/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.converter;

import java.text.MessageFormat;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;

public class FileSizeConverter
implements Converter {
    private static final double KB = 1024.0;
    private static final double MB = 1048576.0;

    public Object getAsObject(FacesContext ctx, UIComponent component, String value) {
        return null;
    }

    public String getAsString(FacesContext ctx, UIComponent component, Object value) {
        if (value instanceof byte[]) {
            int len = ((byte[])value).length;
            return this.convert(len);
        }
        if (value instanceof Number) {
            Double len = ((Number)value).doubleValue();
            return this.convert(len);
        }
        if (value instanceof String) {
            return value.toString();
        }
        return "";
    }

    private String convert(double len) {
        MessageFormat mf = new MessageFormat("{0,number,#.##}");
        Object res = "";
        long d = Math.round(len / 1024.0);
        if (d <= 1L) {
            Object[] objs = new Object[]{len};
            res = mf.format(objs);
            res = (String)res + " B";
        } else if (d > 1L && d < 1000L) {
            Object[] objs = new Object[]{len / 1024.0};
            res = mf.format(objs);
            res = (String)res + " KB";
        } else {
            Object[] objs = new Object[]{len / 1048576.0};
            res = mf.format(objs);
            res = (String)res + " MB";
        }
        return res;
    }
}

