/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.constants;

public enum ModalitaRicercaTransazioni {
    ANDAMENTO_TEMPORALE("intervalloTemporale"),
    RICERCA_LIBERA("ricercaLibera"),
    ESAMINA_ARCHIVIO_ZIP("esaminaArchivioZip"),
    MITTENTE_TOKEN_INFO("mittenteTokenInfo"),
    MITTENTE_SOGGETTO("mittenteSoggetto"),
    MITTENTE_APPLICATIVO("mittenteApplicativo"),
    MITTENTE_IDENTIFICATIVO_AUTENTICATO("mittenteIdentificativoAutenticato"),
    MITTENTE_INDIRIZZO_IP("mittenteIndirizzoIP"),
    ID_APPLICATIVO_AVANZATA("idApplicativo"),
    ID_APPLICATIVO_BASE("idApplicativoBase"),
    ID_MESSAGGIO("idMessaggio"),
    ID_TRANSAZIONE("idTransazione"),
    ID_TOKEN("idToken"),
    LIVE("Live"),
    PURPOSE_ID("purposeId");

    private String value;

    private ModalitaRicercaTransazioni(String ruolo) {
        this.value = ruolo;
    }

    public String toString() {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }

    public static ModalitaRicercaTransazioni getFromString(String v) {
        ModalitaRicercaTransazioni res = null;
        for (ModalitaRicercaTransazioni tmp : ModalitaRicercaTransazioni.values()) {
            if (!tmp.getValue().equals(v)) continue;
            res = tmp;
            break;
        }
        return res;
    }

    public static int getLivello(String modalita) {
        ModalitaRicercaTransazioni modalitaEnum = ModalitaRicercaTransazioni.getFromString(modalita);
        if (modalitaEnum != null) {
            switch (modalitaEnum.ordinal()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    return 1;
                }
                case 8: 
                case 9: {
                    return 2;
                }
            }
            return 1;
        }
        return 1;
    }
}

