/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.cache.CacheAlgorithm;
import org.openspcoop2.utils.transport.http.HttpLibrary;
import org.openspcoop2.web.monitor.core.config.ApplicationInstanceProperties;
import org.slf4j.Logger;

public class ApplicationProperties {
    private static ApplicationProperties applicationProperties = null;
    private ApplicationInstanceProperties reader;

    public static synchronized void initialize(Logger log, String propertiesPath, String localPropertyName, String localPropertiesPath) throws Exception {
        if (applicationProperties == null) {
            applicationProperties = new ApplicationProperties(log, propertiesPath, localPropertyName, localPropertiesPath);
        }
    }

    public static ApplicationProperties getInstance(Logger log) throws UtilsException {
        if (log != null) {
            // empty if block
        }
        if (applicationProperties == null) {
            Class<ApplicationProperties> clazz = ApplicationProperties.class;
            synchronized (ApplicationProperties.class) {
                throw new UtilsException("Properties not initialized");
            }
        }
        return applicationProperties;
    }

    private ApplicationProperties(Logger log, String propertiesPath, String localPropertyName, String localPropertiesPath) throws Exception {
        Properties propertiesReader = new Properties();
        InputStream properties = null;
        try {
            properties = ApplicationProperties.class.getResourceAsStream(propertiesPath);
            if (properties == null) {
                throw new Exception("Properties " + propertiesPath + " not found");
            }
            propertiesReader.load(properties);
            properties.close();
        }
        catch (IOException e) {
            log.error("Riscontrato errore durante la lettura del file '" + propertiesPath + "': " + e.getMessage(), (Throwable)e);
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        this.reader = new ApplicationInstanceProperties(propertiesReader, log, localPropertyName, localPropertiesPath);
    }

    private String getPropertyPrefix(String property) {
        return "Property [" + property + "] ";
    }

    private String getMessageUncorrectValue(String tmp) {
        return "with uncorrect value [" + tmp + "]";
    }

    public Enumeration<?> keys() {
        return this.reader.propertyNames();
    }

    public String readProperty(boolean required, String property) throws UtilsException {
        return this.getProperty(property, required, true);
    }

    public String getProperty(String name, boolean required, boolean convertEnvProperty) throws UtilsException {
        String tmp = null;
        tmp = convertEnvProperty ? this.reader.getValueConvertEnvProperties(name) : this.reader.getValue(name);
        if (tmp == null && required) {
            throw new UtilsException(this.getPropertyPrefix(name) + "not found");
        }
        if (tmp != null) {
            return tmp.trim();
        }
        return null;
    }

    public BooleanNullable readBooleanProperty(boolean required, String property) throws UtilsException {
        String tmp = this.getProperty(property, required, true);
        if (tmp == null && !required) {
            return BooleanNullable.NULL();
        }
        if (!"true".equalsIgnoreCase(tmp) && !"false".equalsIgnoreCase(tmp)) {
            throw new UtilsException(this.getPropertyPrefix(property) + this.getMessageUncorrectValue(tmp) + " (true/value expected)");
        }
        return Boolean.parseBoolean(tmp) ? BooleanNullable.TRUE() : BooleanNullable.FALSE();
    }

    public boolean parse(BooleanNullable b, boolean defaultValue) {
        return b != null && b.getValue() != null ? b.getValue() : defaultValue;
    }

    public Properties readProperties(String prefix) throws UtilsException {
        return this.reader.readPropertiesConvertEnvProperties(prefix);
    }

    public Integer readIntegerProperty(boolean required, String property) throws UtilsException {
        String tmp = this.getProperty(property, required, true);
        if (tmp == null && !required) {
            return null;
        }
        try {
            return Integer.parseInt(tmp);
        }
        catch (Exception e) {
            throw new UtilsException(this.getPropertyPrefix(property) + this.getMessageUncorrectValue(tmp) + " (int value expected)");
        }
    }

    public Long readLongProperty(boolean required, String property) throws UtilsException {
        String tmp = this.getProperty(property, required, true);
        if (tmp == null && !required) {
            return null;
        }
        try {
            return Long.parseLong(tmp);
        }
        catch (Exception e) {
            throw new UtilsException(this.getPropertyPrefix(property) + this.getMessageUncorrectValue(tmp) + " (long value expected)");
        }
    }

    public String getConfigurationDir() throws UtilsException {
        return this.getProperty("confDirectory", true, true);
    }

    public String getProtocolloDefault() throws UtilsException {
        return this.getProperty("protocolloDefault", false, true);
    }

    public File getRepositoryJars() throws UtilsException {
        String tmp = this.getProperty("repositoryJars", false, true);
        if (tmp != null) {
            return new File(tmp);
        }
        return null;
    }

    public boolean isAbilitataCache_datiConfigurazione() throws UtilsException {
        String cacheEnabled = this.getProperty("cache.datiConfigurazione.enable", true, true);
        return "true".equalsIgnoreCase(cacheEnabled);
    }

    public boolean isAbilitataJmxCache_datiConfigurazione() throws UtilsException {
        String cacheEnabled = this.getProperty("cache.datiConfigurazione.jmx.enable", false, true);
        return "true".equalsIgnoreCase(cacheEnabled);
    }

    public boolean isDebugCache_datiConfigurazione() throws UtilsException {
        String cacheEnabled = this.getProperty("cache.datiConfigurazione.debug", false, true);
        return "true".equalsIgnoreCase(cacheEnabled);
    }

    public CacheAlgorithm getAlgoritmoCache_datiConfigurazione() throws UtilsException {
        String cacheV = this.getProperty("cache.datiConfigurazione.algoritmo", false, true);
        if (cacheV != null && StringUtils.isNotEmpty((CharSequence)cacheV)) {
            return CacheAlgorithm.valueOf((String)cacheV.toUpperCase());
        }
        return null;
    }

    public Integer getDimensioneCache_datiConfigurazione() throws UtilsException {
        return this._getIntegerValueCache("cache.datiConfigurazione.dimensione");
    }

    public Integer getItemIdleTimeCache_datiConfigurazione() throws UtilsException {
        return this._getIntegerValueCache("cache.datiConfigurazione.itemIdleTime");
    }

    public Integer getItemLifeSecondCache_datiConfigurazione() throws UtilsException {
        return this._getIntegerValueCache("cache.datiConfigurazione.itemLifeSecond");
    }

    public boolean isAbilitataCache_ricercheConfigurazione() throws UtilsException {
        String cacheEnabled = this.getProperty("cache.ricercheConfigurazione.enable", true, true);
        return "true".equalsIgnoreCase(cacheEnabled);
    }

    public boolean isAbilitataJmxCache_ricercheConfigurazione() throws UtilsException {
        String cacheEnabled = this.getProperty("cache.ricercheConfigurazione.jmx.enable", false, true);
        return "true".equalsIgnoreCase(cacheEnabled);
    }

    public boolean isDebugCache_ricercheConfigurazione() throws UtilsException {
        String cacheEnabled = this.getProperty("cache.ricercheConfigurazione.debug", false, true);
        return "true".equalsIgnoreCase(cacheEnabled);
    }

    public CacheAlgorithm getAlgoritmoCache_ricercheConfigurazione() throws UtilsException {
        String cacheV = this.getProperty("cache.ricercheConfigurazione.algoritmo", false, true);
        if (cacheV != null && StringUtils.isNotEmpty((CharSequence)cacheV)) {
            return CacheAlgorithm.valueOf((String)cacheV.toUpperCase());
        }
        return null;
    }

    public Integer getDimensioneCache_ricercheConfigurazione() throws UtilsException {
        return this._getIntegerValueCache("cache.ricercheConfigurazione.dimensione");
    }

    public Integer getItemIdleTimeCache_ricercheConfigurazione() throws UtilsException {
        return this._getIntegerValueCache("cache.ricercheConfigurazione.itemIdleTime");
    }

    public Integer getItemLifeSecondCache_ricercheConfigurazione() throws UtilsException {
        return this._getIntegerValueCache("cache.ricercheConfigurazione.itemLifeSecond");
    }

    private Integer _getIntegerValueCache(String name) throws UtilsException {
        Integer i;
        String cacheV = this.getProperty(name, false, true);
        if (cacheV != null && StringUtils.isNotEmpty((CharSequence)cacheV) && (i = Integer.valueOf(cacheV)) > 0) {
            return i;
        }
        return null;
    }

    public String getJmxPdD_externalConfiguration() throws UtilsException {
        return this.getProperty("configurazioni.risorseJmxPdd.configurazioneNodiRun", false, true);
    }

    public String getJmxPdD_backwardCompatibilityPrefix() {
        return "configurazioni.risorseJmxPdd.";
    }

    public Properties getJmxPdD_backwardCompatibilityProperties() throws UtilsException {
        String prefix = this.getJmxPdD_backwardCompatibilityPrefix();
        Properties p = new Properties();
        Enumeration en = this.reader.propertyNames();
        while (en.hasMoreElements()) {
            String key;
            Object object = en.nextElement();
            if (!(object instanceof String) || !(key = (String)object).contains(prefix)) continue;
            String newKey = key.replace(prefix, "");
            p.put(newKey, this.reader.getValueConvertEnvProperties(key));
        }
        return p;
    }

    public boolean isPluginsEnabled() throws UtilsException {
        String cacheEnabled = this.getProperty("plugins.enabled", true, true);
        return "true".equalsIgnoreCase(cacheEnabled);
    }

    public Integer getPluginsSeconds() throws UtilsException {
        Integer i;
        String cacheV = this.getProperty("plugins.seconds", false, true);
        if (cacheV != null && StringUtils.isNotEmpty((CharSequence)cacheV) && (i = Integer.valueOf(cacheV)) > 0) {
            return i;
        }
        return 300;
    }

    public int getTransazioniDettaglioVisualizzazioneMessaggiThreshold() throws UtilsException {
        return Integer.valueOf(this.getProperty("transazioni.dettaglio.visualizzazioneMessaggi.threshold", true, true));
    }

    public boolean isSecurityLoadBouncyCastle() throws UtilsException {
        BooleanNullable b = this.readBooleanProperty(false, "security.addBouncyCastleProvider");
        return this.parse(b, false);
    }

    public String getEnvMapConfig() throws UtilsException {
        return this.readProperty(false, "env.map.config");
    }

    public boolean isEnvMapConfigRequired() throws UtilsException {
        BooleanNullable b = this.readBooleanProperty(false, "env.map.required");
        return this.parse(b, false);
    }

    public String getHSMConfigurazione() throws UtilsException {
        return this.readProperty(false, "hsm.config");
    }

    public boolean isHSMRequired() throws UtilsException {
        BooleanNullable b = this.readBooleanProperty(false, "hsm.required");
        return this.parse(b, false);
    }

    public boolean isHSMKeyPasswordConfigurable() throws UtilsException {
        BooleanNullable b = this.readBooleanProperty(false, "hsm.keyPassword");
        return this.parse(b, false);
    }

    public String getBYOKConfig() throws UtilsException {
        return this.readProperty(false, "byok.config");
    }

    public boolean isBYOKConfigRequired() throws UtilsException {
        BooleanNullable b = this.readBooleanProperty(false, "byok.required");
        return this.parse(b, false);
    }

    public String getBYOKEnvSecretsConfig() throws UtilsException {
        return this.readProperty(false, "byok.env.secrets.config");
    }

    public boolean isBYOKEnvSecretsConfigRequired() throws UtilsException {
        BooleanNullable b = this.readBooleanProperty(false, "byok.env.secrets.required");
        return this.parse(b, false);
    }

    public boolean isJdbcCloseConnectionCheckIsClosed() throws UtilsException {
        BooleanNullable b = this.readBooleanProperty(true, "jdbc.closeConnection.checkIsClosed");
        return this.parse(b, true);
    }

    public boolean isJdbcCloseConnectionCheckAutocommit() throws UtilsException {
        BooleanNullable b = this.readBooleanProperty(true, "jdbc.closeConnection.checkAutocommit");
        return this.parse(b, true);
    }

    public HttpLibrary getConnettoriRemoteAccessUtilityLibrary() throws UtilsException {
        String lib = this.readProperty(false, "connettori.remoteAccessUtility.library");
        if (lib != null) {
            lib = lib.trim();
            return HttpLibrary.getHttpLibrary((String)lib);
        }
        return null;
    }

    public boolean isLoginApplication() throws UtilsException {
        return "true".equalsIgnoreCase(this.getProperty("login.application", true, true));
    }

    public String getLoginTipo() throws UtilsException {
        return this.getProperty("login.tipo", true, true);
    }
}

