/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.bean;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.faces.event.ActionEvent;
import org.richfaces.model.UploadItem;
import org.springframework.http.MediaType;

public abstract class BaseFileUploadBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, UploadItem> mapElementiRicevuti = null;
    private Map<String, String> mapChiaviElementi = new HashMap<String, String>();
    private int numeroFile = 1;

    protected BaseFileUploadBean() {
        this.mapElementiRicevuti = new HashMap<String, UploadItem>();
    }

    public void setNumeroFile(int numeroFile) {
        this.numeroFile = numeroFile;
    }

    public void clear() {
        this.mapChiaviElementi.clear();
        this.mapElementiRicevuti.clear();
    }

    public int getNumeroFile() {
        return this.numeroFile - this.mapElementiRicevuti.size();
    }

    public boolean checkAcceptedType(String contentType) {
        if (contentType == null) {
            return false;
        }
        return Arrays.asList(this.getAcceptedTypes()).contains(MediaType.parseMediaType((String)contentType));
    }

    public abstract void startUploadsListener(ActionEvent var1);

    public abstract void stopUploadsListener(ActionEvent var1);

    public abstract void uploadErrorListener(ActionEvent var1);

    public abstract void deleteCompleteOkListener(ActionEvent var1);

    public abstract void deleteCompleteFailListener(ActionEvent var1);

    public Map<String, UploadItem> getMapElementiRicevuti() {
        return this.mapElementiRicevuti;
    }

    public void setMapElementiRicevuti(Map<String, UploadItem> mapElementiRicevuti) {
        this.mapElementiRicevuti = mapElementiRicevuti;
    }

    public Map<String, String> getMapChiaviElementi() {
        return this.mapChiaviElementi;
    }

    public void setMapChiaviElementi(Map<String, String> mapChiaviElementi) {
        this.mapChiaviElementi = mapChiaviElementi;
    }

    public boolean isVisualizzaComandiEliminaFile() {
        return !this.getMapElementiRicevuti().isEmpty();
    }

    public void setVisualizzaComandiEliminaFile(boolean visualizzaComandiEliminaFile) {
    }

    public abstract MediaType[] getAcceptedTypes();
}

