/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config.vault.cli;

import java.io.File;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.utils.certificate.byok.BYOKManager;

public class VaultUpdateConfig {
    public static final String SECURITY_IN = "-sec_in";
    public static final String SECURITY_OUT = "-sec_out";
    public static final String PLAIN_IN = "-plain_in";
    public static final String PLAIN_OUT = "-plain_out";
    public static final String REPORT = "-report";
    private static final String UNKNOW_OPTION = "(unknown option '";
    private boolean inSecurityMode = false;
    private boolean inPlainMode = false;
    private String inId = null;
    private boolean outSecurityMode = false;
    private boolean outPlainMode = false;
    private String outId = null;
    private String reportPath = null;

    public static String getUsage() {
        return "-sec_in|-plain_in[=id] -sec_out|-plain_out)[=id] [-report=path]";
    }

    public VaultUpdateConfig(String[] args, String utilizzoErrato) throws CoreException {
        if (args.length < 2 || args[0] == null || args[1] == null) {
            throw new CoreException(utilizzoErrato);
        }
        this.parseFirstArgument(args, utilizzoErrato);
        this.parseSecondArgument(args, utilizzoErrato);
        if (args.length > 2 && args[2] != null) {
            this.parseThirdArgument(args, utilizzoErrato);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseFirstArgument(String[] args, String utilizzoErrato) throws CoreException {
        if (!args[0].contains("=")) {
            if (!PLAIN_IN.equals(args[0])) throw new CoreException("(= not found in first param '" + args[0] + "') " + utilizzoErrato);
            this.inPlainMode = true;
            return;
        } else {
            if (!args[0].startsWith("-sec_in=") || args[0].length() <= "-sec_in=".length()) throw new CoreException(UNKNOW_OPTION + args[0] + "') " + utilizzoErrato);
            this.inSecurityMode = true;
            this.inId = args[0].substring("-sec_in=".length());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseSecondArgument(String[] args, String utilizzoErrato) throws CoreException {
        if (!args[1].contains("=")) {
            if (!PLAIN_OUT.equals(args[1])) throw new CoreException("(= not found in second param '" + args[1] + "') " + utilizzoErrato);
            this.outPlainMode = true;
            return;
        } else {
            if (!args[1].startsWith("-sec_out=") || args[1].length() <= "-sec_out=".length()) throw new CoreException(UNKNOW_OPTION + args[1] + "') " + utilizzoErrato);
            this.outSecurityMode = true;
            this.outId = args[1].substring("-sec_out=".length());
        }
    }

    private void parseThirdArgument(String[] args, String utilizzoErrato) throws CoreException {
        if (!args[2].contains("=")) {
            throw new CoreException("(= not found in third param '" + args[2] + "') " + utilizzoErrato);
        }
        if (!args[2].startsWith("-report=") || args[2].length() <= "-report=".length()) {
            throw new CoreException(UNKNOW_OPTION + args[2] + "') " + utilizzoErrato);
        }
        this.reportPath = args[2].substring("-report=".length());
        File fFilePath = new File(this.reportPath);
        String prefix = "(File '" + fFilePath.getAbsolutePath() + "' ";
        if (fFilePath.exists()) {
            throw new CoreException(prefix + "already exists) " + utilizzoErrato);
        }
    }

    public boolean isInSecurityMode() {
        return this.inSecurityMode;
    }

    public boolean isInPlainMode() {
        return this.inPlainMode;
    }

    public String getInId() {
        return this.inId;
    }

    public boolean isOutSecurityMode() {
        return this.outSecurityMode;
    }

    public boolean isOutPlainMode() {
        return this.outPlainMode;
    }

    public String getOutId() {
        return this.outId;
    }

    public String getReportPath() {
        return this.reportPath;
    }

    public void validate(BYOKManager byokManager) throws CoreException {
        if (this.inSecurityMode && !byokManager.existsSecurityEngineByType(this.inId)) {
            throw new CoreException("Security policy '" + this.inId + "' not found");
        }
        if (this.outSecurityMode && !byokManager.existsSecurityEngineByType(this.outId)) {
            throw new CoreException("Security policy '" + this.outId + "' not found");
        }
    }
}

