/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config.vault.cli;

import java.io.InputStream;
import java.util.Properties;
import org.openspcoop2.core.commons.CoreException;

public class VaultDatabaseProperties {
    private static VaultDatabaseProperties staticInstance = null;
    private static final String PROPERTIES_FILE = "/govway_vault.cli.database.properties";
    private String tipoDatabase = null;
    private String driver = null;
    private String connectionUrl = null;
    private String username = null;
    private String password = null;

    private static synchronized void init() throws CoreException {
        if (staticInstance == null) {
            staticInstance = new VaultDatabaseProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VaultDatabaseProperties getInstance() throws CoreException {
        if (staticInstance != null) return staticInstance;
        Class<VaultDatabaseProperties> clazz = VaultDatabaseProperties.class;
        synchronized (VaultDatabaseProperties.class) {
            VaultDatabaseProperties.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return staticInstance;
        }
    }

    private VaultDatabaseProperties() throws CoreException {
        Properties props = new Properties();
        try {
            InputStream is = VaultDatabaseProperties.class.getResourceAsStream(PROPERTIES_FILE);
            props.load(is);
        }
        catch (Exception e) {
            throw new CoreException("Errore durante l'init delle properties", (Throwable)e);
        }
        this.tipoDatabase = this.getProperty(props, "tipoDatabase", true);
        this.driver = this.getProperty(props, "driver", true);
        this.connectionUrl = this.getProperty(props, "connection-url", true);
        this.username = this.getProperty(props, "username", true);
        this.password = this.getProperty(props, "password", true);
    }

    private String getProperty(Properties props, String name, boolean required) throws CoreException {
        String tmp = props.getProperty(name);
        if (tmp == null) {
            if (required) {
                throw new CoreException("Property '" + name + "' not found");
            }
            return null;
        }
        return tmp.trim();
    }

    public String getTipoDatabase() {
        return this.tipoDatabase;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

