/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.validator;

import java.util.Vector;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import org.apache.log4j.Logger;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.protocol.engine.Configurazione;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.validator.IValidazioneConSchema;

public class ValidazioneConSchema {
    private Vector<Eccezione> erroriValidazione;
    private Vector<Eccezione> erroriProcessamento;
    private OpenSPCoop2Message message;
    private SOAPElement busta;
    private SOAPBody soapBody;
    private boolean isErroreProcessamento = false;
    private boolean isErroreIntestazione = false;
    private boolean validazioneManifestAttachments = false;
    private IProtocolFactory protocolFactory;

    public ValidazioneConSchema(OpenSPCoop2Message message, SOAPElement header, SOAPBody soapBody, boolean isErroreProcessamento, boolean isErroreIntestazione, boolean validazioneManifestAttachments, IProtocolFactory protocolFactory) {
        this(message, header, soapBody, isErroreProcessamento, isErroreIntestazione, validazioneManifestAttachments, Configurazione.getLibraryLog(), protocolFactory);
    }

    public ValidazioneConSchema(OpenSPCoop2Message message, SOAPElement header, SOAPBody soapBody, boolean isErroreProcessamento, boolean isErroreIntestazione, boolean validazioneManifestAttachments, Logger aLog, IProtocolFactory protocolFactory) {
        this.message = message;
        this.busta = header;
        this.soapBody = soapBody;
        this.isErroreProcessamento = isErroreProcessamento;
        this.isErroreIntestazione = isErroreIntestazione;
        this.validazioneManifestAttachments = validazioneManifestAttachments;
        this.protocolFactory = protocolFactory;
    }

    public IProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    public Vector<Eccezione> getEccezioniValidazione() {
        return this.erroriValidazione;
    }

    public Vector<Eccezione> getEccezioniProcessamento() {
        return this.erroriProcessamento;
    }

    public void valida(boolean isMessaggioConAttachments) throws Exception {
        IValidazioneConSchema validazione = this.protocolFactory.createValidazioneConSchema();
        validazione.valida(this.message, this.busta, this.soapBody, this.isErroreProcessamento, this.isErroreIntestazione, isMessaggioConAttachments, this.validazioneManifestAttachments);
        this.erroriProcessamento = validazione.getEccezioniProcessamento();
        this.erroriValidazione = validazione.getEccezioniValidazione();
    }
}

