/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.mapping;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.constants.IDService;
import org.openspcoop2.protocol.engine.mapping.ModalitaIdentificazione;
import org.openspcoop2.protocol.manifest.Openspcoop2;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;

public class MappingProperties {
    private Logger log;
    private Properties propertiesReader;

    protected MappingProperties(String fileNameProperties, InputStream properties, Logger log) throws IOException {
        this.log = log;
        this.propertiesReader = new Properties();
        try {
            this.propertiesReader.load(properties);
            properties.close();
        }
        catch (IOException e) {
            this.log.error((Object)("Riscontrato errore durante la lettura del file '" + fileNameProperties + "': \n\n" + e.getMessage()));
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw e;
        }
    }

    public String getUrlWithoutContext(String protocol, String urlWithContext, IDService idService) throws ProtocolException {
        String prefixProtocol;
        IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocol);
        Openspcoop2 manifestProtocol = pf.getManifest();
        String urlWithoutContext = null;
        String paContext = null;
        if (IDService.PORTA_APPLICATIVA_SOAP.equals(idService)) {
            paContext = "/PA";
        } else if (IDService.PORTA_APPLICATIVA_API.equals(idService)) {
            paContext = "/API/PA";
        } else {
            throw new ProtocolException("Service [" + idService + "] non gestito tramite UrlMapping");
        }
        for (int i = 0; i < manifestProtocol.getWeb().sizeContextList(); ++i) {
            String context = manifestProtocol.getWeb().getContext(i);
            String prefixProtocol2 = context + paContext;
            if (!urlWithContext.contains(prefixProtocol2)) continue;
            if (urlWithContext.endsWith(prefixProtocol2)) {
                urlWithoutContext = "";
                break;
            }
            int offset = urlWithContext.indexOf(prefixProtocol2);
            urlWithoutContext = urlWithContext.substring(offset + prefixProtocol2.length(), urlWithContext.length());
            break;
        }
        if (urlWithoutContext == null && manifestProtocol.getWeb().getEmptyContext() != null && manifestProtocol.getWeb().getEmptyContext().getEnabled() && urlWithContext.contains(prefixProtocol = paContext)) {
            if (urlWithContext.endsWith(prefixProtocol)) {
                urlWithoutContext = "";
            } else {
                int offset = urlWithContext.indexOf(prefixProtocol);
                urlWithoutContext = urlWithContext.substring(offset + prefixProtocol.length(), urlWithContext.length());
            }
        }
        if (urlWithoutContext == null) {
            throw new ProtocolException("Identificazione URL senza contesto applicazione e protocollo non riuscita (protocollo [" + protocol + "], url [" + urlWithContext + "])");
        }
        return urlWithoutContext;
    }

    protected String getMappingName(String protocol, String urlWithContext, IDService idService) throws ProtocolException {
        String prefix = protocol + ".pa.";
        String suffix = ".url";
        String urlWithoutContext = this.getUrlWithoutContext(protocol, urlWithContext, idService);
        Enumeration<Object> keys = this.propertiesReader.keys();
        while (keys.hasMoreElements()) {
            String mapping;
            String tmpurl;
            String propertyName = (String)keys.nextElement();
            if (!propertyName.startsWith(prefix) || !propertyName.endsWith(suffix) || (tmpurl = this.propertiesReader.getProperty(propertyName)) == null) continue;
            if (!(tmpurl = tmpurl.trim()).startsWith("/") && !tmpurl.equals("*")) {
                tmpurl = "/" + tmpurl;
            }
            boolean match = false;
            match = tmpurl.endsWith("*") ? urlWithoutContext.startsWith(tmpurl.substring(0, tmpurl.length() - 1)) : urlWithoutContext.equals(tmpurl);
            if (!match || (mapping = propertyName.substring(prefix.length(), propertyName.length() - suffix.length())) == null || mapping.equals("")) continue;
            return mapping;
        }
        throw new ProtocolException("Non risulta configurata nessuna configurazione di mapping nel protocollo [" + protocol + "] per la url [" + urlWithContext + "]");
    }

    protected ModalitaIdentificazione getModalita(String protocol, String mappingName, String attribute) throws ProtocolException {
        String propertyName = protocol + ".pa." + mappingName + "." + attribute;
        String modalita = this.propertiesReader.getProperty(propertyName);
        if (modalita == null) {
            throw new ProtocolException("Nessuna modalita configurata per la proprieta' [" + propertyName + "].");
        }
        modalita = modalita.trim();
        ModalitaIdentificazione m = ModalitaIdentificazione.toEnumConstant(modalita);
        if (m == null) {
            throw new ProtocolException("La modalita' [" + modalita + "] configurata per la proprieta [" + propertyName + "] non e' supportata.");
        }
        return m;
    }

    protected String getValue(String protocol, String mappingName, String attribute) {
        String propertyName = protocol + ".pa." + mappingName + "." + attribute + ".value";
        String value = this.propertiesReader.getProperty(propertyName);
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    protected String getPattern(String protocol, String mappingName, String attribute) {
        String propertyName = protocol + ".pa." + mappingName + "." + attribute + ".pattern";
        String value = this.propertiesReader.getProperty(propertyName);
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    protected String getName(String protocol, String mappingName, String attribute) {
        String propertyName = protocol + ".pa." + mappingName + "." + attribute + ".name";
        String value = this.propertiesReader.getProperty(propertyName);
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    protected String getAnonymous(String protocol, String mappingName, String attribute) {
        String propertyName = protocol + ".pa." + mappingName + "." + attribute + ".anonymous";
        String value = this.propertiesReader.getProperty(propertyName);
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    protected Boolean isForceWsdlBased(String protocol, String mappingName, String attribute) {
        String propertyName = protocol + ".pa." + mappingName + "." + attribute + ".forceWsdlBased";
        String value = this.propertiesReader.getProperty(propertyName);
        if (value != null) {
            value = value.trim();
            return Boolean.parseBoolean(value);
        }
        return null;
    }
}

