/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.driver;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.openspcoop2.protocol.engine.Configurazione;
import org.openspcoop2.protocol.engine.driver.repository.IGestoreRepository;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.StateMessage;

public class RollbackRepositoryBuste
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger log = null;
    private IState state;
    private String idBusta;
    private IGestoreRepository gestoreRepositoryBuste;

    public RollbackRepositoryBuste(String id, IState state, boolean oneWay11) {
        this(id, state, Configurazione.getLibraryLog(), oneWay11);
    }

    public RollbackRepositoryBuste(String id, IState state, Logger aLog, boolean oneWay11) {
        this.idBusta = id;
        this.state = state;
        this.gestoreRepositoryBuste = Configurazione.getGestoreRepositoryBuste();
        this.log = aLog != null ? aLog : Logger.getLogger((String)RollbackRepositoryBuste.class.getName());
    }

    public void rollbackBustaIntoOutBox() throws ProtocolException {
        this.rollback("OUTBOX", true);
    }

    public void rollbackBustaIntoOutBox(boolean rollbackAccessoHistory) throws ProtocolException {
        this.rollback("OUTBOX", rollbackAccessoHistory);
    }

    public void rollbackBustaIntoInBox() throws ProtocolException {
        this.rollback("INBOX", true);
    }

    public void rollbackBustaIntoInBox(boolean rollbackAccessoHistory) throws ProtocolException {
        this.rollback("INBOX", rollbackAccessoHistory);
    }

    public void rollback(String tipoBusta, boolean rollbackAccessoHistory) throws ProtocolException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        if (connectionDB != null) {
            Statement pstmtUpdateHistory = null;
            PreparedStatement pstmtUpdateProfilo = null;
            Statement pstmtUpdatePdd = null;
            try {
                if (rollbackAccessoHistory) {
                    StringBuffer queryUpdateHistory = new StringBuffer();
                    queryUpdateHistory.append("UPDATE ");
                    queryUpdateHistory.append("REPOSITORY_BUSTE");
                    queryUpdateHistory.append(" SET ");
                    queryUpdateHistory.append(this.gestoreRepositoryBuste.createSQLSet_History(false));
                    queryUpdateHistory.append(" WHERE ID_MESSAGGIO = ? AND TIPO=?");
                    pstmtUpdateHistory = connectionDB.prepareStatement(queryUpdateHistory.toString());
                    pstmtUpdateHistory.setString(1, this.idBusta);
                    pstmtUpdateHistory.setString(2, tipoBusta);
                    stateMSG.getPreparedStatement().put("RollbackGeneraleHISTORY_" + tipoBusta + "_" + this.idBusta, (PreparedStatement)pstmtUpdateHistory);
                }
                StringBuffer queryUpdateProfilo = new StringBuffer();
                queryUpdateProfilo.append("UPDATE ");
                queryUpdateProfilo.append("REPOSITORY_BUSTE");
                queryUpdateProfilo.append(" SET ");
                queryUpdateProfilo.append(this.gestoreRepositoryBuste.createSQLSet_ProfiloCollaborazione(false));
                queryUpdateProfilo.append(" WHERE ID_MESSAGGIO = ? AND TIPO=?");
                pstmtUpdateProfilo = connectionDB.prepareStatement(queryUpdateProfilo.toString());
                pstmtUpdateProfilo.setString(1, this.idBusta);
                pstmtUpdateProfilo.setString(2, tipoBusta);
                stateMSG.getPreparedStatement().put("RollbackGeneralePROFILO_" + tipoBusta + "_" + this.idBusta, pstmtUpdateProfilo);
                StringBuffer queryUpdatePdd = new StringBuffer();
                queryUpdatePdd.append("UPDATE ");
                queryUpdatePdd.append("REPOSITORY_BUSTE");
                queryUpdatePdd.append(" SET ");
                queryUpdatePdd.append(this.gestoreRepositoryBuste.createSQLSet_PdD(false));
                queryUpdatePdd.append(" WHERE ID_MESSAGGIO = ? AND TIPO=?");
                pstmtUpdatePdd = connectionDB.prepareStatement(queryUpdatePdd.toString());
                pstmtUpdatePdd.setString(1, this.idBusta);
                pstmtUpdatePdd.setString(2, tipoBusta);
                stateMSG.getPreparedStatement().put("RollbackGeneralePDD_" + tipoBusta + "_" + this.idBusta, (PreparedStatement)pstmtUpdatePdd);
            }
            catch (Exception e) {
                String errorMsg = "ROLLBACK_BUSTE, Errore " + tipoBusta + "/" + this.idBusta + ": " + e.getMessage();
                this.log.info((Object)errorMsg, (Throwable)e);
                try {
                    if (pstmtUpdateHistory != null) {
                        pstmtUpdateHistory.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtUpdateProfilo != null) {
                        pstmtUpdateProfilo.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtUpdatePdd != null) {
                        pstmtUpdatePdd.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
        this.log.debug((Object)("Rollback(" + tipoBusta + "/" + this.idBusta + ") non effettuato, connessione is null"));
    }

    public void clearAccessiIntoInBox(boolean history, boolean profilo, boolean pdd) throws ProtocolException {
        this.clearAccessi("INBOX", history, profilo, pdd);
    }

    public void clearAccessiIntoOutBox(boolean history, boolean profilo, boolean pdd) throws ProtocolException {
        this.clearAccessi("OUTBOX", history, profilo, pdd);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void clearAccessi(String tipoBusta, boolean history, boolean profilo, boolean pdd) throws ProtocolException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        if (connectionDB != null) {
            Statement pstmtUpdateHistory = null;
            Statement pstmtUpdateProfilo = null;
            Statement pstmtUpdatePdd = null;
            try {
                if (!(history || profilo || pdd)) {
                    return;
                }
                if (history) {
                    StringBuffer queryUpdateHistory = new StringBuffer();
                    queryUpdateHistory.append("UPDATE ");
                    queryUpdateHistory.append("REPOSITORY_BUSTE");
                    queryUpdateHistory.append(" SET ");
                    queryUpdateHistory.append(this.gestoreRepositoryBuste.createSQLSet_History(false));
                    queryUpdateHistory.append(" WHERE ID_MESSAGGIO = ? AND TIPO=?");
                    pstmtUpdateHistory = connectionDB.prepareStatement(queryUpdateHistory.toString());
                    pstmtUpdateHistory.setString(1, this.idBusta);
                    pstmtUpdateHistory.setString(2, tipoBusta);
                    stateMSG.getPreparedStatement().put("ClearAccessiHISTORY_" + tipoBusta + "_" + this.idBusta, (PreparedStatement)pstmtUpdateHistory);
                }
                if (profilo) {
                    StringBuffer queryUpdateProfilo = new StringBuffer();
                    queryUpdateProfilo.append("UPDATE ");
                    queryUpdateProfilo.append("REPOSITORY_BUSTE");
                    queryUpdateProfilo.append(" SET ");
                    queryUpdateProfilo.append(this.gestoreRepositoryBuste.createSQLSet_ProfiloCollaborazione(false));
                    queryUpdateProfilo.append(" WHERE ID_MESSAGGIO = ? AND TIPO=?");
                    pstmtUpdateProfilo = connectionDB.prepareStatement(queryUpdateProfilo.toString());
                    pstmtUpdateProfilo.setString(1, this.idBusta);
                    pstmtUpdateProfilo.setString(2, tipoBusta);
                    stateMSG.getPreparedStatement().put("ClearAccessiPROFILO_" + tipoBusta + "_" + this.idBusta, (PreparedStatement)pstmtUpdateProfilo);
                }
                if (!pdd) return;
                StringBuffer queryUpdatePdd = new StringBuffer();
                queryUpdatePdd.append("UPDATE ");
                queryUpdatePdd.append("REPOSITORY_BUSTE");
                queryUpdatePdd.append(" SET ");
                queryUpdatePdd.append(this.gestoreRepositoryBuste.createSQLSet_PdD(false));
                queryUpdatePdd.append(" WHERE ID_MESSAGGIO = ? AND TIPO=?");
                pstmtUpdatePdd = connectionDB.prepareStatement(queryUpdatePdd.toString());
                pstmtUpdatePdd.setString(1, this.idBusta);
                pstmtUpdatePdd.setString(2, tipoBusta);
                stateMSG.getPreparedStatement().put("ClearAccessiPDD_" + tipoBusta + "_" + this.idBusta, (PreparedStatement)pstmtUpdatePdd);
                return;
            }
            catch (Exception e) {
                String errorMsg = "ROLLBACK_BUSTE, setAccessi Errore " + tipoBusta + "/" + this.idBusta + ": " + e.getMessage();
                this.log.info((Object)errorMsg, (Throwable)e);
                try {
                    if (pstmtUpdateHistory != null) {
                        pstmtUpdateHistory.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtUpdateProfilo != null) {
                        pstmtUpdateProfilo.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtUpdatePdd == null) throw new ProtocolException(errorMsg, (Throwable)e);
                    pstmtUpdatePdd.close();
                    throw new ProtocolException(errorMsg, (Throwable)e);
                }
                catch (Exception er) {
                    // empty catch block
                }
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
        this.log.debug((Object)("clearAccessi(" + tipoBusta + "/" + this.idBusta + ") non effettuato, connessione is null"));
    }
}

