/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.driver;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.protocol.engine.Configurazione;
import org.openspcoop2.protocol.engine.LetturaParametriBusta;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.engine.driver.Riscontri;
import org.openspcoop2.protocol.engine.driver.repository.IGestoreRepository;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Integrazione;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.Riscontro;
import org.openspcoop2.protocol.sdk.Trasmissione;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ContestoCodificaEccezione;
import org.openspcoop2.protocol.sdk.constants.Inoltro;
import org.openspcoop2.protocol.sdk.constants.LivelloRilevanza;
import org.openspcoop2.protocol.sdk.constants.TipoOraRegistrazione;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.protocol.sdk.state.StatefulMessage;
import org.openspcoop2.protocol.sdk.state.StatelessMessage;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class RepositoryBuste {
    private Logger log = null;
    private IState state;
    private boolean isRichiesta = true;
    private IGestoreRepository gestoreRepositoryBuste;
    private IProtocolFactory protocolFactory;

    public boolean isRichiesta() {
        return this.isRichiesta;
    }

    public void setRichiesta(boolean isRichiesta) {
        this.isRichiesta = isRichiesta;
    }

    public RepositoryBuste(IState state, boolean isRichiesta, IProtocolFactory protocolFactory) {
        this(state, Configurazione.getLibraryLog(), isRichiesta, protocolFactory);
    }

    public RepositoryBuste(IState state, Logger alog, IProtocolFactory protocolFactory) {
        this(state, alog, true, protocolFactory);
    }

    public RepositoryBuste(IState state, IProtocolFactory protocolFactory) {
        this(state, Configurazione.getLibraryLog(), true, protocolFactory);
    }

    public RepositoryBuste(IState state, Logger alog, boolean isRichiesta, IProtocolFactory protocolFactory) {
        this.state = state;
        this.gestoreRepositoryBuste = Configurazione.getGestoreRepositoryBuste();
        this.log = alog != null ? alog : Logger.getLogger((String)RepositoryBuste.class.getName());
        this.isRichiesta = isRichiesta;
        this.protocolFactory = protocolFactory;
    }

    public void updateState(IState state) {
        this.state = state;
    }

    public void registraBustaIntoOutBox(Busta busta, long scadenza) throws ProtocolException {
        this.registraBusta(busta, "OUTBOX", null, scadenza);
    }

    public void registraBustaIntoOutBox(Busta busta, Vector<Eccezione> errors, long scadenza) throws ProtocolException {
        this.registraBusta(busta, "OUTBOX", errors, scadenza);
    }

    public void registraBustaIntoOutBox(String id, IDSoggetto soggettoFruitore, IDServizio servizio, long scadenza, org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione profiloCollaborazione, boolean confermaRicezione, Inoltro inoltro) throws ProtocolException {
        Busta busta = new Busta(this.protocolFactory.getProtocol());
        busta.setID(id);
        busta.setTipoMittente(soggettoFruitore.getTipo());
        busta.setMittente(soggettoFruitore.getNome());
        busta.setIdentificativoPortaMittente(soggettoFruitore.getCodicePorta());
        busta.setTipoDestinatario(servizio.getSoggettoErogatore().getTipo());
        busta.setDestinatario(servizio.getSoggettoErogatore().getNome());
        busta.setIdentificativoPortaDestinatario(servizio.getSoggettoErogatore().getCodicePorta());
        busta.setTipoServizio(servizio.getTipoServizio());
        busta.setServizio(servizio.getServizio());
        busta.setVersioneServizio(servizio.getVersioneServizio());
        busta.setAzione(servizio.getAzione());
        busta.setProfiloDiCollaborazione(profiloCollaborazione);
        busta.setConfermaRicezione(confermaRicezione);
        busta.setInoltro(inoltro, this.protocolFactory.createTraduttore().toString(inoltro));
        this.registraBusta(busta, "OUTBOX", null, scadenza);
    }

    public void aggiornaProprietaBustaIntoOutBox(Hashtable<String, String> properties, String idBusta) throws ProtocolException {
        this.aggiornaProprietaBusta(properties, idBusta, "OUTBOX");
    }

    public void aggiornaDuplicatiIntoOutBox(String id) throws ProtocolException {
        this.aggiornaDuplicati(id, "OUTBOX");
    }

    public void aggiornaInfoIntegrazioneIntoOutBox(String id, Integrazione infoIntegrazione) throws ProtocolException {
        this.aggiornaInfoIntegrazione(id, "OUTBOX", infoIntegrazione);
    }

    public void aggiornaInfoIntegrazioneIntoOutBox_ServizioApplicativo(String id, String servizioApplicativo) throws ProtocolException {
        this.aggiornaInfoIntegrazione_ServizioApplicativo(id, "OUTBOX", servizioApplicativo);
    }

    public void aggiornaInfoIntegrazioneIntoOutBox_Scenario(String id, String scenario) throws ProtocolException {
        this.aggiornaInfoIntegrazione_Scenario(id, "OUTBOX", scenario);
    }

    public void aggiornaBustaIntoOutBox(Busta busta, long scadenza) throws ProtocolException {
        this.aggiornaBusta(busta, "OUTBOX", scadenza, null);
    }

    public void aggiornaBustaIntoOutBox(Busta busta, long scadenza, Vector<Eccezione> errors) throws ProtocolException {
        this.aggiornaBusta(busta, "OUTBOX", scadenza, errors);
    }

    public void aggiornaBustaIntoOutBox(String id, IDSoggetto soggettoFruitore, IDServizio servizio, long scadenza, org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione profiloCollaborazione, boolean confermaRicezione, Inoltro inoltro) throws ProtocolException {
        Busta bustaDaAggiornare = new Busta(this.protocolFactory.getProtocol());
        bustaDaAggiornare.setID(id);
        bustaDaAggiornare.setTipoMittente(soggettoFruitore.getTipo());
        bustaDaAggiornare.setMittente(soggettoFruitore.getNome());
        bustaDaAggiornare.setIdentificativoPortaMittente(soggettoFruitore.getCodicePorta());
        bustaDaAggiornare.setTipoDestinatario(servizio.getSoggettoErogatore().getTipo());
        bustaDaAggiornare.setDestinatario(servizio.getSoggettoErogatore().getNome());
        bustaDaAggiornare.setIdentificativoPortaDestinatario(servizio.getSoggettoErogatore().getCodicePorta());
        bustaDaAggiornare.setTipoServizio(servizio.getTipoServizio());
        bustaDaAggiornare.setServizio(servizio.getServizio());
        bustaDaAggiornare.setVersioneServizio(servizio.getVersioneServizio());
        bustaDaAggiornare.setAzione(servizio.getAzione());
        bustaDaAggiornare.setProfiloDiCollaborazione(profiloCollaborazione);
        bustaDaAggiornare.setConfermaRicezione(confermaRicezione);
        bustaDaAggiornare.setInoltro(inoltro, this.protocolFactory.createTraduttore().toString(inoltro));
        this.aggiornaBusta(bustaDaAggiornare, "OUTBOX", scadenza, null);
    }

    public void aggiornaCollaborazioneIntoOutBox(String id, String collaborazione) throws ProtocolException {
        this.aggiornaCollaborazione(id, "OUTBOX", collaborazione);
    }

    public void aggiornaSequenzaIntoOutBox(String id, long sequenza) throws ProtocolException {
        this.aggiornaSequenza(id, "OUTBOX", sequenza);
    }

    public boolean isRegistrataIntoOutBox(String id) throws ProtocolException {
        return this.isRegistrata(id, "OUTBOX");
    }

    public Busta getBustaFromOutBox(String id) throws ProtocolException {
        return this.getBusta(id, "OUTBOX");
    }

    public Vector<Eccezione> getErrorsFromOutBox(String id, IProtocolFactory protocolFactory) throws ProtocolException {
        return this.getErrors(id, "OUTBOX");
    }

    public Busta getSomeValuesFromOutBox(String id, LetturaParametriBusta parametri) throws ProtocolException {
        return this.getSomeValues(id, "OUTBOX", parametri, false);
    }

    public Busta getSomeValuesFromOutBox(String id, LetturaParametriBusta parametri, boolean forzaLetturaDatabase) throws ProtocolException {
        return this.getSomeValues(id, "OUTBOX", parametri, forzaLetturaDatabase);
    }

    public String getCollaborazioneFromOutBox(String id) throws ProtocolException {
        return this.getCollaborazione(id, "OUTBOX");
    }

    public org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione getProfiloCollaborazioneFromOutBox(String id) throws ProtocolException {
        return this.getProfiloCollaborazione(id, "OUTBOX");
    }

    public String getProfiloCollaborazioneValueFromOutBox(String id) throws ProtocolException {
        return this.getProfiloCollaborazioneValue(id, "OUTBOX");
    }

    public long getSequenzaFromOutBox(String id) throws ProtocolException {
        return this.getSequenza(id, "OUTBOX");
    }

    public Integrazione getInfoIntegrazioneFromOutBox(String id) throws ProtocolException {
        return this.getInfoIntegrazione(id, "OUTBOX");
    }

    public void eliminaUtilizzoPdDFromOutBox(String id) throws ProtocolException {
        this.eliminaUtilizzoPdD(id, "OUTBOX", false);
    }

    public void eliminaUtilizzoPdDFromOutBox(String id, boolean forzaUpdateDB) throws ProtocolException {
        this.eliminaUtilizzoPdD(id, "OUTBOX", forzaUpdateDB);
    }

    public void eliminaUtilizzoPdDFromOutBox(String id, boolean forzaUpdateDB, boolean savePreparedStatement) throws ProtocolException {
        this.eliminaUtilizzoPdD(id, "OUTBOX", forzaUpdateDB, savePreparedStatement);
    }

    public void eliminaBustaFromOutBox(String id) throws ProtocolException {
        this.eliminaBusta(id, "OUTBOX");
    }

    public void eliminaBustaStatelessFromOutBox(String id) throws ProtocolException {
        this.eliminaBustaStateless(id, "OUTBOX");
    }

    public void impostaUtilizzoPdDIntoOutBox(String id) throws ProtocolException {
        this.impostaUtilizzoPdD(id, "OUTBOX");
    }

    public void registraBustaIntoInBox(Busta busta, long scadenza) throws ProtocolException {
        this.registraBusta(busta, "INBOX", null, scadenza);
    }

    public void registraBustaIntoInBox(Busta busta, Vector<Eccezione> errors, long scadenza) throws ProtocolException {
        this.registraBusta(busta, "INBOX", errors, scadenza);
    }

    public void registraBustaIntoInBox(String id, IDSoggetto soggettoFruitore, IDServizio servizio, long scadenza, org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione profiloCollaborazione, boolean confermaRicezione, Inoltro inoltro) throws ProtocolException {
        Busta busta = new Busta(this.protocolFactory.getProtocol());
        busta.setID(id);
        busta.setTipoMittente(soggettoFruitore.getTipo());
        busta.setMittente(soggettoFruitore.getNome());
        busta.setIdentificativoPortaMittente(soggettoFruitore.getCodicePorta());
        busta.setTipoDestinatario(servizio.getSoggettoErogatore().getTipo());
        busta.setDestinatario(servizio.getSoggettoErogatore().getNome());
        busta.setIdentificativoPortaDestinatario(servizio.getSoggettoErogatore().getCodicePorta());
        busta.setTipoServizio(servizio.getTipoServizio());
        busta.setServizio(servizio.getServizio());
        busta.setVersioneServizio(servizio.getVersioneServizio());
        busta.setAzione(servizio.getAzione());
        busta.setProfiloDiCollaborazione(profiloCollaborazione);
        busta.setConfermaRicezione(confermaRicezione);
        busta.setInoltro(inoltro, this.protocolFactory.createTraduttore().toString(inoltro));
        this.registraBusta(busta, "INBOX", null, scadenza);
    }

    public void aggiornaProprietaBustaIntoInBox(Hashtable<String, String> properties, String idBusta) throws ProtocolException {
        this.aggiornaProprietaBusta(properties, idBusta, "INBOX");
    }

    public void aggiornaDuplicatiIntoInBox(String id) throws ProtocolException {
        this.aggiornaDuplicati(id, "INBOX");
    }

    public void aggiornaInfoIntegrazioneIntoInBox(String id, Integrazione infoIntegrazione) throws ProtocolException {
        this.aggiornaInfoIntegrazione(id, "INBOX", infoIntegrazione);
    }

    public void aggiornaInfoIntegrazioneIntoInBox_ServizioApplicativo(String id, String servizioApplicativo) throws ProtocolException {
        this.aggiornaInfoIntegrazione_ServizioApplicativo(id, "INBOX", servizioApplicativo);
    }

    public void aggiornaInfoIntegrazioneIntoInBox_Scenario(String id, String scenario) throws ProtocolException {
        this.aggiornaInfoIntegrazione_Scenario(id, "INBOX", scenario);
    }

    public void aggiornaBustaIntoInBox(Busta busta, long scadenza) throws ProtocolException {
        this.aggiornaBusta(busta, "INBOX", scadenza, null);
    }

    public void aggiornaBustaIntoInBox(Busta busta, long scadenza, Vector<Eccezione> errors) throws ProtocolException {
        this.aggiornaBusta(busta, "INBOX", scadenza, errors);
    }

    public void aggiornaBustaIntoInBox(String id, IDSoggetto soggettoFruitore, IDServizio servizio, long scadenza, org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione profiloCollaborazione, boolean confermaRicezione, Inoltro inoltro) throws ProtocolException {
        Busta bustaDaAggiornare = new Busta(this.protocolFactory.getProtocol());
        bustaDaAggiornare.setID(id);
        bustaDaAggiornare.setTipoMittente(soggettoFruitore.getTipo());
        bustaDaAggiornare.setMittente(soggettoFruitore.getNome());
        bustaDaAggiornare.setIdentificativoPortaMittente(soggettoFruitore.getCodicePorta());
        bustaDaAggiornare.setTipoDestinatario(servizio.getSoggettoErogatore().getTipo());
        bustaDaAggiornare.setDestinatario(servizio.getSoggettoErogatore().getNome());
        bustaDaAggiornare.setIdentificativoPortaDestinatario(servizio.getSoggettoErogatore().getCodicePorta());
        bustaDaAggiornare.setTipoServizio(servizio.getTipoServizio());
        bustaDaAggiornare.setServizio(servizio.getServizio());
        bustaDaAggiornare.setVersioneServizio(servizio.getVersioneServizio());
        bustaDaAggiornare.setAzione(servizio.getAzione());
        bustaDaAggiornare.setProfiloDiCollaborazione(profiloCollaborazione);
        bustaDaAggiornare.setConfermaRicezione(confermaRicezione);
        bustaDaAggiornare.setInoltro(inoltro, this.protocolFactory.createTraduttore().toString(inoltro));
        this.aggiornaBusta(bustaDaAggiornare, "INBOX", scadenza, null);
    }

    public void aggiornaCollaborazioneIntoInBox(String id, String collaborazione) throws ProtocolException {
        this.aggiornaCollaborazione(id, "INBOX", collaborazione);
    }

    public void aggiornaSequenzaIntoInBox(String id, long sequenza) throws ProtocolException {
        this.aggiornaSequenza(id, "INBOX", sequenza);
    }

    public boolean isRegistrataIntoInBox(String id) throws ProtocolException {
        return this.isRegistrata(id, "INBOX");
    }

    public Busta getBustaFromInBox(String id) throws ProtocolException {
        return this.getBusta(id, "INBOX");
    }

    public Vector<Eccezione> getErrorsFromInBox(String id) throws ProtocolException {
        return this.getErrors(id, "INBOX");
    }

    public Busta getSomeValuesFromInBox(String id, LetturaParametriBusta parametri) throws ProtocolException {
        return this.getSomeValues(id, "INBOX", parametri, false);
    }

    public Busta getSomeValuesFromInBox(String id, LetturaParametriBusta parametri, boolean forzaLetturaDatabase) throws ProtocolException {
        return this.getSomeValues(id, "INBOX", parametri, forzaLetturaDatabase);
    }

    public String getCollaborazioneFromInBox(String id) throws ProtocolException {
        return this.getCollaborazione(id, "INBOX");
    }

    public org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione getProfiloCollaborazioneFromInBox(String id) throws ProtocolException {
        return this.getProfiloCollaborazione(id, "INBOX");
    }

    public String getProfiloCollaborazioneValueFromInBox(String id) throws ProtocolException {
        return this.getProfiloCollaborazioneValue(id, "INBOX");
    }

    public long getSequenzaFromInBox(String id) throws ProtocolException {
        return this.getSequenza(id, "INBOX");
    }

    public Integrazione getInfoIntegrazioneFromInBox(String id) throws ProtocolException {
        return this.getInfoIntegrazione(id, "INBOX");
    }

    public void eliminaUtilizzoPdDFromInBox(String id) throws ProtocolException {
        this.eliminaUtilizzoPdD(id, "INBOX", false);
    }

    public void eliminaUtilizzoPdDFromInBox(String id, boolean forzaUpdateDB) throws ProtocolException {
        this.eliminaUtilizzoPdD(id, "INBOX", forzaUpdateDB);
    }

    public void eliminaUtilizzoPdDFromInBox(String id, boolean forzaUpdateDB, boolean savePreparedStatement) throws ProtocolException {
        this.eliminaUtilizzoPdD(id, "INBOX", forzaUpdateDB, savePreparedStatement);
    }

    public void eliminaBustaFromInBox(String id) throws ProtocolException {
        this.eliminaBusta(id, "INBOX");
    }

    public void eliminaBustaStatelessFromInBox(String id) throws ProtocolException {
        this.eliminaBustaStateless(id, "INBOX");
    }

    public void impostaUtilizzoPdDIntoInBox(String id) throws ProtocolException {
        this.impostaUtilizzoPdD(id, "INBOX");
    }

    public void registraBustaIntoInboxForHistory(Busta busta, long scadenza) throws ProtocolException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        Statement pstmtBusta = null;
        try {
            Date scadenzaBusta = busta.getScadenza();
            if (scadenzaBusta == null) {
                scadenzaBusta = new Date(DateManager.getTimeMillis() + scadenza * 60L * 1000L);
            }
            Timestamp scadenzaT = new Timestamp(scadenzaBusta.getTime());
            StringBuffer query = new StringBuffer();
            query.append("INSERT INTO  ");
            query.append("REPOSITORY_BUSTE");
            query.append(" (ID_MESSAGGIO,TIPO,MITTENTE,IDPORTA_MITTENTE,TIPO_MITTENTE,IND_TELEMATICO_MITT,DESTINATARIO,IDPORTA_DESTINATARIO,TIPO_DESTINATARIO,IND_TELEMATICO_DEST");
            query.append(",VERSIONE_SERVIZIO,SERVIZIO,TIPO_SERVIZIO,AZIONE,PROFILO_DI_COLLABORAZIONE,SERVIZIO_CORRELATO,TIPO_SERVIZIO_CORRELATO");
            query.append(",COLLABORAZIONE,SEQUENZA,INOLTRO_SENZA_DUPLICATI,CONFERMA_RICEZIONE,ORA_REGISTRAZIONE,TIPO_ORA_REGISTRAZIONE");
            query.append(",RIFERIMENTO_MESSAGGIO,SCADENZA_BUSTA,DUPLICATI,LOCATION_PD,SERVIZIO_APPLICATIVO,MODULO_IN_ATTESA,SCENARIO,PROTOCOLLO,");
            query.append(this.gestoreRepositoryBuste.createSQLFieldHistory());
            query.append(") ");
            query.append(" VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,");
            query.append(this.gestoreRepositoryBuste.getSQLValueHistory(true));
            query.append(")");
            pstmtBusta = connectionDB.prepareStatement(query.toString());
            pstmtBusta.setString(1, busta.getID());
            pstmtBusta.setString(2, "INBOX");
            pstmtBusta.setString(3, busta.getMittente());
            pstmtBusta.setString(4, busta.getIdentificativoPortaMittente());
            pstmtBusta.setString(5, busta.getTipoMittente());
            pstmtBusta.setString(6, busta.getIndirizzoMittente());
            pstmtBusta.setString(7, busta.getDestinatario());
            pstmtBusta.setString(8, busta.getIdentificativoPortaDestinatario());
            pstmtBusta.setString(9, busta.getTipoDestinatario());
            pstmtBusta.setString(10, busta.getIndirizzoDestinatario());
            pstmtBusta.setInt(11, busta.getVersioneServizio());
            pstmtBusta.setString(12, busta.getServizio());
            pstmtBusta.setString(13, busta.getTipoServizio());
            pstmtBusta.setString(14, busta.getAzione());
            pstmtBusta.setString(15, busta.getProfiloDiCollaborazione().getEngineValue());
            pstmtBusta.setString(16, busta.getServizioCorrelato());
            pstmtBusta.setString(17, busta.getTipoServizioCorrelato());
            pstmtBusta.setString(18, busta.getCollaborazione());
            pstmtBusta.setLong(19, busta.getSequenza());
            if (Inoltro.SENZA_DUPLICATI.equals(busta.getInoltro())) {
                pstmtBusta.setInt(20, 1);
            } else {
                pstmtBusta.setInt(20, 0);
            }
            if (busta.isConfermaRicezione()) {
                pstmtBusta.setInt(21, 1);
            } else {
                pstmtBusta.setInt(21, 0);
            }
            Timestamp oraRec = null;
            TipoOraRegistrazione tipoOraRec = null;
            if (busta.getOraRegistrazione() != null && busta.getTipoOraRegistrazione() != null) {
                oraRec = new Timestamp(busta.getOraRegistrazione().getTime());
                tipoOraRec = busta.getTipoOraRegistrazione();
            } else {
                oraRec = DateManager.getTimestamp();
                tipoOraRec = TipoOraRegistrazione.SINCRONIZZATO;
            }
            pstmtBusta.setTimestamp(22, oraRec);
            pstmtBusta.setString(23, tipoOraRec.getEngineValue());
            pstmtBusta.setString(24, busta.getRiferimentoMessaggio());
            pstmtBusta.setTimestamp(25, scadenzaT);
            pstmtBusta.setInt(26, 0);
            pstmtBusta.setString(27, null);
            pstmtBusta.setString(28, null);
            pstmtBusta.setString(29, null);
            pstmtBusta.setString(30, null);
            if (busta.getProtocollo() != null) {
                pstmtBusta.setString(31, busta.getProtocollo());
            } else if (this.protocolFactory != null) {
                pstmtBusta.setString(31, this.protocolFactory.getProtocol());
            } else {
                throw new ProtocolException("Protocol unknow");
            }
            stateMSG.getPreparedStatement().put("INSERT RegistrazioneBustaForHistoryINBOX_" + busta.getID(), (PreparedStatement)pstmtBusta);
        }
        catch (Exception e) {
            String id = busta.getID();
            String errorMsg = "REPOSITORY_BUSTE, Errore di registrazione per History INBOX/" + id + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (pstmtBusta != null) {
                    pstmtBusta.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    public void registraBusta(Busta busta, String tipoBusta, Vector<Eccezione> errors, long scadenza) throws ProtocolException {
        if (!this.isRichiesta && this.state instanceof StatelessMessage) {
            ((StatelessMessage)this.state).setBusta(busta);
            return;
        }
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        Statement pstmtBusta = null;
        Statement pstmtUpdateAccessoPdD = null;
        Statement pstmtListaRiscontri = null;
        Statement pstmtListaTrasmissioni = null;
        Statement pstmtListaEccezioni = null;
        Statement pstmtListaEccezioniValidazione = null;
        Statement pstmtListaExtInfo = null;
        try {
            Date scadenzaBusta = busta.getScadenza();
            if (scadenzaBusta == null) {
                scadenzaBusta = new Date(DateManager.getTimeMillis() + scadenza * 60L * 1000L);
            }
            Timestamp scadenzaT = new Timestamp(scadenzaBusta.getTime());
            StringBuffer query = new StringBuffer();
            query.append("INSERT INTO  ");
            query.append("REPOSITORY_BUSTE");
            query.append(" (ID_MESSAGGIO,TIPO,MITTENTE,IDPORTA_MITTENTE,TIPO_MITTENTE,IND_TELEMATICO_MITT,DESTINATARIO,IDPORTA_DESTINATARIO,TIPO_DESTINATARIO,IND_TELEMATICO_DEST");
            query.append(",VERSIONE_SERVIZIO,SERVIZIO,TIPO_SERVIZIO,AZIONE,PROFILO_DI_COLLABORAZIONE,SERVIZIO_CORRELATO,TIPO_SERVIZIO_CORRELATO");
            query.append(",COLLABORAZIONE,SEQUENZA,INOLTRO_SENZA_DUPLICATI,CONFERMA_RICEZIONE,ORA_REGISTRAZIONE,TIPO_ORA_REGISTRAZIONE");
            query.append(",RIFERIMENTO_MESSAGGIO,SCADENZA_BUSTA,DUPLICATI,LOCATION_PD,SERVIZIO_APPLICATIVO,MODULO_IN_ATTESA,SCENARIO,PROTOCOLLO) ");
            query.append(" VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            pstmtBusta = connectionDB.prepareStatement(query.toString());
            pstmtBusta.setString(1, busta.getID());
            pstmtBusta.setString(2, tipoBusta);
            pstmtBusta.setString(3, busta.getMittente());
            pstmtBusta.setString(4, busta.getIdentificativoPortaMittente());
            pstmtBusta.setString(5, busta.getTipoMittente());
            pstmtBusta.setString(6, busta.getIndirizzoMittente());
            pstmtBusta.setString(7, busta.getDestinatario());
            pstmtBusta.setString(8, busta.getIdentificativoPortaDestinatario());
            pstmtBusta.setString(9, busta.getTipoDestinatario());
            pstmtBusta.setString(10, busta.getIndirizzoDestinatario());
            pstmtBusta.setInt(11, busta.getVersioneServizio());
            pstmtBusta.setString(12, busta.getServizio());
            pstmtBusta.setString(13, busta.getTipoServizio());
            pstmtBusta.setString(14, busta.getAzione());
            pstmtBusta.setString(15, busta.getProfiloDiCollaborazione() == null ? null : busta.getProfiloDiCollaborazione().getEngineValue());
            pstmtBusta.setString(16, busta.getServizioCorrelato());
            pstmtBusta.setString(17, busta.getTipoServizioCorrelato());
            pstmtBusta.setString(18, busta.getCollaborazione());
            pstmtBusta.setLong(19, busta.getSequenza());
            if (Inoltro.SENZA_DUPLICATI.equals(busta.getInoltro())) {
                pstmtBusta.setInt(20, 1);
            } else {
                pstmtBusta.setInt(20, 0);
            }
            if (busta.isConfermaRicezione()) {
                pstmtBusta.setInt(21, 1);
            } else {
                pstmtBusta.setInt(21, 0);
            }
            Timestamp oraRec = null;
            TipoOraRegistrazione tipoOraRec = null;
            if (busta.getOraRegistrazione() != null && busta.getTipoOraRegistrazione() != null) {
                oraRec = new Timestamp(busta.getOraRegistrazione().getTime());
                tipoOraRec = busta.getTipoOraRegistrazione();
            } else {
                oraRec = DateManager.getTimestamp();
                tipoOraRec = TipoOraRegistrazione.SINCRONIZZATO;
            }
            pstmtBusta.setTimestamp(22, oraRec);
            pstmtBusta.setString(23, tipoOraRec.getEngineValue());
            pstmtBusta.setString(24, busta.getRiferimentoMessaggio());
            pstmtBusta.setTimestamp(25, scadenzaT);
            pstmtBusta.setInt(26, 0);
            pstmtBusta.setString(27, null);
            pstmtBusta.setString(28, null);
            pstmtBusta.setString(29, null);
            pstmtBusta.setString(30, null);
            if (busta.getProtocollo() != null) {
                pstmtBusta.setString(31, busta.getProtocollo());
            } else if (this.protocolFactory != null) {
                pstmtBusta.setString(31, this.protocolFactory.getProtocol());
            } else {
                throw new ProtocolException("Protocol unknow");
            }
            stateMSG.getPreparedStatement().put("INSERT RegistrazioneBusta" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtBusta);
            query.delete(0, query.length());
            query.append("UPDATE ");
            query.append("REPOSITORY_BUSTE");
            query.append(" SET ");
            query.append(this.gestoreRepositoryBuste.createSQLSet_PdD(true));
            query.append(" WHERE  ID_MESSAGGIO = ? AND TIPO=?");
            pstmtUpdateAccessoPdD = connectionDB.prepareStatement(query.toString());
            pstmtUpdateAccessoPdD.setString(1, busta.getID());
            pstmtUpdateAccessoPdD.setString(2, tipoBusta);
            stateMSG.getPreparedStatement().put("INSERT RegistrazioneBusta" + tipoBusta + "_" + busta.getID() + " UPDATE RegistrazioneBustaAccessoPdD", (PreparedStatement)pstmtUpdateAccessoPdD);
            if (this.state instanceof StatefulMessage) {
                String[] names;
                Eccezione eccezione;
                int i;
                for (i = 0; i < busta.sizeListaRiscontri(); ++i) {
                    Riscontro riscontro = busta.getRiscontro(i);
                    query.delete(0, query.length());
                    query.append("INSERT INTO  ");
                    query.append("LISTA_RISCONTRI");
                    query.append(" (ID_MESSAGGIO,TIPO,ID_RISCONTRO,ORA_REGISTRAZIONE,TIPO_ORA_REGISTRAZIONE)");
                    query.append(" VALUES (?,?,?,?,?)");
                    pstmtListaRiscontri = connectionDB.prepareStatement(query.toString());
                    pstmtListaRiscontri.setString(1, busta.getID());
                    pstmtListaRiscontri.setString(2, tipoBusta);
                    pstmtListaRiscontri.setString(3, riscontro.getID());
                    Timestamp oraRecRiscontro = null;
                    if (riscontro.getOraRegistrazione() != null) {
                        oraRecRiscontro = new Timestamp(riscontro.getOraRegistrazione().getTime());
                    }
                    pstmtListaRiscontri.setTimestamp(4, oraRecRiscontro);
                    pstmtListaRiscontri.setString(5, riscontro.getTipoOraRegistrazione().getEngineValue());
                    stateMSG.getPreparedStatement().put("INSERT RegistrazioneListaRiscontri_riscontro[" + i + "]_" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtListaRiscontri);
                }
                for (i = 0; i < busta.sizeListaTrasmissioni(); ++i) {
                    Trasmissione trasmissione = busta.getTrasmissione(i);
                    query.delete(0, query.length());
                    query.append("INSERT INTO  ");
                    query.append("LISTA_TRASMISSIONI");
                    query.append(" (ID_MESSAGGIO,TIPO,ORIGINE,TIPO_ORIGINE,DESTINAZIONE,TIPO_DESTINAZIONE,ORA_REGISTRAZIONE,TIPO_ORA_REGISTRAZIONE)");
                    query.append(" VALUES (?,?,?,?,?,?,?,?)");
                    pstmtListaTrasmissioni = connectionDB.prepareStatement(query.toString());
                    pstmtListaTrasmissioni.setString(1, busta.getID());
                    pstmtListaTrasmissioni.setString(2, tipoBusta);
                    pstmtListaTrasmissioni.setString(3, trasmissione.getOrigine());
                    pstmtListaTrasmissioni.setString(4, trasmissione.getTipoOrigine());
                    pstmtListaTrasmissioni.setString(5, trasmissione.getDestinazione());
                    pstmtListaTrasmissioni.setString(6, trasmissione.getTipoDestinazione());
                    Timestamp oraRecTrasmissione = null;
                    if (trasmissione.getOraRegistrazione() != null) {
                        oraRecTrasmissione = new Timestamp(trasmissione.getOraRegistrazione().getTime());
                    }
                    pstmtListaTrasmissioni.setTimestamp(7, oraRecTrasmissione);
                    pstmtListaTrasmissioni.setString(8, trasmissione.getTempo().getEngineValue());
                    stateMSG.getPreparedStatement().put("INSERT RegistrazioneListaTrasmissioni_trasmissione[" + i + "]_" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtListaTrasmissioni);
                }
                for (i = 0; i < busta.sizeListaEccezioni(); ++i) {
                    eccezione = busta.getEccezione(i);
                    query.delete(0, query.length());
                    query.append("INSERT INTO  ");
                    query.append("LISTA_ECCEZIONI");
                    query.append(" (ID_MESSAGGIO,TIPO,VALIDAZIONE,CONTESTO,CODICE,RILEVANZA,POSIZIONE)");
                    query.append(" VALUES (?,?,?,?,?,?,?)");
                    pstmtListaEccezioni = connectionDB.prepareStatement(query.toString());
                    pstmtListaEccezioni.setString(1, busta.getID());
                    pstmtListaEccezioni.setString(2, tipoBusta);
                    pstmtListaEccezioni.setInt(3, 0);
                    pstmtListaEccezioni.setString(4, eccezione.getContestoCodifica().getEngineValue());
                    pstmtListaEccezioni.setInt(5, eccezione.getCodiceEccezione().getCodice());
                    pstmtListaEccezioni.setString(6, eccezione.getRilevanza().getEngineValue());
                    pstmtListaEccezioni.setString(7, eccezione.getDescrizione(this.protocolFactory));
                    stateMSG.getPreparedStatement().put("INSERT RegistrazioneListaEccezioni_eccezioneBusta[" + i + "]_" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtListaEccezioni);
                }
                if (errors != null) {
                    for (i = 0; i < errors.size(); ++i) {
                        eccezione = errors.get(i);
                        query.delete(0, query.length());
                        query.append("INSERT INTO  ");
                        query.append("LISTA_ECCEZIONI");
                        query.append(" (ID_MESSAGGIO,TIPO,VALIDAZIONE,CONTESTO,CODICE,RILEVANZA,POSIZIONE)");
                        query.append(" VALUES (?,?,?,?,?,?,?)");
                        pstmtListaEccezioniValidazione = connectionDB.prepareStatement(query.toString());
                        pstmtListaEccezioniValidazione.setString(1, busta.getID());
                        pstmtListaEccezioniValidazione.setString(2, tipoBusta);
                        pstmtListaEccezioniValidazione.setInt(3, 1);
                        pstmtListaEccezioniValidazione.setString(4, eccezione.getContestoCodifica().getEngineValue());
                        pstmtListaEccezioniValidazione.setInt(5, eccezione.getCodiceEccezione().getCodice());
                        pstmtListaEccezioniValidazione.setString(6, eccezione.getRilevanza().getEngineValue());
                        pstmtListaEccezioniValidazione.setString(7, eccezione.getDescrizione(this.protocolFactory));
                        stateMSG.getPreparedStatement().put("INSERT RegistrazioneListaEccezioni_eccezioneValidazione[" + i + "]_" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtListaEccezioniValidazione);
                    }
                }
                if (busta.sizeProperties() > 0 && (names = busta.getPropertiesNames()) != null && names.length > 0) {
                    for (int i2 = 0; i2 < names.length; ++i2) {
                        String name = names[i2];
                        String value = busta.getProperty(name);
                        query.delete(0, query.length());
                        query.append("INSERT INTO  ");
                        query.append("LISTA_EXT_PROTOCOL_INFO");
                        query.append(" (ID_MESSAGGIO,TIPO,NOME,VALORE)");
                        query.append(" VALUES (?,?,?,?)");
                        pstmtListaExtInfo = connectionDB.prepareStatement(query.toString());
                        pstmtListaExtInfo.setString(1, busta.getID());
                        pstmtListaExtInfo.setString(2, tipoBusta);
                        pstmtListaExtInfo.setString(3, name);
                        pstmtListaExtInfo.setString(4, value);
                        stateMSG.getPreparedStatement().put("INSERT RegistrazioneListaExtInfoProtocol_info[" + i2 + "]_" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtListaExtInfo);
                    }
                }
            }
        }
        catch (Exception e) {
            String id = busta.getID();
            String errorMsg = "REPOSITORY_BUSTE, Errore di registrazione " + tipoBusta + "/" + id + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (pstmtBusta != null) {
                    pstmtBusta.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtUpdateAccessoPdD != null) {
                    pstmtUpdateAccessoPdD.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtListaRiscontri != null) {
                    pstmtListaRiscontri.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtListaTrasmissioni != null) {
                    pstmtListaTrasmissioni.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtListaEccezioni != null) {
                    pstmtListaEccezioni.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtListaEccezioniValidazione != null) {
                    pstmtListaEccezioniValidazione.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtListaExtInfo != null) {
                    pstmtListaExtInfo.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
        if (stateMSG instanceof StatelessMessage) {
            ((StatelessMessage)stateMSG).setBusta(busta);
        }
    }

    public void aggiornaProprietaBusta(Hashtable<String, String> properties, String idBusta, String tipoBusta) throws ProtocolException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        if (connectionDB == null) {
            return;
        }
        PreparedStatement pstmtDeleteListaExtInfo = null;
        Statement pstmtListaExtInfo = null;
        try {
            StringBuffer queryDelete = new StringBuffer();
            queryDelete.delete(0, queryDelete.length());
            queryDelete.append("DELETE FROM ");
            queryDelete.append("LISTA_EXT_PROTOCOL_INFO");
            queryDelete.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
            pstmtDeleteListaExtInfo = connectionDB.prepareStatement(queryDelete.toString());
            pstmtDeleteListaExtInfo.setString(1, idBusta);
            pstmtDeleteListaExtInfo.setString(2, tipoBusta);
            stateMSG.getPreparedStatement().put("DELETE(UPDATE) AggiornamentoBusta_listaExtInfo" + tipoBusta + "_" + idBusta, pstmtDeleteListaExtInfo);
            if (properties.size() > 0) {
                Enumeration<String> keys = properties.keys();
                int index = 0;
                while (keys.hasMoreElements()) {
                    String name = keys.nextElement();
                    String value = properties.get(name);
                    StringBuffer query = new StringBuffer();
                    query.delete(0, query.length());
                    query.append("INSERT INTO  ");
                    query.append("LISTA_EXT_PROTOCOL_INFO");
                    query.append(" (ID_MESSAGGIO,TIPO,NOME,VALORE)");
                    query.append(" VALUES (?,?,?,?)");
                    pstmtListaExtInfo = connectionDB.prepareStatement(query.toString());
                    pstmtListaExtInfo.setString(1, idBusta);
                    pstmtListaExtInfo.setString(2, tipoBusta);
                    pstmtListaExtInfo.setString(3, name);
                    pstmtListaExtInfo.setString(4, value);
                    stateMSG.getPreparedStatement().put("INSERT(UPDATE) RegistrazioneListaExtInfoProtocol_info[" + index + "]_" + tipoBusta + "_" + idBusta, (PreparedStatement)pstmtListaExtInfo);
                    ++index;
                }
            }
        }
        catch (Exception e) {
            String errorMsg = "REPOSITORY_BUSTE, Errore di aggiornamento proprieta' " + tipoBusta + "/" + idBusta + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (pstmtDeleteListaExtInfo != null) {
                    pstmtDeleteListaExtInfo.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtListaExtInfo != null) {
                    pstmtListaExtInfo.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    public void aggiornaBusta(Busta busta, String tipoBusta, long scadenza, Vector<Eccezione> errors) throws ProtocolException {
        if (!this.isRichiesta && this.state instanceof StatelessMessage) {
            ((StatelessMessage)this.state).setBusta(busta);
            return;
        }
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        Statement pstmtBusta = null;
        Statement pstmtDeleteListaRiscontri = null;
        Statement pstmtDeleteListaTrasmissioni = null;
        Statement pstmtDeleteListaEccezioni = null;
        Statement pstmtDeleteListaExtInfo = null;
        Statement pstmtListaRiscontri = null;
        Statement pstmtListaTrasmissioni = null;
        Statement pstmtListaEccezioni = null;
        Statement pstmtListaEccezioniValidazione = null;
        Statement pstmtListaExtInfo = null;
        try {
            Date scadenzaBusta = busta.getScadenza();
            if (scadenzaBusta == null) {
                scadenzaBusta = new Date(DateManager.getTimeMillis() + scadenza * 60L * 1000L);
            }
            Timestamp scadenzaT = new Timestamp(scadenzaBusta.getTime());
            StringBuffer query = new StringBuffer();
            query.append("UPDATE  ");
            query.append("REPOSITORY_BUSTE");
            query.append(" SET ");
            query.append("MITTENTE = ? ,");
            query.append("IDPORTA_MITTENTE = ? ,");
            query.append("TIPO_MITTENTE = ? ,");
            query.append("IND_TELEMATICO_MITT = ? ,");
            query.append("DESTINATARIO = ? ,");
            query.append("IDPORTA_DESTINATARIO = ? ,");
            query.append("TIPO_DESTINATARIO = ? ,");
            query.append("IND_TELEMATICO_DEST = ? ,");
            query.append("VERSIONE_SERVIZIO = ? ,");
            query.append("SERVIZIO = ? ,");
            query.append("TIPO_SERVIZIO = ? ,");
            query.append("AZIONE = ? ,");
            query.append("PROFILO_DI_COLLABORAZIONE = ? ,");
            query.append("SERVIZIO_CORRELATO = ? ,");
            query.append("TIPO_SERVIZIO_CORRELATO = ? ,");
            query.append("COLLABORAZIONE = ? ,");
            query.append("SEQUENZA = ? ,");
            query.append("INOLTRO_SENZA_DUPLICATI = ? ,");
            query.append("CONFERMA_RICEZIONE = ? ,");
            query.append("ORA_REGISTRAZIONE = ? ,");
            query.append("TIPO_ORA_REGISTRAZIONE = ? ,");
            query.append("RIFERIMENTO_MESSAGGIO = ? ,");
            query.append("SCADENZA_BUSTA = ? ");
            query.append(" WHERE ID_MESSAGGIO=? AND TIPO=?");
            pstmtBusta = connectionDB.prepareStatement(query.toString());
            pstmtBusta.setString(1, busta.getMittente());
            pstmtBusta.setString(2, busta.getIdentificativoPortaMittente());
            pstmtBusta.setString(3, busta.getTipoMittente());
            pstmtBusta.setString(4, busta.getIndirizzoMittente());
            pstmtBusta.setString(5, busta.getDestinatario());
            pstmtBusta.setString(6, busta.getIdentificativoPortaDestinatario());
            pstmtBusta.setString(7, busta.getTipoDestinatario());
            pstmtBusta.setString(8, busta.getIndirizzoDestinatario());
            pstmtBusta.setInt(9, busta.getVersioneServizio());
            pstmtBusta.setString(10, busta.getServizio());
            pstmtBusta.setString(11, busta.getTipoServizio());
            pstmtBusta.setString(12, busta.getAzione());
            pstmtBusta.setString(13, busta.getProfiloDiCollaborazione() == null ? null : busta.getProfiloDiCollaborazione().getEngineValue());
            pstmtBusta.setString(14, busta.getServizioCorrelato());
            pstmtBusta.setString(15, busta.getTipoServizioCorrelato());
            pstmtBusta.setString(16, busta.getCollaborazione());
            pstmtBusta.setLong(17, busta.getSequenza());
            if (Inoltro.SENZA_DUPLICATI.equals(busta.getInoltro())) {
                pstmtBusta.setInt(18, 1);
            } else {
                pstmtBusta.setInt(18, 0);
            }
            if (busta.isConfermaRicezione()) {
                pstmtBusta.setInt(19, 1);
            } else {
                pstmtBusta.setInt(19, 0);
            }
            Timestamp oraRec = null;
            TipoOraRegistrazione tipoOraRec = null;
            if (busta.getOraRegistrazione() != null && busta.getTipoOraRegistrazione() != null) {
                oraRec = new Timestamp(busta.getOraRegistrazione().getTime());
                tipoOraRec = busta.getTipoOraRegistrazione();
            }
            pstmtBusta.setTimestamp(20, oraRec);
            pstmtBusta.setString(21, tipoOraRec.getEngineValue());
            pstmtBusta.setString(22, busta.getRiferimentoMessaggio());
            pstmtBusta.setTimestamp(23, scadenzaT);
            pstmtBusta.setString(24, busta.getID());
            pstmtBusta.setString(25, tipoBusta);
            stateMSG.getPreparedStatement().put("UPDATE AggiornamentoBusta" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtBusta);
            if (errors != null) {
                String[] names;
                Eccezione eccezione;
                int i;
                StringBuffer queryDelete = new StringBuffer();
                queryDelete.append("DELETE FROM ");
                queryDelete.append("LISTA_TRASMISSIONI");
                queryDelete.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
                pstmtDeleteListaRiscontri = connectionDB.prepareStatement(queryDelete.toString());
                pstmtDeleteListaRiscontri.setString(1, busta.getID());
                pstmtDeleteListaRiscontri.setString(2, tipoBusta);
                stateMSG.getPreparedStatement().put("DELETE(UPDATE) AggiornamentoBusta_listaRiscontri" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtDeleteListaRiscontri);
                queryDelete.delete(0, queryDelete.length());
                queryDelete.append("DELETE FROM ");
                queryDelete.append("LISTA_RISCONTRI");
                queryDelete.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
                pstmtDeleteListaTrasmissioni = connectionDB.prepareStatement(queryDelete.toString());
                pstmtDeleteListaTrasmissioni.setString(1, busta.getID());
                pstmtDeleteListaTrasmissioni.setString(2, tipoBusta);
                stateMSG.getPreparedStatement().put("DELETE(UPDATE) AggiornamentoBusta_listaTrasmissioni" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtDeleteListaTrasmissioni);
                queryDelete.delete(0, queryDelete.length());
                queryDelete.append("DELETE FROM ");
                queryDelete.append("LISTA_ECCEZIONI");
                queryDelete.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
                pstmtDeleteListaEccezioni = connectionDB.prepareStatement(queryDelete.toString());
                pstmtDeleteListaEccezioni.setString(1, busta.getID());
                pstmtDeleteListaEccezioni.setString(2, tipoBusta);
                stateMSG.getPreparedStatement().put("DELETE(UPDATE) AggiornamentoBusta_listaEccezioni" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtDeleteListaEccezioni);
                queryDelete.delete(0, queryDelete.length());
                queryDelete.append("DELETE FROM ");
                queryDelete.append("LISTA_EXT_PROTOCOL_INFO");
                queryDelete.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
                pstmtDeleteListaExtInfo = connectionDB.prepareStatement(queryDelete.toString());
                pstmtDeleteListaExtInfo.setString(1, busta.getID());
                pstmtDeleteListaExtInfo.setString(2, tipoBusta);
                stateMSG.getPreparedStatement().put("DELETE(UPDATE) AggiornamentoBusta_listaExtInfo" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtDeleteListaExtInfo);
                for (i = 0; i < busta.sizeListaRiscontri(); ++i) {
                    Riscontro riscontro = busta.getRiscontro(i);
                    query.delete(0, query.length());
                    query.append("INSERT INTO  ");
                    query.append("LISTA_RISCONTRI");
                    query.append(" (ID_MESSAGGIO,TIPO,ID_RISCONTRO,ORA_REGISTRAZIONE,TIPO_ORA_REGISTRAZIONE)");
                    query.append(" VALUES (?,?,?,?,?)");
                    pstmtListaRiscontri = connectionDB.prepareStatement(query.toString());
                    pstmtListaRiscontri.setString(1, busta.getID());
                    pstmtListaRiscontri.setString(2, tipoBusta);
                    pstmtListaRiscontri.setString(3, riscontro.getID());
                    Timestamp oraRecRiscontro = null;
                    if (riscontro.getOraRegistrazione() != null) {
                        oraRecRiscontro = new Timestamp(riscontro.getOraRegistrazione().getTime());
                    }
                    pstmtListaRiscontri.setTimestamp(4, oraRecRiscontro);
                    pstmtListaRiscontri.setString(5, riscontro.getTipoOraRegistrazione().getEngineValue());
                    stateMSG.getPreparedStatement().put("INSERT(UPDATE) RegistrazioneListaRiscontri_riscontro[" + i + "]_" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtListaRiscontri);
                }
                for (i = 0; i < busta.sizeListaTrasmissioni(); ++i) {
                    Trasmissione trasmissione = busta.getTrasmissione(i);
                    query.delete(0, query.length());
                    query.append("INSERT INTO  ");
                    query.append("LISTA_TRASMISSIONI");
                    query.append(" (ID_MESSAGGIO,TIPO,ORIGINE,TIPO_ORIGINE,DESTINAZIONE,TIPO_DESTINAZIONE,ORA_REGISTRAZIONE,TIPO_ORA_REGISTRAZIONE)");
                    query.append(" VALUES (?,?,?,?,?,?,?,?)");
                    pstmtListaTrasmissioni = connectionDB.prepareStatement(query.toString());
                    pstmtListaTrasmissioni.setString(1, busta.getID());
                    pstmtListaTrasmissioni.setString(2, tipoBusta);
                    pstmtListaTrasmissioni.setString(3, trasmissione.getOrigine());
                    pstmtListaTrasmissioni.setString(4, trasmissione.getTipoOrigine());
                    pstmtListaTrasmissioni.setString(5, trasmissione.getDestinazione());
                    pstmtListaTrasmissioni.setString(6, trasmissione.getTipoDestinazione());
                    Timestamp oraRecTrasmissione = null;
                    if (trasmissione.getOraRegistrazione() != null) {
                        oraRecTrasmissione = new Timestamp(trasmissione.getOraRegistrazione().getTime());
                    }
                    pstmtListaTrasmissioni.setTimestamp(7, oraRecTrasmissione);
                    pstmtListaTrasmissioni.setString(8, trasmissione.getTempo().getEngineValue());
                    stateMSG.getPreparedStatement().put("INSERT(UPDATE) RegistrazioneListaTrasmissioni_trasmissione[" + i + "]_" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtListaTrasmissioni);
                }
                for (i = 0; i < busta.sizeListaEccezioni(); ++i) {
                    eccezione = busta.getEccezione(i);
                    query.delete(0, query.length());
                    query.append("INSERT INTO  ");
                    query.append("LISTA_ECCEZIONI");
                    query.append(" (ID_MESSAGGIO,TIPO,VALIDAZIONE,CONTESTO,CODICE,RILEVANZA,POSIZIONE)");
                    query.append(" VALUES (?,?,?,?,?,?,?)");
                    pstmtListaEccezioni = connectionDB.prepareStatement(query.toString());
                    pstmtListaEccezioni.setString(1, busta.getID());
                    pstmtListaEccezioni.setString(2, tipoBusta);
                    pstmtListaEccezioni.setInt(3, 0);
                    pstmtListaEccezioni.setString(4, eccezione.getContestoCodifica().getEngineValue());
                    pstmtListaEccezioni.setInt(5, eccezione.getCodiceEccezione().getCodice());
                    pstmtListaEccezioni.setString(6, eccezione.getRilevanza().getEngineValue());
                    pstmtListaEccezioni.setString(7, eccezione.getDescrizione(this.protocolFactory));
                    stateMSG.getPreparedStatement().put("INSERT(UPDATE) RegistrazioneListaEccezioni_eccezioneBusta[" + i + "]_" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtListaEccezioni);
                }
                for (i = 0; i < errors.size(); ++i) {
                    eccezione = errors.get(i);
                    query.delete(0, query.length());
                    query.append("INSERT INTO  ");
                    query.append("LISTA_ECCEZIONI");
                    query.append(" (ID_MESSAGGIO,TIPO,VALIDAZIONE,CONTESTO,CODICE,RILEVANZA,POSIZIONE)");
                    query.append(" VALUES (?,?,?,?,?,?,?)");
                    pstmtListaEccezioniValidazione = connectionDB.prepareStatement(query.toString());
                    pstmtListaEccezioniValidazione.setString(1, busta.getID());
                    pstmtListaEccezioniValidazione.setString(2, tipoBusta);
                    pstmtListaEccezioniValidazione.setInt(3, 1);
                    pstmtListaEccezioniValidazione.setString(4, eccezione.getContestoCodifica().getEngineValue());
                    pstmtListaEccezioniValidazione.setInt(5, eccezione.getCodiceEccezione().getCodice());
                    pstmtListaEccezioniValidazione.setString(6, eccezione.getRilevanza().getEngineValue());
                    pstmtListaEccezioniValidazione.setString(7, eccezione.getDescrizione(this.protocolFactory));
                    stateMSG.getPreparedStatement().put("INSERT(UPDATE) RegistrazioneListaEccezioni_eccezioneValidazione[" + i + "]_" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtListaEccezioniValidazione);
                }
                if (busta.sizeProperties() > 0 && (names = busta.getPropertiesNames()) != null && names.length > 0) {
                    for (int i2 = 0; i2 < names.length; ++i2) {
                        String name = names[i2];
                        String value = busta.getProperty(name);
                        query.delete(0, query.length());
                        query.append("INSERT INTO  ");
                        query.append("LISTA_EXT_PROTOCOL_INFO");
                        query.append(" (ID_MESSAGGIO,TIPO,NOME,VALORE)");
                        query.append(" VALUES (?,?,?,?)");
                        pstmtListaExtInfo = connectionDB.prepareStatement(query.toString());
                        pstmtListaExtInfo.setString(1, busta.getID());
                        pstmtListaExtInfo.setString(2, tipoBusta);
                        pstmtListaExtInfo.setString(3, name);
                        pstmtListaExtInfo.setString(4, value);
                        stateMSG.getPreparedStatement().put("INSERT(UPDATE) RegistrazioneListaExtInfoProtocol_info[" + i2 + "]_" + tipoBusta + "_" + busta.getID(), (PreparedStatement)pstmtListaExtInfo);
                    }
                }
            }
        }
        catch (Exception e) {
            String id = busta.getID();
            String errorMsg = "REPOSITORY_BUSTE, Errore di aggiornamento " + tipoBusta + "/" + id + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (pstmtBusta != null) {
                    pstmtBusta.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtDeleteListaRiscontri != null) {
                    pstmtDeleteListaRiscontri.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtDeleteListaTrasmissioni != null) {
                    pstmtDeleteListaTrasmissioni.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtDeleteListaEccezioni != null) {
                    pstmtDeleteListaEccezioni.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtDeleteListaExtInfo != null) {
                    pstmtDeleteListaExtInfo.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtListaRiscontri != null) {
                    pstmtListaRiscontri.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtListaTrasmissioni != null) {
                    pstmtListaTrasmissioni.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtListaEccezioni != null) {
                    pstmtListaEccezioni.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtListaEccezioniValidazione != null) {
                    pstmtListaEccezioniValidazione.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtListaExtInfo != null) {
                    pstmtListaExtInfo.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
        if (stateMSG instanceof StatelessMessage) {
            ((StatelessMessage)this.state).setBusta(busta);
        }
    }

    private void aggiornaDuplicati(String id, String tipoBusta) throws ProtocolException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        PreparedStatement pstmt = null;
        try {
            StringBuffer query = new StringBuffer();
            query.append("UPDATE ");
            query.append("REPOSITORY_BUSTE");
            query.append(" SET DUPLICATI=(DUPLICATI+1) WHERE  ID_MESSAGGIO = ? AND TIPO=?");
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, id);
            pstmt.setString(2, tipoBusta);
            stateMSG.getPreparedStatement().put("UPDATE aggiornaDuplicati " + tipoBusta + "_" + id, pstmt);
        }
        catch (Exception e) {
            String errorMsg = "REPOSITORY_BUSTE, Errore di aggiornamento informazioni pacchetti duplicati " + tipoBusta + "/" + id + ": " + e.getMessage();
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    public void aggiornaInfoIntegrazione(String id, String tipoBusta, Integrazione infoIntegrazione) throws ProtocolException {
        boolean registrazioneInfoIntegrazione = false;
        if (this.state instanceof StatefulMessage) {
            registrazioneInfoIntegrazione = true;
        } else if (this.isRichiesta && "OUTBOX".equals(tipoBusta)) {
            StatelessMessage stateless = (StatelessMessage)this.state;
            Busta busta = stateless.getBusta();
            if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ONEWAY.equals(busta.getProfiloDiCollaborazione()) && busta.isConfermaRicezione()) {
                registrazioneInfoIntegrazione = true;
            } else if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(busta.getProfiloDiCollaborazione()) && busta.getRiferimentoMessaggio() == null) {
                registrazioneInfoIntegrazione = true;
            }
        }
        if (registrazioneInfoIntegrazione) {
            StateMessage stateMSG = (StateMessage)this.state;
            Connection connectionDB = stateMSG.getConnectionDB();
            PreparedStatement pstmt = null;
            try {
                StringBuffer query = new StringBuffer();
                query.append("UPDATE ");
                query.append("REPOSITORY_BUSTE");
                query.append(" SET LOCATION_PD=? , SERVIZIO_APPLICATIVO=? , MODULO_IN_ATTESA=? , SCENARIO=? WHERE  ID_MESSAGGIO = ? AND TIPO=?");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, infoIntegrazione.getLocationPD());
                pstmt.setString(2, infoIntegrazione.getServizioApplicativo());
                pstmt.setString(3, infoIntegrazione.getIdModuloInAttesa());
                pstmt.setString(4, infoIntegrazione.getScenario());
                pstmt.setString(5, id);
                pstmt.setString(6, tipoBusta);
                stateMSG.getPreparedStatement().put("UPDATE aggiornaInformazioniIntegrazione " + tipoBusta + "_" + id, pstmt);
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_BUSTE, Errore di aggiornamento informazioni di Integrazione " + tipoBusta + "/" + id + ": " + e.getMessage();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
    }

    private void aggiornaInfoIntegrazione_ServizioApplicativo(String id, String tipoBusta, String servizioApplicativo) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            try {
                StringBuffer query = new StringBuffer();
                query.append("UPDATE ");
                query.append("REPOSITORY_BUSTE");
                query.append(" SET SERVIZIO_APPLICATIVO=? WHERE  ID_MESSAGGIO = ? AND TIPO=?");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, servizioApplicativo);
                pstmt.setString(2, id);
                pstmt.setString(3, tipoBusta);
                stateful.getPreparedStatement().put("UPDATE aggiornaInformazioniIntegrazione_ServizioApplicativo_" + tipoBusta + "_" + id, pstmt);
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_BUSTE, Errore di aggiornamento informazioni di Integrazione " + tipoBusta + "/" + id + " (ServizioApplicativo): " + e.getMessage();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
    }

    private void aggiornaInfoIntegrazione_Scenario(String id, String tipoBusta, String scenario) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            try {
                StringBuffer query = new StringBuffer();
                query.append("UPDATE ");
                query.append("REPOSITORY_BUSTE");
                query.append(" SET SCENARIO=? WHERE  ID_MESSAGGIO = ? AND TIPO=?");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, scenario);
                pstmt.setString(2, id);
                pstmt.setString(3, tipoBusta);
                stateful.getPreparedStatement().put("UPDATE aggiornaInformazioniIntegrazione_Scenario_" + tipoBusta + "_" + id, pstmt);
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_BUSTE, Errore di aggiornamento informazioni di Integrazione " + tipoBusta + "/" + id + " (Scenario): " + e.getMessage();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
    }

    private void aggiornaCollaborazione(String id, String tipoBusta, String collaborazione) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmtBusta = null;
            try {
                StringBuffer query = new StringBuffer();
                query.append("UPDATE  ");
                query.append("REPOSITORY_BUSTE");
                query.append(" SET ");
                query.append("COLLABORAZIONE = ?");
                query.append(" WHERE ID_MESSAGGIO=? AND TIPO=?");
                pstmtBusta = connectionDB.prepareStatement(query.toString());
                pstmtBusta.setString(1, collaborazione);
                pstmtBusta.setString(2, id);
                pstmtBusta.setString(3, tipoBusta);
                stateful.getPreparedStatement().put("UPDATE AggiornamentoCollaborazione" + tipoBusta + "_" + id, pstmtBusta);
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_BUSTE, Errore di aggiornamento collaborazione " + tipoBusta + "/" + id + ": " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                try {
                    if (pstmtBusta != null) {
                        pstmtBusta.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
        StatelessMessage statelessMsg = (StatelessMessage)this.state;
        statelessMsg.getBusta().setCollaborazione(collaborazione);
    }

    private void aggiornaSequenza(String id, String tipoBusta, long sequenza) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmtBusta = null;
            try {
                StringBuffer query = new StringBuffer();
                query.append("UPDATE  ");
                query.append("REPOSITORY_BUSTE");
                query.append(" SET ");
                query.append("SEQUENZA = ?");
                query.append(" WHERE ID_MESSAGGIO=? AND TIPO=?");
                pstmtBusta = connectionDB.prepareStatement(query.toString());
                pstmtBusta.setLong(1, sequenza);
                pstmtBusta.setString(2, id);
                pstmtBusta.setString(3, tipoBusta);
                stateful.getPreparedStatement().put("UPDATE AggiornamentoSequenza" + tipoBusta + "_" + id, pstmtBusta);
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_BUSTE, Errore di aggiornamento sequenza " + tipoBusta + "/" + id + ": " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                try {
                    if (pstmtBusta != null) {
                        pstmtBusta.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
        StatelessMessage statelessMsg = (StatelessMessage)this.state;
        statelessMsg.getBusta().setSequenza(sequenza);
    }

    public boolean isRegistrata(String id, String tipoBusta) throws ProtocolException {
        Connection connectionDB = ((StateMessage)this.state).getConnectionDB();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuffer query = new StringBuffer();
            query.append("select ID_MESSAGGIO from ");
            query.append("REPOSITORY_BUSTE");
            query.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, id);
            pstmt.setString(2, tipoBusta);
            rs = pstmt.executeQuery();
            if (rs == null) {
                throw new ProtocolException("RS Null?");
            }
            boolean value = rs.next();
            rs.close();
            pstmt.close();
            return value;
        }
        catch (Exception e) {
            String errorMsg = "REPOSITORY_BUSTE, Errore durante isRegistrata " + tipoBusta + "/" + id + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    private Busta getBusta(String id, String tipoBusta) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                StringBuffer query = new StringBuffer();
                query.append("select * from ");
                query.append("REPOSITORY_BUSTE");
                query.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, id);
                pstmt.setString(2, tipoBusta);
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new ProtocolException("RS Null?");
                }
                if (!rs.next()) {
                    throw new ProtocolException("Busta non trovata");
                }
                Busta busta = new Busta(rs.getString("PROTOCOLLO"));
                if (this.protocolFactory == null) {
                    if (busta.getProtocollo() != null) {
                        this.protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(busta.getProtocollo());
                    } else {
                        throw new ProtocolException("Protocol unknown");
                    }
                }
                busta.setID(rs.getString("ID_MESSAGGIO"));
                busta.setTipoMittente(rs.getString("TIPO_MITTENTE"));
                busta.setMittente(rs.getString("MITTENTE"));
                busta.setIdentificativoPortaMittente(rs.getString("IDPORTA_MITTENTE"));
                busta.setIndirizzoMittente(rs.getString("IND_TELEMATICO_MITT"));
                busta.setTipoDestinatario(rs.getString("TIPO_DESTINATARIO"));
                busta.setDestinatario(rs.getString("DESTINATARIO"));
                busta.setIdentificativoPortaDestinatario(rs.getString("IDPORTA_DESTINATARIO"));
                busta.setIndirizzoDestinatario(rs.getString("IND_TELEMATICO_DEST"));
                busta.setVersioneServizio(rs.getInt("VERSIONE_SERVIZIO"));
                busta.setServizio(rs.getString("SERVIZIO"));
                busta.setTipoServizio(rs.getString("TIPO_SERVIZIO"));
                busta.setAzione(rs.getString("AZIONE"));
                String profiloCollaborazione = rs.getString("PROFILO_DI_COLLABORAZIONE");
                if (profiloCollaborazione != null) {
                    busta.setProfiloDiCollaborazione(org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.toProfiloDiCollaborazione((String)profiloCollaborazione));
                }
                busta.setServizioCorrelato(rs.getString("SERVIZIO_CORRELATO"));
                busta.setTipoServizioCorrelato(rs.getString("TIPO_SERVIZIO_CORRELATO"));
                busta.setCollaborazione(rs.getString("COLLABORAZIONE"));
                busta.setSequenza(rs.getLong("SEQUENZA"));
                if (rs.getInt("INOLTRO_SENZA_DUPLICATI") != 0) {
                    busta.setInoltro(Inoltro.SENZA_DUPLICATI, this.protocolFactory.createTraduttore().toString(Inoltro.SENZA_DUPLICATI));
                } else {
                    busta.setInoltro(Inoltro.CON_DUPLICATI, this.protocolFactory.createTraduttore().toString(Inoltro.CON_DUPLICATI));
                }
                if (rs.getInt("CONFERMA_RICEZIONE") != 0) {
                    busta.setConfermaRicezione(true);
                } else {
                    busta.setConfermaRicezione(false);
                }
                busta.setOraRegistrazione((Date)rs.getTimestamp("ORA_REGISTRAZIONE"));
                TipoOraRegistrazione tipoOraRegistrazione = TipoOraRegistrazione.toTipoOraRegistrazione((String)rs.getString("TIPO_ORA_REGISTRAZIONE"));
                busta.setTipoOraRegistrazione(tipoOraRegistrazione, this.protocolFactory.createTraduttore().toString(tipoOraRegistrazione));
                busta.setRiferimentoMessaggio(rs.getString("RIFERIMENTO_MESSAGGIO"));
                busta.setScadenza((Date)rs.getTimestamp("SCADENZA_BUSTA"));
                rs.close();
                pstmt.close();
                query.delete(0, query.length());
                query.append("select * from ");
                query.append("LISTA_TRASMISSIONI");
                query.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, id);
                pstmt.setString(2, tipoBusta);
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new ProtocolException("RS Null?");
                }
                while (rs.next()) {
                    Trasmissione trasmissione = new Trasmissione();
                    trasmissione.setOrigine(rs.getString("ORIGINE"));
                    trasmissione.setTipoOrigine(rs.getString("TIPO_ORIGINE"));
                    trasmissione.setDestinazione(rs.getString("DESTINAZIONE"));
                    trasmissione.setTipoDestinazione(rs.getString("TIPO_DESTINAZIONE"));
                    trasmissione.setOraRegistrazione((Date)rs.getTimestamp("ORA_REGISTRAZIONE"));
                    trasmissione.setTempo(TipoOraRegistrazione.toTipoOraRegistrazione((String)rs.getString("TIPO_ORA_REGISTRAZIONE")));
                    busta.addTrasmissione(trasmissione);
                }
                rs.close();
                pstmt.close();
                query.delete(0, query.length());
                query.append("select * from ");
                query.append("LISTA_RISCONTRI");
                query.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, id);
                pstmt.setString(2, tipoBusta);
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new ProtocolException("RS Null?");
                }
                while (rs.next()) {
                    Riscontro riscontro = new Riscontro();
                    riscontro.setID(rs.getString("ID_RISCONTRO"));
                    riscontro.setOraRegistrazione((Date)rs.getTimestamp("ORA_REGISTRAZIONE"));
                    riscontro.setTipoOraRegistrazione(TipoOraRegistrazione.toTipoOraRegistrazione((String)rs.getString("TIPO_ORA_REGISTRAZIONE")));
                    busta.addRiscontro(riscontro);
                }
                rs.close();
                pstmt.close();
                query.delete(0, query.length());
                query.append("select * from ");
                query.append("LISTA_ECCEZIONI");
                query.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ? AND VALIDAZIONE=0");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, id);
                pstmt.setString(2, tipoBusta);
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new ProtocolException("RS Null?");
                }
                while (rs.next()) {
                    Eccezione eccezione = Eccezione.newEccezione();
                    eccezione.setContestoCodifica(ContestoCodificaEccezione.toContestoCodificaEccezione((String)rs.getString("CONTESTO")));
                    eccezione.setCodiceEccezione(CodiceErroreCooperazione.toCodiceErroreCooperazione((int)rs.getInt("CODICE")));
                    eccezione.setRilevanza(LivelloRilevanza.toLivelloRilevanza((String)rs.getString("RILEVANZA")));
                    eccezione.setDescrizione(rs.getString("POSIZIONE"));
                    busta.addEccezione(eccezione);
                }
                rs.close();
                pstmt.close();
                query.delete(0, query.length());
                query.append("select * from ");
                query.append("LISTA_EXT_PROTOCOL_INFO");
                query.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, id);
                pstmt.setString(2, tipoBusta);
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new ProtocolException("RS Null?");
                }
                while (rs.next()) {
                    busta.addProperty(rs.getString("NOME"), rs.getString("VALORE"));
                }
                rs.close();
                pstmt.close();
                return busta;
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_BUSTE, Errore durante la getBusta " + tipoBusta + "/" + id + ": " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
        StatelessMessage statelessMsg = (StatelessMessage)this.state;
        return statelessMsg.getBusta();
    }

    private Vector<Eccezione> getErrors(String id, String tipoBusta) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            Vector<Eccezione> errors = new Vector<Eccezione>();
            try {
                StringBuffer query = new StringBuffer();
                query.append("select * from ");
                query.append("LISTA_ECCEZIONI");
                query.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ? AND VALIDAZIONE=1");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, id);
                pstmt.setString(2, tipoBusta);
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new ProtocolException("RS Null?");
                }
                while (rs.next()) {
                    Eccezione eccezione = Eccezione.newEccezione();
                    eccezione.setContestoCodifica(ContestoCodificaEccezione.toContestoCodificaEccezione((String)rs.getString("CONTESTO")));
                    eccezione.setCodiceEccezione(CodiceErroreCooperazione.toCodiceErroreCooperazione((int)rs.getInt("CODICE")));
                    eccezione.setRilevanza(LivelloRilevanza.toLivelloRilevanza((String)rs.getString("RILEVANZA")));
                    eccezione.setDescrizione(rs.getString("POSIZIONE"));
                    errors.add(eccezione);
                }
                rs.close();
                pstmt.close();
                return errors;
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_BUSTE, Errore durante la getErrors " + tipoBusta + "/" + id + ": " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
        return null;
    }

    private Busta getSomeValues(String id, String tipoBusta, LetturaParametriBusta parametri, boolean forzaLetturaSuDatabase) throws ProtocolException {
        int i;
        if (this.state instanceof StatefulMessage || forzaLetturaSuDatabase) {
            StateMessage state = (StateMessage)this.state;
            Connection connectionDB = state.getConnectionDB();
            Statement pstmt = null;
            ResultSet rs = null;
            String protocollo = null;
            if (this.protocolFactory != null) {
                protocollo = this.protocolFactory.getProtocol();
            }
            Busta busta = new Busta(protocollo);
            try {
                StringBuffer bf = new StringBuffer();
                bf.append("SELECT ");
                bf.append("PROTOCOLLO");
                boolean first = false;
                if (parametri.isMittente()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("MITTENTE,TIPO_MITTENTE,IDPORTA_MITTENTE");
                    first = false;
                }
                if (parametri.isDestinatario()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("DESTINATARIO,TIPO_DESTINATARIO,IDPORTA_DESTINATARIO");
                }
                if (parametri.isIndirizziTelematici()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("IND_TELEMATICO_MITT,IND_TELEMATICO_DEST");
                }
                if (parametri.isServizio()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("SERVIZIO,TIPO_SERVIZIO,VERSIONE_SERVIZIO");
                }
                if (parametri.isAzione()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("AZIONE");
                }
                if (parametri.isProfiloDiCollaborazione()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("PROFILO_DI_COLLABORAZIONE");
                }
                if (parametri.isServizioCorrelato()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("SERVIZIO_CORRELATO,TIPO_SERVIZIO_CORRELATO");
                }
                if (parametri.isCollaborazione()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("COLLABORAZIONE");
                }
                if (parametri.isSequenza()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("SEQUENZA");
                }
                if (parametri.isProfiloTrasmissione()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("INOLTRO_SENZA_DUPLICATI,CONFERMA_RICEZIONE");
                }
                if (parametri.isOraRegistrazione()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("ORA_REGISTRAZIONE,TIPO_ORA_REGISTRAZIONE");
                }
                if (parametri.isRiferimentoMessaggio()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("RIFERIMENTO_MESSAGGIO");
                }
                if (parametri.isScadenza()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append("SCADENZA_BUSTA");
                }
                bf.append(" FROM ");
                bf.append("REPOSITORY_BUSTE");
                bf.append(" WHERE ID_MESSAGGIO=? AND TIPO=?");
                pstmt = connectionDB.prepareStatement(bf.toString());
                pstmt.setString(1, id);
                pstmt.setString(2, tipoBusta);
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new ProtocolException("RS Null?");
                }
                if (rs.next()) {
                    String protocolloRead = rs.getString("PROTOCOLLO");
                    if (busta.getProtocollo() == null) {
                        busta.setProtocollo(protocolloRead);
                    }
                    if (this.protocolFactory == null) {
                        this.protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocolloRead);
                    }
                    if (parametri.isMittente()) {
                        busta.setTipoMittente(rs.getString("TIPO_MITTENTE"));
                        busta.setMittente(rs.getString("MITTENTE"));
                        busta.setIdentificativoPortaMittente(rs.getString("IDPORTA_MITTENTE"));
                    }
                    if (parametri.isDestinatario()) {
                        busta.setTipoDestinatario(rs.getString("TIPO_DESTINATARIO"));
                        busta.setDestinatario(rs.getString("DESTINATARIO"));
                        busta.setIdentificativoPortaDestinatario(rs.getString("IDPORTA_DESTINATARIO"));
                    }
                    if (parametri.isIndirizziTelematici()) {
                        busta.setIndirizzoMittente(rs.getString("IND_TELEMATICO_MITT"));
                        busta.setIndirizzoDestinatario(rs.getString("IND_TELEMATICO_DEST"));
                    }
                    if (parametri.isServizio()) {
                        busta.setTipoServizio(rs.getString("TIPO_SERVIZIO"));
                        busta.setServizio(rs.getString("SERVIZIO"));
                        busta.setVersioneServizio(rs.getInt("VERSIONE_SERVIZIO"));
                    }
                    if (parametri.isAzione()) {
                        busta.setAzione(rs.getString("AZIONE"));
                    }
                    if (parametri.isProfiloDiCollaborazione()) {
                        busta.setProfiloDiCollaborazione(org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.toProfiloDiCollaborazione((String)rs.getString("PROFILO_DI_COLLABORAZIONE")));
                    }
                    if (parametri.isServizioCorrelato()) {
                        busta.setTipoServizioCorrelato(rs.getString("TIPO_SERVIZIO_CORRELATO"));
                        busta.setServizioCorrelato(rs.getString("SERVIZIO_CORRELATO"));
                    }
                    if (parametri.isCollaborazione()) {
                        busta.setCollaborazione(rs.getString("COLLABORAZIONE"));
                    }
                    if (parametri.isSequenza()) {
                        busta.setSequenza(rs.getLong("SEQUENZA"));
                    }
                    if (parametri.isProfiloTrasmissione()) {
                        if (rs.getInt("INOLTRO_SENZA_DUPLICATI") != 0) {
                            busta.setInoltro(Inoltro.SENZA_DUPLICATI, this.protocolFactory.createTraduttore().toString(Inoltro.SENZA_DUPLICATI));
                        } else {
                            busta.setInoltro(Inoltro.CON_DUPLICATI, this.protocolFactory.createTraduttore().toString(Inoltro.CON_DUPLICATI));
                        }
                        if (rs.getInt("CONFERMA_RICEZIONE") != 0) {
                            busta.setConfermaRicezione(true);
                        } else {
                            busta.setConfermaRicezione(false);
                        }
                    }
                    if (parametri.isOraRegistrazione()) {
                        busta.setOraRegistrazione((Date)rs.getTimestamp("ORA_REGISTRAZIONE"));
                        TipoOraRegistrazione tipoOraRegistrazione = TipoOraRegistrazione.toTipoOraRegistrazione((String)rs.getString("TIPO_ORA_REGISTRAZIONE"));
                        busta.setTipoOraRegistrazione(tipoOraRegistrazione, this.protocolFactory.createTraduttore().toString(tipoOraRegistrazione));
                    }
                    if (parametri.isRiferimentoMessaggio()) {
                        busta.setRiferimentoMessaggio(rs.getString("RIFERIMENTO_MESSAGGIO"));
                    }
                    if (parametri.isScadenza()) {
                        busta.setScadenza((Date)rs.getTimestamp("SCADENZA_BUSTA"));
                    }
                } else {
                    throw new ProtocolException("Busta non trovata");
                }
                rs.close();
                pstmt.close();
                return busta;
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_BUSTE, Errore  getSomeValues " + tipoBusta + "/" + id + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
        StatelessMessage statelessMsg = (StatelessMessage)this.state;
        Busta busta = statelessMsg.getBusta();
        if (!parametri.isMittente()) {
            busta.setTipoMittente(null);
            busta.setMittente(null);
        }
        if (!parametri.isDestinatario()) {
            busta.setTipoDestinatario(null);
            busta.setDestinatario(null);
        }
        if (!parametri.isIndirizziTelematici()) {
            busta.setIndirizzoMittente(null);
            busta.setIndirizzoDestinatario(null);
        }
        if (!parametri.isServizio()) {
            busta.setTipoServizio(null);
            busta.setServizio(null);
        }
        if (!parametri.isAzione()) {
            busta.setAzione(null);
        }
        if (!parametri.isProfiloDiCollaborazione()) {
            busta.setProfiloDiCollaborazione(null);
        }
        if (!parametri.isServizioCorrelato()) {
            busta.setTipoServizioCorrelato(null);
            busta.setServizioCorrelato(null);
        }
        if (!parametri.isCollaborazione()) {
            busta.setCollaborazione(null);
        }
        if (!parametri.isSequenza()) {
            busta.setSequenza(-1L);
        }
        if (!parametri.isProfiloTrasmissione()) {
            busta.setInoltro(null, null);
            busta.setConfermaRicezione(false);
        }
        if (!parametri.isOraRegistrazione()) {
            busta.setOraRegistrazione(null);
            busta.setTipoOraRegistrazione(null, null);
        }
        if (!parametri.isRiferimentoMessaggio()) {
            busta.setRiferimentoMessaggio(null);
        }
        if (!parametri.isScadenza()) {
            busta.setScadenza(null);
        }
        for (i = 0; i < busta.sizeListaEccezioni(); ++i) {
            busta.removeEccezione(i);
        }
        for (i = 0; i < busta.sizeListaTrasmissioni(); ++i) {
            busta.removeTrasmissione(i);
        }
        for (i = 0; i < busta.sizeListaRiscontri(); ++i) {
            busta.removeRiscontro(i);
        }
        if (busta.sizeProperties() > 0) {
            String[] pNames = busta.getPropertiesNames();
            for (int i2 = 0; i2 < pNames.length; ++i2) {
                busta.removeProperty(pNames[i2]);
            }
        }
        return busta;
    }

    private String getCollaborazione(String id, String tipoBusta) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String query = "SELECT COLLABORAZIONE FROM REPOSITORY_BUSTE WHERE ID_MESSAGGIO=? AND TIPO=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, id);
                pstmt.setString(2, tipoBusta);
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new ProtocolException("RS Null?");
                }
                String collaborazione = null;
                if (rs.next()) {
                    collaborazione = rs.getString("COLLABORAZIONE");
                }
                rs.close();
                pstmt.close();
                return collaborazione;
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_BUSTE, Errore  getCollaborazione " + tipoBusta + "/" + id + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
        StatelessMessage statelessMsg = (StatelessMessage)this.state;
        Busta busta = statelessMsg.getBusta();
        return busta.getCollaborazione();
    }

    private org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione getProfiloCollaborazione(String id, String tipoBusta) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String query = "SELECT PROFILO_DI_COLLABORAZIONE FROM REPOSITORY_BUSTE WHERE ID_MESSAGGIO=? AND TIPO=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, id);
                pstmt.setString(2, tipoBusta);
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new ProtocolException("RS Null?");
                }
                org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione profiloCollaborazione = null;
                if (rs.next()) {
                    profiloCollaborazione = org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.toProfiloDiCollaborazione((String)rs.getString("PROFILO_DI_COLLABORAZIONE"));
                }
                rs.close();
                pstmt.close();
                return profiloCollaborazione;
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_BUSTE, Errore  getProfiloCollaborazione " + tipoBusta + "/" + id + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
        StatelessMessage statelessMsg = (StatelessMessage)this.state;
        Busta busta = statelessMsg.getBusta();
        return busta.getProfiloDiCollaborazione();
    }

    private String getProfiloCollaborazioneValue(String id, String tipoBusta) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            return null;
        }
        StatelessMessage statelessMsg = (StatelessMessage)this.state;
        Busta busta = statelessMsg.getBusta();
        return busta.getProfiloDiCollaborazioneValue();
    }

    private long getSequenza(String id, String tipoBusta) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String query = "SELECT SEQUENZA FROM REPOSITORY_BUSTE WHERE ID_MESSAGGIO=? AND TIPO=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, id);
                pstmt.setString(2, tipoBusta);
                rs = pstmt.executeQuery();
                if (rs == null) {
                    throw new ProtocolException("RS Null?");
                }
                long sequenza = -1L;
                if (rs.next()) {
                    sequenza = rs.getLong("SEQUENZA");
                }
                rs.close();
                pstmt.close();
                return sequenza;
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_BUSTE, Errore  getSequenza " + tipoBusta + "/" + id + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
        StatelessMessage statelessMsg = (StatelessMessage)this.state;
        Busta busta = statelessMsg.getBusta();
        return busta.getSequenza();
    }

    private Integrazione getInfoIntegrazione(String id, String tipoBusta) throws ProtocolException {
        StateMessage stateful = (StateMessage)this.state;
        Connection connectionDB = stateful.getConnectionDB();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String query = "SELECT LOCATION_PD,SERVIZIO_APPLICATIVO,MODULO_IN_ATTESA,SCENARIO FROM REPOSITORY_BUSTE WHERE ID_MESSAGGIO=? AND TIPO=?";
            pstmt = connectionDB.prepareStatement(query);
            pstmt.setString(1, id);
            pstmt.setString(2, tipoBusta);
            rs = pstmt.executeQuery();
            if (rs == null) {
                throw new ProtocolException("RS Null?");
            }
            Integrazione infoIntegrazione = new Integrazione();
            if (rs.next()) {
                infoIntegrazione.setIdModuloInAttesa(rs.getString("MODULO_IN_ATTESA"));
                infoIntegrazione.setLocationPD(rs.getString("LOCATION_PD"));
                infoIntegrazione.setScenario(rs.getString("SCENARIO"));
                infoIntegrazione.setServizioApplicativo(rs.getString("SERVIZIO_APPLICATIVO"));
            }
            rs.close();
            pstmt.close();
            return infoIntegrazione;
        }
        catch (Exception e) {
            String errorMsg = "REPOSITORY_BUSTE, Errore  getInfoIntegrazione " + tipoBusta + "/" + id + ": " + e.getMessage();
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    private void eliminaUtilizzoPdD(String id, String tipoBusta, boolean forzaEliminazioneDB) throws ProtocolException {
        this.eliminaUtilizzoPdD(id, tipoBusta, forzaEliminazioneDB, true);
    }

    private void eliminaUtilizzoPdD(String id, String tipoBusta, boolean forzaEliminazioneDB, boolean savePreparedStatement) throws ProtocolException {
        if (this.state instanceof StatefulMessage || forzaEliminazioneDB) {
            StateMessage stateMSG = (StateMessage)this.state;
            Connection connectionDB = stateMSG.getConnectionDB();
            Statement pstmtUpdate = null;
            try {
                StringBuffer queryUpdate = new StringBuffer();
                queryUpdate.append("UPDATE ");
                queryUpdate.append("REPOSITORY_BUSTE");
                queryUpdate.append(" SET ");
                queryUpdate.append(this.gestoreRepositoryBuste.createSQLSet_PdD(false));
                queryUpdate.append(" WHERE  ID_MESSAGGIO = ? AND TIPO=?");
                pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
                pstmtUpdate.setString(1, id);
                pstmtUpdate.setString(2, tipoBusta);
                if (savePreparedStatement) {
                    stateMSG.getPreparedStatement().put("UPDATE AggiornamentoBusta" + tipoBusta + "_" + id, (PreparedStatement)pstmtUpdate);
                } else {
                    pstmtUpdate.executeUpdate();
                }
            }
            catch (Exception e) {
                String errorMsg = "REPOSITORY_BUSTE, Errore di cancellazione utilizzo from PdD " + tipoBusta + "/" + id + ": " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                try {
                    if (pstmtUpdate != null) {
                        pstmtUpdate.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
    }

    private void eliminaBustaStateless(String id, String tipoBusta) throws ProtocolException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        Statement pstmtUpdate = null;
        try {
            StringBuffer queryUpdate = new StringBuffer();
            queryUpdate.append("UPDATE ");
            queryUpdate.append("REPOSITORY_BUSTE");
            queryUpdate.append(" SET ");
            queryUpdate.append(this.gestoreRepositoryBuste.createSQLSet_PdD(false));
            queryUpdate.append(" WHERE  ID_MESSAGGIO = ? AND TIPO=?");
            pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
            pstmtUpdate.setString(1, id);
            pstmtUpdate.setString(2, tipoBusta);
            stateMSG.getPreparedStatement().put("UPDATE AggiornamentoBusta" + tipoBusta + "_" + id, (PreparedStatement)pstmtUpdate);
        }
        catch (Exception e) {
            String errorMsg = "REPOSITORY_BUSTE, Errore di cancellazione utilizzo from PdD " + tipoBusta + "/" + id + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (pstmtUpdate != null) {
                    pstmtUpdate.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    private void eliminaBusta(String id, String tipoBusta) throws ProtocolException {
        StateMessage state = (StateMessage)this.state;
        Connection connectionDB = state.getConnectionDB();
        Statement pstmtDelete = null;
        try {
            StringBuffer queryDelete;
            ProfiloDiCollaborazione profilo;
            if ("OUTBOX".equals(tipoBusta)) {
                if (this.state instanceof StatefulMessage) {
                    Riscontri riscontri = new Riscontri((IState)state, this.log);
                    riscontri.validazioneRiscontroRicevuto(id);
                    state.executePreparedStatement();
                }
                profilo = new ProfiloDiCollaborazione((IState)state, this.log, this.protocolFactory);
                profilo.asincrono_eliminaRegistrazione(id, "OUTBOX");
                state.executePreparedStatement();
            } else if ("INBOX".equals(tipoBusta)) {
                profilo = new ProfiloDiCollaborazione((IState)state, this.log, this.protocolFactory);
                profilo.asincrono_eliminaRegistrazione(id, "INBOX");
                state.executePreparedStatement();
            }
            if (this.state instanceof StatefulMessage) {
                queryDelete = new StringBuffer();
                queryDelete.append("DELETE FROM ");
                queryDelete.append("LISTA_TRASMISSIONI");
                queryDelete.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
                pstmtDelete = connectionDB.prepareStatement(queryDelete.toString());
                pstmtDelete.setString(1, id);
                pstmtDelete.setString(2, tipoBusta);
                pstmtDelete.execute();
                pstmtDelete.close();
                queryDelete.delete(0, queryDelete.length());
                queryDelete.append("DELETE FROM ");
                queryDelete.append("LISTA_RISCONTRI");
                queryDelete.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
                pstmtDelete = connectionDB.prepareStatement(queryDelete.toString());
                pstmtDelete.setString(1, id);
                pstmtDelete.setString(2, tipoBusta);
                pstmtDelete.execute();
                pstmtDelete.close();
                queryDelete.delete(0, queryDelete.length());
                queryDelete.append("DELETE FROM ");
                queryDelete.append("LISTA_ECCEZIONI");
                queryDelete.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
                pstmtDelete = connectionDB.prepareStatement(queryDelete.toString());
                pstmtDelete.setString(1, id);
                pstmtDelete.setString(2, tipoBusta);
                pstmtDelete.execute();
                pstmtDelete.close();
                queryDelete.delete(0, queryDelete.length());
                queryDelete.append("DELETE FROM ");
                queryDelete.append("LISTA_EXT_PROTOCOL_INFO");
                queryDelete.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
                pstmtDelete = connectionDB.prepareStatement(queryDelete.toString());
                pstmtDelete.setString(1, id);
                pstmtDelete.setString(2, tipoBusta);
                pstmtDelete.execute();
                pstmtDelete.close();
            }
            queryDelete = new StringBuffer();
            queryDelete.append("DELETE FROM ");
            queryDelete.append("REPOSITORY_BUSTE");
            queryDelete.append(" WHERE ID_MESSAGGIO = ? AND TIPO = ?");
            pstmtDelete = connectionDB.prepareStatement(queryDelete.toString());
            pstmtDelete.setString(1, id);
            pstmtDelete.setString(2, tipoBusta);
            pstmtDelete.execute();
            pstmtDelete.close();
        }
        catch (Exception e) {
            String errorMsg = "REPOSITORY_BUSTE, Errore di cancellazione from REPOSITORY_BUSTE " + tipoBusta + "/" + id + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (pstmtDelete != null) {
                    pstmtDelete.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    public Vector<String> getBusteDaEliminareFromInBox(int limit, boolean logQuery, boolean forceIndex, boolean filtraBustaScadetureRispettoOraRegistrazione, boolean orderBy) throws ProtocolException {
        return this.getBusteDaEliminare("INBOX", limit, logQuery, forceIndex, filtraBustaScadetureRispettoOraRegistrazione, orderBy);
    }

    public Vector<String> getBusteDaEliminareFromOutBox(int limit, boolean logQuery, boolean forceIndex, boolean filtraBustaScadetureRispettoOraRegistrazione, boolean orderBy) throws ProtocolException {
        return this.getBusteDaEliminare("OUTBOX", limit, logQuery, forceIndex, filtraBustaScadetureRispettoOraRegistrazione, orderBy);
    }

    private Vector<String> getBusteDaEliminare(String tipoBusta, int limit, boolean logQuery, boolean forceIndex, boolean filtraBustaScadetureRispettoOraRegistrazione, boolean orderBy) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            Statement pstmt = null;
            ResultSet rs = null;
            Vector<String> idBuste = new Vector<String>();
            IGestoreRepository gestorerepositoryBuste = Configurazione.getGestoreRepositoryBuste();
            String queryString = null;
            try {
                ISQLQueryObject sqlQueryObject;
                StringBuffer query;
                if (filtraBustaScadetureRispettoOraRegistrazione) {
                    if (Configurazione.getSqlQueryObjectType() == null) {
                        query = new StringBuffer();
                        query.append("SELECT ");
                        if (forceIndex) {
                            query.append("/*+ index(REPOSITORY_BUSTE REP_BUSTE_SEARCH) */");
                        }
                        query.append(" ID_MESSAGGIO FROM ");
                        query.append("REPOSITORY_BUSTE");
                        query.append(" WHERE SCADENZA_BUSTA < ? AND TIPO=? AND ");
                        query.append(gestorerepositoryBuste.createSQLCondition_enableOnlyHistory());
                        queryString = query.toString();
                    } else {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                        if (forceIndex) {
                            sqlQueryObject.addSelectForceIndex("REPOSITORY_BUSTE", "REP_BUSTE_SEARCH");
                        }
                        sqlQueryObject.addSelectField("ID_MESSAGGIO");
                        sqlQueryObject.addSelectField("ORA_REGISTRAZIONE");
                        sqlQueryObject.addSelectField("SCADENZA_BUSTA");
                        sqlQueryObject.addSelectField("TIPO");
                        sqlQueryObject.addSelectField(gestorerepositoryBuste.createSQLFields());
                        sqlQueryObject.addFromTable("REPOSITORY_BUSTE");
                        sqlQueryObject.addWhereCondition("SCADENZA_BUSTA < ?");
                        sqlQueryObject.addWhereCondition("TIPO=?");
                        sqlQueryObject.addWhereCondition(gestorerepositoryBuste.createSQLCondition_enableOnlyHistory());
                        sqlQueryObject.setANDLogicOperator(true);
                        if (orderBy) {
                            sqlQueryObject.addOrderBy("SCADENZA_BUSTA");
                            sqlQueryObject.setSortType(true);
                        }
                        sqlQueryObject.setLimit(limit);
                        queryString = sqlQueryObject.createSQLQuery();
                    }
                    Timestamp now = DateManager.getTimestamp();
                    pstmt = connectionDB.prepareStatement(queryString);
                    pstmt.setTimestamp(1, now);
                    pstmt.setString(2, tipoBusta);
                    long startDateSQLCommand = DateManager.getTimeMillis();
                    if (logQuery) {
                        this.log.debug((Object)("[QUERY] (repositoryBuste.busteScadute) [" + queryString + "] 1[" + now + "] 2[" + tipoBusta + "]..."));
                    }
                    rs = pstmt.executeQuery();
                    long endDateSQLCommand = DateManager.getTimeMillis();
                    long secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
                    if (logQuery) {
                        this.log.debug((Object)("[QUERY] (repositoryBuste.busteScadute) [" + queryString + "] 1[" + now + "] 2[" + tipoBusta + "] effettuata in " + secondSQLCommand + " secondi"));
                    }
                    int countLimit = 0;
                    while (rs.next()) {
                        idBuste.add(rs.getString("ID_MESSAGGIO"));
                        if (Configurazione.getSqlQueryObjectType() != null || ++countLimit != limit) continue;
                    }
                    rs.close();
                    pstmt.close();
                }
                queryString = null;
                if (Configurazione.getSqlQueryObjectType() == null) {
                    query = new StringBuffer();
                    query.append("SELECT ");
                    if (forceIndex) {
                        query.append("/*+ index(REPOSITORY_BUSTE REP_BUSTE_SEARCH_TIPO) */");
                    }
                    query.append(" ID_MESSAGGIO FROM ");
                    query.append("REPOSITORY_BUSTE");
                    query.append(" WHERE TIPO=? AND ");
                    query.append(gestorerepositoryBuste.createSQLCondition_disabledAll());
                    queryString = query.toString();
                } else {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    if (forceIndex) {
                        sqlQueryObject.addSelectForceIndex("REPOSITORY_BUSTE", "REP_BUSTE_SEARCH_TIPO");
                    }
                    sqlQueryObject.addSelectField("ID_MESSAGGIO");
                    sqlQueryObject.addSelectField("ORA_REGISTRAZIONE");
                    sqlQueryObject.addSelectField("TIPO");
                    sqlQueryObject.addSelectField(gestorerepositoryBuste.createSQLFields());
                    sqlQueryObject.addFromTable("REPOSITORY_BUSTE");
                    sqlQueryObject.addWhereCondition("TIPO=?");
                    sqlQueryObject.addWhereCondition(gestorerepositoryBuste.createSQLCondition_disabledAll());
                    sqlQueryObject.setANDLogicOperator(true);
                    if (orderBy) {
                        sqlQueryObject.addOrderBy("SCADENZA_BUSTA");
                        sqlQueryObject.setSortType(true);
                    }
                    sqlQueryObject.setLimit(limit);
                    queryString = sqlQueryObject.createSQLQuery();
                }
                pstmt = connectionDB.prepareStatement(queryString.toString());
                pstmt.setString(1, tipoBusta);
                long startDateSQLCommand = DateManager.getTimeMillis();
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] (repositoryBuste.busteCancellateLogicamente) [" + queryString + "] 1[" + tipoBusta + "]..."));
                }
                rs = pstmt.executeQuery();
                long endDateSQLCommand = DateManager.getTimeMillis();
                long secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] (repositoryBuste.busteCancellateLogicamente) [" + queryString + "] 1[" + tipoBusta + "] effettuata in " + secondSQLCommand + " secondi"));
                }
                int countLimit = 0;
                while (rs.next()) {
                    idBuste.add(rs.getString("ID_MESSAGGIO"));
                    if (Configurazione.getSqlQueryObjectType() != null || ++countLimit != limit) continue;
                }
                rs.close();
                pstmt.close();
                return idBuste;
            }
            catch (Exception e) {
                String errorMsg = "[repositoryBuste.getBusteDaEliminare] errore, queryString[" + queryString + "]: " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
        throw new ProtocolException("Metodo non invocabile in stateless mode");
    }

    public void impostaUtilizzoPdD(String id, String tipoBusta) throws ProtocolException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        Statement pstmtUpdate = null;
        try {
            StringBuffer queryUpdate = new StringBuffer();
            queryUpdate.append("UPDATE ");
            queryUpdate.append("REPOSITORY_BUSTE");
            queryUpdate.append(" SET ");
            queryUpdate.append(this.gestoreRepositoryBuste.createSQLSet_PdD(true));
            queryUpdate.append(" WHERE  ID_MESSAGGIO = ? AND TIPO=?");
            pstmtUpdate = connectionDB.prepareStatement(queryUpdate.toString());
            pstmtUpdate.setString(1, id);
            pstmtUpdate.setString(2, tipoBusta);
            stateMSG.getPreparedStatement().put("UPDATE AggiornamentoBusta_setUtilizzoPdD" + tipoBusta + "_" + id, (PreparedStatement)pstmtUpdate);
        }
        catch (Exception e) {
            String errorMsg = "REPOSITORY_BUSTE, Errore di impostazione utilizzo from PdD " + tipoBusta + "/" + id + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (pstmtUpdate != null) {
                    pstmtUpdate.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }

    public boolean exists(String id, String tipoBusta) throws ProtocolException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            StringBuffer queryUpdate = new StringBuffer();
            queryUpdate.append("SELECT ID_MESSAGGIO FROM ");
            queryUpdate.append("REPOSITORY_BUSTE");
            queryUpdate.append(" WHERE  ID_MESSAGGIO = ? AND TIPO=? AND (");
            queryUpdate.append(this.gestoreRepositoryBuste.createSQLCondition_History(true));
            queryUpdate.append(" OR ");
            queryUpdate.append(this.gestoreRepositoryBuste.createSQLCondition_PdD(true));
            queryUpdate.append(" OR ");
            queryUpdate.append(this.gestoreRepositoryBuste.createSQLCondition_ProfiloCollaborazione(true));
            queryUpdate.append(" ) ");
            pstmt = connectionDB.prepareStatement(queryUpdate.toString());
            pstmt.setString(1, id);
            pstmt.setString(2, tipoBusta);
            rs = pstmt.executeQuery();
            if (rs == null) {
                throw new Exception("Result set is null??");
            }
            boolean value = rs.next();
            rs.close();
            pstmt.close();
            return value;
        }
        catch (Exception e) {
            String errorMsg = "REPOSITORY_BUSTE, Errore durante l'utilizzo di exists " + tipoBusta + "/" + id + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, (Throwable)e);
        }
    }
}

