/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.builder;

import javax.xml.soap.SOAPElement;
import org.apache.log4j.Logger;
import org.openspcoop2.protocol.engine.Configurazione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.tracciamento.IXMLTracciaBuilder;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;

public class TracciaBuilder {
    protected Logger log = null;
    private IProtocolFactory protocolFactory;
    private IXMLTracciaBuilder tracciaProtocolBuilder;

    public TracciaBuilder(IProtocolFactory protocolFactory) {
        this(Configurazione.getLibraryLog(), protocolFactory);
    }

    public TracciaBuilder(Logger aLog, IProtocolFactory protocolFactory) {
        this.log = aLog != null ? aLog : Logger.getLogger(TracciaBuilder.class);
        this.protocolFactory = protocolFactory;
        try {
            this.tracciaProtocolBuilder = this.protocolFactory.createXMLTracciaBuilder();
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante la creazione dell'XMLTracciaBuilder: " + e.getMessage()), (Throwable)e);
        }
    }

    public IProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    public SOAPElement toElement(Traccia traccia) throws ProtocolException {
        return this.tracciaProtocolBuilder.toElement(traccia);
    }

    public byte[] toByteArray(Traccia traccia) throws ProtocolException {
        return this.tracciaProtocolBuilder.toByteArray(traccia);
    }

    public String toString(Traccia traccia) throws ProtocolException {
        return this.tracciaProtocolBuilder.toString(traccia);
    }
}

