/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.archive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaApplicativaByNome;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteComuneServizioCompostoServizioComponente;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.ProprietariDocumento;
import org.openspcoop2.core.registry.constants.RuoliDocumento;
import org.openspcoop2.core.registry.constants.StatiAccordo;
import org.openspcoop2.core.registry.constants.TipologiaServizio;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicerca;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.ValidazioneStatoPackageException;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.utils.XMLDataConverter;
import org.openspcoop2.core.registry.wsdl.RegistroOpenSPCoopUtilities;
import org.openspcoop2.message.XMLUtils;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.archive.AbstractArchiveEngine;
import org.openspcoop2.protocol.engine.archive.ImportInformationMissingException;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.archive.Archive;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoCooperazione;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioComposto;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteComune;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteSpecifica;
import org.openspcoop2.protocol.sdk.archive.ArchiveEsitoImport;
import org.openspcoop2.protocol.sdk.archive.ArchiveEsitoImportDetail;
import org.openspcoop2.protocol.sdk.archive.ArchiveEsitoImportDetailConfigurazione;
import org.openspcoop2.protocol.sdk.archive.ArchiveFruitore;
import org.openspcoop2.protocol.sdk.archive.ArchivePdd;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaApplicativa;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaDelegata;
import org.openspcoop2.protocol.sdk.archive.ArchiveServizioApplicativo;
import org.openspcoop2.protocol.sdk.archive.ArchiveSoggetto;
import org.openspcoop2.protocol.sdk.archive.IArchiveObject;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.protocol.sdk.constants.ArchiveStatoImport;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.wsdl.DefinitionWrapper;
import org.openspcoop2.utils.xml.AbstractXMLUtils;

public class ImporterArchiveUtils {
    private AbstractArchiveEngine importerEngine;
    private Logger log;
    private String userLogin;
    private boolean gestioneWorkflowStatiAccordi;
    private boolean updateAbilitato;
    private String nomePddOperativa;
    private String tipoPddDefault;
    private ProtocolFactoryManager protocolFactoryManager;
    private IDAccordoCooperazioneFactory idAccordoCooperazioneFactory;
    private IDAccordoFactory idAccordoFactory;

    public ImporterArchiveUtils(AbstractArchiveEngine importerEngine, Logger log, String userLogin, String nomePddOperativa, String tipoPddDefault, boolean gestioneWorkflowStatiAccordi, boolean updateAbilitato) throws Exception {
        this.importerEngine = importerEngine;
        this.log = log;
        this.userLogin = userLogin;
        this.gestioneWorkflowStatiAccordi = gestioneWorkflowStatiAccordi;
        this.updateAbilitato = updateAbilitato;
        if (nomePddOperativa != null) {
            this.nomePddOperativa = nomePddOperativa;
        } else {
            FiltroRicerca filtroRicerca = new FiltroRicerca();
            filtroRicerca.setTipo("operativo");
            List<String> pdd = this.importerEngine.getAllIdPorteDominio(filtroRicerca);
            if (pdd.size() <= 0) {
                throw new Exception("Pdd operative non trovate nel registro");
            }
            if (pdd.size() > 1) {
                throw new Exception("Riscontrate piu' di una porta di dominio operativa");
            }
            this.nomePddOperativa = pdd.get(0);
        }
        this.tipoPddDefault = tipoPddDefault;
        if (this.tipoPddDefault == null) {
            this.tipoPddDefault = "esterno";
        }
        this.protocolFactoryManager = ProtocolFactoryManager.getInstance();
        this.idAccordoCooperazioneFactory = IDAccordoCooperazioneFactory.getInstance();
        this.idAccordoFactory = IDAccordoFactory.getInstance();
    }

    public ArchiveEsitoImport importArchive(Archive archive, String userLogin, boolean utilizzoAzioniDiretteInAccordoAbilitato, boolean isAbilitatoControlloUnicitaImplementazioneAccordoPerSoggetto, boolean isAbilitatoControlloUnicitaImplementazionePortTypePerSoggetto) throws Exception, ImportInformationMissingException {
        ArchiveEsitoImportDetail detail;
        ArchiveAccordoServizioParteSpecifica archiveAccordoServizioParteSpecifica;
        int i;
        ArchiveEsitoImportDetail detail2;
        int i2;
        ArchiveEsitoImport esito = new ArchiveEsitoImport();
        for (i2 = 0; i2 < archive.getPdd().size(); ++i2) {
            ArchivePdd archivePdd = (ArchivePdd)archive.getPdd().get(i2);
            detail2 = new ArchiveEsitoImportDetail((IArchiveObject)archivePdd);
            try {
                this.importPdd(archivePdd, detail2);
            }
            catch (Exception e) {
                detail2.setState(ArchiveStatoImport.ERROR);
                detail2.setException((Throwable)e);
            }
            esito.getPdd().add((Object)detail2);
        }
        for (i2 = 0; i2 < archive.getSoggetti().size(); ++i2) {
            ArchiveSoggetto archiveSoggetto = (ArchiveSoggetto)archive.getSoggetti().get(i2);
            detail2 = new ArchiveEsitoImportDetail((IArchiveObject)archiveSoggetto);
            try {
                this.importSoggetto(archiveSoggetto, detail2);
            }
            catch (Exception e) {
                detail2.setState(ArchiveStatoImport.ERROR);
                detail2.setException((Throwable)e);
            }
            esito.getSoggetti().add((Object)detail2);
        }
        for (i2 = 0; i2 < archive.getServiziApplicativi().size(); ++i2) {
            ArchiveServizioApplicativo archiveServizioApplicativo = (ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i2);
            detail2 = new ArchiveEsitoImportDetail((IArchiveObject)archiveServizioApplicativo);
            try {
                archiveServizioApplicativo.update();
                this.importServizioApplicativo(archiveServizioApplicativo, detail2);
            }
            catch (Exception e) {
                detail2.setState(ArchiveStatoImport.ERROR);
                detail2.setException((Throwable)e);
            }
            esito.getServiziApplicativi().add((Object)detail2);
        }
        for (i2 = 0; i2 < archive.getAccordiCooperazione().size(); ++i2) {
            ArchiveAccordoCooperazione archiveAccordoCooperazione = (ArchiveAccordoCooperazione)archive.getAccordiCooperazione().get(i2);
            detail2 = new ArchiveEsitoImportDetail((IArchiveObject)archiveAccordoCooperazione);
            try {
                archiveAccordoCooperazione.update();
                this.importAccordoCooperazione(archiveAccordoCooperazione, detail2);
            }
            catch (Exception e) {
                detail2.setState(ArchiveStatoImport.ERROR);
                detail2.setException((Throwable)e);
            }
            esito.getAccordiCooperazione().add((Object)detail2);
        }
        for (i2 = 0; i2 < archive.getAccordiServizioParteComune().size(); ++i2) {
            ArchiveAccordoServizioParteComune archiveAccordoServizioParteComune = (ArchiveAccordoServizioParteComune)archive.getAccordiServizioParteComune().get(i2);
            detail2 = new ArchiveEsitoImportDetail((IArchiveObject)archiveAccordoServizioParteComune);
            try {
                archiveAccordoServizioParteComune.update();
                this.importAccordoServizioParteComune(archiveAccordoServizioParteComune, utilizzoAzioniDiretteInAccordoAbilitato, detail2);
            }
            catch (Exception e) {
                detail2.setState(ArchiveStatoImport.ERROR);
                detail2.setException((Throwable)e);
            }
            esito.getAccordiServizioParteComune().add((Object)detail2);
        }
        ArrayList<ArchiveAccordoServizioParteSpecifica> listAccordiServizioParteSpecifica = new ArrayList<ArchiveAccordoServizioParteSpecifica>();
        ArrayList<ArchiveAccordoServizioParteSpecifica> listAccordiServizioParteSpecifica_serviziComposti = new ArrayList<ArchiveAccordoServizioParteSpecifica>();
        for (i = 0; i < archive.getAccordiServizioParteSpecifica().size(); ++i) {
            archiveAccordoServizioParteSpecifica = (ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i);
            archiveAccordoServizioParteSpecifica.update();
            IDAccordo idAccordo = archiveAccordoServizioParteSpecifica.getIdAccordoServizioParteComune();
            if (this.importerEngine.existsAccordoServizioParteComune(idAccordo)) {
                AccordoServizioParteComune aspc = this.importerEngine.getAccordoServizioParteComune(idAccordo);
                if (aspc.getServizioComposto() != null) {
                    listAccordiServizioParteSpecifica_serviziComposti.add(archiveAccordoServizioParteSpecifica);
                    continue;
                }
                listAccordiServizioParteSpecifica.add(archiveAccordoServizioParteSpecifica);
                continue;
            }
            listAccordiServizioParteSpecifica_serviziComposti.add(archiveAccordoServizioParteSpecifica);
        }
        for (i = 0; i < listAccordiServizioParteSpecifica.size(); ++i) {
            archiveAccordoServizioParteSpecifica = (ArchiveAccordoServizioParteSpecifica)listAccordiServizioParteSpecifica.get(i);
            detail = new ArchiveEsitoImportDetail((IArchiveObject)archiveAccordoServizioParteSpecifica);
            try {
                this.importAccordoServizioParteSpecifica(archiveAccordoServizioParteSpecifica, false, isAbilitatoControlloUnicitaImplementazioneAccordoPerSoggetto, isAbilitatoControlloUnicitaImplementazionePortTypePerSoggetto, detail);
            }
            catch (Exception e) {
                detail.setState(ArchiveStatoImport.ERROR);
                detail.setException((Throwable)e);
            }
            esito.getAccordiServizioParteSpecifica().add((Object)detail);
        }
        for (i = 0; i < archive.getAccordiServizioComposto().size(); ++i) {
            ArchiveAccordoServizioComposto archiveAccordoServizioComposto = (ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i);
            detail = new ArchiveEsitoImportDetail((IArchiveObject)archiveAccordoServizioComposto);
            try {
                archiveAccordoServizioComposto.update();
                this.importAccordoServizioComposto(archiveAccordoServizioComposto, utilizzoAzioniDiretteInAccordoAbilitato, detail);
            }
            catch (Exception e) {
                detail.setState(ArchiveStatoImport.ERROR);
                detail.setException((Throwable)e);
            }
            esito.getAccordiServizioComposto().add((Object)detail);
        }
        for (i = 0; i < listAccordiServizioParteSpecifica_serviziComposti.size(); ++i) {
            archiveAccordoServizioParteSpecifica = (ArchiveAccordoServizioParteSpecifica)listAccordiServizioParteSpecifica_serviziComposti.get(i);
            detail = new ArchiveEsitoImportDetail((IArchiveObject)archiveAccordoServizioParteSpecifica);
            try {
                this.importAccordoServizioParteSpecifica(archiveAccordoServizioParteSpecifica, true, isAbilitatoControlloUnicitaImplementazioneAccordoPerSoggetto, isAbilitatoControlloUnicitaImplementazionePortTypePerSoggetto, detail);
            }
            catch (Exception e) {
                detail.setState(ArchiveStatoImport.ERROR);
                detail.setException((Throwable)e);
            }
            esito.getAccordiServizioParteSpecificaServiziComposti().add((Object)detail);
        }
        for (i = 0; i < archive.getAccordiFruitori().size(); ++i) {
            ArchiveFruitore archiveFruitore = (ArchiveFruitore)archive.getAccordiFruitori().get(i);
            detail = new ArchiveEsitoImportDetail((IArchiveObject)archiveFruitore);
            try {
                archiveFruitore.update();
                this.importFruitore(archiveFruitore, detail);
            }
            catch (Exception e) {
                detail.setState(ArchiveStatoImport.ERROR);
                detail.setException((Throwable)e);
            }
            esito.getAccordiFruitori().add((Object)detail);
        }
        for (i = 0; i < archive.getPorteDelegate().size(); ++i) {
            ArchivePortaDelegata archivePortaDelegata = (ArchivePortaDelegata)archive.getPorteDelegate().get(i);
            detail = new ArchiveEsitoImportDetail((IArchiveObject)archivePortaDelegata);
            try {
                archivePortaDelegata.update();
                this.importPortaDelegata(archivePortaDelegata, detail);
            }
            catch (Exception e) {
                detail.setState(ArchiveStatoImport.ERROR);
                detail.setException((Throwable)e);
            }
            esito.getPorteDelegate().add((Object)detail);
        }
        for (i = 0; i < archive.getPorteApplicative().size(); ++i) {
            ArchivePortaApplicativa archivePortaApplicativa = (ArchivePortaApplicativa)archive.getPorteApplicative().get(i);
            detail = new ArchiveEsitoImportDetail((IArchiveObject)archivePortaApplicativa);
            try {
                archivePortaApplicativa.update();
                this.importPortaApplicativa(archivePortaApplicativa, detail);
            }
            catch (Exception e) {
                detail.setState(ArchiveStatoImport.ERROR);
                detail.setException((Throwable)e);
            }
            esito.getPorteApplicative().add((Object)detail);
        }
        if (archive.getConfigurazionePdD() != null) {
            Configurazione configurazione = archive.getConfigurazionePdD();
            ArchiveEsitoImportDetailConfigurazione detail3 = new ArchiveEsitoImportDetailConfigurazione(configurazione);
            try {
                this.importConfigurazione(configurazione, detail3);
            }
            catch (Exception e) {
                detail3.setState(ArchiveStatoImport.ERROR);
                detail3.setException((Throwable)e);
            }
            esito.setConfigurazionePdD(detail3);
        }
        return esito;
    }

    public void importPdd(ArchivePdd archivePdd, ArchiveEsitoImportDetail detail) {
        String nomePdd = archivePdd.getNomePdd();
        try {
            if (!this.updateAbilitato && this.importerEngine.existsPortaDominio(nomePdd)) {
                detail.setState(ArchiveStatoImport.UPDATE_NOT_PERMISSED);
                return;
            }
            archivePdd.getPortaDominio().setSuperUser(this.userLogin);
            XMLDataConverter.impostaInformazioniRegistroDB_PortaDominio((PortaDominio)archivePdd.getPortaDominio());
            archivePdd.getPortaDominio().setOraRegistrazione(DateManager.getDate());
            boolean create = false;
            if (this.importerEngine.existsPortaDominio(nomePdd)) {
                PortaDominio old = this.importerEngine.getPortaDominio(nomePdd);
                archivePdd.getPortaDominio().setId(old.getId());
                if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(old.getSuperUser())) {
                    throw new Exception("La porta di dominio non \u00e8 visibile/aggiornabile dall'utente collegato (" + this.userLogin + ")");
                }
                this.importerEngine.updatePortaDominio(archivePdd.getPortaDominio());
                create = false;
            } else {
                this.importerEngine.createPortaDominio(archivePdd.getPortaDominio());
                create = true;
            }
            XMLDataConverter.impostaInformazioniRegistroDB_PortaDominio_update((PortaDominio)archivePdd.getPortaDominio(), (String)this.nomePddOperativa, (Logger)this.log, (DriverRegistroServiziDB)this.importerEngine.getDriverRegistroServizi(), (String)this.tipoPddDefault);
            if (create) {
                detail.setState(ArchiveStatoImport.CREATED);
            } else {
                detail.setState(ArchiveStatoImport.UPDATED);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante l'import della porta di dominio [" + nomePdd + "]: " + e.getMessage()), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void importSoggetto(ArchiveSoggetto archiveSoggetto, ArchiveEsitoImportDetail detail) {
        IDSoggetto idSoggetto = archiveSoggetto.getIdSoggetto();
        try {
            org.openspcoop2.core.config.Soggetto old;
            ITraduttore traduttore;
            IProtocolFactory protocolFactory;
            boolean create = false;
            if (archiveSoggetto.getSoggettoRegistro() != null) {
                if (!this.updateAbilitato && this.importerEngine.existsSoggettoRegistro(idSoggetto)) {
                    detail.setState(ArchiveStatoImport.UPDATE_NOT_PERMISSED);
                    return;
                }
                if (archiveSoggetto.getSoggettoRegistro().getPortaDominio() != null && !this.importerEngine.existsPortaDominio(archiveSoggetto.getSoggettoRegistro().getPortaDominio())) {
                    throw new Exception("Porta di dominio [" + archiveSoggetto.getSoggettoRegistro().getPortaDominio() + "] associata non esiste");
                }
                XMLDataConverter.impostaInformazioniRegistroDB_Soggetto((Soggetto)archiveSoggetto.getSoggettoRegistro(), (String)this.nomePddOperativa);
                archiveSoggetto.getSoggettoRegistro().setSuperUser(this.userLogin);
                if (archiveSoggetto.getSoggettoRegistro().getCodiceIpa() == null || archiveSoggetto.getSoggettoRegistro().getIdentificativoPorta() == null) {
                    protocolFactory = this.protocolFactoryManager.getProtocolFactoryBySubjectType(idSoggetto.getTipo());
                    traduttore = protocolFactory.createTraduttore();
                    if (archiveSoggetto.getSoggettoRegistro().getCodiceIpa() == null) {
                        archiveSoggetto.getSoggettoRegistro().setCodiceIpa(traduttore.getIdentificativoCodiceIPADefault(idSoggetto, false));
                    }
                    if (archiveSoggetto.getSoggettoRegistro().getIdentificativoPorta() == null) {
                        archiveSoggetto.getSoggettoRegistro().setIdentificativoPorta(traduttore.getIdentificativoPortaDefault(idSoggetto));
                    }
                }
                archiveSoggetto.getSoggettoRegistro().setOraRegistrazione(DateManager.getDate());
                if (this.importerEngine.existsSoggettoRegistro(idSoggetto)) {
                    old = this.importerEngine.getSoggettoRegistro(idSoggetto);
                    archiveSoggetto.getSoggettoRegistro().setId(old.getId());
                    archiveSoggetto.getSoggettoRegistro().setOldTipoForUpdate(old.getTipo());
                    archiveSoggetto.getSoggettoRegistro().setOldNomeForUpdate(old.getNome());
                    XMLDataConverter.impostaInformazioniRegistroDB_Soggetto_update((Soggetto)archiveSoggetto.getSoggettoRegistro(), (Soggetto)old);
                    if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(old.getSuperUser())) {
                        throw new Exception("Il soggetto non \u00e8 visibile/aggiornabile dall'utente collegato (" + this.userLogin + ")");
                    }
                    this.importerEngine.updateSoggettoRegistro(archiveSoggetto.getSoggettoRegistro());
                } else {
                    this.importerEngine.createSoggettoRegistro(archiveSoggetto.getSoggettoRegistro());
                    create = true;
                }
            }
            if (archiveSoggetto.getSoggettoConfigurazione() != null) {
                if (!this.updateAbilitato && this.importerEngine.existsSoggettoConfigurazione(idSoggetto) && !create) {
                    detail.setState(ArchiveStatoImport.UPDATE_NOT_PERMISSED);
                    return;
                }
                archiveSoggetto.getSoggettoConfigurazione().setSuperUser(this.userLogin);
                if (archiveSoggetto.getSoggettoConfigurazione().getIdentificativoPorta() == null) {
                    protocolFactory = this.protocolFactoryManager.getProtocolFactoryBySubjectType(idSoggetto.getTipo());
                    traduttore = protocolFactory.createTraduttore();
                    if (archiveSoggetto.getSoggettoConfigurazione().getIdentificativoPorta() == null) {
                        archiveSoggetto.getSoggettoConfigurazione().setIdentificativoPorta(traduttore.getIdentificativoPortaDefault(idSoggetto));
                    }
                }
                archiveSoggetto.getSoggettoConfigurazione().setOraRegistrazione(DateManager.getDate());
                if (this.importerEngine.existsSoggettoConfigurazione(idSoggetto)) {
                    old = this.importerEngine.getSoggettoConfigurazione(idSoggetto);
                    archiveSoggetto.getSoggettoConfigurazione().setId(old.getId());
                    archiveSoggetto.getSoggettoRegistro().setOldTipoForUpdate(old.getTipo());
                    archiveSoggetto.getSoggettoRegistro().setOldNomeForUpdate(old.getNome());
                    if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(old.getSuperUser())) {
                        throw new Exception("Il soggetto non \u00e8 visibile/aggiornabile dall'utente collegato (" + this.userLogin + ")");
                    }
                    this.importerEngine.updateSoggettoConfigurazione(archiveSoggetto.getSoggettoConfigurazione());
                } else {
                    this.importerEngine.createSoggettoConfigurazione(archiveSoggetto.getSoggettoConfigurazione());
                    create = true;
                }
            }
            if (create) {
                detail.setState(ArchiveStatoImport.CREATED);
            } else {
                detail.setState(ArchiveStatoImport.UPDATED);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante l'import del soggetto [" + idSoggetto + "]: " + e.getMessage()), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void importServizioApplicativo(ArchiveServizioApplicativo archiveServizioApplicativo, ArchiveEsitoImportDetail detail) {
        IDServizioApplicativo idServizioApplicativo = archiveServizioApplicativo.getIdServizioApplicativo();
        IDSoggetto idSoggettoProprietario = archiveServizioApplicativo.getIdSoggettoProprietario();
        try {
            if (!this.updateAbilitato && this.importerEngine.existsServizioApplicativo(idServizioApplicativo)) {
                detail.setState(ArchiveStatoImport.UPDATE_NOT_PERMISSED);
                return;
            }
            if (!this.importerEngine.existsSoggettoConfigurazione(idSoggettoProprietario)) {
                throw new Exception("Soggetto proprietario [" + idSoggettoProprietario + "] non esistente");
            }
            org.openspcoop2.core.config.Soggetto soggetto = this.importerEngine.getSoggettoConfigurazione(idSoggettoProprietario);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggetto.getSuperUser())) {
                throw new Exception("Il soggetto proprietario [" + idSoggettoProprietario + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
            }
            org.openspcoop2.core.config.driver.utils.XMLDataConverter.impostaInformazioniConfigurazione_ServizioApplicativo((ServizioApplicativo)archiveServizioApplicativo.getServizioApplicativo(), (org.openspcoop2.core.config.Soggetto)soggetto, (String)"", (Logger)this.log, (String)"db");
            archiveServizioApplicativo.getServizioApplicativo().setOraRegistrazione(DateManager.getDate());
            if (this.importerEngine.existsServizioApplicativo(idServizioApplicativo)) {
                ServizioApplicativo old = this.importerEngine.getServizioApplicativo(idServizioApplicativo);
                archiveServizioApplicativo.getServizioApplicativo().setId(old.getId());
                archiveServizioApplicativo.getServizioApplicativo().setOldNomeForUpdate(old.getNome());
                archiveServizioApplicativo.getServizioApplicativo().setOldTipoSoggettoProprietarioForUpdate(old.getTipoSoggettoProprietario());
                archiveServizioApplicativo.getServizioApplicativo().setOldNomeSoggettoProprietarioForUpdate(old.getNomeSoggettoProprietario());
                org.openspcoop2.core.config.driver.utils.XMLDataConverter.impostaInformazioniConfigurazione_ServizioApplicativo_update((ServizioApplicativo)archiveServizioApplicativo.getServizioApplicativo(), (ServizioApplicativo)old);
                this.importerEngine.updateServizioApplicativo(archiveServizioApplicativo.getServizioApplicativo());
                detail.setState(ArchiveStatoImport.UPDATED);
            } else {
                this.importerEngine.createServizioApplicativo(archiveServizioApplicativo.getServizioApplicativo());
                detail.setState(ArchiveStatoImport.CREATED);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante l'import del servizio applicativo [" + idServizioApplicativo + "]: " + e.getMessage()), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void importAccordoCooperazione(ArchiveAccordoCooperazione archiveAccordoCooperazione, ArchiveEsitoImportDetail detail) {
        IDAccordoCooperazione idAccordoCooperazione = archiveAccordoCooperazione.getIdAccordoCooperazione();
        IDSoggetto idSoggettoReferente = archiveAccordoCooperazione.getIdSoggettoReferente();
        List idSoggettiPartecipanti = archiveAccordoCooperazione.getIdSoggettiPartecipanti();
        try {
            int i;
            if (!this.updateAbilitato && this.importerEngine.existsAccordoCooperazione(idAccordoCooperazione)) {
                detail.setState(ArchiveStatoImport.UPDATE_NOT_PERMISSED);
                return;
            }
            if (!this.importerEngine.existsSoggettoRegistro(idSoggettoReferente)) {
                throw new Exception("Soggetto proprietario [" + idSoggettoReferente + "] non esistente");
            }
            if (idSoggettiPartecipanti != null) {
                for (IDSoggetto idSoggettoPartecipante : idSoggettiPartecipanti) {
                    if (this.importerEngine.existsSoggettoRegistro(idSoggettoPartecipante)) continue;
                    throw new Exception("Soggetto partecipante [" + idSoggettoPartecipante + "] non esistente");
                }
            }
            String protocolloAssociatoAccordo = this.protocolFactoryManager.getProtocolBySubjectType(idSoggettoReferente.getTipo());
            if (idSoggettiPartecipanti != null) {
                for (IDSoggetto idSoggettoPartecipante : idSoggettiPartecipanti) {
                    String protocolloAssociatoSoggettoPartecipante = this.protocolFactoryManager.getProtocolBySubjectType(idSoggettoPartecipante.getTipo());
                    if (protocolloAssociatoAccordo.equals(protocolloAssociatoSoggettoPartecipante)) continue;
                    throw new Exception("Soggetto partecipante [" + idSoggettoPartecipante + "] (protocollo:" + protocolloAssociatoSoggettoPartecipante + ") non utilizzabile in un accordo con soggetto referente [" + idSoggettoReferente + "] (protocollo:" + protocolloAssociatoAccordo + ")");
                }
            }
            Soggetto soggetto = this.importerEngine.getSoggettoRegistro(idSoggettoReferente);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggetto.getSuperUser())) {
                throw new Exception("Il soggetto referente [" + idSoggettoReferente + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
            }
            if (idSoggettiPartecipanti != null) {
                for (IDSoggetto idSoggettoPartecipante : idSoggettiPartecipanti) {
                    Soggetto soggettoPartecipante = this.importerEngine.getSoggettoRegistro(idSoggettoPartecipante);
                    if (this.importerEngine.isVisioneOggettiGlobale(this.userLogin) || this.userLogin.equals(soggettoPartecipante.getSuperUser())) continue;
                    throw new Exception("Il soggetto partecipante [" + idSoggettoPartecipante + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
                }
            }
            archiveAccordoCooperazione.getAccordoCooperazione().setSuperUser(this.userLogin);
            for (i = 0; i < archiveAccordoCooperazione.getAccordoCooperazione().sizeAllegatoList(); ++i) {
                archiveAccordoCooperazione.getAccordoCooperazione().getAllegato(i).setRuolo(RuoliDocumento.allegato.toString());
                archiveAccordoCooperazione.getAccordoCooperazione().getAllegato(i).setTipoProprietarioDocumento(ProprietariDocumento.accordoCooperazione.toString());
            }
            for (i = 0; i < archiveAccordoCooperazione.getAccordoCooperazione().sizeSpecificaSemiformaleList(); ++i) {
                archiveAccordoCooperazione.getAccordoCooperazione().getSpecificaSemiformale(i).setRuolo(RuoliDocumento.specificaSemiformale.toString());
                archiveAccordoCooperazione.getAccordoCooperazione().getSpecificaSemiformale(i).setTipoProprietarioDocumento(ProprietariDocumento.accordoCooperazione.toString());
            }
            StringBuffer warningInfoStatoFinale = new StringBuffer("");
            if (archiveAccordoCooperazione.getAccordoCooperazione().getStatoPackage() == null) {
                if (this.gestioneWorkflowStatiAccordi) {
                    try {
                        archiveAccordoCooperazione.getAccordoCooperazione().setStatoPackage(StatiAccordo.finale.toString());
                        this.importerEngine.validaStatoAccordoCooperazione(archiveAccordoCooperazione.getAccordoCooperazione());
                    }
                    catch (ValidazioneStatoPackageException validazioneException) {
                        try {
                            archiveAccordoCooperazione.getAccordoCooperazione().setStatoPackage(StatiAccordo.operativo.toString());
                            this.importerEngine.validaStatoAccordoCooperazione(archiveAccordoCooperazione.getAccordoCooperazione());
                        }
                        catch (ValidazioneStatoPackageException validazioneExceptionLevelOperativo) {
                            warningInfoStatoFinale.append("\n\t\t(WARNING) Accordo salvato con stato '").append(StatiAccordo.bozza.toString()).append("'\n\t\t\t");
                            warningInfoStatoFinale.append(validazioneException.toString("\n\t\t\t - ", "\n\t\t\t - "));
                            warningInfoStatoFinale.append("\n\t\t\t" + validazioneExceptionLevelOperativo.toString("\n\t\t\t - ", "\n\t\t\t - "));
                            archiveAccordoCooperazione.getAccordoCooperazione().setStatoPackage(StatiAccordo.bozza.toString());
                        }
                    }
                } else {
                    archiveAccordoCooperazione.getAccordoCooperazione().setStatoPackage(StatiAccordo.finale.toString());
                }
            }
            archiveAccordoCooperazione.getAccordoCooperazione().setOraRegistrazione(DateManager.getDate());
            if (this.importerEngine.existsAccordoCooperazione(idAccordoCooperazione)) {
                AccordoCooperazione old = this.importerEngine.getAccordoCooperazione(idAccordoCooperazione);
                archiveAccordoCooperazione.getAccordoCooperazione().setId(old.getId());
                archiveAccordoCooperazione.getAccordoCooperazione().setOldIDAccordoForUpdate(this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(old));
                if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(old.getSuperUser())) {
                    throw new Exception("L'accordo non \u00e8 visibile/aggiornabile dall'utente collegato (" + this.userLogin + ")");
                }
                this.importerEngine.updateAccordoCooperazione(archiveAccordoCooperazione.getAccordoCooperazione());
                detail.setState(ArchiveStatoImport.UPDATED);
                detail.setStateDetail(warningInfoStatoFinale.toString());
            } else {
                this.importerEngine.createAccordoCooperazione(archiveAccordoCooperazione.getAccordoCooperazione());
                detail.setState(ArchiveStatoImport.CREATED);
                detail.setStateDetail(warningInfoStatoFinale.toString());
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante l'import dell'accordo di cooperazione [" + idAccordoCooperazione + "]: " + e.getMessage()), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void importAccordoServizioParteComune(ArchiveAccordoServizioParteComune archiveAccordoServizioParteComune, boolean utilizzoAzioniDiretteInAccordoAbilitato, ArchiveEsitoImportDetail detail) {
        IDAccordo idAccordoServizioParteComune = archiveAccordoServizioParteComune.getIdAccordoServizioParteComune();
        IDSoggetto idSoggettoReferente = archiveAccordoServizioParteComune.getIdSoggettoReferente();
        try {
            int i;
            if (!this.updateAbilitato && this.importerEngine.existsAccordoServizioParteComune(idAccordoServizioParteComune)) {
                detail.setState(ArchiveStatoImport.UPDATE_NOT_PERMISSED);
                return;
            }
            if (!this.importerEngine.existsSoggettoRegistro(idSoggettoReferente)) {
                throw new Exception("Soggetto proprietario [" + idSoggettoReferente + "] non esistente");
            }
            Soggetto soggetto = this.importerEngine.getSoggettoRegistro(idSoggettoReferente);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggetto.getSuperUser())) {
                throw new Exception("Il soggetto referente [" + idSoggettoReferente + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
            }
            XMLDataConverter.impostaInformazioniRegistroDB_AccordoServizioParteComune((AccordoServizioParteComune)archiveAccordoServizioParteComune.getAccordoServizioParteComune());
            archiveAccordoServizioParteComune.getAccordoServizioParteComune().setSuperUser(this.userLogin);
            for (i = 0; i < archiveAccordoServizioParteComune.getAccordoServizioParteComune().sizeAllegatoList(); ++i) {
                archiveAccordoServizioParteComune.getAccordoServizioParteComune().getAllegato(i).setRuolo(RuoliDocumento.allegato.toString());
                archiveAccordoServizioParteComune.getAccordoServizioParteComune().getAllegato(i).setTipoProprietarioDocumento(ProprietariDocumento.accordoServizio.toString());
            }
            for (i = 0; i < archiveAccordoServizioParteComune.getAccordoServizioParteComune().sizeSpecificaSemiformaleList(); ++i) {
                archiveAccordoServizioParteComune.getAccordoServizioParteComune().getSpecificaSemiformale(i).setRuolo(RuoliDocumento.specificaSemiformale.toString());
                archiveAccordoServizioParteComune.getAccordoServizioParteComune().getSpecificaSemiformale(i).setTipoProprietarioDocumento(ProprietariDocumento.accordoServizio.toString());
            }
            StringBuffer warningInfoStatoFinale = new StringBuffer("");
            if (archiveAccordoServizioParteComune.getAccordoServizioParteComune().getStatoPackage() == null) {
                if (this.gestioneWorkflowStatiAccordi) {
                    try {
                        archiveAccordoServizioParteComune.getAccordoServizioParteComune().setStatoPackage(StatiAccordo.finale.toString());
                        this.importerEngine.validaStatoAccordoServizioParteComune(archiveAccordoServizioParteComune.getAccordoServizioParteComune(), utilizzoAzioniDiretteInAccordoAbilitato);
                    }
                    catch (ValidazioneStatoPackageException validazioneException) {
                        try {
                            archiveAccordoServizioParteComune.getAccordoServizioParteComune().setStatoPackage(StatiAccordo.operativo.toString());
                            this.importerEngine.validaStatoAccordoServizioParteComune(archiveAccordoServizioParteComune.getAccordoServizioParteComune(), utilizzoAzioniDiretteInAccordoAbilitato);
                        }
                        catch (ValidazioneStatoPackageException validazioneExceptionLevelOperativo) {
                            warningInfoStatoFinale.append("\n\t\t(WARNING) Accordo salvato con stato '").append(StatiAccordo.bozza.toString()).append("':\n\t\t\t");
                            warningInfoStatoFinale.append(validazioneException.toString("\n\t\t\t - ", "\n\t\t\t - "));
                            warningInfoStatoFinale.append("\n\t\t\t" + validazioneExceptionLevelOperativo.toString("\n\t\t\t - ", "\n\t\t\t - "));
                            archiveAccordoServizioParteComune.getAccordoServizioParteComune().setStatoPackage(StatiAccordo.bozza.toString());
                        }
                    }
                } else {
                    archiveAccordoServizioParteComune.getAccordoServizioParteComune().setStatoPackage(StatiAccordo.finale.toString());
                }
            }
            StringBuffer warningAderenzaWSDL = new StringBuffer("");
            this.informazioniServizioAderentiWSDL(archiveAccordoServizioParteComune.getAccordoServizioParteComune(), warningAderenzaWSDL);
            archiveAccordoServizioParteComune.getAccordoServizioParteComune().setOraRegistrazione(DateManager.getDate());
            if (this.importerEngine.existsAccordoServizioParteComune(idAccordoServizioParteComune)) {
                AccordoServizioParteComune old = this.importerEngine.getAccordoServizioParteComune(idAccordoServizioParteComune);
                archiveAccordoServizioParteComune.getAccordoServizioParteComune().setId(old.getId());
                archiveAccordoServizioParteComune.getAccordoServizioParteComune().setOldIDAccordoForUpdate(this.idAccordoFactory.getIDAccordoFromAccordo(old));
                if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(old.getSuperUser())) {
                    throw new Exception("L'accordo non \u00e8 visibile/aggiornabile dall'utente collegato (" + this.userLogin + ")");
                }
                this.importerEngine.updateAccordoServizioParteComune(archiveAccordoServizioParteComune.getAccordoServizioParteComune());
                detail.setState(ArchiveStatoImport.UPDATED);
                detail.setStateDetail(warningInfoStatoFinale.toString() + warningAderenzaWSDL.toString());
            } else {
                this.importerEngine.createAccordoServizioParteComune(archiveAccordoServizioParteComune.getAccordoServizioParteComune());
                detail.setState(ArchiveStatoImport.CREATED);
                detail.setStateDetail(warningInfoStatoFinale.toString() + warningAderenzaWSDL.toString());
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante l'import dell'accordo di servizio parte comune [" + idAccordoServizioParteComune + "]: " + e.getMessage()), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void importAccordoServizioComposto(ArchiveAccordoServizioComposto archiveAccordoServizioComposto, boolean utilizzoAzioniDiretteInAccordoAbilitato, ArchiveEsitoImportDetail detail) {
        IDAccordo idAccordoServizioComposto = archiveAccordoServizioComposto.getIdAccordoServizioParteComune();
        IDSoggetto idSoggettoReferente = archiveAccordoServizioComposto.getIdSoggettoReferente();
        IDAccordoCooperazione idAccordoCooperazione = archiveAccordoServizioComposto.getIdAccordoCooperazione();
        List idServiziComponenti = archiveAccordoServizioComposto.getIdServiziComponenti();
        try {
            int i;
            AccordoCooperazione ac;
            String protocolloAssociatoAccordoCooperazione;
            if (!this.updateAbilitato && this.importerEngine.existsAccordoServizioParteComune(idAccordoServizioComposto)) {
                detail.setState(ArchiveStatoImport.UPDATE_NOT_PERMISSED);
                return;
            }
            if (!this.importerEngine.existsSoggettoRegistro(idSoggettoReferente)) {
                throw new Exception("Soggetto proprietario [" + idSoggettoReferente + "] non esistente");
            }
            if (!this.importerEngine.existsAccordoCooperazione(idAccordoCooperazione)) {
                throw new Exception("Accordo di Cooperazione [" + idAccordoCooperazione + "] riferito non esistente");
            }
            for (IDServizio idServizioComponente : idServiziComponenti) {
                if (this.importerEngine.existsAccordoServizioParteSpecifica(idServizioComponente)) continue;
                throw new Exception("ServizioComponente [" + idServizioComponente + "] riferito non esistente");
            }
            String protocolloAssociatoAccordo = this.protocolFactoryManager.getProtocolBySubjectType(idSoggettoReferente.getTipo());
            if (!protocolloAssociatoAccordo.equals(protocolloAssociatoAccordoCooperazione = this.protocolFactoryManager.getProtocolBySubjectType((ac = this.importerEngine.getAccordoCooperazione(idAccordoCooperazione)).getSoggettoReferente().getTipo()))) {
                throw new Exception("Soggetto referente (" + ac.getSoggettoReferente().getTipo() + "/" + ac.getSoggettoReferente().getNome() + ") dell'accordo di cooperazione [" + idAccordoCooperazione + "] (protocollo:" + protocolloAssociatoAccordoCooperazione + ") non utilizzabile in un accordo con soggetto referente [" + idSoggettoReferente + "] (protocollo:" + protocolloAssociatoAccordo + ")");
            }
            for (IDServizio idServizioComponente : idServiziComponenti) {
                String protocolloAssociatoServizioComponente = this.protocolFactoryManager.getProtocolByServiceType(idServizioComponente.getTipoServizio());
                if (!protocolloAssociatoAccordo.equals(protocolloAssociatoServizioComponente)) {
                    throw new Exception("ServizioComponente [" + idServizioComponente + "] (protocollo:" + protocolloAssociatoServizioComponente + ") non utilizzabile in un accordo con soggetto referente [" + idSoggettoReferente + "] (protocollo:" + protocolloAssociatoAccordo + ")");
                }
                String protocolloAssociatoSoggettoServizioComponente = this.protocolFactoryManager.getProtocolBySubjectType(idServizioComponente.getSoggettoErogatore().getTipo());
                if (protocolloAssociatoAccordo.equals(protocolloAssociatoSoggettoServizioComponente)) continue;
                throw new Exception("ServizioComponente [" + idServizioComponente + "] (protocollo:" + protocolloAssociatoSoggettoServizioComponente + ") non utilizzabile in un accordo con soggetto referente [" + idSoggettoReferente + "] (protocollo:" + protocolloAssociatoAccordo + ")");
            }
            Soggetto soggetto = this.importerEngine.getSoggettoRegistro(idSoggettoReferente);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggetto.getSuperUser())) {
                throw new Exception("Il soggetto referente [" + idSoggettoReferente + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
            }
            AccordoCooperazione accordoCooperazione = this.importerEngine.getAccordoCooperazione(idAccordoCooperazione);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(accordoCooperazione.getSuperUser())) {
                throw new Exception("L'accordo di cooperazione [" + idAccordoCooperazione + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
            }
            Hashtable<String, AccordoServizioParteSpecifica> serviziComponenti = new Hashtable<String, AccordoServizioParteSpecifica>();
            for (IDServizio idServizioComponente : idServiziComponenti) {
                AccordoServizioParteSpecifica asps = this.importerEngine.getAccordoServizioParteSpecifica(idServizioComponente);
                serviziComponenti.put(idServizioComponente.toString(), asps);
                if (this.importerEngine.isVisioneOggettiGlobale(this.userLogin)) continue;
                if (!this.userLogin.equals(asps.getSuperUser())) {
                    throw new Exception("Il servizio componente [" + idServizioComponente + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ").");
                }
                Soggetto soggettoErogatoreServizioComponente = this.importerEngine.getSoggettoRegistro(new IDSoggetto(idServizioComponente.getSoggettoErogatore().getTipo(), idServizioComponente.getSoggettoErogatore().getNome()));
                if (this.userLogin.equals(soggettoErogatoreServizioComponente.getSuperUser())) continue;
                throw new Exception("Il servizio componente [" + idServizioComponente + "] (il soggetto erogatore in particolar modo) non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ").");
            }
            XMLDataConverter.impostaInformazioniRegistroDB_AccordoServizioParteComune((AccordoServizioParteComune)archiveAccordoServizioComposto.getAccordoServizioParteComune());
            archiveAccordoServizioComposto.getAccordoServizioParteComune().setSuperUser(this.userLogin);
            for (i = 0; i < archiveAccordoServizioComposto.getAccordoServizioParteComune().sizeAllegatoList(); ++i) {
                archiveAccordoServizioComposto.getAccordoServizioParteComune().getAllegato(i).setRuolo(RuoliDocumento.allegato.toString());
                archiveAccordoServizioComposto.getAccordoServizioParteComune().getAllegato(i).setTipoProprietarioDocumento(ProprietariDocumento.accordoServizio.toString());
            }
            for (i = 0; i < archiveAccordoServizioComposto.getAccordoServizioParteComune().sizeSpecificaSemiformaleList(); ++i) {
                archiveAccordoServizioComposto.getAccordoServizioParteComune().getSpecificaSemiformale(i).setRuolo(RuoliDocumento.specificaSemiformale.toString());
                archiveAccordoServizioComposto.getAccordoServizioParteComune().getSpecificaSemiformale(i).setTipoProprietarioDocumento(ProprietariDocumento.accordoServizio.toString());
            }
            for (i = 0; i < archiveAccordoServizioComposto.getAccordoServizioParteComune().getServizioComposto().sizeSpecificaCoordinamentoList(); ++i) {
                archiveAccordoServizioComposto.getAccordoServizioParteComune().getSpecificaSemiformale(i).setRuolo(RuoliDocumento.specificaCoordinamento.toString());
                archiveAccordoServizioComposto.getAccordoServizioParteComune().getSpecificaSemiformale(i).setTipoProprietarioDocumento(ProprietariDocumento.accordoServizio.toString());
            }
            archiveAccordoServizioComposto.getAccordoServizioParteComune().getServizioComposto().setIdAccordoCooperazione(accordoCooperazione.getId());
            for (i = 0; i < archiveAccordoServizioComposto.getAccordoServizioParteComune().getServizioComposto().sizeServizioComponenteList(); ++i) {
                AccordoServizioParteComuneServizioCompostoServizioComponente componente = archiveAccordoServizioComposto.getAccordoServizioParteComune().getServizioComposto().getServizioComponente(i);
                IDServizio idServizioComponente = new IDServizio(componente.getTipoSoggetto(), componente.getNomeSoggetto(), componente.getTipo(), componente.getNome(), componente.getAzione());
                AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)serviziComponenti.get(idServizioComponente.toString());
                if (asps == null) {
                    Enumeration idServizi = serviziComponenti.keys();
                    StringBuffer bfException = new StringBuffer();
                    while (idServizi.hasMoreElements()) {
                        String idS = (String)idServizi.nextElement();
                        if (bfException.length() > 0) {
                            bfException.append(",");
                        }
                        bfException.append(idS);
                    }
                    throw new Exception("ServizioComponente [" + idServizioComponente + "] riferito non esistente?? Dovrebbe essere stato recuperato? ListaKeys: " + bfException.toString());
                }
                componente.setIdServizioComponente(asps.getId());
            }
            StringBuffer warningInfoStatoFinale = new StringBuffer("");
            if (archiveAccordoServizioComposto.getAccordoServizioParteComune().getStatoPackage() == null) {
                if (this.gestioneWorkflowStatiAccordi) {
                    try {
                        archiveAccordoServizioComposto.getAccordoServizioParteComune().setStatoPackage(StatiAccordo.finale.toString());
                        this.importerEngine.validaStatoAccordoServizioParteComune(archiveAccordoServizioComposto.getAccordoServizioParteComune(), utilizzoAzioniDiretteInAccordoAbilitato);
                    }
                    catch (ValidazioneStatoPackageException validazioneException) {
                        try {
                            archiveAccordoServizioComposto.getAccordoServizioParteComune().setStatoPackage(StatiAccordo.operativo.toString());
                            this.importerEngine.validaStatoAccordoServizioParteComune(archiveAccordoServizioComposto.getAccordoServizioParteComune(), utilizzoAzioniDiretteInAccordoAbilitato);
                        }
                        catch (ValidazioneStatoPackageException validazioneExceptionLevelOperativo) {
                            warningInfoStatoFinale.append("\n\t\t(WARNING) Accordo salvato con stato '").append(StatiAccordo.bozza.toString()).append("':\n\t\t\t");
                            warningInfoStatoFinale.append(validazioneException.toString("\n\t\t\t - ", "\n\t\t\t - "));
                            warningInfoStatoFinale.append("\n\t\t\t" + validazioneExceptionLevelOperativo.toString("\n\t\t\t - ", "\n\t\t\t - "));
                            archiveAccordoServizioComposto.getAccordoServizioParteComune().setStatoPackage(StatiAccordo.bozza.toString());
                        }
                    }
                } else {
                    archiveAccordoServizioComposto.getAccordoServizioParteComune().setStatoPackage(StatiAccordo.finale.toString());
                }
            }
            StringBuffer warningAderenzaWSDL = new StringBuffer("");
            this.informazioniServizioAderentiWSDL(archiveAccordoServizioComposto.getAccordoServizioParteComune(), warningAderenzaWSDL);
            archiveAccordoServizioComposto.getAccordoServizioParteComune().setOraRegistrazione(DateManager.getDate());
            if (this.importerEngine.existsAccordoServizioParteComune(idAccordoServizioComposto)) {
                AccordoServizioParteComune old = this.importerEngine.getAccordoServizioParteComune(idAccordoServizioComposto);
                archiveAccordoServizioComposto.getAccordoServizioParteComune().setId(old.getId());
                archiveAccordoServizioComposto.getAccordoServizioParteComune().setOldIDAccordoForUpdate(this.idAccordoFactory.getIDAccordoFromAccordo(old));
                if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(old.getSuperUser())) {
                    throw new Exception("L'accordo non \u00e8 visibile/aggiornabile dall'utente collegato (" + this.userLogin + ")");
                }
                this.importerEngine.updateAccordoServizioParteComune(archiveAccordoServizioComposto.getAccordoServizioParteComune());
                detail.setState(ArchiveStatoImport.UPDATED);
                detail.setStateDetail(warningInfoStatoFinale.toString() + warningAderenzaWSDL.toString());
            } else {
                this.importerEngine.createAccordoServizioParteComune(archiveAccordoServizioComposto.getAccordoServizioParteComune());
                detail.setState(ArchiveStatoImport.CREATED);
                detail.setStateDetail(warningInfoStatoFinale.toString() + warningAderenzaWSDL.toString());
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante l'import dell'accordo di servizio parte comune [" + idAccordoServizioComposto + "]: " + e.getMessage()), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    private void informazioniServizioAderentiWSDL(AccordoServizioParteComune accordoServizioParteComune, StringBuffer anomalieRiscontrate) throws Exception {
        try {
            Operation opOpenSPCoop;
            PortType ptOpenSPCoop;
            ArrayList<String> listOperationName;
            ArrayList<String> listPortTypesName;
            String indent = "\t\t";
            StringBuffer strutturaWSDL = new StringBuffer("Struttura WSDL:\n");
            byte[] wsdl = accordoServizioParteComune.getByteWsdlConcettuale();
            if (wsdl == null) {
                throw new Exception("WSDLConcettuale non fornito");
            }
            RegistroOpenSPCoopUtilities wsdlUtility = new RegistroOpenSPCoopUtilities(this.log);
            wsdl = wsdlUtility.eliminaImportASParteComune(wsdl);
            DefinitionWrapper wsdlObject = new DefinitionWrapper(wsdl, (AbstractXMLUtils)XMLUtils.getInstance());
            Hashtable mapPortTypeOperations = new Hashtable();
            Map pts = wsdlObject.getAllPortTypes();
            if (pts == null || pts.size() <= 0) {
                this.log.warn((Object)"Non sono stati definiti port types nel wsdl concettuale");
            } else {
                Iterator ptsIterator = pts.values().iterator();
                listPortTypesName = new ArrayList<String>();
                while (ptsIterator.hasNext()) {
                    javax.wsdl.PortType pt = (javax.wsdl.PortType)ptsIterator.next();
                    String ptName = pt.getQName().getLocalPart();
                    listPortTypesName.add(ptName);
                    List ops = pt.getOperations();
                    Iterator opIt = ops.iterator();
                    listOperationName = new ArrayList<String>();
                    while (opIt.hasNext()) {
                        javax.wsdl.Operation op = (javax.wsdl.Operation)opIt.next();
                        String nomeOperazione = op.getName();
                        listOperationName.add(nomeOperazione);
                    }
                    Collections.sort(listOperationName);
                    mapPortTypeOperations.put(ptName, listOperationName);
                }
                Collections.sort(listPortTypesName);
                for (String ptName : listPortTypesName) {
                    strutturaWSDL.append(indent + ". " + ptName + "\n");
                    List opList = (List)mapPortTypeOperations.get(ptName);
                    for (String opName : opList) {
                        strutturaWSDL.append(indent + "\t- " + opName + "\n");
                    }
                }
            }
            StringBuffer strutturaAccordoOpenSPCoop = new StringBuffer("Servizi/Azioni associati all'accordo:\n");
            listPortTypesName = new ArrayList();
            Hashtable<String, PortType> mapPtNameToObject = new Hashtable<String, PortType>();
            for (int i = 0; i < accordoServizioParteComune.sizePortTypeList(); ++i) {
                PortType ptOpenSPCoop2 = accordoServizioParteComune.getPortType(i);
                listPortTypesName.add(ptOpenSPCoop2.getNome());
                mapPtNameToObject.put(ptOpenSPCoop2.getNome(), ptOpenSPCoop2);
            }
            Collections.sort(listPortTypesName);
            for (String ptName : listPortTypesName) {
                ptOpenSPCoop = (PortType)mapPtNameToObject.get(ptName);
                strutturaAccordoOpenSPCoop.append(indent + ". " + ptOpenSPCoop.getNome() + "\n");
                listOperationName = new ArrayList();
                for (int j = 0; j < ptOpenSPCoop.sizeAzioneList(); ++j) {
                    opOpenSPCoop = ptOpenSPCoop.getAzione(j);
                    listOperationName.add(opOpenSPCoop.getNome());
                }
                Collections.sort(listOperationName);
                for (String opName : listOperationName) {
                    strutturaAccordoOpenSPCoop.append(indent + "\t- " + opName + "\n");
                }
            }
            boolean aderenzaWSDL = true;
            for (int i = 0; i < accordoServizioParteComune.sizePortTypeList(); ++i) {
                ptOpenSPCoop = accordoServizioParteComune.getPortType(i);
                if (mapPortTypeOperations.containsKey(ptOpenSPCoop.getNome())) {
                    List opWSDL = (List)mapPortTypeOperations.remove(ptOpenSPCoop.getNome());
                    for (int j = 0; j < ptOpenSPCoop.sizeAzioneList(); ++j) {
                        opOpenSPCoop = ptOpenSPCoop.getAzione(j);
                        if (!opWSDL.contains(opOpenSPCoop.getNome())) {
                            aderenzaWSDL = false;
                            break;
                        }
                        opWSDL.remove(opOpenSPCoop.getNome());
                    }
                    if (opWSDL.size() <= 0) continue;
                    aderenzaWSDL = false;
                    break;
                }
                aderenzaWSDL = false;
                break;
            }
            if (aderenzaWSDL && mapPortTypeOperations.size() > 0) {
                aderenzaWSDL = false;
            }
            if (!aderenzaWSDL) {
                anomalieRiscontrate.append("\n" + indent + "(WARNING) accordo importato contiene una struttura (servizi e azioni) non aderente all'interfaccia WSDL");
                anomalieRiscontrate.append("\n" + indent + "Alcuni servizi o alcune azioni associate all'accordo importato");
                anomalieRiscontrate.append("\n" + indent + "non corrispondono ai port types e alle operations definite");
                anomalieRiscontrate.append("\n" + indent);
                anomalieRiscontrate.append(strutturaWSDL);
                anomalieRiscontrate.append(indent);
                anomalieRiscontrate.append(strutturaAccordoOpenSPCoop);
            }
        }
        catch (Exception e) {
            this.log.debug((Object)("Check informazioniServizioAderentiWSDL non riuscito: " + e.getMessage()));
        }
    }

    public void importAccordoServizioParteSpecifica(ArchiveAccordoServizioParteSpecifica archiveAccordoServizioParteSpecifica, boolean servizioComposto, boolean isAbilitatoControlloUnicitaImplementazioneAccordoPerSoggetto, boolean isAbilitatoControlloUnicitaImplementazionePortTypePerSoggetto, ArchiveEsitoImportDetail detail) {
        IDAccordo idAccordoServizioParteComune = archiveAccordoServizioParteSpecifica.getIdAccordoServizioParteComune();
        IDAccordo idAccordoServizioParteSpecifica = archiveAccordoServizioParteSpecifica.getIdAccordoServizioParteSpecifica();
        IDServizio idServizio = archiveAccordoServizioParteSpecifica.getIdServizio();
        IDSoggetto idSoggettoErogatore = archiveAccordoServizioParteSpecifica.getIdSoggettoErogatore();
        String labelAccordoParteComune = "Accordo di Servizio Parte Comune";
        if (servizioComposto) {
            labelAccordoParteComune = "Accordo di Servizio Composto";
        }
        try {
            int i;
            String protocolloAssociatoAccordoParteComune;
            String protocolloAssociatoAccordo;
            if (!this.updateAbilitato && this.importerEngine.existsAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica)) {
                detail.setState(ArchiveStatoImport.UPDATE_NOT_PERMISSED);
                return;
            }
            if (!this.importerEngine.existsSoggettoRegistro(idSoggettoErogatore)) {
                throw new Exception("Soggetto erogatore [" + idSoggettoErogatore + "] non esistente");
            }
            if (!this.importerEngine.existsAccordoServizioParteComune(idAccordoServizioParteComune)) {
                throw new Exception(labelAccordoParteComune + " [" + idAccordoServizioParteComune + "] non esistente");
            }
            Soggetto soggetto = this.importerEngine.getSoggettoRegistro(idSoggettoErogatore);
            AccordoServizioParteComune accordoServizioParteComune = this.importerEngine.getAccordoServizioParteComune(idAccordoServizioParteComune);
            AccordoServizioParteSpecifica old = null;
            long idAccordoServizioParteSpecificaLong = -1L;
            boolean isUpdate = false;
            boolean servizioCorrelato = TipologiaServizio.CORRELATO.equals(archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getServizio().getTipologiaServizio());
            if (this.importerEngine.existsAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica)) {
                old = this.importerEngine.getAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica);
                idAccordoServizioParteSpecificaLong = old.getId();
                isUpdate = true;
            }
            this.importerEngine.controlloUnicitaImplementazioneAccordoPerSoggetto(archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getPortType(), idSoggettoErogatore, soggetto.getId(), idAccordoServizioParteComune, accordoServizioParteComune.getId(), idServizio, idAccordoServizioParteSpecificaLong, isUpdate, servizioCorrelato, isAbilitatoControlloUnicitaImplementazioneAccordoPerSoggetto, isAbilitatoControlloUnicitaImplementazionePortTypePerSoggetto);
            if (this.importerEngine.existsAccordoServizioParteSpecifica(idServizio)) {
                if (!isUpdate) {
                    AccordoServizioParteSpecifica aspsCheck = this.importerEngine.getAccordoServizioParteSpecifica(idServizio);
                    throw new Exception("Servizio [" + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + "] erogato dal soggetto [" + idSoggettoErogatore + "] gi\u00e0 esistente definito all'interno dell'accordo di servizio parte specifica [" + IDAccordoFactory.getInstance().getUriFromAccordo(aspsCheck) + "]");
                }
                AccordoServizioParteSpecifica aspsCheck = this.importerEngine.getAccordoServizioParteSpecifica(idServizio);
                IDAccordo idAccordoASPSCheck = IDAccordoFactory.getInstance().getIDAccordoFromAccordo(aspsCheck);
                if (!idAccordoASPSCheck.equals((Object)idAccordoServizioParteSpecifica)) {
                    throw new Exception("Servizio [" + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + "] erogato dal soggetto [" + idSoggettoErogatore + "] gi\u00e0 esistente definito all'interno dell'accordo di servizio parte specifica [" + IDAccordoFactory.getInstance().getUriFromAccordo(aspsCheck) + "]");
                }
            }
            if (!(protocolloAssociatoAccordo = this.protocolFactoryManager.getProtocolBySubjectType(idSoggettoErogatore.getTipo())).equals(protocolloAssociatoAccordoParteComune = this.protocolFactoryManager.getProtocolBySubjectType(idAccordoServizioParteComune.getSoggettoReferente().getTipo()))) {
                throw new Exception("AccordoServizioParteComune [" + idAccordoServizioParteComune + "] (protocollo:" + protocolloAssociatoAccordoParteComune + ") non utilizzabile in un accordo con soggetto erogatore [" + idSoggettoErogatore + "] (protocollo:" + protocolloAssociatoAccordo + ")");
            }
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggetto.getSuperUser())) {
                throw new Exception("Il soggetto erogatore [" + idSoggettoErogatore + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
            }
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(accordoServizioParteComune.getSuperUser())) {
                throw new Exception("L'accordo di servizio parte comune [" + idAccordoServizioParteComune + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
            }
            XMLDataConverter.impostaInformazioniRegistroDB_AccordoServizioParteSpecifica((AccordoServizioParteSpecifica)archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica());
            archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().setSuperUser(this.userLogin);
            for (i = 0; i < archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().sizeAllegatoList(); ++i) {
                archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getAllegato(i).setRuolo(RuoliDocumento.allegato.toString());
                archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getAllegato(i).setTipoProprietarioDocumento(ProprietariDocumento.servizio.toString());
            }
            for (i = 0; i < archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().sizeSpecificaSemiformaleList(); ++i) {
                archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getSpecificaSemiformale(i).setRuolo(RuoliDocumento.specificaSemiformale.toString());
                archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getSpecificaSemiformale(i).setTipoProprietarioDocumento(ProprietariDocumento.servizio.toString());
            }
            for (i = 0; i < archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().sizeSpecificaLivelloServizioList(); ++i) {
                archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getSpecificaLivelloServizio(i).setRuolo(RuoliDocumento.specificaLivelloServizio.toString());
                archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getSpecificaLivelloServizio(i).setTipoProprietarioDocumento(ProprietariDocumento.servizio.toString());
            }
            for (i = 0; i < archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().sizeSpecificaSicurezzaList(); ++i) {
                archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getSpecificaSicurezza(i).setRuolo(RuoliDocumento.specificaSicurezza.toString());
                archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getSpecificaSicurezza(i).setTipoProprietarioDocumento(ProprietariDocumento.servizio.toString());
            }
            StringBuffer warningInfoStatoFinale = new StringBuffer("");
            if (archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getStatoPackage() == null) {
                if (this.gestioneWorkflowStatiAccordi) {
                    try {
                        archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().setStatoPackage(StatiAccordo.finale.toString());
                        this.importerEngine.validaStatoAccordoServizioParteSpecifica(archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica());
                    }
                    catch (ValidazioneStatoPackageException validazioneException) {
                        try {
                            archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().setStatoPackage(StatiAccordo.operativo.toString());
                            this.importerEngine.validaStatoAccordoServizioParteSpecifica(archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica());
                        }
                        catch (ValidazioneStatoPackageException validazioneExceptionLevelOperativo) {
                            warningInfoStatoFinale.append("\n\t\t(WARNING) Accordo salvato con stato '").append(StatiAccordo.bozza.toString()).append("':\n\t\t\t");
                            warningInfoStatoFinale.append(validazioneException.toString("\n\t\t\t - ", "\n\t\t\t - "));
                            warningInfoStatoFinale.append("\n\t\t\t" + validazioneExceptionLevelOperativo.toString("\n\t\t\t - ", "\n\t\t\t - "));
                            archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().setStatoPackage(StatiAccordo.bozza.toString());
                        }
                    }
                } else {
                    archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().setStatoPackage(StatiAccordo.finale.toString());
                }
            }
            archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().setOraRegistrazione(DateManager.getDate());
            XMLDataConverter.aggiornatoStatoFruitori((AccordoServizioParteSpecifica)archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica(), (StatiAccordo)StatiAccordo.valueOf((String)archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getStatoPackage()));
            if (this.importerEngine.existsAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica)) {
                archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().setId(old.getId());
                archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getServizio().setOldTipoForUpdate(old.getServizio().getTipo());
                archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getServizio().setOldNomeForUpdate(old.getServizio().getNome());
                archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getServizio().setOldTipoSoggettoErogatoreForUpdate(old.getServizio().getTipoSoggettoErogatore());
                archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getServizio().setOldNomeSoggettoErogatoreForUpdate(old.getServizio().getNomeSoggettoErogatore());
                boolean mantieniFruitoriEsistenti = true;
                XMLDataConverter.impostaInformazioniRegistro_AccordoServizioParteSpecifica_update((AccordoServizioParteSpecifica)archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica(), (AccordoServizioParteSpecifica)old, (boolean)mantieniFruitoriEsistenti);
                if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(old.getSuperUser())) {
                    throw new Exception("L'accordo non \u00e8 visibile/aggiornabile dall'utente collegato (" + this.userLogin + ")");
                }
                this.importerEngine.updateAccordoServizioParteSpecifica(archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica());
                detail.setState(ArchiveStatoImport.UPDATED);
                detail.setStateDetail(warningInfoStatoFinale.toString());
            } else {
                this.importerEngine.createAccordoServizioParteSpecifica(archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica());
                detail.setState(ArchiveStatoImport.CREATED);
                detail.setStateDetail(warningInfoStatoFinale.toString());
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante l'import dell'accordo di servizio parte specifica [" + idAccordoServizioParteSpecifica + "]: " + e.getMessage()), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void importFruitore(ArchiveFruitore archiveFruitore, ArchiveEsitoImportDetail detail) {
        IDAccordo idAccordoServizioParteSpecifica = archiveFruitore.getIdAccordoServizioParteSpecifica();
        IDSoggetto idSoggettoFruitore = archiveFruitore.getIdSoggettoFruitore();
        try {
            String protocolloAssociatoAccordoParteSpecifica;
            AccordoServizioParteSpecifica oldAccordo = null;
            Fruitore old = null;
            if (this.importerEngine.existsAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica)) {
                oldAccordo = this.importerEngine.getAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica);
                for (int i = 0; i < oldAccordo.sizeFruitoreList(); ++i) {
                    Fruitore check = oldAccordo.getFruitore(i);
                    if (!check.getTipo().equals(idSoggettoFruitore.getTipo()) || !check.getNome().equals(idSoggettoFruitore.getNome())) continue;
                    old = oldAccordo.removeFruitore(i);
                    break;
                }
            }
            if (!this.updateAbilitato && old != null) {
                detail.setState(ArchiveStatoImport.UPDATE_NOT_PERMISSED);
                return;
            }
            if (!this.importerEngine.existsSoggettoRegistro(idSoggettoFruitore)) {
                throw new Exception("Soggetto fruitore [" + idSoggettoFruitore + "] non esistente");
            }
            if (!this.importerEngine.existsAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica)) {
                throw new Exception("Accordo di Servizio Parte Specifica non esistente");
            }
            String protocolloAssociatoFruitore = this.protocolFactoryManager.getProtocolBySubjectType(idSoggettoFruitore.getTipo());
            if (!protocolloAssociatoFruitore.equals(protocolloAssociatoAccordoParteSpecifica = this.protocolFactoryManager.getProtocolBySubjectType(idAccordoServizioParteSpecifica.getSoggettoReferente().getTipo()))) {
                throw new Exception("AccordoServizioParteSpecifica [" + idAccordoServizioParteSpecifica + "] (protocollo:" + protocolloAssociatoAccordoParteSpecifica + ") non utilizzabile in un fruitore [" + idSoggettoFruitore + "] (protocollo:" + protocolloAssociatoFruitore + ")");
            }
            Soggetto soggetto = this.importerEngine.getSoggettoRegistro(idSoggettoFruitore);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggetto.getSuperUser())) {
                throw new Exception("Il soggetto fruitore [" + idSoggettoFruitore + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
            }
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(oldAccordo.getSuperUser())) {
                throw new Exception("L'accordo di servizio parte specifica [" + idAccordoServizioParteSpecifica + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
            }
            XMLDataConverter.impostaInformazioniRegistroDB_AccordoServizioParteSpecifica_Fruitore((Fruitore)archiveFruitore.getFruitore());
            StringBuffer warningInfoStatoFinale = new StringBuffer("");
            if (archiveFruitore.getFruitore() == null) {
                if (this.gestioneWorkflowStatiAccordi) {
                    try {
                        archiveFruitore.getFruitore().setStatoPackage(StatiAccordo.finale.toString());
                        this.importerEngine.validaStatoFruitoreServizio(archiveFruitore.getFruitore(), oldAccordo);
                    }
                    catch (ValidazioneStatoPackageException validazioneException) {
                        try {
                            archiveFruitore.getFruitore().setStatoPackage(StatiAccordo.operativo.toString());
                            this.importerEngine.validaStatoFruitoreServizio(archiveFruitore.getFruitore(), oldAccordo);
                        }
                        catch (ValidazioneStatoPackageException validazioneExceptionLevelOperativo) {
                            warningInfoStatoFinale.append("\n\t\t(WARNING) Fruitore salvato con stato '").append(StatiAccordo.bozza.toString()).append("':\n\t\t\t");
                            warningInfoStatoFinale.append(validazioneException.toString("\n\t\t\t - ", "\n\t\t\t - "));
                            warningInfoStatoFinale.append("\n\t\t\t" + validazioneExceptionLevelOperativo.toString("\n\t\t\t - ", "\n\t\t\t - "));
                            archiveFruitore.getFruitore().setStatoPackage(StatiAccordo.bozza.toString());
                        }
                    }
                } else {
                    archiveFruitore.getFruitore().setStatoPackage(StatiAccordo.finale.toString());
                }
            }
            archiveFruitore.getFruitore().setOraRegistrazione(DateManager.getDate());
            if (old != null) {
                archiveFruitore.getFruitore().setId(old.getId());
            }
            oldAccordo.addFruitore(archiveFruitore.getFruitore());
            oldAccordo.getServizio().setOldTipoForUpdate(oldAccordo.getServizio().getTipo());
            oldAccordo.getServizio().setOldNomeForUpdate(oldAccordo.getServizio().getNome());
            oldAccordo.getServizio().setOldTipoSoggettoErogatoreForUpdate(oldAccordo.getServizio().getTipoSoggettoErogatore());
            oldAccordo.getServizio().setOldNomeSoggettoErogatoreForUpdate(oldAccordo.getServizio().getNomeSoggettoErogatore());
            this.importerEngine.updateAccordoServizioParteSpecifica(oldAccordo);
            if (archiveFruitore.getServiziApplicativiAutorizzati() != null && archiveFruitore.getServiziApplicativiAutorizzati().size() > 0) {
                List<IDServizioApplicativo> listaAttuale = null;
                try {
                    listaAttuale = this.importerEngine.getAllIdServiziApplicativiAutorizzati(archiveFruitore.getIdAccordoServizioParteSpecifica(), archiveFruitore.getIdSoggettoFruitore());
                }
                catch (DriverRegistroServiziNotFound notFound) {
                    // empty catch block
                }
                if (listaAttuale == null) {
                    listaAttuale = new ArrayList<IDServizioApplicativo>();
                }
                for (String nomeServizioApplicativo : archiveFruitore.getServiziApplicativiAutorizzati()) {
                    boolean found = false;
                    for (IDServizioApplicativo idServizioApplicativo : listaAttuale) {
                        if (!idServizioApplicativo.getNome().equals(nomeServizioApplicativo)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.importerEngine.createServizioApplicativoAutorizzato(archiveFruitore.getIdAccordoServizioParteSpecifica(), archiveFruitore.getIdSoggettoFruitore(), nomeServizioApplicativo);
                }
            }
            if (old != null) {
                detail.setState(ArchiveStatoImport.UPDATED);
                detail.setStateDetail(warningInfoStatoFinale.toString());
            } else {
                detail.setState(ArchiveStatoImport.CREATED);
                detail.setStateDetail(warningInfoStatoFinale.toString());
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante l'import del fruitore[" + idSoggettoFruitore + "] dell'accordo di servizio parte specifica [" + idAccordoServizioParteSpecifica + "]: " + e.getMessage()), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void importPortaDelegata(ArchivePortaDelegata archivePortaDelegata, ArchiveEsitoImportDetail detail) {
        IDPortaDelegata idPortaDelegata = archivePortaDelegata.getIdPortaDelegata();
        IDSoggetto idSoggettoProprietario = archivePortaDelegata.getIdSoggettoProprietario();
        try {
            String protocolloAssociatoSoggettoErogatore;
            if (!this.updateAbilitato && this.importerEngine.existsPortaDelegata(idPortaDelegata)) {
                detail.setState(ArchiveStatoImport.UPDATE_NOT_PERMISSED);
                return;
            }
            PortaDelegata pd = archivePortaDelegata.getPortaDelegata();
            IDSoggetto idSoggettoErogatore = null;
            IDServizio idServizio = null;
            if (pd.getSoggettoErogatore() != null && pd.getSoggettoErogatore().getTipo() != null && pd.getSoggettoErogatore().getNome() != null && pd.getSoggettoErogatore().getIdentificazione() == null || CostantiConfigurazione.PORTA_DELEGATA_SOGGETTO_EROGATORE_STATIC.equals(pd.getSoggettoErogatore().getIdentificazione())) {
                idSoggettoErogatore = new IDSoggetto(pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome());
            }
            if (idSoggettoErogatore != null && (pd.getServizio() != null && pd.getServizio().getTipo() != null && pd.getServizio().getNome() != null && pd.getServizio().getIdentificazione() == null || CostantiConfigurazione.PORTA_DELEGATA_SERVIZIO_STATIC.equals(pd.getServizio().getIdentificazione()))) {
                idServizio = new IDServizio(idSoggettoErogatore, pd.getServizio().getTipo(), pd.getServizio().getNome());
            }
            if (!this.importerEngine.existsSoggettoConfigurazione(idSoggettoProprietario)) {
                throw new Exception("Soggetto proprietario [" + idSoggettoProprietario + "] non esistente");
            }
            if (idSoggettoErogatore != null && !this.importerEngine.existsSoggettoRegistro(idSoggettoErogatore)) {
                throw new Exception("Soggetto erogatore riferito nella PD [" + idSoggettoErogatore + "] non esistente");
            }
            if (idServizio != null && !this.importerEngine.existsAccordoServizioParteSpecifica(idServizio)) {
                throw new Exception("Servizio riferito nella PD [" + idServizio + "] non esistente");
            }
            String protocolloAssociatoSoggettoProprietario = this.protocolFactoryManager.getProtocolBySubjectType(idSoggettoProprietario.getTipo());
            if (idSoggettoErogatore != null && !protocolloAssociatoSoggettoProprietario.equals(protocolloAssociatoSoggettoErogatore = this.protocolFactoryManager.getProtocolBySubjectType(idSoggettoErogatore.getTipo()))) {
                throw new Exception("SoggettoErogatore [" + idSoggettoErogatore + "] (protocollo:" + protocolloAssociatoSoggettoErogatore + ") non utilizzabile in una porta delegata appartenete al soggetto [" + idSoggettoProprietario + "] (protocollo:" + protocolloAssociatoSoggettoProprietario + ")");
            }
            if (idServizio != null) {
                String protocolloAssociatoAccordoParteSpecifica = this.protocolFactoryManager.getProtocolByServiceType(idServizio.getTipoServizio());
                if (!protocolloAssociatoSoggettoProprietario.equals(protocolloAssociatoAccordoParteSpecifica)) {
                    throw new Exception("AccordoServizioParteSpecifica [" + idServizio + "] (protocollo:" + protocolloAssociatoAccordoParteSpecifica + ") con servizio non utilizzabile in una porta delegata appartenete al soggetto [" + idSoggettoProprietario + "] (protocollo:" + protocolloAssociatoSoggettoProprietario + ")");
                }
                String protocolloAssociatoSoggettoAccordoParteSpecifica = this.protocolFactoryManager.getProtocolBySubjectType(idServizio.getSoggettoErogatore().getTipo());
                if (!protocolloAssociatoSoggettoProprietario.equals(protocolloAssociatoSoggettoAccordoParteSpecifica)) {
                    throw new Exception("AccordoServizioParteSpecifica [" + idServizio + "] (protocollo:" + protocolloAssociatoSoggettoAccordoParteSpecifica + ") con soggetto non utilizzabile in una porta delegata appartenete al soggetto [" + idSoggettoProprietario + "] (protocollo:" + protocolloAssociatoSoggettoProprietario + ")");
                }
            }
            org.openspcoop2.core.config.Soggetto soggetto = this.importerEngine.getSoggettoConfigurazione(idSoggettoProprietario);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggetto.getSuperUser())) {
                throw new Exception("Il soggetto proprietario [" + idSoggettoProprietario + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
            }
            Soggetto soggettoErogatore = null;
            AccordoServizioParteSpecifica accordoServizioParteSpecifica = null;
            if (idSoggettoErogatore != null) {
                soggettoErogatore = this.importerEngine.getSoggettoRegistro(idSoggettoErogatore);
                if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggettoErogatore.getSuperUser())) {
                    throw new Exception("Il soggetto erogatore riferito nella PD [" + idSoggettoErogatore + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
                }
            }
            if (idServizio != null) {
                accordoServizioParteSpecifica = this.importerEngine.getAccordoServizioParteSpecifica(idServizio);
                if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(accordoServizioParteSpecifica.getSuperUser())) {
                    throw new Exception("Il servizio riferito nella PD [" + idServizio + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
                }
            }
            if (idSoggettoErogatore != null) {
                pd.getSoggettoErogatore().setId(soggettoErogatore.getId());
            }
            if (idServizio != null) {
                pd.getServizio().setId(accordoServizioParteSpecifica.getId());
            }
            pd.setOraRegistrazione(DateManager.getDate());
            if (this.importerEngine.existsPortaDelegata(idPortaDelegata)) {
                PortaDelegata old = this.importerEngine.getPortaDelegata(idPortaDelegata);
                pd.setId(old.getId());
                pd.setOldNomeForUpdate(old.getNome());
                pd.setOldTipoSoggettoProprietarioForUpdate(old.getTipoSoggettoProprietario());
                pd.setOldNomeSoggettoProprietarioForUpdate(old.getNomeSoggettoProprietario());
                org.openspcoop2.core.config.driver.utils.XMLDataConverter.impostaInformazioniConfigurazione_PortaDelegata((PortaDelegata)pd);
                this.importerEngine.updatePortaDelegata(pd);
                detail.setState(ArchiveStatoImport.UPDATED);
            } else {
                this.importerEngine.createPortaDelegata(pd);
                detail.setState(ArchiveStatoImport.CREATED);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante l'import della porta delegata [" + idPortaDelegata + "]: " + e.getMessage()), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void importPortaApplicativa(ArchivePortaApplicativa archivePortaApplicativa, ArchiveEsitoImportDetail detail) {
        IDPortaApplicativa idPortaApplicativa = archivePortaApplicativa.getIdPortaApplicativa();
        IDPortaApplicativaByNome idPortaApplicativaByNome = archivePortaApplicativa.getIdPortaApplicativaByNome();
        IDSoggetto idSoggettoProprietario = archivePortaApplicativa.getIdSoggettoProprietario();
        try {
            String protocolloAssociatoSoggettoErogatore;
            if (!this.updateAbilitato && this.importerEngine.existsPortaApplicativa(idPortaApplicativaByNome.getNome(), idSoggettoProprietario)) {
                detail.setState(ArchiveStatoImport.UPDATE_NOT_PERMISSED);
                return;
            }
            PortaApplicativa pa = archivePortaApplicativa.getPortaApplicativa();
            IDServizio idServizio = null;
            IDSoggetto idSoggettoErogatore = idSoggettoProprietario;
            if (pa.getSoggettoVirtuale() != null && pa.getSoggettoVirtuale().getTipo() != null && pa.getSoggettoVirtuale().getNome() != null) {
                idSoggettoErogatore = new IDSoggetto(pa.getSoggettoVirtuale().getTipo(), pa.getSoggettoVirtuale().getNome());
            }
            if (idSoggettoErogatore != null && pa.getServizio() != null && pa.getServizio().getTipo() != null && pa.getServizio().getNome() != null) {
                idServizio = new IDServizio(idSoggettoErogatore, pa.getServizio().getTipo(), pa.getServizio().getNome());
            }
            if (!this.importerEngine.existsSoggettoConfigurazione(idSoggettoProprietario)) {
                throw new Exception("Soggetto proprietario [" + idSoggettoProprietario + "] non esistente");
            }
            if (idSoggettoErogatore != null && !this.importerEngine.existsSoggettoRegistro(idSoggettoErogatore)) {
                throw new Exception("Soggetto erogatore riferito nella PA [" + idSoggettoErogatore + "] non esistente");
            }
            if (idServizio != null && !this.importerEngine.existsAccordoServizioParteSpecifica(idServizio)) {
                throw new Exception("Servizio riferito nella PA [" + idServizio + "] non esistente");
            }
            String protocolloAssociatoSoggettoProprietario = this.protocolFactoryManager.getProtocolBySubjectType(idSoggettoProprietario.getTipo());
            if (!protocolloAssociatoSoggettoProprietario.equals(protocolloAssociatoSoggettoErogatore = this.protocolFactoryManager.getProtocolBySubjectType(idSoggettoErogatore.getTipo()))) {
                throw new Exception("SoggettoErogatore [" + idSoggettoErogatore + "] (protocollo:" + protocolloAssociatoSoggettoErogatore + ") non utilizzabile in una porta applicativa appartenete al soggetto [" + idSoggettoProprietario + "] (protocollo:" + protocolloAssociatoSoggettoProprietario + ")");
            }
            String protocolloAssociatoAccordoParteSpecifica = this.protocolFactoryManager.getProtocolByServiceType(idServizio.getTipoServizio());
            if (!protocolloAssociatoSoggettoProprietario.equals(protocolloAssociatoAccordoParteSpecifica)) {
                throw new Exception("AccordoServizioParteSpecifica [" + idServizio + "] (protocollo:" + protocolloAssociatoAccordoParteSpecifica + ") con servizio non utilizzabile in una porta applicativa appartenete al soggetto [" + idSoggettoProprietario + "] (protocollo:" + protocolloAssociatoSoggettoProprietario + ")");
            }
            String protocolloAssociatoSoggettoAccordoParteSpecifica = this.protocolFactoryManager.getProtocolBySubjectType(idServizio.getSoggettoErogatore().getTipo());
            if (!protocolloAssociatoSoggettoProprietario.equals(protocolloAssociatoSoggettoAccordoParteSpecifica)) {
                throw new Exception("AccordoServizioParteSpecifica [" + idServizio + "] (protocollo:" + protocolloAssociatoSoggettoAccordoParteSpecifica + ") con soggetto non utilizzabile in una porta applicativa appartenete al soggetto [" + idSoggettoProprietario + "] (protocollo:" + protocolloAssociatoSoggettoProprietario + ")");
            }
            org.openspcoop2.core.config.Soggetto soggetto = this.importerEngine.getSoggettoConfigurazione(idSoggettoProprietario);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggetto.getSuperUser())) {
                throw new Exception("Il soggetto proprietario [" + idSoggettoProprietario + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
            }
            Soggetto soggettoErogatore = null;
            AccordoServizioParteSpecifica accordoServizioParteSpecifica = null;
            if (idSoggettoErogatore != null) {
                soggettoErogatore = this.importerEngine.getSoggettoRegistro(idSoggettoErogatore);
                if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggettoErogatore.getSuperUser())) {
                    throw new Exception("Il soggetto erogatore riferito nella PA [" + idSoggettoErogatore + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
                }
            }
            if (idServizio != null) {
                accordoServizioParteSpecifica = this.importerEngine.getAccordoServizioParteSpecifica(idServizio);
                if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(accordoServizioParteSpecifica.getSuperUser())) {
                    throw new Exception("Il servizio riferito nella PA [" + idServizio + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
                }
            }
            if (pa.getSoggettoVirtuale() != null) {
                pa.getSoggettoVirtuale().setId(soggettoErogatore.getId());
            }
            if (idServizio != null) {
                pa.getServizio().setId(accordoServizioParteSpecifica.getId());
            }
            pa.setOraRegistrazione(DateManager.getDate());
            if (this.importerEngine.existsPortaApplicativa(idPortaApplicativaByNome.getNome(), idSoggettoProprietario)) {
                PortaApplicativa old = this.importerEngine.getPortaApplicativa(idPortaApplicativaByNome.getNome(), idSoggettoProprietario);
                pa.setId(old.getId());
                pa.setOldNomeForUpdate(old.getNome());
                pa.setOldTipoSoggettoProprietarioForUpdate(old.getTipoSoggettoProprietario());
                pa.setOldNomeSoggettoProprietarioForUpdate(old.getNomeSoggettoProprietario());
                org.openspcoop2.core.config.driver.utils.XMLDataConverter.impostaInformazioniConfigurazione_PortaApplicativa((PortaApplicativa)pa);
                this.importerEngine.updatePortaApplicativa(pa);
                detail.setState(ArchiveStatoImport.UPDATED);
            } else {
                this.importerEngine.createPortaApplicativa(pa);
                detail.setState(ArchiveStatoImport.CREATED);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante l'import della porta applicativa [" + idPortaApplicativa + "]: " + e.getMessage()), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void importConfigurazione(Configurazione configurazionePdD, ArchiveEsitoImportDetailConfigurazione detail) {
        try {
            this.importerEngine.updateConfigurazione(configurazionePdD);
            detail.setState(ArchiveStatoImport.UPDATED);
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante l'import della configurazione: " + e.getMessage()), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }
}

