/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.archive;

import org.apache.log4j.Logger;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.archive.ArchiveEngine;
import org.openspcoop2.protocol.engine.archive.ArchiveRegistryReader;
import org.openspcoop2.protocol.engine.archive.ArchiveValidator;
import org.openspcoop2.protocol.engine.archive.ImportInformationMissingCollection;
import org.openspcoop2.protocol.engine.archive.ImporterArchiveUtils;
import org.openspcoop2.protocol.sdk.ConfigurazionePdD;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.archive.Archive;
import org.openspcoop2.protocol.sdk.archive.ArchiveEsitoImport;
import org.openspcoop2.protocol.sdk.archive.ArchiveMode;
import org.openspcoop2.protocol.sdk.archive.ArchiveModeType;
import org.openspcoop2.protocol.sdk.archive.IArchive;
import org.openspcoop2.protocol.sdk.archive.IRegistryReader;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.resources.Loader;

public class Importer {
    public static void main(String[] args) throws Exception {
        Logger log = Logger.getLogger(Importer.class);
        String archiveFile = args[0];
        byte[] archiveBytes = FileSystemUtilities.readBytesFromFile((String)archiveFile);
        String protocollo = args[1];
        String mode = args[2];
        ArchiveMode archiveMode = new ArchiveMode(mode);
        String type = args[3];
        ArchiveModeType archiveModeType = new ArchiveModeType(type);
        boolean validateDocuments = Boolean.parseBoolean(args[4]);
        String userLogin = args[5];
        String nomePddOperativa = args[6];
        String tipoPddDefault = args[7];
        boolean updateAbilitato = Boolean.parseBoolean(args[8]);
        boolean isShowCorrelazioneAsincronaInAccordi = true;
        boolean isShowGestioneWorkflowStatoDocumenti = true;
        boolean isShowAccordiColonnaAzioni = true;
        boolean isAbilitatoControlloUnicitaImplementazioneAccordoPerSoggetto = false;
        boolean isAbilitatoControlloUnicitaImplementazionePortTypePerSoggetto = false;
        ConfigurazionePdD configPdD = new ConfigurazionePdD();
        configPdD.setLoader(new Loader());
        configPdD.setLog(log);
        ProtocolFactoryManager.initializeSingleProtocol(log, configPdD, protocollo);
        DriverRegistroServiziDB driverRegistroServizi = null;
        DriverConfigurazioneDB driverConfigurazione = null;
        ArchiveRegistryReader archiveRegistryReader = new ArchiveRegistryReader(driverRegistroServizi, driverConfigurazione);
        IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
        IArchive archiveEngine = pf.createArchive();
        Archive archive = archiveEngine.importArchive(archiveBytes, archiveMode, archiveModeType, (IRegistryReader)archiveRegistryReader, validateDocuments, null);
        ArchiveValidator validator = new ArchiveValidator(archiveRegistryReader);
        ImportInformationMissingCollection importInformationMissingCollection = new ImportInformationMissingCollection();
        validator.validateArchive(archive, protocollo, validateDocuments, importInformationMissingCollection, userLogin, isShowCorrelazioneAsincronaInAccordi);
        ArchiveEngine importerEngine = new ArchiveEngine(driverRegistroServizi, driverConfigurazione);
        ImporterArchiveUtils importerArchiveUtils = new ImporterArchiveUtils(importerEngine, log, userLogin, nomePddOperativa, tipoPddDefault, isShowGestioneWorkflowStatoDocumenti, updateAbilitato);
        ArchiveEsitoImport result = importerArchiveUtils.importArchive(archive, userLogin, isShowAccordiColonnaAzioni, isAbilitatoControlloUnicitaImplementazioneAccordoPerSoggetto, isAbilitatoControlloUnicitaImplementazionePortTypePerSoggetto);
        String resultAsString = archiveEngine.toString(result, archiveMode);
        log.info((Object)resultAsString);
    }
}

