/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.archive;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.openspcoop2.core.commons.DBOggettiInUsoUtils;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaApplicativaByNome;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.protocol.engine.archive.AbstractArchiveEngine;
import org.openspcoop2.protocol.engine.archive.ImportInformationMissingException;
import org.openspcoop2.protocol.sdk.archive.Archive;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoCooperazione;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioComposto;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteComune;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteSpecifica;
import org.openspcoop2.protocol.sdk.archive.ArchiveEsitoDelete;
import org.openspcoop2.protocol.sdk.archive.ArchiveEsitoImportDetail;
import org.openspcoop2.protocol.sdk.archive.ArchiveEsitoImportDetailConfigurazione;
import org.openspcoop2.protocol.sdk.archive.ArchiveFruitore;
import org.openspcoop2.protocol.sdk.archive.ArchivePdd;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaApplicativa;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaDelegata;
import org.openspcoop2.protocol.sdk.archive.ArchiveServizioApplicativo;
import org.openspcoop2.protocol.sdk.archive.ArchiveSoggetto;
import org.openspcoop2.protocol.sdk.archive.IArchiveObject;
import org.openspcoop2.protocol.sdk.constants.ArchiveStatoImport;

public class DeleterArchiveUtils {
    private AbstractArchiveEngine importerEngine;
    private Logger log;
    private String userLogin;
    private static String NEW_LINE = "\n\t\t";

    public DeleterArchiveUtils(AbstractArchiveEngine importerEngine, Logger log, String userLogin) throws Exception {
        this.importerEngine = importerEngine;
        this.log = log;
        this.userLogin = userLogin;
    }

    public ArchiveEsitoDelete deleteArchive(Archive archive, String userLogin) throws Exception, ImportInformationMissingException {
        ArchiveEsitoImportDetail detail;
        ArchiveAccordoServizioParteSpecifica archiveAccordoServizioParteSpecifica;
        int i;
        ArchiveEsitoImportDetail detail2;
        int i2;
        ArchiveEsitoDelete esito = new ArchiveEsitoDelete();
        for (i2 = 0; i2 < archive.getPorteApplicative().size(); ++i2) {
            ArchivePortaApplicativa archivePortaApplicativa = (ArchivePortaApplicativa)archive.getPorteApplicative().get(i2);
            detail2 = new ArchiveEsitoImportDetail((IArchiveObject)archivePortaApplicativa);
            try {
                archivePortaApplicativa.update();
                this.deletePortaApplicativa(archivePortaApplicativa, detail2);
            }
            catch (Exception e) {
                detail2.setState(ArchiveStatoImport.ERROR);
                detail2.setException((Throwable)e);
            }
            esito.getPorteApplicative().add((Object)detail2);
        }
        for (i2 = 0; i2 < archive.getPorteDelegate().size(); ++i2) {
            ArchivePortaDelegata archivePortaDelegata = (ArchivePortaDelegata)archive.getPorteDelegate().get(i2);
            detail2 = new ArchiveEsitoImportDetail((IArchiveObject)archivePortaDelegata);
            try {
                archivePortaDelegata.update();
                this.deletePortaDelegata(archivePortaDelegata, detail2);
            }
            catch (Exception e) {
                detail2.setState(ArchiveStatoImport.ERROR);
                detail2.setException((Throwable)e);
            }
            esito.getPorteDelegate().add((Object)detail2);
        }
        for (i2 = 0; i2 < archive.getAccordiFruitori().size(); ++i2) {
            ArchiveFruitore archiveFruitore = (ArchiveFruitore)archive.getAccordiFruitori().get(i2);
            detail2 = new ArchiveEsitoImportDetail((IArchiveObject)archiveFruitore);
            try {
                archiveFruitore.update();
                this.deleteFruitore(archiveFruitore, detail2);
            }
            catch (Exception e) {
                detail2.setState(ArchiveStatoImport.ERROR);
                detail2.setException((Throwable)e);
            }
            esito.getAccordiFruitori().add((Object)detail2);
        }
        ArrayList<ArchiveAccordoServizioParteSpecifica> listAccordiServizioParteSpecifica = new ArrayList<ArchiveAccordoServizioParteSpecifica>();
        ArrayList<ArchiveAccordoServizioParteSpecifica> listAccordiServizioParteSpecifica_serviziComposti = new ArrayList<ArchiveAccordoServizioParteSpecifica>();
        for (i = 0; i < archive.getAccordiServizioParteSpecifica().size(); ++i) {
            archiveAccordoServizioParteSpecifica = (ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i);
            archiveAccordoServizioParteSpecifica.update();
            IDAccordo idAccordo = archiveAccordoServizioParteSpecifica.getIdAccordoServizioParteComune();
            if (this.importerEngine.existsAccordoServizioParteComune(idAccordo)) {
                AccordoServizioParteComune aspc = this.importerEngine.getAccordoServizioParteComune(idAccordo);
                if (aspc.getServizioComposto() != null) {
                    listAccordiServizioParteSpecifica_serviziComposti.add(archiveAccordoServizioParteSpecifica);
                    continue;
                }
                listAccordiServizioParteSpecifica.add(archiveAccordoServizioParteSpecifica);
                continue;
            }
            listAccordiServizioParteSpecifica_serviziComposti.add(archiveAccordoServizioParteSpecifica);
        }
        for (i = 0; i < listAccordiServizioParteSpecifica_serviziComposti.size(); ++i) {
            archiveAccordoServizioParteSpecifica = (ArchiveAccordoServizioParteSpecifica)listAccordiServizioParteSpecifica_serviziComposti.get(i);
            detail = new ArchiveEsitoImportDetail((IArchiveObject)archiveAccordoServizioParteSpecifica);
            try {
                this.deleteAccordoServizioParteSpecifica(archiveAccordoServizioParteSpecifica, true, detail);
            }
            catch (Exception e) {
                detail.setState(ArchiveStatoImport.ERROR);
                detail.setException((Throwable)e);
            }
            esito.getAccordiServizioParteSpecificaServiziComposti().add((Object)detail);
        }
        for (i = 0; i < archive.getAccordiServizioComposto().size(); ++i) {
            ArchiveAccordoServizioComposto archiveAccordoServizioComposto = (ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i);
            detail = new ArchiveEsitoImportDetail((IArchiveObject)archiveAccordoServizioComposto);
            try {
                archiveAccordoServizioComposto.update();
                this.deleteAccordoServizioComposto(archiveAccordoServizioComposto, detail);
            }
            catch (Exception e) {
                detail.setState(ArchiveStatoImport.ERROR);
                detail.setException((Throwable)e);
            }
            esito.getAccordiServizioComposto().add((Object)detail);
        }
        for (i = 0; i < listAccordiServizioParteSpecifica.size(); ++i) {
            archiveAccordoServizioParteSpecifica = (ArchiveAccordoServizioParteSpecifica)listAccordiServizioParteSpecifica.get(i);
            detail = new ArchiveEsitoImportDetail((IArchiveObject)archiveAccordoServizioParteSpecifica);
            try {
                this.deleteAccordoServizioParteSpecifica(archiveAccordoServizioParteSpecifica, false, detail);
            }
            catch (Exception e) {
                detail.setState(ArchiveStatoImport.ERROR);
                detail.setException((Throwable)e);
            }
            esito.getAccordiServizioParteSpecifica().add((Object)detail);
        }
        for (i = 0; i < archive.getAccordiServizioParteComune().size(); ++i) {
            ArchiveAccordoServizioParteComune archiveAccordoServizioParteComune = (ArchiveAccordoServizioParteComune)archive.getAccordiServizioParteComune().get(i);
            detail = new ArchiveEsitoImportDetail((IArchiveObject)archiveAccordoServizioParteComune);
            try {
                archiveAccordoServizioParteComune.update();
                this.deleteAccordoServizioParteComune(archiveAccordoServizioParteComune, detail);
            }
            catch (Exception e) {
                detail.setState(ArchiveStatoImport.ERROR);
                detail.setException((Throwable)e);
            }
            esito.getAccordiServizioParteComune().add((Object)detail);
        }
        for (i = 0; i < archive.getAccordiCooperazione().size(); ++i) {
            ArchiveAccordoCooperazione archiveAccordoCooperazione = (ArchiveAccordoCooperazione)archive.getAccordiCooperazione().get(i);
            detail = new ArchiveEsitoImportDetail((IArchiveObject)archiveAccordoCooperazione);
            try {
                archiveAccordoCooperazione.update();
                this.deleteAccordoCooperazione(archiveAccordoCooperazione, detail);
            }
            catch (Exception e) {
                detail.setState(ArchiveStatoImport.ERROR);
                detail.setException((Throwable)e);
            }
            esito.getAccordiCooperazione().add((Object)detail);
        }
        for (i = 0; i < archive.getServiziApplicativi().size(); ++i) {
            ArchiveServizioApplicativo archiveServizioApplicativo = (ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i);
            detail = new ArchiveEsitoImportDetail((IArchiveObject)archiveServizioApplicativo);
            try {
                archiveServizioApplicativo.update();
                this.deleteServizioApplicativo(archiveServizioApplicativo, detail);
            }
            catch (Exception e) {
                detail.setState(ArchiveStatoImport.ERROR);
                detail.setException((Throwable)e);
            }
            esito.getServiziApplicativi().add((Object)detail);
        }
        for (i = 0; i < archive.getSoggetti().size(); ++i) {
            ArchiveSoggetto archiveSoggetto = (ArchiveSoggetto)archive.getSoggetti().get(i);
            detail = new ArchiveEsitoImportDetail((IArchiveObject)archiveSoggetto);
            try {
                this.deleteSoggetto(archiveSoggetto, detail);
            }
            catch (Exception e) {
                detail.setState(ArchiveStatoImport.ERROR);
                detail.setException((Throwable)e);
            }
            esito.getSoggetti().add((Object)detail);
        }
        for (i = 0; i < archive.getPdd().size(); ++i) {
            ArchivePdd archivePdd = (ArchivePdd)archive.getPdd().get(i);
            detail = new ArchiveEsitoImportDetail((IArchiveObject)archivePdd);
            try {
                this.deletePdd(archivePdd, detail);
            }
            catch (Exception e) {
                detail.setState(ArchiveStatoImport.ERROR);
                detail.setException((Throwable)e);
            }
            esito.getPdd().add((Object)detail);
        }
        return esito;
    }

    public void deletePdd(ArchivePdd archivePdd, ArchiveEsitoImportDetail detail) {
        String nomePdd = archivePdd.getNomePdd();
        try {
            if (!this.importerEngine.existsPortaDominio(nomePdd)) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            PortaDominio pddReadFromDb = this.importerEngine.getPortaDominio(nomePdd);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(pddReadFromDb.getSuperUser())) {
                throw new Exception("La Porta di Dominio [" + nomePdd + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            ArrayList<String> whereIsInUso = new ArrayList<String>();
            if (this.importerEngine.isPddInUso(nomePdd, whereIsInUso)) {
                throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString((String)nomePdd, whereIsInUso, (boolean)false, (String)NEW_LINE));
            }
            this.importerEngine.deletePortaDominio(archivePdd.getPortaDominio());
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante l'eliminazione della porta di dominio [" + nomePdd + "]: " + e.getMessage()), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void deleteSoggetto(ArchiveSoggetto archiveSoggetto, ArchiveEsitoImportDetail detail) {
        IDSoggetto idSoggetto = archiveSoggetto.getIdSoggetto();
        try {
            boolean delete = false;
            if (archiveSoggetto.getSoggettoRegistro() != null && this.importerEngine.existsSoggettoRegistro(idSoggetto)) {
                Soggetto old = this.importerEngine.getSoggettoRegistro(idSoggetto);
                if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(old.getSuperUser())) {
                    throw new Exception("Il soggetto non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
                }
                HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
                if (this.importerEngine.isSoggettoRegistroInUso(idSoggetto, whereIsInUso)) {
                    throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString((IDSoggetto)idSoggetto, whereIsInUso, (boolean)false, (String)NEW_LINE));
                }
                this.importerEngine.deleteSoggettoRegistro(archiveSoggetto.getSoggettoRegistro());
                delete = true;
            }
            if (archiveSoggetto.getSoggettoConfigurazione() != null && this.importerEngine.existsSoggettoConfigurazione(idSoggetto)) {
                HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
                if (this.importerEngine.isSoggettoConfigurazioneInUso(idSoggetto, whereIsInUso)) {
                    throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString((IDSoggetto)idSoggetto, whereIsInUso, (boolean)false, (String)NEW_LINE));
                }
                this.importerEngine.deleteSoggettoConfigurazione(archiveSoggetto.getSoggettoConfigurazione());
                delete = true;
            }
            if (delete) {
                detail.setState(ArchiveStatoImport.DELETED);
            } else {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante l'eliminazione del soggetto [" + idSoggetto + "]: " + e.getMessage()), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void deleteServizioApplicativo(ArchiveServizioApplicativo archiveServizioApplicativo, ArchiveEsitoImportDetail detail) {
        IDServizioApplicativo idServizioApplicativo = archiveServizioApplicativo.getIdServizioApplicativo();
        IDSoggetto idSoggettoProprietario = archiveServizioApplicativo.getIdSoggettoProprietario();
        try {
            if (!this.importerEngine.existsServizioApplicativo(idServizioApplicativo)) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            org.openspcoop2.core.config.Soggetto soggetto = this.importerEngine.getSoggettoConfigurazione(idSoggettoProprietario);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggetto.getSuperUser())) {
                throw new Exception("Il soggetto proprietario [" + idSoggettoProprietario + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
            if (this.importerEngine.isServizioApplicativoInUso(idServizioApplicativo, whereIsInUso)) {
                throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString((IDServizioApplicativo)idServizioApplicativo, whereIsInUso, (boolean)false, (String)NEW_LINE));
            }
            this.importerEngine.deleteServizioApplicativo(archiveServizioApplicativo.getServizioApplicativo());
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante l'eliminazione del servizio applicativo [" + idServizioApplicativo + "]: " + e.getMessage()), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void deleteAccordoCooperazione(ArchiveAccordoCooperazione archiveAccordoCooperazione, ArchiveEsitoImportDetail detail) {
        IDAccordoCooperazione idAccordoCooperazione = archiveAccordoCooperazione.getIdAccordoCooperazione();
        try {
            if (!this.importerEngine.existsAccordoCooperazione(idAccordoCooperazione)) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            AccordoCooperazione acReadFromDb = this.importerEngine.getAccordoCooperazione(idAccordoCooperazione);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(acReadFromDb.getSuperUser())) {
                throw new Exception("L'accordo di cooperazione [" + idAccordoCooperazione + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
            if (this.importerEngine.isAccordoCooperazioneInUso(idAccordoCooperazione, whereIsInUso)) {
                throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString((IDAccordoCooperazione)idAccordoCooperazione, whereIsInUso, (boolean)false, (String)NEW_LINE));
            }
            this.importerEngine.deleteAccordoCooperazione(archiveAccordoCooperazione.getAccordoCooperazione());
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante l'eliminazione dell'accordo di cooperazione [" + idAccordoCooperazione + "]: " + e.getMessage()), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void deleteAccordoServizioParteComune(ArchiveAccordoServizioParteComune archiveAccordoServizioParteComune, ArchiveEsitoImportDetail detail) {
        IDAccordo idAccordoServizioParteComune = archiveAccordoServizioParteComune.getIdAccordoServizioParteComune();
        try {
            if (!this.importerEngine.existsAccordoServizioParteComune(idAccordoServizioParteComune)) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            AccordoServizioParteComune aspcReadFromDb = this.importerEngine.getAccordoServizioParteComune(idAccordoServizioParteComune);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(aspcReadFromDb.getSuperUser())) {
                throw new Exception("L'accordo di servizio parte comune [" + idAccordoServizioParteComune + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
            if (this.importerEngine.isAccordoServizioParteComuneInUso(idAccordoServizioParteComune, whereIsInUso)) {
                throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString((IDAccordo)idAccordoServizioParteComune, whereIsInUso, (boolean)false, (String)NEW_LINE));
            }
            this.importerEngine.deleteAccordoServizioParteComune(archiveAccordoServizioParteComune.getAccordoServizioParteComune());
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante l'eliminazione dell'accordo di servizio parte comune [" + idAccordoServizioParteComune + "]: " + e.getMessage()), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void deleteAccordoServizioComposto(ArchiveAccordoServizioComposto archiveAccordoServizioComposto, ArchiveEsitoImportDetail detail) {
        IDAccordo idAccordoServizioComposto = archiveAccordoServizioComposto.getIdAccordoServizioParteComune();
        try {
            if (!this.importerEngine.existsAccordoServizioParteComune(idAccordoServizioComposto)) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            AccordoServizioParteComune ascReadFromDb = this.importerEngine.getAccordoServizioParteComune(idAccordoServizioComposto);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(ascReadFromDb.getSuperUser())) {
                throw new Exception("L'accordo di servizio composto [" + idAccordoServizioComposto + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
            if (this.importerEngine.isAccordoServizioParteComuneInUso(idAccordoServizioComposto, whereIsInUso)) {
                throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString((IDAccordo)idAccordoServizioComposto, whereIsInUso, (boolean)false, (String)NEW_LINE));
            }
            this.importerEngine.deleteAccordoServizioParteComune(archiveAccordoServizioComposto.getAccordoServizioParteComune());
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante l'eliminazione dell'accordo di servizio parte comune [" + idAccordoServizioComposto + "]: " + e.getMessage()), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void deleteAccordoServizioParteSpecifica(ArchiveAccordoServizioParteSpecifica archiveAccordoServizioParteSpecifica, boolean servizioComposto, ArchiveEsitoImportDetail detail) {
        IDAccordo idAccordoServizioParteSpecifica = archiveAccordoServizioParteSpecifica.getIdAccordoServizioParteSpecifica();
        try {
            if (!this.importerEngine.existsAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica)) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            AccordoServizioParteSpecifica aspsReadFromDb = this.importerEngine.getAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(aspsReadFromDb.getSuperUser())) {
                throw new Exception("L'accordo di servizio parte specifica [" + idAccordoServizioParteSpecifica + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
            if (this.importerEngine.isAccordoServizioParteSpecificaInUso(archiveAccordoServizioParteSpecifica.getIdServizio(), whereIsInUso)) {
                throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString((IDServizio)archiveAccordoServizioParteSpecifica.getIdServizio(), whereIsInUso, (boolean)false, (String)NEW_LINE));
            }
            this.importerEngine.deleteAccordoServizioParteSpecifica(archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica());
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante l'eliminazione dell'accordo di servizio parte specifica [" + idAccordoServizioParteSpecifica + "]: " + e.getMessage()), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void deleteFruitore(ArchiveFruitore archiveFruitore, ArchiveEsitoImportDetail detail) {
        IDAccordo idAccordoServizioParteSpecifica = archiveFruitore.getIdAccordoServizioParteSpecifica();
        IDSoggetto idSoggettoFruitore = archiveFruitore.getIdSoggettoFruitore();
        try {
            AccordoServizioParteSpecifica oldAccordo = null;
            Fruitore old = null;
            if (this.importerEngine.existsAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica)) {
                oldAccordo = this.importerEngine.getAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica);
                for (int i = 0; i < oldAccordo.sizeFruitoreList(); ++i) {
                    Fruitore check = oldAccordo.getFruitore(i);
                    if (!check.getTipo().equals(idSoggettoFruitore.getTipo()) || !check.getNome().equals(idSoggettoFruitore.getNome())) continue;
                    old = oldAccordo.removeFruitore(i);
                    break;
                }
            }
            if (old == null) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            Soggetto soggetto = this.importerEngine.getSoggettoRegistro(idSoggettoFruitore);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggetto.getSuperUser())) {
                throw new Exception("Il soggetto fruitore [" + idSoggettoFruitore + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(oldAccordo.getSuperUser())) {
                throw new Exception("L'accordo di servizio parte specifica [" + idAccordoServizioParteSpecifica + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            if (archiveFruitore.getServiziApplicativiAutorizzati() != null && archiveFruitore.getServiziApplicativiAutorizzati().size() > 0) {
                List<IDServizioApplicativo> listaAttuale = null;
                try {
                    listaAttuale = this.importerEngine.getAllIdServiziApplicativiAutorizzati(archiveFruitore.getIdAccordoServizioParteSpecifica(), archiveFruitore.getIdSoggettoFruitore());
                }
                catch (DriverRegistroServiziNotFound notFound) {
                    // empty catch block
                }
                if (listaAttuale == null) {
                    listaAttuale = new ArrayList<IDServizioApplicativo>();
                }
                for (String nomeServizioApplicativo : archiveFruitore.getServiziApplicativiAutorizzati()) {
                    boolean found = false;
                    for (IDServizioApplicativo idServizioApplicativo : listaAttuale) {
                        if (!idServizioApplicativo.getNome().equals(nomeServizioApplicativo)) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    this.importerEngine.deleteServizioApplicativoAutorizzato(archiveFruitore.getIdAccordoServizioParteSpecifica(), archiveFruitore.getIdSoggettoFruitore(), nomeServizioApplicativo);
                }
            }
            oldAccordo.getServizio().setOldTipoForUpdate(oldAccordo.getServizio().getTipo());
            oldAccordo.getServizio().setOldNomeForUpdate(oldAccordo.getServizio().getNome());
            oldAccordo.getServizio().setOldTipoSoggettoErogatoreForUpdate(oldAccordo.getServizio().getTipoSoggettoErogatore());
            oldAccordo.getServizio().setOldNomeSoggettoErogatoreForUpdate(oldAccordo.getServizio().getNomeSoggettoErogatore());
            this.importerEngine.updateAccordoServizioParteSpecifica(oldAccordo);
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante l'eliminazione del fruitore[" + idSoggettoFruitore + "] dell'accordo di servizio parte specifica [" + idAccordoServizioParteSpecifica + "]: " + e.getMessage()), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void deletePortaDelegata(ArchivePortaDelegata archivePortaDelegata, ArchiveEsitoImportDetail detail) {
        IDPortaDelegata idPortaDelegata = archivePortaDelegata.getIdPortaDelegata();
        IDSoggetto idSoggettoProprietario = archivePortaDelegata.getIdSoggettoProprietario();
        try {
            if (!this.importerEngine.existsPortaDelegata(idPortaDelegata)) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            org.openspcoop2.core.config.Soggetto soggetto = this.importerEngine.getSoggettoConfigurazione(idSoggettoProprietario);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggetto.getSuperUser())) {
                throw new Exception("Il soggetto proprietario [" + idSoggettoProprietario + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            PortaDelegata portaDelegata = archivePortaDelegata.getPortaDelegata();
            this.importerEngine.deletePortaDelegata(portaDelegata);
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante l'eliminazione della porta delegata [" + idPortaDelegata + "]: " + e.getMessage()), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void deletePortaApplicativa(ArchivePortaApplicativa archivePortaApplicativa, ArchiveEsitoImportDetail detail) {
        IDPortaApplicativa idPortaApplicativa = archivePortaApplicativa.getIdPortaApplicativa();
        IDPortaApplicativaByNome idPortaApplicativaByNome = archivePortaApplicativa.getIdPortaApplicativaByNome();
        IDSoggetto idSoggettoProprietario = archivePortaApplicativa.getIdSoggettoProprietario();
        try {
            if (!this.importerEngine.existsPortaApplicativa(idPortaApplicativaByNome.getNome(), idSoggettoProprietario)) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            org.openspcoop2.core.config.Soggetto soggetto = this.importerEngine.getSoggettoConfigurazione(idSoggettoProprietario);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggetto.getSuperUser())) {
                throw new Exception("Il soggetto proprietario [" + idSoggettoProprietario + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            PortaApplicativa pa = archivePortaApplicativa.getPortaApplicativa();
            this.importerEngine.deletePortaApplicativa(pa);
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante l'eliminazione della porta applicativa [" + idPortaApplicativa + "]: " + e.getMessage()), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void importConfigurazione(Configurazione configurazionePdD, ArchiveEsitoImportDetailConfigurazione detail) {
        try {
            this.importerEngine.updateConfigurazione(configurazionePdD);
            detail.setState(ArchiveStatoImport.UPDATED);
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante l'import della configurazione: " + e.getMessage()), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }
}

