/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.archive;

import java.util.ArrayList;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.archive.ImportInformationMissingCollection;
import org.openspcoop2.protocol.engine.archive.ImportInformationMissingException;
import org.openspcoop2.protocol.engine.archive.ImporterInformationMissingSetter;
import org.openspcoop2.protocol.engine.archive.ImporterInformationMissingUtils;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.archive.Archive;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoCooperazione;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioComposto;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteComune;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteSpecifica;
import org.openspcoop2.protocol.sdk.archive.ArchiveFruitore;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaApplicativa;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaDelegata;
import org.openspcoop2.protocol.sdk.archive.ArchiveServizioApplicativo;
import org.openspcoop2.protocol.sdk.archive.IRegistryReader;

public class ArchiveValidator {
    private IRegistryReader registryReader;

    public ArchiveValidator(IRegistryReader registryReader) {
        this.registryReader = registryReader;
    }

    public void validateArchive(Archive archive, String protocolloEffettivo, boolean validazioneDocumenti, ImportInformationMissingCollection importInformationMissingCollection, String userLogin, boolean checkCorrelazioneAsincrona) throws Exception, ImportInformationMissingException {
        try {
            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocolloEffettivo);
            this.validateAndFillImportInformationMissing(archive, protocolFactory, importInformationMissingCollection, validazioneDocumenti, userLogin, checkCorrelazioneAsincrona);
        }
        catch (ImportInformationMissingException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    private void validateAndFillImportInformationMissing(Archive archive, IProtocolFactory protocolFactory, ImportInformationMissingCollection importInformationMissingCollection, boolean validazioneDocumenti, String userLogin, boolean checkCorrelazioneAsincrona) throws Exception, ImportInformationMissingException {
        int i;
        int i2;
        ImporterInformationMissingUtils importerInformationMissingUtils = new ImporterInformationMissingUtils(importInformationMissingCollection, this.registryReader, validazioneDocumenti, protocolFactory, userLogin, archive);
        if (archive.getInformationMissing() != null) {
            importerInformationMissingUtils.validateAndFillInformationMissing(archive.getInformationMissing());
        }
        for (i2 = 0; i2 < archive.getServiziApplicativi().size(); ++i2) {
            importerInformationMissingUtils.validateAndFillServizioApplicativo((ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i2));
        }
        for (i2 = 0; i2 < archive.getPorteDelegate().size(); ++i2) {
            importerInformationMissingUtils.validateAndFillPortaDelegata((ArchivePortaDelegata)archive.getPorteDelegate().get(i2));
        }
        for (i2 = 0; i2 < archive.getPorteApplicative().size(); ++i2) {
            importerInformationMissingUtils.validateAndFillPortaApplicativa((ArchivePortaApplicativa)archive.getPorteApplicative().get(i2));
        }
        for (i2 = 0; i2 < archive.getAccordiCooperazione().size(); ++i2) {
            importerInformationMissingUtils.validateAndFillAccordoCooperazione((ArchiveAccordoCooperazione)archive.getAccordiCooperazione().get(i2));
        }
        for (i2 = 0; i2 < archive.getAccordiServizioParteComune().size(); ++i2) {
            importerInformationMissingUtils.validateAndFillAccordoServizioParteComune((ArchiveAccordoServizioParteComune)archive.getAccordiServizioParteComune().get(i2), checkCorrelazioneAsincrona);
        }
        ArrayList<ArchiveAccordoServizioParteSpecifica> listServiziImplementanoAccordiServizioCompostoPresentiArchivio = new ArrayList<ArchiveAccordoServizioParteSpecifica>();
        for (i = 0; i < archive.getAccordiServizioParteSpecifica().size(); ++i) {
            ArchiveAccordoServizioParteSpecifica archiveServizio = (ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i);
            String uriAccordoServizioParteComune = archiveServizio.getAccordoServizioParteSpecifica().getAccordoServizioParteComune();
            boolean found = false;
            for (int j = 0; j < archive.getAccordiServizioComposto().size(); ++j) {
                AccordoServizioParteComune as = ((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(j)).getAccordoServizioParteComune();
                String uri = IDAccordoFactory.getInstance().getUriFromAccordo(as);
                if (!uriAccordoServizioParteComune.equals(uri)) continue;
                found = true;
                listServiziImplementanoAccordiServizioCompostoPresentiArchivio.add(archiveServizio);
                break;
            }
            if (found) continue;
            importerInformationMissingUtils.validateAndFillAccordoServizioParteSpecifica((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i));
        }
        for (i = 0; i < archive.getAccordiServizioComposto().size(); ++i) {
            importerInformationMissingUtils.validateAndFillAccordoServizioParteComune((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i), checkCorrelazioneAsincrona);
        }
        for (ArchiveAccordoServizioParteSpecifica archiveAccordoServizioParteSpecifica : listServiziImplementanoAccordiServizioCompostoPresentiArchivio) {
            importerInformationMissingUtils.validateAndFillAccordoServizioParteSpecifica(archiveAccordoServizioParteSpecifica);
        }
        for (int i3 = 0; i3 < archive.getAccordiFruitori().size(); ++i3) {
            importerInformationMissingUtils.validateAndFillFruitore((ArchiveFruitore)archive.getAccordiFruitori().get(i3));
        }
        ImporterInformationMissingSetter.replaceTemplatesNames(archive);
    }
}

