/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.archive;

import java.util.List;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicerca;
import org.openspcoop2.core.registry.driver.FiltroRicercaAccordi;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.protocol.sdk.archive.FiltroRicercaServizi;
import org.openspcoop2.protocol.sdk.archive.IRegistryReader;
import org.openspcoop2.protocol.sdk.archive.RegistryNotFound;

public class ArchiveRegistryReader
implements IRegistryReader {
    private DriverRegistroServiziDB driverRegistroServiziDB;
    private DriverConfigurazioneDB driverConfigurazioneDB;

    public ArchiveRegistryReader(DriverRegistroServiziDB driverRegistroServiziDB, DriverConfigurazioneDB driverConfigurazioneDB) throws Exception {
        this.driverRegistroServiziDB = driverRegistroServiziDB;
        this.driverConfigurazioneDB = driverConfigurazioneDB;
    }

    public boolean existsPortaDominio(String nome) {
        try {
            return this.driverRegistroServiziDB.existsPortaDominio(nome);
        }
        catch (Exception e) {
            return false;
        }
    }

    public List<String> findPorteDominio(boolean operativo) throws RegistryNotFound {
        try {
            FiltroRicerca filtroRicerca = new FiltroRicerca();
            if (operativo) {
                filtroRicerca.setTipo("operativo");
            } else {
                filtroRicerca.setTipo("esterno");
            }
            return this.driverRegistroServiziDB.getAllIdPorteDominio(filtroRicerca);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), (Throwable)de);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean existsSoggettoByCodiceIPA(String codiceIPA) {
        try {
            return this.driverRegistroServiziDB.existsSoggetto(codiceIPA);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean existsSoggetto(IDSoggetto idSoggetto) {
        try {
            return this.driverRegistroServiziDB.existsSoggetto(idSoggetto);
        }
        catch (Exception e) {
            return false;
        }
    }

    public IDSoggetto getIdSoggettoByCodiceIPA(String codiceIPA) throws RegistryNotFound {
        try {
            Soggetto s = this.driverRegistroServiziDB.getSoggetto(codiceIPA);
            IDSoggetto idSoggetto = new IDSoggetto(s.getTipo(), s.getNome(), s.getIdentificativoPorta());
            return idSoggetto;
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), (Throwable)de);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getCodiceIPA(IDSoggetto idSoggetto) throws RegistryNotFound {
        try {
            return this.driverRegistroServiziDB.getCodiceIPA(idSoggetto);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), (Throwable)de);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Soggetto getSoggetto(IDSoggetto idSoggetto) throws RegistryNotFound {
        try {
            return this.driverRegistroServiziDB.getSoggetto(idSoggetto);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), (Throwable)de);
        }
        catch (Exception e) {
            return null;
        }
    }

    public AccordoServizioParteComune getAccordoServizioParteComune(IDAccordo idAccordo) throws RegistryNotFound {
        try {
            return this.driverRegistroServiziDB.getAccordoServizioParteComune(idAccordo);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), (Throwable)de);
        }
        catch (Exception e) {
            return null;
        }
    }

    public AccordoServizioParteComune getAccordoServizioParteComune(IDAccordo idAccordo, boolean readAllegati) throws RegistryNotFound {
        try {
            return this.driverRegistroServiziDB.getAccordoServizioParteComune(idAccordo, readAllegati);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), (Throwable)de);
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<IDAccordo> findAccordiServizioParteComune(org.openspcoop2.protocol.sdk.archive.FiltroRicercaAccordi filtro) throws RegistryNotFound {
        try {
            FiltroRicercaAccordi filtroRicerca = new FiltroRicercaAccordi();
            if (filtro.getNome() != null) {
                filtroRicerca.setNomeAccordo(filtro.getNome());
            }
            if (filtro.getVersione() != null) {
                filtroRicerca.setVersione(filtro.getVersione() + "");
            }
            if (filtro.getSoggetto() != null) {
                if (filtro.getSoggetto().getTipo() != null) {
                    filtroRicerca.setTipoSoggettoReferente(filtro.getSoggetto().getTipo());
                }
                if (filtro.getSoggetto().getNome() != null) {
                    filtroRicerca.setNomeSoggettoReferente(filtro.getSoggetto().getNome());
                }
            }
            return this.driverRegistroServiziDB.getAllIdAccordiServizioParteComune(filtroRicerca);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), (Throwable)de);
        }
        catch (Exception e) {
            return null;
        }
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDAccordo idAccordo) throws RegistryNotFound {
        try {
            return this.driverRegistroServiziDB.getAccordoServizioParteSpecifica(idAccordo);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), (Throwable)de);
        }
        catch (Exception e) {
            return null;
        }
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDAccordo idAccordo, boolean readAllegati) throws RegistryNotFound {
        try {
            return this.driverRegistroServiziDB.getAccordoServizioParteSpecifica(idAccordo, readAllegati);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), (Throwable)de);
        }
        catch (Exception e) {
            return null;
        }
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idServizio) throws RegistryNotFound {
        try {
            return this.driverRegistroServiziDB.getAccordoServizioParteSpecifica(idServizio);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), (Throwable)de);
        }
        catch (Exception e) {
            return null;
        }
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idServizio, boolean readAllegati) throws RegistryNotFound {
        try {
            return this.driverRegistroServiziDB.getAccordoServizioParteSpecifica(idServizio, readAllegati);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), (Throwable)de);
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<IDAccordo> findAccordiServizioParteSpecifica(FiltroRicercaServizi filtro) throws RegistryNotFound {
        try {
            org.openspcoop2.core.registry.driver.FiltroRicercaServizi filtroRicerca = new org.openspcoop2.core.registry.driver.FiltroRicercaServizi();
            if (filtro.getTipo() != null) {
                filtroRicerca.setTipo(filtro.getTipo());
            }
            if (filtro.getNome() != null) {
                filtroRicerca.setNome(filtro.getNome());
            }
            if (filtro.getSoggetto() != null) {
                if (filtro.getSoggetto().getTipo() != null) {
                    filtroRicerca.setTipoSoggettoErogatore(filtro.getSoggetto().getTipo());
                }
                if (filtro.getSoggetto().getNome() != null) {
                    filtroRicerca.setNomeSoggettoErogatore(filtro.getSoggetto().getNome());
                }
            }
            return this.driverRegistroServiziDB.getAllIdAccordiServizioParteSpecifica(filtroRicerca);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), (Throwable)de);
        }
        catch (Exception e) {
            return null;
        }
    }

    public IDServizio convertToIDServizio(IDAccordo idAccordoServizioParteSpecifica) throws RegistryNotFound {
        try {
            AccordoServizioParteSpecifica as = this.driverRegistroServiziDB.getAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica);
            IDServizio idServizio = new IDServizio(idAccordoServizioParteSpecifica.getSoggettoReferente(), as.getServizio().getTipo(), as.getServizio().getNome());
            return idServizio;
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), (Throwable)de);
        }
        catch (Exception e) {
            return null;
        }
    }

    public IDAccordo convertToIDAccordo(IDServizio idServizio) throws RegistryNotFound {
        try {
            AccordoServizioParteSpecifica as = this.driverRegistroServiziDB.getAccordoServizioParteSpecifica(idServizio);
            return IDAccordoFactory.getInstance().getIDAccordoFromAccordo(as);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), (Throwable)de);
        }
        catch (Exception e) {
            return null;
        }
    }

    public AccordoCooperazione getAccordoCooperazione(IDAccordoCooperazione idAccordo) throws RegistryNotFound {
        try {
            return this.driverRegistroServiziDB.getAccordoCooperazione(idAccordo);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), (Throwable)de);
        }
        catch (Exception e) {
            return null;
        }
    }

    public AccordoCooperazione getAccordoCooperazione(IDAccordoCooperazione idAccordo, boolean readAllegati) throws RegistryNotFound {
        try {
            return this.driverRegistroServiziDB.getAccordoCooperazione(idAccordo, readAllegati);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), (Throwable)de);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean existsServizioApplicativo(IDServizioApplicativo idServizioApplicativo) {
        try {
            return this.driverConfigurazioneDB.existsServizioApplicativo(idServizioApplicativo);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean existsServizioApplicativo(String username, String password) {
        try {
            return this.driverConfigurazioneDB.getServizioApplicativoAutenticato(username, password) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean existsServizioApplicativo(String subject) {
        try {
            return this.driverConfigurazioneDB.getServizioApplicativoAutenticato(subject) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public ServizioApplicativo getServizioApplicativo(IDServizioApplicativo idServizioApplicativo) throws RegistryNotFound {
        try {
            return this.driverConfigurazioneDB.getServizioApplicativo(idServizioApplicativo);
        }
        catch (DriverConfigurazioneNotFound de) {
            throw new RegistryNotFound(de.getMessage(), (Throwable)de);
        }
        catch (Exception e) {
            return null;
        }
    }
}

