/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.resources.TransportRequestContext;

public class URLProtocolContext
extends TransportRequestContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PA_FUNCTION = "PA";
    public static final String PD_FUNCTION = "PD";
    public static final String PDtoSOAP_FUNCTION = "PDtoSOAP";
    public static final String IntegrationManager_FUNCTION = "IntegrationManager";
    public static final String IntegrationManager_ENGINE = "IntegrationManagerEngine";
    public static final String IntegrationManager_FUNCTION_PD = "IntegrationManager/PD";
    public static final String IntegrationManager_FUNCTION_MessageBox = "IntegrationManager/MessageBox";
    public static final String API_ENGINE = "API";
    public static final String API_FUNCTION_PD = "PD";
    public static final String API_FUNCTION_PA = "PA";
    public static final String API_FUNCTION_MessageBox = "MessageBox";
    public static final String CheckPdD_FUNCTION = "checkPdD";

    public URLProtocolContext() throws ProtocolException, UtilsException {
    }

    public URLProtocolContext(HttpServletRequest req, Logger logCore) throws ProtocolException, UtilsException {
        String servletContext = req.getContextPath();
        String urlInvocazione = req.getRequestURI();
        String servizioInvocato = null;
        if (logCore != null) {
            logCore.debug((Object)("SERVLET CONTEXT [" + servletContext + "] URL[" + urlInvocazione + "]"));
        }
        try {
            int sizePrefix;
            this.parametersFormBased = new Properties();
            Enumeration en = req.getParameterNames();
            while (en.hasMoreElements()) {
                String nomeProperty = (String)en.nextElement();
                this.parametersFormBased.setProperty(nomeProperty, req.getParameter(nomeProperty));
            }
            this.parametersTrasporto = new Properties();
            Enumeration enTrasporto = req.getHeaderNames();
            while (enTrasporto.hasMoreElements()) {
                String nomeProperty = (String)enTrasporto.nextElement();
                this.parametersTrasporto.setProperty(nomeProperty, req.getHeader(nomeProperty));
            }
            if (!urlInvocazione.startsWith(servletContext + "/")) {
                throw new Exception("OpenSPCoop2 [protocol/]service to be used not supplied (context error)");
            }
            servizioInvocato = urlInvocazione.substring((servletContext + "/").length());
            if (logCore != null) {
                logCore.debug((Object)("SERVIZIO RICHIESTO: [" + servizioInvocato + "]"));
            }
            if (servizioInvocato == null || "".equals(servizioInvocato.trim())) {
                throw new Exception("OpenSPCoop2 [protocol/]service to be used not supplied");
            }
            String protocollo = null;
            String function = null;
            String functionParameters = null;
            if (servizioInvocato.indexOf("/") >= 0) {
                protocollo = servizioInvocato.substring(0, servizioInvocato.indexOf("/"));
                function = servizioInvocato.substring(servizioInvocato.indexOf("/") + 1, servizioInvocato.length());
            } else {
                protocollo = servizioInvocato;
                function = servizioInvocato;
            }
            if (logCore != null) {
                logCore.debug((Object)("PROTOCOLLO[" + protocollo + "] FUNCTION[" + function + "]"));
            }
            if (protocollo.equals("PA") || protocollo.equals("PD") || protocollo.equals(PDtoSOAP_FUNCTION) || protocollo.equals(IntegrationManager_FUNCTION) || protocollo.equals(API_ENGINE) || protocollo.equals(CheckPdD_FUNCTION)) {
                if (logCore != null) {
                    logCore.debug((Object)"SERVLET PATH EMPTY");
                }
                function = protocollo;
                protocollo = "@EMPTY@";
                sizePrefix = (req.getContextPath() + "/" + function + "/").length();
                if (req.getRequestURI().length() > sizePrefix) {
                    functionParameters = req.getRequestURI().substring(sizePrefix);
                }
            } else {
                if (function.indexOf("/") > 0) {
                    function = function.substring(0, function.indexOf("/"));
                } else if (function.indexOf("?") > 0) {
                    function = function.substring(0, function.indexOf("?"));
                }
                if (logCore != null) {
                    logCore.debug((Object)("FUNCTION [" + function + "]"));
                }
                sizePrefix = (req.getContextPath() + "/" + protocollo + "/" + function + "/").length();
                if (req.getRequestURI().length() > sizePrefix) {
                    functionParameters = req.getRequestURI().substring(sizePrefix);
                }
            }
            if (API_ENGINE.equals(function)) {
                if (functionParameters == null) {
                    throw new Exception("API Service invocation without context (PD,PA,MessageBox)");
                }
                String functionApi = functionParameters;
                if (functionParameters.contains("/")) {
                    functionApi = functionParameters.substring(0, functionParameters.indexOf("/"));
                }
                if ("PD".equals(functionApi) || "PA".equals(functionApi) || API_FUNCTION_MessageBox.equals(functionApi)) {
                    function = "API/" + functionApi;
                    functionParameters = functionParameters.length() > (functionApi + "/").length() ? functionParameters.substring((functionApi + "/").length()) : null;
                }
            }
            if (logCore != null) {
                logCore.debug((Object)("Elaborazione finale Protocollo[" + protocollo + "] Function[" + function + "] FunctionParameters [" + functionParameters + "]"));
            }
            this.webContext = req.getContextPath();
            this.requestURI = req.getRequestURI();
            this.protocol = protocollo;
            this.function = function;
            this.functionParameters = functionParameters;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }
}

