/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.validator;

import java.util.Vector;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPHeader;
import org.apache.log4j.Logger;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.protocol.engine.Configurazione;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.builder.ProprietaManifestAttachments;
import org.openspcoop2.protocol.sdk.config.IProtocolManager;
import org.openspcoop2.protocol.sdk.constants.ErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.validator.IValidazioneSintattica;
import org.openspcoop2.protocol.sdk.validator.ProprietaValidazioneErrori;
import org.openspcoop2.protocol.sdk.validator.ValidazioneSintatticaResult;

public class ValidazioneSintattica {
    protected OpenSPCoop2Message msg;
    protected SOAPHeader headerSOAP = null;
    protected SOAPElement headerProtocollo;
    protected Vector<Eccezione> erroriValidazione;
    protected Vector<Eccezione> erroriProcessamento;
    protected Vector<Eccezione> errorsTrovatiSullaListaEccezioni;
    protected Busta busta;
    protected Boolean isRichiesta;
    protected ErroreCooperazione errore;
    protected boolean readQualifiedAttribute;
    protected Logger log = null;
    protected boolean segnalazioneElementoPresentePiuVolte = false;
    private IProtocolFactory protocolFactory;
    private IProtocolManager protocolManager;
    protected boolean messaggioScaduto = false;
    protected Busta bustaErroreHeaderIntestazione = null;
    private IState state;

    public SOAPElement getProtocolHeader() {
        return this.headerProtocollo;
    }

    public void setHeaderSOAP(SOAPHeader headerSOAP) {
        this.headerSOAP = headerSOAP;
    }

    public Busta getBustaErroreHeaderIntestazione() {
        return this.bustaErroreHeaderIntestazione;
    }

    public ValidazioneSintattica(IState state, OpenSPCoop2Message aMsg, boolean readQualifiedAttribute, IProtocolFactory protocolFactory) throws ProtocolException {
        this(state, aMsg, Configurazione.getLibraryLog(), readQualifiedAttribute, protocolFactory);
    }

    public ValidazioneSintattica(IState state, OpenSPCoop2Message aMsg, IProtocolFactory protocolFactory) throws ProtocolException {
        this(state, aMsg, Configurazione.getLibraryLog(), false, protocolFactory);
    }

    public ValidazioneSintattica(IState state, OpenSPCoop2Message aMsg, Logger alog, IProtocolFactory protocolFactory) throws ProtocolException {
        this(state, aMsg, alog, false, protocolFactory);
    }

    public ValidazioneSintattica(IState state, OpenSPCoop2Message aMsg, Busta busta, Boolean isRichiesta, Logger alog, boolean readQualifiedAttribute, IProtocolFactory protocolFactory) throws ProtocolException {
        this(state, aMsg, alog, readQualifiedAttribute, protocolFactory);
        this.busta = busta;
        this.isRichiesta = isRichiesta;
    }

    public ValidazioneSintattica(IState state, OpenSPCoop2Message aMsg, Logger alog, boolean readQualifiedAttribute, IProtocolFactory protocolFactory) throws ProtocolException {
        this.state = state;
        this.msg = aMsg;
        this.log = alog != null ? alog : Logger.getLogger((String)ValidazioneSintattica.class.getName());
        this.readQualifiedAttribute = readQualifiedAttribute;
        this.protocolFactory = protocolFactory;
        this.protocolManager = this.protocolFactory.createProtocolManager();
    }

    public IProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    public Busta getBusta() {
        return this.busta;
    }

    public Vector<Eccezione> getEccezioniValidazione() {
        return this.erroriValidazione;
    }

    public Vector<Eccezione> getEccezioniProcessamento() {
        return this.erroriProcessamento;
    }

    public Vector<Eccezione> getErroriTrovatiSullaListaEccezioni() {
        return this.errorsTrovatiSullaListaEccezioni;
    }

    public ErroreCooperazione getErrore() {
        return this.errore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean valida() {
        ValidazioneSintatticaResult result = null;
        IValidazioneSintattica validazioneSintattica = null;
        try {
            validazioneSintattica = this.protocolFactory.createValidazioneSintattica();
            ProprietaValidazioneErrori pValidazioneErrori = new ProprietaValidazioneErrori();
            pValidazioneErrori.setIgnoraEccezioniNonGravi(this.protocolManager.isIgnoraEccezioniNonGravi());
            result = this.isRichiesta == null || this.isRichiesta.booleanValue() ? validazioneSintattica.validaRichiesta(this.state, this.msg, this.busta, pValidazioneErrori) : validazioneSintattica.validaRisposta(this.state, this.msg, this.busta, pValidazioneErrori);
        }
        catch (ProtocolException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (result != null) {
                if (result.getBusta() != null) {
                    this.busta = result.getBusta();
                }
                if (result.getBustaErrore() != null) {
                    this.bustaErroreHeaderIntestazione = result.getBustaErrore();
                }
                this.errore = result.getErrore();
                this.erroriProcessamento = result.getErroriProcessamento();
                if (this.erroriProcessamento == null) {
                    this.erroriProcessamento = new Vector();
                }
                this.erroriValidazione = result.getErroriValidazione();
                if (this.erroriValidazione == null) {
                    this.erroriValidazione = new Vector();
                }
                this.errorsTrovatiSullaListaEccezioni = result.getErrorsTrovatiSullaListaEccezioni();
                if (this.errorsTrovatiSullaListaEccezioni == null) {
                    this.errorsTrovatiSullaListaEccezioni = new Vector();
                }
                this.headerProtocollo = result.getProtocolElement() != null ? result.getProtocolElement() : validazioneSintattica.getHeaderProtocollo(this.busta);
                return result.isValido();
            }
        }
        return false;
    }

    public boolean verifyProtocolPresence(TipoPdD tipoPdD, ProfiloDiCollaborazione profilo, boolean isRichiesta) throws Exception {
        return this.protocolFactory.createValidazioneSintattica().verifyProtocolPresence(tipoPdD, profilo, isRichiesta, this.msg);
    }

    public void validazioneFault(SOAPBody body) throws ProtocolException {
        ValidazioneSintatticaResult result = this.protocolFactory.createValidazioneSintattica().validazioneFault(body);
        if (result != null) {
            if (result.getBusta() != null) {
                this.busta = result.getBusta();
            }
            if (result.getBustaErrore() != null) {
                this.bustaErroreHeaderIntestazione = result.getBustaErrore();
            }
            this.errore = result.getErrore();
            this.erroriProcessamento = result.getErroriProcessamento();
            if (this.erroriProcessamento == null) {
                this.erroriProcessamento = new Vector();
            }
            this.erroriValidazione = result.getErroriValidazione();
            if (this.erroriValidazione == null) {
                this.erroriValidazione = new Vector();
            }
            this.errorsTrovatiSullaListaEccezioni = result.getErrorsTrovatiSullaListaEccezioni();
            if (this.errorsTrovatiSullaListaEccezioni == null) {
                this.errorsTrovatiSullaListaEccezioni = new Vector();
            }
            if (result.getProtocolElement() != null) {
                this.headerProtocollo = result.getProtocolElement();
            }
        }
    }

    public void validazioneManifestAttachments(OpenSPCoop2Message msg, ProprietaManifestAttachments proprietaManifestAttachments) throws ProtocolException {
        ValidazioneSintatticaResult result = this.protocolFactory.createValidazioneSintattica().validazioneManifestAttachments(msg, proprietaManifestAttachments);
        if (result != null) {
            if (result.getBusta() != null) {
                this.busta = result.getBusta();
            }
            if (result.getBustaErrore() != null) {
                this.bustaErroreHeaderIntestazione = result.getBustaErrore();
            }
            this.errore = result.getErrore();
            this.erroriProcessamento = result.getErroriProcessamento();
            if (this.erroriProcessamento == null) {
                this.erroriProcessamento = new Vector();
            }
            this.erroriValidazione = result.getErroriValidazione();
            if (this.erroriValidazione == null) {
                this.erroriValidazione = new Vector();
            }
            this.errorsTrovatiSullaListaEccezioni = result.getErrorsTrovatiSullaListaEccezioni();
            if (this.errorsTrovatiSullaListaEccezioni == null) {
                this.errorsTrovatiSullaListaEccezioni = new Vector();
            }
            if (result.getProtocolElement() != null) {
                this.headerProtocollo = result.getProtocolElement();
            }
        }
    }

    public SOAPElement getHeaderProtocollo_senzaControlli() throws ProtocolException {
        return this.protocolFactory.createValidazioneSintattica().getHeaderProtocollo_senzaControlli(this.msg);
    }
}

