/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.mapping;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import org.apache.log4j.Logger;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.DynamicNamespaceContextFactory;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.XPathExpressionEngine;
import org.openspcoop2.protocol.engine.URLProtocolContext;
import org.openspcoop2.protocol.engine.constants.IDService;
import org.openspcoop2.protocol.engine.mapping.MappingInfo;
import org.openspcoop2.protocol.engine.mapping.MappingPAInfo;
import org.openspcoop2.protocol.engine.mapping.MappingProperties;
import org.openspcoop2.protocol.engine.mapping.ModalitaIdentificazione;
import org.openspcoop2.protocol.engine.mapping.OperationFinder;
import org.openspcoop2.protocol.manifest.Openspcoop2;
import org.openspcoop2.protocol.manifest.UrlMapping;
import org.openspcoop2.protocol.manifest.constants.UrlMappingSourceType;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.Identity;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.utils.xml.AbstractXPathExpressionEngine;
import org.openspcoop2.utils.xml.DynamicNamespaceContext;
import org.w3c.dom.Node;

public class InformazioniServizioURLMapping {
    private static final String TIPO_MITTENTE = "identificazione-tipo-mittente";
    private static final String NOME_MITTENTE = "identificazione-mittente";
    private static final String TIPO_DESTINATARIO = "identificazione-tipo-destinatario";
    private static final String NOME_DESTINATARIO = "identificazione-destinatario";
    private static final String TIPO_SERVIZIO = "identificazione-tipo-servizio";
    private static final String NOME_SERVIZIO = "identificazione-servizio";
    private static final String NOME_AZIONE = "identificazione-azione";
    private static final String INFORMAZIONI_PROTOCOLLO = "identificazione-informazioni-protocollo";
    private static final String ID_PROTOCOLLO = "identificazione-id-protocollo";
    private static final String GENERAZIONE_LISTA_TRASMISSIONI = "generazione-lista-trasmissioni";
    private static HashMap<String, MappingProperties> mappingPropertiesTable = new HashMap();
    private OpenSPCoop2Message msg;
    private URLProtocolContext urlProtocolContext;
    private RegistroServiziManager registroServiziManager;
    private Logger log;
    private MappingProperties mp;
    private String idMapping;
    private MappingInfo tipoMittente;
    private MappingInfo mittente;
    private MappingInfo tipoDestinatario;
    private MappingInfo destinatario;
    private MappingInfo tipoServizio;
    private MappingInfo servizio;
    private MappingInfo azione;
    private MappingInfo infoProtocollo;
    private MappingInfo idProtocollo;
    private MappingPAInfo paInfo;
    private boolean generateListaTrasmissione = false;

    private static MappingProperties getMappingProperties(IProtocolFactory protocolFactory) throws ProtocolException {
        Openspcoop2 manifest = protocolFactory.getManifest();
        if (!mappingPropertiesTable.containsKey(manifest.getProtocolName())) {
            InformazioniServizioURLMapping.initMappingProperties(protocolFactory);
        }
        return mappingPropertiesTable.get(manifest.getProtocolName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void initMappingProperties(IProtocolFactory protocolFactory) throws ProtocolException {
        block12: {
            try {
                Openspcoop2 manifest = protocolFactory.getManifest();
                if (mappingPropertiesTable.containsKey(manifest.getProtocolName())) break block12;
                UrlMapping urlMapping = manifest.getUrlMapping();
                if (UrlMappingSourceType.XML.equals(urlMapping.getTipo())) {
                    throw new ProtocolException("Not implemented");
                }
                if (UrlMappingSourceType.PROPERTIES.equals(urlMapping.getTipo())) {
                    File f = new File(urlMapping.getFile());
                    InputStream is = null;
                    try {
                        is = f.exists() ? new FileInputStream(f) : protocolFactory.getClass().getResourceAsStream(urlMapping.getFile());
                        MappingProperties m = new MappingProperties(urlMapping.getFile(), is, protocolFactory.getLogger());
                        mappingPropertiesTable.put(manifest.getProtocolName(), m);
                        break block12;
                    }
                    finally {
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (Exception eClose) {}
                    }
                }
                throw new ProtocolException("[" + urlMapping.getTipo().getValue() + "] Not supported");
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public InformazioniServizioURLMapping(OpenSPCoop2Message msg, IProtocolFactory protocolFactory, URLProtocolContext urlProtocolContext, RegistroServiziManager registroServiziManager, Logger log, IDService idService) throws ProtocolException {
        String generazioneListaTrasmissioniTmp;
        this.mp = InformazioniServizioURLMapping.getMappingProperties(protocolFactory);
        this.msg = msg;
        this.urlProtocolContext = urlProtocolContext;
        this.registroServiziManager = registroServiziManager;
        this.log = log;
        this.idMapping = this.resolveMappingName(urlProtocolContext, idService);
        this.tipoMittente = this.getMappingInfo(TIPO_MITTENTE);
        this.mittente = this.getMappingInfo(NOME_MITTENTE);
        this.tipoDestinatario = this.getMappingInfo(TIPO_DESTINATARIO);
        this.destinatario = this.getMappingInfo(NOME_DESTINATARIO);
        this.tipoServizio = this.getMappingInfo(TIPO_SERVIZIO);
        this.servizio = this.getMappingInfo(NOME_SERVIZIO);
        this.azione = this.getMappingInfo(NOME_AZIONE);
        this.infoProtocollo = this.getMappingInfo(INFORMAZIONI_PROTOCOLLO);
        this.idProtocollo = this.getMappingInfo(ID_PROTOCOLLO);
        if (this.existsPABasedIdentificationMode()) {
            this.paInfo = this.getMappingPAInfo(this.msg.getProtocolName(), urlProtocolContext, idService);
        }
        if ((generazioneListaTrasmissioniTmp = this.mp.getValue(this.msg.getProtocolName(), this.idMapping, GENERAZIONE_LISTA_TRASMISSIONI)) != null) {
            this.generateListaTrasmissione = Boolean.parseBoolean(generazioneListaTrasmissioniTmp);
        }
    }

    public MappingPAInfo getPaInfo() {
        return this.paInfo;
    }

    public String toString() {
        StringBuffer bf = new StringBuffer();
        bf.append("MappingId(");
        bf.append(this.idMapping);
        bf.append(") ");
        bf.append("TipoMittente(");
        if (this.tipoMittente != null) {
            bf.append(this.tipoMittente.toString());
        } else {
            bf.append("?non presente?");
        }
        bf.append(") ");
        bf.append("Mittente(");
        if (this.mittente != null) {
            bf.append(this.mittente.toString());
        } else {
            bf.append("?non presente?");
        }
        bf.append(") ");
        bf.append("TipoDestinatario(");
        if (this.tipoDestinatario != null) {
            bf.append(this.tipoDestinatario.toString());
        } else {
            bf.append("?non presente?");
        }
        bf.append(") ");
        bf.append("Destinatario(");
        if (this.destinatario != null) {
            bf.append(this.destinatario.toString());
        } else {
            bf.append("?non presente?");
        }
        bf.append(") ");
        bf.append("TipoServizio(");
        if (this.tipoServizio != null) {
            bf.append(this.tipoServizio.toString());
        } else {
            bf.append("?non presente?");
        }
        bf.append(") ");
        bf.append("Servizio(");
        if (this.servizio != null) {
            bf.append(this.servizio.toString());
        } else {
            bf.append("?non presente?");
        }
        bf.append(") ");
        bf.append("Azione(");
        if (this.azione != null) {
            bf.append(this.azione.toString());
        } else {
            bf.append("?non presente?");
        }
        bf.append(") ");
        bf.append("InformazioniProtocollo(");
        if (this.infoProtocollo != null) {
            bf.append(this.infoProtocollo.toString());
        } else {
            bf.append("?non presente?");
        }
        bf.append(") ");
        bf.append("IDProtocollo(");
        if (this.idProtocollo != null) {
            bf.append(this.idProtocollo.toString());
        } else {
            bf.append("?non presente?");
        }
        bf.append(") ");
        if (this.paInfo != null) {
            bf.append("PAMappingInfo(");
            bf.append(this.paInfo.toString());
            bf.append(") ");
        }
        bf.append("GenerazioneListaTrasmissioni(");
        bf.append(this.generateListaTrasmissione);
        bf.append(") ");
        return bf.toString();
    }

    private String resolveMappingName(URLProtocolContext urlProtocolContext, IDService idService) throws ProtocolException {
        String mappingName = this.mp.getMappingName(this.msg.getProtocolName(), urlProtocolContext.getRequestURI(), idService);
        return mappingName;
    }

    private MappingInfo getMappingInfo(String proprieta) throws ProtocolException {
        MappingInfo mappingInfo = new MappingInfo();
        mappingInfo.setModalitaIdentificazione(this.mp.getModalita(this.msg.getProtocolName(), this.idMapping, proprieta));
        mappingInfo.setName(this.mp.getName(this.msg.getProtocolName(), this.idMapping, proprieta));
        mappingInfo.setValue(this.mp.getValue(this.msg.getProtocolName(), this.idMapping, proprieta));
        mappingInfo.setPattern(this.mp.getPattern(this.msg.getProtocolName(), this.idMapping, proprieta));
        mappingInfo.setAnonymous(this.mp.getAnonymous(this.msg.getProtocolName(), this.idMapping, proprieta));
        mappingInfo.setForceWsdlBased(this.mp.isForceWsdlBased(this.msg.getProtocolName(), this.idMapping, proprieta));
        if (ID_PROTOCOLLO.equals(proprieta) || INFORMAZIONI_PROTOCOLLO.equals(proprieta)) {
            if (!ModalitaIdentificazione.STATIC.equals(mappingInfo.getModalitaIdentificazione()) && !ModalitaIdentificazione.PLUGIN_BASED.equals(mappingInfo.getModalitaIdentificazione())) {
                throw new ProtocolException("La Modalita' '" + mappingInfo.getModalitaIdentificazione().toString() + "', indicata per la proprieta' [" + proprieta + "], non puo' essere utilizzata");
            }
            return mappingInfo;
        }
        if (ModalitaIdentificazione.STATIC.equals(mappingInfo.getModalitaIdentificazione()) && mappingInfo.getValue() == null) {
            throw new ProtocolException("La Modalita' '" + ModalitaIdentificazione.STATIC.toString() + "', indicata per la proprieta' [" + proprieta + "], richiede la definizione di una omonima proprieta' con suffisso '.value'");
        }
        if (ModalitaIdentificazione.URL_BASED.equals(mappingInfo.getModalitaIdentificazione()) && mappingInfo.getPattern() == null) {
            throw new ProtocolException("La Modalita' '" + ModalitaIdentificazione.URL_BASED.toString() + "', indicata per la proprieta' [" + proprieta + "], richiede la definizione di una omonima proprieta' con suffisso '.pattern'");
        }
        if (ModalitaIdentificazione.CONTENT_BASED.equals(mappingInfo.getModalitaIdentificazione()) && mappingInfo.getPattern() == null) {
            throw new ProtocolException("La Modalita' '" + ModalitaIdentificazione.CONTENT_BASED.toString() + "', indicata per la proprieta' [" + proprieta + "], richiede la definizione di una omonima proprieta' con suffisso '.pattern'");
        }
        if (ModalitaIdentificazione.HEADER_BASED.equals(mappingInfo.getModalitaIdentificazione()) && mappingInfo.getName() == null) {
            throw new ProtocolException("La Modalita' '" + ModalitaIdentificazione.CONTENT_BASED.toString() + "', indicata per la proprieta' [" + proprieta + "], richiede la definizione di una omonima proprieta' con suffisso '.name'");
        }
        if (!NOME_AZIONE.equals(proprieta)) {
            if (mappingInfo.getForceWsdlBased() != null) {
                throw new ProtocolException("Il suffisso '.forceWsdlBased', indicato per la proprieta' [" + proprieta + "], puo' essere utilizzata solamente per identificare il nome dell'azione");
            }
        } else {
            if (mappingInfo.getForceWsdlBased() != null && ModalitaIdentificazione.WSDL_BASED.equals(mappingInfo.getModalitaIdentificazione())) {
                throw new ProtocolException("Il suffisso '.forceWsdlBased', indicato per la proprieta' [" + proprieta + "], indica un meccanismo alternativo per identificare il nome dell'azione. E' utilizzabile solamente se la modalit\u00e0 d'identificazione principale \u00e8 differente da " + ModalitaIdentificazione.WSDL_BASED.getValore());
            }
            if (mappingInfo.getForceWsdlBased() != null && ModalitaIdentificazione.PLUGIN_BASED.equals(mappingInfo.getModalitaIdentificazione())) {
                throw new ProtocolException("Il suffisso '.forceWsdlBased', indicato per la proprieta' [" + proprieta + "], non puo' essere utilizzata come meccanismo alternativo per identificare il nome dell'azione se la modalit\u00e0 d'identificazione principale \u00e8 " + ModalitaIdentificazione.PLUGIN_BASED.getValore());
            }
        }
        if (ModalitaIdentificazione.SOAP_ACTION_BASED.equals(mappingInfo.getModalitaIdentificazione()) && !NOME_AZIONE.equals(proprieta)) {
            throw new ProtocolException("La Modalita' '" + ModalitaIdentificazione.SOAP_ACTION_BASED.toString() + "', indicata per la proprieta' [" + proprieta + "], puo' essere utilizzata solamente per identificare il nome dell'azione");
        }
        if (ModalitaIdentificazione.WSDL_BASED.equals(mappingInfo.getModalitaIdentificazione()) && !NOME_AZIONE.equals(proprieta)) {
            throw new ProtocolException("La Modalita' '" + ModalitaIdentificazione.WSDL_BASED.toString() + "', indicata per la proprieta' [" + proprieta + "], puo' essere utilizzata solamente per identificare il nome dell'azione");
        }
        if (ModalitaIdentificazione.PA_BASED.equals(mappingInfo.getModalitaIdentificazione())) {
            if (TIPO_MITTENTE.equals(proprieta) || NOME_MITTENTE.equals(proprieta)) {
                throw new ProtocolException("La Modalita' '" + ModalitaIdentificazione.PA_BASED.toString() + "', indicata per la proprieta' [" + proprieta + "], non puo' essere utilizzata per identificare il tipo od il nome del mittente");
            }
            if (INFORMAZIONI_PROTOCOLLO.equals(proprieta)) {
                throw new ProtocolException("La Modalita' '" + ModalitaIdentificazione.PA_BASED.toString() + "', indicata per la proprieta' [" + proprieta + "], non puo' essere utilizzata per identificare le informazioni di protocollo");
            }
            if (ID_PROTOCOLLO.equals(proprieta)) {
                throw new ProtocolException("La Modalita' '" + ModalitaIdentificazione.PA_BASED.toString() + "', indicata per la proprieta' [" + proprieta + "], non puo' essere utilizzata per identificare l'identificativo unico di protocollo");
            }
        }
        if (ModalitaIdentificazione.IDENTITY_BASED.equals(mappingInfo.getModalitaIdentificazione()) && !NOME_MITTENTE.equals(proprieta)) {
            throw new ProtocolException("La Modalita' '" + ModalitaIdentificazione.IDENTITY_BASED.toString() + "', indicata per la proprieta' [" + proprieta + "], puo' essere utilizzata solamente per identificare il nome del mittente");
        }
        return mappingInfo;
    }

    private MappingPAInfo getMappingPAInfo(String protocol, URLProtocolContext urlProtocolContext, IDService idService) throws ProtocolException {
        String urlWithoutContext = this.mp.getUrlWithoutContext(protocol, urlProtocolContext.getRequestURI(), idService);
        if (urlWithoutContext.startsWith("/")) {
            urlWithoutContext = urlWithoutContext.substring(1, urlWithoutContext.length());
        }
        MappingPAInfo mappingInfo = new MappingPAInfo();
        if (urlWithoutContext.contains("/")) {
            int indexOfLast = urlWithoutContext.lastIndexOf("/");
            mappingInfo.setNomePA(urlWithoutContext.substring(0, indexOfLast));
            if (indexOfLast + 1 < urlWithoutContext.length()) {
                mappingInfo.setAzione(urlWithoutContext.substring(indexOfLast + 1, urlWithoutContext.length()));
            }
        } else {
            mappingInfo.setNomePA(urlWithoutContext);
        }
        if (urlProtocolContext.getParametersFormBased() != null) {
            if (urlProtocolContext.getParametersFormBased().containsKey("tipo_soggetto")) {
                mappingInfo.setTipoSoggetto(urlProtocolContext.getParametersFormBased().getProperty("tipo_soggetto"));
            }
            if (urlProtocolContext.getParametersFormBased().containsKey("soggetto")) {
                mappingInfo.setNomeSoggetto(urlProtocolContext.getParametersFormBased().getProperty("soggetto"));
            }
        }
        if (mappingInfo.getNomePA() == null) {
            throw new ProtocolException("Nome della Porta Applicativa non presente nella url");
        }
        return mappingInfo;
    }

    public boolean existsUrlBasedIdentificationMode() {
        if (this.tipoMittente != null && ModalitaIdentificazione.URL_BASED.equals(this.tipoMittente.getModalitaIdentificazione())) {
            return true;
        }
        if (this.mittente != null && ModalitaIdentificazione.URL_BASED.equals(this.mittente.getModalitaIdentificazione())) {
            return true;
        }
        if (this.tipoDestinatario != null && ModalitaIdentificazione.URL_BASED.equals(this.tipoDestinatario.getModalitaIdentificazione())) {
            return true;
        }
        if (this.destinatario != null && ModalitaIdentificazione.URL_BASED.equals(this.destinatario.getModalitaIdentificazione())) {
            return true;
        }
        if (this.tipoServizio != null && ModalitaIdentificazione.URL_BASED.equals(this.tipoServizio.getModalitaIdentificazione())) {
            return true;
        }
        if (this.servizio != null && ModalitaIdentificazione.URL_BASED.equals(this.servizio.getModalitaIdentificazione())) {
            return true;
        }
        return this.azione != null && ModalitaIdentificazione.URL_BASED.equals(this.azione.getModalitaIdentificazione());
    }

    public boolean existsContentBasedIdentificationMode() {
        if (this.tipoMittente != null && ModalitaIdentificazione.CONTENT_BASED.equals(this.tipoMittente.getModalitaIdentificazione())) {
            return true;
        }
        if (this.mittente != null && ModalitaIdentificazione.CONTENT_BASED.equals(this.mittente.getModalitaIdentificazione())) {
            return true;
        }
        if (this.tipoDestinatario != null && ModalitaIdentificazione.CONTENT_BASED.equals(this.tipoDestinatario.getModalitaIdentificazione())) {
            return true;
        }
        if (this.destinatario != null && ModalitaIdentificazione.CONTENT_BASED.equals(this.destinatario.getModalitaIdentificazione())) {
            return true;
        }
        if (this.tipoServizio != null && ModalitaIdentificazione.CONTENT_BASED.equals(this.tipoServizio.getModalitaIdentificazione())) {
            return true;
        }
        if (this.servizio != null && ModalitaIdentificazione.CONTENT_BASED.equals(this.servizio.getModalitaIdentificazione())) {
            return true;
        }
        return this.azione != null && ModalitaIdentificazione.CONTENT_BASED.equals(this.azione.getModalitaIdentificazione());
    }

    public boolean existsPABasedIdentificationMode() {
        if (this.tipoDestinatario != null && ModalitaIdentificazione.PA_BASED.equals(this.tipoDestinatario.getModalitaIdentificazione())) {
            return true;
        }
        if (this.destinatario != null && ModalitaIdentificazione.PA_BASED.equals(this.destinatario.getModalitaIdentificazione())) {
            return true;
        }
        if (this.tipoServizio != null && ModalitaIdentificazione.PA_BASED.equals(this.tipoServizio.getModalitaIdentificazione())) {
            return true;
        }
        if (this.servizio != null && ModalitaIdentificazione.PA_BASED.equals(this.servizio.getModalitaIdentificazione())) {
            return true;
        }
        return this.azione != null && ModalitaIdentificazione.PA_BASED.equals(this.azione.getModalitaIdentificazione());
    }

    public boolean existsIdentityBasedIdentificationMode() {
        return this.mittente != null && ModalitaIdentificazione.IDENTITY_BASED.equals(this.mittente.getModalitaIdentificazione());
    }

    public boolean isStaticBasedIdentificationMode_InfoProtocol() {
        return this.infoProtocollo != null && ModalitaIdentificazione.STATIC.equals(this.infoProtocollo.getModalitaIdentificazione());
    }

    public boolean isStaticBasedIdentificationMode_IdProtocol() {
        return this.idProtocollo != null && ModalitaIdentificazione.STATIC.equals(this.idProtocollo.getModalitaIdentificazione());
    }

    public boolean isGenerateListaTrasmissione() {
        return this.generateListaTrasmissione;
    }

    public void refreshDati(IDSoggetto idMittente, IDServizio idServizio, String soapAction, Identity identity, PortaApplicativa pa) throws ProtocolException {
        String servizio;
        String tipoServizio;
        String destinatario;
        String tipoDestinatario;
        String mittente;
        SOAPEnvelope envelope;
        XPathExpressionEngine xPathEngine;
        DynamicNamespaceContext dnc;
        String urlInvocazione;
        block25: {
            String tipoMittente;
            block24: {
                urlInvocazione = null;
                dnc = null;
                xPathEngine = null;
                envelope = null;
                if (this.existsUrlBasedIdentificationMode()) {
                    urlInvocazione = this.urlProtocolContext.getUrlInvocazione_formBased();
                }
                if (this.existsContentBasedIdentificationMode()) {
                    try {
                        envelope = this.msg.getSOAPPart().getEnvelope();
                        dnc = DynamicNamespaceContextFactory.getInstance().getNamespaceContext((Node)envelope);
                        xPathEngine = new XPathExpressionEngine();
                    }
                    catch (Exception e) {
                        throw new ProtocolException(e.getMessage(), (Throwable)e);
                    }
                }
                tipoMittente = null;
                try {
                    tipoMittente = this.readValue(this.tipoMittente, TIPO_MITTENTE, soapAction, identity, urlInvocazione, envelope, dnc, (AbstractXPathExpressionEngine)xPathEngine, pa, null);
                }
                catch (ProtocolException e) {
                    if (tipoMittente != null || ModalitaIdentificazione.PLUGIN_BASED.equals(this.tipoMittente.getModalitaIdentificazione())) break block24;
                    if (this.tipoMittente.getAnonymous() == null) {
                        throw e;
                    }
                    tipoMittente = this.tipoMittente.getAnonymous();
                }
            }
            if (tipoMittente != null) {
                idMittente.setTipo(tipoMittente);
            }
            mittente = null;
            try {
                mittente = this.readValue(this.mittente, NOME_MITTENTE, soapAction, identity, urlInvocazione, envelope, dnc, (AbstractXPathExpressionEngine)xPathEngine, pa, null);
            }
            catch (ProtocolException e) {
                if (mittente != null || ModalitaIdentificazione.PLUGIN_BASED.equals(this.mittente.getModalitaIdentificazione())) break block25;
                if (this.mittente.getAnonymous() == null) {
                    throw e;
                }
                mittente = this.mittente.getAnonymous();
            }
        }
        if (mittente != null) {
            idMittente.setNome(mittente);
        }
        if ((tipoDestinatario = this.readValue(this.tipoDestinatario, TIPO_DESTINATARIO, soapAction, identity, urlInvocazione, envelope, dnc, (AbstractXPathExpressionEngine)xPathEngine, pa, null)) != null) {
            idServizio.getSoggettoErogatore().setTipo(tipoDestinatario);
        }
        if ((destinatario = this.readValue(this.destinatario, NOME_DESTINATARIO, soapAction, identity, urlInvocazione, envelope, dnc, (AbstractXPathExpressionEngine)xPathEngine, pa, null)) != null) {
            idServizio.getSoggettoErogatore().setNome(destinatario);
        }
        if ((tipoServizio = this.readValue(this.tipoServizio, TIPO_SERVIZIO, soapAction, identity, urlInvocazione, envelope, dnc, (AbstractXPathExpressionEngine)xPathEngine, pa, null)) != null) {
            idServizio.setTipoServizio(tipoServizio);
        }
        if ((servizio = this.readValue(this.servizio, NOME_SERVIZIO, soapAction, identity, urlInvocazione, envelope, dnc, (AbstractXPathExpressionEngine)xPathEngine, pa, null)) != null) {
            idServizio.setServizio(servizio);
        }
        String azione = null;
        ProtocolException eAzione = null;
        try {
            azione = this.readValue(this.azione, NOME_AZIONE, soapAction, identity, urlInvocazione, envelope, dnc, (AbstractXPathExpressionEngine)xPathEngine, pa, idServizio);
        }
        catch (ProtocolException e) {
            eAzione = e;
        }
        if (azione == null && this.azione.getForceWsdlBased() != null && this.azione.getForceWsdlBased().booleanValue()) {
            try {
                InformazioniServizioURLMapping.checkIDServizioPerRiconoscimentoAzione(idServizio, ModalitaIdentificazione.WSDL_BASED);
                azione = OperationFinder.searchOperationByRequestMessage(this.msg, this.registroServiziManager, idServizio, this.log);
            }
            catch (Exception e) {
                this.log.debug((Object)("Riconoscimento forzato dell'azione non riuscito: " + e.getMessage()), (Throwable)e);
            }
        }
        if (azione != null) {
            idServizio.setAzione(azione);
        } else if (eAzione != null) {
            throw eAzione;
        }
    }

    private String readValue(MappingInfo mappingInfo, String oggetto, String soapAction, Identity identity, String urlInvocazione, SOAPEnvelope envelope, DynamicNamespaceContext dnc, AbstractXPathExpressionEngine xPathEngine, PortaApplicativa pa, IDServizio idServizio) throws ProtocolException {
        if (ModalitaIdentificazione.STATIC.equals(mappingInfo.getModalitaIdentificazione())) {
            if (mappingInfo.getValue() == null) {
                throw new ProtocolException("URLMapping[" + oggetto + "] identificazione " + ModalitaIdentificazione.STATIC.toString() + " non riuscita: valore nell'omonima proprieta' con suffisso '.value' non fornito");
            }
            return mappingInfo.getValue();
        }
        if (ModalitaIdentificazione.PLUGIN_BASED.equals(mappingInfo.getModalitaIdentificazione())) {
            return null;
        }
        if (ModalitaIdentificazione.URL_BASED.equals(mappingInfo.getModalitaIdentificazione())) {
            try {
                return RegularExpressionEngine.getStringMatchPattern((String)urlInvocazione, (String)mappingInfo.getPattern());
            }
            catch (Exception e) {
                throw new ProtocolException("URLMapping[" + oggetto + "] identificazione " + ModalitaIdentificazione.URL_BASED.toString() + " non riuscita: " + e.getMessage(), (Throwable)e);
            }
        }
        if (ModalitaIdentificazione.CONTENT_BASED.equals(mappingInfo.getModalitaIdentificazione())) {
            try {
                return xPathEngine.getStringMatchPattern((SOAPElement)envelope, dnc, mappingInfo.getPattern());
            }
            catch (Exception e) {
                throw new ProtocolException("URLMapping[" + oggetto + "] identificazione " + ModalitaIdentificazione.CONTENT_BASED.toString() + " non riuscita: " + e.getMessage(), (Throwable)e);
            }
        }
        if (ModalitaIdentificazione.SOAP_ACTION_BASED.equals(mappingInfo.getModalitaIdentificazione())) {
            if (soapAction == null) {
                throw new ProtocolException("URLMapping[" + oggetto + "] identificazione " + ModalitaIdentificazione.SOAP_ACTION_BASED.toString() + " non riuscita: la soap action non risulta valorizzata nella transazione in corso");
            }
            return soapAction;
        }
        if (ModalitaIdentificazione.WSDL_BASED.equals(mappingInfo.getModalitaIdentificazione())) {
            try {
                InformazioniServizioURLMapping.checkIDServizioPerRiconoscimentoAzione(idServizio, mappingInfo.getModalitaIdentificazione());
                return OperationFinder.searchOperationByRequestMessage(this.msg, this.registroServiziManager, idServizio, this.log);
            }
            catch (Exception e) {
                throw new ProtocolException("URLMapping[" + oggetto + "] identificazione " + ModalitaIdentificazione.WSDL_BASED.toString() + " non riuscita: " + e.getMessage(), (Throwable)e);
            }
        }
        if (ModalitaIdentificazione.HEADER_BASED.equals(mappingInfo.getModalitaIdentificazione())) {
            if (mappingInfo.getName() == null) {
                throw new ProtocolException("URLMapping[" + oggetto + "] identificazione " + ModalitaIdentificazione.HEADER_BASED.toString() + " non riuscita: nome header nell'omonima proprieta' con suffisso '.name' non fornito");
            }
            if (!this.urlProtocolContext.getParametersTrasporto().containsKey(mappingInfo.getName())) {
                throw new ProtocolException("URLMapping[" + oggetto + "] identificazione " + ModalitaIdentificazione.HEADER_BASED.toString() + " non riuscita: header di trasporto con nome [" + mappingInfo.getName() + "] non trovato");
            }
            return this.urlProtocolContext.getParametersTrasporto().getProperty(mappingInfo.getName());
        }
        if (ModalitaIdentificazione.PA_BASED.equals(mappingInfo.getModalitaIdentificazione())) {
            if (pa == null) {
                throw new ProtocolException("URLMapping[" + oggetto + "] identificazione " + ModalitaIdentificazione.PA_BASED.toString() + " non riuscita: porta applicativa non fornita");
            }
            if (TIPO_DESTINATARIO.equals(oggetto)) {
                if (pa.getTipoSoggettoProprietario() == null) {
                    throw new ProtocolException("URLMapping[" + oggetto + "] identificazione " + ModalitaIdentificazione.PA_BASED.toString() + " non riuscita: la porta applicativa non contiene l'informazione");
                }
                return pa.getTipoSoggettoProprietario();
            }
            if (NOME_DESTINATARIO.equals(oggetto)) {
                if (pa.getNomeSoggettoProprietario() == null) {
                    throw new ProtocolException("URLMapping[" + oggetto + "] identificazione " + ModalitaIdentificazione.PA_BASED.toString() + " non riuscita: la porta applicativa non contiene l'informazione");
                }
                return pa.getNomeSoggettoProprietario();
            }
            if (TIPO_SERVIZIO.equals(oggetto)) {
                if (pa.getServizio() == null || pa.getServizio().getTipo() == null) {
                    throw new ProtocolException("URLMapping[" + oggetto + "] identificazione " + ModalitaIdentificazione.PA_BASED.toString() + " non riuscita: la porta applicativa non contiene l'informazione");
                }
                return pa.getServizio().getTipo();
            }
            if (NOME_SERVIZIO.equals(oggetto)) {
                if (pa.getServizio() == null || pa.getServizio().getNome() == null) {
                    throw new ProtocolException("URLMapping[" + oggetto + "] identificazione " + ModalitaIdentificazione.PA_BASED.toString() + " non riuscita: la porta applicativa non contiene l'informazione");
                }
                return pa.getServizio().getNome();
            }
            if (NOME_AZIONE.equals(oggetto)) {
                if (pa.getAzione() != null && pa.getAzione().getNome() != null) {
                    return pa.getAzione().getNome();
                }
                if (this.paInfo != null && this.paInfo.getAzione() != null) {
                    return this.paInfo.getAzione();
                }
            }
        } else if (ModalitaIdentificazione.IDENTITY_BASED.equals(mappingInfo.getModalitaIdentificazione())) {
            if (identity == null) {
                throw new ProtocolException("URLMapping[" + oggetto + "] identificazione " + ModalitaIdentificazione.IDENTITY_BASED.toString() + " non riuscita: Identity non fornita");
            }
            String id = null;
            if (identity.getPrincipal() != null) {
                id = identity.getPrincipal();
            } else if (identity.getSubject() != null) {
                id = identity.getSubject();
            } else if (identity.getUsername() != null) {
                id = identity.getUsername();
            }
            if (id != null) {
                if (mappingInfo.getPattern() != null) {
                    try {
                        String tmp = RegularExpressionEngine.getStringMatchPattern((String)id, (String)mappingInfo.getPattern());
                        if (tmp != null && !"".equals(tmp.trim())) {
                            return tmp.trim();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                return id;
            }
            throw new ProtocolException("URLMapping[" + oggetto + "] identificazione " + ModalitaIdentificazione.IDENTITY_BASED.toString() + " non riuscita: Identity fornita non contiene una identita");
        }
        return null;
    }

    public static void checkIDServizioPerRiconoscimentoAzione(IDServizio idServizio, ModalitaIdentificazione modalitaIdentificazione) throws Exception {
        if (idServizio == null) {
            throw new Exception("Dati del servizio non trovati (necessari per procedere con la modalit\u00e0 di identificazione " + modalitaIdentificazione.name() + " dell'azione)");
        }
        if (idServizio.getSoggettoErogatore() == null) {
            throw new Exception("Dati del soggetto erogatore del servizio non trovati (necessari per procedere con la modalit\u00e0 di identificazione " + modalitaIdentificazione.name() + " dell'azione)");
        }
        if (idServizio.getSoggettoErogatore().getTipo() == null) {
            throw new Exception("Tipo soggetto erogatore del servizio non trovato (necessari per procedere con la modalit\u00e0 di identificazione " + modalitaIdentificazione.name() + " dell'azione)");
        }
        if (idServizio.getSoggettoErogatore().getNome() == null) {
            throw new Exception("Nome soggetto erogatore del servizio non trovato (necessari per procedere con la modalit\u00e0 di identificazione " + modalitaIdentificazione.name() + " dell'azione)");
        }
        if (idServizio.getTipoServizio() == null) {
            throw new Exception("Tipo servizio non trovato (necessari per procedere con la modalit\u00e0 di identificazione " + modalitaIdentificazione.name() + " dell'azione)");
        }
        if (idServizio.getServizio() == null) {
            throw new Exception("Nome servizio non trovato (necessari per procedere con la modalit\u00e0 di identificazione " + modalitaIdentificazione.name() + " dell'azione)");
        }
    }
}

