/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.driver.repository;

import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.protocol.engine.driver.repository.GestoreRepositoryBitOrAndFunction;
import org.openspcoop2.protocol.engine.driver.repository.GestoreRepositoryBytewise;
import org.openspcoop2.protocol.engine.driver.repository.GestoreRepositoryOracle;
import org.openspcoop2.protocol.engine.driver.repository.IGestoreRepository;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.TipiDatabase;

public class GestoreRepositoryFactory {
    public static IGestoreRepository createRepositoryBuste(TipiDatabase tipoDatabase) throws ProtocolException {
        return GestoreRepositoryFactory.createRepositoryBuste(tipoDatabase.toString());
    }

    public static IGestoreRepository createRepositoryBuste(String tipoDatabase) throws ProtocolException {
        IGestoreRepository repositoryBuste = null;
        if (TipiDatabase.POSTGRESQL.equals(tipoDatabase)) {
            repositoryBuste = new GestoreRepositoryBytewise();
        } else if (TipiDatabase.MYSQL.equals(tipoDatabase)) {
            repositoryBuste = new GestoreRepositoryBytewise();
        } else if (TipiDatabase.ORACLE.equals(tipoDatabase)) {
            repositoryBuste = new GestoreRepositoryOracle();
        } else if (TipiDatabase.HSQL.equals(tipoDatabase)) {
            repositoryBuste = new GestoreRepositoryBitOrAndFunction();
        } else if (TipiDatabase.SQLSERVER.equals(tipoDatabase)) {
            repositoryBuste = new GestoreRepositoryBytewise();
        } else if (TipiDatabase.DB2.equals(tipoDatabase)) {
            repositoryBuste = new GestoreRepositoryBitOrAndFunction();
        } else {
            throw new ProtocolException("Tipo database non gestito [" + tipoDatabase + "]");
        }
        return repositoryBuste;
    }

    public static String getTipoRepositoryBuste(TipiDatabase tipoDatabase) throws ProtocolException {
        return GestoreRepositoryFactory.getTipoRepositoryBuste(tipoDatabase.toString());
    }

    public static String getTipoRepositoryBuste(String tipoDatabase) throws ProtocolException {
        String repositoryBuste = null;
        if (TipiDatabase.POSTGRESQL.equals(tipoDatabase)) {
            repositoryBuste = "bytewise";
        } else if (TipiDatabase.MYSQL.equals(tipoDatabase)) {
            repositoryBuste = "bytewise";
        } else if (TipiDatabase.ORACLE.equals(tipoDatabase)) {
            repositoryBuste = CostantiConfigurazione.REPOSITORY_BUSTE_BYTEWISE_ORACLE;
        } else if (TipiDatabase.HSQL.equals(tipoDatabase)) {
            repositoryBuste = "bitOrAndFunction";
        } else if (TipiDatabase.SQLSERVER.equals(tipoDatabase)) {
            repositoryBuste = "bytewise";
        } else if (TipiDatabase.DB2.equals(tipoDatabase)) {
            repositoryBuste = "bitOrAndFunction";
        } else {
            throw new ProtocolException("Tipo database non gestito [" + tipoDatabase + "]");
        }
        return repositoryBuste;
    }
}

