/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.driver;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Random;
import org.apache.log4j.Logger;
import org.openspcoop2.protocol.engine.Configurazione;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.ErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.protocol.sdk.state.StatefulMessage;
import org.openspcoop2.utils.date.DateManager;

public class ConsegnaInOrdine {
    private Logger log = null;
    private IState state;
    private IProtocolFactory protocolFactory;
    private static final String NOT_USED = "";
    private long sequenzaAttesa = -1L;

    public ConsegnaInOrdine(IState state, IProtocolFactory protocolFactory) {
        this(state, Configurazione.getLibraryLog(), protocolFactory);
    }

    public ConsegnaInOrdine(IState state, Logger alog, IProtocolFactory protocolFactory) {
        this.state = state;
        this.log = alog != null ? alog : Logger.getLogger((String)ConsegnaInOrdine.class.getName());
        this.protocolFactory = protocolFactory;
    }

    public void updateState(IState state) {
        this.state = state;
    }

    public void setNextSequenza_daInviare(Busta busta) throws ProtocolException {
        if (this.state instanceof StateMessage) {
            StateMessage stateful = (StateMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            Statement pstmt = null;
            ResultSet rs = null;
            Statement pstmtInsert = null;
            String idCollaborazione = null;
            long sequenza = -1L;
            try {
                StringBuffer query = new StringBuffer();
                query.append("SELECT ID_COLLABORAZIONE,PROSSIMA_SEQUENZA FROM ");
                query.append("SEQUENZA_DA_INVIARE");
                query.append(" WHERE MITTENTE=? AND TIPO_MITTENTE=? AND DESTINATARIO=? AND TIPO_DESTINATARIO=? AND SERVIZIO=? AND TIPO_SERVIZIO=? AND AZIONE=?");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, busta.getMittente());
                pstmt.setString(2, busta.getTipoMittente());
                pstmt.setString(3, busta.getDestinatario());
                pstmt.setString(4, busta.getTipoDestinatario());
                pstmt.setString(5, busta.getServizio());
                pstmt.setString(6, busta.getTipoServizio());
                if (busta.getAzione() != null) {
                    pstmt.setString(7, busta.getAzione());
                } else {
                    pstmt.setString(7, NOT_USED);
                }
                rs = pstmt.executeQuery();
                if (rs == null) {
                    pstmt.close();
                    throw new ProtocolException("RS NULL?");
                }
                if (rs.next()) {
                    idCollaborazione = rs.getString("ID_COLLABORAZIONE");
                    sequenza = rs.getLong("PROSSIMA_SEQUENZA");
                    long next_sequenza = sequenza + 1L;
                    if (next_sequenza > 9999999L) {
                        next_sequenza = 1L;
                    }
                    rs.close();
                    pstmt.close();
                    StringBuffer queryInsert = new StringBuffer();
                    queryInsert.append("UPDATE ");
                    queryInsert.append("SEQUENZA_DA_INVIARE");
                    queryInsert.append(" SET PROSSIMA_SEQUENZA = ? WHERE MITTENTE=? AND TIPO_MITTENTE=? AND DESTINATARIO=? AND TIPO_DESTINATARIO=? AND SERVIZIO=? AND TIPO_SERVIZIO=? AND AZIONE=?");
                    pstmtInsert = connectionDB.prepareStatement(queryInsert.toString());
                    pstmtInsert.setLong(1, next_sequenza);
                    pstmtInsert.setString(2, busta.getMittente());
                    pstmtInsert.setString(3, busta.getTipoMittente());
                    pstmtInsert.setString(4, busta.getDestinatario());
                    pstmtInsert.setString(5, busta.getTipoDestinatario());
                    pstmtInsert.setString(6, busta.getServizio());
                    pstmtInsert.setString(7, busta.getTipoServizio());
                    if (busta.getAzione() != null) {
                        pstmtInsert.setString(8, busta.getAzione());
                    } else {
                        pstmtInsert.setString(8, NOT_USED);
                    }
                    stateful.getPreparedStatement().put("UPDATE setNextSequenza_daInviare" + busta.getCollaborazione(), (PreparedStatement)pstmtInsert);
                } else {
                    idCollaborazione = busta.getID();
                    sequenza = 1L;
                    rs.close();
                    pstmt.close();
                    StringBuffer queryInsert = new StringBuffer();
                    queryInsert.append("INSERT INTO  ");
                    queryInsert.append("SEQUENZA_DA_INVIARE");
                    queryInsert.append(" VALUES ( ? , ? , ? , ? , ? , ? , ? , ? , ? )");
                    pstmtInsert = connectionDB.prepareStatement(queryInsert.toString());
                    pstmtInsert.setString(1, busta.getMittente());
                    pstmtInsert.setString(2, busta.getTipoMittente());
                    pstmtInsert.setString(3, busta.getDestinatario());
                    pstmtInsert.setString(4, busta.getTipoDestinatario());
                    pstmtInsert.setString(5, busta.getServizio());
                    pstmtInsert.setString(6, busta.getTipoServizio());
                    if (busta.getAzione() != null) {
                        pstmtInsert.setString(7, busta.getAzione());
                    } else {
                        pstmtInsert.setString(7, NOT_USED);
                    }
                    pstmtInsert.setLong(8, 2L);
                    pstmtInsert.setString(9, busta.getID());
                    stateful.getPreparedStatement().put("INSERT setNextSequenza_daInviare" + busta.getCollaborazione(), (PreparedStatement)pstmtInsert);
                }
                busta.setSequenza(sequenza);
                busta.setCollaborazione(idCollaborazione);
            }
            catch (Exception e) {
                String errorMsg = "ConsegnaInOrdine, Errore durante la setNextSequenza_daInviare: " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtInsert != null) {
                        pstmtInsert.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
        throw new ProtocolException("Metodo invocato con IState non valido");
    }

    public Eccezione validazioneDatiConsegnaInOrdine(Busta busta, IProtocolFactory protocolFactory) throws ProtocolException {
        if (this.state instanceof StateMessage) {
            block23: {
                StateMessage stateful = (StateMessage)this.state;
                Connection connectionDB = stateful.getConnectionDB();
                boolean connessioneValida = false;
                try {
                    connessioneValida = stateful instanceof StatefulMessage ? true : connectionDB != null && !connectionDB.isClosed();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (connessioneValida && busta.getSequenza() != -1L && busta.getCollaborazione() != null) {
                    Statement pstmt = null;
                    ResultSet rs = null;
                    try {
                        if (busta.getID().equals(busta.getCollaborazione())) {
                            if (busta.getSequenza() != 1L) {
                                this.log.debug((Object)"Riscontrato numero di sequenza diverso da 1, in una busta capostipite di una sequenza");
                                return Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.CONSEGNA_IN_ORDINE_FUORI_SEQUENZA.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                            }
                            break block23;
                        }
                        StringBuffer query = new StringBuffer();
                        query.append("SELECT * FROM ");
                        query.append("SEQUENZA_DA_RICEVERE");
                        query.append(" WHERE ID_COLLABORAZIONE=?");
                        pstmt = connectionDB.prepareStatement(query.toString());
                        pstmt.setString(1, busta.getCollaborazione());
                        rs = pstmt.executeQuery();
                        if (rs == null) {
                            pstmt.close();
                            throw new ProtocolException("RS NULL?");
                        }
                        if (rs.next()) {
                            String tipoMittente = rs.getString("TIPO_MITTENTE");
                            String mittente = rs.getString("MITTENTE");
                            String tipoDestinatario = rs.getString("TIPO_DESTINATARIO");
                            String destinatario = rs.getString("DESTINATARIO");
                            String tipoServizio = rs.getString("TIPO_SERVIZIO");
                            String servizio = rs.getString("SERVIZIO");
                            String azione = rs.getString("AZIONE");
                            rs.close();
                            pstmt.close();
                            if (!tipoMittente.equals(busta.getTipoMittente())) {
                                this.log.debug((Object)"Il tipo di mittente non rispetta quello atteso nella gestione della collaborazione con consegna in ordine.");
                                return Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.CONSEGNA_IN_ORDINE_TIPO_MITTENTE_NON_VALIDO.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                            }
                            if (!mittente.equals(busta.getMittente())) {
                                this.log.debug((Object)"Il mittente non rispetta quello atteso nella gestione della collaborazione con consegna in ordine.");
                                return Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.CONSEGNA_IN_ORDINE_MITTENTE_NON_VALIDO.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                            }
                            if (!tipoDestinatario.equals(busta.getTipoDestinatario())) {
                                this.log.debug((Object)"Il tipo di destinatario non rispetta quello atteso nella gestione della collaborazione con consegna in ordine.");
                                return Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.CONSEGNA_IN_ORDINE_TIPO_DESTINATARIO_NON_VALIDO.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                            }
                            if (!destinatario.equals(busta.getDestinatario())) {
                                this.log.debug((Object)"Il destinatario non rispetta quello atteso nella gestione della collaborazione con consegna in ordine.");
                                return Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.CONSEGNA_IN_ORDINE_DESTINATARIO_NON_VALIDO.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                            }
                            if (!tipoServizio.equals(busta.getTipoServizio())) {
                                this.log.debug((Object)"Il tipo di servizio non rispetta quello atteso nella gestione della collaborazione con consegna in ordine.");
                                return Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.CONSEGNA_IN_ORDINE_TIPO_SERVIZIO_NON_VALIDO.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                            }
                            if (!servizio.equals(busta.getServizio())) {
                                this.log.debug((Object)"Il servizio non rispetta quello atteso nella gestione della collaborazione con consegna in ordine.");
                                return Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.CONSEGNA_IN_ORDINE_SERVIZIO_NON_VALIDO.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                            }
                            if (azione == null && busta.getAzione() != null || !azione.equals(busta.getAzione())) {
                                this.log.debug((Object)"L'azione non rispetta quello attesa nella gestione della collaborazione con consegna in ordine.");
                                return Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.CONSEGNA_IN_ORDINE_AZIONE_NON_VALIDA.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                            }
                            break block23;
                        }
                        this.log.debug((Object)"Busta non capostipite che richiede funzionalit\u00e0 di consegna in ordine presenta una collaborazione non registrata per le funzioni di consegna in ordine");
                        return Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.CONSEGNA_IN_ORDINE_COLLABORAZIONE_IN_BUSTA_NON_CAPOSTIPITE_SCONOSCIUTA.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                    }
                    catch (Exception e) {
                        this.log.error((Object)("ERROR validazioneDatiConsegnaInOrdine [" + e.getMessage() + "]"), (Throwable)e);
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                        catch (Exception er) {
                            // empty catch block
                        }
                        try {
                            if (pstmt != null) {
                                pstmt.close();
                            }
                        }
                        catch (Exception er) {
                            // empty catch block
                        }
                        throw new ProtocolException("ERROR validazioneDatiConsegnaInOrdine [" + e.getMessage() + "]", (Throwable)e);
                    }
                }
            }
            return null;
        }
        throw new ProtocolException("Metodo invocato con IState non valido");
    }

    public boolean isConsegnaInOrdine(Busta busta) throws ProtocolException {
        return this.isConsegnaInOrdine(busta, 60L, 100);
    }

    public long getSequenzaAttesa() {
        return this.sequenzaAttesa;
    }

    public boolean isConsegnaInOrdine(Busta busta, long attesaAttiva, int checkInterval) throws ProtocolException {
        if (this.state instanceof StateMessage) {
            StateMessage stateMsg = (StateMessage)this.state;
            Connection connectionDB = stateMsg.getConnectionDB();
            RepositoryBuste repository = new RepositoryBuste((IState)stateMsg, this.log, true, this.protocolFactory);
            long sequenzaGestita = repository.getSequenzaFromInBox(busta.getID());
            if (sequenzaGestita == -2L) {
                return true;
            }
            int oldTransactionIsolation = -1;
            try {
                oldTransactionIsolation = connectionDB.getTransactionIsolation();
                connectionDB.setAutoCommit(false);
                connectionDB.setTransactionIsolation(8);
            }
            catch (Exception er) {
                String errorMsg = "ConsegnaInOrdine, errore durante isConsegnaInOrdine(setIsolation): " + er.getMessage();
                this.log.error((Object)errorMsg, (Throwable)er);
                throw new ProtocolException(errorMsg, (Throwable)er);
            }
            boolean nextSequenceOK = false;
            boolean bustaInOrdine = false;
            long scadenzaWhile = DateManager.getTimeMillis() + attesaAttiva;
            while (!nextSequenceOK && DateManager.getTimeMillis() < scadenzaWhile) {
                Statement pstmt = null;
                ResultSet rs = null;
                try {
                    if (busta.getID().equals(busta.getCollaborazione())) {
                        bustaInOrdine = true;
                    } else {
                        StringBuffer query = new StringBuffer();
                        query.append("SELECT SEQUENZA_ATTESA FROM ");
                        query.append("SEQUENZA_DA_RICEVERE");
                        query.append(" WHERE ID_COLLABORAZIONE=? FOR UPDATE");
                        pstmt = connectionDB.prepareStatement(query.toString());
                        pstmt.setString(1, busta.getCollaborazione());
                        rs = pstmt.executeQuery();
                        if (rs == null) {
                            pstmt.close();
                            throw new ProtocolException("RS NULL?");
                        }
                        if (!rs.next()) {
                            throw new Exception("Informazioni su consegna in ordine non trovate, durante il check di una busta non capostipite");
                        }
                        this.sequenzaAttesa = rs.getLong("SEQUENZA_ATTESA");
                        rs.close();
                        pstmt.close();
                        bustaInOrdine = this.sequenzaAttesa == busta.getSequenza();
                    }
                    connectionDB.commit();
                    nextSequenceOK = true;
                }
                catch (Exception e) {
                    this.log.error((Object)("ERROR isConsegnaInOrdine [" + e.getMessage() + "]"));
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                    try {
                        connectionDB.rollback();
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                }
                if (nextSequenceOK) continue;
                try {
                    Thread.sleep(new Random().nextInt(checkInterval));
                }
                catch (Exception eRandom) {}
            }
            try {
                connectionDB.setTransactionIsolation(oldTransactionIsolation);
                connectionDB.setAutoCommit(true);
            }
            catch (Exception er) {
                String errorMsg = "ConsegnaInOrdine, Errore durante la isConsegnaInOrdine(ripristinoIsolation): " + er.getMessage();
                this.log.error((Object)errorMsg, (Throwable)er);
                throw new ProtocolException(errorMsg, (Throwable)er);
            }
            if (!nextSequenceOK) {
                throw new ProtocolException("Controllo sequenza per gestione funzionalita' di consegna in ordine non riuscita");
            }
            return bustaInOrdine;
        }
        throw new ProtocolException("Metodo invocato con IState non valido");
    }

    public void setNextSequenza_daRicevere(Busta busta) throws ProtocolException {
        if (this.state instanceof StateMessage) {
            StateMessage stateful = (StateMessage)this.state;
            Connection connectionDB = stateful.getConnectionDB();
            RepositoryBuste repository = new RepositoryBuste((IState)stateful, this.log, true, this.protocolFactory);
            long sequenzaGestita = repository.getSequenzaFromInBox(busta.getID());
            if (sequenzaGestita == -2L) {
                return;
            }
            Statement pstmtInsert = null;
            try {
                if (busta.getID().equals(busta.getCollaborazione())) {
                    StringBuffer queryInsert = new StringBuffer();
                    queryInsert.append("INSERT INTO  ");
                    queryInsert.append("SEQUENZA_DA_RICEVERE");
                    queryInsert.append(" VALUES ( ? , ? , ? , ? , ? , ? , ? , ? , ? )");
                    pstmtInsert = connectionDB.prepareStatement(queryInsert.toString());
                    pstmtInsert.setString(1, busta.getCollaborazione());
                    pstmtInsert.setLong(2, busta.getSequenza() + 1L);
                    pstmtInsert.setString(3, busta.getMittente());
                    pstmtInsert.setString(4, busta.getTipoMittente());
                    pstmtInsert.setString(5, busta.getDestinatario());
                    pstmtInsert.setString(6, busta.getTipoDestinatario());
                    pstmtInsert.setString(7, busta.getServizio());
                    pstmtInsert.setString(8, busta.getTipoServizio());
                    pstmtInsert.setString(9, busta.getAzione());
                } else {
                    StringBuffer queryInsert = new StringBuffer();
                    queryInsert.append("UPDATE ");
                    queryInsert.append("SEQUENZA_DA_RICEVERE");
                    queryInsert.append(" SET SEQUENZA_ATTESA = ? WHERE ID_COLLABORAZIONE=? ");
                    pstmtInsert = connectionDB.prepareStatement(queryInsert.toString());
                    long next_sequenza = busta.getSequenza() + 1L;
                    if (next_sequenza > 9999999L) {
                        next_sequenza = 1L;
                    }
                    pstmtInsert.setLong(1, next_sequenza);
                    pstmtInsert.setString(2, busta.getCollaborazione());
                }
                stateful.getPreparedStatement().put("INSERT setNextSequenza_daRicevere" + busta.getCollaborazione(), (PreparedStatement)pstmtInsert);
                repository.aggiornaSequenzaIntoInBox(busta.getID(), -2L);
            }
            catch (Exception e) {
                String errorMsg = "ConsegnaInOrdine, Errore durante la setNextSequenza_daRicevere: " + e.getMessage();
                try {
                    if (pstmtInsert != null) {
                        pstmtInsert.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
        throw new ProtocolException("Metodo invocato con IState non valido");
    }
}

