/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.builder;

import org.apache.log4j.Logger;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.eccezione.details.DettaglioEccezione;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.SOAPVersion;
import org.openspcoop2.message.XMLUtils;
import org.openspcoop2.protocol.engine.builder.DettaglioEccezioneOpenSPCoop2Builder;
import org.openspcoop2.protocol.sdk.AbstractEccezioneBuilderParameter;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.EccezioneIntegrazioneBuilderParameters;
import org.openspcoop2.protocol.sdk.EccezioneProtocolloBuilderParameters;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.builder.IErroreApplicativoBuilder;
import org.openspcoop2.protocol.sdk.builder.ProprietaErroreApplicativo;
import org.openspcoop2.protocol.sdk.config.IProtocolManager;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.w3c.dom.Element;

public class ErroreApplicativoBuilder {
    protected Logger log = null;
    protected OpenSPCoop2MessageFactory fac = OpenSPCoop2MessageFactory.getMessageFactory();
    private IProtocolFactory protocolFactory;
    private IProtocolManager protocolManager;
    private IErroreApplicativoBuilder erroreApplicativoBuilder;
    private XMLUtils xmlUtils;
    private IDSoggetto dominio;
    private IDSoggetto mittente;
    private IDServizio servizio;
    private String idFunzione;
    private ProprietaErroreApplicativo proprietaErroreApplicato;
    private SOAPVersion soapVersion;
    private DettaglioEccezioneOpenSPCoop2Builder dettaglioEccezioneOpenSPCoop2Builder;
    private String servizioApplicativo;
    private TipoPdD tipoPdD = null;

    public void setDominio(IDSoggetto dominio) {
        this.dominio = dominio;
    }

    public void setMittente(IDSoggetto mittente) {
        this.mittente = mittente;
    }

    public void setServizio(IDServizio servizio) {
        this.servizio = servizio;
    }

    public void setProprietaErroreApplicato(ProprietaErroreApplicativo proprietaErroreApplicato) {
        this.proprietaErroreApplicato = proprietaErroreApplicato;
    }

    public void setServizioApplicativo(String servizioApplicativo) {
        this.servizioApplicativo = servizioApplicativo;
    }

    public void setTipoPdD(TipoPdD tipoPdD) {
        this.tipoPdD = tipoPdD;
    }

    public ErroreApplicativoBuilder(Logger aLog, IProtocolFactory protocolFactory, IDSoggetto dominio, IDSoggetto mittente, IDServizio servizio, String idFunzione, ProprietaErroreApplicativo proprietaErroreApplicativo, SOAPVersion soapVersion, TipoPdD tipoPdD, String servizioApplicativo) throws ProtocolException {
        this.log = aLog != null ? aLog : Logger.getLogger(ErroreApplicativoBuilder.class);
        this.protocolFactory = protocolFactory;
        this.xmlUtils = XMLUtils.getInstance();
        this.protocolManager = this.protocolFactory.createProtocolManager();
        this.erroreApplicativoBuilder = this.protocolFactory.createErroreApplicativoBuilder();
        this.dominio = dominio;
        this.mittente = mittente;
        this.servizio = servizio;
        this.idFunzione = idFunzione;
        this.proprietaErroreApplicato = proprietaErroreApplicativo;
        this.soapVersion = soapVersion;
        this.dettaglioEccezioneOpenSPCoop2Builder = new DettaglioEccezioneOpenSPCoop2Builder(aLog, protocolFactory);
        this.tipoPdD = tipoPdD;
        this.servizioApplicativo = servizioApplicativo;
    }

    public IProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    private void setEccezioneBuilderParameter(AbstractEccezioneBuilderParameter parameters, DettaglioEccezione dettaglio, Exception exception) {
        parameters.setDettaglioEccezionePdD(dettaglio);
        parameters.setDominioPorta(this.dominio);
        parameters.setMittente(this.mittente);
        parameters.setServizio(this.servizio);
        parameters.setIdFunzione(this.idFunzione);
        parameters.setException(exception);
        parameters.setProprieta(this.proprietaErroreApplicato);
        parameters.setVersioneSoap(this.soapVersion);
        parameters.setTipoPorta(this.tipoPdD);
        parameters.setServizioApplicativo(this.servizioApplicativo);
    }

    private EccezioneProtocolloBuilderParameters getEccezioneProtocolloBuilderParameters(Eccezione eccezioneProtocollo, IDSoggetto soggettoProduceEccezione, DettaglioEccezione dettaglio, Exception exception) {
        EccezioneProtocolloBuilderParameters parameters = new EccezioneProtocolloBuilderParameters();
        this.setEccezioneBuilderParameter((AbstractEccezioneBuilderParameter)parameters, dettaglio, exception);
        parameters.setEccezioneProtocollo(eccezioneProtocollo);
        parameters.setSoggettoProduceEccezione(soggettoProduceEccezione);
        return parameters;
    }

    private EccezioneIntegrazioneBuilderParameters getEccezioneIntegrazioneBuilderParameters(ErroreIntegrazione erroreIntegrazione, DettaglioEccezione dettaglio, Exception exception) {
        EccezioneIntegrazioneBuilderParameters parameters = new EccezioneIntegrazioneBuilderParameters();
        this.setEccezioneBuilderParameter((AbstractEccezioneBuilderParameter)parameters, dettaglio, exception);
        parameters.setErroreIntegrazione(erroreIntegrazione);
        return parameters;
    }

    public Element toElement(ErroreIntegrazione errore) throws ProtocolException {
        EccezioneIntegrazioneBuilderParameters parameters = this.getEccezioneIntegrazioneBuilderParameters(errore, null, null);
        return this.erroreApplicativoBuilder.toElement(parameters);
    }

    public byte[] toByteArray(ErroreIntegrazione errore) throws ProtocolException {
        Element eccezione = this.toElement(errore);
        if (eccezione == null) {
            throw new ProtocolException("Elemento non generato");
        }
        try {
            return this.xmlUtils.toByteArray(eccezione, true);
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildBytes_Eccezione error: " + e.getMessage()), (Throwable)e);
            throw new ProtocolException("toByte failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public void insertInSOAPFault(ErroreIntegrazione errore, OpenSPCoop2Message msg) throws ProtocolException {
        EccezioneIntegrazioneBuilderParameters parameters = this.getEccezioneIntegrazioneBuilderParameters(errore, null, null);
        this.erroreApplicativoBuilder.insertInSOAPFault(parameters, msg);
    }

    public void insertRoutingErrorInSOAPFault(IDSoggetto identitaRouter, String idFunzione, String msgErrore, OpenSPCoop2Message msg) throws ProtocolException {
        this.erroreApplicativoBuilder.insertRoutingErrorInSOAPFault(identitaRouter, idFunzione, msgErrore, msg);
    }

    public OpenSPCoop2Message toMessage(ErroreIntegrazione errore, Exception eParsing) {
        return this.toMessage(errore, null, eParsing);
    }

    public OpenSPCoop2Message toMessage(ErroreIntegrazione errore, Exception eProcessamento, Exception eParsing) {
        try {
            boolean produciDettaglioEccezione = false;
            produciDettaglioEccezione = errore.getCodiceErrore().getCodice() < 500 ? this.protocolManager.isGenerazioneDetailsSOAPFaultIntegratione_erroreClient() : this.protocolManager.isGenerazioneDetailsSOAPFaultIntegratione_erroreServer();
            String msgErroreTrasformato = this.proprietaErroreApplicato.transformFaultMsg(errore, this.protocolFactory);
            String codErroreTrasformato = this.protocolFactory.createTraduttore().toString(errore.getCodiceErrore(), this.proprietaErroreApplicato.getFaultPrefixCode(), this.proprietaErroreApplicato.isFaultAsGenericCode());
            DettaglioEccezione dettaglioEccezione = null;
            if (produciDettaglioEccezione) {
                dettaglioEccezione = this.dettaglioEccezioneOpenSPCoop2Builder.buildDettaglioEccezione(this.dominio, this.tipoPdD, this.idFunzione, codErroreTrasformato, msgErroreTrasformato, false);
                if (eProcessamento != null) {
                    boolean informazioniGeneriche = this.proprietaErroreApplicato.isInformazioniGenericheDetailsOpenSPCoop();
                    this.dettaglioEccezioneOpenSPCoop2Builder.gestioneDettaglioEccezioneIntegrazione(eProcessamento, dettaglioEccezione, informazioniGeneriche);
                }
            }
            EccezioneIntegrazioneBuilderParameters parameters = this.getEccezioneIntegrazioneBuilderParameters(errore, dettaglioEccezione, eParsing);
            return this.erroreApplicativoBuilder.toMessage(parameters);
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la costruzione del messaggio di eccezione integrazione", (Throwable)e);
            return this.fac.createFaultMessage(this.soapVersion, "ErroreDiProcessamento");
        }
    }

    public OpenSPCoop2Message toMessage(Eccezione eccezione, IDSoggetto soggettoProduceEccezione, Exception eParsing) {
        EccezioneProtocolloBuilderParameters parameters = this.getEccezioneProtocolloBuilderParameters(eccezione, soggettoProduceEccezione, null, eParsing);
        try {
            return this.erroreApplicativoBuilder.toMessage(parameters);
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la costruzione del messaggio di eccezione busta", (Throwable)e);
            return this.fac.createFaultMessage(this.soapVersion, "ErroreDiProcessamento");
        }
    }

    public OpenSPCoop2Message toMessage(Eccezione eccezione, IDSoggetto soggettoProduceEccezione, DettaglioEccezione dettaglioEccezione, Exception eParsing) {
        try {
            EccezioneProtocolloBuilderParameters parameters = this.getEccezioneProtocolloBuilderParameters(eccezione, soggettoProduceEccezione, dettaglioEccezione, eParsing);
            return this.erroreApplicativoBuilder.toMessage(parameters);
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la costruzione del messaggio di eccezione busta", (Throwable)e);
            return this.fac.createFaultMessage(this.soapVersion, "ErroreDiProcessamento");
        }
    }
}

