/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.builder;

import org.apache.log4j.Logger;
import org.openspcoop2.protocol.engine.Configurazione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.diagnostica.IXMLDiagnosticoBuilder;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.w3c.dom.Element;

public class DiagnosticoBuilder {
    protected Logger log = null;
    private IProtocolFactory protocolFactory;
    private IXMLDiagnosticoBuilder diagnosticoProtocolBuilder;

    public DiagnosticoBuilder(IProtocolFactory protocolFactory) {
        this(Configurazione.getLibraryLog(), protocolFactory);
    }

    public DiagnosticoBuilder(Logger aLog, IProtocolFactory protocolFactory) {
        this.log = aLog != null ? aLog : Logger.getLogger(DiagnosticoBuilder.class);
        this.protocolFactory = protocolFactory;
        try {
            this.diagnosticoProtocolBuilder = this.protocolFactory.createXMLDiagnosticoBuilder();
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante la creazione dell'XMLDiagnosticoBuilder: " + e.getMessage()), (Throwable)e);
        }
    }

    public IProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    public Element toElement(MsgDiagnostico msgDiag) throws ProtocolException {
        return this.diagnosticoProtocolBuilder.toElement(msgDiag);
    }

    public byte[] toByteArray(MsgDiagnostico msgDiag) throws ProtocolException {
        return this.diagnosticoProtocolBuilder.toByteArray(msgDiag);
    }

    public String toString(MsgDiagnostico msgDiag) throws ProtocolException {
        return this.diagnosticoProtocolBuilder.toString(msgDiag);
    }
}

