/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.archive;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.xml.namespace.QName;
import org.openspcoop2.core.config.Credenziali;
import org.openspcoop2.core.config.InvocazioneServizio;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.IdSoggetto;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.constants.TipologiaServizio;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.message.XMLUtils;
import org.openspcoop2.protocol.engine.archive.ImportInformationMissing;
import org.openspcoop2.protocol.engine.archive.ImportInformationMissingCollection;
import org.openspcoop2.protocol.engine.archive.ImportInformationMissingException;
import org.openspcoop2.protocol.engine.archive.ImporterInformationMissingSetter;
import org.openspcoop2.protocol.information_missing.AccordoCooperazione;
import org.openspcoop2.protocol.information_missing.AccordoServizioParteComune;
import org.openspcoop2.protocol.information_missing.AccordoServizioParteSpecifica;
import org.openspcoop2.protocol.information_missing.Input;
import org.openspcoop2.protocol.information_missing.Openspcoop2;
import org.openspcoop2.protocol.information_missing.Soggetto;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.Archive;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoCooperazione;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioComposto;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteComune;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteSpecifica;
import org.openspcoop2.protocol.sdk.archive.ArchiveFruitore;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaApplicativa;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaDelegata;
import org.openspcoop2.protocol.sdk.archive.ArchiveServizioApplicativo;
import org.openspcoop2.protocol.sdk.archive.ArchiveSoggetto;
import org.openspcoop2.protocol.sdk.archive.IRegistryReader;
import org.openspcoop2.protocol.sdk.archive.RegistryNotFound;
import org.openspcoop2.protocol.sdk.validator.IValidazioneDocumenti;
import org.openspcoop2.protocol.sdk.validator.ValidazioneResult;
import org.openspcoop2.utils.wsdl.DefinitionWrapper;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.w3c.dom.Document;

public class ImporterInformationMissingUtils {
    private IDAccordoCooperazioneFactory idAccordoCooperazioneFactory = IDAccordoCooperazioneFactory.getInstance();
    private IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
    private ImportInformationMissingCollection importInformationMissingCollection = null;
    private boolean validateDocuments = false;
    private IProtocolFactory protocolFactory;
    private IValidazioneDocumenti validatoreDocumenti;
    private AbstractXMLUtils xmlUtils;
    private IRegistryReader registryReader;
    private Archive archive;

    public ImporterInformationMissingUtils(ImportInformationMissingCollection importInformationMissingCollection, IRegistryReader registryReader, boolean validateDocuments, IProtocolFactory protocolFactory, String userLogin, Archive archive) throws Exception {
        this.importInformationMissingCollection = importInformationMissingCollection;
        this.validateDocuments = validateDocuments;
        this.protocolFactory = protocolFactory;
        this.validatoreDocumenti = this.protocolFactory.createValidazioneDocumenti();
        this.xmlUtils = XMLUtils.getInstance();
        this.registryReader = registryReader;
        this.archive = archive;
    }

    public void validateAndFillInformationMissing(Openspcoop2 archiveInformationMissing) throws Exception {
        ImportInformationMissingException infoException = null;
        String objectId = null;
        String objectIdDescription = null;
        ImportInformationMissing importInformationMissing = null;
        boolean throwException = false;
        try {
            AccordoServizioParteComune asMissingInfo;
            boolean updateInfo;
            int i;
            if (!throwException && archiveInformationMissing.sizeSoggettoList() > 0) {
                for (i = 0; i < archiveInformationMissing.sizeSoggettoList(); ++i) {
                    Soggetto soggettoMissingInfo = archiveInformationMissing.getSoggetto(i);
                    importInformationMissing = null;
                    objectId = "[[InformationMissingSoggetto-" + i + "]]";
                    objectIdDescription = soggettoMissingInfo.getDescrizione();
                    if (this.importInformationMissingCollection != null) {
                        importInformationMissing = this.importInformationMissingCollection.get(objectId);
                    }
                    updateInfo = false;
                    switch (soggettoMissingInfo.getTipo()) {
                        case RIFERIMENTO: {
                            if (importInformationMissing != null && importInformationMissing.getSoggetto() != null) {
                                if (!this.registryReader.existsSoggetto(importInformationMissing.getSoggetto())) {
                                    boolean found = false;
                                    if (this.archive.getSoggetti() != null && this.archive.getSoggetti().size() > 0) {
                                        for (int j = 0; j < this.archive.getSoggetti().size(); ++j) {
                                            ArchiveSoggetto archiveSoggetto = (ArchiveSoggetto)this.archive.getSoggetti().get(j);
                                            if (!archiveSoggetto.getIdSoggetto().equals((Object)importInformationMissing.getSoggetto())) continue;
                                            found = true;
                                            break;
                                        }
                                    }
                                    if (!found) {
                                        throw new ProtocolException("Il Soggetto " + importInformationMissing.getSoggetto().toString() + " non esiste (indicato in ImportInformationMissing parameter??)");
                                    }
                                }
                                updateInfo = true;
                                break;
                            }
                            infoException = new ImportInformationMissingException(objectId, objectIdDescription);
                            infoException.setMissingInfoSoggetto(true);
                            infoException.setMissingInfoSoggetto_protocollo(soggettoMissingInfo.getProtocollo());
                            if (soggettoMissingInfo.getTipoPdd() != null) {
                                infoException.setMissingInfoSoggetto_tipoPdD(soggettoMissingInfo.getTipoPdd().getValue());
                            }
                            throwException = true;
                            break;
                        }
                        case CONNETTORE: {
                            if (importInformationMissing != null && importInformationMissing.getInvocazioneServizio() != null) {
                                updateInfo = true;
                                break;
                            }
                            infoException = new ImportInformationMissingException(objectId, objectIdDescription);
                            infoException.setMissingInfoInvocazioneServizio(true);
                            infoException.setMissingInfoSoggetto_protocollo(soggettoMissingInfo.getProtocollo());
                            if (soggettoMissingInfo.getTipoPdd() != null) {
                                infoException.setMissingInfoSoggetto_tipoPdD(soggettoMissingInfo.getTipoPdd().getValue());
                            }
                            throwException = true;
                        }
                    }
                    if (throwException || !updateInfo) break;
                    IDSoggetto importInformationMissing_soggetto = null;
                    Connettore importInformationMissing_connettore = null;
                    if (importInformationMissing != null) {
                        importInformationMissing_soggetto = importInformationMissing.getSoggetto();
                        importInformationMissing_connettore = importInformationMissing.getConnettore();
                    }
                    ImporterInformationMissingSetter.setInformationMissingSoggetto(this.archive, soggettoMissingInfo, importInformationMissing_soggetto, importInformationMissing_connettore);
                }
            }
            if (!throwException && archiveInformationMissing.sizeInputList() > 0) {
                for (i = 0; i < archiveInformationMissing.sizeInputList(); ++i) {
                    Input inputMissingInfo = archiveInformationMissing.getInput(i);
                    importInformationMissing = null;
                    objectId = "[[InformationMissingInput-" + i + "]]";
                    objectIdDescription = inputMissingInfo.getDescrizione();
                    if (this.importInformationMissingCollection != null) {
                        importInformationMissing = this.importInformationMissingCollection.get(objectId);
                    }
                    if (importInformationMissing == null || importInformationMissing.getInputPlaceholder() == null) {
                        infoException = new ImportInformationMissingException(objectId, objectIdDescription);
                        infoException.setMissingInfoInput(true);
                        infoException.setMissingInfoInputObject(inputMissingInfo);
                        throwException = true;
                    }
                    if (throwException) break;
                }
            }
            if (!throwException && archiveInformationMissing.sizeServizioApplicativoList() > 0) {
                for (i = 0; i < archiveInformationMissing.sizeServizioApplicativoList(); ++i) {
                    org.openspcoop2.protocol.information_missing.ServizioApplicativo saMissingInfo = archiveInformationMissing.getServizioApplicativo(i);
                    importInformationMissing = null;
                    objectId = "[[InformationMissingServizioApplicativo-" + i + "]]";
                    objectIdDescription = saMissingInfo.getDescrizione();
                    if (this.importInformationMissingCollection != null) {
                        importInformationMissing = this.importInformationMissingCollection.get(objectId);
                    }
                    updateInfo = false;
                    switch (saMissingInfo.getTipo()) {
                        case RIFERIMENTO: {
                            break;
                        }
                        case CONNETTORE: {
                            if (importInformationMissing != null && importInformationMissing.getInvocazioneServizio() != null) {
                                updateInfo = true;
                                break;
                            }
                            infoException = new ImportInformationMissingException(objectId, objectIdDescription);
                            infoException.setMissingInfoInvocazioneServizio(true);
                            throwException = true;
                            break;
                        }
                        case CREDENZIALI_ACCESSO_PDD: {
                            if (importInformationMissing != null && importInformationMissing.getCredenziali() != null) {
                                updateInfo = true;
                                break;
                            }
                            infoException = new ImportInformationMissingException(objectId, objectIdDescription);
                            infoException.setMissingInfoCredenziali(true);
                            throwException = true;
                            break;
                        }
                        case ALLINEA_CREDENZIALI_PD: {
                            updateInfo = true;
                        }
                    }
                    if (throwException || !updateInfo) break;
                    InvocazioneServizio importInformationMissing_invocazioneServizio = null;
                    Credenziali importInformationMissing_credenziali = null;
                    if (importInformationMissing != null) {
                        importInformationMissing_invocazioneServizio = importInformationMissing.getInvocazioneServizio();
                        importInformationMissing_credenziali = importInformationMissing.getCredenziali();
                    }
                    ImporterInformationMissingSetter.setInformationMissingServizioApplicativo(this.archive, saMissingInfo, importInformationMissing_invocazioneServizio, importInformationMissing_credenziali);
                }
            }
            if (!throwException && archiveInformationMissing.sizeAccordoCooperazioneList() > 0) {
                for (i = 0; i < archiveInformationMissing.sizeAccordoCooperazioneList(); ++i) {
                    AccordoCooperazione acMissingInfo = archiveInformationMissing.getAccordoCooperazione(i);
                    importInformationMissing = null;
                    objectId = "[[InformationMissingAccordoCooperazione-" + i + "]]";
                    objectIdDescription = acMissingInfo.getDescrizione();
                    if (this.importInformationMissingCollection != null) {
                        importInformationMissing = this.importInformationMissingCollection.get(objectId);
                    }
                    updateInfo = false;
                    switch (acMissingInfo.getTipo()) {
                        case RIFERIMENTO: {
                            if (importInformationMissing != null && importInformationMissing.getIdAccordoCooperazione() != null) {
                                updateInfo = true;
                                break;
                            }
                            infoException = new ImportInformationMissingException(objectId, objectIdDescription);
                            infoException.setMissingInfoAccordoCooperazione(true);
                            throwException = true;
                            break;
                        }
                        case STATO_ARCHIVIO: {
                            updateInfo = true;
                        }
                    }
                    if (throwException || !updateInfo) break;
                    IDAccordoCooperazione importInformationMissing_idAccordoCooperazione = null;
                    if (importInformationMissing != null) {
                        importInformationMissing_idAccordoCooperazione = importInformationMissing.getIdAccordoCooperazione();
                    }
                    ImporterInformationMissingSetter.setInformationMissingAccordoCooperazione(this.archive, acMissingInfo, importInformationMissing_idAccordoCooperazione);
                }
            }
            if (!throwException && archiveInformationMissing.sizeAccordoServizioParteComuneList() > 0) {
                for (i = 0; i < archiveInformationMissing.sizeAccordoServizioParteComuneList(); ++i) {
                    asMissingInfo = archiveInformationMissing.getAccordoServizioParteComune(i);
                    importInformationMissing = null;
                    objectId = "[[InformationMissingAccordoServizioParteComune-" + i + "]]";
                    objectIdDescription = asMissingInfo.getDescrizione();
                    if (this.importInformationMissingCollection != null) {
                        importInformationMissing = this.importInformationMissingCollection.get(objectId);
                    }
                    updateInfo = false;
                    switch (asMissingInfo.getTipo()) {
                        case RIFERIMENTO: {
                            if (importInformationMissing != null && importInformationMissing.getIdAccordoServizioParteComune() != null) {
                                updateInfo = true;
                                break;
                            }
                            infoException = new ImportInformationMissingException(objectId, objectIdDescription);
                            infoException.setMissingInfoAccordoServizioParteComune(true);
                            throwException = true;
                            break;
                        }
                        case STATO_ARCHIVIO: {
                            updateInfo = true;
                        }
                    }
                    if (throwException || !updateInfo) break;
                    IDAccordo importInformationMissing_idAccordo = null;
                    if (importInformationMissing != null) {
                        importInformationMissing_idAccordo = importInformationMissing.getIdAccordoServizioParteComune();
                    }
                    ImporterInformationMissingSetter.setInformationMissingAccordoServizioParteComune(this.archive, asMissingInfo, importInformationMissing_idAccordo);
                }
            }
            if (!throwException && archiveInformationMissing.sizeAccordoServizioParteSpecificaList() > 0) {
                for (i = 0; i < archiveInformationMissing.sizeAccordoServizioParteSpecificaList(); ++i) {
                    AccordoServizioParteSpecifica aspsMissingInfo = archiveInformationMissing.getAccordoServizioParteSpecifica(i);
                    importInformationMissing = null;
                    objectId = "[[InformationMissingAPS-" + i + "]]";
                    objectIdDescription = aspsMissingInfo.getDescrizione();
                    if (this.importInformationMissingCollection != null) {
                        importInformationMissing = this.importInformationMissingCollection.get(objectId);
                    }
                    updateInfo = false;
                    switch (aspsMissingInfo.getTipo()) {
                        case CONNETTORE: {
                            if (importInformationMissing != null && importInformationMissing.getConnettore() != null) {
                                updateInfo = true;
                                break;
                            }
                            infoException = new ImportInformationMissingException(objectId, objectIdDescription);
                            infoException.setMissingInfoConnettore(true);
                            throwException = true;
                            break;
                        }
                        case STATO_ARCHIVIO: {
                            updateInfo = true;
                        }
                    }
                    if (throwException || !updateInfo) break;
                    Connettore importInformationMissing_connettore = null;
                    if (importInformationMissing != null) {
                        importInformationMissing_connettore = importInformationMissing.getConnettore();
                    }
                    ImporterInformationMissingSetter.setInformationMissingAccordoServizioParteSpecifica(this.archive, aspsMissingInfo, importInformationMissing_connettore);
                }
            }
            if (!throwException && archiveInformationMissing.sizeAccordoServizioCompostoList() > 0) {
                for (i = 0; i < archiveInformationMissing.sizeAccordoServizioCompostoList(); ++i) {
                    asMissingInfo = archiveInformationMissing.getAccordoServizioComposto(i);
                    importInformationMissing = null;
                    objectId = "[[InformationMissingAccordoServizioComposto-" + i + "]]";
                    objectIdDescription = asMissingInfo.getDescrizione();
                    if (this.importInformationMissingCollection != null) {
                        importInformationMissing = this.importInformationMissingCollection.get(objectId);
                    }
                    updateInfo = false;
                    switch (asMissingInfo.getTipo()) {
                        case RIFERIMENTO: {
                            if (importInformationMissing != null && importInformationMissing.getIdAccordoServizioParteComune() != null) {
                                updateInfo = true;
                                break;
                            }
                            infoException = new ImportInformationMissingException(objectId, objectIdDescription);
                            infoException.setMissingInfoAccordoServizioParteComune(true);
                            throwException = true;
                            break;
                        }
                        case STATO_ARCHIVIO: {
                            updateInfo = true;
                        }
                    }
                    if (throwException || !updateInfo) break;
                    IDAccordo importInformationMissing_idAccordo = null;
                    if (importInformationMissing != null) {
                        importInformationMissing_idAccordo = importInformationMissing.getIdAccordoServizioParteComune();
                    }
                    ImporterInformationMissingSetter.setInformationMissingAccordoServizioComposto(this.archive, asMissingInfo, importInformationMissing_idAccordo);
                }
            }
            if (!throwException && archiveInformationMissing.sizeFruitoreList() > 0) {
                for (i = 0; i < archiveInformationMissing.sizeFruitoreList(); ++i) {
                    org.openspcoop2.protocol.information_missing.Fruitore fruitoreMissingInfo = archiveInformationMissing.getFruitore(i);
                    importInformationMissing = null;
                    objectId = "[[InformationMissingFruitore-" + i + "]]";
                    objectIdDescription = fruitoreMissingInfo.getDescrizione();
                    if (this.importInformationMissingCollection != null) {
                        importInformationMissing = this.importInformationMissingCollection.get(objectId);
                    }
                    updateInfo = false;
                    switch (fruitoreMissingInfo.getTipo()) {
                        case STATO_ARCHIVIO: {
                            updateInfo = true;
                        }
                    }
                    if (throwException || !updateInfo) break;
                    ImporterInformationMissingSetter.setInformationMissingFruitore(this.archive, fruitoreMissingInfo);
                }
            }
            if (throwException) {
                throw infoException;
            }
        }
        catch (ImportInformationMissingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Exception(objectIdDescription + " validazione fallita: " + e.getMessage(), e);
        }
    }

    public void validateAndFillServizioApplicativo(ArchiveServizioApplicativo archiveServizioApplicativo) throws Exception {
        ServizioApplicativo sa = archiveServizioApplicativo.getServizioApplicativo();
        String uri = sa.getNome();
        if (sa.getTipoSoggettoProprietario() != null && sa.getNomeSoggettoProprietario() != null) {
            uri = uri + ":" + sa.getTipoSoggettoProprietario() + "/" + sa.getNomeSoggettoProprietario();
        }
        String objectId = "[[SA]]" + uri;
        String objectIdDescription = "Servizio Applicativo [" + uri + "]";
        ImportInformationMissing importInformationMissing = null;
        if (this.importInformationMissingCollection != null) {
            importInformationMissing = this.importInformationMissingCollection.get(objectId);
        }
        try {
            String tipoSoggettoProprietario = sa.getTipoSoggettoProprietario();
            String nomeSoggettoProprietario = sa.getNomeSoggettoProprietario();
            if (tipoSoggettoProprietario == null || nomeSoggettoProprietario == null) {
                ImportInformationMissingException infoException = new ImportInformationMissingException(objectId, objectIdDescription);
                boolean throwException = false;
                if (tipoSoggettoProprietario == null || nomeSoggettoProprietario == null) {
                    if (importInformationMissing != null && importInformationMissing.getSoggetto() != null) {
                        if (!this.registryReader.existsSoggetto(importInformationMissing.getSoggetto())) {
                            boolean found = false;
                            if (this.archive.getSoggetti() != null && this.archive.getSoggetti().size() > 0) {
                                for (int i = 0; i < this.archive.getSoggetti().size(); ++i) {
                                    ArchiveSoggetto archiveSoggetto = (ArchiveSoggetto)this.archive.getSoggetti().get(i);
                                    if (!archiveSoggetto.getIdSoggetto().equals((Object)importInformationMissing.getSoggetto())) continue;
                                    found = true;
                                    break;
                                }
                            }
                            if (!found) {
                                throw new ProtocolException("Il Soggetto " + importInformationMissing.getSoggetto().toString() + " non esiste (indicato in ImportInformationMissing parameter??)");
                            }
                        }
                        sa.setTipoSoggettoProprietario(importInformationMissing.getSoggetto().getTipo());
                        sa.setNomeSoggettoProprietario(importInformationMissing.getSoggetto().getNome());
                    } else {
                        infoException.setMissingInfoSoggetto(true);
                        throwException = true;
                    }
                }
                if (throwException) {
                    throw infoException;
                }
            }
        }
        catch (ImportInformationMissingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Exception(objectIdDescription + " validazione fallita: " + e.getMessage(), e);
        }
    }

    public void validateAndFillPortaDelegata(ArchivePortaDelegata archivePortaDelegata) throws Exception {
        PortaDelegata pd = archivePortaDelegata.getPortaDelegata();
        String uri = pd.getNome();
        if (pd.getTipoSoggettoProprietario() != null && pd.getNomeSoggettoProprietario() != null) {
            uri = uri + ":" + pd.getTipoSoggettoProprietario() + "/" + pd.getNomeSoggettoProprietario();
        }
        String objectId = "[[PD]]" + uri;
        String objectIdDescription = "PortaDelegata [" + uri + "]";
        ImportInformationMissing importInformationMissing = null;
        if (this.importInformationMissingCollection != null) {
            importInformationMissing = this.importInformationMissingCollection.get(objectId);
        }
        try {
            String tipoSoggettoProprietario = pd.getTipoSoggettoProprietario();
            String nomeSoggettoProprietario = pd.getNomeSoggettoProprietario();
            if (tipoSoggettoProprietario == null || nomeSoggettoProprietario == null) {
                ImportInformationMissingException infoException = new ImportInformationMissingException(objectId, objectIdDescription);
                boolean throwException = false;
                if (tipoSoggettoProprietario == null || nomeSoggettoProprietario == null) {
                    if (importInformationMissing != null && importInformationMissing.getSoggetto() != null) {
                        if (!this.registryReader.existsSoggetto(importInformationMissing.getSoggetto())) {
                            boolean found = false;
                            if (this.archive.getSoggetti() != null && this.archive.getSoggetti().size() > 0) {
                                for (int i = 0; i < this.archive.getSoggetti().size(); ++i) {
                                    ArchiveSoggetto archiveSoggetto = (ArchiveSoggetto)this.archive.getSoggetti().get(i);
                                    if (!archiveSoggetto.getIdSoggetto().equals((Object)importInformationMissing.getSoggetto())) continue;
                                    found = true;
                                    break;
                                }
                            }
                            if (!found) {
                                throw new ProtocolException("Il Soggetto " + importInformationMissing.getSoggetto().toString() + " non esiste (indicato in ImportInformationMissing parameter??)");
                            }
                        }
                        pd.setTipoSoggettoProprietario(importInformationMissing.getSoggetto().getTipo());
                        pd.setNomeSoggettoProprietario(importInformationMissing.getSoggetto().getNome());
                    } else {
                        infoException.setMissingInfoSoggetto(true);
                        throwException = true;
                    }
                }
                if (throwException) {
                    throw infoException;
                }
            }
        }
        catch (ImportInformationMissingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Exception(objectIdDescription + " validazione fallita: " + e.getMessage(), e);
        }
    }

    public void validateAndFillPortaApplicativa(ArchivePortaApplicativa archivePortaApplicativa) throws Exception {
        PortaApplicativa pa = archivePortaApplicativa.getPortaApplicativa();
        String uri = pa.getNome();
        if (pa.getTipoSoggettoProprietario() != null && pa.getNomeSoggettoProprietario() != null) {
            uri = uri + ":" + pa.getTipoSoggettoProprietario() + "/" + pa.getNomeSoggettoProprietario();
        }
        String objectId = "[[PD]]" + uri;
        String objectIdDescription = "PortaApplicativa [" + uri + "]";
        ImportInformationMissing importInformationMissing = null;
        if (this.importInformationMissingCollection != null) {
            importInformationMissing = this.importInformationMissingCollection.get(objectId);
        }
        try {
            String tipoSoggettoProprietario = pa.getTipoSoggettoProprietario();
            String nomeSoggettoProprietario = pa.getNomeSoggettoProprietario();
            if (tipoSoggettoProprietario == null || nomeSoggettoProprietario == null) {
                ImportInformationMissingException infoException = new ImportInformationMissingException(objectId, objectIdDescription);
                boolean throwException = false;
                if (tipoSoggettoProprietario == null || nomeSoggettoProprietario == null) {
                    if (importInformationMissing != null && importInformationMissing.getSoggetto() != null) {
                        if (!this.registryReader.existsSoggetto(importInformationMissing.getSoggetto())) {
                            boolean found = false;
                            if (this.archive.getSoggetti() != null && this.archive.getSoggetti().size() > 0) {
                                for (int i = 0; i < this.archive.getSoggetti().size(); ++i) {
                                    ArchiveSoggetto archiveSoggetto = (ArchiveSoggetto)this.archive.getSoggetti().get(i);
                                    if (!archiveSoggetto.getIdSoggetto().equals((Object)importInformationMissing.getSoggetto())) continue;
                                    found = true;
                                    break;
                                }
                            }
                            if (!found) {
                                throw new ProtocolException("Il Soggetto " + importInformationMissing.getSoggetto().toString() + " non esiste (indicato in ImportInformationMissing parameter??)");
                            }
                        }
                        pa.setTipoSoggettoProprietario(importInformationMissing.getSoggetto().getTipo());
                        pa.setNomeSoggettoProprietario(importInformationMissing.getSoggetto().getNome());
                    } else {
                        infoException.setMissingInfoSoggetto(true);
                        throwException = true;
                    }
                }
                if (throwException) {
                    throw infoException;
                }
            }
        }
        catch (ImportInformationMissingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Exception(objectIdDescription + " validazione fallita: " + e.getMessage(), e);
        }
    }

    public void validateAndFillAccordoCooperazione(ArchiveAccordoCooperazione archiveAccordoCooperazione) throws Exception {
        org.openspcoop2.core.registry.AccordoCooperazione ac = archiveAccordoCooperazione.getAccordoCooperazione();
        String uri = this.idAccordoCooperazioneFactory.getUriFromAccordo(ac);
        String objectId = "[[AC]]" + uri;
        String objectIdDescription = "Accordo di Cooperazione [" + uri + "]";
        ImportInformationMissing importInformationMissing = null;
        if (this.importInformationMissingCollection != null) {
            importInformationMissing = this.importInformationMissingCollection.get(objectId);
        }
        try {
            ValidazioneResult result;
            IdSoggetto acSoggettoReferente = ac.getSoggettoReferente();
            String versione = ac.getVersione();
            if (acSoggettoReferente == null || acSoggettoReferente.getTipo() == null || acSoggettoReferente.getNome() == null || versione == null) {
                ImportInformationMissingException infoException = new ImportInformationMissingException(objectId, objectIdDescription);
                boolean throwException = false;
                if (acSoggettoReferente == null || acSoggettoReferente.getTipo() == null || acSoggettoReferente.getNome() == null) {
                    if (importInformationMissing != null && importInformationMissing.getSoggetto() != null) {
                        if (!this.registryReader.existsSoggetto(importInformationMissing.getSoggetto())) {
                            boolean found = false;
                            if (this.archive.getSoggetti() != null && this.archive.getSoggetti().size() > 0) {
                                for (int i = 0; i < this.archive.getSoggetti().size(); ++i) {
                                    ArchiveSoggetto archiveSoggetto = (ArchiveSoggetto)this.archive.getSoggetti().get(i);
                                    if (!archiveSoggetto.getIdSoggetto().equals((Object)importInformationMissing.getSoggetto())) continue;
                                    found = true;
                                    break;
                                }
                            }
                            if (!found) {
                                throw new ProtocolException("Il Soggetto " + importInformationMissing.getSoggetto().toString() + " non esiste (indicato in ImportInformationMissing parameter??)");
                            }
                        }
                        IdSoggetto acSoggettoReferenteNew = new IdSoggetto();
                        acSoggettoReferenteNew.setTipo(importInformationMissing.getSoggetto().getTipo());
                        acSoggettoReferenteNew.setNome(importInformationMissing.getSoggetto().getNome());
                        ac.setSoggettoReferente(acSoggettoReferenteNew);
                    } else {
                        infoException.setMissingInfoSoggetto(true);
                        throwException = true;
                    }
                }
                if (versione == null) {
                    if (importInformationMissing != null && importInformationMissing.getVersione() != null) {
                        ac.setVersione(importInformationMissing.getVersione() + "");
                    } else {
                        infoException.setMissingInfoVersione(true);
                        throwException = true;
                    }
                }
                if (throwException) {
                    throw infoException;
                }
            }
            if (this.validateDocuments && !(result = this.validatoreDocumenti.validaDocumenti(ac)).isEsito()) {
                if (result.getException() != null) {
                    throw new Exception(result.getMessaggioErrore(), result.getException());
                }
                throw new Exception(result.getMessaggioErrore());
            }
        }
        catch (ImportInformationMissingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Exception(objectIdDescription + " validazione fallita: " + e.getMessage(), e);
        }
    }

    public void validateAndFillAccordoServizioParteComune(ArchiveAccordoServizioParteComune archiveAspc, boolean checkCorrelazioneAsincrona) throws Exception {
        this.validateAndFillAccordoServizioEngine(archiveAspc.getAccordoServizioParteComune(), checkCorrelazioneAsincrona);
    }

    public void validateAndFillAccordoServizioParteComune(ArchiveAccordoServizioComposto archiveAsc, boolean checkCorrelazioneAsincrona) throws Exception {
        this.validateAndFillAccordoServizioEngine(archiveAsc.getAccordoServizioParteComune(), checkCorrelazioneAsincrona);
    }

    private void validateAndFillAccordoServizioEngine(org.openspcoop2.core.registry.AccordoServizioParteComune aspc, boolean checkCorrelazioneAsincrona) throws Exception {
        String uri = this.idAccordoFactory.getUriFromAccordo(aspc);
        String tipoAccordo = "[[ASPC]]";
        if (aspc.getServizioComposto() != null) {
            tipoAccordo = "[[ASC]]";
        }
        String objectId = tipoAccordo + uri;
        String objectIdDescription = "Accordo di Servizio Parte Comune [" + uri + "]";
        if (aspc.getServizioComposto() != null) {
            objectIdDescription = "Accordo di Servizio Composto [" + uri + "]";
            if (aspc.getServizioComposto().getAccordoCooperazione() != null && !"".equals(aspc.getServizioComposto().getAccordoCooperazione().trim())) {
                objectIdDescription = objectIdDescription + " (rifAccordo: " + aspc.getServizioComposto().getAccordoCooperazione() + ")";
            }
        }
        ImportInformationMissing importInformationMissing = null;
        if (this.importInformationMissingCollection != null) {
            importInformationMissing = this.importInformationMissingCollection.get(objectId);
        }
        try {
            IdSoggetto aspcSoggettoReferente = aspc.getSoggettoReferente();
            String versione = aspc.getVersione();
            boolean informazioniProfiloServiziPresenti = this.isInformazioniProfiloServiziPresenti(aspc, checkCorrelazioneAsincrona);
            String uriAccordoCooperazione = null;
            if (aspc.getServizioComposto() != null && aspc.getServizioComposto().getAccordoCooperazione() != null && !"".equals(aspc.getServizioComposto().getAccordoCooperazione().trim())) {
                uriAccordoCooperazione = aspc.getServizioComposto().getAccordoCooperazione();
            }
            if (aspcSoggettoReferente == null || aspcSoggettoReferente.getTipo() == null || aspcSoggettoReferente.getNome() == null || versione == null || !informazioniProfiloServiziPresenti || aspc.getServizioComposto() != null && uriAccordoCooperazione == null) {
                ImportInformationMissingException infoException = new ImportInformationMissingException(objectId, objectIdDescription);
                boolean throwException = false;
                if (aspcSoggettoReferente == null || aspcSoggettoReferente.getTipo() == null || aspcSoggettoReferente.getNome() == null) {
                    if (importInformationMissing != null && importInformationMissing.getSoggetto() != null) {
                        if (!this.registryReader.existsSoggetto(importInformationMissing.getSoggetto())) {
                            boolean found = false;
                            if (this.archive.getSoggetti() != null && this.archive.getSoggetti().size() > 0) {
                                for (int i = 0; i < this.archive.getSoggetti().size(); ++i) {
                                    ArchiveSoggetto archiveSoggetto = (ArchiveSoggetto)this.archive.getSoggetti().get(i);
                                    if (!archiveSoggetto.getIdSoggetto().equals((Object)importInformationMissing.getSoggetto())) continue;
                                    found = true;
                                    break;
                                }
                            }
                            if (!found) {
                                throw new ProtocolException("Il Soggetto " + importInformationMissing.getSoggetto().toString() + " non esiste (indicato in ImportInformationMissing parameter??)");
                            }
                        }
                        IdSoggetto aspcSoggettoReferenteNew = new IdSoggetto();
                        aspcSoggettoReferenteNew.setTipo(importInformationMissing.getSoggetto().getTipo());
                        aspcSoggettoReferenteNew.setNome(importInformationMissing.getSoggetto().getNome());
                        aspc.setSoggettoReferente(aspcSoggettoReferenteNew);
                    } else {
                        infoException.setMissingInfoSoggetto(true);
                        throwException = true;
                    }
                }
                if (versione == null) {
                    if (importInformationMissing != null && importInformationMissing.getVersione() != null) {
                        aspc.setVersione(importInformationMissing.getVersione() + "");
                    } else {
                        infoException.setMissingInfoVersione(true);
                        throwException = true;
                    }
                }
                if (!informazioniProfiloServiziPresenti) {
                    if (importInformationMissing != null && importInformationMissing.sizePortTypeList() > 0) {
                        for (int i = 0; i < importInformationMissing.sizePortTypeList(); ++i) {
                            aspc.addPortType(importInformationMissing.getPortType(i));
                        }
                    }
                    if (!(informazioniProfiloServiziPresenti = this.isInformazioniProfiloServiziPresenti(aspc, checkCorrelazioneAsincrona))) {
                        infoException.setMissingInfoProfiliServizi(true);
                        while (aspc.sizePortTypeList() > 0) {
                            aspc.removePortType(0);
                        }
                        infoException.setObject(aspc);
                        infoException.setClassObject(aspc.getClass());
                        throwException = true;
                    }
                }
                if (aspc.getServizioComposto() != null && uriAccordoCooperazione == null) {
                    if (importInformationMissing != null && importInformationMissing.getIdAccordoCooperazione() != null) {
                        aspc.getServizioComposto().setAccordoCooperazione(this.idAccordoCooperazioneFactory.getUriFromIDAccordo(importInformationMissing.getIdAccordoCooperazione()));
                    } else {
                        infoException.setMissingInfoAccordoCooperazione(true);
                        throwException = true;
                    }
                }
                if (throwException) {
                    throw infoException;
                }
            }
            if (this.validateDocuments) {
                ValidazioneResult result = this.validatoreDocumenti.validaInterfacciaWsdlParteComune(aspc);
                if (!result.isEsito()) {
                    if (result.getException() != null) {
                        throw new Exception(result.getMessaggioErrore(), result.getException());
                    }
                    throw new Exception(result.getMessaggioErrore());
                }
                result = this.validatoreDocumenti.validaSpecificaConversazione(aspc);
                if (!result.isEsito()) {
                    if (result.getException() != null) {
                        throw new Exception(result.getMessaggioErrore(), result.getException());
                    }
                    throw new Exception(result.getMessaggioErrore());
                }
                result = this.validatoreDocumenti.validaDocumenti(aspc);
                if (!result.isEsito()) {
                    if (result.getException() != null) {
                        throw new Exception(result.getMessaggioErrore(), result.getException());
                    }
                    throw new Exception(result.getMessaggioErrore());
                }
            }
        }
        catch (ImportInformationMissingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Exception(objectIdDescription + " validazione fallita: " + e.getMessage(), e);
        }
    }

    private boolean isInformazioniProfiloServiziPresenti(org.openspcoop2.core.registry.AccordoServizioParteComune aspc, boolean checkCorrelazioneAsincrona) {
        if (aspc == null) {
            return false;
        }
        if (aspc.getProfiloCollaborazione() == null && aspc.sizePortTypeList() <= 0) {
            return false;
        }
        if (aspc.sizePortTypeList() > 0) {
            for (int i = 0; i < aspc.sizePortTypeList(); ++i) {
                PortType pt = aspc.getPortType(i);
                if (pt == null) {
                    return false;
                }
                if ("default".equals(pt.getProfiloPT()) ? aspc.getProfiloCollaborazione() == null : pt.getProfiloCollaborazione() == null && aspc.getProfiloCollaborazione() == null) {
                    return false;
                }
                for (int j = 0; j < pt.sizeAzioneList(); ++j) {
                    Operation op = pt.getAzione(j);
                    if (!("default".equals(op.getProfAzione()) ? aspc.getProfiloCollaborazione() == null && pt.getProfiloCollaborazione() == null : op.getProfiloCollaborazione() == null && pt.getProfiloCollaborazione() == null && aspc.getProfiloCollaborazione() == null)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void validateAndFillAccordoServizioParteSpecifica(ArchiveAccordoServizioParteSpecifica archiveAsps) throws Exception {
        org.openspcoop2.core.registry.AccordoServizioParteSpecifica asps = archiveAsps.getAccordoServizioParteSpecifica();
        String uri = this.idAccordoFactory.getUriFromAccordo(asps);
        String objectId = "[[ASPS]]" + uri;
        String objectIdDescription = "Accordo di Servizio Parte Specifica [" + uri + "]";
        if (asps.getAccordoServizioParteComune() != null && !"".equals(asps.getAccordoServizioParteComune().trim())) {
            objectIdDescription = objectIdDescription + " (rifParteComune: " + asps.getAccordoServizioParteComune() + ")";
        }
        ImportInformationMissing importInformationMissing = null;
        if (this.importInformationMissingCollection != null) {
            importInformationMissing = this.importInformationMissingCollection.get(objectId);
        }
        try {
            org.openspcoop2.core.registry.AccordoServizioParteComune aspc;
            block36: {
                aspc = null;
                if (asps.getAccordoServizioParteComune() != null && !"".equals(asps.getAccordoServizioParteComune().trim())) {
                    try {
                        aspc = this.registryReader.getAccordoServizioParteComune(this.idAccordoFactory.getIDAccordoFromUri(asps.getAccordoServizioParteComune()));
                    }
                    catch (RegistryNotFound notFound) {
                        IDAccordo idAccordo;
                        ArchiveAccordoServizioParteComune archiveAccordo;
                        int i;
                        boolean found = false;
                        if (this.archive.getAccordiServizioParteComune() != null && this.archive.getAccordiServizioParteComune().size() > 0) {
                            for (i = 0; i < this.archive.getAccordiServizioParteComune().size(); ++i) {
                                archiveAccordo = (ArchiveAccordoServizioParteComune)this.archive.getAccordiServizioParteComune().get(i);
                                idAccordo = this.idAccordoFactory.getIDAccordoFromAccordo(archiveAccordo.getAccordoServizioParteComune());
                                if (!idAccordo.equals((Object)this.idAccordoFactory.getIDAccordoFromUri(asps.getAccordoServizioParteComune()))) continue;
                                found = true;
                                aspc = archiveAccordo.getAccordoServizioParteComune();
                                break;
                            }
                        }
                        if (!found && this.archive.getAccordiServizioComposto() != null && this.archive.getAccordiServizioComposto().size() > 0) {
                            for (i = 0; i < this.archive.getAccordiServizioComposto().size(); ++i) {
                                archiveAccordo = (ArchiveAccordoServizioParteComune)this.archive.getAccordiServizioComposto().get(i);
                                idAccordo = this.idAccordoFactory.getIDAccordoFromAccordo(archiveAccordo.getAccordoServizioParteComune());
                                if (!idAccordo.equals((Object)this.idAccordoFactory.getIDAccordoFromUri(asps.getAccordoServizioParteComune()))) continue;
                                found = true;
                                aspc = archiveAccordo.getAccordoServizioParteComune();
                                break;
                            }
                        }
                        if (found) break block36;
                        throw new ProtocolException("Accordo di Servizio Parte Comune [" + asps.getAccordoServizioParteComune() + "], riferito dall'archivio, non esiste");
                    }
                }
            }
            String tipoSoggettoErogatore = asps.getServizio().getTipoSoggettoErogatore();
            String nomeSoggettoErogatore = asps.getServizio().getNomeSoggettoErogatore();
            String versione = asps.getVersione();
            if (tipoSoggettoErogatore == null || nomeSoggettoErogatore == null || versione == null || aspc == null) {
                ImportInformationMissingException infoException = new ImportInformationMissingException(objectId, objectIdDescription);
                boolean throwException = false;
                if (tipoSoggettoErogatore == null || nomeSoggettoErogatore == null) {
                    if (importInformationMissing != null && importInformationMissing.getSoggetto() != null) {
                        if (!this.registryReader.existsSoggetto(importInformationMissing.getSoggetto())) {
                            boolean found = false;
                            if (this.archive.getSoggetti() != null && this.archive.getSoggetti().size() > 0) {
                                for (int i = 0; i < this.archive.getSoggetti().size(); ++i) {
                                    ArchiveSoggetto archiveSoggetto = (ArchiveSoggetto)this.archive.getSoggetti().get(i);
                                    if (!archiveSoggetto.getIdSoggetto().equals((Object)importInformationMissing.getSoggetto())) continue;
                                    found = true;
                                    break;
                                }
                            }
                            if (!found) {
                                throw new ProtocolException("Il Soggetto " + importInformationMissing.getSoggetto().toString() + " non esiste (indicato in ImportInformationMissing parameter??)");
                            }
                        }
                        asps.getServizio().setTipoSoggettoErogatore(importInformationMissing.getSoggetto().getTipo());
                        asps.getServizio().setNomeSoggettoErogatore(importInformationMissing.getSoggetto().getNome());
                    } else {
                        infoException.setMissingInfoSoggetto(true);
                        throwException = true;
                    }
                }
                if (versione == null) {
                    if (importInformationMissing != null && importInformationMissing.getVersione() != null) {
                        asps.setVersione(importInformationMissing.getVersione() + "");
                    } else {
                        infoException.setMissingInfoVersione(true);
                        throwException = true;
                    }
                }
                if (aspc == null) {
                    if (importInformationMissing != null && importInformationMissing.getIdAccordoServizioParteComune() != null) {
                        asps.setAccordoServizioParteComune(this.idAccordoFactory.getUriFromIDAccordo(importInformationMissing.getIdAccordoServizioParteComune()));
                    } else {
                        infoException.setMissingInfoAccordoServizioParteComune(true);
                        throwException = true;
                    }
                }
                if (throwException) {
                    throw infoException;
                }
            }
            if (aspc != null) {
                List<String> serviziIdentificatiNellaParteComune = this.letturaServiziDefinitiParteComune(asps, aspc);
                if (this.validateDocuments) {
                    ValidazioneResult result = this.validatoreDocumenti.validaInterfacciaWsdlParteSpecifica(asps, aspc);
                    if (!result.isEsito()) {
                        if (result.getException() != null) {
                            throw new Exception(result.getMessaggioErrore(), result.getException());
                        }
                        throw new Exception(result.getMessaggioErrore());
                    }
                    result = this.validatoreDocumenti.validaDocumenti(asps);
                    if (!result.isEsito()) {
                        if (result.getException() != null) {
                            throw new Exception(result.getMessaggioErrore(), result.getException());
                        }
                        throw new Exception(result.getMessaggioErrore());
                    }
                    this.verificaMappingPortTypeBindingInRiferimentoParteComune(asps, aspc, serviziIdentificatiNellaParteComune);
                }
                if (importInformationMissing != null && importInformationMissing.getPortTypeImplemented() != null) {
                    if (asps.getPortType() != null && asps.getPortType().equals(asps.getServizio().getNome())) {
                        asps.getServizio().setNome(importInformationMissing.getPortTypeImplemented());
                    }
                    asps.setPortType(importInformationMissing.getPortTypeImplemented());
                }
                if (asps.getPortType() != null && !serviziIdentificatiNellaParteComune.contains(asps.getPortType())) {
                    ImportInformationMissingException infoException = new ImportInformationMissingException(objectId, objectIdDescription);
                    infoException.setMismatchPortTypeRifServiziParteComune(true, asps.getPortType(), serviziIdentificatiNellaParteComune);
                    throw infoException;
                }
            }
        }
        catch (ImportInformationMissingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Exception(objectIdDescription + " validazione fallita: " + e.getMessage(), e);
        }
    }

    private List<String> letturaServiziDefinitiParteComune(Fruitore fruitore, org.openspcoop2.core.registry.AccordoServizioParteSpecifica asps, org.openspcoop2.core.registry.AccordoServizioParteComune aspc) {
        Boolean correlato = null;
        if (fruitore.getByteWsdlImplementativoErogatore() != null) {
            correlato = false;
        } else if (fruitore.getByteWsdlImplementativoFruitore() != null) {
            correlato = true;
        } else if (asps.getByteWsdlImplementativoErogatore() != null) {
            correlato = false;
        } else if (asps.getByteWsdlImplementativoFruitore() != null) {
            correlato = true;
        }
        if (correlato == null) {
            TipologiaServizio tipologiaServizio = TipologiaServizio.NORMALE;
            if (asps.getServizio() != null) {
                tipologiaServizio = asps.getServizio().getTipologiaServizio();
            }
            correlato = TipologiaServizio.CORRELATO.equals(tipologiaServizio);
        }
        return this.letturaServiziDefinitiParteComune(correlato, aspc);
    }

    private List<String> letturaServiziDefinitiParteComune(org.openspcoop2.core.registry.AccordoServizioParteSpecifica asps, org.openspcoop2.core.registry.AccordoServizioParteComune aspc) {
        Boolean correlato = null;
        if (asps.getByteWsdlImplementativoErogatore() != null) {
            correlato = false;
        } else if (asps.getByteWsdlImplementativoFruitore() != null) {
            correlato = true;
        }
        if (correlato == null) {
            TipologiaServizio tipologiaServizio = TipologiaServizio.NORMALE;
            if (asps.getServizio() != null) {
                tipologiaServizio = asps.getServizio().getTipologiaServizio();
            }
            correlato = TipologiaServizio.CORRELATO.equals(tipologiaServizio);
        }
        return this.letturaServiziDefinitiParteComune(correlato, aspc);
    }

    private List<String> letturaServiziDefinitiParteComune(boolean correlato, org.openspcoop2.core.registry.AccordoServizioParteComune aspc) {
        ArrayList<String> serviziIdentificatiNellaParteComune = new ArrayList<String>();
        for (int i = 0; i < aspc.sizePortTypeList(); ++i) {
            PortType pt = aspc.getPortType(i);
            boolean servizioCorrelato = false;
            for (int j = 0; j < pt.sizeAzioneList(); ++j) {
                Operation op = pt.getAzione(j);
                if (op.getCorrelataServizio() == null || pt.getNome().equals(op.getCorrelataServizio()) || op.getCorrelata() == null) continue;
                servizioCorrelato = true;
                break;
            }
            if (correlato) {
                if (!servizioCorrelato) continue;
                serviziIdentificatiNellaParteComune.add(aspc.getPortType(i).getNome());
                continue;
            }
            if (servizioCorrelato) continue;
            serviziIdentificatiNellaParteComune.add(aspc.getPortType(i).getNome());
        }
        return serviziIdentificatiNellaParteComune;
    }

    private void verificaMappingPortTypeBindingInRiferimentoParteComune(Fruitore fruitore, org.openspcoop2.core.registry.AccordoServizioParteSpecifica asps, org.openspcoop2.core.registry.AccordoServizioParteComune aspc, List<String> serviziIdentificatiNellaParteComune) throws Exception {
        byte[] wsdlImplementativo = null;
        String tipoWSDL = "WSDL Implementativo";
        if (fruitore.getByteWsdlImplementativoErogatore() != null) {
            wsdlImplementativo = asps.getByteWsdlImplementativoErogatore();
            tipoWSDL = "WSDL Implementativo Erogatore";
        } else if (fruitore.getByteWsdlImplementativoFruitore() != null) {
            wsdlImplementativo = asps.getByteWsdlImplementativoFruitore();
            tipoWSDL = "WSDL Implementativo Fruitore";
        } else if (asps.getByteWsdlImplementativoErogatore() != null) {
            wsdlImplementativo = asps.getByteWsdlImplementativoErogatore();
            tipoWSDL = "WSDL Implementativo Erogatore";
        } else if (asps.getByteWsdlImplementativoFruitore() != null) {
            wsdlImplementativo = asps.getByteWsdlImplementativoFruitore();
            tipoWSDL = "WSDL Implementativo Fruitore";
        }
        if (wsdlImplementativo != null) {
            this.verificaMappingPortTypeBindingInRiferimentoParteComune(wsdlImplementativo, tipoWSDL, aspc, serviziIdentificatiNellaParteComune);
        }
    }

    private void verificaMappingPortTypeBindingInRiferimentoParteComune(org.openspcoop2.core.registry.AccordoServizioParteSpecifica asps, org.openspcoop2.core.registry.AccordoServizioParteComune aspc, List<String> serviziIdentificatiNellaParteComune) throws Exception {
        byte[] wsdlImplementativo = null;
        String tipoWSDL = "WSDL Implementativo";
        if (asps.getByteWsdlImplementativoErogatore() != null) {
            wsdlImplementativo = asps.getByteWsdlImplementativoErogatore();
            tipoWSDL = "WSDL Implementativo Erogatore";
        } else if (asps.getByteWsdlImplementativoFruitore() != null) {
            wsdlImplementativo = asps.getByteWsdlImplementativoFruitore();
            tipoWSDL = "WSDL Implementativo Fruitore";
        }
        if (wsdlImplementativo != null) {
            this.verificaMappingPortTypeBindingInRiferimentoParteComune(wsdlImplementativo, tipoWSDL, aspc, serviziIdentificatiNellaParteComune);
        }
    }

    private void verificaMappingPortTypeBindingInRiferimentoParteComune(byte[] wsdlImplementativo, String tipoWSDL, org.openspcoop2.core.registry.AccordoServizioParteComune aspc, List<String> serviziIdentificatiNellaParteComune) throws Exception {
        ArrayList<String> portTypesImplemented = new ArrayList<String>();
        try {
            Document d = this.xmlUtils.newDocument(wsdlImplementativo);
            DefinitionWrapper wsdl = new DefinitionWrapper(d, this.xmlUtils, false, false);
            Hashtable mapBindingToPortTypeImplemented = wsdl.getMapPortTypesImplementedBinding();
            Enumeration bindings = mapBindingToPortTypeImplemented.keys();
            while (bindings.hasMoreElements()) {
                QName binding = (QName)bindings.nextElement();
                QName portType = (QName)mapBindingToPortTypeImplemented.get(binding);
                String portTypeName = portType.getLocalPart();
                if (portTypesImplemented.contains(portTypeName)) continue;
                portTypesImplemented.add(portTypeName);
            }
        }
        catch (Exception e) {
            String msgErrore = "La verifica dei port-types, implementati dai binding del " + tipoWSDL + ", rispetto ai servizi definiti nell'accordo di servizio parte comune, ha riscontrato un errore: " + e.getMessage();
            this.protocolFactory.getLogger().error((Object)msgErrore, (Throwable)e);
            throw new Exception(msgErrore, e);
        }
        for (String pt : portTypesImplemented) {
            boolean trovato = false;
            for (String servizioOpenSPCoop : serviziIdentificatiNellaParteComune) {
                if (!pt.equals(servizioOpenSPCoop)) continue;
                trovato = true;
                break;
            }
            if (trovato) continue;
            throw new Exception("Il PortType " + pt + " implementato nei binding presenti nel " + tipoWSDL + " non \u00e8 uno dei servizi definiti nell'accordo di servizio parte comune");
        }
    }

    public void validateAndFillFruitore(ArchiveFruitore archiveFruitore) throws Exception {
        Fruitore fruitore = archiveFruitore.getFruitore();
        IDAccordo asps = archiveFruitore.getIdAccordoServizioParteSpecifica();
        String uri = fruitore.getTipo() + "/" + fruitore.getNome() + "_" + this.idAccordoFactory.getUriFromIDAccordo(asps);
        String objectId = "[[Fruitore]]" + uri;
        String objectIdDescription = "Fruitore [" + fruitore.getTipo() + "/" + fruitore.getNome() + "] dell'Accordo di Servizio Parte Specifica [" + this.idAccordoFactory.getUriFromIDAccordo(asps) + "]";
        ImportInformationMissing importInformationMissing = null;
        if (this.importInformationMissingCollection != null) {
            importInformationMissing = this.importInformationMissingCollection.get(objectId);
        }
        try {
            org.openspcoop2.core.registry.AccordoServizioParteComune aspc;
            org.openspcoop2.core.registry.AccordoServizioParteSpecifica accordoAsps;
            block32: {
                block31: {
                    int i;
                    boolean found;
                    String tipoSoggettoErogatore = null;
                    String nomeSoggettoErogatore = null;
                    if (asps.getSoggettoReferente() != null) {
                        tipoSoggettoErogatore = asps.getSoggettoReferente().getTipo();
                        nomeSoggettoErogatore = asps.getSoggettoReferente().getNome();
                    }
                    String versione = asps.getVersione();
                    if (tipoSoggettoErogatore == null || nomeSoggettoErogatore == null || versione == null) {
                        ImportInformationMissingException infoException = new ImportInformationMissingException(objectId, objectIdDescription);
                        boolean throwException = false;
                        if (tipoSoggettoErogatore == null || nomeSoggettoErogatore == null) {
                            if (importInformationMissing != null && importInformationMissing.getSoggetto() != null) {
                                if (!this.registryReader.existsSoggetto(importInformationMissing.getSoggetto())) {
                                    found = false;
                                    if (this.archive.getSoggetti() != null && this.archive.getSoggetti().size() > 0) {
                                        for (i = 0; i < this.archive.getSoggetti().size(); ++i) {
                                            ArchiveSoggetto archiveSoggetto = (ArchiveSoggetto)this.archive.getSoggetti().get(i);
                                            if (!archiveSoggetto.getIdSoggetto().equals((Object)importInformationMissing.getSoggetto())) continue;
                                            found = true;
                                            break;
                                        }
                                    }
                                    if (!found) {
                                        throw new ProtocolException("Il Soggetto " + importInformationMissing.getSoggetto().toString() + " non esiste (indicato in ImportInformationMissing parameter??)");
                                    }
                                }
                                if (asps.getSoggettoReferente() == null) {
                                    asps.setSoggettoReferente(importInformationMissing.getSoggetto());
                                }
                            } else {
                                infoException.setMissingInfoSoggetto(true);
                                throwException = true;
                            }
                        }
                        if (versione == null) {
                            if (importInformationMissing != null && importInformationMissing.getVersione() != null) {
                                asps.setVersione(importInformationMissing.getVersione() + "");
                            } else {
                                infoException.setMissingInfoVersione(true);
                                throwException = true;
                            }
                        }
                        if (throwException) {
                            throw infoException;
                        }
                    }
                    accordoAsps = null;
                    try {
                        accordoAsps = this.registryReader.getAccordoServizioParteSpecifica(asps);
                    }
                    catch (RegistryNotFound notFound) {
                        found = false;
                        if (this.archive.getAccordiServizioParteSpecifica() != null && this.archive.getAccordiServizioParteSpecifica().size() > 0) {
                            for (i = 0; i < this.archive.getAccordiServizioParteSpecifica().size(); ++i) {
                                ArchiveAccordoServizioParteSpecifica archiveAccordo = (ArchiveAccordoServizioParteSpecifica)this.archive.getAccordiServizioParteSpecifica().get(i);
                                IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromAccordo(archiveAccordo.getAccordoServizioParteSpecifica());
                                if (!idAccordo.equals((Object)asps)) continue;
                                found = true;
                                accordoAsps = archiveAccordo.getAccordoServizioParteSpecifica();
                                break;
                            }
                        }
                        if (found) break block31;
                        throw new ProtocolException("Accordo di Servizio Parte Specifica [" + asps + "], riferito dall'archivio fruitore, non esiste");
                    }
                }
                aspc = null;
                try {
                    aspc = this.registryReader.getAccordoServizioParteComune(this.idAccordoFactory.getIDAccordoFromUri(accordoAsps.getAccordoServizioParteComune()));
                }
                catch (RegistryNotFound notFound) {
                    IDAccordo idAccordo;
                    ArchiveAccordoServizioParteComune archiveAccordo;
                    boolean found = false;
                    if (this.archive.getAccordiServizioParteComune() != null && this.archive.getAccordiServizioParteComune().size() > 0) {
                        for (int i = 0; i < this.archive.getAccordiServizioParteComune().size(); ++i) {
                            archiveAccordo = (ArchiveAccordoServizioParteComune)this.archive.getAccordiServizioParteComune().get(i);
                            idAccordo = this.idAccordoFactory.getIDAccordoFromAccordo(archiveAccordo.getAccordoServizioParteComune());
                            if (!idAccordo.equals((Object)this.idAccordoFactory.getIDAccordoFromUri(accordoAsps.getAccordoServizioParteComune()))) continue;
                            found = true;
                            aspc = archiveAccordo.getAccordoServizioParteComune();
                            break;
                        }
                    }
                    if (!found && this.archive.getAccordiServizioComposto() != null && this.archive.getAccordiServizioComposto().size() > 0) {
                        for (int i = 0; i < this.archive.getAccordiServizioComposto().size(); ++i) {
                            archiveAccordo = (ArchiveAccordoServizioParteComune)this.archive.getAccordiServizioComposto().get(i);
                            idAccordo = this.idAccordoFactory.getIDAccordoFromAccordo(archiveAccordo.getAccordoServizioParteComune());
                            if (!idAccordo.equals((Object)this.idAccordoFactory.getIDAccordoFromUri(accordoAsps.getAccordoServizioParteComune()))) continue;
                            found = true;
                            aspc = archiveAccordo.getAccordoServizioParteComune();
                            break;
                        }
                    }
                    if (found) break block32;
                    throw new ProtocolException("Accordo di Servizio Parte Comune [" + accordoAsps.getAccordoServizioParteComune() + "], riferito dall'accordo parte specifica dell'archivio fruitore, non esiste");
                }
            }
            List<String> serviziIdentificatiNellaParteComune = this.letturaServiziDefinitiParteComune(fruitore, accordoAsps, aspc);
            if (this.validateDocuments) {
                ValidazioneResult result = this.validatoreDocumenti.validaInterfacciaWsdlParteSpecifica(fruitore, accordoAsps, aspc);
                if (!result.isEsito()) {
                    if (result.getException() != null) {
                        throw new Exception(result.getMessaggioErrore(), result.getException());
                    }
                    throw new Exception(result.getMessaggioErrore());
                }
                this.verificaMappingPortTypeBindingInRiferimentoParteComune(fruitore, accordoAsps, aspc, serviziIdentificatiNellaParteComune);
            }
        }
        catch (ImportInformationMissingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Exception(objectIdDescription + " validazione fallita: " + e.getMessage(), e);
        }
    }
}

