/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.archive;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.FiltroRicercaPorteApplicative;
import org.openspcoop2.core.config.driver.FiltroRicercaPorteDelegate;
import org.openspcoop2.core.config.driver.FiltroRicercaServiziApplicativi;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDAccordoCooperazioneWithSoggetto;
import org.openspcoop2.core.id.IDPortaApplicativaByNome;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteComuneServizioCompostoServizioComponente;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.IdSoggetto;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicerca;
import org.openspcoop2.core.registry.driver.FiltroRicercaAccordi;
import org.openspcoop2.core.registry.driver.FiltroRicercaServizi;
import org.openspcoop2.core.registry.driver.FiltroRicercaSoggetti;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.archive.AbstractArchiveEngine;
import org.openspcoop2.protocol.engine.archive.ArchiveRegistryReader;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.Archive;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoCooperazione;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioComposto;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteComune;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteSpecifica;
import org.openspcoop2.protocol.sdk.archive.ArchiveCascadeConfiguration;
import org.openspcoop2.protocol.sdk.archive.ArchiveFruitore;
import org.openspcoop2.protocol.sdk.archive.ArchiveMode;
import org.openspcoop2.protocol.sdk.archive.ArchivePdd;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaApplicativa;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaDelegata;
import org.openspcoop2.protocol.sdk.archive.ArchiveServizioApplicativo;
import org.openspcoop2.protocol.sdk.archive.ArchiveSoggetto;
import org.openspcoop2.protocol.sdk.archive.IArchive;
import org.openspcoop2.protocol.sdk.archive.IRegistryReader;
import org.openspcoop2.protocol.sdk.constants.ArchiveType;

public class ExporterArchiveUtils {
    private AbstractArchiveEngine archiveEngine;
    private Logger log;
    private ProtocolFactoryManager protocolFactoryManager;

    public ExporterArchiveUtils(AbstractArchiveEngine archiveEngine, Logger log) throws Exception {
        this.archiveEngine = archiveEngine;
        this.log = log;
        this.protocolFactoryManager = ProtocolFactoryManager.getInstance();
    }

    public void export(String protocol, Archive archive, OutputStream out, ArchiveMode mode) throws Exception {
        IProtocolFactory protocolFactory = this.protocolFactoryManager.getProtocolFactoryByName(protocol);
        IArchive archiveEngine = protocolFactory.createArchive();
        ArchiveRegistryReader archiveRegistryReader = new ArchiveRegistryReader(this.archiveEngine.getDriverRegistroServizi());
        archiveEngine.exportArchive(archive, out, mode, (IRegistryReader)archiveRegistryReader);
    }

    public byte[] export(String protocol, Archive archive, ArchiveMode mode) throws Exception {
        IProtocolFactory protocolFactory = this.protocolFactoryManager.getProtocolFactoryByName(protocol);
        IArchive archiveEngine = protocolFactory.createArchive();
        ArchiveRegistryReader archiveRegistryReader = new ArchiveRegistryReader(this.archiveEngine.getDriverRegistroServizi());
        return archiveEngine.exportArchive(archive, mode, (IRegistryReader)archiveRegistryReader);
    }

    public void fillArchive(Archive archive, ArchiveType exportSourceArchiveType, List<?> listObject, ArchiveCascadeConfiguration cascadeConfig) throws Exception {
        switch (exportSourceArchiveType) {
            case PDD: {
                for (Object object : listObject) {
                    this.readPdd(archive, (String)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case SOGGETTO: {
                for (Object object : listObject) {
                    this.readSoggetto(archive, (IDSoggetto)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case SERVIZIO_APPLICATIVO: {
                for (Object object : listObject) {
                    this.readServizioApplicativo(archive, (IDServizioApplicativo)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case PORTA_DELEGATA: {
                for (Object object : listObject) {
                    this.readPortaDelegata(archive, (IDPortaDelegata)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case PORTA_APPLICATIVA: {
                for (Object object : listObject) {
                    this.readPortaApplicativa(archive, (IDPortaApplicativaByNome)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case ACCORDO_COOPERAZIONE: {
                for (Object object : listObject) {
                    this.readAccordoCooperazione(archive, (IDAccordoCooperazioneWithSoggetto)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case ACCORDO_SERVIZIO_PARTE_COMUNE: {
                for (Object object : listObject) {
                    this.readAccordoServizioParteComune(archive, (IDAccordo)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case ACCORDO_SERVIZIO_COMPOSTO: {
                for (Object object : listObject) {
                    this.readAccordoServizioComposto(archive, (IDAccordo)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case ACCORDO_SERVIZIO_PARTE_SPECIFICA: {
                for (Object object : listObject) {
                    this.readAccordoServizioParteSpecifica(archive, (IDAccordo)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case CONFIGURAZIONE: {
                archive.setConfigurazionePdD(this.archiveEngine.getConfigurazione());
                break;
            }
            case ALL: 
            case ALL_WITHOUT_CONFIGURAZIONE: {
                FiltroRicercaSoggetti filtroSoggetti = new FiltroRicercaSoggetti();
                try {
                    ArchiveCascadeConfiguration cascadeAll = new ArchiveCascadeConfiguration(true);
                    List<IDSoggetto> idsSoggetti = this.archiveEngine.getAllIdSoggettiRegistro(filtroSoggetti);
                    if (idsSoggetti != null && idsSoggetti.size() > 0) {
                        for (IDSoggetto idSoggetto : idsSoggetti) {
                            this.readSoggetto(archive, idSoggetto, cascadeAll, exportSourceArchiveType);
                        }
                    }
                }
                catch (DriverConfigurazioneNotFound notFound) {
                    // empty catch block
                }
                if (!exportSourceArchiveType.equals((Object)ArchiveType.ALL)) break;
                archive.setConfigurazionePdD(this.archiveEngine.getConfigurazione());
                break;
            }
        }
    }

    private void readPdd(Archive archive, String nomePdd, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readPdd(archive, nomePdd, cascadeConfig, true, provenienza);
    }

    private void readPdd(Archive archive, String nomePdd, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        String key = ArchivePdd.buildKey((String)nomePdd);
        if (!archive.getPdd().containsKey(key)) {
            try {
                if (cascadeConfig.isCascadePdd() || ArchiveType.PDD.equals((Object)provenienza)) {
                    PortaDominio pdd = this.archiveEngine.getPortaDominio(nomePdd);
                    ArchivePdd archivePdd = new ArchivePdd(pdd);
                    archive.getPdd().add((Object)archivePdd);
                }
            }
            catch (Exception e) {
                throw new ProtocolException("(PdD " + nomePdd + ") " + e.getMessage(), (Throwable)e);
            }
        }
        if (cascadeAvanti) {
            FiltroRicercaSoggetti filtroSoggetti = new FiltroRicercaSoggetti();
            filtroSoggetti.setNomePdd(nomePdd);
            try {
                List<IDSoggetto> idsSoggetti = this.archiveEngine.getAllIdSoggettiRegistro(filtroSoggetti);
                if (idsSoggetti != null && idsSoggetti.size() > 0) {
                    for (IDSoggetto idSoggetto : idsSoggetti) {
                        this.readSoggetto(archive, idSoggetto, cascadeConfig, ArchiveType.PDD);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound notFound) {
                // empty catch block
            }
        }
    }

    private void readSoggetto(Archive archive, IDSoggetto idSoggetto, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readSoggetto(archive, idSoggetto, cascadeConfig, true, provenienza);
    }

    private void readSoggetto(Archive archive, IDSoggetto idSoggetto, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        block36: {
            String key = ArchiveSoggetto.buildKey((String)idSoggetto.getTipo(), (String)idSoggetto.getNome());
            if (!archive.getSoggetti().containsKey(key)) {
                try {
                    if (!cascadeConfig.isCascadeSoggetti() && !ArchiveType.SOGGETTO.equals((Object)provenienza)) break block36;
                    Soggetto soggettoRegistro = this.archiveEngine.getSoggettoRegistro(idSoggetto);
                    org.openspcoop2.core.config.Soggetto soggettoConfigurazione = this.archiveEngine.getSoggettoConfigurazione(idSoggetto);
                    ArchiveSoggetto archiveSoggetto = new ArchiveSoggetto(soggettoConfigurazione, soggettoRegistro);
                    archive.getSoggetti().add((Object)archiveSoggetto);
                    FiltroRicerca filtroPdd = new FiltroRicerca();
                    filtroPdd.setNome(soggettoRegistro.getPortaDominio());
                    try {
                        List<String> idsPdD = this.archiveEngine.getAllIdPorteDominio(filtroPdd);
                        if (idsPdD != null && idsPdD.size() > 0) {
                            for (String idPdd : idsPdD) {
                                this.readPdd(archive, idPdd, cascadeConfig, false, ArchiveType.SOGGETTO);
                            }
                        }
                    }
                    catch (DriverRegistroServiziNotFound notFound) {
                    }
                }
                catch (Exception e) {
                    throw new ProtocolException("(Soggetto " + idSoggetto + ") " + e.getMessage(), (Throwable)e);
                }
            }
        }
        if (cascadeAvanti) {
            FiltroRicercaServiziApplicativi filtroServiziApplicativi = new FiltroRicercaServiziApplicativi();
            filtroServiziApplicativi.setTipoSoggetto(idSoggetto.getTipo());
            filtroServiziApplicativi.setNomeSoggetto(idSoggetto.getNome());
            try {
                List<IDServizioApplicativo> idsSA = this.archiveEngine.getAllIdServiziApplicativi(filtroServiziApplicativi);
                if (idsSA != null && idsSA.size() > 0) {
                    for (IDServizioApplicativo idServizioApplicativo : idsSA) {
                        this.readServizioApplicativo(archive, idServizioApplicativo, cascadeConfig, ArchiveType.SOGGETTO);
                    }
                }
            }
            catch (DriverConfigurazioneNotFound notFound) {
                // empty catch block
            }
            FiltroRicercaAccordi filtroAccordiCooperazione = new FiltroRicercaAccordi();
            filtroAccordiCooperazione.setTipoSoggettoReferente(idSoggetto.getTipo());
            filtroAccordiCooperazione.setNomeSoggettoReferente(idSoggetto.getNome());
            try {
                List<IDAccordoCooperazione> idsAC = this.archiveEngine.getAllIdAccordiCooperazione(filtroAccordiCooperazione);
                if (idsAC != null && idsAC.size() > 0) {
                    for (IDAccordoCooperazione idAccordoCooperazione : idsAC) {
                        IDAccordoCooperazioneWithSoggetto idAccordoCooperazioneWithSoggetto = new IDAccordoCooperazioneWithSoggetto(idAccordoCooperazione);
                        idAccordoCooperazioneWithSoggetto.setSoggettoReferente(idSoggetto);
                        this.readAccordoCooperazione(archive, idAccordoCooperazioneWithSoggetto, cascadeConfig, ArchiveType.SOGGETTO);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound notFound) {
                // empty catch block
            }
            FiltroRicercaAccordi filtroAccordiServizioParteComune = new FiltroRicercaAccordi();
            filtroAccordiServizioParteComune.setTipoSoggettoReferente(idSoggetto.getTipo());
            filtroAccordiServizioParteComune.setNomeSoggettoReferente(idSoggetto.getNome());
            filtroAccordiServizioParteComune.setServizioComposto(Boolean.valueOf(false));
            try {
                List<IDAccordo> idsAccordi = this.archiveEngine.getAllIdAccordiServizioParteComune(filtroAccordiServizioParteComune);
                if (idsAccordi != null && idsAccordi.size() > 0) {
                    for (IDAccordo idAccordo : idsAccordi) {
                        this.readAccordoServizioParteComune(archive, idAccordo, cascadeConfig, ArchiveType.SOGGETTO);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound notFound) {
                // empty catch block
            }
            FiltroRicercaAccordi filtroAccordiServizioComposto = new FiltroRicercaAccordi();
            filtroAccordiServizioComposto.setTipoSoggettoReferente(idSoggetto.getTipo());
            filtroAccordiServizioComposto.setNomeSoggettoReferente(idSoggetto.getNome());
            filtroAccordiServizioComposto.setServizioComposto(Boolean.valueOf(true));
            try {
                List<IDAccordo> idsAccordi = this.archiveEngine.getAllIdAccordiServizioParteComune(filtroAccordiServizioComposto);
                if (idsAccordi != null && idsAccordi.size() > 0) {
                    for (IDAccordo idAccordo : idsAccordi) {
                        this.readAccordoServizioComposto(archive, idAccordo, cascadeConfig, ArchiveType.SOGGETTO);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound notFound) {
                // empty catch block
            }
            FiltroRicercaServizi filtroAccordiServizioParteSpecifica = new FiltroRicercaServizi();
            filtroAccordiServizioParteSpecifica.setTipoSoggettoErogatore(idSoggetto.getTipo());
            filtroAccordiServizioParteSpecifica.setNomeSoggettoErogatore(idSoggetto.getNome());
            try {
                List<IDAccordo> idsAccordi = this.archiveEngine.getAllIdAccordiServizioParteSpecifica(filtroAccordiServizioParteSpecifica);
                if (idsAccordi != null && idsAccordi.size() > 0) {
                    for (IDAccordo idAccordo : idsAccordi) {
                        this.readAccordoServizioParteSpecifica(archive, idAccordo, cascadeConfig, ArchiveType.SOGGETTO);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound notFound) {
                // empty catch block
            }
            FiltroRicercaPorteDelegate filtroPorteDelegate = new FiltroRicercaPorteDelegate();
            filtroPorteDelegate.setTipoSoggetto(idSoggetto.getTipo());
            filtroPorteDelegate.setNomeSoggetto(idSoggetto.getNome());
            try {
                List<IDPortaDelegata> idsPD = this.archiveEngine.getAllIdPorteDelegate(filtroPorteDelegate);
                if (idsPD != null && idsPD.size() > 0) {
                    for (IDPortaDelegata idPortaDelegata : idsPD) {
                        this.readPortaDelegata(archive, idPortaDelegata, cascadeConfig, ArchiveType.SOGGETTO);
                    }
                }
            }
            catch (DriverConfigurazioneNotFound notFound) {
                // empty catch block
            }
            FiltroRicercaPorteApplicative filtroPorteApplicative = new FiltroRicercaPorteApplicative();
            filtroPorteApplicative.setTipoSoggetto(idSoggetto.getTipo());
            filtroPorteApplicative.setNomeSoggetto(idSoggetto.getNome());
            try {
                List<IDPortaApplicativaByNome> idsPA = this.archiveEngine.getAllIdPorteApplicative(filtroPorteApplicative);
                if (idsPA != null && idsPA.size() > 0) {
                    for (IDPortaApplicativaByNome idPortaApplicativa : idsPA) {
                        this.readPortaApplicativa(archive, idPortaApplicativa, cascadeConfig, ArchiveType.SOGGETTO);
                    }
                }
            }
            catch (DriverConfigurazioneNotFound notFound) {
                // empty catch block
            }
        }
    }

    private void readServizioApplicativo(Archive archive, IDServizioApplicativo idServizioApplicativo, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readServizioApplicativo(archive, idServizioApplicativo, cascadeConfig, true, provenienza);
    }

    private void readServizioApplicativo(Archive archive, IDServizioApplicativo idServizioApplicativo, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        String key = ArchiveServizioApplicativo.buildKey((String)idServizioApplicativo.getIdSoggettoProprietario().getTipo(), (String)idServizioApplicativo.getIdSoggettoProprietario().getNome(), (String)idServizioApplicativo.getNome());
        if (!archive.getServiziApplicativi().containsKey(key)) {
            try {
                boolean enabled = cascadeConfig.isCascadeServiziApplicativi();
                switch (provenienza) {
                    case SOGGETTO: {
                        break;
                    }
                    case SERVIZIO_APPLICATIVO: {
                        enabled = enabled || ArchiveType.SERVIZIO_APPLICATIVO.equals((Object)provenienza);
                        break;
                    }
                    case PORTA_DELEGATA: {
                        enabled = enabled && cascadeConfig.isCascadePorteDelegate();
                        break;
                    }
                    case PORTA_APPLICATIVA: {
                        enabled = enabled && cascadeConfig.isCascadePorteApplicative();
                        break;
                    }
                    case FRUITORE: {
                        enabled = enabled && cascadeConfig.isCascadeFruizioni();
                        break;
                    }
                }
                if (enabled) {
                    ServizioApplicativo sa = this.archiveEngine.getServizioApplicativo(idServizioApplicativo);
                    if (sa.getTipoSoggettoProprietario() == null) {
                        sa.setTipoSoggettoProprietario(idServizioApplicativo.getIdSoggettoProprietario().getTipo());
                    }
                    if (sa.getNomeSoggettoProprietario() == null) {
                        sa.setNomeSoggettoProprietario(idServizioApplicativo.getIdSoggettoProprietario().getNome());
                    }
                    ArchiveServizioApplicativo archiveSa = new ArchiveServizioApplicativo(sa);
                    archive.getServiziApplicativi().add((Object)archiveSa);
                    this.readSoggetto(archive, idServizioApplicativo.getIdSoggettoProprietario(), cascadeConfig, false, ArchiveType.SERVIZIO_APPLICATIVO);
                }
            }
            catch (Exception e) {
                throw new ProtocolException("(ServizioApplicativo " + idServizioApplicativo + ") " + e.getMessage(), (Throwable)e);
            }
        }
        if (cascadeAvanti) {
            // empty if block
        }
    }

    private void readAccordoCooperazione(Archive archive, IDAccordoCooperazioneWithSoggetto idAccordoCooperazione, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readAccordoCooperazione(archive, idAccordoCooperazione, cascadeConfig, true, provenienza);
    }

    private void readAccordoCooperazione(Archive archive, IDAccordoCooperazioneWithSoggetto idAccordoCooperazione, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        String tipoSoggetto = null;
        String nomeSoggetto = null;
        if (idAccordoCooperazione.getSoggettoReferente() != null) {
            tipoSoggetto = idAccordoCooperazione.getSoggettoReferente().getTipo();
            nomeSoggetto = idAccordoCooperazione.getSoggettoReferente().getNome();
        }
        String key = ArchiveAccordoCooperazione.buildKey((String)tipoSoggetto, nomeSoggetto, (String)idAccordoCooperazione.getNome(), (String)idAccordoCooperazione.getVersione());
        if (!archive.getAccordiCooperazione().containsKey(key)) {
            try {
                if (cascadeConfig.isCascadeAccordoCooperazione() || ArchiveType.ACCORDO_COOPERAZIONE.equals((Object)provenienza)) {
                    AccordoCooperazione ac = this.archiveEngine.getAccordoCooperazione((IDAccordoCooperazione)idAccordoCooperazione, true);
                    ArchiveAccordoCooperazione archiveAc = new ArchiveAccordoCooperazione(ac);
                    archive.getAccordiCooperazione().add((Object)archiveAc);
                    this.readSoggetto(archive, idAccordoCooperazione.getSoggettoReferente(), cascadeConfig, false, ArchiveType.ACCORDO_COOPERAZIONE);
                    if (ac.getElencoPartecipanti() != null && ac.getElencoPartecipanti().sizeSoggettoPartecipanteList() > 0) {
                        for (IdSoggetto partecipante : ac.getElencoPartecipanti().getSoggettoPartecipanteList()) {
                            IDSoggetto idPartecipante = new IDSoggetto(partecipante.getTipo(), partecipante.getNome());
                            this.readSoggetto(archive, idPartecipante, cascadeConfig, false, ArchiveType.ACCORDO_COOPERAZIONE);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new ProtocolException("(AccordoCooperazione " + IDAccordoCooperazioneFactory.getInstance().getUriFromIDAccordo((IDAccordoCooperazione)idAccordoCooperazione) + ") " + e.getMessage(), (Throwable)e);
            }
        }
        if (cascadeAvanti) {
            FiltroRicercaAccordi filtroRicercaAccordi = new FiltroRicercaAccordi();
            filtroRicercaAccordi.setIdAccordoCooperazione((IDAccordoCooperazione)idAccordoCooperazione);
            try {
                List<IDAccordo> idsAS = this.archiveEngine.getAllIdAccordiServizioParteComune(filtroRicercaAccordi);
                if (idsAS != null && idsAS.size() > 0) {
                    for (IDAccordo idAccordo : idsAS) {
                        this.readAccordoServizioComposto(archive, idAccordo, cascadeConfig, ArchiveType.ACCORDO_COOPERAZIONE);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound notFound) {
                // empty catch block
            }
        }
    }

    private void readAccordoServizioParteComune(Archive archive, IDAccordo idAccordoServizio, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readAccordoServizioParteComune(archive, idAccordoServizio, cascadeConfig, true, provenienza);
    }

    private void readAccordoServizioParteComune(Archive archive, IDAccordo idAccordoServizio, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        String tipoSoggetto = null;
        String nomeSoggetto = null;
        if (idAccordoServizio.getSoggettoReferente() != null) {
            tipoSoggetto = idAccordoServizio.getSoggettoReferente().getTipo();
            nomeSoggetto = idAccordoServizio.getSoggettoReferente().getNome();
        }
        String key = ArchiveAccordoServizioParteComune.buildKey((String)tipoSoggetto, nomeSoggetto, (String)idAccordoServizio.getNome(), (String)idAccordoServizio.getVersione());
        if (!archive.getAccordiServizioParteComune().containsKey(key)) {
            try {
                if (cascadeConfig.isCascadeAccordoServizioParteComune() || ArchiveType.ACCORDO_SERVIZIO_PARTE_COMUNE.equals((Object)provenienza)) {
                    AccordoServizioParteComune as = this.archiveEngine.getAccordoServizioParteComune(idAccordoServizio, true);
                    ArchiveAccordoServizioParteComune archiveAs = new ArchiveAccordoServizioParteComune(as);
                    archive.getAccordiServizioParteComune().add((Object)archiveAs);
                    this.readSoggetto(archive, idAccordoServizio.getSoggettoReferente(), cascadeConfig, false, ArchiveType.ACCORDO_SERVIZIO_PARTE_COMUNE);
                }
            }
            catch (Exception e) {
                throw new ProtocolException("(AccordoServizioParteComune " + IDAccordoFactory.getInstance().getUriFromIDAccordo(idAccordoServizio) + ") " + e.getMessage(), (Throwable)e);
            }
        }
        if (cascadeAvanti) {
            FiltroRicercaServizi filtroRicercaAccordi = new FiltroRicercaServizi();
            filtroRicercaAccordi.setIdAccordo(idAccordoServizio);
            try {
                List<IDAccordo> idsAS = this.archiveEngine.getAllIdAccordiServizioParteSpecifica(filtroRicercaAccordi);
                if (idsAS != null && idsAS.size() > 0) {
                    for (IDAccordo idAccordo : idsAS) {
                        this.readAccordoServizioParteSpecifica(archive, idAccordo, cascadeConfig, ArchiveType.ACCORDO_SERVIZIO_PARTE_COMUNE);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound notFound) {
                // empty catch block
            }
        }
    }

    private void readAccordoServizioComposto(Archive archive, IDAccordo idAccordoServizio, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readAccordoServizioComposto(archive, idAccordoServizio, cascadeConfig, true, provenienza);
    }

    private void readAccordoServizioComposto(Archive archive, IDAccordo idAccordoServizio, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        String tipoSoggetto = null;
        String nomeSoggetto = null;
        if (idAccordoServizio.getSoggettoReferente() != null) {
            tipoSoggetto = idAccordoServizio.getSoggettoReferente().getTipo();
            nomeSoggetto = idAccordoServizio.getSoggettoReferente().getNome();
        }
        String key = ArchiveAccordoServizioComposto.buildKey((String)tipoSoggetto, nomeSoggetto, (String)idAccordoServizio.getNome(), (String)idAccordoServizio.getVersione());
        AccordoServizioParteComune as = null;
        if (archive.getAccordiServizioComposto().containsKey(key)) {
            as = ((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(key)).getAccordoServizioParteComune();
        } else {
            try {
                if (cascadeConfig.isCascadeAccordoServizioComposto() || ArchiveType.ACCORDO_SERVIZIO_COMPOSTO.equals((Object)provenienza)) {
                    as = this.archiveEngine.getAccordoServizioParteComune(idAccordoServizio, true);
                    ArchiveAccordoServizioComposto archiveAs = new ArchiveAccordoServizioComposto(as);
                    archive.getAccordiServizioComposto().add((Object)archiveAs);
                    this.readSoggetto(archive, idAccordoServizio.getSoggettoReferente(), cascadeConfig, false, ArchiveType.ACCORDO_SERVIZIO_COMPOSTO);
                } else {
                    as = this.archiveEngine.getAccordoServizioParteComune(idAccordoServizio, false);
                }
            }
            catch (Exception e) {
                throw new ProtocolException("(AccordoServizioComposto " + IDAccordoFactory.getInstance().getUriFromIDAccordo(idAccordoServizio) + ") " + e.getMessage(), (Throwable)e);
            }
        }
        if (cascadeAvanti) {
            FiltroRicercaServizi filtroRicercaAccordi = new FiltroRicercaServizi();
            filtroRicercaAccordi.setIdAccordo(idAccordoServizio);
            try {
                List<IDAccordo> idsAS = this.archiveEngine.getAllIdAccordiServizioParteSpecifica(filtroRicercaAccordi);
                if (idsAS != null && idsAS.size() > 0) {
                    for (IDAccordo idAccordo : idsAS) {
                        this.readAccordoServizioParteSpecifica(archive, idAccordo, cascadeConfig, ArchiveType.ACCORDO_SERVIZIO_COMPOSTO);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound notFound) {
                // empty catch block
            }
            for (AccordoServizioParteComuneServizioCompostoServizioComponente servizioComponente : as.getServizioComposto().getServizioComponenteList()) {
                IDServizio idServizio = new IDServizio(servizioComponente.getTipoSoggetto(), servizioComponente.getNomeSoggetto(), servizioComponente.getTipo(), servizioComponente.getNome());
                this.readAccordoServizioParteSpecifica(archive, idServizio, cascadeConfig, ArchiveType.ACCORDO_SERVIZIO_COMPOSTO);
            }
        }
    }

    private void readAccordoServizioParteSpecifica(Archive archive, IDAccordo idAccordoServizio, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readAccordoServizioParteSpecifica(archive, idAccordoServizio, cascadeConfig, true, provenienza);
    }

    private void readAccordoServizioParteSpecifica(Archive archive, IDAccordo idAccordoServizio, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        String tipoSoggetto = null;
        String nomeSoggetto = null;
        if (idAccordoServizio.getSoggettoReferente() != null) {
            tipoSoggetto = idAccordoServizio.getSoggettoReferente().getTipo();
            nomeSoggetto = idAccordoServizio.getSoggettoReferente().getNome();
        }
        String key = ArchiveAccordoServizioParteSpecifica.buildKey((String)tipoSoggetto, nomeSoggetto, (String)idAccordoServizio.getNome(), (String)idAccordoServizio.getVersione());
        ArrayList<Fruitore> fruitoriList = null;
        AccordoServizioParteSpecifica as = null;
        if (archive.getAccordiServizioParteSpecifica().containsKey(key)) {
            as = ((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(key)).getAccordoServizioParteSpecifica();
        } else {
            try {
                if (cascadeConfig.isCascadeAccordoServizioParteSpecifica() || ArchiveType.ACCORDO_SERVIZIO_PARTE_SPECIFICA.equals((Object)provenienza)) {
                    fruitoriList = new ArrayList<Fruitore>();
                    as = this.archiveEngine.getAccordoServizioParteSpecifica(idAccordoServizio, true);
                    if (as.getServizio().getTipoSoggettoErogatore() == null) {
                        as.getServizio().setTipoSoggettoErogatore(tipoSoggetto);
                    }
                    if (as.getServizio().getNomeSoggettoErogatore() == null) {
                        as.getServizio().setNomeSoggettoErogatore(nomeSoggetto);
                    }
                    ArchiveAccordoServizioParteSpecifica archiveAs = new ArchiveAccordoServizioParteSpecifica(as);
                    while (as.sizeFruitoreList() > 0) {
                        fruitoriList.add(as.removeFruitore(0));
                    }
                    archive.getAccordiServizioParteSpecifica().add((Object)archiveAs);
                    this.readSoggetto(archive, idAccordoServizio.getSoggettoReferente(), cascadeConfig, false, ArchiveType.ACCORDO_SERVIZIO_PARTE_SPECIFICA);
                    IDAccordo idAccordoServizioParteComune = IDAccordoFactory.getInstance().getIDAccordoFromUri(as.getAccordoServizioParteComune());
                    AccordoServizioParteComune aspc = this.archiveEngine.getAccordoServizioParteComune(idAccordoServizioParteComune);
                    if (aspc.getServizioComposto() == null) {
                        this.readAccordoServizioParteComune(archive, idAccordoServizioParteComune, cascadeConfig, false, ArchiveType.ACCORDO_SERVIZIO_PARTE_SPECIFICA);
                    } else {
                        this.readAccordoServizioComposto(archive, idAccordoServizioParteComune, cascadeConfig, false, ArchiveType.ACCORDO_SERVIZIO_PARTE_SPECIFICA);
                    }
                }
            }
            catch (Exception e) {
                throw new ProtocolException("(AccordoServizioParteSpecifica " + IDAccordoFactory.getInstance().getUriFromIDAccordo(idAccordoServizio) + ") " + e.getMessage(), (Throwable)e);
            }
        }
        if (cascadeAvanti) {
            List<IDPortaApplicativaByNome> idsPA;
            if (fruitoriList == null) {
                fruitoriList = new ArrayList();
                as = this.archiveEngine.getAccordoServizioParteSpecifica(idAccordoServizio, true);
                while (as.sizeFruitoreList() > 0) {
                    fruitoriList.add(as.removeFruitore(0));
                }
            }
            for (Fruitore fruitore : fruitoriList) {
                IDSoggetto idFruitore = new IDSoggetto(fruitore.getTipo(), fruitore.getNome());
                this.readFruitore(archive, idAccordoServizio, idFruitore, fruitore, cascadeConfig, ArchiveType.ACCORDO_SERVIZIO_PARTE_SPECIFICA);
            }
            FiltroRicercaPorteDelegate filtroRicercaPorteDelegate = new FiltroRicercaPorteDelegate();
            filtroRicercaPorteDelegate.setTipoSoggettoErogatore(idAccordoServizio.getSoggettoReferente().getTipo());
            filtroRicercaPorteDelegate.setNomeSoggettoErogatore(idAccordoServizio.getSoggettoReferente().getNome());
            filtroRicercaPorteDelegate.setTipoServizio(as.getServizio().getTipo());
            filtroRicercaPorteDelegate.setNomeServizio(as.getServizio().getNome());
            try {
                List<IDPortaDelegata> idsPD = this.archiveEngine.getAllIdPorteDelegate(filtroRicercaPorteDelegate);
                if (idsPD != null && idsPD.size() > 0) {
                    for (IDPortaDelegata idPortaDelegata : idsPD) {
                        this.readPortaDelegata(archive, idPortaDelegata, cascadeConfig, ArchiveType.ACCORDO_SERVIZIO_PARTE_SPECIFICA);
                    }
                }
            }
            catch (DriverConfigurazioneNotFound notFound) {
                // empty catch block
            }
            FiltroRicercaPorteApplicative filtroRicercaPorteApplicative = new FiltroRicercaPorteApplicative();
            filtroRicercaPorteApplicative.setTipoSoggetto(idAccordoServizio.getSoggettoReferente().getTipo());
            filtroRicercaPorteApplicative.setNomeSoggetto(idAccordoServizio.getSoggettoReferente().getNome());
            filtroRicercaPorteApplicative.setTipoServizio(as.getServizio().getTipo());
            filtroRicercaPorteApplicative.setNomeServizio(as.getServizio().getNome());
            try {
                idsPA = this.archiveEngine.getAllIdPorteApplicative(filtroRicercaPorteApplicative);
                if (idsPA != null && idsPA.size() > 0) {
                    for (IDPortaApplicativaByNome idPortaApplicativa : idsPA) {
                        this.readPortaApplicativa(archive, idPortaApplicativa, cascadeConfig, ArchiveType.ACCORDO_SERVIZIO_PARTE_SPECIFICA);
                    }
                }
            }
            catch (DriverConfigurazioneNotFound notFound) {
                // empty catch block
            }
            filtroRicercaPorteApplicative = new FiltroRicercaPorteApplicative();
            filtroRicercaPorteApplicative.setTipoSoggettoVirtuale(idAccordoServizio.getSoggettoReferente().getTipo());
            filtroRicercaPorteApplicative.setNomeSoggettoVirtuale(idAccordoServizio.getSoggettoReferente().getNome());
            filtroRicercaPorteApplicative.setTipoServizio(as.getServizio().getTipo());
            filtroRicercaPorteApplicative.setNomeServizio(as.getServizio().getNome());
            try {
                idsPA = this.archiveEngine.getAllIdPorteApplicative(filtroRicercaPorteApplicative);
                if (idsPA != null && idsPA.size() > 0) {
                    for (IDPortaApplicativaByNome idPortaApplicativa : idsPA) {
                        this.readPortaApplicativa(archive, idPortaApplicativa, cascadeConfig, ArchiveType.ACCORDO_SERVIZIO_PARTE_SPECIFICA);
                    }
                }
            }
            catch (DriverConfigurazioneNotFound notFound) {
                // empty catch block
            }
        }
    }

    private void readAccordoServizioParteSpecifica(Archive archive, IDServizio idServizio, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readAccordoServizioParteSpecifica(archive, idServizio, cascadeConfig, true, provenienza);
    }

    private void readAccordoServizioParteSpecifica(Archive archive, IDServizio idServizio, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        AccordoServizioParteSpecifica as = this.archiveEngine.getAccordoServizioParteSpecifica(idServizio, false);
        IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromAccordo(as);
        this.readAccordoServizioParteSpecifica(archive, idAccordo, cascadeConfig, cascadeAvanti, provenienza);
    }

    private void readFruitore(Archive archive, IDAccordo idAccordoServizio, IDSoggetto idFruitore, Fruitore fruitore, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readFruitore(archive, idAccordoServizio, idFruitore, fruitore, cascadeConfig, true, provenienza);
    }

    private void readFruitore(Archive archive, IDAccordo idAccordoServizio, IDSoggetto idFruitore, Fruitore fruitore, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        String tipoSoggetto = null;
        String nomeSoggetto = null;
        if (idAccordoServizio.getSoggettoReferente() != null) {
            tipoSoggetto = idAccordoServizio.getSoggettoReferente().getTipo();
            nomeSoggetto = idAccordoServizio.getSoggettoReferente().getNome();
        }
        String key = ArchiveFruitore.buildKey((String)idFruitore.getTipo(), (String)idFruitore.getNome(), (String)tipoSoggetto, (String)nomeSoggetto, (String)idAccordoServizio.getNome(), (String)idAccordoServizio.getVersione());
        if (!archive.getAccordiFruitori().containsKey(key)) {
            try {
                if (cascadeConfig.isCascadeFruizioni() || ArchiveType.FRUITORE.equals((Object)provenienza)) {
                    if (fruitore == null) {
                        AccordoServizioParteSpecifica as = this.archiveEngine.getAccordoServizioParteSpecifica(idAccordoServizio, true);
                        for (Fruitore fruitoreCheck : as.getFruitoreList()) {
                            if (!fruitoreCheck.getTipo().equals(idFruitore.getTipo()) || !fruitoreCheck.getNome().equals(idFruitore.getNome())) continue;
                            fruitore = fruitoreCheck;
                            break;
                        }
                    }
                    ArchiveFruitore archiveFruitore = new ArchiveFruitore(idAccordoServizio, fruitore);
                    archive.getAccordiFruitori().add((Object)archiveFruitore);
                    this.readSoggetto(archive, idFruitore, cascadeConfig, false, ArchiveType.FRUITORE);
                    this.readAccordoServizioParteSpecifica(archive, idAccordoServizio, cascadeConfig, false, ArchiveType.FRUITORE);
                }
            }
            catch (Exception e) {
                throw new ProtocolException("(Fruitore " + idFruitore + " dell'accordo " + IDAccordoFactory.getInstance().getUriFromIDAccordo(idAccordoServizio) + ") " + e.getMessage(), (Throwable)e);
            }
        }
        if (cascadeAvanti) {
            try {
                List idSA = this.archiveEngine.getDriverRegistroServizi().getAllIdServiziApplicativiAutorizzati(idAccordoServizio, idFruitore);
                if (idSA != null && idSA.size() > 0) {
                    for (IDServizioApplicativo idServizioApplicativo : idSA) {
                        this.readServizioApplicativo(archive, idServizioApplicativo, cascadeConfig, ArchiveType.FRUITORE);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound notFound) {
                // empty catch block
            }
        }
    }

    private void readPortaDelegata(Archive archive, IDPortaDelegata idPortaDelegata, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readPortaDelegata(archive, idPortaDelegata, cascadeConfig, true, provenienza);
    }

    private void readPortaDelegata(Archive archive, IDPortaDelegata idPortaDelegata, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        String key = ArchivePortaDelegata.buildKey((String)idPortaDelegata.getSoggettoFruitore().getTipo(), (String)idPortaDelegata.getSoggettoFruitore().getNome(), (String)idPortaDelegata.getLocationPD());
        PortaDelegata pd = null;
        if (archive.getPorteDelegate().containsKey(key)) {
            pd = ((ArchivePortaDelegata)archive.getPorteDelegate().get(key)).getPortaDelegata();
        } else {
            try {
                pd = this.archiveEngine.getPortaDelegata(idPortaDelegata);
                if (cascadeConfig.isCascadePorteDelegate() || ArchiveType.PORTA_DELEGATA.equals((Object)provenienza)) {
                    if (pd.getTipoSoggettoProprietario() == null) {
                        pd.setTipoSoggettoProprietario(idPortaDelegata.getSoggettoFruitore().getTipo());
                    }
                    if (pd.getNomeSoggettoProprietario() == null) {
                        pd.setNomeSoggettoProprietario(idPortaDelegata.getSoggettoFruitore().getNome());
                    }
                    ArchivePortaDelegata archivePd = new ArchivePortaDelegata(pd);
                    archive.getPorteDelegate().add((Object)archivePd);
                    this.readSoggetto(archive, idPortaDelegata.getSoggettoFruitore(), cascadeConfig, false, ArchiveType.PORTA_DELEGATA);
                    if (!(pd.getSoggettoErogatore() == null || pd.getSoggettoErogatore().getTipo() == null || "".equals(pd.getSoggettoErogatore().getTipo()) || pd.getSoggettoErogatore().getNome() == null || "".equals(pd.getSoggettoErogatore().getNome()) || pd.getServizio() == null || pd.getServizio().getTipo() == null || "".equals(pd.getServizio().getTipo()) || pd.getServizio().getNome() == null || "".equals(pd.getServizio().getNome()))) {
                        IDServizio idServizio = new IDServizio(pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome(), pd.getServizio().getTipo(), pd.getServizio().getNome());
                        this.readAccordoServizioParteSpecifica(archive, idServizio, cascadeConfig, false, ArchiveType.PORTA_DELEGATA);
                    }
                }
            }
            catch (Exception e) {
                throw new ProtocolException("(PortaDelegata " + idPortaDelegata + ") " + e.getMessage(), (Throwable)e);
            }
        }
        if (cascadeAvanti && pd.sizeServizioApplicativoList() > 0) {
            for (ServizioApplicativo sa : pd.getServizioApplicativoList()) {
                IDServizioApplicativo idSA = new IDServizioApplicativo();
                idSA.setIdSoggettoProprietario(idPortaDelegata.getSoggettoFruitore());
                idSA.setNome(sa.getNome());
                this.readServizioApplicativo(archive, idSA, cascadeConfig, ArchiveType.PORTA_DELEGATA);
            }
        }
    }

    private void readPortaApplicativa(Archive archive, IDPortaApplicativaByNome idPortaApplicativa, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readPortaApplicativa(archive, idPortaApplicativa, cascadeConfig, true, provenienza);
    }

    private void readPortaApplicativa(Archive archive, IDPortaApplicativaByNome idPortaApplicativa, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        String key = ArchivePortaApplicativa.buildKey((String)idPortaApplicativa.getSoggetto().getTipo(), (String)idPortaApplicativa.getSoggetto().getNome(), (String)idPortaApplicativa.getNome());
        PortaApplicativa pa = null;
        if (archive.getPorteApplicative().containsKey(key)) {
            pa = ((ArchivePortaApplicativa)archive.getPorteApplicative().get(key)).getPortaApplicativa();
        } else {
            try {
                pa = this.archiveEngine.getPortaApplicativa(idPortaApplicativa);
                if (cascadeConfig.isCascadePorteApplicative() || ArchiveType.PORTA_APPLICATIVA.equals((Object)provenienza)) {
                    if (pa.getTipoSoggettoProprietario() == null) {
                        pa.setTipoSoggettoProprietario(idPortaApplicativa.getSoggetto().getTipo());
                    }
                    if (pa.getNomeSoggettoProprietario() == null) {
                        pa.setNomeSoggettoProprietario(idPortaApplicativa.getSoggetto().getNome());
                    }
                    ArchivePortaApplicativa archivePa = new ArchivePortaApplicativa(pa);
                    archive.getPorteApplicative().add((Object)archivePa);
                    this.readSoggetto(archive, idPortaApplicativa.getSoggetto(), cascadeConfig, false, ArchiveType.PORTA_APPLICATIVA);
                    if (pa.getSoggettoVirtuale() != null && pa.getSoggettoVirtuale().getTipo() != null && !"".equals(pa.getSoggettoVirtuale().getTipo()) && pa.getSoggettoVirtuale().getNome() != null && !"".equals(pa.getSoggettoVirtuale().getNome())) {
                        IDSoggetto idSoggetto = new IDSoggetto(pa.getSoggettoVirtuale().getTipo(), pa.getSoggettoVirtuale().getNome());
                        this.readSoggetto(archive, idSoggetto, cascadeConfig, false, ArchiveType.PORTA_APPLICATIVA);
                    }
                    if (pa.getServizio() != null && pa.getServizio().getTipo() != null && !"".equals(pa.getServizio().getTipo()) && pa.getServizio().getNome() != null && !"".equals(pa.getServizio().getNome())) {
                        IDServizio idServizio;
                        if (pa.getSoggettoVirtuale() != null && pa.getSoggettoVirtuale().getTipo() != null && !"".equals(pa.getSoggettoVirtuale().getTipo()) && pa.getSoggettoVirtuale().getNome() != null && !"".equals(pa.getSoggettoVirtuale().getNome())) {
                            idServizio = new IDServizio(pa.getSoggettoVirtuale().getTipo(), pa.getSoggettoVirtuale().getNome(), pa.getServizio().getTipo(), pa.getServizio().getNome());
                            this.readAccordoServizioParteSpecifica(archive, idServizio, cascadeConfig, false, ArchiveType.PORTA_APPLICATIVA);
                        } else {
                            idServizio = new IDServizio(idPortaApplicativa.getSoggetto(), pa.getServizio().getTipo(), pa.getServizio().getNome());
                            this.readAccordoServizioParteSpecifica(archive, idServizio, cascadeConfig, false, ArchiveType.PORTA_APPLICATIVA);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new ProtocolException("(PortaApplicativa " + idPortaApplicativa + ") " + e.getMessage(), (Throwable)e);
            }
        }
        if (cascadeAvanti && pa.sizeServizioApplicativoList() > 0) {
            for (ServizioApplicativo sa : pa.getServizioApplicativoList()) {
                IDServizioApplicativo idSA = new IDServizioApplicativo();
                idSA.setIdSoggettoProprietario(idPortaApplicativa.getSoggetto());
                idSA.setNome(sa.getNome());
                this.readServizioApplicativo(archive, idSA, cascadeConfig, ArchiveType.PORTA_APPLICATIVA);
            }
        }
    }
}

