/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.archive;

import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.archive.ImportInformationMissingCollection;
import org.openspcoop2.protocol.engine.archive.ImportInformationMissingException;
import org.openspcoop2.protocol.engine.archive.ImporterInformationMissingSetter;
import org.openspcoop2.protocol.engine.archive.ImporterInformationMissingUtils;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.archive.Archive;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoCooperazione;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioComposto;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteComune;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteSpecifica;
import org.openspcoop2.protocol.sdk.archive.ArchiveFruitore;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaApplicativa;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaDelegata;
import org.openspcoop2.protocol.sdk.archive.ArchiveServizioApplicativo;
import org.openspcoop2.protocol.sdk.archive.IRegistryReader;

public class ArchiveValidator {
    private IRegistryReader registryReader;

    public ArchiveValidator(IRegistryReader registryReader) {
        this.registryReader = registryReader;
    }

    public void validateArchive(Archive archive, String protocolloEffettivo, boolean validazioneDocumenti, ImportInformationMissingCollection importInformationMissingCollection, String userLogin, boolean checkCorrelazioneAsincrona) throws Exception, ImportInformationMissingException {
        try {
            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocolloEffettivo);
            this.validateAndFillImportInformationMissing(archive, protocolFactory, importInformationMissingCollection, validazioneDocumenti, userLogin, checkCorrelazioneAsincrona);
        }
        catch (ImportInformationMissingException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    private void validateAndFillImportInformationMissing(Archive archive, IProtocolFactory protocolFactory, ImportInformationMissingCollection importInformationMissingCollection, boolean validazioneDocumenti, String userLogin, boolean checkCorrelazioneAsincrona) throws Exception, ImportInformationMissingException {
        int i;
        ImporterInformationMissingUtils importerInformationMissingUtils = new ImporterInformationMissingUtils(importInformationMissingCollection, this.registryReader, validazioneDocumenti, protocolFactory, userLogin, archive);
        if (archive.getInformationMissing() != null) {
            importerInformationMissingUtils.validateAndFillInformationMissing(archive.getInformationMissing());
        }
        for (i = 0; i < archive.getServiziApplicativi().size(); ++i) {
            importerInformationMissingUtils.validateAndFillServizioApplicativo((ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i));
        }
        for (i = 0; i < archive.getPorteDelegate().size(); ++i) {
            importerInformationMissingUtils.validateAndFillPortaDelegata((ArchivePortaDelegata)archive.getPorteDelegate().get(i));
        }
        for (i = 0; i < archive.getPorteApplicative().size(); ++i) {
            importerInformationMissingUtils.validateAndFillPortaApplicativa((ArchivePortaApplicativa)archive.getPorteApplicative().get(i));
        }
        for (i = 0; i < archive.getAccordiCooperazione().size(); ++i) {
            importerInformationMissingUtils.validateAndFillAccordoCooperazione((ArchiveAccordoCooperazione)archive.getAccordiCooperazione().get(i));
        }
        for (i = 0; i < archive.getAccordiServizioParteComune().size(); ++i) {
            importerInformationMissingUtils.validateAndFillAccordoServizioParteComune((ArchiveAccordoServizioParteComune)archive.getAccordiServizioParteComune().get(i), checkCorrelazioneAsincrona);
        }
        for (i = 0; i < archive.getAccordiServizioParteSpecifica().size(); ++i) {
            importerInformationMissingUtils.validateAndFillAccordoServizioParteSpecifica((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i));
        }
        for (i = 0; i < archive.getAccordiServizioComposto().size(); ++i) {
            importerInformationMissingUtils.validateAndFillAccordoServizioParteComune((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i), checkCorrelazioneAsincrona);
        }
        for (i = 0; i < archive.getAccordiFruitori().size(); ++i) {
            importerInformationMissingUtils.validateAndFillFruitore((ArchiveFruitore)archive.getAccordiFruitori().get(i));
        }
        ImporterInformationMissingSetter.replaceTemplatesNames(archive);
    }
}

