/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.openspcoop2.generic_project.exception.ServiceException;

public class LoaderProperties {
    protected Properties properties = null;
    protected String filePropertiesName = null;

    public LoaderProperties(String filePropertiesName) throws ServiceException {
        InputStream is = null;
        try {
            this.filePropertiesName = filePropertiesName;
            File f = new File(filePropertiesName);
            if (f.exists()) {
                is = new FileInputStream(f);
            } else {
                is = LoaderProperties.class.getResourceAsStream(filePropertiesName);
                if (is == null) {
                    is = LoaderProperties.class.getResourceAsStream("/" + filePropertiesName);
                }
            }
            if (is == null) {
                throw new Exception("InputStream is null");
            }
            this.properties = new Properties();
            this.properties.load(is);
        }
        catch (Exception e) {
            throw new ServiceException("Loading properties file [" + filePropertiesName + "] failed: " + e.getMessage(), e);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {}
        }
    }

    public LoaderProperties(Properties properties) throws ServiceException {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

