/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.utils;

import org.openspcoop2.generic_project.beans.ComplexField;
import org.openspcoop2.generic_project.beans.IField;

public class IDGenerator {
    private static long serialNumber = 0L;
    private static long sequence = 0L;

    public static synchronized String getUniqueID() {
        if (serialNumber + 1L > Long.MAX_VALUE) {
            serialNumber = 0L;
        }
        return "T" + System.currentTimeMillis() + "_" + "S" + ++serialNumber;
    }

    public static synchronized long getUniqueSequenceValue() {
        if (sequence + 1L > Long.MAX_VALUE) {
            sequence = 0L;
        }
        return ++sequence;
    }

    public static String getUniqueID(IField field) {
        ComplexField cf;
        if (field instanceof ComplexField && (cf = (ComplexField)field).getFather() != null) {
            return IDGenerator.normalize(cf.getFather().getFieldName() + "_" + field.getFieldName() + "_" + IDGenerator.getUniqueID());
        }
        return IDGenerator.normalize(field.getClassName() + "_" + field.getFieldName() + "_" + IDGenerator.getUniqueID());
    }

    private static String normalize(String value) {
        return value.replaceAll("-", "_");
    }
}

