/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.utils.DatabaseInstanceProperties;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.utils.TipiDatabase;

public class DatabaseProperties {
    private static DatabaseProperties databaseProperties = null;
    private DatabaseInstanceProperties reader;
    private static final String PROP_TIPO_DATABASE = "db.tipoDatabase";
    private static final String PROP_SHOW_SQL = "db.showSql";
    private static final String PROP_GENERATE_DDL = "db.generateDDL";
    private static final String PROP_AUTO_COMMIT = "db.autoCommit";
    private static final String PROP_TIPO = "db.tipo";
    private static final String PROP_TIPO_VALUE_DATASOURCE = "datasource";
    private static final String PROP_TIPO_VALUE_CONNECTION = "connection";
    private static final String PROP_DATASOURCE_JNDI_NAME = "db.datasource.jndiName";
    private static final String PROP_DATASOURCE_JNDI_CONTEXT = "db.datasource.jndiContext";
    private static final String PROP_CONNECTION_URL = "db.connection.url";
    private static final String PROP_CONNECTION_DRIVER = "db.connection.driver";
    private static final String PROP_CONNECTION_AUTH_USER = "db.connection.user";
    private static final String PROP_CONNECTION_AUTH_PASSWORD = "db.connection.password";

    public static synchronized void initialize(String PROPERTIES_LOCAL_PATH, String PROPERTIES_NAME, String nomeFileProperties, Logger log) throws ServiceException {
        if (databaseProperties == null) {
            databaseProperties = new DatabaseProperties(PROPERTIES_LOCAL_PATH, PROPERTIES_NAME, nomeFileProperties, log);
        }
    }

    public static DatabaseProperties getInstance(Logger log) throws ServiceException {
        if (databaseProperties == null) {
            throw new ServiceException("DatabaseProperties not initialized, use initialize method");
        }
        return databaseProperties;
    }

    public DatabaseProperties(String PROPERTIES_LOCAL_PATH, String PROPERTIES_NAME, String nomeFileProperties, Logger log) throws ServiceException {
        Properties propertiesReader = new Properties();
        InputStream properties = null;
        try {
            properties = DatabaseProperties.class.getResourceAsStream("/" + nomeFileProperties);
            if (properties == null) {
                throw new ServiceException("Properties " + nomeFileProperties + " not found");
            }
            propertiesReader.load(properties);
            properties.close();
        }
        catch (IOException e) {
            log.error((Object)("Riscontrato errore durante la lettura del file '" + nomeFileProperties + "': " + e.getMessage()), (Throwable)e);
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new ServiceException(e.getMessage(), e);
        }
        try {
            this.reader = new DatabaseInstanceProperties(PROPERTIES_LOCAL_PATH, PROPERTIES_NAME, propertiesReader, log);
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    private String getProperty(String name, boolean required, boolean convertEnvProperty) throws Exception {
        String tmp = null;
        tmp = convertEnvProperty ? this.reader.getValue_convertEnvProperties(name) : this.reader.getValue(name);
        if (tmp == null && required) {
            throw new Exception("Property [" + name + "] not found");
        }
        if (tmp != null) {
            return tmp.trim();
        }
        return null;
    }

    public String getTipoDatabase() throws Exception {
        return this.getProperty(PROP_TIPO_DATABASE, true, false);
    }

    public TipiDatabase getTipoDatabaseEnum() throws Exception {
        return TipiDatabase.toEnumConstant((String)this.getTipoDatabase());
    }

    public boolean isShowSql() throws Exception {
        return Boolean.parseBoolean(this.getProperty(PROP_SHOW_SQL, true, false));
    }

    public boolean isGenerateDDL() throws Exception {
        return Boolean.parseBoolean(this.getProperty(PROP_GENERATE_DDL, true, false));
    }

    public boolean isAutoCommit() throws Exception {
        return Boolean.parseBoolean(this.getProperty(PROP_AUTO_COMMIT, true, false));
    }

    public ServiceManagerProperties getServiceManagerProperties() throws Exception {
        ServiceManagerProperties sm = new ServiceManagerProperties();
        sm.setDatabaseType(this.getTipoDatabase());
        sm.setShowSql(this.isShowSql());
        sm.setGenerateDdl(this.isGenerateDDL());
        sm.setAutomaticTransactionManagement(this.isAutoCommit());
        return sm;
    }

    private String getTipoAccessoDatabase() throws Exception {
        String v = this.getProperty(PROP_TIPO, true, true);
        if (!PROP_TIPO_VALUE_DATASOURCE.equals(v) && !PROP_TIPO_VALUE_CONNECTION.equals(v)) {
            throw new Exception("Tipo di accesso al database fornito [" + v + "] non valido (supportati " + PROP_TIPO_VALUE_DATASOURCE + "," + PROP_TIPO_VALUE_CONNECTION + ")");
        }
        return v;
    }

    public boolean isTipoAccessoTramiteDatasource() throws Exception {
        return PROP_TIPO_VALUE_DATASOURCE.equals(this.getTipoAccessoDatabase());
    }

    public boolean isTipoAccessoTramiteConnection() throws Exception {
        return PROP_TIPO_VALUE_CONNECTION.equals(this.getTipoAccessoDatabase());
    }

    public String getDatasourceJNDIName() throws Exception {
        return this.getProperty(PROP_DATASOURCE_JNDI_NAME, PROP_TIPO_VALUE_DATASOURCE.equals(this.getTipoAccessoDatabase()), true);
    }

    public Properties getDatasourceJNDIContext() throws Exception {
        return this.reader.readProperties_convertEnvProperties(PROP_DATASOURCE_JNDI_CONTEXT);
    }

    public String getConnectionUrl() throws Exception {
        return this.getProperty(PROP_CONNECTION_URL, PROP_TIPO_VALUE_CONNECTION.equals(this.getTipoAccessoDatabase()), true);
    }

    public String getConnectionDriverJDBC() throws Exception {
        return this.getProperty(PROP_CONNECTION_DRIVER, PROP_TIPO_VALUE_CONNECTION.equals(this.getTipoAccessoDatabase()), true);
    }

    public String getConnectionAuthUsername() throws Exception {
        return this.getProperty(PROP_CONNECTION_AUTH_USER, false, true);
    }

    public String getConnectionAuthPassword() throws Exception {
        return this.getProperty(PROP_CONNECTION_AUTH_PASSWORD, false, true);
    }
}

