/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.expression.impl.sql;

import org.openspcoop2.generic_project.beans.AliasField;
import org.openspcoop2.generic_project.beans.ConstantField;
import org.openspcoop2.generic_project.beans.CustomField;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;

public abstract class AbstractSQLFieldConverter
implements ISQLFieldConverter {
    @Override
    public String toColumn(IField field, boolean returnAlias, boolean appendTablePrefix) throws ExpressionException {
        if (field instanceof CustomField) {
            CustomField cf = (CustomField)field;
            if (appendTablePrefix) {
                String table = this.toAliasTable(field);
                if (table != null && !"".equals(table)) {
                    if (returnAlias) {
                        return table + "." + cf.getAliasColumnName();
                    }
                    return table + "." + cf.getColumnName();
                }
                if (returnAlias) {
                    return cf.getAliasColumnName();
                }
                return cf.getColumnName();
            }
            if (returnAlias) {
                return cf.getAliasColumnName();
            }
            return cf.getColumnName();
        }
        if (field instanceof ConstantField) {
            ConstantField cf = (ConstantField)field;
            if (returnAlias) {
                return cf.getAlias();
            }
            return cf.getConstantValue(this.getDatabaseType());
        }
        if (field instanceof AliasField) {
            AliasField af = (AliasField)field;
            if (returnAlias) {
                return af.getAlias();
            }
            return this.toColumn(af.getField(), returnAlias, appendTablePrefix);
        }
        throw new ExpressionException("Field [" + field.toString() + "] not supported by converter.toColumn: " + this.getClass().getName());
    }

    @Override
    public String toColumn(IField field, boolean appendTablePrefix) throws ExpressionException {
        return this.toColumn(field, false, appendTablePrefix);
    }

    @Override
    public String toAliasColumn(IField field, boolean appendTablePrefix) throws ExpressionException {
        return this.toColumn(field, true, appendTablePrefix);
    }

    @Override
    public String toTable(IField field, boolean returnAlias) throws ExpressionException {
        if (field instanceof CustomField) {
            CustomField cf = (CustomField)field;
            if (returnAlias) {
                return cf.getAliasTableName();
            }
            return cf.getTableName();
        }
        if (field instanceof ConstantField) {
            return this.toTable(this.getRootModel(), returnAlias);
        }
        if (field instanceof AliasField) {
            AliasField af = (AliasField)field;
            return this.toTable(af.getField(), returnAlias);
        }
        throw new ExpressionException("Field [" + field.toString() + "] not supported by converter.toTable: " + this.getClass().getName());
    }

    @Override
    public String toTable(IField field) throws ExpressionException {
        return this.toTable(field, false);
    }

    @Override
    public String toAliasTable(IField field) throws ExpressionException {
        return this.toTable(field, true);
    }

    @Override
    public String toTable(IModel<?> model, boolean returnAlias) throws ExpressionException {
        throw new ExpressionException("Model [" + model.toString() + "] not supported by converter.toTable: " + this.getClass().getName());
    }

    @Override
    public String toTable(IModel<?> model) throws ExpressionException {
        return this.toTable(model, false);
    }

    @Override
    public String toAliasTable(IModel<?> model) throws ExpressionException {
        return this.toTable(model, true);
    }
}

