/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.expression.impl.formatter;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.expression.impl.formatter.ITypeFormatter;
import org.openspcoop2.utils.TipiDatabase;

public class TimestampTypeFormatter
implements ITypeFormatter<Timestamp> {
    private SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    @Override
    public String toString(Timestamp o) throws ExpressionException {
        if (o == null) {
            throw new ExpressionException("Object parameter is null");
        }
        return this.dateformat.format(o);
    }

    @Override
    public String toSQLString(Timestamp o) throws ExpressionException {
        return this.toSQLString(o, TipiDatabase.DEFAULT);
    }

    @Override
    public String toSQLString(Timestamp o, TipiDatabase databaseType) throws ExpressionException {
        switch (databaseType) {
            case POSTGRESQL: {
                return "timestamp '" + this.toString(o) + "'";
            }
        }
        return "'" + this.toString(o) + "'";
    }

    @Override
    public Timestamp toObject(String o, Class<?> c) throws ExpressionException {
        if (o == null) {
            throw new ExpressionException("Object parameter is null");
        }
        try {
            return new Timestamp(this.dateformat.parse(o).getTime());
        }
        catch (Exception e) {
            throw new ExpressionException("Conversion failure: " + e.getMessage(), e);
        }
    }

    @Override
    public Class<Timestamp> getTypeSupported() {
        return Timestamp.class;
    }
}

