/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.expression.impl.formatter;

import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.expression.impl.formatter.ITypeFormatter;
import org.openspcoop2.utils.TipiDatabase;

public class StringTypeFormatter
implements ITypeFormatter<String> {
    @Override
    public String toString(String o) throws ExpressionException {
        if (o == null) {
            throw new ExpressionException("Object parameter is null");
        }
        return o;
    }

    @Override
    public String toSQLString(String o) throws ExpressionException {
        return this.toSQLString(o, TipiDatabase.DEFAULT);
    }

    @Override
    public String toSQLString(String o, TipiDatabase databaseType) throws ExpressionException {
        switch (databaseType) {
            case POSTGRESQL: {
                return "'" + StringTypeFormatter.escapeStringValue(this.toString(o)) + "'::text";
            }
        }
        return "'" + StringTypeFormatter.escapeStringValue(this.toString(o)) + "'";
    }

    @Override
    public String toObject(String o, Class<?> c) throws ExpressionException {
        if (o == null) {
            throw new ExpressionException("Object parameter is null");
        }
        return o;
    }

    @Override
    public Class<String> getTypeSupported() {
        return String.class;
    }

    public static String escapeStringValue(String value) throws ExpressionException {
        if (value == null) {
            throw new ExpressionException("Value is null");
        }
        int index = value.indexOf(39);
        if (index >= 0) {
            StringBuffer str = new StringBuffer();
            char[] v = value.toCharArray();
            for (int i = 0; i < v.length; ++i) {
                if (v[i] == '\'') {
                    str.append('\'');
                }
                str.append(v[i]);
            }
            return str.toString();
        }
        return value;
    }
}

