/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.expression.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openspcoop2.generic_project.beans.ComplexField;
import org.openspcoop2.generic_project.beans.ConstantField;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotFoundException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.LikeMode;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.generic_project.expression.impl.AbstractBaseExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.BetweenExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.Comparator;
import org.openspcoop2.generic_project.expression.impl.ComparatorExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.ConjunctionExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.InExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.LikeExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.formatter.IObjectFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.ObjectFormatter;

public class ExpressionImpl
implements IExpression {
    private boolean throwExpressionNotInitialized = false;
    protected IObjectFormatter objectFormatter;
    protected boolean andLogicOperator = true;
    protected AbstractBaseExpressionImpl expressionEngine;
    protected boolean notOperator = false;
    protected SortOrder sortOrder = SortOrder.UNSORTED;
    protected List<IField> orderedFields = new ArrayList<IField>();
    protected List<IField> groupByFields = new ArrayList<IField>();

    public IObjectFormatter getObjectFormatter() {
        return this.objectFormatter;
    }

    public void setObjectFormatter(IObjectFormatter objectFormatter) {
        this.objectFormatter = objectFormatter;
    }

    public ExpressionImpl() throws ExpressionException {
        this.objectFormatter = new ObjectFormatter();
    }

    public ExpressionImpl(IObjectFormatter objectFormatter) throws ExpressionException {
        if (objectFormatter == null) {
            throw new ExpressionException("IObjectFormatter parameter is null");
        }
        this.objectFormatter = objectFormatter;
    }

    public ExpressionImpl(ExpressionImpl expr) {
        this.andLogicOperator = expr.andLogicOperator;
        this.expressionEngine = expr.expressionEngine;
        this.notOperator = expr.notOperator;
        this.objectFormatter = expr.objectFormatter;
        this.orderedFields = expr.orderedFields;
        this.sortOrder = expr.sortOrder;
        this.groupByFields = expr.groupByFields;
        this.throwExpressionNotInitialized = expr.throwExpressionNotInitialized;
    }

    public AbstractBaseExpressionImpl getExpressionEngine() {
        return this.expressionEngine;
    }

    @Override
    public IExpression not() throws ExpressionNotImplementedException, ExpressionException {
        this.notOperator = true;
        if (this.expressionEngine != null) {
            this.expressionEngine.setNot(true);
        }
        return this;
    }

    @Override
    public IExpression and() throws ExpressionNotImplementedException, ExpressionException {
        this.andLogicOperator = true;
        if (this.expressionEngine != null && this.expressionEngine instanceof ConjunctionExpressionImpl) {
            ((ConjunctionExpressionImpl)this.expressionEngine).setAndConjunction(this.andLogicOperator);
        }
        return this;
    }

    @Override
    public IExpression or() throws ExpressionNotImplementedException, ExpressionException {
        this.andLogicOperator = false;
        if (this.expressionEngine != null && this.expressionEngine instanceof ConjunctionExpressionImpl) {
            ((ConjunctionExpressionImpl)this.expressionEngine).setAndConjunction(this.andLogicOperator);
        }
        return this;
    }

    @Override
    public IExpression equals(IField field, Object value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildComparatorExpression(field, value, Comparator.EQUALS);
        return this;
    }

    @Override
    public IExpression notEquals(IField field, Object value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildComparatorExpression(field, value, Comparator.NOT_EQUALS);
        return this;
    }

    @Override
    public IExpression allEquals(Map<IField, Object> propertyNameValues) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(propertyNameValues);
        this.buildComparatorExpression(propertyNameValues, Comparator.EQUALS, true);
        return this;
    }

    @Override
    public IExpression allNotEquals(Map<IField, Object> propertyNameValues) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(propertyNameValues);
        this.buildComparatorExpression(propertyNameValues, Comparator.NOT_EQUALS, true);
        return this;
    }

    @Override
    public IExpression allEquals(Map<IField, Object> propertyNameValues, boolean andConjunction) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(propertyNameValues);
        this.buildComparatorExpression(propertyNameValues, Comparator.EQUALS, andConjunction);
        return this;
    }

    @Override
    public IExpression allNotEquals(Map<IField, Object> propertyNameValues, boolean andConjunction) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(propertyNameValues);
        this.buildComparatorExpression(propertyNameValues, Comparator.NOT_EQUALS, andConjunction);
        return this;
    }

    @Override
    public IExpression greaterThan(IField field, Object value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildComparatorExpression(field, value, Comparator.GREATER_THAN);
        return this;
    }

    @Override
    public IExpression greaterEquals(IField field, Object value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildComparatorExpression(field, value, Comparator.GREATER_EQUALS);
        return this;
    }

    @Override
    public IExpression lessThan(IField field, Object value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildComparatorExpression(field, value, Comparator.LESS_THAN);
        return this;
    }

    @Override
    public IExpression lessEquals(IField field, Object value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildComparatorExpression(field, value, Comparator.LESS_EQUALS);
        return this;
    }

    @Override
    public IExpression isNull(IField field) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, false);
        this.buildComparatorExpression(field, null, Comparator.IS_NULL);
        return this;
    }

    @Override
    public IExpression isNotNull(IField field) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, false);
        this.buildComparatorExpression(field, null, Comparator.IS_NOT_NULL);
        return this;
    }

    @Override
    public IExpression isEmpty(IField field) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, false);
        this.buildComparatorExpression(field, null, Comparator.IS_EMPTY);
        return this;
    }

    @Override
    public IExpression isNotEmpty(IField field) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, false);
        this.buildComparatorExpression(field, null, Comparator.IS_NOT_EMPTY);
        return this;
    }

    @Override
    public IExpression between(IField field, Object lower, Object high) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, lower, high);
        this.buildBeetweenExpression(field, lower, high);
        return this;
    }

    @Override
    public IExpression like(IField field, String value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildLikeExpression(field, value, LikeMode.ANYWHERE, false);
        return this;
    }

    @Override
    public IExpression like(IField field, String value, LikeMode mode) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildLikeExpression(field, value, mode, false);
        return this;
    }

    @Override
    public IExpression ilike(IField field, String value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildLikeExpression(field, value, LikeMode.ANYWHERE, true);
        return this;
    }

    @Override
    public IExpression ilike(IField field, String value, LikeMode mode) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildLikeExpression(field, value, mode, true);
        return this;
    }

    @Override
    public IExpression in(IField field, Object ... values) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, values);
        this.buildInExpression(field, values);
        return this;
    }

    @Override
    public IExpression in(IField field, Collection<?> values) throws ExpressionNotImplementedException, ExpressionException {
        if (values == null) {
            throw new ExpressionException("Values is null");
        }
        this.checkArgoments(field, values.toArray(new Object[1]));
        this.buildInExpression(field, values.toArray(new Object[1]));
        return this;
    }

    @Override
    public IExpression and(IExpression exp1, IExpression exp2) throws ExpressionNotImplementedException, ExpressionException {
        IExpression[] expr = new IExpression[]{exp1, exp2};
        return this.and(expr);
    }

    @Override
    public IExpression and(IExpression ... expressions) throws ExpressionNotImplementedException, ExpressionException {
        this.checkConjunctionOperation(expressions);
        this.buildConjunctionExpression(true, expressions);
        return this;
    }

    @Override
    public IExpression or(IExpression exp1, IExpression exp2) throws ExpressionNotImplementedException, ExpressionException {
        IExpression[] expr = new IExpression[]{exp1, exp2};
        return this.or(expr);
    }

    @Override
    public IExpression or(IExpression ... expressions) throws ExpressionNotImplementedException, ExpressionException {
        this.checkConjunctionOperation(expressions);
        this.buildConjunctionExpression(false, expressions);
        return this;
    }

    @Override
    public IExpression not(IExpression expression) throws ExpressionNotImplementedException, ExpressionException {
        if (!(expression instanceof ExpressionImpl)) {
            throw new ExpressionException("Expression has wrong type expect: " + ExpressionImpl.class.getName() + "  found: " + expression.getClass().getName());
        }
        this.buildNotExpression(((ExpressionImpl)expression).expressionEngine);
        return this;
    }

    @Override
    public IExpression sortOrder(SortOrder sortOrder) throws ExpressionNotImplementedException, ExpressionException {
        this.sortOrder = sortOrder;
        return this;
    }

    @Override
    public IExpression addOrder(IField field) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, false);
        if (this.sortOrder == null || SortOrder.UNSORTED.equals(this.sortOrder)) {
            throw new ExpressionException("To add order by conditions must first be defined the sort order (by sortOrder method)");
        }
        this.orderedFields.add(field);
        return this;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public List<IField> getOrderedFields() {
        return this.orderedFields;
    }

    @Override
    public IExpression addGroupBy(IField field) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, false);
        this.groupByFields.add(field);
        return this;
    }

    public List<IField> getGroupByFields() {
        return this.groupByFields;
    }

    @Override
    public boolean inUseField(IField field, boolean checkOnlyWhereCondition) throws ExpressionNotImplementedException, ExpressionException {
        if (this.expressionEngine == null && checkOnlyWhereCondition) {
            return false;
        }
        if (this.expressionEngine != null && this.expressionEngine.inUseField(field)) {
            return true;
        }
        if (!checkOnlyWhereCondition) {
            int i;
            if (this.orderedFields != null) {
                for (i = 0; i < this.orderedFields.size(); ++i) {
                    if (!field.equals(this.orderedFields.get(i))) continue;
                    return true;
                }
            }
            if (this.groupByFields != null) {
                for (i = 0; i < this.groupByFields.size(); ++i) {
                    if (!field.equals(this.groupByFields.get(i))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean inUseModel(IModel<?> model, boolean checkOnlyWhereCondition) throws ExpressionNotImplementedException, ExpressionException {
        if (this.expressionEngine == null && checkOnlyWhereCondition) {
            return false;
        }
        if (this.expressionEngine != null && this.expressionEngine.inUseModel(model)) {
            return true;
        }
        if (!checkOnlyWhereCondition) {
            ComplexField c;
            boolean inUseModel;
            IField field;
            int i;
            if (this.orderedFields != null) {
                for (i = 0; i < this.orderedFields.size(); ++i) {
                    field = this.orderedFields.get(i);
                    inUseModel = false;
                    if (model.getBaseField() != null) {
                        if (field instanceof ComplexField) {
                            c = (ComplexField)field;
                            inUseModel = c.getFather().equals(model.getBaseField());
                        } else {
                            inUseModel = model.getModeledClass().getName().equals(field.getClassType().getName());
                        }
                    } else {
                        inUseModel = model.getModeledClass().getName().equals(field.getClassType().getName());
                    }
                    if (!inUseModel) continue;
                    return true;
                }
            }
            if (this.groupByFields != null) {
                for (i = 0; i < this.groupByFields.size(); ++i) {
                    field = this.groupByFields.get(i);
                    inUseModel = false;
                    if (model.getBaseField() != null) {
                        if (field instanceof ComplexField) {
                            c = (ComplexField)field;
                            inUseModel = c.getFather().equals(model.getBaseField());
                        } else {
                            inUseModel = model.getModeledClass().getName().equals(field.getClassType().getName());
                        }
                    } else {
                        inUseModel = model.getModeledClass().getName().equals(field.getClassType().getName());
                    }
                    if (!inUseModel) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public List<IField> getFields(boolean onlyWhereCondition) throws ExpressionNotImplementedException, ExpressionException {
        List<IField> o;
        List<IField> list = o = this.expressionEngine != null ? this.expressionEngine.getFields() : null;
        if (!onlyWhereCondition) {
            IField field;
            int i;
            if (this.orderedFields != null) {
                for (i = 0; i < this.orderedFields.size(); ++i) {
                    field = this.orderedFields.get(i);
                    if (o == null) {
                        o = new ArrayList<IField>();
                    }
                    if (o.contains(field)) continue;
                    o.add(field);
                }
            }
            if (this.groupByFields != null) {
                for (i = 0; i < this.groupByFields.size(); ++i) {
                    field = this.groupByFields.get(i);
                    if (o == null) {
                        o = new ArrayList<IField>();
                    }
                    if (o.contains(field)) continue;
                    o.add(field);
                }
            }
        }
        return o;
    }

    @Override
    public List<Object> getWhereConditionFieldValues(IField field) throws ExpressionNotImplementedException, ExpressionNotFoundException, ExpressionException {
        if (this.expressionEngine == null) {
            throw new ExpressionNotFoundException("Field is not used in expression (Expression is empty)");
        }
        if (!this.inUseField(field, true)) {
            throw new ExpressionNotFoundException("Field is not used in expression [" + field.toString() + "]");
        }
        List<Object> o = this.expressionEngine.getFieldValues(field);
        if (o == null) {
            throw new ExpressionNotFoundException("Field is not used in expression [" + field.toString() + "] (null??)");
        }
        return o;
    }

    @Override
    public boolean isWhereConditionsPresent() throws ExpressionNotImplementedException, ExpressionException {
        return this.expressionEngine == null;
    }

    public String toString() {
        ComplexField cf;
        int index;
        String s = super.toString();
        if (s == null) {
            return s;
        }
        if (this.throwExpressionNotInitialized) {
            throw new RuntimeException("Expression is not initialized");
        }
        StringBuffer bf = new StringBuffer();
        if (this.expressionEngine == null) {
            bf.append("");
        } else {
            bf.append(this.expressionEngine.toString());
        }
        if (this.groupByFields.size() > 0) {
            bf.append(" GROUP BY ");
            index = 0;
            for (IField field : this.groupByFields) {
                if (index > 0) {
                    bf.append(" , ");
                }
                if (field instanceof ComplexField) {
                    cf = (ComplexField)field;
                    if (cf.getFather() != null) {
                        bf.append(cf.getFather().getFieldName());
                    } else {
                        bf.append(field.getClassName());
                    }
                } else {
                    bf.append(field.getClassName());
                }
                bf.append(".");
                bf.append(field.getFieldName());
                ++index;
            }
        }
        if (!SortOrder.UNSORTED.equals(this.sortOrder)) {
            bf.append(" ORDER BY ");
            if (this.orderedFields.size() > 0) {
                index = 0;
                for (IField field : this.orderedFields) {
                    if (index > 0) {
                        bf.append(" , ");
                    }
                    if (field instanceof ComplexField) {
                        cf = (ComplexField)field;
                        if (cf.getFather() != null) {
                            bf.append(cf.getFather().getFieldName());
                        } else {
                            bf.append(field.getClassName());
                        }
                    } else {
                        bf.append(field.getClassName());
                    }
                    bf.append(".");
                    bf.append(field.getFieldName());
                    ++index;
                }
            } else {
                bf.append(" DEFAULT_ORDER_FIELD");
            }
            bf.append(" ");
            bf.append(this.sortOrder.name());
        }
        return bf.toString();
    }

    protected ComparatorExpressionImpl getComparatorExpression(IField field, Object value, Comparator c) throws ExpressionException {
        return new ComparatorExpressionImpl(this.objectFormatter, field, value, c);
    }

    protected BetweenExpressionImpl getBetweenExpression(IField field, Object lower, Object high) throws ExpressionException {
        return new BetweenExpressionImpl(this.objectFormatter, field, lower, high);
    }

    protected InExpressionImpl getInExpression(IField field, Object ... values) throws ExpressionException {
        ArrayList<Object> lista = new ArrayList<Object>();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                lista.add(values[i]);
            }
        }
        return new InExpressionImpl(this.objectFormatter, field, lista);
    }

    protected LikeExpressionImpl getLikeExpression(IField field, String value, LikeMode mode, boolean caseInsensitive) throws ExpressionException {
        return new LikeExpressionImpl(this.objectFormatter, field, value, mode, caseInsensitive);
    }

    protected ConjunctionExpressionImpl getConjunctionExpression() throws ExpressionException {
        return new ConjunctionExpressionImpl(this.objectFormatter);
    }

    protected void buildComparatorExpression(IField field, Object value, Comparator c) throws ExpressionException {
        ComparatorExpressionImpl cExp = this.getComparatorExpression(field, value, c);
        if (this.expressionEngine == null) {
            this.expressionEngine = cExp;
        } else {
            this.conjunctionWithInternalInstance(cExp);
        }
        this.expressionEngine.setNot(this.notOperator);
    }

    protected void buildComparatorExpression(Map<IField, Object> propertyNameValues, Comparator c, boolean and) throws ExpressionException {
        Iterator<IField> fieldsIt = propertyNameValues.keySet().iterator();
        ConjunctionExpressionImpl newConjunctionExpr = this.getConjunctionExpression();
        newConjunctionExpr.setAndConjunction(and);
        while (fieldsIt.hasNext()) {
            IField field = fieldsIt.next();
            Object value = propertyNameValues.get(field);
            newConjunctionExpr.addXMLExpression(this.getComparatorExpression(field, value, c));
        }
        this.conjunctionWithInternalInstance(newConjunctionExpr);
        this.expressionEngine.setNot(this.notOperator);
    }

    protected void buildBeetweenExpression(IField field, Object lower, Object high) throws ExpressionException {
        BetweenExpressionImpl cExp = this.getBetweenExpression(field, lower, high);
        if (this.expressionEngine == null) {
            this.expressionEngine = cExp;
        } else {
            this.conjunctionWithInternalInstance(cExp);
        }
        this.expressionEngine.setNot(this.notOperator);
    }

    protected void buildInExpression(IField field, Object ... values) throws ExpressionException {
        InExpressionImpl cExp = this.getInExpression(field, values);
        if (this.expressionEngine == null) {
            this.expressionEngine = cExp;
        } else {
            this.conjunctionWithInternalInstance(cExp);
        }
        this.expressionEngine.setNot(this.notOperator);
    }

    protected void buildLikeExpression(IField field, String value, LikeMode mode, boolean caseInsensitive) throws ExpressionException {
        LikeExpressionImpl cExp = this.getLikeExpression(field, value, mode, caseInsensitive);
        if (this.expressionEngine == null) {
            this.expressionEngine = cExp;
        } else {
            this.conjunctionWithInternalInstance(cExp);
        }
        this.expressionEngine.setNot(this.notOperator);
    }

    protected void buildNotExpression(AbstractBaseExpressionImpl expr) throws ExpressionException {
        expr.setNot(true);
        if (this.expressionEngine == null) {
            this.expressionEngine = expr;
        } else {
            String s2;
            String s1 = this.expressionEngine.toString();
            if (s1.equals(s2 = expr.toString())) {
                this.expressionEngine = expr;
            } else {
                this.conjunctionWithInternalInstance(expr);
            }
        }
    }

    protected void buildConjunctionExpression(boolean and, IExpression ... expressions) throws ExpressionException {
        ConjunctionExpressionImpl cExp = this.getConjunctionExpression();
        cExp.setAndConjunction(and);
        for (int i = 0; i < expressions.length; ++i) {
            ExpressionImpl xmlExpression = (ExpressionImpl)expressions[i];
            cExp.addXMLExpression(xmlExpression.expressionEngine);
        }
        if (this.expressionEngine == null) {
            this.expressionEngine = cExp;
        } else {
            this.conjunctionWithInternalInstance(cExp);
        }
        this.expressionEngine.setNot(this.notOperator);
    }

    protected void conjunctionWithInternalInstance(AbstractBaseExpressionImpl newExpr) throws ExpressionException {
        ConjunctionExpressionImpl newConjunctionExpr = this.getConjunctionExpression();
        newConjunctionExpr.setAndConjunction(this.andLogicOperator);
        if (this.expressionEngine != null) {
            if (!(this.expressionEngine instanceof ConjunctionExpressionImpl)) {
                newConjunctionExpr.addXMLExpression(this.expressionEngine);
            } else {
                boolean simpleConjunction = true;
                ConjunctionExpressionImpl cTest = (ConjunctionExpressionImpl)this.expressionEngine;
                if (cTest.isAndConjunction() != this.andLogicOperator) {
                    simpleConjunction = false;
                }
                if (simpleConjunction) {
                    for (AbstractBaseExpressionImpl expr : cTest.getLista()) {
                        if (!(expr instanceof ConjunctionExpressionImpl)) continue;
                        simpleConjunction = false;
                        break;
                    }
                }
                if (simpleConjunction) {
                    for (AbstractBaseExpressionImpl expr : cTest.getLista()) {
                        expr.setNot(false);
                        newConjunctionExpr.addXMLExpression(expr);
                    }
                } else {
                    newConjunctionExpr.addXMLExpression(cTest);
                }
            }
        }
        newConjunctionExpr.addXMLExpression(newExpr);
        this.expressionEngine = newConjunctionExpr;
        this.expressionEngine.setNot(this.notOperator);
    }

    protected void checkArgoments(IField field) throws ExpressionException {
        this.checkArgoments(field, true);
    }

    protected void checkArgoments(IField field, boolean constantPermit) throws ExpressionException {
        if (field == null) {
            throw new ExpressionException("Field is null");
        }
        if (!constantPermit && field instanceof ConstantField) {
            throw new ExpressionException("The field type 'ConstantField' can not be used with this method");
        }
    }

    protected void checkArgoments(IField field, Object value) throws ExpressionException {
        this.checkArgoments(field, value, true);
    }

    protected void checkArgoments(IField field, Object value, boolean constantPermit) throws ExpressionException {
        if (field == null) {
            throw new ExpressionException("Field is null");
        }
        if (value == null) {
            throw new ExpressionException("Value is null for field: " + field.toString());
        }
        try {
            this.objectFormatter.isSupported(value);
        }
        catch (Exception e) {
            throw new ExpressionException("[Value] " + e.getMessage(), e);
        }
        if (!constantPermit && field instanceof ConstantField) {
            throw new ExpressionException("The field type 'ConstantField' can not be used with this method");
        }
    }

    protected void checkArgoments(IField field, Object[] values) throws ExpressionException {
        this.checkArgoments(field, values, true);
    }

    protected void checkArgoments(IField field, Object[] values, boolean constantPermit) throws ExpressionException {
        if (field == null) {
            throw new ExpressionException("Field is null");
        }
        if (values == null) {
            throw new ExpressionException("Values is null");
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                throw new ExpressionException("Values[" + i + "] is null for field: " + field.toString());
            }
            try {
                this.objectFormatter.isSupported(values[i]);
                continue;
            }
            catch (Exception e) {
                throw new ExpressionException("[Value[" + i + "]] " + e.getMessage(), e);
            }
        }
        if (!constantPermit && field instanceof ConstantField) {
            throw new ExpressionException("The field type 'ConstantField' can not be used with this method");
        }
    }

    protected void checkArgoments(IField field, Object lower, Object high) throws ExpressionException {
        this.checkArgoments(field, lower, high, true);
    }

    protected void checkArgoments(IField field, Object lower, Object high, boolean constantPermit) throws ExpressionException {
        if (field == null) {
            throw new ExpressionException("Field is null");
        }
        if (lower == null) {
            throw new ExpressionException("Lower is null for field: " + field.toString());
        }
        if (high == null) {
            throw new ExpressionException("High is null for field: " + field.toString());
        }
        try {
            this.objectFormatter.isSupported(lower);
        }
        catch (Exception e) {
            throw new ExpressionException("[Lower] " + e.getMessage(), e);
        }
        try {
            this.objectFormatter.isSupported(high);
        }
        catch (Exception e) {
            throw new ExpressionException("[High] " + e.getMessage(), e);
        }
        if (!constantPermit && field instanceof ConstantField) {
            throw new ExpressionException("The field type 'ConstantField' can not be used with this method");
        }
    }

    protected void checkArgoments(Map<IField, Object> propertyNameValues) throws ExpressionException {
        this.checkArgoments(propertyNameValues, true);
    }

    protected void checkArgoments(Map<IField, Object> propertyNameValues, boolean constantPermit) throws ExpressionException {
        if (propertyNameValues == null) {
            throw new ExpressionException("PropertyNameValues is null");
        }
        for (IField iField : propertyNameValues.keySet()) {
            if (iField == null) {
                throw new ExpressionException("Field is null");
            }
            if (propertyNameValues.get(iField) == null) {
                throw new ExpressionException("Value for Field[" + iField + "] is null");
            }
            try {
                this.objectFormatter.isSupported(propertyNameValues.get(iField));
            }
            catch (Exception e) {
                throw new ExpressionException("[Value for Field[" + iField + "]] " + e.getMessage(), e);
            }
            if (constantPermit || !(iField instanceof ConstantField)) continue;
            throw new ExpressionException("The field type 'ConstantField' can not be used with this method");
        }
    }

    protected void checkConjunctionOperation(IExpression ... expressions) throws ExpressionException {
        if (expressions == null || expressions.length <= 0) {
            throw new ExpressionException("Expressions is null or is empty");
        }
        for (int i = 0; i < expressions.length; ++i) {
            if (expressions[i] == null) {
                throw new ExpressionException("Expression[" + i + "] is null");
            }
            if (expressions[i] instanceof ExpressionImpl) continue;
            throw new ExpressionException("Expression[" + i + "] has wrong type expect: " + ExpressionImpl.class.getName() + "  found: " + expressions[i].getClass().getName());
        }
    }
}

