/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.transazioni.dao.jdbc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.core.transazioni.TransazioneExtendedInfo;
import org.openspcoop2.core.transazioni.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.transazioni.dao.jdbc.JDBCTransazioneServiceSearchImpl;
import org.openspcoop2.core.transazioni.utils.TransazioneDaoExt;
import org.openspcoop2.generic_project.beans.IDMappingBehaviour;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.generic_project.beans.NonNegativeNumber;
import org.openspcoop2.generic_project.beans.UpdateField;
import org.openspcoop2.generic_project.beans.UpdateModel;
import org.openspcoop2.generic_project.dao.jdbc.IJDBCServiceCRUDWithId;
import org.openspcoop2.generic_project.dao.jdbc.IJDBCServiceSearchWithId;
import org.openspcoop2.generic_project.dao.jdbc.JDBCExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCPaginatedExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCServiceManagerProperties;
import org.openspcoop2.generic_project.dao.jdbc.utils.GenericJDBCUtilities;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCObject;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCPreparedStatementUtilities;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.date.UnitaTemporale;
import org.openspcoop2.utils.jdbc.JDBCAdapterException;
import org.openspcoop2.utils.jdbc.PostgreSQLUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLQueryObjectException;
import org.slf4j.Logger;

public class JDBCTransazioneServiceImpl
extends JDBCTransazioneServiceSearchImpl
implements IJDBCServiceCRUDWithId<Transazione, String, JDBCServiceManager> {
    private static boolean efficiente = true;

    public void create(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Transazione transazione, IDMappingBehaviour idMappingResolutionBehaviour) throws NotImplementedException, ServiceException, Exception {
        if (TipiDatabase.POSTGRESQL.equals((Object)jdbcProperties.getDatabase())) {
            if (transazione.getFaultCooperazione() != null && PostgreSQLUtilities.containsNullByteSequence((String)transazione.getFaultCooperazione())) {
                transazione.setFaultCooperazione(PostgreSQLUtilities.normalizeString((String)transazione.getFaultCooperazione()));
            }
            if (transazione.getFaultIntegrazione() != null && PostgreSQLUtilities.containsNullByteSequence((String)transazione.getFaultIntegrazione())) {
                transazione.setFaultIntegrazione(PostgreSQLUtilities.normalizeString((String)transazione.getFaultIntegrazione()));
            }
            if (transazione.getCredenziali() != null && PostgreSQLUtilities.containsNullByteSequence((String)transazione.getCredenziali())) {
                transazione.setCredenziali(PostgreSQLUtilities.normalizeString((String)transazione.getCredenziali()));
            }
        }
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ISQLQueryObject sqlQueryObjectInsert = sqlQueryObject.newSQLQueryObject();
        sqlQueryObjectInsert.addInsertTable(this.getTransazioneFieldConverter().toTable((IModel)Transazione.model()));
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().ID_TRANSAZIONE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().STATO, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().RUOLO_TRANSAZIONE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().ESITO, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().ESITO_SINCRONO, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().CONSEGNE_MULTIPLE_IN_CORSO, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().ESITO_CONTESTO, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().PROTOCOLLO, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TIPO_RICHIESTA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().CODICE_RISPOSTA_INGRESSO, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().CODICE_RISPOSTA_USCITA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DATA_ACCETTAZIONE_RICHIESTA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DATA_INGRESSO_RICHIESTA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DATA_INGRESSO_RICHIESTA_STREAM, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DATA_USCITA_RICHIESTA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DATA_USCITA_RICHIESTA_STREAM, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DATA_ACCETTAZIONE_RISPOSTA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DATA_INGRESSO_RISPOSTA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DATA_INGRESSO_RISPOSTA_STREAM, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DATA_USCITA_RISPOSTA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DATA_USCITA_RISPOSTA_STREAM, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().RICHIESTA_INGRESSO_BYTES, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().RICHIESTA_USCITA_BYTES, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().RISPOSTA_INGRESSO_BYTES, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().RISPOSTA_USCITA_BYTES, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().PDD_CODICE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().PDD_TIPO_SOGGETTO, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().PDD_NOME_SOGGETTO, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().PDD_RUOLO, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().FAULT_INTEGRAZIONE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().FORMATO_FAULT_INTEGRAZIONE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().FAULT_COOPERAZIONE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().FORMATO_FAULT_COOPERAZIONE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TIPO_SOGGETTO_FRUITORE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().NOME_SOGGETTO_FRUITORE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().IDPORTA_SOGGETTO_FRUITORE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().INDIRIZZO_SOGGETTO_FRUITORE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TIPO_SOGGETTO_EROGATORE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().NOME_SOGGETTO_EROGATORE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().IDPORTA_SOGGETTO_EROGATORE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().INDIRIZZO_SOGGETTO_EROGATORE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().ID_MESSAGGIO_RICHIESTA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().ID_MESSAGGIO_RISPOSTA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DATA_ID_MSG_RICHIESTA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DATA_ID_MSG_RISPOSTA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().PROFILO_COLLABORAZIONE_OP_2, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().PROFILO_COLLABORAZIONE_PROT, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().ID_COLLABORAZIONE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().URI_ACCORDO_SERVIZIO, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TIPO_SERVIZIO, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().NOME_SERVIZIO, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().VERSIONE_SERVIZIO, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().AZIONE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().ID_ASINCRONO, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TIPO_SERVIZIO_CORRELATO, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().NOME_SERVIZIO_CORRELATO, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().HEADER_PROTOCOLLO_RICHIESTA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DIGEST_RICHIESTA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().PROTOCOLLO_EXT_INFO_RICHIESTA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().HEADER_PROTOCOLLO_RISPOSTA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DIGEST_RISPOSTA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().PROTOCOLLO_EXT_INFO_RISPOSTA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TRACCIA_RICHIESTA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TRACCIA_RISPOSTA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DIAGNOSTICI, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DIAGNOSTICI_LIST_1, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DIAGNOSTICI_LIST_2, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DIAGNOSTICI_LIST_EXT, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DIAGNOSTICI_EXT, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().ERROR_LOG, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().WARNING_LOG, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().ID_CORRELAZIONE_APPLICATIVA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().ID_CORRELAZIONE_APPLICATIVA_RISPOSTA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().SERVIZIO_APPLICATIVO_FRUITORE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().SERVIZIO_APPLICATIVO_EROGATORE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().OPERAZIONE_IM, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().LOCATION_RICHIESTA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().LOCATION_RISPOSTA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().NOME_PORTA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().CREDENZIALI, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().LOCATION_CONNETTORE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().URL_INVOCAZIONE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TRASPORTO_MITTENTE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TOKEN_ISSUER, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TOKEN_CLIENT_ID, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TOKEN_SUBJECT, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TOKEN_USERNAME, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TOKEN_MAIL, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TOKEN_INFO, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TOKEN_PURPOSE_ID, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TOKEN_ID, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TEMPI_ELABORAZIONE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DUPLICATI_RICHIESTA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DUPLICATI_RISPOSTA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().CLUSTER_ID, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().SOCKET_CLIENT_ADDRESS, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TRANSPORT_CLIENT_ADDRESS, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().CLIENT_ADDRESS, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().EVENTI_GESTIONE, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TIPO_API, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().URI_API, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getTransazioneFieldConverter().toColumn(Transazione.model().GRUPPI, false), "?");
        if (transazione.sizeTransazioneExtendedInfoList() > 0) {
            for (TransazioneExtendedInfo transazioneExtedendInfo : transazione.getTransazioneExtendedInfoList()) {
                sqlQueryObjectInsert.addInsertField(transazioneExtedendInfo.getNome(), "?");
            }
        }
        String insertSql = sqlQueryObjectInsert.createSQLInsert();
        ArrayList<JDBCObject> listaJDBCObject = new ArrayList<JDBCObject>();
        listaJDBCObject.add(new JDBCObject((Object)transazione.getIdTransazione(), Transazione.model().ID_TRANSAZIONE.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getStato(), Transazione.model().STATO.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getRuoloTransazione(), Transazione.model().RUOLO_TRANSAZIONE.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getEsito(), Transazione.model().ESITO.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getEsitoSincrono(), Transazione.model().ESITO_SINCRONO.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getConsegneMultipleInCorso(), Transazione.model().CONSEGNE_MULTIPLE_IN_CORSO.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getEsitoContesto(), Transazione.model().ESITO_CONTESTO.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getProtocollo(), Transazione.model().PROTOCOLLO.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getTipoRichiesta(), Transazione.model().TIPO_RICHIESTA.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getCodiceRispostaIngresso(), Transazione.model().CODICE_RISPOSTA_INGRESSO.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getCodiceRispostaUscita(), Transazione.model().CODICE_RISPOSTA_USCITA.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getDataAccettazioneRichiesta(), Transazione.model().DATA_ACCETTAZIONE_RICHIESTA.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getDataIngressoRichiesta(), Transazione.model().DATA_INGRESSO_RICHIESTA.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getDataIngressoRichiestaStream(), Transazione.model().DATA_INGRESSO_RICHIESTA_STREAM.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getDataUscitaRichiesta(), Transazione.model().DATA_USCITA_RICHIESTA.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getDataUscitaRichiestaStream(), Transazione.model().DATA_USCITA_RICHIESTA_STREAM.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getDataAccettazioneRisposta(), Transazione.model().DATA_ACCETTAZIONE_RISPOSTA.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getDataIngressoRisposta(), Transazione.model().DATA_INGRESSO_RISPOSTA.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getDataIngressoRispostaStream(), Transazione.model().DATA_INGRESSO_RISPOSTA_STREAM.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getDataUscitaRisposta(), Transazione.model().DATA_USCITA_RISPOSTA.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getDataUscitaRispostaStream(), Transazione.model().DATA_USCITA_RISPOSTA_STREAM.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getRichiestaIngressoBytes(), Transazione.model().RICHIESTA_INGRESSO_BYTES.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getRichiestaUscitaBytes(), Transazione.model().RICHIESTA_USCITA_BYTES.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getRispostaIngressoBytes(), Transazione.model().RISPOSTA_INGRESSO_BYTES.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getRispostaUscitaBytes(), Transazione.model().RISPOSTA_USCITA_BYTES.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getPddCodice(), Transazione.model().PDD_CODICE.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getPddTipoSoggetto(), Transazione.model().PDD_TIPO_SOGGETTO.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getPddNomeSoggetto(), Transazione.model().PDD_NOME_SOGGETTO.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getPddRuolo(), Transazione.model().PDD_RUOLO.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getFaultIntegrazione(), Transazione.model().FAULT_INTEGRAZIONE.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getFormatoFaultIntegrazione(), Transazione.model().FORMATO_FAULT_INTEGRAZIONE.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getFaultCooperazione(), Transazione.model().FAULT_COOPERAZIONE.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getFormatoFaultCooperazione(), Transazione.model().FORMATO_FAULT_COOPERAZIONE.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getTipoSoggettoFruitore(), Transazione.model().TIPO_SOGGETTO_FRUITORE.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getNomeSoggettoFruitore(), Transazione.model().NOME_SOGGETTO_FRUITORE.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getIdportaSoggettoFruitore(), Transazione.model().IDPORTA_SOGGETTO_FRUITORE.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getIndirizzoSoggettoFruitore(), Transazione.model().INDIRIZZO_SOGGETTO_FRUITORE.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getTipoSoggettoErogatore(), Transazione.model().TIPO_SOGGETTO_EROGATORE.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getNomeSoggettoErogatore(), Transazione.model().NOME_SOGGETTO_EROGATORE.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getIdportaSoggettoErogatore(), Transazione.model().IDPORTA_SOGGETTO_EROGATORE.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getIndirizzoSoggettoErogatore(), Transazione.model().INDIRIZZO_SOGGETTO_EROGATORE.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getIdMessaggioRichiesta(), Transazione.model().ID_MESSAGGIO_RICHIESTA.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getIdMessaggioRisposta(), Transazione.model().ID_MESSAGGIO_RISPOSTA.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getDataIdMsgRichiesta(), Transazione.model().DATA_ID_MSG_RICHIESTA.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getDataIdMsgRisposta(), Transazione.model().DATA_ID_MSG_RISPOSTA.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getProfiloCollaborazioneOp2(), Transazione.model().PROFILO_COLLABORAZIONE_OP_2.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getProfiloCollaborazioneProt(), Transazione.model().PROFILO_COLLABORAZIONE_PROT.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getIdCollaborazione(), Transazione.model().ID_COLLABORAZIONE.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getUriAccordoServizio(), Transazione.model().URI_ACCORDO_SERVIZIO.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getTipoServizio(), Transazione.model().TIPO_SERVIZIO.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getNomeServizio(), Transazione.model().NOME_SERVIZIO.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getVersioneServizio(), Transazione.model().VERSIONE_SERVIZIO.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getAzione(), Transazione.model().AZIONE.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getIdAsincrono(), Transazione.model().ID_ASINCRONO.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getTipoServizioCorrelato(), Transazione.model().TIPO_SERVIZIO_CORRELATO.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getNomeServizioCorrelato(), Transazione.model().NOME_SERVIZIO_CORRELATO.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getHeaderProtocolloRichiesta(), Transazione.model().HEADER_PROTOCOLLO_RICHIESTA.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getDigestRichiesta(), Transazione.model().DIGEST_RICHIESTA.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getProtocolloExtInfoRichiesta(), Transazione.model().PROTOCOLLO_EXT_INFO_RICHIESTA.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getHeaderProtocolloRisposta(), Transazione.model().HEADER_PROTOCOLLO_RISPOSTA.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getDigestRisposta(), Transazione.model().DIGEST_RISPOSTA.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getProtocolloExtInfoRisposta(), Transazione.model().PROTOCOLLO_EXT_INFO_RISPOSTA.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getTracciaRichiesta(), Transazione.model().TRACCIA_RICHIESTA.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getTracciaRisposta(), Transazione.model().TRACCIA_RISPOSTA.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getDiagnostici(), Transazione.model().DIAGNOSTICI.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getDiagnosticiList1(), Transazione.model().DIAGNOSTICI_LIST_1.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getDiagnosticiList2(), Transazione.model().DIAGNOSTICI_LIST_2.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getDiagnosticiListExt(), Transazione.model().DIAGNOSTICI_LIST_EXT.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getDiagnosticiExt(), Transazione.model().DIAGNOSTICI_EXT.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getErrorLog(), Transazione.model().ERROR_LOG.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getWarningLog(), Transazione.model().WARNING_LOG.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getIdCorrelazioneApplicativa(), Transazione.model().ID_CORRELAZIONE_APPLICATIVA.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getIdCorrelazioneApplicativaRisposta(), Transazione.model().ID_CORRELAZIONE_APPLICATIVA_RISPOSTA.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getServizioApplicativoFruitore(), Transazione.model().SERVIZIO_APPLICATIVO_FRUITORE.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getServizioApplicativoErogatore(), Transazione.model().SERVIZIO_APPLICATIVO_EROGATORE.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getOperazioneIm(), Transazione.model().OPERAZIONE_IM.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getLocationRichiesta(), Transazione.model().LOCATION_RICHIESTA.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getLocationRisposta(), Transazione.model().LOCATION_RISPOSTA.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getNomePorta(), Transazione.model().NOME_PORTA.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getCredenziali(), Transazione.model().CREDENZIALI.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getLocationConnettore(), Transazione.model().LOCATION_CONNETTORE.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getUrlInvocazione(), Transazione.model().URL_INVOCAZIONE.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getTrasportoMittente(), Transazione.model().TRASPORTO_MITTENTE.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getTokenIssuer(), Transazione.model().TOKEN_ISSUER.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getTokenClientId(), Transazione.model().TOKEN_CLIENT_ID.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getTokenSubject(), Transazione.model().TOKEN_SUBJECT.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getTokenUsername(), Transazione.model().TOKEN_USERNAME.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getTokenMail(), Transazione.model().TOKEN_MAIL.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getTokenInfo(), Transazione.model().TOKEN_INFO.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getTokenPurposeId(), Transazione.model().TOKEN_PURPOSE_ID.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getTokenId(), Transazione.model().TOKEN_ID.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getTempiElaborazione(), Transazione.model().TEMPI_ELABORAZIONE.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getDuplicatiRichiesta(), Transazione.model().DUPLICATI_RICHIESTA.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getDuplicatiRisposta(), Transazione.model().DUPLICATI_RISPOSTA.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getClusterId(), Transazione.model().CLUSTER_ID.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getSocketClientAddress(), Transazione.model().SOCKET_CLIENT_ADDRESS.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getTransportClientAddress(), Transazione.model().TRANSPORT_CLIENT_ADDRESS.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getClientAddress(), Transazione.model().CLIENT_ADDRESS.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getEventiGestione(), Transazione.model().EVENTI_GESTIONE.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getTipoApi(), Transazione.model().TIPO_API.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getUriApi(), Transazione.model().URI_API.getFieldType()));
        listaJDBCObject.add(new JDBCObject((Object)transazione.getGruppi(), Transazione.model().GRUPPI.getFieldType()));
        if (transazione.sizeTransazioneExtendedInfoList() > 0) {
            for (TransazioneExtendedInfo transazioneExtedendInfo : transazione.getTransazioneExtendedInfoList()) {
                listaJDBCObject.add(new JDBCObject((Object)transazioneExtedendInfo.getValore(), String.class));
            }
        }
        jdbcUtilities.execute(insertSql, jdbcProperties.isShowSql(), listaJDBCObject.toArray(new JDBCObject[1]));
    }

    public void update(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, String oldId, Transazione transazioneParam, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        ISQLQueryObject sqlQueryObjectUpdate;
        Object longIdByLogicId;
        Transazione transazione = null;
        boolean useDayIntervalForUpdate = false;
        if (transazioneParam instanceof TransazioneDaoExt) {
            TransazioneDaoExt ext = (TransazioneDaoExt)transazioneParam;
            transazione = ext.getWrapped();
            useDayIntervalForUpdate = ext.isUseDayIntervalForUpdate();
        } else {
            transazione = transazioneParam;
        }
        if (TipiDatabase.POSTGRESQL.equals((Object)jdbcProperties.getDatabase())) {
            if (transazione.getFaultCooperazione() != null && PostgreSQLUtilities.containsNullByteSequence((String)transazione.getFaultCooperazione())) {
                transazione.setFaultCooperazione(PostgreSQLUtilities.normalizeString((String)transazione.getFaultCooperazione()));
            }
            if (transazione.getFaultIntegrazione() != null && PostgreSQLUtilities.containsNullByteSequence((String)transazione.getFaultIntegrazione())) {
                transazione.setFaultIntegrazione(PostgreSQLUtilities.normalizeString((String)transazione.getFaultIntegrazione()));
            }
            if (transazione.getCredenziali() != null && PostgreSQLUtilities.containsNullByteSequence((String)transazione.getCredenziali())) {
                transazione.setCredenziali(PostgreSQLUtilities.normalizeString((String)transazione.getCredenziali()));
            }
        }
        if ((longIdByLogicId = this.findIdTransazione(jdbcProperties, log, connection, (sqlQueryObjectUpdate = sqlQueryObject.newSQLQueryObject()).newSQLQueryObject(), oldId, true, false)) == null) {
            throw new Exception("Retrieve logicId failed");
        }
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        sqlQueryObjectUpdate.setANDLogicOperator(true);
        sqlQueryObjectUpdate.addUpdateTable(this.getTransazioneFieldConverter().toTable((IModel)Transazione.model()));
        boolean isUpdate_transazione = true;
        ArrayList<JDBCObject> lstObjects_transazione = new ArrayList<JDBCObject>();
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().ID_TRANSAZIONE, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getIdTransazione(), Transazione.model().ID_TRANSAZIONE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().STATO, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getStato(), Transazione.model().STATO.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().RUOLO_TRANSAZIONE, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getRuoloTransazione(), Transazione.model().RUOLO_TRANSAZIONE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().ESITO, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getEsito(), Transazione.model().ESITO.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().ESITO_SINCRONO, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getEsitoSincrono(), Transazione.model().ESITO_SINCRONO.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().CONSEGNE_MULTIPLE_IN_CORSO, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getConsegneMultipleInCorso(), Transazione.model().CONSEGNE_MULTIPLE_IN_CORSO.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().ESITO_CONTESTO, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getEsitoContesto(), Transazione.model().ESITO_CONTESTO.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().PROTOCOLLO, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getProtocollo(), Transazione.model().PROTOCOLLO.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TIPO_RICHIESTA, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getTipoRichiesta(), Transazione.model().TIPO_RICHIESTA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().CODICE_RISPOSTA_INGRESSO, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getCodiceRispostaIngresso(), Transazione.model().CODICE_RISPOSTA_INGRESSO.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().CODICE_RISPOSTA_USCITA, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getCodiceRispostaUscita(), Transazione.model().CODICE_RISPOSTA_USCITA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DATA_ACCETTAZIONE_RICHIESTA, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getDataAccettazioneRichiesta(), Transazione.model().DATA_ACCETTAZIONE_RICHIESTA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DATA_INGRESSO_RICHIESTA, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getDataIngressoRichiesta(), Transazione.model().DATA_INGRESSO_RICHIESTA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DATA_INGRESSO_RICHIESTA_STREAM, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getDataIngressoRichiestaStream(), Transazione.model().DATA_INGRESSO_RICHIESTA_STREAM.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DATA_USCITA_RICHIESTA, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getDataUscitaRichiesta(), Transazione.model().DATA_USCITA_RICHIESTA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DATA_USCITA_RICHIESTA_STREAM, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getDataUscitaRichiestaStream(), Transazione.model().DATA_USCITA_RICHIESTA_STREAM.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DATA_ACCETTAZIONE_RISPOSTA, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getDataAccettazioneRisposta(), Transazione.model().DATA_ACCETTAZIONE_RISPOSTA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DATA_INGRESSO_RISPOSTA, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getDataIngressoRisposta(), Transazione.model().DATA_INGRESSO_RISPOSTA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DATA_INGRESSO_RISPOSTA_STREAM, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getDataIngressoRispostaStream(), Transazione.model().DATA_INGRESSO_RISPOSTA_STREAM.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DATA_USCITA_RISPOSTA, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getDataUscitaRisposta(), Transazione.model().DATA_USCITA_RISPOSTA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DATA_USCITA_RISPOSTA_STREAM, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getDataUscitaRispostaStream(), Transazione.model().DATA_USCITA_RISPOSTA_STREAM.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().RICHIESTA_INGRESSO_BYTES, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getRichiestaIngressoBytes(), Transazione.model().RICHIESTA_INGRESSO_BYTES.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().RICHIESTA_USCITA_BYTES, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getRichiestaUscitaBytes(), Transazione.model().RICHIESTA_USCITA_BYTES.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().RISPOSTA_INGRESSO_BYTES, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getRispostaIngressoBytes(), Transazione.model().RISPOSTA_INGRESSO_BYTES.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().RISPOSTA_USCITA_BYTES, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getRispostaUscitaBytes(), Transazione.model().RISPOSTA_USCITA_BYTES.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().PDD_CODICE, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getPddCodice(), Transazione.model().PDD_CODICE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().PDD_TIPO_SOGGETTO, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getPddTipoSoggetto(), Transazione.model().PDD_TIPO_SOGGETTO.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().PDD_NOME_SOGGETTO, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getPddNomeSoggetto(), Transazione.model().PDD_NOME_SOGGETTO.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().PDD_RUOLO, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getPddRuolo(), Transazione.model().PDD_RUOLO.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().FAULT_INTEGRAZIONE, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getFaultIntegrazione(), Transazione.model().FAULT_INTEGRAZIONE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().FORMATO_FAULT_INTEGRAZIONE, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getFormatoFaultIntegrazione(), Transazione.model().FORMATO_FAULT_INTEGRAZIONE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().FAULT_COOPERAZIONE, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getFaultCooperazione(), Transazione.model().FAULT_COOPERAZIONE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().FORMATO_FAULT_COOPERAZIONE, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getFormatoFaultCooperazione(), Transazione.model().FORMATO_FAULT_COOPERAZIONE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TIPO_SOGGETTO_FRUITORE, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getTipoSoggettoFruitore(), Transazione.model().TIPO_SOGGETTO_FRUITORE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().NOME_SOGGETTO_FRUITORE, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getNomeSoggettoFruitore(), Transazione.model().NOME_SOGGETTO_FRUITORE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().IDPORTA_SOGGETTO_FRUITORE, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getIdportaSoggettoFruitore(), Transazione.model().IDPORTA_SOGGETTO_FRUITORE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().INDIRIZZO_SOGGETTO_FRUITORE, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getIndirizzoSoggettoFruitore(), Transazione.model().INDIRIZZO_SOGGETTO_FRUITORE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TIPO_SOGGETTO_EROGATORE, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getTipoSoggettoErogatore(), Transazione.model().TIPO_SOGGETTO_EROGATORE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().NOME_SOGGETTO_EROGATORE, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getNomeSoggettoErogatore(), Transazione.model().NOME_SOGGETTO_EROGATORE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().IDPORTA_SOGGETTO_EROGATORE, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getIdportaSoggettoErogatore(), Transazione.model().IDPORTA_SOGGETTO_EROGATORE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().INDIRIZZO_SOGGETTO_EROGATORE, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getIndirizzoSoggettoErogatore(), Transazione.model().INDIRIZZO_SOGGETTO_EROGATORE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().ID_MESSAGGIO_RICHIESTA, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getIdMessaggioRichiesta(), Transazione.model().ID_MESSAGGIO_RICHIESTA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().ID_MESSAGGIO_RISPOSTA, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getIdMessaggioRisposta(), Transazione.model().ID_MESSAGGIO_RISPOSTA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DATA_ID_MSG_RICHIESTA, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getDataIdMsgRichiesta(), Transazione.model().DATA_ID_MSG_RICHIESTA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DATA_ID_MSG_RISPOSTA, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getDataIdMsgRisposta(), Transazione.model().DATA_ID_MSG_RISPOSTA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().PROFILO_COLLABORAZIONE_OP_2, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getProfiloCollaborazioneOp2(), Transazione.model().PROFILO_COLLABORAZIONE_OP_2.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().PROFILO_COLLABORAZIONE_PROT, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getProfiloCollaborazioneProt(), Transazione.model().PROFILO_COLLABORAZIONE_PROT.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().ID_COLLABORAZIONE, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getIdCollaborazione(), Transazione.model().ID_COLLABORAZIONE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().URI_ACCORDO_SERVIZIO, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getUriAccordoServizio(), Transazione.model().URI_ACCORDO_SERVIZIO.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TIPO_SERVIZIO, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getTipoServizio(), Transazione.model().TIPO_SERVIZIO.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().NOME_SERVIZIO, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getNomeServizio(), Transazione.model().NOME_SERVIZIO.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().VERSIONE_SERVIZIO, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getVersioneServizio(), Transazione.model().VERSIONE_SERVIZIO.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().AZIONE, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getAzione(), Transazione.model().AZIONE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().ID_ASINCRONO, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getIdAsincrono(), Transazione.model().ID_ASINCRONO.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TIPO_SERVIZIO_CORRELATO, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getTipoServizioCorrelato(), Transazione.model().TIPO_SERVIZIO_CORRELATO.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().NOME_SERVIZIO_CORRELATO, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getNomeServizioCorrelato(), Transazione.model().NOME_SERVIZIO_CORRELATO.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().HEADER_PROTOCOLLO_RICHIESTA, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getHeaderProtocolloRichiesta(), Transazione.model().HEADER_PROTOCOLLO_RICHIESTA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DIGEST_RICHIESTA, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getDigestRichiesta(), Transazione.model().DIGEST_RICHIESTA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().PROTOCOLLO_EXT_INFO_RICHIESTA, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getProtocolloExtInfoRichiesta(), Transazione.model().PROTOCOLLO_EXT_INFO_RICHIESTA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().HEADER_PROTOCOLLO_RISPOSTA, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getHeaderProtocolloRisposta(), Transazione.model().HEADER_PROTOCOLLO_RISPOSTA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DIGEST_RISPOSTA, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getDigestRisposta(), Transazione.model().DIGEST_RISPOSTA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().PROTOCOLLO_EXT_INFO_RISPOSTA, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getProtocolloExtInfoRisposta(), Transazione.model().PROTOCOLLO_EXT_INFO_RISPOSTA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TRACCIA_RICHIESTA, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getTracciaRichiesta(), Transazione.model().TRACCIA_RICHIESTA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TRACCIA_RISPOSTA, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getTracciaRisposta(), Transazione.model().TRACCIA_RISPOSTA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DIAGNOSTICI, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getDiagnostici(), Transazione.model().DIAGNOSTICI.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DIAGNOSTICI_LIST_1, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getDiagnosticiList1(), Transazione.model().DIAGNOSTICI_LIST_1.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DIAGNOSTICI_LIST_2, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getDiagnosticiList2(), Transazione.model().DIAGNOSTICI_LIST_2.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DIAGNOSTICI_LIST_EXT, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getDiagnosticiListExt(), Transazione.model().DIAGNOSTICI_LIST_EXT.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DIAGNOSTICI_EXT, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getDiagnosticiExt(), Transazione.model().DIAGNOSTICI_EXT.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().ERROR_LOG, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getErrorLog(), Transazione.model().ERROR_LOG.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().WARNING_LOG, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getWarningLog(), Transazione.model().WARNING_LOG.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().ID_CORRELAZIONE_APPLICATIVA, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getIdCorrelazioneApplicativa(), Transazione.model().ID_CORRELAZIONE_APPLICATIVA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().ID_CORRELAZIONE_APPLICATIVA_RISPOSTA, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getIdCorrelazioneApplicativaRisposta(), Transazione.model().ID_CORRELAZIONE_APPLICATIVA_RISPOSTA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().SERVIZIO_APPLICATIVO_FRUITORE, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getServizioApplicativoFruitore(), Transazione.model().SERVIZIO_APPLICATIVO_FRUITORE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().SERVIZIO_APPLICATIVO_EROGATORE, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getServizioApplicativoErogatore(), Transazione.model().SERVIZIO_APPLICATIVO_EROGATORE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().OPERAZIONE_IM, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getOperazioneIm(), Transazione.model().OPERAZIONE_IM.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().LOCATION_RICHIESTA, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getLocationRichiesta(), Transazione.model().LOCATION_RICHIESTA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().LOCATION_RISPOSTA, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getLocationRisposta(), Transazione.model().LOCATION_RISPOSTA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().NOME_PORTA, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getNomePorta(), Transazione.model().NOME_PORTA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().CREDENZIALI, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getCredenziali(), Transazione.model().CREDENZIALI.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().LOCATION_CONNETTORE, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getLocationConnettore(), Transazione.model().LOCATION_CONNETTORE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().URL_INVOCAZIONE, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getUrlInvocazione(), Transazione.model().URL_INVOCAZIONE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TRASPORTO_MITTENTE, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getTrasportoMittente(), Transazione.model().TRASPORTO_MITTENTE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TOKEN_ISSUER, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getTokenIssuer(), Transazione.model().TOKEN_ISSUER.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TOKEN_CLIENT_ID, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getTokenClientId(), Transazione.model().TOKEN_CLIENT_ID.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TOKEN_SUBJECT, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getTokenSubject(), Transazione.model().TOKEN_SUBJECT.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TOKEN_USERNAME, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getTokenUsername(), Transazione.model().TOKEN_USERNAME.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TOKEN_MAIL, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getTokenMail(), Transazione.model().TOKEN_MAIL.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TOKEN_INFO, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getTokenInfo(), Transazione.model().TOKEN_INFO.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TOKEN_PURPOSE_ID, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getTokenPurposeId(), Transazione.model().TOKEN_PURPOSE_ID.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TOKEN_ID, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getTokenId(), Transazione.model().TOKEN_ID.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TEMPI_ELABORAZIONE, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getTempiElaborazione(), Transazione.model().TEMPI_ELABORAZIONE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DUPLICATI_RICHIESTA, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getDuplicatiRichiesta(), Transazione.model().DUPLICATI_RICHIESTA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().DUPLICATI_RISPOSTA, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getDuplicatiRisposta(), Transazione.model().DUPLICATI_RISPOSTA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().CLUSTER_ID, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getClusterId(), Transazione.model().CLUSTER_ID.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().SOCKET_CLIENT_ADDRESS, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getSocketClientAddress(), Transazione.model().SOCKET_CLIENT_ADDRESS.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TRANSPORT_CLIENT_ADDRESS, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getTransportClientAddress(), Transazione.model().TRANSPORT_CLIENT_ADDRESS.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().CLIENT_ADDRESS, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getClientAddress(), Transazione.model().CLIENT_ADDRESS.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().EVENTI_GESTIONE, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getEventiGestione(), Transazione.model().EVENTI_GESTIONE.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().TIPO_API, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getTipoApi(), Transazione.model().TIPO_API.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().URI_API, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getUriApi(), Transazione.model().URI_API.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(Transazione.model().GRUPPI, false), "?");
        lstObjects_transazione.add(new JDBCObject((Object)transazione.getGruppi(), Transazione.model().GRUPPI.getFieldType()));
        if (transazione.sizeTransazioneExtendedInfoList() > 0) {
            for (TransazioneExtendedInfo transazioneExtedendInfo : transazione.getTransazioneExtendedInfoList()) {
                sqlQueryObjectUpdate.addUpdateField(transazioneExtedendInfo.getNome(), "?");
                lstObjects_transazione.add(new JDBCObject((Object)transazioneExtedendInfo.getValore(), String.class));
            }
        }
        sqlQueryObjectUpdate.addWhereCondition(this.getTransazioneFieldConverter().toColumn(Transazione.model().ID_TRANSAZIONE, false) + "=?");
        lstObjects_transazione.add(new JDBCObject(longIdByLogicId, longIdByLogicId.getClass()));
        if (useDayIntervalForUpdate) {
            Date left = DateUtils.convertToLeftInterval((Date)transazione.getDataIngressoRichiesta(), (UnitaTemporale)UnitaTemporale.GIORNALIERO);
            sqlQueryObjectUpdate.addWhereCondition(this.getTransazioneFieldConverter().toColumn(Transazione.model().DATA_INGRESSO_RICHIESTA, false) + ">=?");
            lstObjects_transazione.add(new JDBCObject((Object)left, left.getClass()));
            Date right = DateUtils.convertToRightInterval((Date)transazione.getDataIngressoRichiesta(), (UnitaTemporale)UnitaTemporale.GIORNALIERO);
            sqlQueryObjectUpdate.addWhereCondition(this.getTransazioneFieldConverter().toColumn(Transazione.model().DATA_INGRESSO_RICHIESTA, false) + "<=?");
            lstObjects_transazione.add(new JDBCObject((Object)right, right.getClass()));
        }
        if (isUpdate_transazione) {
            jdbcUtilities.executeUpdate(sqlQueryObjectUpdate.createSQLUpdate(), jdbcProperties.isShowSql(), lstObjects_transazione.toArray(new JDBCObject[0]));
        }
    }

    public void update(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, Transazione transazione, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        throw new NotImplementedException("Table without long id column PK");
    }

    public static boolean isEfficiente() {
        return efficiente;
    }

    public static void setEfficiente(boolean efficiente) {
        JDBCTransazioneServiceImpl.efficiente = efficiente;
    }

    public void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, String id, UpdateField ... updateFields) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        if (efficiente) {
            this.updateFieldsOptimized(jdbcProperties, log, connection, sqlQueryObject, id, null, updateFields);
        } else {
            GenericJDBCUtilities.updateFields((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)this.getTransazioneFieldConverter().toTable((IModel)Transazione.model()), this.getMapTableToPKColumnEngine(), this.getRootTablePrimaryKeyValuesEngine(jdbcProperties, log, connection, sqlQueryObject, id), (ISQLFieldConverter)this.getTransazioneFieldConverter(), (IJDBCServiceSearchWithId)this, null, (UpdateField[])updateFields);
        }
    }

    public void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, String id, IExpression condition, UpdateField ... updateFields) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        if (efficiente) {
            this.updateFieldsOptimized(jdbcProperties, log, connection, sqlQueryObject, id, condition, updateFields);
        } else {
            GenericJDBCUtilities.updateFields((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)this.getTransazioneFieldConverter().toTable((IModel)Transazione.model()), this.getMapTableToPKColumnEngine(), this.getRootTablePrimaryKeyValuesEngine(jdbcProperties, log, connection, sqlQueryObject, id), (ISQLFieldConverter)this.getTransazioneFieldConverter(), (IJDBCServiceSearchWithId)this, (IExpression)condition, (UpdateField[])updateFields);
        }
    }

    private void updateFieldsOptimized(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, String id, IExpression condition, UpdateField ... updateFields) throws NotFoundException, NotImplementedException, ServiceException, SQLQueryObjectException, ExpressionException, JDBCAdapterException {
        String table = this.getTransazioneFieldConverter().toTable((IModel)Transazione.model());
        ISQLQueryObject sqlQueryObjectUpdate = sqlQueryObject.newSQLQueryObject();
        sqlQueryObjectUpdate.setANDLogicOperator(true);
        sqlQueryObjectUpdate.addUpdateTable(table);
        ArrayList<JDBCObject> lstObjectsUpdate = new ArrayList<JDBCObject>();
        for (UpdateField updateField : updateFields) {
            sqlQueryObjectUpdate.addUpdateField(this.getTransazioneFieldConverter().toColumn(updateField.getField(), false), "?");
            lstObjectsUpdate.add(new JDBCObject(updateField.getValue(), updateField.getField().getFieldType()));
        }
        sqlQueryObjectUpdate.addWhereCondition(this.getTransazioneFieldConverter().toColumn(Transazione.model().ID_TRANSAZIONE, false) + "=?");
        lstObjectsUpdate.add(new JDBCObject((Object)id, id.getClass()));
        if (condition instanceof JDBCExpression) {
            JDBCExpression jdbc = (JDBCExpression)condition;
            ArrayList oggetti = new ArrayList();
            jdbc.toSqlForPreparedStatement(sqlQueryObjectUpdate, oggetti);
            if (!oggetti.isEmpty()) {
                for (Object object : oggetti) {
                    lstObjectsUpdate.add(new JDBCObject(object, object.getClass()));
                }
            }
        }
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        int updateRow = jdbcUtilities.executeUpdate(sqlQueryObjectUpdate.createSQLUpdate(), jdbcProperties.isShowSql(), lstObjectsUpdate.toArray(new JDBCObject[0]));
        String msg = "UpdateField[" + table + "]: " + updateRow + " rows";
        log.debug(msg);
    }

    public void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, String id, UpdateModel ... updateModels) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        GenericJDBCUtilities.updateFields((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)this.getTransazioneFieldConverter().toTable((IModel)Transazione.model()), this.getMapTableToPKColumnEngine(), this.getRootTablePrimaryKeyValuesEngine(jdbcProperties, log, connection, sqlQueryObject, id), (ISQLFieldConverter)this.getTransazioneFieldConverter(), (IJDBCServiceSearchWithId)this, (UpdateModel[])updateModels);
    }

    public void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, UpdateField ... updateFields) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        throw new NotImplementedException("Table without long id column PK");
    }

    public void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, IExpression condition, UpdateField ... updateFields) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        throw new NotImplementedException("Table without long id column PK");
    }

    public void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, UpdateModel ... updateModels) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        throw new NotImplementedException("Table without long id column PK");
    }

    public void updateOrCreate(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, String oldId, Transazione transazione, IDMappingBehaviour idMappingResolutionBehaviour) throws NotImplementedException, ServiceException, Exception {
        if (this.exists(jdbcProperties, log, connection, sqlQueryObject, oldId)) {
            this.update(jdbcProperties, log, connection, sqlQueryObject, oldId, transazione, idMappingResolutionBehaviour);
        } else {
            this.create(jdbcProperties, log, connection, sqlQueryObject, transazione, idMappingResolutionBehaviour);
        }
    }

    public void updateOrCreate(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, Transazione transazione, IDMappingBehaviour idMappingResolutionBehaviour) throws NotImplementedException, ServiceException, Exception {
        throw new NotImplementedException("Table without long id column PK");
    }

    public void delete(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Transazione transazione) throws NotImplementedException, ServiceException, Exception {
        String idObject = transazione.getIdTransazione();
        if (idObject == null) {
            throw new ServiceException("IdTransazione non presente nell'oggetto");
        }
        this.deleteEngine(jdbcProperties, log, connection, sqlQueryObject, idObject);
    }

    private void deleteEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Object id) throws NotImplementedException, ServiceException, Exception {
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ISQLQueryObject sqlQueryObjectDelete = sqlQueryObject.newSQLQueryObject();
        sqlQueryObjectDelete.setANDLogicOperator(true);
        sqlQueryObjectDelete.addDeleteTable(this.getTransazioneFieldConverter().toTable((IModel)Transazione.model()));
        sqlQueryObjectDelete.addWhereCondition(this.getTransazioneFieldConverter().toColumn(Transazione.model().ID_TRANSAZIONE, false) + "=?");
        jdbcUtilities.execute(sqlQueryObjectDelete.createSQLDelete(), jdbcProperties.isShowSql(), new JDBCObject[]{new JDBCObject(id, id.getClass())});
    }

    public void deleteById(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, String idTransazione) throws NotImplementedException, ServiceException, Exception {
        Object id = null;
        try {
            id = this.findIdTransazione(jdbcProperties, log, connection, sqlQueryObject, idTransazione, true, true);
        }
        catch (NotFoundException notFound) {
            return;
        }
        this.deleteEngine(jdbcProperties, log, connection, sqlQueryObject, id);
    }

    public NonNegativeNumber deleteAll(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject) throws NotImplementedException, ServiceException, Exception {
        return this.deleteAll(jdbcProperties, log, connection, sqlQueryObject, new JDBCExpression((ISQLFieldConverter)this.getTransazioneFieldConverter()));
    }

    public NonNegativeNumber deleteAll(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression) throws NotImplementedException, ServiceException, Exception {
        List<Object> lst = this._findAllObjectIds(jdbcProperties, log, connection, sqlQueryObject, new JDBCPaginatedExpression(expression));
        for (Object id : lst) {
            this.deleteEngine(jdbcProperties, log, connection, sqlQueryObject, id);
        }
        return new NonNegativeNumber((long)lst.size());
    }

    public void deleteById(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId) throws ServiceException, NotImplementedException, Exception {
        throw new NotImplementedException("Table without long id column PK");
    }

    public int nativeUpdate(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlObject, String sql, Object ... param) throws ServiceException, NotImplementedException, Exception {
        return GenericJDBCUtilities.nativeUpdate((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlObject, (String)sql, (Object[])param);
    }
}

