/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.statistiche.utils.serializer;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import javax.xml.bind.JAXBElement;
import org.openspcoop2.core.statistiche.Statistica;
import org.openspcoop2.core.statistiche.StatisticaContenuti;
import org.openspcoop2.core.statistiche.StatisticaGiornaliera;
import org.openspcoop2.core.statistiche.StatisticaInfo;
import org.openspcoop2.core.statistiche.StatisticaMensile;
import org.openspcoop2.core.statistiche.StatisticaOraria;
import org.openspcoop2.core.statistiche.StatisticaSettimanale;
import org.openspcoop2.core.statistiche.StatistichePdndTracing;
import org.openspcoop2.generic_project.exception.SerializerException;
import org.openspcoop2.utils.beans.WriteToSerializerType;
import org.openspcoop2.utils.xml.JaxbUtils;

public abstract class AbstractSerializer {
    protected abstract WriteToSerializerType getType();

    protected void _objToXml(OutputStream out, Class<?> c, Object object, boolean prettyPrint) throws Exception {
        if (object instanceof JAXBElement) {
            JaxbUtils.objToXml((OutputStream)out, c, (Object)object, (boolean)prettyPrint);
        } else {
            Method m = c.getMethod("writeTo", OutputStream.class, WriteToSerializerType.class);
            m.invoke(object, out, this.getType());
        }
    }

    protected void objToXml(OutputStream out, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        try {
            this._objToXml(out, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                out.flush();
            }
            catch (Exception exception) {}
        }
    }

    protected void objToXml(String fileName, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        try {
            this.objToXml(new File(fileName), c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
    }

    protected void objToXml(File file, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            this._objToXml(fout, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected ByteArrayOutputStream objToXml(Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            this._objToXml(bout, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (bout != null) {
                    bout.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (bout != null) {
                    bout.close();
                }
            }
            catch (Exception exception) {}
        }
        return bout;
    }

    public void write(String fileName, Statistica statistica) throws SerializerException {
        this.objToXml(fileName, Statistica.class, (Object)statistica, false);
    }

    public void write(String fileName, Statistica statistica, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Statistica.class, (Object)statistica, prettyPrint);
    }

    public void write(File file, Statistica statistica) throws SerializerException {
        this.objToXml(file, Statistica.class, (Object)statistica, false);
    }

    public void write(File file, Statistica statistica, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Statistica.class, (Object)statistica, prettyPrint);
    }

    public void write(OutputStream out, Statistica statistica) throws SerializerException {
        this.objToXml(out, Statistica.class, (Object)statistica, false);
    }

    public void write(OutputStream out, Statistica statistica, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Statistica.class, (Object)statistica, prettyPrint);
    }

    public byte[] toByteArray(Statistica statistica) throws SerializerException {
        return this.objToXml(Statistica.class, statistica, false).toByteArray();
    }

    public byte[] toByteArray(Statistica statistica, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Statistica.class, statistica, prettyPrint).toByteArray();
    }

    public String toString(Statistica statistica) throws SerializerException {
        return this.objToXml(Statistica.class, statistica, false).toString();
    }

    public String toString(Statistica statistica, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Statistica.class, statistica, prettyPrint).toString();
    }

    public void write(String fileName, StatisticaMensile statisticaMensile) throws SerializerException {
        this.objToXml(fileName, StatisticaMensile.class, (Object)statisticaMensile, false);
    }

    public void write(String fileName, StatisticaMensile statisticaMensile, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, StatisticaMensile.class, (Object)statisticaMensile, prettyPrint);
    }

    public void write(File file, StatisticaMensile statisticaMensile) throws SerializerException {
        this.objToXml(file, StatisticaMensile.class, (Object)statisticaMensile, false);
    }

    public void write(File file, StatisticaMensile statisticaMensile, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, StatisticaMensile.class, (Object)statisticaMensile, prettyPrint);
    }

    public void write(OutputStream out, StatisticaMensile statisticaMensile) throws SerializerException {
        this.objToXml(out, StatisticaMensile.class, (Object)statisticaMensile, false);
    }

    public void write(OutputStream out, StatisticaMensile statisticaMensile, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, StatisticaMensile.class, (Object)statisticaMensile, prettyPrint);
    }

    public byte[] toByteArray(StatisticaMensile statisticaMensile) throws SerializerException {
        return this.objToXml(StatisticaMensile.class, statisticaMensile, false).toByteArray();
    }

    public byte[] toByteArray(StatisticaMensile statisticaMensile, boolean prettyPrint) throws SerializerException {
        return this.objToXml(StatisticaMensile.class, statisticaMensile, prettyPrint).toByteArray();
    }

    public String toString(StatisticaMensile statisticaMensile) throws SerializerException {
        return this.objToXml(StatisticaMensile.class, statisticaMensile, false).toString();
    }

    public String toString(StatisticaMensile statisticaMensile, boolean prettyPrint) throws SerializerException {
        return this.objToXml(StatisticaMensile.class, statisticaMensile, prettyPrint).toString();
    }

    public void write(String fileName, StatisticaContenuti statisticaContenuti) throws SerializerException {
        this.objToXml(fileName, StatisticaContenuti.class, (Object)statisticaContenuti, false);
    }

    public void write(String fileName, StatisticaContenuti statisticaContenuti, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, StatisticaContenuti.class, (Object)statisticaContenuti, prettyPrint);
    }

    public void write(File file, StatisticaContenuti statisticaContenuti) throws SerializerException {
        this.objToXml(file, StatisticaContenuti.class, (Object)statisticaContenuti, false);
    }

    public void write(File file, StatisticaContenuti statisticaContenuti, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, StatisticaContenuti.class, (Object)statisticaContenuti, prettyPrint);
    }

    public void write(OutputStream out, StatisticaContenuti statisticaContenuti) throws SerializerException {
        this.objToXml(out, StatisticaContenuti.class, (Object)statisticaContenuti, false);
    }

    public void write(OutputStream out, StatisticaContenuti statisticaContenuti, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, StatisticaContenuti.class, (Object)statisticaContenuti, prettyPrint);
    }

    public byte[] toByteArray(StatisticaContenuti statisticaContenuti) throws SerializerException {
        return this.objToXml(StatisticaContenuti.class, statisticaContenuti, false).toByteArray();
    }

    public byte[] toByteArray(StatisticaContenuti statisticaContenuti, boolean prettyPrint) throws SerializerException {
        return this.objToXml(StatisticaContenuti.class, statisticaContenuti, prettyPrint).toByteArray();
    }

    public String toString(StatisticaContenuti statisticaContenuti) throws SerializerException {
        return this.objToXml(StatisticaContenuti.class, statisticaContenuti, false).toString();
    }

    public String toString(StatisticaContenuti statisticaContenuti, boolean prettyPrint) throws SerializerException {
        return this.objToXml(StatisticaContenuti.class, statisticaContenuti, prettyPrint).toString();
    }

    public void write(String fileName, StatisticaGiornaliera statisticaGiornaliera) throws SerializerException {
        this.objToXml(fileName, StatisticaGiornaliera.class, (Object)statisticaGiornaliera, false);
    }

    public void write(String fileName, StatisticaGiornaliera statisticaGiornaliera, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, StatisticaGiornaliera.class, (Object)statisticaGiornaliera, prettyPrint);
    }

    public void write(File file, StatisticaGiornaliera statisticaGiornaliera) throws SerializerException {
        this.objToXml(file, StatisticaGiornaliera.class, (Object)statisticaGiornaliera, false);
    }

    public void write(File file, StatisticaGiornaliera statisticaGiornaliera, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, StatisticaGiornaliera.class, (Object)statisticaGiornaliera, prettyPrint);
    }

    public void write(OutputStream out, StatisticaGiornaliera statisticaGiornaliera) throws SerializerException {
        this.objToXml(out, StatisticaGiornaliera.class, (Object)statisticaGiornaliera, false);
    }

    public void write(OutputStream out, StatisticaGiornaliera statisticaGiornaliera, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, StatisticaGiornaliera.class, (Object)statisticaGiornaliera, prettyPrint);
    }

    public byte[] toByteArray(StatisticaGiornaliera statisticaGiornaliera) throws SerializerException {
        return this.objToXml(StatisticaGiornaliera.class, statisticaGiornaliera, false).toByteArray();
    }

    public byte[] toByteArray(StatisticaGiornaliera statisticaGiornaliera, boolean prettyPrint) throws SerializerException {
        return this.objToXml(StatisticaGiornaliera.class, statisticaGiornaliera, prettyPrint).toByteArray();
    }

    public String toString(StatisticaGiornaliera statisticaGiornaliera) throws SerializerException {
        return this.objToXml(StatisticaGiornaliera.class, statisticaGiornaliera, false).toString();
    }

    public String toString(StatisticaGiornaliera statisticaGiornaliera, boolean prettyPrint) throws SerializerException {
        return this.objToXml(StatisticaGiornaliera.class, statisticaGiornaliera, prettyPrint).toString();
    }

    public void write(String fileName, StatistichePdndTracing statistichePdndTracing) throws SerializerException {
        this.objToXml(fileName, StatistichePdndTracing.class, (Object)statistichePdndTracing, false);
    }

    public void write(String fileName, StatistichePdndTracing statistichePdndTracing, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, StatistichePdndTracing.class, (Object)statistichePdndTracing, prettyPrint);
    }

    public void write(File file, StatistichePdndTracing statistichePdndTracing) throws SerializerException {
        this.objToXml(file, StatistichePdndTracing.class, (Object)statistichePdndTracing, false);
    }

    public void write(File file, StatistichePdndTracing statistichePdndTracing, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, StatistichePdndTracing.class, (Object)statistichePdndTracing, prettyPrint);
    }

    public void write(OutputStream out, StatistichePdndTracing statistichePdndTracing) throws SerializerException {
        this.objToXml(out, StatistichePdndTracing.class, (Object)statistichePdndTracing, false);
    }

    public void write(OutputStream out, StatistichePdndTracing statistichePdndTracing, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, StatistichePdndTracing.class, (Object)statistichePdndTracing, prettyPrint);
    }

    public byte[] toByteArray(StatistichePdndTracing statistichePdndTracing) throws SerializerException {
        return this.objToXml(StatistichePdndTracing.class, statistichePdndTracing, false).toByteArray();
    }

    public byte[] toByteArray(StatistichePdndTracing statistichePdndTracing, boolean prettyPrint) throws SerializerException {
        return this.objToXml(StatistichePdndTracing.class, statistichePdndTracing, prettyPrint).toByteArray();
    }

    public String toString(StatistichePdndTracing statistichePdndTracing) throws SerializerException {
        return this.objToXml(StatistichePdndTracing.class, statistichePdndTracing, false).toString();
    }

    public String toString(StatistichePdndTracing statistichePdndTracing, boolean prettyPrint) throws SerializerException {
        return this.objToXml(StatistichePdndTracing.class, statistichePdndTracing, prettyPrint).toString();
    }

    public void write(String fileName, StatisticaSettimanale statisticaSettimanale) throws SerializerException {
        this.objToXml(fileName, StatisticaSettimanale.class, (Object)statisticaSettimanale, false);
    }

    public void write(String fileName, StatisticaSettimanale statisticaSettimanale, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, StatisticaSettimanale.class, (Object)statisticaSettimanale, prettyPrint);
    }

    public void write(File file, StatisticaSettimanale statisticaSettimanale) throws SerializerException {
        this.objToXml(file, StatisticaSettimanale.class, (Object)statisticaSettimanale, false);
    }

    public void write(File file, StatisticaSettimanale statisticaSettimanale, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, StatisticaSettimanale.class, (Object)statisticaSettimanale, prettyPrint);
    }

    public void write(OutputStream out, StatisticaSettimanale statisticaSettimanale) throws SerializerException {
        this.objToXml(out, StatisticaSettimanale.class, (Object)statisticaSettimanale, false);
    }

    public void write(OutputStream out, StatisticaSettimanale statisticaSettimanale, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, StatisticaSettimanale.class, (Object)statisticaSettimanale, prettyPrint);
    }

    public byte[] toByteArray(StatisticaSettimanale statisticaSettimanale) throws SerializerException {
        return this.objToXml(StatisticaSettimanale.class, statisticaSettimanale, false).toByteArray();
    }

    public byte[] toByteArray(StatisticaSettimanale statisticaSettimanale, boolean prettyPrint) throws SerializerException {
        return this.objToXml(StatisticaSettimanale.class, statisticaSettimanale, prettyPrint).toByteArray();
    }

    public String toString(StatisticaSettimanale statisticaSettimanale) throws SerializerException {
        return this.objToXml(StatisticaSettimanale.class, statisticaSettimanale, false).toString();
    }

    public String toString(StatisticaSettimanale statisticaSettimanale, boolean prettyPrint) throws SerializerException {
        return this.objToXml(StatisticaSettimanale.class, statisticaSettimanale, prettyPrint).toString();
    }

    public void write(String fileName, StatisticaOraria statisticaOraria) throws SerializerException {
        this.objToXml(fileName, StatisticaOraria.class, (Object)statisticaOraria, false);
    }

    public void write(String fileName, StatisticaOraria statisticaOraria, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, StatisticaOraria.class, (Object)statisticaOraria, prettyPrint);
    }

    public void write(File file, StatisticaOraria statisticaOraria) throws SerializerException {
        this.objToXml(file, StatisticaOraria.class, (Object)statisticaOraria, false);
    }

    public void write(File file, StatisticaOraria statisticaOraria, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, StatisticaOraria.class, (Object)statisticaOraria, prettyPrint);
    }

    public void write(OutputStream out, StatisticaOraria statisticaOraria) throws SerializerException {
        this.objToXml(out, StatisticaOraria.class, (Object)statisticaOraria, false);
    }

    public void write(OutputStream out, StatisticaOraria statisticaOraria, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, StatisticaOraria.class, (Object)statisticaOraria, prettyPrint);
    }

    public byte[] toByteArray(StatisticaOraria statisticaOraria) throws SerializerException {
        return this.objToXml(StatisticaOraria.class, statisticaOraria, false).toByteArray();
    }

    public byte[] toByteArray(StatisticaOraria statisticaOraria, boolean prettyPrint) throws SerializerException {
        return this.objToXml(StatisticaOraria.class, statisticaOraria, prettyPrint).toByteArray();
    }

    public String toString(StatisticaOraria statisticaOraria) throws SerializerException {
        return this.objToXml(StatisticaOraria.class, statisticaOraria, false).toString();
    }

    public String toString(StatisticaOraria statisticaOraria, boolean prettyPrint) throws SerializerException {
        return this.objToXml(StatisticaOraria.class, statisticaOraria, prettyPrint).toString();
    }

    public void write(String fileName, StatisticaInfo statisticaInfo) throws SerializerException {
        this.objToXml(fileName, StatisticaInfo.class, (Object)statisticaInfo, false);
    }

    public void write(String fileName, StatisticaInfo statisticaInfo, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, StatisticaInfo.class, (Object)statisticaInfo, prettyPrint);
    }

    public void write(File file, StatisticaInfo statisticaInfo) throws SerializerException {
        this.objToXml(file, StatisticaInfo.class, (Object)statisticaInfo, false);
    }

    public void write(File file, StatisticaInfo statisticaInfo, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, StatisticaInfo.class, (Object)statisticaInfo, prettyPrint);
    }

    public void write(OutputStream out, StatisticaInfo statisticaInfo) throws SerializerException {
        this.objToXml(out, StatisticaInfo.class, (Object)statisticaInfo, false);
    }

    public void write(OutputStream out, StatisticaInfo statisticaInfo, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, StatisticaInfo.class, (Object)statisticaInfo, prettyPrint);
    }

    public byte[] toByteArray(StatisticaInfo statisticaInfo) throws SerializerException {
        return this.objToXml(StatisticaInfo.class, statisticaInfo, false).toByteArray();
    }

    public byte[] toByteArray(StatisticaInfo statisticaInfo, boolean prettyPrint) throws SerializerException {
        return this.objToXml(StatisticaInfo.class, statisticaInfo, prettyPrint).toByteArray();
    }

    public String toString(StatisticaInfo statisticaInfo) throws SerializerException {
        return this.objToXml(StatisticaInfo.class, statisticaInfo, false).toString();
    }

    public String toString(StatisticaInfo statisticaInfo, boolean prettyPrint) throws SerializerException {
        return this.objToXml(StatisticaInfo.class, statisticaInfo, prettyPrint).toString();
    }
}

