/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.wsdl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Part;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Header;
import javax.wsdl.extensions.soap12.SOAP12HeaderFault;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.Message;
import org.openspcoop2.core.registry.MessagePart;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.constants.BindingStyle;
import org.openspcoop2.core.registry.constants.BindingUse;
import org.openspcoop2.core.registry.constants.CostantiRegistroServizi;
import org.openspcoop2.core.registry.driver.AccordoServizioUtils;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.wsdl.AccordoServizioWrapper;
import org.openspcoop2.core.registry.wsdl.RegistroOpenSPCoopUtilities;
import org.openspcoop2.core.registry.wsdl.WSDLValidator;
import org.openspcoop2.core.registry.wsdl.WSDLValidatorConfig;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.soap.reader.OpenSPCoop2MessageSoapStreamReader;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.utils.wsdl.WSDLUtilities;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.slf4j.Logger;
import org.w3c.dom.Document;

public class AccordoServizioWrapperUtilities {
    private Logger logger = null;
    private RegistroOpenSPCoopUtilities openspcoopUtilities = null;
    private AbstractXMLUtils xmlUtils = null;
    private WSDLUtilities wsdlUtilities = null;
    private AccordoServizioUtils accordoServizioUtils = null;
    private OpenSPCoop2MessageFactory messageFactory;
    private AccordoServizioWrapper accordoServizioWrapper = null;

    public AccordoServizioWrapperUtilities(OpenSPCoop2MessageFactory messageFactory, Logger log) {
        this.logger = log != null ? log : LoggerWrapperFactory.getLogger(AccordoServizioWrapperUtilities.class);
        this.messageFactory = messageFactory;
        this.openspcoopUtilities = new RegistroOpenSPCoopUtilities(this.messageFactory, this.logger);
        this.xmlUtils = MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)this.messageFactory);
        this.wsdlUtilities = WSDLUtilities.getInstance((AbstractXMLUtils)this.xmlUtils);
        this.accordoServizioUtils = new AccordoServizioUtils(this.messageFactory, this.logger);
    }

    public AccordoServizioWrapperUtilities(Logger log, AccordoServizioWrapper accordoServizio) {
        this.logger = log != null ? log : LoggerWrapperFactory.getLogger(AccordoServizioWrapperUtilities.class);
        this.accordoServizioWrapper = accordoServizio;
    }

    public AccordoServizioWrapper getAccordoServizioWrapper() {
        return this.accordoServizioWrapper;
    }

    public void setAccordoServizio(AccordoServizioWrapper accordoServizio) {
        this.accordoServizioWrapper = accordoServizio;
    }

    public void buildSchema(boolean fromBytes) throws DriverRegistroServiziException {
        if (this.accordoServizioWrapper == null) {
            throw new DriverRegistroServiziException("Accordo di Servizio Wrapper non definito, utilizza setAccordoServizioWrapper()");
        }
        if (this.accordoServizioWrapper.getAccordoServizio() == null) {
            throw new DriverRegistroServiziException("Accordo di Servizio OpenSPCoop non definito all'interno dell'Accordo di Servizio Wrapper");
        }
        AccordoServizioParteComune as = this.accordoServizioWrapper.getAccordoServizio();
        this.accordoServizioWrapper.setSchema(this.accordoServizioUtils.buildSchema(as, fromBytes));
    }

    public Definition buildWsdlErogatore() throws DriverRegistroServiziException {
        if (this.accordoServizioWrapper == null) {
            throw new DriverRegistroServiziException("Accordo di Servizio Wrapper non definito, utilizza setAccordoServizioWrapper()");
        }
        if (this.accordoServizioWrapper.getAccordoServizio() == null) {
            throw new DriverRegistroServiziException("Accordo di Servizio OpenSPCoop non definito all'interno dell'Accordo di Servizio Wrapper");
        }
        AccordoServizioParteComune as = this.accordoServizioWrapper.getAccordoServizio();
        if (as.getWsdlLogicoErogatore() == null || "".equals(as.getWsdlLogicoErogatore())) {
            throw new DriverRegistroServiziException("Location del WsdlLogicoErogatore non definito");
        }
        Definition wsdl = this.buildWsdl(as.getWsdlLogicoErogatore());
        if (this.accordoServizioWrapper.getLocationWsdlImplementativoErogatore() != null && !"".equals(this.accordoServizioWrapper.getLocationWsdlImplementativoErogatore())) {
            Definition wsdlImplementativo = this.buildWsdl(this.accordoServizioWrapper.getLocationWsdlImplementativoErogatore());
            this.logger.debug("Add parte implementativa...");
            this.openspcoopUtilities.addParteImplementativa(wsdl, wsdlImplementativo);
        }
        return wsdl;
    }

    public Definition buildWsdlFruitore() throws DriverRegistroServiziException {
        if (this.accordoServizioWrapper == null) {
            throw new DriverRegistroServiziException("Accordo di Servizio non definito, utilizza setAccordoServizio()");
        }
        if (this.accordoServizioWrapper.getAccordoServizio() == null) {
            throw new DriverRegistroServiziException("Accordo di Servizio OpenSPCoop non definito all'interno dell'Accordo di Servizio Wrapper");
        }
        AccordoServizioParteComune as = this.accordoServizioWrapper.getAccordoServizio();
        if (as.getWsdlLogicoFruitore() == null || "".equals(as.getWsdlLogicoFruitore())) {
            throw new DriverRegistroServiziException("Location del WsdlLogicoFruitore non definito, utilizza setLocationWsdlLogicoFruitore(String)");
        }
        Definition wsdl = this.buildWsdl(as.getWsdlLogicoFruitore());
        if (this.accordoServizioWrapper.getLocationWsdlImplementativoFruitore() != null && !"".equals(this.accordoServizioWrapper.getLocationWsdlImplementativoFruitore())) {
            Definition wsdlImplementativo = this.buildWsdl(this.accordoServizioWrapper.getLocationWsdlImplementativoFruitore());
            this.logger.debug("Add parte implementativa...");
            this.openspcoopUtilities.addParteImplementativa(wsdl, wsdlImplementativo);
        }
        return wsdl;
    }

    public Definition buildWsdlErogatoreFromBytes() throws DriverRegistroServiziException {
        if (this.accordoServizioWrapper == null) {
            throw new DriverRegistroServiziException("Accordo di Servizio non definito, utilizza setAccordoServizio()");
        }
        if (this.accordoServizioWrapper.getAccordoServizio() == null) {
            throw new DriverRegistroServiziException("Accordo di Servizio OpenSPCoop non definito all'interno dell'Accordo di Servizio Wrapper");
        }
        AccordoServizioParteComune as = this.accordoServizioWrapper.getAccordoServizio();
        Definition wsdl = this.openspcoopUtilities.buildWsdlFromObjects(as, this.accordoServizioWrapper.getBytesWsdlImplementativoErogatore(), true);
        return wsdl;
    }

    public Definition buildWsdlFruitoreFromBytes() throws DriverRegistroServiziException {
        if (this.accordoServizioWrapper == null) {
            throw new DriverRegistroServiziException("Accordo di Servizio non definito, utilizza setAccordoServizio()");
        }
        if (this.accordoServizioWrapper.getAccordoServizio() == null) {
            throw new DriverRegistroServiziException("Accordo di Servizio OpenSPCoop non definito all'interno dell'Accordo di Servizio Wrapper");
        }
        AccordoServizioParteComune as = this.accordoServizioWrapper.getAccordoServizio();
        Definition wsdl = this.openspcoopUtilities.buildWsdlFromObjects(as, this.accordoServizioWrapper.getBytesWsdlImplementativoFruitore(), false);
        return wsdl;
    }

    private Definition buildWsdl(String url) throws DriverRegistroServiziException {
        try {
            Document document = null;
            document = url.startsWith("http://") || url.startsWith("file://") ? this.xmlUtils.newDocument(HttpUtilities.requestHTTPFile((String)url)) : this.xmlUtils.newDocument(FileSystemUtilities.readBytesFromFile((String)url));
            this.wsdlUtilities.removeSchemiIntoTypes(document);
            this.wsdlUtilities.removeImports(document);
            Definition wsdl = this.wsdlUtilities.readWSDLFromDocument(document);
            return wsdl;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante la costruzione del wsdl [" + url + "]: " + e.getMessage(), e);
        }
    }

    public static void addMessageInputOperation(javax.wsdl.Operation operationWSDL, Logger logger, Operation operationAS, HashMap<String, QName> mapPartQName) {
        if (operationWSDL.getInput() != null && operationWSDL.getInput().getMessage() != null && operationWSDL.getInput().getMessage().getParts() != null) {
            QName nameMesssage = operationWSDL.getInput().getMessage().getQName();
            Map argumentsOperationInput = operationWSDL.getInput().getMessage().getParts();
            if (argumentsOperationInput != null && argumentsOperationInput.size() > 0) {
                Message mInputAS = new Message();
                Iterator argumentsIterator = argumentsOperationInput.values().iterator();
                while (argumentsIterator.hasNext()) {
                    String namespace;
                    String name;
                    MessagePart partAS = new MessagePart();
                    Part argument = (Part)argumentsIterator.next();
                    partAS.setName(argument.getName());
                    if (argument.getElementName() != null) {
                        name = argument.getElementName().getLocalPart();
                        namespace = argument.getElementName().getNamespaceURI();
                        partAS.setElementName(name);
                        partAS.setElementNamespace(namespace);
                    }
                    if (argument.getTypeName() != null) {
                        name = argument.getTypeName().getLocalPart();
                        namespace = argument.getTypeName().getNamespaceURI();
                        partAS.setTypeName(name);
                        partAS.setTypeNamespace(namespace);
                    }
                    if (nameMesssage != null) {
                        mapPartQName.put(partAS.getName(), nameMesssage);
                    }
                    mInputAS.addPart(partAS);
                    logger.debug("add message input dell'operation[" + operationWSDL.getName() + "] con name [" + partAS.getName() + "] element-info({" + partAS.getElementNamespace() + "}" + partAS.getElementName() + ") type-info({" + partAS.getTypeNamespace() + "}" + partAS.getTypeName() + ")");
                }
                operationAS.setMessageInput(mInputAS);
            }
        }
    }

    public static void addMessageOutputOperation(javax.wsdl.Operation operationWSDL, Logger logger, Operation operationAS, HashMap<String, QName> mapPartQName) {
        if (operationWSDL.getOutput() != null && operationWSDL.getOutput().getMessage() != null && operationWSDL.getOutput().getMessage().getParts() != null) {
            QName nameMesssage = operationWSDL.getOutput().getMessage().getQName();
            Map argumentsOperationOutput = operationWSDL.getOutput().getMessage().getParts();
            if (argumentsOperationOutput != null && argumentsOperationOutput.size() > 0) {
                Message mOutputAS = new Message();
                Iterator argumentsIterator = argumentsOperationOutput.values().iterator();
                while (argumentsIterator.hasNext()) {
                    String namespace;
                    String name;
                    MessagePart partAS = new MessagePart();
                    Part argument = (Part)argumentsIterator.next();
                    partAS.setName(argument.getName());
                    if (argument.getElementName() != null) {
                        name = argument.getElementName().getLocalPart();
                        namespace = argument.getElementName().getNamespaceURI();
                        partAS.setElementName(name);
                        partAS.setElementNamespace(namespace);
                    }
                    if (argument.getTypeName() != null) {
                        name = argument.getTypeName().getLocalPart();
                        namespace = argument.getTypeName().getNamespaceURI();
                        partAS.setTypeName(name);
                        partAS.setTypeNamespace(namespace);
                    }
                    if (nameMesssage != null) {
                        mapPartQName.put(partAS.getName(), nameMesssage);
                    }
                    mOutputAS.addPart(partAS);
                    logger.debug("add message output dell'operation[" + operationWSDL.getName() + "] con name [" + partAS.getName() + "] element-info({" + partAS.getElementNamespace() + "}" + partAS.getElementName() + ") type-info({" + partAS.getTypeNamespace() + "}" + partAS.getTypeName() + ")");
                }
                operationAS.setMessageOutput(mOutputAS);
            }
        }
    }

    public static void setPortTypeSoapBindingStyle(Binding bindingWSDL, Logger logger, PortType ptAS) {
        String nomePortType = ptAS.getNome();
        List extendibleElements = bindingWSDL.getExtensibilityElements();
        if (extendibleElements != null) {
            logger.debug("esamino binding extendibles [" + extendibleElements.size() + "] per port type: [" + nomePortType + "]");
            for (int i = 0; i < extendibleElements.size(); ++i) {
                SOAPBinding soapBinding;
                ExtensibilityElement elem = (ExtensibilityElement)extendibleElements.get(i);
                logger.debug("esamino binding extendibles di tipo:" + elem.getClass().getName() + " instance of SOAPBinding:" + (elem instanceof SOAPBinding));
                if (elem instanceof SOAPBinding) {
                    soapBinding = (SOAPBinding)elem;
                    ptAS.setStyle(BindingStyle.toEnumConstant(soapBinding.getStyle()));
                    logger.debug("add style port type [" + nomePortType + "]: " + soapBinding.getStyle());
                    continue;
                }
                if (!(elem instanceof SOAP12Binding)) continue;
                soapBinding = (SOAP12Binding)elem;
                ptAS.setStyle(BindingStyle.toEnumConstant(soapBinding.getStyle()));
                logger.debug("add style port type [" + nomePortType + "]: " + soapBinding.getStyle());
            }
        }
    }

    public static void setOperationSoapBindingInformation(BindingOperation bindingOperation, Logger logger, Operation operationAS, PortType ptAS) {
        String nomeOperation = operationAS.getNome();
        String nomePortType = ptAS.getNome();
        List extendibleElementsOperations = bindingOperation.getExtensibilityElements();
        if (extendibleElementsOperations != null) {
            logger.debug("esamino binding extendibles [" + extendibleElementsOperations.size() + "] per azione[" + nomeOperation + "] del port type[" + nomePortType + "]");
            for (int j = 0; j < extendibleElementsOperations.size(); ++j) {
                SOAPOperation soapOperation;
                ExtensibilityElement elem = (ExtensibilityElement)extendibleElementsOperations.get(j);
                logger.debug("esamino binding extendibles di tipo:" + elem.getClass().getName() + " instance of SOAPOperation:" + (elem instanceof SOAPOperation));
                if (elem instanceof SOAPOperation) {
                    soapOperation = (SOAPOperation)elem;
                    operationAS.setStyle(BindingStyle.toEnumConstant(soapOperation.getStyle()));
                    logger.debug("add style Operation [" + nomeOperation + "] del Port type [" + ptAS.getNome() + "]: " + soapOperation.getStyle());
                    operationAS.setSoapAction(soapOperation.getSoapActionURI());
                    logger.debug("add SOAPAction Operation [" + nomeOperation + "] del Port type [" + ptAS.getNome() + "]: " + soapOperation.getSoapActionURI());
                    continue;
                }
                if (!(elem instanceof SOAP12Operation)) continue;
                soapOperation = (SOAP12Operation)elem;
                operationAS.setStyle(BindingStyle.toEnumConstant(soapOperation.getStyle()));
                logger.debug("add style Operation [" + nomeOperation + "] del Port type [" + ptAS.getNome() + "]: " + soapOperation.getStyle());
                operationAS.setSoapAction(soapOperation.getSoapActionURI());
                logger.debug("add SOAPAction Operation [" + nomeOperation + "] del Port type [" + ptAS.getNome() + "]: " + soapOperation.getSoapActionURI());
            }
        }
    }

    public static void setMessageInputSoapBindingInformation(BindingOperation bindingOperation, Logger logger, Operation operationAS, PortType ptAS, HashMap<String, QName> mapPartQName, String wsdlTargetNamespace) {
        List extendibleElementsMessageInput;
        String nomeOperation = operationAS.getNome();
        String nomePortType = ptAS.getNome();
        BindingInput bindingInput = bindingOperation.getBindingInput();
        if (bindingInput != null && (extendibleElementsMessageInput = bindingInput.getExtensibilityElements()) != null) {
            logger.debug("esamino binding extendibles [" + extendibleElementsMessageInput.size() + "] per message-input dell'azione[" + nomeOperation + "] del port type[" + nomePortType + "]");
            for (int j = 0; j < extendibleElementsMessageInput.size(); ++j) {
                ExtensibilityElement elem = (ExtensibilityElement)extendibleElementsMessageInput.get(j);
                logger.debug("esamino binding extendibles di tipo:" + elem.getClass().getName() + " instance of SOAPBody:" + (elem instanceof SOAPBody));
                AccordoServizioWrapperUtilities.setPartMessageSoapBindingOperationInfo(elem, logger, operationAS, ptAS, true, operationAS.getMessageInput(), mapPartQName, wsdlTargetNamespace);
            }
        }
    }

    public static void setMessageOutputSoapBindingInformation(BindingOperation bindingOperation, Logger logger, Operation operationAS, PortType ptAS, HashMap<String, QName> mapPartQName, String wsdlTargetNamespace) {
        List extendibleElementsMessageOutput;
        String nomeOperation = operationAS.getNome();
        String nomePortType = ptAS.getNome();
        BindingOutput bindingOutput = bindingOperation.getBindingOutput();
        if (bindingOutput != null && (extendibleElementsMessageOutput = bindingOutput.getExtensibilityElements()) != null) {
            logger.debug("esamino binding extendibles [" + extendibleElementsMessageOutput.size() + "] per message-output dell'azione[" + nomeOperation + "] del port type[" + nomePortType + "]");
            for (int j = 0; j < extendibleElementsMessageOutput.size(); ++j) {
                ExtensibilityElement elem = (ExtensibilityElement)extendibleElementsMessageOutput.get(j);
                logger.debug("esamino binding extendibles di tipo:" + elem.getClass().getName() + " instance of SOAPBody:" + (elem instanceof SOAPBody));
                AccordoServizioWrapperUtilities.setPartMessageSoapBindingOperationInfo(elem, logger, operationAS, ptAS, false, operationAS.getMessageOutput(), mapPartQName, wsdlTargetNamespace);
            }
        }
    }

    public static void setPartMessageSoapBindingOperationInfo(ExtensibilityElement elem, Logger logger, Operation operationAS, PortType ptAS, boolean inputMessage, Message message, HashMap<String, QName> mapPartQName, String wsdlTargetNamespace) {
        block21: {
            block26: {
                block25: {
                    String tipoMessage;
                    String nomeOperation;
                    block24: {
                        block23: {
                            block22: {
                                nomeOperation = operationAS.getNome();
                                tipoMessage = "message-input";
                                if (!inputMessage) {
                                    tipoMessage = "message-output";
                                }
                                if (!(elem instanceof SOAPBody)) break block22;
                                SOAPBody soapBody = (SOAPBody)elem;
                                message.setUse(BindingUse.toEnumConstant(soapBody.getUse()));
                                if (soapBody.getNamespaceURI() != null) {
                                    message.setSoapNamespace(soapBody.getNamespaceURI());
                                } else {
                                    message.setSoapNamespace(wsdlTargetNamespace);
                                }
                                StringBuilder bf = new StringBuilder();
                                List listParts = soapBody.getParts();
                                if (listParts != null) {
                                    for (Object part : listParts) {
                                        if (bf.length() > 0) {
                                            bf.append(",");
                                        }
                                        bf.append(part);
                                    }
                                }
                                logger.debug("add use " + tipoMessage + " Operation [" + nomeOperation + "] (parts:" + bf.toString() + ") del Port type [" + ptAS.getNome() + "]: " + soapBody.getUse());
                                break block21;
                            }
                            if (!(elem instanceof SOAPHeader)) break block23;
                            SOAPHeader soapHeader = (SOAPHeader)elem;
                            String part = soapHeader.getPart();
                            QName messageQName = soapHeader.getMessage();
                            if (part == null || message.sizePartList() <= 0) break block21;
                            for (int i = 0; i < message.sizePartList(); ++i) {
                                if (!part.equals(message.getPart(i).getName())) continue;
                                if (messageQName != null && mapPartQName != null && mapPartQName.size() > 0) {
                                    if (!mapPartQName.containsKey(part)) continue;
                                    QName qname = mapPartQName.get(part);
                                    if (!messageQName.toString().equals(qname.toString())) continue;
                                }
                                message.removePart(i);
                                break block21;
                            }
                            break block21;
                        }
                        if (!(elem instanceof SOAPHeaderFault)) break block24;
                        SOAPHeaderFault soapHeaderFault = (SOAPHeaderFault)elem;
                        String part = soapHeaderFault.getPart();
                        QName messageQName = soapHeaderFault.getMessage();
                        if (part == null || message.sizePartList() <= 0) break block21;
                        for (int i = 0; i < message.sizePartList(); ++i) {
                            if (!part.equals(message.getPart(i).getName())) continue;
                            if (messageQName != null && mapPartQName != null && mapPartQName.size() > 0) {
                                if (!mapPartQName.containsKey(part)) continue;
                                QName qname = mapPartQName.get(part);
                                if (!messageQName.toString().equals(qname.toString())) continue;
                            }
                            message.removePart(i);
                            break block21;
                        }
                        break block21;
                    }
                    if (!(elem instanceof SOAP12Body)) break block25;
                    SOAP12Body soapBody = (SOAP12Body)elem;
                    message.setUse(BindingUse.toEnumConstant(soapBody.getUse()));
                    if (soapBody.getNamespaceURI() != null) {
                        message.setSoapNamespace(soapBody.getNamespaceURI());
                    } else {
                        message.setSoapNamespace(wsdlTargetNamespace);
                    }
                    StringBuilder bf = new StringBuilder();
                    List listParts = soapBody.getParts();
                    if (listParts != null) {
                        for (Object part : listParts) {
                            if (bf.length() > 0) {
                                bf.append(",");
                            }
                            bf.append(part);
                        }
                    }
                    logger.debug("add use " + tipoMessage + " Operation [" + nomeOperation + "] (parts:" + bf.toString() + ") del Port type [" + ptAS.getNome() + "]: " + soapBody.getUse());
                    break block21;
                }
                if (!(elem instanceof SOAP12Header)) break block26;
                SOAP12Header soapHeader = (SOAP12Header)elem;
                String part = soapHeader.getPart();
                QName messageQName = soapHeader.getMessage();
                if (part == null || message.sizePartList() <= 0) break block21;
                for (int i = 0; i < message.sizePartList(); ++i) {
                    if (!part.equals(message.getPart(i).getName())) continue;
                    if (messageQName != null && mapPartQName != null && mapPartQName.size() > 0) {
                        if (!mapPartQName.containsKey(part)) continue;
                        QName qname = mapPartQName.get(part);
                        if (!messageQName.toString().equals(qname.toString())) continue;
                    }
                    message.removePart(i);
                    break block21;
                }
                break block21;
            }
            if (elem instanceof SOAP12HeaderFault) {
                SOAP12HeaderFault soapHeaderFault = (SOAP12HeaderFault)elem;
                String part = soapHeaderFault.getPart();
                QName messageQName = soapHeaderFault.getMessage();
                if (part != null && message.sizePartList() > 0) {
                    for (int i = 0; i < message.sizePartList(); ++i) {
                        if (!part.equals(message.getPart(i).getName())) continue;
                        if (messageQName != null && mapPartQName != null && mapPartQName.size() > 0) {
                            if (!mapPartQName.containsKey(part)) continue;
                            QName qname = mapPartQName.get(part);
                            if (!messageQName.toString().equals(qname.toString())) continue;
                        }
                        message.removePart(i);
                        break;
                    }
                }
            }
        }
    }

    public void buildAccordoServizioWrapperFromWsdl(Definition wsdl, boolean readParteImplementativa) throws DriverRegistroServiziException {
        try {
            if (this.accordoServizioWrapper == null) {
                this.accordoServizioWrapper = new AccordoServizioWrapper();
            }
            this.accordoServizioWrapper.setPortTypesLoadedFromWSDL(true);
            javax.wsdl.PortType portTypeWSDL = null;
            Map portTypes = wsdl.getPortTypes();
            if (portTypes == null || portTypes.size() <= 0) {
                throw new DriverRegistroServiziException("Port types non presenti");
            }
            Iterator portTypeIterator = portTypes.values().iterator();
            HashMap<String, HashMap<String, QName>> mapOperationTo_mapPartQName_input = new HashMap<String, HashMap<String, QName>>();
            HashMap<String, HashMap<String, QName>> mapOperationTo_mapPartQName_output = new HashMap<String, HashMap<String, QName>>();
            while (portTypeIterator.hasNext()) {
                portTypeWSDL = (javax.wsdl.PortType)portTypeIterator.next();
                PortType ptAS = new PortType();
                ptAS.setNome(portTypeWSDL.getQName().getLocalPart());
                this.logger.debug("add port type: [" + portTypeWSDL.getQName().getLocalPart() + "]");
                List operations = portTypeWSDL.getOperations();
                if (operations == null || operations.size() <= 0) {
                    throw new DriverRegistroServiziException("operations per il port type [" + ptAS.getNome() + "] non presenti");
                }
                for (int opIndex = 0; opIndex < operations.size(); ++opIndex) {
                    javax.wsdl.Operation operationWSDL = (javax.wsdl.Operation)operations.get(opIndex);
                    Operation operationAS = new Operation();
                    operationAS.setNome(operationWSDL.getName());
                    this.logger.debug("add operation: [" + operationWSDL.getName() + "]");
                    HashMap<String, QName> mapPartQName_input = new HashMap<String, QName>();
                    mapOperationTo_mapPartQName_input.put(operationAS.getNome(), mapPartQName_input);
                    AccordoServizioWrapperUtilities.addMessageInputOperation(operationWSDL, this.logger, operationAS, mapPartQName_input);
                    HashMap<String, QName> mapPartQName_output = new HashMap<String, QName>();
                    mapOperationTo_mapPartQName_output.put(operationAS.getNome(), mapPartQName_output);
                    AccordoServizioWrapperUtilities.addMessageOutputOperation(operationWSDL, this.logger, operationAS, mapPartQName_output);
                    ptAS.addAzione(operationAS);
                }
                this.accordoServizioWrapper.addPortType(ptAS);
            }
            if (readParteImplementativa) {
                Map bindings = wsdl.getAllBindings();
                if (bindings == null || bindings.size() <= 0) {
                    throw new DriverRegistroServiziException("bindings non presenti");
                }
                this.logger.debug("bindings presenti [" + bindings.size() + "]");
                Binding bindingWSDL2 = null;
                for (Binding bindingWSDL2 : bindings.values()) {
                    if (bindingWSDL2.getPortType() == null) {
                        throw new DriverRegistroServiziException("Un errore \u00e8 avvenuto durante l'analisi del binding '" + bindingWSDL2.getQName() + "': port type non definito o non esistente");
                    }
                    String nomePortType = bindingWSDL2.getPortType().getQName().getLocalPart();
                    PortType ptAS = this.accordoServizioWrapper.removePortType(nomePortType);
                    if (ptAS == null) {
                        throw new DriverRegistroServiziException("Port type [" + nomePortType + "] non presente, nella lista dei port type, durante l'analisi della parte di binding");
                    }
                    this.logger.debug("esamino binding per port type: [" + nomePortType + "]");
                    AccordoServizioWrapperUtilities.setPortTypeSoapBindingStyle(bindingWSDL2, this.logger, ptAS);
                    List bindingsOperation = bindingWSDL2.getBindingOperations();
                    if (bindingsOperation == null || bindingsOperation.size() <= 0) {
                        throw new DriverRegistroServiziException("Bindings operations per il port type [" + ptAS.getNome() + "] non presenti");
                    }
                    for (int i = 0; i < bindingsOperation.size(); ++i) {
                        BindingOperation bindingOperation = (BindingOperation)bindingsOperation.get(i);
                        String nomeOperation = bindingOperation.getName();
                        Operation operationAS = null;
                        for (int j = 0; j < ptAS.sizeAzioneList(); ++j) {
                            if (!nomeOperation.equals(ptAS.getAzione(j).getNome())) continue;
                            operationAS = ptAS.removeAzione(j);
                            ++j;
                        }
                        if (operationAS == null) {
                            throw new DriverRegistroServiziException("Operation [" + nomeOperation + "] del Port type [" + ptAS.getNome() + "] non presente, nella lista delle operation, durante l'analisi della parte di binding");
                        }
                        AccordoServizioWrapperUtilities.setOperationSoapBindingInformation(bindingOperation, this.logger, operationAS, ptAS);
                        AccordoServizioWrapperUtilities.setMessageInputSoapBindingInformation(bindingOperation, this.logger, operationAS, ptAS, (HashMap)mapOperationTo_mapPartQName_input.get(operationAS.getNome()), wsdl.getTargetNamespace());
                        AccordoServizioWrapperUtilities.setMessageOutputSoapBindingInformation(bindingOperation, this.logger, operationAS, ptAS, (HashMap)mapOperationTo_mapPartQName_output.get(operationAS.getNome()), wsdl.getTargetNamespace());
                        ptAS.addAzione(operationAS);
                    }
                    this.accordoServizioWrapper.addPortType(ptAS);
                }
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante la lettura del wsdl: " + e.getMessage(), e);
        }
    }

    public void buildAccordoServizioWrapperFromOpenSPCoopAS(AccordoServizioParteComune as) throws DriverRegistroServiziException {
        if (this.accordoServizioWrapper == null) {
            this.accordoServizioWrapper = new AccordoServizioWrapper();
        }
        this.accordoServizioWrapper.setPortTypesLoadedFromWSDL(false);
        for (int i = 0; i < as.sizePortTypeList(); ++i) {
            this.accordoServizioWrapper.addPortType(as.getPortType(i));
        }
    }

    public String searchOperationName(boolean isRichiesta, String portType, OpenSPCoop2Message messageParam, OpenSPCoop2MessageSoapStreamReader soapStreamReaderParam, WSDLValidatorConfig config) throws DriverRegistroServiziException {
        try {
            Operation op;
            int j;
            if (this.accordoServizioWrapper == null) {
                throw new DriverRegistroServiziException("Accordo Servizio Wrapper non definito");
            }
            if (messageParam == null && soapStreamReaderParam == null) {
                throw new DriverRegistroServiziException("Messaggio non fornito");
            }
            if (messageParam != null && !ServiceBinding.SOAP.equals((Object)messageParam.getServiceBinding())) {
                throw new DriverRegistroServiziException("Tipologia REST non supportata");
            }
            OpenSPCoop2MessageSoapStreamReader soapStreamReader = null;
            soapStreamReader = soapStreamReaderParam != null ? soapStreamReaderParam : messageParam.castAsSoap().getSoapReader();
            if (soapStreamReader != null && !soapStreamReader.isParsingComplete()) {
                soapStreamReader = null;
            }
            String rootElementLocalName = null;
            String rootElementNamespace = null;
            if (soapStreamReader != null) {
                rootElementLocalName = soapStreamReader.getRootElementLocalName();
                rootElementNamespace = soapStreamReader.getRootElementNamespace();
            }
            if (rootElementLocalName != null) {
                for (int i = 0; i < this.accordoServizioWrapper.sizePortTypeList(); ++i) {
                    PortType pt = this.accordoServizioWrapper.getPortType(i);
                    if (portType != null && !pt.getNome().equals(portType)) continue;
                    BindingStyle style = CostantiRegistroServizi.WSDL_STYLE_DOCUMENT;
                    BindingUse use = CostantiRegistroServizi.WSDL_USE_LITERAL;
                    if (pt.getStyle() != null && !"".equals(pt.getStyle().getValue()) && CostantiRegistroServizi.WSDL_STYLE_RPC.equals(pt.getStyle())) {
                        style = CostantiRegistroServizi.WSDL_STYLE_RPC;
                    }
                    for (j = 0; j < pt.sizeAzioneList(); ++j) {
                        op = pt.getAzione(j);
                        try {
                            Message argumentsOperation;
                            Message message = argumentsOperation = isRichiesta ? op.getMessageInput() : op.getMessageOutput();
                            if (op.getStyle() != null && !"".equals(op.getStyle().getValue())) {
                                if (CostantiRegistroServizi.WSDL_STYLE_RPC.equals(op.getStyle())) {
                                    style = CostantiRegistroServizi.WSDL_STYLE_RPC;
                                } else if (CostantiRegistroServizi.WSDL_STYLE_DOCUMENT.equals(op.getStyle())) {
                                    style = CostantiRegistroServizi.WSDL_STYLE_DOCUMENT;
                                }
                            }
                            if (argumentsOperation != null && argumentsOperation.getUse() != null && !"".equals(argumentsOperation.getUse().getValue()) && CostantiRegistroServizi.WSDL_USE_ENCODED.equals(argumentsOperation.getUse())) {
                                use = CostantiRegistroServizi.WSDL_USE_ENCODED;
                            }
                            if (CostantiRegistroServizi.WSDL_STYLE_DOCUMENT.equals(style) && CostantiRegistroServizi.WSDL_USE_LITERAL.equals(use) && argumentsOperation != null && argumentsOperation.sizePartList() == 1) {
                                MessagePart part = argumentsOperation.getPart(0);
                                if (part == null || part.getElementName() == null) continue;
                                boolean match = part.getElementName().equals(rootElementLocalName);
                                if (match) {
                                    if (part.getElementNamespace() == null) {
                                        if (rootElementNamespace != null) {
                                            match = false;
                                        }
                                    } else if (!part.getElementNamespace().equals(rootElementNamespace)) {
                                        match = false;
                                    }
                                }
                                if (!match) continue;
                                return op.getNome();
                            }
                            if (!CostantiRegistroServizi.WSDL_STYLE_RPC.equals(style) || !rootElementLocalName.equals(op.getNome())) continue;
                            boolean match = true;
                            if (argumentsOperation != null && argumentsOperation.getSoapNamespace() == null) {
                                if (rootElementNamespace != null) {
                                    match = false;
                                }
                            } else if (argumentsOperation != null && !argumentsOperation.getSoapNamespace().equals(rootElementNamespace)) {
                                if (rootElementNamespace == null || StringUtils.isEmpty((String)rootElementNamespace)) {
                                    if (config != null && !config.isRpcAcceptRootElementUnqualified()) {
                                        match = false;
                                    }
                                } else {
                                    match = false;
                                }
                            }
                            if (!match) continue;
                            return op.getNome();
                        }
                        catch (Exception e) {
                            this.logger.debug("@@@searchOperationName Azione [" + op.getNome() + "] mismatch rootElement[" + rootElementLocalName + "] namespace[" + rootElementNamespace + "]: " + e.getMessage());
                        }
                    }
                }
            }
            if (messageParam != null) {
                boolean addPrefixError = true;
                WSDLValidator wsdlValidator = new WSDLValidator(messageParam, this.xmlUtils, this.accordoServizioWrapper, this.logger, config, addPrefixError, false, null);
                for (int i = 0; i < this.accordoServizioWrapper.sizePortTypeList(); ++i) {
                    PortType pt = this.accordoServizioWrapper.getPortType(i);
                    if (portType != null && !pt.getNome().equals(portType)) continue;
                    for (j = 0; j < pt.sizeAzioneList(); ++j) {
                        op = pt.getAzione(j);
                        try {
                            wsdlValidator.wsdlConformanceCheck(isRichiesta, null, op.getNome(), false, true);
                            return op.getNome();
                        }
                        catch (Exception e) {
                            this.logger.debug("@@@searchOperationName Azione [" + op.getNome() + "] mismatch: " + e.getMessage());
                            continue;
                        }
                    }
                }
            }
            return null;
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
    }
}

