/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.utils.serializer;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import javax.xml.bind.JAXBElement;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoCooperazionePartecipanti;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteComuneServizioComposto;
import org.openspcoop2.core.registry.AccordoServizioParteComuneServizioCompostoServizioComponente;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Azione;
import org.openspcoop2.core.registry.ConfigurazioneServizio;
import org.openspcoop2.core.registry.ConfigurazioneServizioAzione;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.CredenzialiSoggetto;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.GruppiAccordo;
import org.openspcoop2.core.registry.Gruppo;
import org.openspcoop2.core.registry.GruppoAccordo;
import org.openspcoop2.core.registry.IdAccordoCooperazione;
import org.openspcoop2.core.registry.IdAccordoServizioParteComune;
import org.openspcoop2.core.registry.IdAccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.IdGruppo;
import org.openspcoop2.core.registry.IdPortaDominio;
import org.openspcoop2.core.registry.IdRuolo;
import org.openspcoop2.core.registry.IdScope;
import org.openspcoop2.core.registry.IdSoggetto;
import org.openspcoop2.core.registry.Message;
import org.openspcoop2.core.registry.MessagePart;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.Property;
import org.openspcoop2.core.registry.Proprieta;
import org.openspcoop2.core.registry.ProprietaOggetto;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.RegistroServizi;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.ResourceParameter;
import org.openspcoop2.core.registry.ResourceRepresentation;
import org.openspcoop2.core.registry.ResourceRepresentationJson;
import org.openspcoop2.core.registry.ResourceRepresentationXml;
import org.openspcoop2.core.registry.ResourceRequest;
import org.openspcoop2.core.registry.ResourceResponse;
import org.openspcoop2.core.registry.RuoliSoggetto;
import org.openspcoop2.core.registry.Ruolo;
import org.openspcoop2.core.registry.RuoloSoggetto;
import org.openspcoop2.core.registry.Scope;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.generic_project.exception.SerializerException;
import org.openspcoop2.utils.beans.WriteToSerializerType;
import org.openspcoop2.utils.xml.JaxbUtils;

public abstract class AbstractSerializer {
    protected abstract WriteToSerializerType getType();

    protected void _objToXml(OutputStream out, Class<?> c, Object object, boolean prettyPrint) throws Exception {
        if (object instanceof JAXBElement) {
            JaxbUtils.objToXml((OutputStream)out, c, (Object)object, (boolean)prettyPrint);
        } else {
            Method m = c.getMethod("writeTo", OutputStream.class, WriteToSerializerType.class);
            m.invoke(object, out, this.getType());
        }
    }

    protected void objToXml(OutputStream out, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        try {
            this._objToXml(out, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                out.flush();
            }
            catch (Exception exception) {}
        }
    }

    protected void objToXml(String fileName, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        try {
            this.objToXml(new File(fileName), c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
    }

    protected void objToXml(File file, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            this._objToXml(fout, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected ByteArrayOutputStream objToXml(Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            this._objToXml(bout, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (bout != null) {
                    bout.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (bout != null) {
                    bout.close();
                }
            }
            catch (Exception exception) {}
        }
        return bout;
    }

    public void write(String fileName, Message message) throws SerializerException {
        this.objToXml(fileName, Message.class, (Object)message, false);
    }

    public void write(String fileName, Message message, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Message.class, (Object)message, prettyPrint);
    }

    public void write(File file, Message message) throws SerializerException {
        this.objToXml(file, Message.class, (Object)message, false);
    }

    public void write(File file, Message message, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Message.class, (Object)message, prettyPrint);
    }

    public void write(OutputStream out, Message message) throws SerializerException {
        this.objToXml(out, Message.class, (Object)message, false);
    }

    public void write(OutputStream out, Message message, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Message.class, (Object)message, prettyPrint);
    }

    public byte[] toByteArray(Message message) throws SerializerException {
        return this.objToXml(Message.class, message, false).toByteArray();
    }

    public byte[] toByteArray(Message message, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Message.class, message, prettyPrint).toByteArray();
    }

    public String toString(Message message) throws SerializerException {
        return this.objToXml(Message.class, message, false).toString();
    }

    public String toString(Message message, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Message.class, message, prettyPrint).toString();
    }

    public void write(String fileName, Operation operation) throws SerializerException {
        this.objToXml(fileName, Operation.class, (Object)operation, false);
    }

    public void write(String fileName, Operation operation, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Operation.class, (Object)operation, prettyPrint);
    }

    public void write(File file, Operation operation) throws SerializerException {
        this.objToXml(file, Operation.class, (Object)operation, false);
    }

    public void write(File file, Operation operation, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Operation.class, (Object)operation, prettyPrint);
    }

    public void write(OutputStream out, Operation operation) throws SerializerException {
        this.objToXml(out, Operation.class, (Object)operation, false);
    }

    public void write(OutputStream out, Operation operation, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Operation.class, (Object)operation, prettyPrint);
    }

    public byte[] toByteArray(Operation operation) throws SerializerException {
        return this.objToXml(Operation.class, operation, false).toByteArray();
    }

    public byte[] toByteArray(Operation operation, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Operation.class, operation, prettyPrint).toByteArray();
    }

    public String toString(Operation operation) throws SerializerException {
        return this.objToXml(Operation.class, operation, false).toString();
    }

    public String toString(Operation operation, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Operation.class, operation, prettyPrint).toString();
    }

    public void write(String fileName, ProtocolProperty protocolProperty) throws SerializerException {
        this.objToXml(fileName, ProtocolProperty.class, (Object)protocolProperty, false);
    }

    public void write(String fileName, ProtocolProperty protocolProperty, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ProtocolProperty.class, (Object)protocolProperty, prettyPrint);
    }

    public void write(File file, ProtocolProperty protocolProperty) throws SerializerException {
        this.objToXml(file, ProtocolProperty.class, (Object)protocolProperty, false);
    }

    public void write(File file, ProtocolProperty protocolProperty, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ProtocolProperty.class, (Object)protocolProperty, prettyPrint);
    }

    public void write(OutputStream out, ProtocolProperty protocolProperty) throws SerializerException {
        this.objToXml(out, ProtocolProperty.class, (Object)protocolProperty, false);
    }

    public void write(OutputStream out, ProtocolProperty protocolProperty, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ProtocolProperty.class, (Object)protocolProperty, prettyPrint);
    }

    public byte[] toByteArray(ProtocolProperty protocolProperty) throws SerializerException {
        return this.objToXml(ProtocolProperty.class, protocolProperty, false).toByteArray();
    }

    public byte[] toByteArray(ProtocolProperty protocolProperty, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ProtocolProperty.class, protocolProperty, prettyPrint).toByteArray();
    }

    public String toString(ProtocolProperty protocolProperty) throws SerializerException {
        return this.objToXml(ProtocolProperty.class, protocolProperty, false).toString();
    }

    public String toString(ProtocolProperty protocolProperty, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ProtocolProperty.class, protocolProperty, prettyPrint).toString();
    }

    public void write(String fileName, ResourceParameter resourceParameter) throws SerializerException {
        this.objToXml(fileName, ResourceParameter.class, (Object)resourceParameter, false);
    }

    public void write(String fileName, ResourceParameter resourceParameter, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ResourceParameter.class, (Object)resourceParameter, prettyPrint);
    }

    public void write(File file, ResourceParameter resourceParameter) throws SerializerException {
        this.objToXml(file, ResourceParameter.class, (Object)resourceParameter, false);
    }

    public void write(File file, ResourceParameter resourceParameter, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ResourceParameter.class, (Object)resourceParameter, prettyPrint);
    }

    public void write(OutputStream out, ResourceParameter resourceParameter) throws SerializerException {
        this.objToXml(out, ResourceParameter.class, (Object)resourceParameter, false);
    }

    public void write(OutputStream out, ResourceParameter resourceParameter, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ResourceParameter.class, (Object)resourceParameter, prettyPrint);
    }

    public byte[] toByteArray(ResourceParameter resourceParameter) throws SerializerException {
        return this.objToXml(ResourceParameter.class, resourceParameter, false).toByteArray();
    }

    public byte[] toByteArray(ResourceParameter resourceParameter, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ResourceParameter.class, resourceParameter, prettyPrint).toByteArray();
    }

    public String toString(ResourceParameter resourceParameter) throws SerializerException {
        return this.objToXml(ResourceParameter.class, resourceParameter, false).toString();
    }

    public String toString(ResourceParameter resourceParameter, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ResourceParameter.class, resourceParameter, prettyPrint).toString();
    }

    public void write(String fileName, ResourceRequest resourceRequest) throws SerializerException {
        this.objToXml(fileName, ResourceRequest.class, (Object)resourceRequest, false);
    }

    public void write(String fileName, ResourceRequest resourceRequest, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ResourceRequest.class, (Object)resourceRequest, prettyPrint);
    }

    public void write(File file, ResourceRequest resourceRequest) throws SerializerException {
        this.objToXml(file, ResourceRequest.class, (Object)resourceRequest, false);
    }

    public void write(File file, ResourceRequest resourceRequest, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ResourceRequest.class, (Object)resourceRequest, prettyPrint);
    }

    public void write(OutputStream out, ResourceRequest resourceRequest) throws SerializerException {
        this.objToXml(out, ResourceRequest.class, (Object)resourceRequest, false);
    }

    public void write(OutputStream out, ResourceRequest resourceRequest, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ResourceRequest.class, (Object)resourceRequest, prettyPrint);
    }

    public byte[] toByteArray(ResourceRequest resourceRequest) throws SerializerException {
        return this.objToXml(ResourceRequest.class, resourceRequest, false).toByteArray();
    }

    public byte[] toByteArray(ResourceRequest resourceRequest, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ResourceRequest.class, resourceRequest, prettyPrint).toByteArray();
    }

    public String toString(ResourceRequest resourceRequest) throws SerializerException {
        return this.objToXml(ResourceRequest.class, resourceRequest, false).toString();
    }

    public String toString(ResourceRequest resourceRequest, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ResourceRequest.class, resourceRequest, prettyPrint).toString();
    }

    public void write(String fileName, ResourceRepresentation resourceRepresentation) throws SerializerException {
        this.objToXml(fileName, ResourceRepresentation.class, (Object)resourceRepresentation, false);
    }

    public void write(String fileName, ResourceRepresentation resourceRepresentation, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ResourceRepresentation.class, (Object)resourceRepresentation, prettyPrint);
    }

    public void write(File file, ResourceRepresentation resourceRepresentation) throws SerializerException {
        this.objToXml(file, ResourceRepresentation.class, (Object)resourceRepresentation, false);
    }

    public void write(File file, ResourceRepresentation resourceRepresentation, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ResourceRepresentation.class, (Object)resourceRepresentation, prettyPrint);
    }

    public void write(OutputStream out, ResourceRepresentation resourceRepresentation) throws SerializerException {
        this.objToXml(out, ResourceRepresentation.class, (Object)resourceRepresentation, false);
    }

    public void write(OutputStream out, ResourceRepresentation resourceRepresentation, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ResourceRepresentation.class, (Object)resourceRepresentation, prettyPrint);
    }

    public byte[] toByteArray(ResourceRepresentation resourceRepresentation) throws SerializerException {
        return this.objToXml(ResourceRepresentation.class, resourceRepresentation, false).toByteArray();
    }

    public byte[] toByteArray(ResourceRepresentation resourceRepresentation, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ResourceRepresentation.class, resourceRepresentation, prettyPrint).toByteArray();
    }

    public String toString(ResourceRepresentation resourceRepresentation) throws SerializerException {
        return this.objToXml(ResourceRepresentation.class, resourceRepresentation, false).toString();
    }

    public String toString(ResourceRepresentation resourceRepresentation, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ResourceRepresentation.class, resourceRepresentation, prettyPrint).toString();
    }

    public void write(String fileName, Resource resource) throws SerializerException {
        this.objToXml(fileName, Resource.class, (Object)resource, false);
    }

    public void write(String fileName, Resource resource, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Resource.class, (Object)resource, prettyPrint);
    }

    public void write(File file, Resource resource) throws SerializerException {
        this.objToXml(file, Resource.class, (Object)resource, false);
    }

    public void write(File file, Resource resource, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Resource.class, (Object)resource, prettyPrint);
    }

    public void write(OutputStream out, Resource resource) throws SerializerException {
        this.objToXml(out, Resource.class, (Object)resource, false);
    }

    public void write(OutputStream out, Resource resource, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Resource.class, (Object)resource, prettyPrint);
    }

    public byte[] toByteArray(Resource resource) throws SerializerException {
        return this.objToXml(Resource.class, resource, false).toByteArray();
    }

    public byte[] toByteArray(Resource resource, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Resource.class, resource, prettyPrint).toByteArray();
    }

    public String toString(Resource resource) throws SerializerException {
        return this.objToXml(Resource.class, resource, false).toString();
    }

    public String toString(Resource resource, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Resource.class, resource, prettyPrint).toString();
    }

    public void write(String fileName, ResourceResponse resourceResponse) throws SerializerException {
        this.objToXml(fileName, ResourceResponse.class, (Object)resourceResponse, false);
    }

    public void write(String fileName, ResourceResponse resourceResponse, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ResourceResponse.class, (Object)resourceResponse, prettyPrint);
    }

    public void write(File file, ResourceResponse resourceResponse) throws SerializerException {
        this.objToXml(file, ResourceResponse.class, (Object)resourceResponse, false);
    }

    public void write(File file, ResourceResponse resourceResponse, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ResourceResponse.class, (Object)resourceResponse, prettyPrint);
    }

    public void write(OutputStream out, ResourceResponse resourceResponse) throws SerializerException {
        this.objToXml(out, ResourceResponse.class, (Object)resourceResponse, false);
    }

    public void write(OutputStream out, ResourceResponse resourceResponse, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ResourceResponse.class, (Object)resourceResponse, prettyPrint);
    }

    public byte[] toByteArray(ResourceResponse resourceResponse) throws SerializerException {
        return this.objToXml(ResourceResponse.class, resourceResponse, false).toByteArray();
    }

    public byte[] toByteArray(ResourceResponse resourceResponse, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ResourceResponse.class, resourceResponse, prettyPrint).toByteArray();
    }

    public String toString(ResourceResponse resourceResponse) throws SerializerException {
        return this.objToXml(ResourceResponse.class, resourceResponse, false).toString();
    }

    public String toString(ResourceResponse resourceResponse, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ResourceResponse.class, resourceResponse, prettyPrint).toString();
    }

    public void write(String fileName, IdRuolo idRuolo) throws SerializerException {
        this.objToXml(fileName, IdRuolo.class, (Object)idRuolo, false);
    }

    public void write(String fileName, IdRuolo idRuolo, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, IdRuolo.class, (Object)idRuolo, prettyPrint);
    }

    public void write(File file, IdRuolo idRuolo) throws SerializerException {
        this.objToXml(file, IdRuolo.class, (Object)idRuolo, false);
    }

    public void write(File file, IdRuolo idRuolo, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, IdRuolo.class, (Object)idRuolo, prettyPrint);
    }

    public void write(OutputStream out, IdRuolo idRuolo) throws SerializerException {
        this.objToXml(out, IdRuolo.class, (Object)idRuolo, false);
    }

    public void write(OutputStream out, IdRuolo idRuolo, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, IdRuolo.class, (Object)idRuolo, prettyPrint);
    }

    public byte[] toByteArray(IdRuolo idRuolo) throws SerializerException {
        return this.objToXml(IdRuolo.class, idRuolo, false).toByteArray();
    }

    public byte[] toByteArray(IdRuolo idRuolo, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IdRuolo.class, idRuolo, prettyPrint).toByteArray();
    }

    public String toString(IdRuolo idRuolo) throws SerializerException {
        return this.objToXml(IdRuolo.class, idRuolo, false).toString();
    }

    public String toString(IdRuolo idRuolo, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IdRuolo.class, idRuolo, prettyPrint).toString();
    }

    public void write(String fileName, ResourceRepresentationJson resourceRepresentationJson) throws SerializerException {
        this.objToXml(fileName, ResourceRepresentationJson.class, (Object)resourceRepresentationJson, false);
    }

    public void write(String fileName, ResourceRepresentationJson resourceRepresentationJson, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ResourceRepresentationJson.class, (Object)resourceRepresentationJson, prettyPrint);
    }

    public void write(File file, ResourceRepresentationJson resourceRepresentationJson) throws SerializerException {
        this.objToXml(file, ResourceRepresentationJson.class, (Object)resourceRepresentationJson, false);
    }

    public void write(File file, ResourceRepresentationJson resourceRepresentationJson, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ResourceRepresentationJson.class, (Object)resourceRepresentationJson, prettyPrint);
    }

    public void write(OutputStream out, ResourceRepresentationJson resourceRepresentationJson) throws SerializerException {
        this.objToXml(out, ResourceRepresentationJson.class, (Object)resourceRepresentationJson, false);
    }

    public void write(OutputStream out, ResourceRepresentationJson resourceRepresentationJson, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ResourceRepresentationJson.class, (Object)resourceRepresentationJson, prettyPrint);
    }

    public byte[] toByteArray(ResourceRepresentationJson resourceRepresentationJson) throws SerializerException {
        return this.objToXml(ResourceRepresentationJson.class, resourceRepresentationJson, false).toByteArray();
    }

    public byte[] toByteArray(ResourceRepresentationJson resourceRepresentationJson, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ResourceRepresentationJson.class, resourceRepresentationJson, prettyPrint).toByteArray();
    }

    public String toString(ResourceRepresentationJson resourceRepresentationJson) throws SerializerException {
        return this.objToXml(ResourceRepresentationJson.class, resourceRepresentationJson, false).toString();
    }

    public String toString(ResourceRepresentationJson resourceRepresentationJson, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ResourceRepresentationJson.class, resourceRepresentationJson, prettyPrint).toString();
    }

    public void write(String fileName, MessagePart messagePart) throws SerializerException {
        this.objToXml(fileName, MessagePart.class, (Object)messagePart, false);
    }

    public void write(String fileName, MessagePart messagePart, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, MessagePart.class, (Object)messagePart, prettyPrint);
    }

    public void write(File file, MessagePart messagePart) throws SerializerException {
        this.objToXml(file, MessagePart.class, (Object)messagePart, false);
    }

    public void write(File file, MessagePart messagePart, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, MessagePart.class, (Object)messagePart, prettyPrint);
    }

    public void write(OutputStream out, MessagePart messagePart) throws SerializerException {
        this.objToXml(out, MessagePart.class, (Object)messagePart, false);
    }

    public void write(OutputStream out, MessagePart messagePart, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, MessagePart.class, (Object)messagePart, prettyPrint);
    }

    public byte[] toByteArray(MessagePart messagePart) throws SerializerException {
        return this.objToXml(MessagePart.class, messagePart, false).toByteArray();
    }

    public byte[] toByteArray(MessagePart messagePart, boolean prettyPrint) throws SerializerException {
        return this.objToXml(MessagePart.class, messagePart, prettyPrint).toByteArray();
    }

    public String toString(MessagePart messagePart) throws SerializerException {
        return this.objToXml(MessagePart.class, messagePart, false).toString();
    }

    public String toString(MessagePart messagePart, boolean prettyPrint) throws SerializerException {
        return this.objToXml(MessagePart.class, messagePart, prettyPrint).toString();
    }

    public void write(String fileName, IdPortaDominio idPortaDominio) throws SerializerException {
        this.objToXml(fileName, IdPortaDominio.class, (Object)idPortaDominio, false);
    }

    public void write(String fileName, IdPortaDominio idPortaDominio, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, IdPortaDominio.class, (Object)idPortaDominio, prettyPrint);
    }

    public void write(File file, IdPortaDominio idPortaDominio) throws SerializerException {
        this.objToXml(file, IdPortaDominio.class, (Object)idPortaDominio, false);
    }

    public void write(File file, IdPortaDominio idPortaDominio, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, IdPortaDominio.class, (Object)idPortaDominio, prettyPrint);
    }

    public void write(OutputStream out, IdPortaDominio idPortaDominio) throws SerializerException {
        this.objToXml(out, IdPortaDominio.class, (Object)idPortaDominio, false);
    }

    public void write(OutputStream out, IdPortaDominio idPortaDominio, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, IdPortaDominio.class, (Object)idPortaDominio, prettyPrint);
    }

    public byte[] toByteArray(IdPortaDominio idPortaDominio) throws SerializerException {
        return this.objToXml(IdPortaDominio.class, idPortaDominio, false).toByteArray();
    }

    public byte[] toByteArray(IdPortaDominio idPortaDominio, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IdPortaDominio.class, idPortaDominio, prettyPrint).toByteArray();
    }

    public String toString(IdPortaDominio idPortaDominio) throws SerializerException {
        return this.objToXml(IdPortaDominio.class, idPortaDominio, false).toString();
    }

    public String toString(IdPortaDominio idPortaDominio, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IdPortaDominio.class, idPortaDominio, prettyPrint).toString();
    }

    public void write(String fileName, Documento documento) throws SerializerException {
        this.objToXml(fileName, Documento.class, (Object)documento, false);
    }

    public void write(String fileName, Documento documento, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Documento.class, (Object)documento, prettyPrint);
    }

    public void write(File file, Documento documento) throws SerializerException {
        this.objToXml(file, Documento.class, (Object)documento, false);
    }

    public void write(File file, Documento documento, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Documento.class, (Object)documento, prettyPrint);
    }

    public void write(OutputStream out, Documento documento) throws SerializerException {
        this.objToXml(out, Documento.class, (Object)documento, false);
    }

    public void write(OutputStream out, Documento documento, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Documento.class, (Object)documento, prettyPrint);
    }

    public byte[] toByteArray(Documento documento) throws SerializerException {
        return this.objToXml(Documento.class, documento, false).toByteArray();
    }

    public byte[] toByteArray(Documento documento, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Documento.class, documento, prettyPrint).toByteArray();
    }

    public String toString(Documento documento) throws SerializerException {
        return this.objToXml(Documento.class, documento, false).toString();
    }

    public String toString(Documento documento, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Documento.class, documento, prettyPrint).toString();
    }

    public void write(String fileName, IdSoggetto idSoggetto) throws SerializerException {
        this.objToXml(fileName, IdSoggetto.class, (Object)idSoggetto, false);
    }

    public void write(String fileName, IdSoggetto idSoggetto, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, IdSoggetto.class, (Object)idSoggetto, prettyPrint);
    }

    public void write(File file, IdSoggetto idSoggetto) throws SerializerException {
        this.objToXml(file, IdSoggetto.class, (Object)idSoggetto, false);
    }

    public void write(File file, IdSoggetto idSoggetto, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, IdSoggetto.class, (Object)idSoggetto, prettyPrint);
    }

    public void write(OutputStream out, IdSoggetto idSoggetto) throws SerializerException {
        this.objToXml(out, IdSoggetto.class, (Object)idSoggetto, false);
    }

    public void write(OutputStream out, IdSoggetto idSoggetto, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, IdSoggetto.class, (Object)idSoggetto, prettyPrint);
    }

    public byte[] toByteArray(IdSoggetto idSoggetto) throws SerializerException {
        return this.objToXml(IdSoggetto.class, idSoggetto, false).toByteArray();
    }

    public byte[] toByteArray(IdSoggetto idSoggetto, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IdSoggetto.class, idSoggetto, prettyPrint).toByteArray();
    }

    public String toString(IdSoggetto idSoggetto) throws SerializerException {
        return this.objToXml(IdSoggetto.class, idSoggetto, false).toString();
    }

    public String toString(IdSoggetto idSoggetto, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IdSoggetto.class, idSoggetto, prettyPrint).toString();
    }

    public void write(String fileName, IdAccordoServizioParteSpecifica idAccordoServizioParteSpecifica) throws SerializerException {
        this.objToXml(fileName, IdAccordoServizioParteSpecifica.class, (Object)idAccordoServizioParteSpecifica, false);
    }

    public void write(String fileName, IdAccordoServizioParteSpecifica idAccordoServizioParteSpecifica, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, IdAccordoServizioParteSpecifica.class, (Object)idAccordoServizioParteSpecifica, prettyPrint);
    }

    public void write(File file, IdAccordoServizioParteSpecifica idAccordoServizioParteSpecifica) throws SerializerException {
        this.objToXml(file, IdAccordoServizioParteSpecifica.class, (Object)idAccordoServizioParteSpecifica, false);
    }

    public void write(File file, IdAccordoServizioParteSpecifica idAccordoServizioParteSpecifica, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, IdAccordoServizioParteSpecifica.class, (Object)idAccordoServizioParteSpecifica, prettyPrint);
    }

    public void write(OutputStream out, IdAccordoServizioParteSpecifica idAccordoServizioParteSpecifica) throws SerializerException {
        this.objToXml(out, IdAccordoServizioParteSpecifica.class, (Object)idAccordoServizioParteSpecifica, false);
    }

    public void write(OutputStream out, IdAccordoServizioParteSpecifica idAccordoServizioParteSpecifica, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, IdAccordoServizioParteSpecifica.class, (Object)idAccordoServizioParteSpecifica, prettyPrint);
    }

    public byte[] toByteArray(IdAccordoServizioParteSpecifica idAccordoServizioParteSpecifica) throws SerializerException {
        return this.objToXml(IdAccordoServizioParteSpecifica.class, idAccordoServizioParteSpecifica, false).toByteArray();
    }

    public byte[] toByteArray(IdAccordoServizioParteSpecifica idAccordoServizioParteSpecifica, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IdAccordoServizioParteSpecifica.class, idAccordoServizioParteSpecifica, prettyPrint).toByteArray();
    }

    public String toString(IdAccordoServizioParteSpecifica idAccordoServizioParteSpecifica) throws SerializerException {
        return this.objToXml(IdAccordoServizioParteSpecifica.class, idAccordoServizioParteSpecifica, false).toString();
    }

    public String toString(IdAccordoServizioParteSpecifica idAccordoServizioParteSpecifica, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IdAccordoServizioParteSpecifica.class, idAccordoServizioParteSpecifica, prettyPrint).toString();
    }

    public void write(String fileName, GruppoAccordo gruppoAccordo) throws SerializerException {
        this.objToXml(fileName, GruppoAccordo.class, (Object)gruppoAccordo, false);
    }

    public void write(String fileName, GruppoAccordo gruppoAccordo, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, GruppoAccordo.class, (Object)gruppoAccordo, prettyPrint);
    }

    public void write(File file, GruppoAccordo gruppoAccordo) throws SerializerException {
        this.objToXml(file, GruppoAccordo.class, (Object)gruppoAccordo, false);
    }

    public void write(File file, GruppoAccordo gruppoAccordo, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, GruppoAccordo.class, (Object)gruppoAccordo, prettyPrint);
    }

    public void write(OutputStream out, GruppoAccordo gruppoAccordo) throws SerializerException {
        this.objToXml(out, GruppoAccordo.class, (Object)gruppoAccordo, false);
    }

    public void write(OutputStream out, GruppoAccordo gruppoAccordo, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, GruppoAccordo.class, (Object)gruppoAccordo, prettyPrint);
    }

    public byte[] toByteArray(GruppoAccordo gruppoAccordo) throws SerializerException {
        return this.objToXml(GruppoAccordo.class, gruppoAccordo, false).toByteArray();
    }

    public byte[] toByteArray(GruppoAccordo gruppoAccordo, boolean prettyPrint) throws SerializerException {
        return this.objToXml(GruppoAccordo.class, gruppoAccordo, prettyPrint).toByteArray();
    }

    public String toString(GruppoAccordo gruppoAccordo) throws SerializerException {
        return this.objToXml(GruppoAccordo.class, gruppoAccordo, false).toString();
    }

    public String toString(GruppoAccordo gruppoAccordo, boolean prettyPrint) throws SerializerException {
        return this.objToXml(GruppoAccordo.class, gruppoAccordo, prettyPrint).toString();
    }

    public void write(String fileName, GruppiAccordo gruppiAccordo) throws SerializerException {
        this.objToXml(fileName, GruppiAccordo.class, (Object)gruppiAccordo, false);
    }

    public void write(String fileName, GruppiAccordo gruppiAccordo, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, GruppiAccordo.class, (Object)gruppiAccordo, prettyPrint);
    }

    public void write(File file, GruppiAccordo gruppiAccordo) throws SerializerException {
        this.objToXml(file, GruppiAccordo.class, (Object)gruppiAccordo, false);
    }

    public void write(File file, GruppiAccordo gruppiAccordo, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, GruppiAccordo.class, (Object)gruppiAccordo, prettyPrint);
    }

    public void write(OutputStream out, GruppiAccordo gruppiAccordo) throws SerializerException {
        this.objToXml(out, GruppiAccordo.class, (Object)gruppiAccordo, false);
    }

    public void write(OutputStream out, GruppiAccordo gruppiAccordo, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, GruppiAccordo.class, (Object)gruppiAccordo, prettyPrint);
    }

    public byte[] toByteArray(GruppiAccordo gruppiAccordo) throws SerializerException {
        return this.objToXml(GruppiAccordo.class, gruppiAccordo, false).toByteArray();
    }

    public byte[] toByteArray(GruppiAccordo gruppiAccordo, boolean prettyPrint) throws SerializerException {
        return this.objToXml(GruppiAccordo.class, gruppiAccordo, prettyPrint).toByteArray();
    }

    public String toString(GruppiAccordo gruppiAccordo) throws SerializerException {
        return this.objToXml(GruppiAccordo.class, gruppiAccordo, false).toString();
    }

    public String toString(GruppiAccordo gruppiAccordo, boolean prettyPrint) throws SerializerException {
        return this.objToXml(GruppiAccordo.class, gruppiAccordo, prettyPrint).toString();
    }

    public void write(String fileName, IdScope idScope) throws SerializerException {
        this.objToXml(fileName, IdScope.class, (Object)idScope, false);
    }

    public void write(String fileName, IdScope idScope, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, IdScope.class, (Object)idScope, prettyPrint);
    }

    public void write(File file, IdScope idScope) throws SerializerException {
        this.objToXml(file, IdScope.class, (Object)idScope, false);
    }

    public void write(File file, IdScope idScope, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, IdScope.class, (Object)idScope, prettyPrint);
    }

    public void write(OutputStream out, IdScope idScope) throws SerializerException {
        this.objToXml(out, IdScope.class, (Object)idScope, false);
    }

    public void write(OutputStream out, IdScope idScope, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, IdScope.class, (Object)idScope, prettyPrint);
    }

    public byte[] toByteArray(IdScope idScope) throws SerializerException {
        return this.objToXml(IdScope.class, idScope, false).toByteArray();
    }

    public byte[] toByteArray(IdScope idScope, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IdScope.class, idScope, prettyPrint).toByteArray();
    }

    public String toString(IdScope idScope) throws SerializerException {
        return this.objToXml(IdScope.class, idScope, false).toString();
    }

    public String toString(IdScope idScope, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IdScope.class, idScope, prettyPrint).toString();
    }

    public void write(String fileName, ConfigurazioneServizio configurazioneServizio) throws SerializerException {
        this.objToXml(fileName, ConfigurazioneServizio.class, (Object)configurazioneServizio, false);
    }

    public void write(String fileName, ConfigurazioneServizio configurazioneServizio, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ConfigurazioneServizio.class, (Object)configurazioneServizio, prettyPrint);
    }

    public void write(File file, ConfigurazioneServizio configurazioneServizio) throws SerializerException {
        this.objToXml(file, ConfigurazioneServizio.class, (Object)configurazioneServizio, false);
    }

    public void write(File file, ConfigurazioneServizio configurazioneServizio, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ConfigurazioneServizio.class, (Object)configurazioneServizio, prettyPrint);
    }

    public void write(OutputStream out, ConfigurazioneServizio configurazioneServizio) throws SerializerException {
        this.objToXml(out, ConfigurazioneServizio.class, (Object)configurazioneServizio, false);
    }

    public void write(OutputStream out, ConfigurazioneServizio configurazioneServizio, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ConfigurazioneServizio.class, (Object)configurazioneServizio, prettyPrint);
    }

    public byte[] toByteArray(ConfigurazioneServizio configurazioneServizio) throws SerializerException {
        return this.objToXml(ConfigurazioneServizio.class, configurazioneServizio, false).toByteArray();
    }

    public byte[] toByteArray(ConfigurazioneServizio configurazioneServizio, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ConfigurazioneServizio.class, configurazioneServizio, prettyPrint).toByteArray();
    }

    public String toString(ConfigurazioneServizio configurazioneServizio) throws SerializerException {
        return this.objToXml(ConfigurazioneServizio.class, configurazioneServizio, false).toString();
    }

    public String toString(ConfigurazioneServizio configurazioneServizio, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ConfigurazioneServizio.class, configurazioneServizio, prettyPrint).toString();
    }

    public void write(String fileName, AccordoServizioParteSpecifica accordoServizioParteSpecifica) throws SerializerException {
        this.objToXml(fileName, AccordoServizioParteSpecifica.class, (Object)accordoServizioParteSpecifica, false);
    }

    public void write(String fileName, AccordoServizioParteSpecifica accordoServizioParteSpecifica, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, AccordoServizioParteSpecifica.class, (Object)accordoServizioParteSpecifica, prettyPrint);
    }

    public void write(File file, AccordoServizioParteSpecifica accordoServizioParteSpecifica) throws SerializerException {
        this.objToXml(file, AccordoServizioParteSpecifica.class, (Object)accordoServizioParteSpecifica, false);
    }

    public void write(File file, AccordoServizioParteSpecifica accordoServizioParteSpecifica, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, AccordoServizioParteSpecifica.class, (Object)accordoServizioParteSpecifica, prettyPrint);
    }

    public void write(OutputStream out, AccordoServizioParteSpecifica accordoServizioParteSpecifica) throws SerializerException {
        this.objToXml(out, AccordoServizioParteSpecifica.class, (Object)accordoServizioParteSpecifica, false);
    }

    public void write(OutputStream out, AccordoServizioParteSpecifica accordoServizioParteSpecifica, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, AccordoServizioParteSpecifica.class, (Object)accordoServizioParteSpecifica, prettyPrint);
    }

    public byte[] toByteArray(AccordoServizioParteSpecifica accordoServizioParteSpecifica) throws SerializerException {
        return this.objToXml(AccordoServizioParteSpecifica.class, accordoServizioParteSpecifica, false).toByteArray();
    }

    public byte[] toByteArray(AccordoServizioParteSpecifica accordoServizioParteSpecifica, boolean prettyPrint) throws SerializerException {
        return this.objToXml(AccordoServizioParteSpecifica.class, accordoServizioParteSpecifica, prettyPrint).toByteArray();
    }

    public String toString(AccordoServizioParteSpecifica accordoServizioParteSpecifica) throws SerializerException {
        return this.objToXml(AccordoServizioParteSpecifica.class, accordoServizioParteSpecifica, false).toString();
    }

    public String toString(AccordoServizioParteSpecifica accordoServizioParteSpecifica, boolean prettyPrint) throws SerializerException {
        return this.objToXml(AccordoServizioParteSpecifica.class, accordoServizioParteSpecifica, prettyPrint).toString();
    }

    public void write(String fileName, Fruitore fruitore) throws SerializerException {
        this.objToXml(fileName, Fruitore.class, (Object)fruitore, false);
    }

    public void write(String fileName, Fruitore fruitore, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Fruitore.class, (Object)fruitore, prettyPrint);
    }

    public void write(File file, Fruitore fruitore) throws SerializerException {
        this.objToXml(file, Fruitore.class, (Object)fruitore, false);
    }

    public void write(File file, Fruitore fruitore, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Fruitore.class, (Object)fruitore, prettyPrint);
    }

    public void write(OutputStream out, Fruitore fruitore) throws SerializerException {
        this.objToXml(out, Fruitore.class, (Object)fruitore, false);
    }

    public void write(OutputStream out, Fruitore fruitore, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Fruitore.class, (Object)fruitore, prettyPrint);
    }

    public byte[] toByteArray(Fruitore fruitore) throws SerializerException {
        return this.objToXml(Fruitore.class, fruitore, false).toByteArray();
    }

    public byte[] toByteArray(Fruitore fruitore, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Fruitore.class, fruitore, prettyPrint).toByteArray();
    }

    public String toString(Fruitore fruitore) throws SerializerException {
        return this.objToXml(Fruitore.class, fruitore, false).toString();
    }

    public String toString(Fruitore fruitore, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Fruitore.class, fruitore, prettyPrint).toString();
    }

    public void write(String fileName, ProprietaOggetto proprietaOggetto) throws SerializerException {
        this.objToXml(fileName, ProprietaOggetto.class, (Object)proprietaOggetto, false);
    }

    public void write(String fileName, ProprietaOggetto proprietaOggetto, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ProprietaOggetto.class, (Object)proprietaOggetto, prettyPrint);
    }

    public void write(File file, ProprietaOggetto proprietaOggetto) throws SerializerException {
        this.objToXml(file, ProprietaOggetto.class, (Object)proprietaOggetto, false);
    }

    public void write(File file, ProprietaOggetto proprietaOggetto, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ProprietaOggetto.class, (Object)proprietaOggetto, prettyPrint);
    }

    public void write(OutputStream out, ProprietaOggetto proprietaOggetto) throws SerializerException {
        this.objToXml(out, ProprietaOggetto.class, (Object)proprietaOggetto, false);
    }

    public void write(OutputStream out, ProprietaOggetto proprietaOggetto, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ProprietaOggetto.class, (Object)proprietaOggetto, prettyPrint);
    }

    public byte[] toByteArray(ProprietaOggetto proprietaOggetto) throws SerializerException {
        return this.objToXml(ProprietaOggetto.class, proprietaOggetto, false).toByteArray();
    }

    public byte[] toByteArray(ProprietaOggetto proprietaOggetto, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ProprietaOggetto.class, proprietaOggetto, prettyPrint).toByteArray();
    }

    public String toString(ProprietaOggetto proprietaOggetto) throws SerializerException {
        return this.objToXml(ProprietaOggetto.class, proprietaOggetto, false).toString();
    }

    public String toString(ProprietaOggetto proprietaOggetto, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ProprietaOggetto.class, proprietaOggetto, prettyPrint).toString();
    }

    public void write(String fileName, Property property) throws SerializerException {
        this.objToXml(fileName, Property.class, (Object)property, false);
    }

    public void write(String fileName, Property property, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Property.class, (Object)property, prettyPrint);
    }

    public void write(File file, Property property) throws SerializerException {
        this.objToXml(file, Property.class, (Object)property, false);
    }

    public void write(File file, Property property, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Property.class, (Object)property, prettyPrint);
    }

    public void write(OutputStream out, Property property) throws SerializerException {
        this.objToXml(out, Property.class, (Object)property, false);
    }

    public void write(OutputStream out, Property property, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Property.class, (Object)property, prettyPrint);
    }

    public byte[] toByteArray(Property property) throws SerializerException {
        return this.objToXml(Property.class, property, false).toByteArray();
    }

    public byte[] toByteArray(Property property, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Property.class, property, prettyPrint).toByteArray();
    }

    public String toString(Property property) throws SerializerException {
        return this.objToXml(Property.class, property, false).toString();
    }

    public String toString(Property property, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Property.class, property, prettyPrint).toString();
    }

    public void write(String fileName, Ruolo ruolo) throws SerializerException {
        this.objToXml(fileName, Ruolo.class, (Object)ruolo, false);
    }

    public void write(String fileName, Ruolo ruolo, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Ruolo.class, (Object)ruolo, prettyPrint);
    }

    public void write(File file, Ruolo ruolo) throws SerializerException {
        this.objToXml(file, Ruolo.class, (Object)ruolo, false);
    }

    public void write(File file, Ruolo ruolo, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Ruolo.class, (Object)ruolo, prettyPrint);
    }

    public void write(OutputStream out, Ruolo ruolo) throws SerializerException {
        this.objToXml(out, Ruolo.class, (Object)ruolo, false);
    }

    public void write(OutputStream out, Ruolo ruolo, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Ruolo.class, (Object)ruolo, prettyPrint);
    }

    public byte[] toByteArray(Ruolo ruolo) throws SerializerException {
        return this.objToXml(Ruolo.class, ruolo, false).toByteArray();
    }

    public byte[] toByteArray(Ruolo ruolo, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Ruolo.class, ruolo, prettyPrint).toByteArray();
    }

    public String toString(Ruolo ruolo) throws SerializerException {
        return this.objToXml(Ruolo.class, ruolo, false).toString();
    }

    public String toString(Ruolo ruolo, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Ruolo.class, ruolo, prettyPrint).toString();
    }

    public void write(String fileName, AccordoCooperazionePartecipanti accordoCooperazionePartecipanti) throws SerializerException {
        this.objToXml(fileName, AccordoCooperazionePartecipanti.class, (Object)accordoCooperazionePartecipanti, false);
    }

    public void write(String fileName, AccordoCooperazionePartecipanti accordoCooperazionePartecipanti, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, AccordoCooperazionePartecipanti.class, (Object)accordoCooperazionePartecipanti, prettyPrint);
    }

    public void write(File file, AccordoCooperazionePartecipanti accordoCooperazionePartecipanti) throws SerializerException {
        this.objToXml(file, AccordoCooperazionePartecipanti.class, (Object)accordoCooperazionePartecipanti, false);
    }

    public void write(File file, AccordoCooperazionePartecipanti accordoCooperazionePartecipanti, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, AccordoCooperazionePartecipanti.class, (Object)accordoCooperazionePartecipanti, prettyPrint);
    }

    public void write(OutputStream out, AccordoCooperazionePartecipanti accordoCooperazionePartecipanti) throws SerializerException {
        this.objToXml(out, AccordoCooperazionePartecipanti.class, (Object)accordoCooperazionePartecipanti, false);
    }

    public void write(OutputStream out, AccordoCooperazionePartecipanti accordoCooperazionePartecipanti, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, AccordoCooperazionePartecipanti.class, (Object)accordoCooperazionePartecipanti, prettyPrint);
    }

    public byte[] toByteArray(AccordoCooperazionePartecipanti accordoCooperazionePartecipanti) throws SerializerException {
        return this.objToXml(AccordoCooperazionePartecipanti.class, accordoCooperazionePartecipanti, false).toByteArray();
    }

    public byte[] toByteArray(AccordoCooperazionePartecipanti accordoCooperazionePartecipanti, boolean prettyPrint) throws SerializerException {
        return this.objToXml(AccordoCooperazionePartecipanti.class, accordoCooperazionePartecipanti, prettyPrint).toByteArray();
    }

    public String toString(AccordoCooperazionePartecipanti accordoCooperazionePartecipanti) throws SerializerException {
        return this.objToXml(AccordoCooperazionePartecipanti.class, accordoCooperazionePartecipanti, false).toString();
    }

    public String toString(AccordoCooperazionePartecipanti accordoCooperazionePartecipanti, boolean prettyPrint) throws SerializerException {
        return this.objToXml(AccordoCooperazionePartecipanti.class, accordoCooperazionePartecipanti, prettyPrint).toString();
    }

    public void write(String fileName, Proprieta proprieta) throws SerializerException {
        this.objToXml(fileName, Proprieta.class, (Object)proprieta, false);
    }

    public void write(String fileName, Proprieta proprieta, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Proprieta.class, (Object)proprieta, prettyPrint);
    }

    public void write(File file, Proprieta proprieta) throws SerializerException {
        this.objToXml(file, Proprieta.class, (Object)proprieta, false);
    }

    public void write(File file, Proprieta proprieta, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Proprieta.class, (Object)proprieta, prettyPrint);
    }

    public void write(OutputStream out, Proprieta proprieta) throws SerializerException {
        this.objToXml(out, Proprieta.class, (Object)proprieta, false);
    }

    public void write(OutputStream out, Proprieta proprieta, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Proprieta.class, (Object)proprieta, prettyPrint);
    }

    public byte[] toByteArray(Proprieta proprieta) throws SerializerException {
        return this.objToXml(Proprieta.class, proprieta, false).toByteArray();
    }

    public byte[] toByteArray(Proprieta proprieta, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Proprieta.class, proprieta, prettyPrint).toByteArray();
    }

    public String toString(Proprieta proprieta) throws SerializerException {
        return this.objToXml(Proprieta.class, proprieta, false).toString();
    }

    public String toString(Proprieta proprieta, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Proprieta.class, proprieta, prettyPrint).toString();
    }

    public void write(String fileName, Azione azione) throws SerializerException {
        this.objToXml(fileName, Azione.class, (Object)azione, false);
    }

    public void write(String fileName, Azione azione, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Azione.class, (Object)azione, prettyPrint);
    }

    public void write(File file, Azione azione) throws SerializerException {
        this.objToXml(file, Azione.class, (Object)azione, false);
    }

    public void write(File file, Azione azione, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Azione.class, (Object)azione, prettyPrint);
    }

    public void write(OutputStream out, Azione azione) throws SerializerException {
        this.objToXml(out, Azione.class, (Object)azione, false);
    }

    public void write(OutputStream out, Azione azione, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Azione.class, (Object)azione, prettyPrint);
    }

    public byte[] toByteArray(Azione azione) throws SerializerException {
        return this.objToXml(Azione.class, azione, false).toByteArray();
    }

    public byte[] toByteArray(Azione azione, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Azione.class, azione, prettyPrint).toByteArray();
    }

    public String toString(Azione azione) throws SerializerException {
        return this.objToXml(Azione.class, azione, false).toString();
    }

    public String toString(Azione azione, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Azione.class, azione, prettyPrint).toString();
    }

    public void write(String fileName, Connettore connettore) throws SerializerException {
        this.objToXml(fileName, Connettore.class, (Object)connettore, false);
    }

    public void write(String fileName, Connettore connettore, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Connettore.class, (Object)connettore, prettyPrint);
    }

    public void write(File file, Connettore connettore) throws SerializerException {
        this.objToXml(file, Connettore.class, (Object)connettore, false);
    }

    public void write(File file, Connettore connettore, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Connettore.class, (Object)connettore, prettyPrint);
    }

    public void write(OutputStream out, Connettore connettore) throws SerializerException {
        this.objToXml(out, Connettore.class, (Object)connettore, false);
    }

    public void write(OutputStream out, Connettore connettore, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Connettore.class, (Object)connettore, prettyPrint);
    }

    public byte[] toByteArray(Connettore connettore) throws SerializerException {
        return this.objToXml(Connettore.class, connettore, false).toByteArray();
    }

    public byte[] toByteArray(Connettore connettore, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Connettore.class, connettore, prettyPrint).toByteArray();
    }

    public String toString(Connettore connettore) throws SerializerException {
        return this.objToXml(Connettore.class, connettore, false).toString();
    }

    public String toString(Connettore connettore, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Connettore.class, connettore, prettyPrint).toString();
    }

    public void write(String fileName, ConfigurazioneServizioAzione configurazioneServizioAzione) throws SerializerException {
        this.objToXml(fileName, ConfigurazioneServizioAzione.class, (Object)configurazioneServizioAzione, false);
    }

    public void write(String fileName, ConfigurazioneServizioAzione configurazioneServizioAzione, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ConfigurazioneServizioAzione.class, (Object)configurazioneServizioAzione, prettyPrint);
    }

    public void write(File file, ConfigurazioneServizioAzione configurazioneServizioAzione) throws SerializerException {
        this.objToXml(file, ConfigurazioneServizioAzione.class, (Object)configurazioneServizioAzione, false);
    }

    public void write(File file, ConfigurazioneServizioAzione configurazioneServizioAzione, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ConfigurazioneServizioAzione.class, (Object)configurazioneServizioAzione, prettyPrint);
    }

    public void write(OutputStream out, ConfigurazioneServizioAzione configurazioneServizioAzione) throws SerializerException {
        this.objToXml(out, ConfigurazioneServizioAzione.class, (Object)configurazioneServizioAzione, false);
    }

    public void write(OutputStream out, ConfigurazioneServizioAzione configurazioneServizioAzione, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ConfigurazioneServizioAzione.class, (Object)configurazioneServizioAzione, prettyPrint);
    }

    public byte[] toByteArray(ConfigurazioneServizioAzione configurazioneServizioAzione) throws SerializerException {
        return this.objToXml(ConfigurazioneServizioAzione.class, configurazioneServizioAzione, false).toByteArray();
    }

    public byte[] toByteArray(ConfigurazioneServizioAzione configurazioneServizioAzione, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ConfigurazioneServizioAzione.class, configurazioneServizioAzione, prettyPrint).toByteArray();
    }

    public String toString(ConfigurazioneServizioAzione configurazioneServizioAzione) throws SerializerException {
        return this.objToXml(ConfigurazioneServizioAzione.class, configurazioneServizioAzione, false).toString();
    }

    public String toString(ConfigurazioneServizioAzione configurazioneServizioAzione, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ConfigurazioneServizioAzione.class, configurazioneServizioAzione, prettyPrint).toString();
    }

    public void write(String fileName, RuoloSoggetto ruoloSoggetto) throws SerializerException {
        this.objToXml(fileName, RuoloSoggetto.class, (Object)ruoloSoggetto, false);
    }

    public void write(String fileName, RuoloSoggetto ruoloSoggetto, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, RuoloSoggetto.class, (Object)ruoloSoggetto, prettyPrint);
    }

    public void write(File file, RuoloSoggetto ruoloSoggetto) throws SerializerException {
        this.objToXml(file, RuoloSoggetto.class, (Object)ruoloSoggetto, false);
    }

    public void write(File file, RuoloSoggetto ruoloSoggetto, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, RuoloSoggetto.class, (Object)ruoloSoggetto, prettyPrint);
    }

    public void write(OutputStream out, RuoloSoggetto ruoloSoggetto) throws SerializerException {
        this.objToXml(out, RuoloSoggetto.class, (Object)ruoloSoggetto, false);
    }

    public void write(OutputStream out, RuoloSoggetto ruoloSoggetto, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, RuoloSoggetto.class, (Object)ruoloSoggetto, prettyPrint);
    }

    public byte[] toByteArray(RuoloSoggetto ruoloSoggetto) throws SerializerException {
        return this.objToXml(RuoloSoggetto.class, ruoloSoggetto, false).toByteArray();
    }

    public byte[] toByteArray(RuoloSoggetto ruoloSoggetto, boolean prettyPrint) throws SerializerException {
        return this.objToXml(RuoloSoggetto.class, ruoloSoggetto, prettyPrint).toByteArray();
    }

    public String toString(RuoloSoggetto ruoloSoggetto) throws SerializerException {
        return this.objToXml(RuoloSoggetto.class, ruoloSoggetto, false).toString();
    }

    public String toString(RuoloSoggetto ruoloSoggetto, boolean prettyPrint) throws SerializerException {
        return this.objToXml(RuoloSoggetto.class, ruoloSoggetto, prettyPrint).toString();
    }

    public void write(String fileName, Scope scope) throws SerializerException {
        this.objToXml(fileName, Scope.class, (Object)scope, false);
    }

    public void write(String fileName, Scope scope, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Scope.class, (Object)scope, prettyPrint);
    }

    public void write(File file, Scope scope) throws SerializerException {
        this.objToXml(file, Scope.class, (Object)scope, false);
    }

    public void write(File file, Scope scope, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Scope.class, (Object)scope, prettyPrint);
    }

    public void write(OutputStream out, Scope scope) throws SerializerException {
        this.objToXml(out, Scope.class, (Object)scope, false);
    }

    public void write(OutputStream out, Scope scope, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Scope.class, (Object)scope, prettyPrint);
    }

    public byte[] toByteArray(Scope scope) throws SerializerException {
        return this.objToXml(Scope.class, scope, false).toByteArray();
    }

    public byte[] toByteArray(Scope scope, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Scope.class, scope, prettyPrint).toByteArray();
    }

    public String toString(Scope scope) throws SerializerException {
        return this.objToXml(Scope.class, scope, false).toString();
    }

    public String toString(Scope scope, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Scope.class, scope, prettyPrint).toString();
    }

    public void write(String fileName, ResourceRepresentationXml resourceRepresentationXml) throws SerializerException {
        this.objToXml(fileName, ResourceRepresentationXml.class, (Object)resourceRepresentationXml, false);
    }

    public void write(String fileName, ResourceRepresentationXml resourceRepresentationXml, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ResourceRepresentationXml.class, (Object)resourceRepresentationXml, prettyPrint);
    }

    public void write(File file, ResourceRepresentationXml resourceRepresentationXml) throws SerializerException {
        this.objToXml(file, ResourceRepresentationXml.class, (Object)resourceRepresentationXml, false);
    }

    public void write(File file, ResourceRepresentationXml resourceRepresentationXml, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ResourceRepresentationXml.class, (Object)resourceRepresentationXml, prettyPrint);
    }

    public void write(OutputStream out, ResourceRepresentationXml resourceRepresentationXml) throws SerializerException {
        this.objToXml(out, ResourceRepresentationXml.class, (Object)resourceRepresentationXml, false);
    }

    public void write(OutputStream out, ResourceRepresentationXml resourceRepresentationXml, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ResourceRepresentationXml.class, (Object)resourceRepresentationXml, prettyPrint);
    }

    public byte[] toByteArray(ResourceRepresentationXml resourceRepresentationXml) throws SerializerException {
        return this.objToXml(ResourceRepresentationXml.class, resourceRepresentationXml, false).toByteArray();
    }

    public byte[] toByteArray(ResourceRepresentationXml resourceRepresentationXml, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ResourceRepresentationXml.class, resourceRepresentationXml, prettyPrint).toByteArray();
    }

    public String toString(ResourceRepresentationXml resourceRepresentationXml) throws SerializerException {
        return this.objToXml(ResourceRepresentationXml.class, resourceRepresentationXml, false).toString();
    }

    public String toString(ResourceRepresentationXml resourceRepresentationXml, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ResourceRepresentationXml.class, resourceRepresentationXml, prettyPrint).toString();
    }

    public void write(String fileName, AccordoServizioParteComuneServizioCompostoServizioComponente accordoServizioParteComuneServizioCompostoServizioComponente) throws SerializerException {
        this.objToXml(fileName, AccordoServizioParteComuneServizioCompostoServizioComponente.class, (Object)accordoServizioParteComuneServizioCompostoServizioComponente, false);
    }

    public void write(String fileName, AccordoServizioParteComuneServizioCompostoServizioComponente accordoServizioParteComuneServizioCompostoServizioComponente, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, AccordoServizioParteComuneServizioCompostoServizioComponente.class, (Object)accordoServizioParteComuneServizioCompostoServizioComponente, prettyPrint);
    }

    public void write(File file, AccordoServizioParteComuneServizioCompostoServizioComponente accordoServizioParteComuneServizioCompostoServizioComponente) throws SerializerException {
        this.objToXml(file, AccordoServizioParteComuneServizioCompostoServizioComponente.class, (Object)accordoServizioParteComuneServizioCompostoServizioComponente, false);
    }

    public void write(File file, AccordoServizioParteComuneServizioCompostoServizioComponente accordoServizioParteComuneServizioCompostoServizioComponente, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, AccordoServizioParteComuneServizioCompostoServizioComponente.class, (Object)accordoServizioParteComuneServizioCompostoServizioComponente, prettyPrint);
    }

    public void write(OutputStream out, AccordoServizioParteComuneServizioCompostoServizioComponente accordoServizioParteComuneServizioCompostoServizioComponente) throws SerializerException {
        this.objToXml(out, AccordoServizioParteComuneServizioCompostoServizioComponente.class, (Object)accordoServizioParteComuneServizioCompostoServizioComponente, false);
    }

    public void write(OutputStream out, AccordoServizioParteComuneServizioCompostoServizioComponente accordoServizioParteComuneServizioCompostoServizioComponente, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, AccordoServizioParteComuneServizioCompostoServizioComponente.class, (Object)accordoServizioParteComuneServizioCompostoServizioComponente, prettyPrint);
    }

    public byte[] toByteArray(AccordoServizioParteComuneServizioCompostoServizioComponente accordoServizioParteComuneServizioCompostoServizioComponente) throws SerializerException {
        return this.objToXml(AccordoServizioParteComuneServizioCompostoServizioComponente.class, accordoServizioParteComuneServizioCompostoServizioComponente, false).toByteArray();
    }

    public byte[] toByteArray(AccordoServizioParteComuneServizioCompostoServizioComponente accordoServizioParteComuneServizioCompostoServizioComponente, boolean prettyPrint) throws SerializerException {
        return this.objToXml(AccordoServizioParteComuneServizioCompostoServizioComponente.class, accordoServizioParteComuneServizioCompostoServizioComponente, prettyPrint).toByteArray();
    }

    public String toString(AccordoServizioParteComuneServizioCompostoServizioComponente accordoServizioParteComuneServizioCompostoServizioComponente) throws SerializerException {
        return this.objToXml(AccordoServizioParteComuneServizioCompostoServizioComponente.class, accordoServizioParteComuneServizioCompostoServizioComponente, false).toString();
    }

    public String toString(AccordoServizioParteComuneServizioCompostoServizioComponente accordoServizioParteComuneServizioCompostoServizioComponente, boolean prettyPrint) throws SerializerException {
        return this.objToXml(AccordoServizioParteComuneServizioCompostoServizioComponente.class, accordoServizioParteComuneServizioCompostoServizioComponente, prettyPrint).toString();
    }

    public void write(String fileName, AccordoServizioParteComuneServizioComposto accordoServizioParteComuneServizioComposto) throws SerializerException {
        this.objToXml(fileName, AccordoServizioParteComuneServizioComposto.class, (Object)accordoServizioParteComuneServizioComposto, false);
    }

    public void write(String fileName, AccordoServizioParteComuneServizioComposto accordoServizioParteComuneServizioComposto, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, AccordoServizioParteComuneServizioComposto.class, (Object)accordoServizioParteComuneServizioComposto, prettyPrint);
    }

    public void write(File file, AccordoServizioParteComuneServizioComposto accordoServizioParteComuneServizioComposto) throws SerializerException {
        this.objToXml(file, AccordoServizioParteComuneServizioComposto.class, (Object)accordoServizioParteComuneServizioComposto, false);
    }

    public void write(File file, AccordoServizioParteComuneServizioComposto accordoServizioParteComuneServizioComposto, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, AccordoServizioParteComuneServizioComposto.class, (Object)accordoServizioParteComuneServizioComposto, prettyPrint);
    }

    public void write(OutputStream out, AccordoServizioParteComuneServizioComposto accordoServizioParteComuneServizioComposto) throws SerializerException {
        this.objToXml(out, AccordoServizioParteComuneServizioComposto.class, (Object)accordoServizioParteComuneServizioComposto, false);
    }

    public void write(OutputStream out, AccordoServizioParteComuneServizioComposto accordoServizioParteComuneServizioComposto, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, AccordoServizioParteComuneServizioComposto.class, (Object)accordoServizioParteComuneServizioComposto, prettyPrint);
    }

    public byte[] toByteArray(AccordoServizioParteComuneServizioComposto accordoServizioParteComuneServizioComposto) throws SerializerException {
        return this.objToXml(AccordoServizioParteComuneServizioComposto.class, accordoServizioParteComuneServizioComposto, false).toByteArray();
    }

    public byte[] toByteArray(AccordoServizioParteComuneServizioComposto accordoServizioParteComuneServizioComposto, boolean prettyPrint) throws SerializerException {
        return this.objToXml(AccordoServizioParteComuneServizioComposto.class, accordoServizioParteComuneServizioComposto, prettyPrint).toByteArray();
    }

    public String toString(AccordoServizioParteComuneServizioComposto accordoServizioParteComuneServizioComposto) throws SerializerException {
        return this.objToXml(AccordoServizioParteComuneServizioComposto.class, accordoServizioParteComuneServizioComposto, false).toString();
    }

    public String toString(AccordoServizioParteComuneServizioComposto accordoServizioParteComuneServizioComposto, boolean prettyPrint) throws SerializerException {
        return this.objToXml(AccordoServizioParteComuneServizioComposto.class, accordoServizioParteComuneServizioComposto, prettyPrint).toString();
    }

    public void write(String fileName, PortType portType) throws SerializerException {
        this.objToXml(fileName, PortType.class, (Object)portType, false);
    }

    public void write(String fileName, PortType portType, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, PortType.class, (Object)portType, prettyPrint);
    }

    public void write(File file, PortType portType) throws SerializerException {
        this.objToXml(file, PortType.class, (Object)portType, false);
    }

    public void write(File file, PortType portType, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, PortType.class, (Object)portType, prettyPrint);
    }

    public void write(OutputStream out, PortType portType) throws SerializerException {
        this.objToXml(out, PortType.class, (Object)portType, false);
    }

    public void write(OutputStream out, PortType portType, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, PortType.class, (Object)portType, prettyPrint);
    }

    public byte[] toByteArray(PortType portType) throws SerializerException {
        return this.objToXml(PortType.class, portType, false).toByteArray();
    }

    public byte[] toByteArray(PortType portType, boolean prettyPrint) throws SerializerException {
        return this.objToXml(PortType.class, portType, prettyPrint).toByteArray();
    }

    public String toString(PortType portType) throws SerializerException {
        return this.objToXml(PortType.class, portType, false).toString();
    }

    public String toString(PortType portType, boolean prettyPrint) throws SerializerException {
        return this.objToXml(PortType.class, portType, prettyPrint).toString();
    }

    public void write(String fileName, IdAccordoCooperazione idAccordoCooperazione) throws SerializerException {
        this.objToXml(fileName, IdAccordoCooperazione.class, (Object)idAccordoCooperazione, false);
    }

    public void write(String fileName, IdAccordoCooperazione idAccordoCooperazione, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, IdAccordoCooperazione.class, (Object)idAccordoCooperazione, prettyPrint);
    }

    public void write(File file, IdAccordoCooperazione idAccordoCooperazione) throws SerializerException {
        this.objToXml(file, IdAccordoCooperazione.class, (Object)idAccordoCooperazione, false);
    }

    public void write(File file, IdAccordoCooperazione idAccordoCooperazione, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, IdAccordoCooperazione.class, (Object)idAccordoCooperazione, prettyPrint);
    }

    public void write(OutputStream out, IdAccordoCooperazione idAccordoCooperazione) throws SerializerException {
        this.objToXml(out, IdAccordoCooperazione.class, (Object)idAccordoCooperazione, false);
    }

    public void write(OutputStream out, IdAccordoCooperazione idAccordoCooperazione, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, IdAccordoCooperazione.class, (Object)idAccordoCooperazione, prettyPrint);
    }

    public byte[] toByteArray(IdAccordoCooperazione idAccordoCooperazione) throws SerializerException {
        return this.objToXml(IdAccordoCooperazione.class, idAccordoCooperazione, false).toByteArray();
    }

    public byte[] toByteArray(IdAccordoCooperazione idAccordoCooperazione, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IdAccordoCooperazione.class, idAccordoCooperazione, prettyPrint).toByteArray();
    }

    public String toString(IdAccordoCooperazione idAccordoCooperazione) throws SerializerException {
        return this.objToXml(IdAccordoCooperazione.class, idAccordoCooperazione, false).toString();
    }

    public String toString(IdAccordoCooperazione idAccordoCooperazione, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IdAccordoCooperazione.class, idAccordoCooperazione, prettyPrint).toString();
    }

    public void write(String fileName, AccordoCooperazione accordoCooperazione) throws SerializerException {
        this.objToXml(fileName, AccordoCooperazione.class, (Object)accordoCooperazione, false);
    }

    public void write(String fileName, AccordoCooperazione accordoCooperazione, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, AccordoCooperazione.class, (Object)accordoCooperazione, prettyPrint);
    }

    public void write(File file, AccordoCooperazione accordoCooperazione) throws SerializerException {
        this.objToXml(file, AccordoCooperazione.class, (Object)accordoCooperazione, false);
    }

    public void write(File file, AccordoCooperazione accordoCooperazione, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, AccordoCooperazione.class, (Object)accordoCooperazione, prettyPrint);
    }

    public void write(OutputStream out, AccordoCooperazione accordoCooperazione) throws SerializerException {
        this.objToXml(out, AccordoCooperazione.class, (Object)accordoCooperazione, false);
    }

    public void write(OutputStream out, AccordoCooperazione accordoCooperazione, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, AccordoCooperazione.class, (Object)accordoCooperazione, prettyPrint);
    }

    public byte[] toByteArray(AccordoCooperazione accordoCooperazione) throws SerializerException {
        return this.objToXml(AccordoCooperazione.class, accordoCooperazione, false).toByteArray();
    }

    public byte[] toByteArray(AccordoCooperazione accordoCooperazione, boolean prettyPrint) throws SerializerException {
        return this.objToXml(AccordoCooperazione.class, accordoCooperazione, prettyPrint).toByteArray();
    }

    public String toString(AccordoCooperazione accordoCooperazione) throws SerializerException {
        return this.objToXml(AccordoCooperazione.class, accordoCooperazione, false).toString();
    }

    public String toString(AccordoCooperazione accordoCooperazione, boolean prettyPrint) throws SerializerException {
        return this.objToXml(AccordoCooperazione.class, accordoCooperazione, prettyPrint).toString();
    }

    public void write(String fileName, CredenzialiSoggetto credenzialiSoggetto) throws SerializerException {
        this.objToXml(fileName, CredenzialiSoggetto.class, (Object)credenzialiSoggetto, false);
    }

    public void write(String fileName, CredenzialiSoggetto credenzialiSoggetto, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, CredenzialiSoggetto.class, (Object)credenzialiSoggetto, prettyPrint);
    }

    public void write(File file, CredenzialiSoggetto credenzialiSoggetto) throws SerializerException {
        this.objToXml(file, CredenzialiSoggetto.class, (Object)credenzialiSoggetto, false);
    }

    public void write(File file, CredenzialiSoggetto credenzialiSoggetto, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, CredenzialiSoggetto.class, (Object)credenzialiSoggetto, prettyPrint);
    }

    public void write(OutputStream out, CredenzialiSoggetto credenzialiSoggetto) throws SerializerException {
        this.objToXml(out, CredenzialiSoggetto.class, (Object)credenzialiSoggetto, false);
    }

    public void write(OutputStream out, CredenzialiSoggetto credenzialiSoggetto, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, CredenzialiSoggetto.class, (Object)credenzialiSoggetto, prettyPrint);
    }

    public byte[] toByteArray(CredenzialiSoggetto credenzialiSoggetto) throws SerializerException {
        return this.objToXml(CredenzialiSoggetto.class, credenzialiSoggetto, false).toByteArray();
    }

    public byte[] toByteArray(CredenzialiSoggetto credenzialiSoggetto, boolean prettyPrint) throws SerializerException {
        return this.objToXml(CredenzialiSoggetto.class, credenzialiSoggetto, prettyPrint).toByteArray();
    }

    public String toString(CredenzialiSoggetto credenzialiSoggetto) throws SerializerException {
        return this.objToXml(CredenzialiSoggetto.class, credenzialiSoggetto, false).toString();
    }

    public String toString(CredenzialiSoggetto credenzialiSoggetto, boolean prettyPrint) throws SerializerException {
        return this.objToXml(CredenzialiSoggetto.class, credenzialiSoggetto, prettyPrint).toString();
    }

    public void write(String fileName, RegistroServizi registroServizi) throws SerializerException {
        this.objToXml(fileName, RegistroServizi.class, (Object)registroServizi, false);
    }

    public void write(String fileName, RegistroServizi registroServizi, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, RegistroServizi.class, (Object)registroServizi, prettyPrint);
    }

    public void write(File file, RegistroServizi registroServizi) throws SerializerException {
        this.objToXml(file, RegistroServizi.class, (Object)registroServizi, false);
    }

    public void write(File file, RegistroServizi registroServizi, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, RegistroServizi.class, (Object)registroServizi, prettyPrint);
    }

    public void write(OutputStream out, RegistroServizi registroServizi) throws SerializerException {
        this.objToXml(out, RegistroServizi.class, (Object)registroServizi, false);
    }

    public void write(OutputStream out, RegistroServizi registroServizi, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, RegistroServizi.class, (Object)registroServizi, prettyPrint);
    }

    public byte[] toByteArray(RegistroServizi registroServizi) throws SerializerException {
        return this.objToXml(RegistroServizi.class, registroServizi, false).toByteArray();
    }

    public byte[] toByteArray(RegistroServizi registroServizi, boolean prettyPrint) throws SerializerException {
        return this.objToXml(RegistroServizi.class, registroServizi, prettyPrint).toByteArray();
    }

    public String toString(RegistroServizi registroServizi) throws SerializerException {
        return this.objToXml(RegistroServizi.class, registroServizi, false).toString();
    }

    public String toString(RegistroServizi registroServizi, boolean prettyPrint) throws SerializerException {
        return this.objToXml(RegistroServizi.class, registroServizi, prettyPrint).toString();
    }

    public void write(String fileName, AccordoServizioParteComune accordoServizioParteComune) throws SerializerException {
        this.objToXml(fileName, AccordoServizioParteComune.class, (Object)accordoServizioParteComune, false);
    }

    public void write(String fileName, AccordoServizioParteComune accordoServizioParteComune, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, AccordoServizioParteComune.class, (Object)accordoServizioParteComune, prettyPrint);
    }

    public void write(File file, AccordoServizioParteComune accordoServizioParteComune) throws SerializerException {
        this.objToXml(file, AccordoServizioParteComune.class, (Object)accordoServizioParteComune, false);
    }

    public void write(File file, AccordoServizioParteComune accordoServizioParteComune, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, AccordoServizioParteComune.class, (Object)accordoServizioParteComune, prettyPrint);
    }

    public void write(OutputStream out, AccordoServizioParteComune accordoServizioParteComune) throws SerializerException {
        this.objToXml(out, AccordoServizioParteComune.class, (Object)accordoServizioParteComune, false);
    }

    public void write(OutputStream out, AccordoServizioParteComune accordoServizioParteComune, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, AccordoServizioParteComune.class, (Object)accordoServizioParteComune, prettyPrint);
    }

    public byte[] toByteArray(AccordoServizioParteComune accordoServizioParteComune) throws SerializerException {
        return this.objToXml(AccordoServizioParteComune.class, accordoServizioParteComune, false).toByteArray();
    }

    public byte[] toByteArray(AccordoServizioParteComune accordoServizioParteComune, boolean prettyPrint) throws SerializerException {
        return this.objToXml(AccordoServizioParteComune.class, accordoServizioParteComune, prettyPrint).toByteArray();
    }

    public String toString(AccordoServizioParteComune accordoServizioParteComune) throws SerializerException {
        return this.objToXml(AccordoServizioParteComune.class, accordoServizioParteComune, false).toString();
    }

    public String toString(AccordoServizioParteComune accordoServizioParteComune, boolean prettyPrint) throws SerializerException {
        return this.objToXml(AccordoServizioParteComune.class, accordoServizioParteComune, prettyPrint).toString();
    }

    public void write(String fileName, PortaDominio portaDominio) throws SerializerException {
        this.objToXml(fileName, PortaDominio.class, (Object)portaDominio, false);
    }

    public void write(String fileName, PortaDominio portaDominio, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, PortaDominio.class, (Object)portaDominio, prettyPrint);
    }

    public void write(File file, PortaDominio portaDominio) throws SerializerException {
        this.objToXml(file, PortaDominio.class, (Object)portaDominio, false);
    }

    public void write(File file, PortaDominio portaDominio, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, PortaDominio.class, (Object)portaDominio, prettyPrint);
    }

    public void write(OutputStream out, PortaDominio portaDominio) throws SerializerException {
        this.objToXml(out, PortaDominio.class, (Object)portaDominio, false);
    }

    public void write(OutputStream out, PortaDominio portaDominio, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, PortaDominio.class, (Object)portaDominio, prettyPrint);
    }

    public byte[] toByteArray(PortaDominio portaDominio) throws SerializerException {
        return this.objToXml(PortaDominio.class, portaDominio, false).toByteArray();
    }

    public byte[] toByteArray(PortaDominio portaDominio, boolean prettyPrint) throws SerializerException {
        return this.objToXml(PortaDominio.class, portaDominio, prettyPrint).toByteArray();
    }

    public String toString(PortaDominio portaDominio) throws SerializerException {
        return this.objToXml(PortaDominio.class, portaDominio, false).toString();
    }

    public String toString(PortaDominio portaDominio, boolean prettyPrint) throws SerializerException {
        return this.objToXml(PortaDominio.class, portaDominio, prettyPrint).toString();
    }

    public void write(String fileName, Gruppo gruppo) throws SerializerException {
        this.objToXml(fileName, Gruppo.class, (Object)gruppo, false);
    }

    public void write(String fileName, Gruppo gruppo, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Gruppo.class, (Object)gruppo, prettyPrint);
    }

    public void write(File file, Gruppo gruppo) throws SerializerException {
        this.objToXml(file, Gruppo.class, (Object)gruppo, false);
    }

    public void write(File file, Gruppo gruppo, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Gruppo.class, (Object)gruppo, prettyPrint);
    }

    public void write(OutputStream out, Gruppo gruppo) throws SerializerException {
        this.objToXml(out, Gruppo.class, (Object)gruppo, false);
    }

    public void write(OutputStream out, Gruppo gruppo, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Gruppo.class, (Object)gruppo, prettyPrint);
    }

    public byte[] toByteArray(Gruppo gruppo) throws SerializerException {
        return this.objToXml(Gruppo.class, gruppo, false).toByteArray();
    }

    public byte[] toByteArray(Gruppo gruppo, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Gruppo.class, gruppo, prettyPrint).toByteArray();
    }

    public String toString(Gruppo gruppo) throws SerializerException {
        return this.objToXml(Gruppo.class, gruppo, false).toString();
    }

    public String toString(Gruppo gruppo, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Gruppo.class, gruppo, prettyPrint).toString();
    }

    public void write(String fileName, Soggetto soggetto) throws SerializerException {
        this.objToXml(fileName, Soggetto.class, (Object)soggetto, false);
    }

    public void write(String fileName, Soggetto soggetto, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Soggetto.class, (Object)soggetto, prettyPrint);
    }

    public void write(File file, Soggetto soggetto) throws SerializerException {
        this.objToXml(file, Soggetto.class, (Object)soggetto, false);
    }

    public void write(File file, Soggetto soggetto, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Soggetto.class, (Object)soggetto, prettyPrint);
    }

    public void write(OutputStream out, Soggetto soggetto) throws SerializerException {
        this.objToXml(out, Soggetto.class, (Object)soggetto, false);
    }

    public void write(OutputStream out, Soggetto soggetto, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Soggetto.class, (Object)soggetto, prettyPrint);
    }

    public byte[] toByteArray(Soggetto soggetto) throws SerializerException {
        return this.objToXml(Soggetto.class, soggetto, false).toByteArray();
    }

    public byte[] toByteArray(Soggetto soggetto, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Soggetto.class, soggetto, prettyPrint).toByteArray();
    }

    public String toString(Soggetto soggetto) throws SerializerException {
        return this.objToXml(Soggetto.class, soggetto, false).toString();
    }

    public String toString(Soggetto soggetto, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Soggetto.class, soggetto, prettyPrint).toString();
    }

    public void write(String fileName, IdGruppo idGruppo) throws SerializerException {
        this.objToXml(fileName, IdGruppo.class, (Object)idGruppo, false);
    }

    public void write(String fileName, IdGruppo idGruppo, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, IdGruppo.class, (Object)idGruppo, prettyPrint);
    }

    public void write(File file, IdGruppo idGruppo) throws SerializerException {
        this.objToXml(file, IdGruppo.class, (Object)idGruppo, false);
    }

    public void write(File file, IdGruppo idGruppo, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, IdGruppo.class, (Object)idGruppo, prettyPrint);
    }

    public void write(OutputStream out, IdGruppo idGruppo) throws SerializerException {
        this.objToXml(out, IdGruppo.class, (Object)idGruppo, false);
    }

    public void write(OutputStream out, IdGruppo idGruppo, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, IdGruppo.class, (Object)idGruppo, prettyPrint);
    }

    public byte[] toByteArray(IdGruppo idGruppo) throws SerializerException {
        return this.objToXml(IdGruppo.class, idGruppo, false).toByteArray();
    }

    public byte[] toByteArray(IdGruppo idGruppo, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IdGruppo.class, idGruppo, prettyPrint).toByteArray();
    }

    public String toString(IdGruppo idGruppo) throws SerializerException {
        return this.objToXml(IdGruppo.class, idGruppo, false).toString();
    }

    public String toString(IdGruppo idGruppo, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IdGruppo.class, idGruppo, prettyPrint).toString();
    }

    public void write(String fileName, RuoliSoggetto ruoliSoggetto) throws SerializerException {
        this.objToXml(fileName, RuoliSoggetto.class, (Object)ruoliSoggetto, false);
    }

    public void write(String fileName, RuoliSoggetto ruoliSoggetto, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, RuoliSoggetto.class, (Object)ruoliSoggetto, prettyPrint);
    }

    public void write(File file, RuoliSoggetto ruoliSoggetto) throws SerializerException {
        this.objToXml(file, RuoliSoggetto.class, (Object)ruoliSoggetto, false);
    }

    public void write(File file, RuoliSoggetto ruoliSoggetto, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, RuoliSoggetto.class, (Object)ruoliSoggetto, prettyPrint);
    }

    public void write(OutputStream out, RuoliSoggetto ruoliSoggetto) throws SerializerException {
        this.objToXml(out, RuoliSoggetto.class, (Object)ruoliSoggetto, false);
    }

    public void write(OutputStream out, RuoliSoggetto ruoliSoggetto, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, RuoliSoggetto.class, (Object)ruoliSoggetto, prettyPrint);
    }

    public byte[] toByteArray(RuoliSoggetto ruoliSoggetto) throws SerializerException {
        return this.objToXml(RuoliSoggetto.class, ruoliSoggetto, false).toByteArray();
    }

    public byte[] toByteArray(RuoliSoggetto ruoliSoggetto, boolean prettyPrint) throws SerializerException {
        return this.objToXml(RuoliSoggetto.class, ruoliSoggetto, prettyPrint).toByteArray();
    }

    public String toString(RuoliSoggetto ruoliSoggetto) throws SerializerException {
        return this.objToXml(RuoliSoggetto.class, ruoliSoggetto, false).toString();
    }

    public String toString(RuoliSoggetto ruoliSoggetto, boolean prettyPrint) throws SerializerException {
        return this.objToXml(RuoliSoggetto.class, ruoliSoggetto, prettyPrint).toString();
    }

    public void write(String fileName, IdAccordoServizioParteComune idAccordoServizioParteComune) throws SerializerException {
        this.objToXml(fileName, IdAccordoServizioParteComune.class, (Object)idAccordoServizioParteComune, false);
    }

    public void write(String fileName, IdAccordoServizioParteComune idAccordoServizioParteComune, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, IdAccordoServizioParteComune.class, (Object)idAccordoServizioParteComune, prettyPrint);
    }

    public void write(File file, IdAccordoServizioParteComune idAccordoServizioParteComune) throws SerializerException {
        this.objToXml(file, IdAccordoServizioParteComune.class, (Object)idAccordoServizioParteComune, false);
    }

    public void write(File file, IdAccordoServizioParteComune idAccordoServizioParteComune, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, IdAccordoServizioParteComune.class, (Object)idAccordoServizioParteComune, prettyPrint);
    }

    public void write(OutputStream out, IdAccordoServizioParteComune idAccordoServizioParteComune) throws SerializerException {
        this.objToXml(out, IdAccordoServizioParteComune.class, (Object)idAccordoServizioParteComune, false);
    }

    public void write(OutputStream out, IdAccordoServizioParteComune idAccordoServizioParteComune, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, IdAccordoServizioParteComune.class, (Object)idAccordoServizioParteComune, prettyPrint);
    }

    public byte[] toByteArray(IdAccordoServizioParteComune idAccordoServizioParteComune) throws SerializerException {
        return this.objToXml(IdAccordoServizioParteComune.class, idAccordoServizioParteComune, false).toByteArray();
    }

    public byte[] toByteArray(IdAccordoServizioParteComune idAccordoServizioParteComune, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IdAccordoServizioParteComune.class, idAccordoServizioParteComune, prettyPrint).toByteArray();
    }

    public String toString(IdAccordoServizioParteComune idAccordoServizioParteComune) throws SerializerException {
        return this.objToXml(IdAccordoServizioParteComune.class, idAccordoServizioParteComune, false).toString();
    }

    public String toString(IdAccordoServizioParteComune idAccordoServizioParteComune, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IdAccordoServizioParteComune.class, idAccordoServizioParteComune, prettyPrint).toString();
    }
}

