/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.rest;

import java.io.Serializable;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.rest.api.Api;

public class AccordoServizioWrapper
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private transient Api api = null;
    private transient Semaphore _semaphore = new Semaphore("AccordoServizioWrapperREST");
    private IDAccordo idAccordoServizio;
    private AccordoServizioParteComune accordoServizio;
    private String locationSpecifica;
    private byte[] bytesSpecifica;
    private boolean registroServiziDB = false;

    public Api getApi() {
        return this.api;
    }

    public void setApi(Api api) {
        this.api = api;
    }

    public Semaphore getSemaphore() {
        if (this._semaphore == null) {
            this.initSemaphore();
        }
        return this._semaphore;
    }

    private synchronized void initSemaphore() {
        this._semaphore = new Semaphore("AccordoServizioWrapperREST");
    }

    public void updateApi(Api api) {
        SemaphoreLock lock = this.getSemaphore().acquireThrowRuntime("updateAPI");
        try {
            this.api = api;
        }
        finally {
            this.getSemaphore().release(lock, "updateAPI");
        }
    }

    public IDAccordo getIdAccordoServizio() {
        return this.idAccordoServizio;
    }

    public void setIdAccordoServizio(IDAccordo idAccordoServizio) {
        this.idAccordoServizio = idAccordoServizio;
    }

    public AccordoServizioParteComune getAccordoServizio() {
        return this.accordoServizio;
    }

    public void setAccordoServizio(AccordoServizioParteComune accordoServizio) {
        this.accordoServizio = accordoServizio;
    }

    public String getLocationSpecifica() {
        return this.locationSpecifica;
    }

    public void setLocationSpecifica(String locationSpecifica) {
        this.locationSpecifica = locationSpecifica;
    }

    public byte[] getBytesSpecifica() {
        return this.bytesSpecifica;
    }

    public void setBytesSpecifica(byte[] bytesSpecifica) {
        this.bytesSpecifica = bytesSpecifica;
    }

    public boolean isRegistroServiziDB() {
        return this.registroServiziDB;
    }

    public void setRegistroServiziDB(boolean registroServiziDB) {
        this.registroServiziDB = registroServiziDB;
    }

    public AccordoServizioWrapper clone() {
        AccordoServizioWrapper as = new AccordoServizioWrapper();
        if (this.accordoServizio != null) {
            as.accordoServizio = (AccordoServizioParteComune)this.accordoServizio.clone();
        }
        if (this.idAccordoServizio != null) {
            as.idAccordoServizio = this.idAccordoServizio.clone();
        }
        if (this.locationSpecifica != null) {
            as.locationSpecifica = new String(this.locationSpecifica);
        }
        as.bytesSpecifica = this.bytesSpecifica;
        if (this.api != null) {
            as.api = this.api;
        }
        as.registroServiziDB = this.registroServiziDB;
        return as;
    }
}

