/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.Filtri;
import org.openspcoop2.core.commons.IMonitoraggioRisorsa;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoAzione;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDFruizione;
import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.id.IDPortType;
import org.openspcoop2.core.id.IDPortTypeAzione;
import org.openspcoop2.core.id.IDResource;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.id.IDScope;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Azione;
import org.openspcoop2.core.registry.CredenzialiSoggetto;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.Gruppo;
import org.openspcoop2.core.registry.GruppoAccordo;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.RegistroServizi;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.Ruolo;
import org.openspcoop2.core.registry.Scope;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.CredenzialeTipo;
import org.openspcoop2.core.registry.constants.RuoloContesto;
import org.openspcoop2.core.registry.constants.RuoloTipologia;
import org.openspcoop2.core.registry.constants.ScopeContesto;
import org.openspcoop2.core.registry.constants.TipiDocumentoLivelloServizio;
import org.openspcoop2.core.registry.constants.TipiDocumentoSemiformale;
import org.openspcoop2.core.registry.constants.TipiDocumentoSicurezza;
import org.openspcoop2.core.registry.constants.TipologiaServizio;
import org.openspcoop2.core.registry.driver.BeanUtilities;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicerca;
import org.openspcoop2.core.registry.driver.FiltroRicercaAccordi;
import org.openspcoop2.core.registry.driver.FiltroRicercaAzioni;
import org.openspcoop2.core.registry.driver.FiltroRicercaFruizioniServizio;
import org.openspcoop2.core.registry.driver.FiltroRicercaGruppi;
import org.openspcoop2.core.registry.driver.FiltroRicercaOperations;
import org.openspcoop2.core.registry.driver.FiltroRicercaPortTypes;
import org.openspcoop2.core.registry.driver.FiltroRicercaResources;
import org.openspcoop2.core.registry.driver.FiltroRicercaRuoli;
import org.openspcoop2.core.registry.driver.FiltroRicercaScope;
import org.openspcoop2.core.registry.driver.FiltroRicercaServizi;
import org.openspcoop2.core.registry.driver.FiltroRicercaSoggetti;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.registry.driver.IDriverRegistroServiziGet;
import org.openspcoop2.core.registry.driver.ProtocolPropertiesUtilities;
import org.openspcoop2.core.registry.driver.ValidazioneSemantica;
import org.openspcoop2.core.registry.utils.serializer.JaxbDeserializer;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.xml.ValidatoreXSD;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.ArchiveType;
import org.openspcoop2.utils.certificate.Certificate;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.certificate.CertificateUtils;
import org.openspcoop2.utils.certificate.PrincipalType;
import org.openspcoop2.utils.crypt.CryptConfig;
import org.openspcoop2.utils.crypt.CryptFactory;
import org.openspcoop2.utils.crypt.ICrypt;
import org.openspcoop2.utils.date.DateManager;
import org.slf4j.Logger;

public class DriverRegistroServiziXML
extends BeanUtilities
implements IDriverRegistroServiziGet,
IMonitoraggioRisorsa {
    public boolean create = false;
    private String registry_path;
    private RegistroServizi registro;
    private ValidatoreXSD validatoreRegistro = null;
    private IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
    private IDAccordoCooperazioneFactory idAccordoCooperazioneFactory = IDAccordoCooperazioneFactory.getInstance();
    private IDServizioFactory idServizioFactory = IDServizioFactory.getInstance();
    private long lastModified = 0L;
    private Logger log = null;
    private static final int timeoutRefresh = 30;
    private boolean validazioneSemanticaDuranteModificaXML = false;
    private boolean verificaURI = false;
    private String[] tipiConnettori = null;
    private String[] tipiSoggetti = null;
    private String[] tipiServiziSoap = null;
    private String[] tipiServiziRest = null;

    public RegistroServizi getRegistroXML() {
        return this.registro;
    }

    public void parsingXMLRegistroServizi() throws DriverRegistroServiziException {
        FileInputStream fXML = null;
        try {
            if (this.registry_path.startsWith("http://") || this.registry_path.startsWith("file://")) {
                this.validatoreRegistro.valida(this.registry_path);
            } else {
                fXML = new FileInputStream(this.registry_path);
                this.validatoreRegistro.valida((InputStream)fXML);
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage());
        }
        finally {
            if (fXML != null) {
                try {
                    fXML.close();
                }
                catch (Exception exception) {}
            }
        }
        InputStream iStream = null;
        HttpURLConnection httpConn = null;
        if (this.registry_path.startsWith("http://") || this.registry_path.startsWith("file://")) {
            try {
                URL url = new URL(this.registry_path);
                URLConnection connection = url.openConnection();
                httpConn = (HttpURLConnection)connection;
                httpConn.setRequestMethod("GET");
                httpConn.setDoOutput(true);
                httpConn.setDoInput(true);
                iStream = httpConn.getInputStream();
            }
            catch (Exception e) {
                try {
                    if (httpConn != null) {
                        httpConn.disconnect();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new DriverRegistroServiziException("Riscontrato errore durante la creazione dell'inputStream del registro dei servizi (HTTP) : \n\n" + e.getMessage());
            }
            this.lastModified = DateManager.getTimeMillis();
        } else {
            try {
                iStream = new FileInputStream(this.registry_path);
            }
            catch (FileNotFoundException e) {
                throw new DriverRegistroServiziException("Riscontrato errore durante la creazione dell'inputStream del registro dei servizi (FILE) : \n\n" + e.getMessage());
            }
            try {
                this.lastModified = new File(this.registry_path).lastModified();
            }
            catch (Exception e) {
                try {
                    if (iStream != null) {
                        iStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new DriverRegistroServiziException("Riscontrato errore durante la lettura del file dove e' allocato il registro dei servizi: " + e.getMessage());
            }
        }
        try {
            JaxbDeserializer deserializer = new JaxbDeserializer();
            this.registro = deserializer.readRegistroServizi(iStream);
        }
        catch (Exception e) {
            try {
                if (iStream != null) {
                    iStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (httpConn != null) {
                    httpConn.disconnect();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new DriverRegistroServiziException("Riscontrato errore durante l'unmarshall del file di configurazione: " + e.getMessage());
        }
        try {
            if (iStream != null) {
                iStream.close();
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante la chiusura dell'Input Stream: " + e.getMessage());
        }
        try {
            if (httpConn != null) {
                httpConn.disconnect();
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante la chiusura dell'Input Stream (http): " + e.getMessage());
        }
    }

    public DriverRegistroServiziXML(String path, Logger alog) {
        this.log = alog == null ? LoggerWrapperFactory.getLogger(DriverRegistroServiziXML.class) : alog;
        if (path == null) {
            this.log.error("DriverRegistroServizi: Riscontrato errore durante la creazione: url/path is null");
            this.create = false;
            return;
        }
        this.registry_path = path;
        try {
            this.validatoreRegistro = new ValidatoreXSD(OpenSPCoop2MessageFactory.getDefaultMessageFactory(), this.log, DriverRegistroServiziXML.class.getResourceAsStream("/registroServizi.xsd"));
        }
        catch (Exception e) {
            this.log.error("Riscontrato errore durante l'inizializzazione dello schema del Registro dei Servizi di OpenSPCoop: " + e.getMessage());
            return;
        }
        try {
            this.parsingXMLRegistroServizi();
        }
        catch (Exception e) {
            this.log.error("DriverRegistroServizi: " + e.getMessage());
            this.create = false;
            return;
        }
        this.create = true;
    }

    private void forzaRefreshRegistroServiziXML() throws DriverRegistroServiziException {
        this.refreshRegistroServiziXML(true);
    }

    public void refreshRegistroServiziXML() throws DriverRegistroServiziException {
        this.refreshRegistroServiziXML(false);
    }

    private synchronized void refreshRegistroServiziXML(boolean refreshForzato) throws DriverRegistroServiziException {
        File fTest = null;
        boolean refresh = refreshForzato;
        if (!refreshForzato) {
            if (this.registry_path.startsWith("http://") || this.registry_path.startsWith("file://")) {
                long now = DateManager.getTimeMillis();
                if (now - this.lastModified > 30000L) {
                    refresh = true;
                }
            } else {
                fTest = new File(this.registry_path);
                if (this.lastModified != fTest.lastModified()) {
                    refresh = true;
                }
            }
        }
        if (refresh) {
            try {
                this.parsingXMLRegistroServizi();
            }
            catch (Exception e) {
                this.log.error("DriverRegistroServizi refreshError: " + e.getMessage());
                throw new DriverRegistroServiziException("DriverRegistroServizi refreshError: " + e.getMessage());
            }
            if (!this.registry_path.startsWith("http://") && !this.registry_path.startsWith("file://")) {
                this.log.warn("Reloaded registry context.");
            }
            if (this.validazioneSemanticaDuranteModificaXML) {
                ValidazioneSemantica validazioneSemantica = new ValidazioneSemantica(this.registro, this.verificaURI, this.tipiConnettori, this.tipiSoggetti, this.tipiServiziSoap, this.tipiServiziRest, this.log);
                try {
                    validazioneSemantica.validazioneSemantica(false);
                }
                catch (Exception e) {
                    this.log.error("DriverRegistroServizi refreshError(ValidazioneSemantica): " + e.getMessage());
                    throw new DriverRegistroServiziException("DriverRegistroServizi refreshError(ValidazioneSemantica): " + e.getMessage());
                }
            }
        }
        if (this.registro == null) {
            this.log.error("DriverRegistroServizi refreshError: istanza del registro is null dopo il refresh");
            throw new DriverRegistroServiziException("DriverRegistroServizi refreshError: istanza del registro is null dopo il refresh");
        }
    }

    public void abilitazioneValidazioneSemanticaDuranteModificaXML(boolean verificaURI, String[] tipiConnettori, String[] tipiSoggetti, String[] tipiServiziSoapValidi, String[] tipiServiziRestValidi) {
        this.validazioneSemanticaDuranteModificaXML = true;
        this.verificaURI = verificaURI;
        this.tipiConnettori = tipiConnettori;
        this.tipiSoggetti = tipiSoggetti;
        this.tipiServiziSoap = tipiServiziSoapValidi;
        this.tipiServiziRest = tipiServiziRestValidi;
    }

    @Override
    public AccordoCooperazione getAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoCooperazione] Parametro Non Valido");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoCooperazione] Nome accordo non presente");
        }
        this.refreshRegistroServiziXML();
        for (int i = 0; i < this.registro.sizeAccordoCooperazioneList(); ++i) {
            AccordoCooperazione ac = this.registro.getAccordoCooperazione(i);
            if (ac.getNome() == null || !ac.getNome().equals(idAccordo.getNome()) || (idAccordo.getVersione() == null ? ac.getVersione() != null : !idAccordo.getVersione().equals(ac.getVersione()))) continue;
            String uriAccordoCooperazione = this.idAccordoCooperazioneFactory.getUriFromAccordo(ac);
            for (int j = 0; j < this.registro.sizeAccordoServizioParteComuneList(); ++j) {
                AccordoServizioParteComune as = this.registro.getAccordoServizioParteComune(j);
                if (as.getServizioComposto() == null || !uriAccordoCooperazione.equals(as.getServizioComposto().getAccordoCooperazione())) continue;
                ac.addUriServiziComposti(this.idAccordoFactory.getUriFromAccordo(as));
            }
            return ac;
        }
        throw new DriverRegistroServiziNotFound("[getAccordoCooperazione] Accordo di Cooperazione non trovato");
    }

    @Override
    public List<IDAccordoCooperazione> getAllIdAccordiCooperazione(FiltroRicercaAccordi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            ArrayList<IDAccordoCooperazione> idAccordi = new ArrayList<IDAccordoCooperazione>();
            for (int i = 0; i < this.registro.sizeAccordoCooperazioneList(); ++i) {
                AccordoCooperazione ac = this.registro.getAccordoCooperazione(i);
                String uriAC = this.idAccordoCooperazioneFactory.getUriFromAccordo(ac);
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (ac.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdAccordiCooperazione](FiltroByMinDate) Accordo di cooperazione [" + uriAC + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (ac.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (ac.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdAccordiCooperazione](FiltroByMaxDate) Accordo di cooperazione [" + uriAC + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (ac.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNomeAccordo() != null && !ac.getNome().equals(filtroRicerca.getNomeAccordo()) || filtroRicerca.getVersione() != null && !ac.getVersione().equals(filtroRicerca.getVersione()) || (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null) && (ac.getSoggettoReferente() == null || filtroRicerca.getTipoSoggettoReferente() != null && !ac.getSoggettoReferente().getTipo().equals(filtroRicerca.getTipoSoggettoReferente()) || filtroRicerca.getNomeSoggettoReferente() != null && !ac.getSoggettoReferente().getNome().equals(filtroRicerca.getNomeSoggettoReferente())) || !ProtocolPropertiesUtilities.isMatch(ac, filtroRicerca.getProtocolPropertiesAccordo())) continue;
                }
                idAccordi.add(this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(ac));
            }
            if (idAccordi.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Accordi di cooperazione non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Accordi di cooperazione non trovati");
            }
            return idAccordi;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdAccordiCooperazione error", e);
        }
    }

    @Override
    public AccordoServizioParteComune getAccordoServizioParteComune(IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComune] Parametro Non Valido");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComune] Nome accordo non presente");
        }
        IDSoggetto soggettoReferenteCheck = idAccordo.getSoggettoReferente();
        if (soggettoReferenteCheck != null) {
            if (soggettoReferenteCheck.getTipo() == null) {
                throw new DriverRegistroServiziException("[getAccordoServizioParteComune] Tipo soggetto referente non presente?");
            }
            if (soggettoReferenteCheck.getNome() == null) {
                throw new DriverRegistroServiziException("[getAccordoServizioParteComune] Nome soggetto referente non presente?");
            }
        }
        this.refreshRegistroServiziXML();
        for (int i = 0; i < this.registro.sizeAccordoServizioParteComuneList(); ++i) {
            AccordoServizioParteComune as = this.registro.getAccordoServizioParteComune(i);
            if (as.getNome() == null || !as.getNome().equals(idAccordo.getNome()) || (soggettoReferenteCheck != null ? as.getSoggettoReferente() == null || !soggettoReferenteCheck.getTipo().equals(as.getSoggettoReferente().getTipo()) || !soggettoReferenteCheck.getNome().equals(as.getSoggettoReferente().getNome()) : as.getSoggettoReferente() != null)) continue;
            if (idAccordo.getVersione() == null ? as.getVersione() != null : !idAccordo.getVersione().equals(as.getVersione())) continue;
            return as;
        }
        throw new DriverRegistroServiziNotFound("[getAccordoServizioParteComune] Accordo di Servizio non trovato");
    }

    @Override
    public List<IDAccordo> getAllIdAccordiServizioParteComune(FiltroRicercaAccordi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDAccordo> list = new ArrayList<IDAccordo>();
        this._fillAllIdAccordiServizioParteComuneEngine("getAllIdAccordiServizioParteComune", filtroRicerca, null, null, null, null, list);
        return list;
    }

    @Override
    public List<IDPortType> getAllIdPortType(FiltroRicercaPortTypes filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDPortType> list = new ArrayList<IDPortType>();
        this._fillAllIdAccordiServizioParteComuneEngine("getAllIdPortType", filtroRicerca, filtroRicerca, null, null, null, list);
        return list;
    }

    @Override
    public List<IDPortTypeAzione> getAllIdAzionePortType(FiltroRicercaOperations filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDPortTypeAzione> list = new ArrayList<IDPortTypeAzione>();
        this._fillAllIdAccordiServizioParteComuneEngine("getAllIdAzionePortType", filtroRicerca, null, filtroRicerca, null, null, list);
        return list;
    }

    @Override
    public List<IDAccordoAzione> getAllIdAzioneAccordo(FiltroRicercaAzioni filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDAccordoAzione> list = new ArrayList<IDAccordoAzione>();
        this._fillAllIdAccordiServizioParteComuneEngine("getAllIdAzioneAccordo", filtroRicerca, null, null, filtroRicerca, null, list);
        return list;
    }

    @Override
    public List<IDResource> getAllIdResource(FiltroRicercaResources filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDResource> list = new ArrayList<IDResource>();
        this._fillAllIdAccordiServizioParteComuneEngine("getAllIdResource", filtroRicerca, null, null, null, filtroRicerca, list);
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> void _fillAllIdAccordiServizioParteComuneEngine(String nomeMetodo, FiltroRicercaAccordi filtroRicercaBase, FiltroRicercaPortTypes filtroPT, FiltroRicercaOperations filtroOP, FiltroRicercaAzioni filtroAZ, FiltroRicercaResources filtroResource, List<T> listReturn) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            int i = 0;
            while (true) {
                block21: {
                    Iterator<Resource> iterator;
                    IDAccordo idAccordo;
                    block37: {
                        Iterator<Azione> iterator2;
                        block35: {
                            Iterator<PortType> iterator3;
                            block33: {
                                Iterator<PortType> iterator4;
                                block31: {
                                    block17: {
                                        block36: {
                                            AccordoServizioParteComune as;
                                            block34: {
                                                block32: {
                                                    block30: {
                                                        block18: {
                                                            block29: {
                                                                block28: {
                                                                    block27: {
                                                                        block24: {
                                                                            block26: {
                                                                                boolean searchByTipoSoggetto;
                                                                                List<String> tipoSoggettiProtocollo;
                                                                                block25: {
                                                                                    block22: {
                                                                                        block23: {
                                                                                            String uriAS;
                                                                                            block19: {
                                                                                                block20: {
                                                                                                    if (i >= this.registro.sizeAccordoServizioParteComuneList()) break block17;
                                                                                                    as = this.registro.getAccordoServizioParteComune(i);
                                                                                                    uriAS = this.idAccordoFactory.getUriFromAccordo(as);
                                                                                                    if (filtroRicercaBase == null) break block18;
                                                                                                    tipoSoggettiProtocollo = null;
                                                                                                    try {
                                                                                                        if (filtroRicercaBase != null && (filtroRicercaBase.getProtocollo() != null || filtroRicercaBase.getProtocolli() != null && !filtroRicercaBase.getProtocolli().isEmpty())) {
                                                                                                            tipoSoggettiProtocollo = Filtri.convertToTipiSoggetti(filtroRicercaBase.getProtocollo(), Filtri.convertToString(filtroRicercaBase.getProtocolli()));
                                                                                                        }
                                                                                                    }
                                                                                                    catch (Exception e) {
                                                                                                        throw new DriverRegistroServiziException(e.getMessage(), e);
                                                                                                    }
                                                                                                    boolean bl = searchByTipoSoggetto = tipoSoggettiProtocollo != null && tipoSoggettiProtocollo.size() > 0;
                                                                                                    if (filtroRicercaBase.getMinDate() == null) break block19;
                                                                                                    if (as.getOraRegistrazione() != null) break block20;
                                                                                                    this.log.debug("[" + nomeMetodo + "](FiltroByMinDate) Accordo di servizio [" + uriAS + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                                                                                                    break block21;
                                                                                                }
                                                                                                if (as.getOraRegistrazione().before(filtroRicercaBase.getMinDate())) break block21;
                                                                                            }
                                                                                            if (filtroRicercaBase.getMaxDate() == null) break block22;
                                                                                            if (as.getOraRegistrazione() != null) break block23;
                                                                                            this.log.debug("[" + nomeMetodo + "](FiltroByMaxDate) Accordo di servizio [" + uriAS + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                                                                                            break block21;
                                                                                        }
                                                                                        if (as.getOraRegistrazione().after(filtroRicercaBase.getMaxDate())) break block21;
                                                                                    }
                                                                                    if (filtroRicercaBase.getNomeAccordo() != null && !as.getNome().equals(filtroRicercaBase.getNomeAccordo()) || filtroRicercaBase.getVersione() != null && !as.getVersione().equals(filtroRicercaBase.getVersione())) break block21;
                                                                                    if (!searchByTipoSoggetto && filtroRicercaBase.getTipoSoggettoReferente() == null && filtroRicercaBase.getNomeSoggettoReferente() == null) break block24;
                                                                                    if (as.getSoggettoReferente() == null) break block21;
                                                                                    if (filtroRicercaBase.getTipoSoggettoReferente() == null) break block25;
                                                                                    if (as.getSoggettoReferente().getTipo().equals(filtroRicercaBase.getTipoSoggettoReferente())) break block26;
                                                                                    break block21;
                                                                                }
                                                                                if (!searchByTipoSoggetto) break block26;
                                                                                boolean find = false;
                                                                                for (String tipoSoggettoProtocollo : tipoSoggettiProtocollo) {
                                                                                    if (!as.getSoggettoReferente().getTipo().equals(tipoSoggettoProtocollo)) continue;
                                                                                    find = true;
                                                                                    break;
                                                                                }
                                                                                if (!find) break block21;
                                                                            }
                                                                            if (filtroRicercaBase.getNomeSoggettoReferente() != null && !as.getSoggettoReferente().getNome().equals(filtroRicercaBase.getNomeSoggettoReferente())) break block21;
                                                                        }
                                                                        if (filtroRicercaBase.getServiceBinding() != null && !as.getServiceBinding().equals(filtroRicercaBase.getServiceBinding())) break block21;
                                                                        if (filtroRicercaBase.getIdGruppo() == null || filtroRicercaBase.getIdGruppo().getNome() == null) break block27;
                                                                        boolean found = false;
                                                                        if (as.getGruppi() != null && as.getGruppi().sizeGruppoList() > 0) {
                                                                            for (GruppoAccordo gruppo : as.getGruppi().getGruppoList()) {
                                                                                if (!gruppo.getNome().equals(filtroRicercaBase.getIdGruppo().getNome())) continue;
                                                                                found = true;
                                                                                break;
                                                                            }
                                                                        }
                                                                        if (!found) break block21;
                                                                    }
                                                                    if (filtroRicercaBase.getIdAccordoCooperazione() == null || filtroRicercaBase.getIdAccordoCooperazione().getNome() == null && filtroRicercaBase.getIdAccordoCooperazione().getVersione() == null) break block28;
                                                                    if (as.getServizioComposto() == null) break block21;
                                                                    IDAccordoCooperazione idAC = this.idAccordoCooperazioneFactory.getIDAccordoFromUri(as.getServizioComposto().getAccordoCooperazione());
                                                                    if ((filtroRicercaBase.getIdAccordoCooperazione().getNome() == null || idAC.getNome().equals(filtroRicercaBase.getIdAccordoCooperazione().getNome())) && (filtroRicercaBase.getIdAccordoCooperazione().getVersione() == null || idAC.getVersione().equals(filtroRicercaBase.getIdAccordoCooperazione().getVersione()))) break block29;
                                                                    break block21;
                                                                }
                                                                if (filtroRicercaBase.isServizioComposto() != null && (filtroRicercaBase.isServizioComposto() == false ? as.getServizioComposto() != null : as.getServizioComposto() == null)) break block21;
                                                            }
                                                            if (!ProtocolPropertiesUtilities.isMatch(as, filtroRicercaBase.getProtocolPropertiesAccordo())) break block21;
                                                        }
                                                        idAccordo = this.idAccordoFactory.getIDAccordoFromAccordo(as);
                                                        if (filtroPT == null) break block30;
                                                        iterator4 = as.getPortTypeList().iterator();
                                                        break block31;
                                                    }
                                                    if (filtroOP == null) break block32;
                                                    iterator3 = as.getPortTypeList().iterator();
                                                    break block33;
                                                }
                                                if (filtroAZ == null) break block34;
                                                iterator2 = as.getAzioneList().iterator();
                                                break block35;
                                            }
                                            if (filtroResource == null) break block36;
                                            iterator = as.getResourceList().iterator();
                                            break block37;
                                        }
                                        listReturn.add(idAccordo);
                                        break block21;
                                    }
                                    if (listReturn.size() > 0) return;
                                    String msgFiltro = "Elementi non trovati che rispettano il filtro di ricerca selezionato: ";
                                    if (filtroPT != null) {
                                        throw new DriverRegistroServiziNotFound(msgFiltro + filtroPT.toString());
                                    }
                                    if (filtroOP != null) {
                                        throw new DriverRegistroServiziNotFound(msgFiltro + filtroOP.toString());
                                    }
                                    if (filtroAZ != null) {
                                        throw new DriverRegistroServiziNotFound(msgFiltro + filtroAZ.toString());
                                    }
                                    if (filtroRicercaBase == null) throw new DriverRegistroServiziNotFound("Elementi non trovati");
                                    throw new DriverRegistroServiziNotFound(msgFiltro + filtroRicercaBase.toString());
                                }
                                while (iterator4.hasNext()) {
                                    PortType pt = iterator4.next();
                                    if (filtroPT.getNomePortType() != null && !pt.getNome().equals(filtroPT.getNomePortType()) || !ProtocolPropertiesUtilities.isMatch(pt, filtroPT.getProtocolPropertiesPortType())) continue;
                                    IDPortType idPT = new IDPortType();
                                    idPT.setIdAccordo(idAccordo);
                                    idPT.setNome(pt.getNome());
                                    listReturn.add(idPT);
                                }
                                break block21;
                            }
                            while (iterator3.hasNext()) {
                                PortType pt = iterator3.next();
                                if (filtroOP.getNomePortType() != null && !pt.getNome().equals(filtroOP.getNomePortType()) || !ProtocolPropertiesUtilities.isMatch(pt, filtroOP.getProtocolPropertiesPortType())) continue;
                                for (Operation op : pt.getAzioneList()) {
                                    if (filtroOP.getNomeAzione() != null && !op.getNome().equals(filtroOP.getNomeAzione()) || !ProtocolPropertiesUtilities.isMatch(pt, filtroOP.getProtocolPropertiesAzione())) continue;
                                    IDPortTypeAzione idAzione = new IDPortTypeAzione();
                                    IDPortType idPT = new IDPortType();
                                    idPT.setIdAccordo(idAccordo);
                                    idPT.setNome(pt.getNome());
                                    idAzione.setIdPortType(idPT);
                                    idAzione.setNome(op.getNome());
                                    listReturn.add(idAzione);
                                }
                            }
                            break block21;
                        }
                        while (iterator2.hasNext()) {
                            Azione az = iterator2.next();
                            if (filtroAZ.getNomeAzione() != null && !az.getNome().equals(filtroAZ.getNomeAzione()) || !ProtocolPropertiesUtilities.isMatch(az, filtroAZ.getProtocolPropertiesAzione())) continue;
                            IDAccordoAzione idAzione = new IDAccordoAzione();
                            idAzione.setIdAccordo(idAccordo);
                            idAzione.setNome(az.getNome());
                            listReturn.add(idAzione);
                        }
                        break block21;
                    }
                    while (iterator.hasNext()) {
                        Resource resource = iterator.next();
                        if (filtroResource.getResourceName() != null && !resource.getNome().equals(filtroResource.getResourceName()) || !ProtocolPropertiesUtilities.isMatch(resource, filtroResource.getProtocolPropertiesResources())) continue;
                        IDResource idResource = new IDResource();
                        idResource.setIdAccordo(idAccordo);
                        idResource.setNome(resource.getNome());
                        listReturn.add(idResource);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(nomeMetodo + " error", e);
        }
    }

    @Override
    public Documento getAllegato(IDAccordo idAccordo, String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoServizioParteComune aspc = this.getAccordoServizioParteComune(idAccordo);
        if (aspc.sizeAllegatoList() > 0) {
            for (Documento doc : aspc.getAllegatoList()) {
                File f = new File(doc.getFile());
                if (!nome.equals(doc.getFile()) && !nome.equals(f.getName())) continue;
                return doc;
            }
        }
        throw new DriverRegistroServiziNotFound("Documento '" + nome + "' non trovato");
    }

    @Override
    public Documento getSpecificaSemiformale(IDAccordo idAccordo, TipiDocumentoSemiformale tipo, String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoServizioParteComune aspc = this.getAccordoServizioParteComune(idAccordo);
        if (aspc.sizeSpecificaSemiformaleList() > 0) {
            for (Documento doc : aspc.getSpecificaSemiformaleList()) {
                File f = new File(doc.getFile());
                if (!nome.equals(doc.getFile()) && !nome.equals(f.getName()) || tipo == null || !tipo.getNome().equals(doc.getTipo())) continue;
                return doc;
            }
        }
        throw new DriverRegistroServiziNotFound("Documento '" + nome + "' non trovato");
    }

    @Override
    public PortaDominio getPortaDominio(String nomePdD) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (nomePdD == null) {
            throw new DriverRegistroServiziException("[getPortaDominio] Parametro Non Valido");
        }
        this.refreshRegistroServiziXML();
        for (int i = 0; i < this.registro.sizePortaDominioList(); ++i) {
            PortaDominio pd = this.registro.getPortaDominio(i);
            if (pd.getNome() == null || !pd.getNome().equals(nomePdD)) continue;
            return pd;
        }
        throw new DriverRegistroServiziNotFound("[getPortaDominio] Porta di Dominio non trovata");
    }

    @Override
    public List<String> getAllIdPorteDominio(FiltroRicerca filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            ArrayList<String> nomiPorteDiDominio = new ArrayList<String>();
            for (int i = 0; i < this.registro.sizePortaDominioList(); ++i) {
                PortaDominio pd = this.registro.getPortaDominio(i);
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (pd.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdPorteDominio](FiltroByMinDate) Porta di Dominio [" + pd.getNome() + "] non valorizzata nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (pd.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (pd.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdPorteDominio](FiltroByMaxDate) Porta di Dominio [" + pd.getNome() + "] non valorizzata nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (pd.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNome() != null && !pd.getNome().equals(filtroRicerca.getNome())) continue;
                }
                nomiPorteDiDominio.add(pd.getNome());
            }
            if (nomiPorteDiDominio.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Porte di Dominio non trovate che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Porte di Dominio non trovate");
            }
            return nomiPorteDiDominio;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdPorteDominio error", e);
        }
    }

    @Override
    public Gruppo getGruppo(IDGruppo idGruppo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idGruppo == null || idGruppo.getNome() == null) {
            throw new DriverRegistroServiziException("[getGruppo] Parametro Non Valido");
        }
        this.refreshRegistroServiziXML();
        for (int i = 0; i < this.registro.sizeGruppoList(); ++i) {
            Gruppo gruppo = this.registro.getGruppo(i);
            if (gruppo.getNome() == null || !gruppo.getNome().equals(idGruppo.getNome())) continue;
            return gruppo;
        }
        throw new DriverRegistroServiziNotFound("[getGruppo] Gruppo non trovato");
    }

    @Override
    public List<IDGruppo> getAllIdGruppi(FiltroRicercaGruppi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            ArrayList<IDGruppo> idGruppi = new ArrayList<IDGruppo>();
            for (int i = 0; i < this.registro.sizeGruppoList(); ++i) {
                Gruppo gruppo = this.registro.getGruppo(i);
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (gruppo.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdGruppi](FiltroByMinDate) Gruppo [" + gruppo.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (gruppo.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (gruppo.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdGruppi](FiltroByMaxDate) Gruppo [" + gruppo.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (gruppo.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNome() != null && !gruppo.getNome().equals(filtroRicerca.getNome()) || filtroRicerca.getServiceBinding() != null && gruppo.getServiceBinding() != null && !gruppo.getServiceBinding().equals(filtroRicerca.getServiceBinding())) continue;
                }
                IDGruppo id = new IDGruppo(gruppo.getNome());
                idGruppi.add(id);
            }
            if (idGruppi.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Gruppi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Gruppi non trovati");
            }
            return idGruppi;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdGruppi error", e);
        }
    }

    @Override
    public Ruolo getRuolo(IDRuolo idRuolo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idRuolo == null || idRuolo.getNome() == null) {
            throw new DriverRegistroServiziException("[getRuolo] Parametro Non Valido");
        }
        this.refreshRegistroServiziXML();
        for (int i = 0; i < this.registro.sizeRuoloList(); ++i) {
            Ruolo ruolo = this.registro.getRuolo(i);
            if (ruolo.getNome() == null || !ruolo.getNome().equals(idRuolo.getNome())) continue;
            return ruolo;
        }
        throw new DriverRegistroServiziNotFound("[getRuolo] Ruolo non trovato");
    }

    @Override
    public List<IDRuolo> getAllIdRuoli(FiltroRicercaRuoli filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            ArrayList<IDRuolo> idRuoli = new ArrayList<IDRuolo>();
            for (int i = 0; i < this.registro.sizeRuoloList(); ++i) {
                Ruolo ruolo = this.registro.getRuolo(i);
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (ruolo.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdRuoli](FiltroByMinDate) Ruolo [" + ruolo.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (ruolo.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (ruolo.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdRuoli](FiltroByMaxDate) Ruolo [" + ruolo.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (ruolo.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNome() != null && !ruolo.getNome().equals(filtroRicerca.getNome()) || filtroRicerca.getTipologia() != null && !RuoloTipologia.QUALSIASI.equals(filtroRicerca.getTipologia()) && (ruolo.getTipologia() == null || !RuoloTipologia.QUALSIASI.equals(ruolo.getTipologia()) && !ruolo.getTipologia().equals(filtroRicerca.getTipologia())) || filtroRicerca.getContesto() != null && !RuoloContesto.QUALSIASI.equals(filtroRicerca.getContesto()) && (ruolo.getContestoUtilizzo() == null || !RuoloContesto.QUALSIASI.equals(ruolo.getContestoUtilizzo()) && !ruolo.getContestoUtilizzo().equals(filtroRicerca.getContesto()))) continue;
                }
                IDRuolo id = new IDRuolo(ruolo.getNome());
                idRuoli.add(id);
            }
            if (idRuoli.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Ruoli non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Ruoli non trovati");
            }
            return idRuoli;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdRuoli error", e);
        }
    }

    @Override
    public Scope getScope(IDScope idScope) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idScope == null || idScope.getNome() == null) {
            throw new DriverRegistroServiziException("[getScope] Parametro Non Valido");
        }
        this.refreshRegistroServiziXML();
        for (int i = 0; i < this.registro.sizeScopeList(); ++i) {
            Scope scope = this.registro.getScope(i);
            if (scope.getNome() == null || !scope.getNome().equals(idScope.getNome())) continue;
            return scope;
        }
        throw new DriverRegistroServiziNotFound("[getScope] Scope non trovato");
    }

    @Override
    public List<IDScope> getAllIdScope(FiltroRicercaScope filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            ArrayList<IDScope> idScope = new ArrayList<IDScope>();
            for (int i = 0; i < this.registro.sizeScopeList(); ++i) {
                Scope scope = this.registro.getScope(i);
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (scope.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdScope](FiltroByMinDate) Scope [" + scope.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (scope.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (scope.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdScope](FiltroByMaxDate) Scope [" + scope.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (scope.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNome() != null && !scope.getNome().equals(filtroRicerca.getNome()) || filtroRicerca.getTipologia() != null && (scope.getTipologia() == null || !scope.getTipologia().equals(filtroRicerca.getTipologia())) || filtroRicerca.getContesto() != null && !ScopeContesto.QUALSIASI.equals(filtroRicerca.getContesto()) && (scope.getContestoUtilizzo() == null || !ScopeContesto.QUALSIASI.equals(scope.getContestoUtilizzo()) && !scope.getContestoUtilizzo().equals(filtroRicerca.getContesto()))) continue;
                }
                IDScope id = new IDScope(scope.getNome());
                idScope.add(id);
            }
            if (idScope.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Scope non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Scope non trovati");
            }
            return idScope;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdScope error", e);
        }
    }

    @Override
    public Soggetto getSoggetto(IDSoggetto idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("[getSoggetto] Parametro Non Valido");
        }
        String tipoSP = idSoggetto.getTipo();
        String codiceSP = idSoggetto.getNome();
        if (tipoSP == null || codiceSP == null) {
            throw new DriverRegistroServiziException("[getSoggetto] Parametri Non Validi");
        }
        this.refreshRegistroServiziXML();
        for (int i = 0; i < this.registro.sizeSoggettoList(); ++i) {
            Soggetto ss = this.registro.getSoggetto(i);
            if (ss.getTipo() == null || ss.getNome() == null || !ss.getTipo().equals(tipoSP) || !ss.getNome().equals(codiceSP)) continue;
            return ss;
        }
        throw new DriverRegistroServiziNotFound("[getSoggetto] Soggetto non trovato");
    }

    @Override
    public Soggetto getSoggettoByCredenzialiBasic(String user, String password, CryptConfig config) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getEngineSoggettoAutenticato(CredenzialeTipo.BASIC, user, password, null, null, null, false, null, config, false);
    }

    @Override
    public Soggetto getSoggettoByCredenzialiApiKey(String user, String password, boolean appId, CryptConfig config) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getEngineSoggettoAutenticato(CredenzialeTipo.APIKEY, user, password, null, null, null, false, null, config, appId);
    }

    @Override
    public Soggetto getSoggettoByCredenzialiSsl(String subject, String issuer) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getEngineSoggettoAutenticato(CredenzialeTipo.SSL, null, null, subject, issuer, null, false, null, null, false);
    }

    @Override
    public Soggetto getSoggettoByCredenzialiSsl(CertificateInfo certificate, boolean strictVerifier) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getEngineSoggettoAutenticato(CredenzialeTipo.SSL, null, null, null, null, certificate, strictVerifier, null, null, false);
    }

    @Override
    public Soggetto getSoggettoByCredenzialiPrincipal(String principal) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getEngineSoggettoAutenticato(CredenzialeTipo.PRINCIPAL, null, null, null, null, null, false, principal, null, false);
    }

    private Soggetto getEngineSoggettoAutenticato(CredenzialeTipo tipoCredenziale, String user, String password, String aSubject, String aIssuer, CertificateInfo aCertificate, boolean aStrictVerifier, String principal, CryptConfig config, boolean appId) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (tipoCredenziale == null) {
            throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro tipoCredenziale is null");
        }
        switch (tipoCredenziale) {
            case BASIC: {
                if (user == null || "".equalsIgnoreCase(user)) {
                    throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro user is null (required for basic auth)");
                }
                if (password != null && !"".equalsIgnoreCase(password)) break;
                throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro password is null (required for basic auth)");
            }
            case APIKEY: {
                if (user == null || "".equalsIgnoreCase(user)) {
                    throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro user is null (required for apikey auth)");
                }
                if (password != null && !"".equalsIgnoreCase(password)) break;
                throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro password is null (required for apikey auth)");
            }
            case SSL: {
                if (aSubject != null && !"".equalsIgnoreCase(aSubject) || aCertificate != null) break;
                throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro subject/certificate is null (required for ssl auth)");
            }
            case PRINCIPAL: {
                if (principal != null && !"".equalsIgnoreCase(principal)) break;
                throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro principal is null (required for principal auth)");
            }
        }
        this.refreshRegistroServiziXML();
        boolean testInChiaro = false;
        ICrypt crypt = null;
        if (CredenzialeTipo.BASIC.equals(tipoCredenziale)) {
            if (config == null || config.isBackwardCompatibility()) {
                testInChiaro = true;
            }
            if (config != null) {
                try {
                    crypt = CryptFactory.getCrypt((Logger)this.log, (CryptConfig)config);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException(e.getMessage(), e);
                }
            }
        } else if (CredenzialeTipo.APIKEY.equals(tipoCredenziale)) {
            if (config != null) {
                try {
                    crypt = CryptFactory.getCrypt((Logger)this.log, (CryptConfig)config);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException(e.getMessage(), e);
                }
            } else {
                testInChiaro = true;
            }
        }
        block17: for (int i = 0; i < this.registro.sizeSoggettoList(); ++i) {
            CredenzialiSoggetto credenziali;
            Soggetto ss = this.registro.getSoggetto(i);
            CredenzialiSoggetto credenzialiSoggetto = credenziali = ss.sizeCredenzialiList() > 0 ? ss.getCredenziali(0) : null;
            if (credenziali == null || credenziali.getTipo() == null && !tipoCredenziale.equals(CredenzialeTipo.SSL) || !tipoCredenziale.equals(credenziali.getTipo())) continue;
            switch (tipoCredenziale) {
                case BASIC: 
                case APIKEY: {
                    if (!user.equals(credenziali.getUser()) || CredenzialeTipo.APIKEY.equals(tipoCredenziale) && (appId ? !credenziali.isAppId() : credenziali.isAppId())) continue block17;
                    String passwordSaved = credenziali.getPassword();
                    boolean found = false;
                    if (testInChiaro) {
                        found = password.equals(passwordSaved);
                    }
                    if (!found && crypt != null) {
                        found = crypt.check(password, passwordSaved);
                    }
                    if (!found) continue block17;
                    return ss;
                }
                case SSL: {
                    try {
                        Certificate certificato;
                        if (aSubject != null && !"".equals(aSubject)) {
                            boolean subjectValid = false;
                            if (credenziali.getSubject() != null) {
                                subjectValid = CertificateUtils.sslVerify((String)credenziali.getSubject(), (String)aSubject, (PrincipalType)PrincipalType.SUBJECT, (Logger)this.log);
                            }
                            boolean issuerValid = true;
                            if (aIssuer != null && !"".equals(aIssuer)) {
                                issuerValid = credenziali.getIssuer() == null ? false : CertificateUtils.sslVerify((String)credenziali.getIssuer(), (String)aIssuer, (PrincipalType)PrincipalType.ISSUER, (Logger)this.log);
                            } else {
                                boolean bl = issuerValid = credenziali.getIssuer() == null;
                            }
                            if (!subjectValid || !issuerValid) continue block17;
                            return ss;
                        }
                        String cnSubject = aCertificate.getSubject().getCN();
                        if (!cnSubject.equals(credenziali.getCnSubject()) || !aCertificate.equals((certificato = ArchiveLoader.load((ArchiveType)ArchiveType.CER, (byte[])credenziali.getCertificate(), (int)0, null)).getCertificate(), aStrictVerifier)) continue block17;
                        return ss;
                    }
                    catch (Exception e) {
                        throw new DriverRegistroServiziException(e.getMessage(), e);
                    }
                }
                case PRINCIPAL: {
                    if (!principal.equals(credenziali.getUser())) continue block17;
                    return ss;
                }
            }
        }
        throw new DriverRegistroServiziNotFound("[getSoggetto] Soggetto non Trovato");
    }

    @Override
    public List<IDSoggetto> getAllIdSoggetti(FiltroRicercaSoggetti filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            boolean testInChiaro = false;
            ICrypt crypt = null;
            if (filtroRicerca != null && filtroRicerca.getCredenzialiSoggetto() != null && filtroRicerca.getCredenzialiSoggetto().getPassword() != null) {
                CryptConfig config;
                CredenzialeTipo cTipo = filtroRicerca.getCredenzialiSoggetto().getTipo();
                if (CredenzialeTipo.BASIC.equals(cTipo)) {
                    config = filtroRicerca.getCryptConfig();
                    if (config == null || config.isBackwardCompatibility()) {
                        testInChiaro = true;
                    }
                    if (config != null) {
                        try {
                            crypt = CryptFactory.getCrypt((Logger)this.log, (CryptConfig)config);
                        }
                        catch (Exception e) {
                            throw new DriverRegistroServiziException(e.getMessage(), e);
                        }
                    }
                } else if (CredenzialeTipo.APIKEY.equals(cTipo)) {
                    config = filtroRicerca.getCryptConfig();
                    if (config != null) {
                        try {
                            crypt = CryptFactory.getCrypt((Logger)this.log, (CryptConfig)config);
                        }
                        catch (Exception e) {
                            throw new DriverRegistroServiziException(e.getMessage(), e);
                        }
                    } else {
                        testInChiaro = true;
                    }
                }
            }
            ArrayList<IDSoggetto> idSoggetti = new ArrayList<IDSoggetto>();
            for (int i = 0; i < this.registro.sizeSoggettoList(); ++i) {
                Soggetto ss = this.registro.getSoggetto(i);
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (ss.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdSoggetti](FiltroByMinDate) Soggetto [" + ss.getTipo() + "/" + ss.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (ss.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (ss.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdSoggetti](FiltroByMaxDate) Soggetto [" + ss.getTipo() + "/" + ss.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (ss.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getTipo() != null && !ss.getTipo().equals(filtroRicerca.getTipo()) || filtroRicerca.getNome() != null && !ss.getNome().equals(filtroRicerca.getNome()) || filtroRicerca.getNomePdd() != null && !ss.getPortaDominio().equals(filtroRicerca.getNomePdd()) || !ProtocolPropertiesUtilities.isMatch(ss, filtroRicerca.getProtocolProperties())) continue;
                    if (filtroRicerca.getIdRuolo() != null && filtroRicerca.getIdRuolo().getNome() != null) {
                        if (ss.getRuoli() == null) continue;
                        boolean contains = false;
                        for (int j = 0; j < ss.getRuoli().sizeRuoloList(); ++j) {
                            if (!filtroRicerca.getIdRuolo().getNome().equals(ss.getRuoli().getRuolo(j).getNome())) continue;
                            contains = true;
                            break;
                        }
                        if (!contains) continue;
                    }
                    if (filtroRicerca.getCredenzialiSoggetto() != null) {
                        CredenzialiSoggetto credenziali;
                        CredenzialiSoggetto credenzialiSoggetto = credenziali = ss.sizeCredenzialiList() > 0 ? ss.getCredenziali(0) : null;
                        if (credenziali == null) continue;
                        if (filtroRicerca.getCredenzialiSoggetto().getTipo() != null) {
                            if (credenziali.getTipo() == null) {
                                if (!filtroRicerca.getCredenzialiSoggetto().getTipo().equals(CredenzialeTipo.SSL)) {
                                    continue;
                                }
                            } else if (!filtroRicerca.getCredenzialiSoggetto().getTipo().equals(credenziali.getTipo()) || CredenzialeTipo.APIKEY.equals(filtroRicerca.getCredenzialiSoggetto().getTipo()) && (!filtroRicerca.getCredenzialiSoggetto().isAppId() ? credenziali.isAppId() : !credenziali.isAppId())) continue;
                        }
                        if (filtroRicerca.getCredenzialiSoggetto().getUser() != null && !filtroRicerca.getCredenzialiSoggetto().getUser().equals(credenziali.getUser())) continue;
                        if (filtroRicerca.getCredenzialiSoggetto().getPassword() != null) {
                            String passwordSaved = credenziali.getPassword();
                            boolean found = false;
                            if (testInChiaro) {
                                found = filtroRicerca.getCredenzialiSoggetto().getPassword().equals(passwordSaved);
                            }
                            if (!found && crypt != null) {
                                found = crypt.check(filtroRicerca.getCredenzialiSoggetto().getPassword(), passwordSaved);
                            }
                            if (!found) continue;
                        }
                        if (filtroRicerca.getCredenzialiSoggetto().getSubject() != null) {
                            try {
                                if (credenziali.getSubject() == null) continue;
                                boolean subjectValid = CertificateUtils.sslVerify((String)credenziali.getSubject(), (String)filtroRicerca.getCredenzialiSoggetto().getSubject(), (PrincipalType)PrincipalType.SUBJECT, (Logger)this.log);
                                boolean issuerValid = true;
                                if (filtroRicerca.getCredenzialiSoggetto().getIssuer() != null) {
                                    issuerValid = credenziali.getIssuer() == null ? false : CertificateUtils.sslVerify((String)credenziali.getIssuer(), (String)filtroRicerca.getCredenzialiSoggetto().getIssuer(), (PrincipalType)PrincipalType.ISSUER, (Logger)this.log);
                                } else {
                                    boolean bl = issuerValid = credenziali.getIssuer() == null;
                                }
                                if (!subjectValid || !issuerValid) {
                                    continue;
                                }
                            }
                            catch (Exception e) {
                                throw new DriverRegistroServiziException(e.getMessage(), e);
                            }
                        }
                        if (filtroRicerca.getCredenzialiSoggetto().getCnSubject() != null && filtroRicerca.getCredenzialiSoggetto().getCertificate() != null) {
                            if (!filtroRicerca.getCredenzialiSoggetto().getCnSubject().equals(credenziali.getCnSubject())) continue;
                            Certificate certificato = ArchiveLoader.load((ArchiveType)ArchiveType.CER, (byte[])credenziali.getCertificate(), (int)0, null);
                            Certificate certificatoFiltro = ArchiveLoader.load((ArchiveType)ArchiveType.CER, (byte[])filtroRicerca.getCredenzialiSoggetto().getCertificate(), (int)0, null);
                            if (!certificatoFiltro.getCertificate().equals(certificato.getCertificate(), filtroRicerca.getCredenzialiSoggetto().isCertificateStrictVerification())) continue;
                        }
                    }
                }
                IDSoggetto idS = new IDSoggetto(ss.getTipo(), ss.getNome());
                idSoggetti.add(idS);
            }
            if (idSoggetti.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Soggetti non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Soggetti non trovati");
            }
            return idSoggetti;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdSoggetti error", e);
        }
    }

    @Override
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idService) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Soggetto soggetto = this.getSoggetto(idService.getSoggettoErogatore());
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica(IDServizio)] Parametro Non Valido");
        }
        String servizio = idService.getNome();
        String tipoServizio = idService.getTipo();
        Integer versioneServizio = idService.getVersione();
        if (servizio == null || tipoServizio == null || versioneServizio == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica(IDServizio)] Parametri Non Validi");
        }
        for (int i = 0; i < soggetto.sizeAccordoServizioParteSpecificaList(); ++i) {
            AccordoServizioParteSpecifica asps = soggetto.getAccordoServizioParteSpecifica(i);
            if (!asps.getTipo().equals(tipoServizio) || !asps.getNome().equals(servizio) || asps.getVersione().intValue() != versioneServizio.intValue()) continue;
            asps.setTipoSoggettoErogatore(soggetto.getTipo());
            asps.setNomeSoggettoErogatore(soggetto.getNome());
            return asps;
        }
        throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica(IDServizio)] Servizio non trovato");
    }

    @Override
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica_ServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordoServizioParteComune) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Soggetto soggetto = this.getSoggetto(idSoggetto);
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica_ServizioCorrelato] Parametro Non Valido");
        }
        String uriAccordo = this.idAccordoFactory.getUriFromIDAccordo(idAccordoServizioParteComune);
        for (int i = 0; i < soggetto.sizeAccordoServizioParteSpecificaList(); ++i) {
            AccordoServizioParteSpecifica asps = soggetto.getAccordoServizioParteSpecifica(i);
            if (asps.getAccordoServizioParteComune() == null || !asps.getAccordoServizioParteComune().equals(uriAccordo) || !TipologiaServizio.CORRELATO.equals(asps.getTipologiaServizio())) continue;
            asps.setTipoSoggettoErogatore(soggetto.getTipo());
            asps.setNomeSoggettoErogatore(soggetto.getNome());
            return asps;
        }
        throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica_ServizioCorrelato] Servizio non trovato");
    }

    @Override
    public List<IDServizio> getAllIdServizi(FiltroRicercaServizi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDServizio> list = new ArrayList<IDServizio>();
        this._fillAllIdServiziEngine("getAllIdServizi", filtroRicerca, list);
        return list;
    }

    @Override
    public List<IDFruizione> getAllIdFruizioniServizio(FiltroRicercaFruizioniServizio filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDFruizione> list = new ArrayList<IDFruizione>();
        this._fillAllIdServiziEngine("getAllIdFruizioniServizio", filtroRicerca, list);
        return list;
    }

    public <T> void _fillAllIdServiziEngine(String nomeMetodo, FiltroRicercaServizi filtroRicerca, List<T> listReturn) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            FiltroRicercaFruizioniServizio filtroFruizioni = null;
            if (filtroRicerca instanceof FiltroRicercaFruizioniServizio) {
                filtroFruizioni = (FiltroRicercaFruizioniServizio)filtroRicerca;
            }
            for (int i = 0; i < this.registro.sizeSoggettoList(); ++i) {
                Soggetto ss = this.registro.getSoggetto(i);
                if (filtroRicerca != null && (filtroRicerca.getTipoSoggettoErogatore() != null && !ss.getTipo().equals(filtroRicerca.getTipoSoggettoErogatore()) || filtroRicerca.getNomeSoggettoErogatore() != null && !ss.getNome().equals(filtroRicerca.getNomeSoggettoErogatore()))) continue;
                for (int j = 0; j < ss.sizeAccordoServizioParteSpecificaList(); ++j) {
                    AccordoServizioParteSpecifica asps = ss.getAccordoServizioParteSpecifica(j);
                    if (filtroRicerca != null) {
                        if (filtroRicerca.getMinDate() != null) {
                            if (asps.getOraRegistrazione() == null) {
                                this.log.debug("[" + nomeMetodo + "](FiltroByMinDate) Servizio[" + this.idServizioFactory.getUriFromAccordo(asps) + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                                continue;
                            }
                            if (asps.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                        }
                        if (filtroRicerca.getMaxDate() != null) {
                            if (asps.getOraRegistrazione() == null) {
                                this.log.debug("[" + nomeMetodo + "](FiltroByMaxDate) Servizio[" + this.idServizioFactory.getUriFromAccordo(asps) + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                                continue;
                            }
                            if (asps.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                        }
                        if (filtroRicerca.getTipo() != null && !asps.getTipo().equals(filtroRicerca.getTipo()) || filtroRicerca.getNome() != null && !asps.getNome().equals(filtroRicerca.getNome()) || filtroRicerca.getVersione() != null && asps.getVersione().intValue() != filtroRicerca.getVersione().intValue() || filtroRicerca.getPortType() != null && !asps.getPortType().equals(filtroRicerca.getPortType())) continue;
                        if (filtroRicerca.getIdAccordoServizioParteComune() != null) {
                            String uriAccordo = this.idAccordoFactory.getUriFromIDAccordo(filtroRicerca.getIdAccordoServizioParteComune());
                            if (!asps.getAccordoServizioParteComune().equals(uriAccordo)) continue;
                        }
                        if (!ProtocolPropertiesUtilities.isMatch(asps, filtroRicerca.getProtocolProperties())) continue;
                        if (filtroRicerca.getTipoSoggettoFruitore() != null || filtroRicerca.getNomeSoggettoFruitore() != null) {
                            if (asps.sizeFruitoreList() <= 0) continue;
                            boolean found = false;
                            for (int k = 0; k < asps.sizeFruitoreList(); ++k) {
                                Fruitore fruitore = asps.getFruitore(k);
                                if (filtroRicerca.getTipoSoggettoFruitore() != null && !fruitore.getTipo().equals(filtroRicerca.getTipoSoggettoFruitore()) || filtroRicerca.getNomeSoggettoFruitore() != null && !fruitore.getNome().equals(filtroRicerca.getNomeSoggettoFruitore())) continue;
                                found = true;
                                break;
                            }
                            if (!found) continue;
                        }
                    }
                    IDServizio idServ = this.idServizioFactory.getIDServizioFromAccordo(asps);
                    if (filtroFruizioni != null) {
                        for (Fruitore fruitore : asps.getFruitoreList()) {
                            if (filtroFruizioni.getTipoSoggettoFruitore() != null && !fruitore.getTipo().equals(filtroFruizioni.getTipoSoggettoFruitore()) || filtroFruizioni.getNomeSoggettoFruitore() != null && !fruitore.getNome().equals(filtroFruizioni.getNomeSoggettoFruitore()) || !ProtocolPropertiesUtilities.isMatch(fruitore, filtroFruizioni.getProtocolPropertiesFruizione())) continue;
                            IDFruizione idFruizione = new IDFruizione();
                            idFruizione.setIdServizio(idServ);
                            idFruizione.setIdFruitore(new IDSoggetto(fruitore.getTipo(), fruitore.getNome()));
                            listReturn.add(idFruizione);
                        }
                        if (filtroRicerca.getTipoSoggettoFruitore() == null && filtroRicerca.getNomeSoggettoFruitore() == null || asps.sizeFruitoreList() <= 0) continue;
                        boolean found = false;
                        for (int k = 0; k < asps.sizeFruitoreList(); ++k) {
                            Fruitore fruitore = asps.getFruitore(k);
                            if (filtroRicerca.getTipoSoggettoFruitore() != null && !fruitore.getTipo().equals(filtroRicerca.getTipoSoggettoFruitore()) || filtroRicerca.getNomeSoggettoFruitore() != null && !fruitore.getNome().equals(filtroRicerca.getNomeSoggettoFruitore())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                    }
                    listReturn.add(idServ);
                }
            }
            if (listReturn.size() <= 0) {
                String msgFiltro = "Elementi non trovati che rispettano il filtro di ricerca selezionato: ";
                if (filtroFruizioni != null) {
                    throw new DriverRegistroServiziNotFound(msgFiltro + filtroFruizioni.toString());
                }
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound(msgFiltro + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Elementi non trovati");
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(nomeMetodo + " error", e);
        }
    }

    @Override
    public Documento getAllegato(IDServizio idASPS, String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoServizioParteSpecifica asps = this.getAccordoServizioParteSpecifica(idASPS);
        if (asps.sizeAllegatoList() > 0) {
            for (Documento doc : asps.getAllegatoList()) {
                File f = new File(doc.getFile());
                if (!nome.equals(doc.getFile()) && !nome.equals(f.getName())) continue;
                return doc;
            }
        }
        throw new DriverRegistroServiziNotFound("Documento '" + nome + "' non trovato");
    }

    @Override
    public Documento getSpecificaSemiformale(IDServizio idASPS, TipiDocumentoSemiformale tipo, String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoServizioParteSpecifica asps = this.getAccordoServizioParteSpecifica(idASPS);
        if (asps.sizeSpecificaSemiformaleList() > 0) {
            for (Documento doc : asps.getSpecificaSemiformaleList()) {
                File f = new File(doc.getFile());
                if (!nome.equals(doc.getFile()) && !nome.equals(f.getName()) || tipo == null || !tipo.getNome().equals(doc.getTipo())) continue;
                return doc;
            }
        }
        throw new DriverRegistroServiziNotFound("Documento '" + nome + "' non trovato");
    }

    @Override
    public Documento getSpecificaSicurezza(IDServizio idASPS, TipiDocumentoSicurezza tipo, String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoServizioParteSpecifica asps = this.getAccordoServizioParteSpecifica(idASPS);
        if (asps.sizeSpecificaSicurezzaList() > 0) {
            for (Documento doc : asps.getSpecificaSicurezzaList()) {
                File f = new File(doc.getFile());
                if (!nome.equals(doc.getFile()) && !nome.equals(f.getName()) || tipo == null || !tipo.getNome().equals(doc.getTipo())) continue;
                return doc;
            }
        }
        throw new DriverRegistroServiziNotFound("Documento '" + nome + "' non trovato");
    }

    @Override
    public Documento getSpecificaLivelloServizio(IDServizio idASPS, TipiDocumentoLivelloServizio tipo, String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoServizioParteSpecifica asps = this.getAccordoServizioParteSpecifica(idASPS);
        if (asps.sizeSpecificaLivelloServizioList() > 0) {
            for (Documento doc : asps.getSpecificaLivelloServizioList()) {
                File f = new File(doc.getFile());
                if (!nome.equals(doc.getFile()) && !nome.equals(f.getName()) || tipo == null || !tipo.getNome().equals(doc.getTipo())) continue;
                return doc;
            }
        }
        throw new DriverRegistroServiziNotFound("Documento '" + nome + "' non trovato");
    }

    @Override
    public void isAlive() throws CoreException {
        if (!this.create) {
            throw new CoreException("Driver non inizializzato");
        }
        try {
            this.forzaRefreshRegistroServiziXML();
        }
        catch (Exception e) {
            throw new CoreException("Connessione al registro non disponibile: " + e.getMessage(), e);
        }
    }

    @Override
    public RegistroServizi getImmagineCompletaRegistroServizi() throws DriverRegistroServiziException {
        this.refreshRegistroServiziXML();
        return this.registro;
    }
}

