/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.openspcoop2.core.byok.BYOKUtilities;
import org.openspcoop2.core.byok.BYOKWrappedValue;
import org.openspcoop2.core.byok.IDriverBYOK;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.CredenzialiSoggetto;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.Proprieta;
import org.openspcoop2.core.registry.RuoloSoggetto;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.CredenzialeTipo;
import org.openspcoop2.core.registry.constants.StatoFunzionalita;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_LIB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_connettoriLIB;
import org.openspcoop2.utils.certificate.CertificateUtils;
import org.openspcoop2.utils.certificate.PrincipalType;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.jdbc.IJDBCAdapter;
import org.openspcoop2.utils.jdbc.JDBCAdapterFactory;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverRegistroServiziDB_soggettiLIB {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void CRUDPortaDominio(int type, PortaDominio pdd, Connection con) throws DriverRegistroServiziException {
        if (pdd == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDPdd] Parametro non valido.");
        }
        String nome = pdd.getNome();
        String descrizione = pdd.getDescrizione();
        String implementazione = pdd.getImplementazione();
        String subject = pdd.getSubject();
        StatoFunzionalita client_auth = pdd.getClientAuth();
        String superuser = pdd.getSuperUser();
        PreparedStatement updateStmt = null;
        String updateQuery = "";
        PreparedStatement selectStmt = null;
        String selectQuery = "";
        ResultSet selectRS = null;
        int n = 0;
        try {
            switch (type) {
                case 1: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addInsertTable("pdd");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("descrizione", "?");
                    sqlQueryObject.addInsertField("implementazione", "?");
                    sqlQueryObject.addInsertField("subject", "?");
                    sqlQueryObject.addInsertField("client_auth", "?");
                    sqlQueryObject.addInsertField("superuser", "?");
                    if (pdd.getOraRegistrazione() != null) {
                        sqlQueryObject.addInsertField("ora_registrazione", "?");
                    }
                    updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, nome);
                    updateStmt.setString(2, descrizione);
                    updateStmt.setString(3, implementazione);
                    updateStmt.setString(4, subject != null ? CertificateUtils.formatPrincipal((String)subject, (PrincipalType)PrincipalType.SUBJECT) : null);
                    updateStmt.setString(5, DriverRegistroServiziDB_LIB.getValue(client_auth));
                    updateStmt.setString(6, superuser);
                    if (pdd.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(7, new Timestamp(pdd.getOraRegistrazione().getTime()));
                    }
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDPdd type = " + type + " row affected =" + n);
                    DriverRegistroServiziDB_LIB.logDebug("CRUDPdd CREATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, nome, descrizione, implementazione, subject, client_auth));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addFromTable("pdd");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("nome = ?");
                    selectQuery = sqlQueryObject.createSQLQuery();
                    selectStmt = con.prepareStatement(selectQuery);
                    selectStmt.setString(1, nome);
                    selectRS = selectStmt.executeQuery();
                    if (selectRS.next()) {
                        pdd.setId(selectRS.getLong("id"));
                    }
                    selectRS.close();
                    selectStmt.close();
                    return;
                }
                case 2: {
                    long idPdd;
                    String nomePdd = pdd.getOldNomeForUpdate();
                    if (nomePdd == null || "".equals(nomePdd)) {
                        nomePdd = pdd.getNome();
                    }
                    if ((idPdd = DBUtils.getIdPortaDominio(nomePdd, con, DriverRegistroServiziDB_LIB.tipoDB)) <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDPortaDominio(UPDATE)] Id Porta di Dominio non valido.");
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addUpdateTable("pdd");
                    sqlQueryObject.addUpdateField("nome", "?");
                    sqlQueryObject.addUpdateField("descrizione", "?");
                    sqlQueryObject.addUpdateField("implementazione", "?");
                    sqlQueryObject.addUpdateField("subject", "?");
                    sqlQueryObject.addUpdateField("client_auth", "?");
                    sqlQueryObject.addUpdateField("superuser", "?");
                    if (pdd.getOraRegistrazione() != null) {
                        sqlQueryObject.addUpdateField("ora_registrazione", "?");
                    }
                    sqlQueryObject.addWhereCondition("id=?");
                    updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, nome);
                    updateStmt.setString(2, descrizione);
                    updateStmt.setString(3, implementazione);
                    updateStmt.setString(4, subject != null ? CertificateUtils.formatPrincipal((String)subject, (PrincipalType)PrincipalType.SUBJECT) : null);
                    updateStmt.setString(5, DriverRegistroServiziDB_LIB.getValue(client_auth));
                    updateStmt.setString(6, superuser);
                    int paramIndex = 6;
                    if (pdd.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(++paramIndex, new Timestamp(pdd.getOraRegistrazione().getTime()));
                    }
                    updateStmt.setLong(++paramIndex, idPdd);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDPdd type = " + type + " row affected =" + n);
                    DriverRegistroServiziDB_LIB.logDebug("CRUDPdd UPDATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, descrizione, implementazione, subject, client_auth, idPdd));
                    return;
                }
                case 3: {
                    long idPdd = DBUtils.getIdPortaDominio(nome, con, DriverRegistroServiziDB_LIB.tipoDB);
                    if (idPdd <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDPortaDominio(DELETE)] Id Porta di Dominio non valido.");
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("pdd");
                    sqlQueryObject.addWhereCondition("id=?");
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idPdd);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDPdd type = " + type + " row affected =" + n);
                    DriverRegistroServiziDB_LIB.logDebug("CRUDPdd DELETE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, idPdd));
                    return;
                }
            }
            return;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverControlStationDB_LIB::CRUDPdd] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverControlStationDB_LIB::CRUDPdd] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            JDBCUtilities.closeResources(updateStmt);
            JDBCUtilities.closeResources(selectRS, selectStmt);
        }
    }

    public static long CRUDSoggetto(int type, Soggetto soggetto, Connection con, String tipoDatabase, IDriverBYOK driverBYOK) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDSoggetto] Parametro non valido.");
        }
        String nome = soggetto.getNome();
        String tipo = soggetto.getTipo();
        if (nome == null || nome.equals("")) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDSoggetto] Parametro Nome non valido.");
        }
        if (tipo == null || tipo.equals("")) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDSoggetto] Parametro Tipo non valido.");
        }
        String descizione = soggetto.getDescrizione();
        String identificativoPorta = soggetto.getIdentificativoPorta();
        String server = soggetto.getPortaDominio();
        Connettore connettore = soggetto.getConnettore();
        String codiceIPA = soggetto.getCodiceIpa();
        String superUser = soggetto.getSuperUser();
        if (connettore == null && type != 1 && type != 3) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDSoggetto] Il connettore del soggetto e' null.");
        }
        PreparedStatement updateStmt = null;
        String updateQuery = "";
        PreparedStatement selectStmt = null;
        String selectQuery = "";
        ResultSet selectRS = null;
        long idSoggetto = 0L;
        int n = 0;
        try {
            switch (type) {
                case 1: {
                    int i;
                    String utenteRichiedente = null;
                    utenteRichiedente = soggetto.getProprietaOggetto() != null && soggetto.getProprietaOggetto().getUtenteRichiedente() != null ? soggetto.getProprietaOggetto().getUtenteRichiedente() : superUser;
                    Timestamp dataCreazione = null;
                    dataCreazione = soggetto.getProprietaOggetto() != null && soggetto.getProprietaOggetto().getDataCreazione() != null ? new Timestamp(soggetto.getProprietaOggetto().getDataCreazione().getTime()) : (soggetto.getOraRegistrazione() != null ? new Timestamp(soggetto.getOraRegistrazione().getTime()) : DateManager.getTimestamp());
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addInsertTable("soggetti");
                    sqlQueryObject.addInsertField("nome_soggetto", "?");
                    sqlQueryObject.addInsertField("descrizione", "?");
                    sqlQueryObject.addInsertField("identificativo_porta", "?");
                    sqlQueryObject.addInsertField("tipo_soggetto", "?");
                    sqlQueryObject.addInsertField("id_connettore", "?");
                    sqlQueryObject.addInsertField("server", "?");
                    sqlQueryObject.addInsertField("superuser", "?");
                    sqlQueryObject.addInsertField("privato", "?");
                    sqlQueryObject.addInsertField("profilo", "?");
                    sqlQueryObject.addInsertField("codice_ipa", "?");
                    sqlQueryObject.addInsertField("tipoauth", "?");
                    sqlQueryObject.addInsertField("utente", "?");
                    sqlQueryObject.addInsertField("password", "?");
                    sqlQueryObject.addInsertField("subject", "?");
                    sqlQueryObject.addInsertField("cn_subject", "?");
                    sqlQueryObject.addInsertField("issuer", "?");
                    sqlQueryObject.addInsertField("cn_issuer", "?");
                    sqlQueryObject.addInsertField("certificate", "?");
                    sqlQueryObject.addInsertField("cert_strict_verification", "?");
                    if (soggetto.getOraRegistrazione() != null) {
                        sqlQueryObject.addInsertField("ora_registrazione", "?");
                    }
                    if (utenteRichiedente != null) {
                        sqlQueryObject.addInsertField("utente_richiedente", "?");
                    }
                    if (dataCreazione != null) {
                        sqlQueryObject.addInsertField("data_creazione", "?");
                    }
                    updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    if (connettore == null) {
                        connettore = new Connettore();
                        connettore.setNome("CNT_" + tipo + "_" + nome);
                    }
                    if (connettore.getNome() == null || connettore.getNome().equals("")) {
                        connettore.setNome("CNT_" + tipo + "_" + nome);
                    }
                    long idConnettore = DriverRegistroServiziDB_connettoriLIB.CRUDConnettore(1, connettore, con, driverBYOK);
                    int index = 1;
                    updateStmt.setString(index++, nome);
                    updateStmt.setString(index++, descizione);
                    updateStmt.setString(index++, identificativoPorta);
                    updateStmt.setString(index++, tipo);
                    updateStmt.setLong(index++, idConnettore);
                    updateStmt.setString(index++, server);
                    updateStmt.setString(index++, superUser);
                    if (soggetto.getPrivato() != null && soggetto.getPrivato().booleanValue()) {
                        updateStmt.setInt(index++, 1);
                    } else {
                        updateStmt.setInt(index++, 0);
                    }
                    updateStmt.setString(index++, soggetto.getVersioneProtocollo());
                    updateStmt.setString(index++, codiceIPA);
                    CredenzialiSoggetto credenziali = soggetto.sizeCredenzialiList() > 0 ? soggetto.getCredenziali(0) : null;
                    updateStmt.setString(index++, credenziali != null ? DriverRegistroServiziDB_LIB.getValue(credenziali.getTipo()) : null);
                    updateStmt.setString(index++, credenziali != null ? credenziali.getUser() : null);
                    updateStmt.setString(index++, credenziali != null ? credenziali.getPassword() : null);
                    String subject = null;
                    if (credenziali != null && credenziali.getSubject() != null && !"".equals(credenziali.getSubject())) {
                        subject = credenziali.getSubject();
                    }
                    updateStmt.setString(index++, subject != null ? CertificateUtils.formatPrincipal(subject, (PrincipalType)PrincipalType.SUBJECT) : null);
                    String subjectCN = null;
                    if (credenziali != null && credenziali.getCnSubject() != null && !"".equals(credenziali.getCnSubject())) {
                        subjectCN = credenziali.getCnSubject();
                    }
                    updateStmt.setString(index++, subjectCN);
                    String issuer = null;
                    if (credenziali != null && CredenzialeTipo.APIKEY.equals(credenziali.getTipo())) {
                        updateStmt.setString(index++, CostantiDB.getIssuerApiKey(credenziali.isAppId()));
                    } else {
                        if (credenziali != null && credenziali.getIssuer() != null && !"".equals(credenziali.getIssuer())) {
                            issuer = credenziali.getIssuer();
                        }
                        updateStmt.setString(index++, issuer != null ? CertificateUtils.formatPrincipal(issuer, (PrincipalType)PrincipalType.ISSUER) : null);
                    }
                    String issuerCN = null;
                    if (credenziali != null && credenziali.getCnIssuer() != null && !"".equals(credenziali.getCnIssuer())) {
                        issuerCN = credenziali.getCnIssuer();
                    }
                    updateStmt.setString(index++, issuerCN);
                    byte[] certificate = null;
                    if (credenziali != null && credenziali.getCertificate() != null) {
                        certificate = credenziali.getCertificate();
                    }
                    IJDBCAdapter jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)DriverRegistroServiziDB_LIB.tipoDB);
                    jdbcAdapter.setBinaryData(updateStmt, index++, certificate);
                    if (credenziali != null && credenziali.isCertificateStrictVerification()) {
                        updateStmt.setInt(index++, 1);
                    } else {
                        updateStmt.setInt(index++, 0);
                    }
                    if (soggetto.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(index++, new Timestamp(soggetto.getOraRegistrazione().getTime()));
                    }
                    if (utenteRichiedente != null) {
                        updateStmt.setString(index++, utenteRichiedente);
                    }
                    if (dataCreazione != null) {
                        updateStmt.setTimestamp(index++, dataCreazione);
                    }
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDSoggetto type = " + type + " row affected =" + n);
                    DriverRegistroServiziDB_LIB.logDebug("CRUDSoggetto CREATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, nome, descizione, identificativoPorta, tipo, idConnettore, server));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addFromTable("soggetti");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
                    sqlQueryObject.addWhereCondition("nome_soggetto = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    selectQuery = sqlQueryObject.createSQLQuery();
                    selectStmt = con.prepareStatement(selectQuery);
                    selectStmt.setString(1, tipo);
                    selectStmt.setString(2, nome);
                    selectRS = selectStmt.executeQuery();
                    if (selectRS.next()) {
                        idSoggetto = selectRS.getLong("id");
                    }
                    soggetto.setId(idSoggetto);
                    selectRS.close();
                    selectStmt.close();
                    DriverRegistroServiziDB_LIB.CRUDProtocolProperty(1, soggetto.getProtocolPropertyList(), idSoggetto, ProprietariProtocolProperty.SOGGETTO, con, tipoDatabase, driverBYOK);
                    n = 0;
                    if (soggetto.getRuoli() != null && soggetto.getRuoli().sizeRuoloList() > 0) {
                        for (i = 0; i < soggetto.getRuoli().sizeRuoloList(); ++i) {
                            RuoloSoggetto ruoloSoggetto = soggetto.getRuoli().getRuolo(i);
                            IDRuolo idRuoloObject = new IDRuolo(ruoloSoggetto.getNome());
                            long idRuolo = DBUtils.getIdRuolo(idRuoloObject, con, DriverRegistroServiziDB_LIB.tipoDB);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                            sqlQueryObject.addInsertTable("soggetti_ruoli");
                            sqlQueryObject.addInsertField("id_soggetto", "?");
                            sqlQueryObject.addInsertField("id_ruolo", "?");
                            updateQuery = sqlQueryObject.createSQLInsert();
                            updateStmt = con.prepareStatement(updateQuery);
                            updateStmt.setLong(1, idSoggetto);
                            updateStmt.setLong(2, idRuolo);
                            int r = updateStmt.executeUpdate();
                            ++n;
                            updateStmt.close();
                            DriverRegistroServiziDB_LIB.logDebug("CRUDSoggetto type = " + type + " row affected =" + r + " create role [" + ruoloSoggetto.getNome() + "]");
                        }
                    }
                    DriverRegistroServiziDB_LIB.logDebug("Aggiunti " + n + " ruoli al soggetto " + idSoggetto);
                    n = 0;
                    if (soggetto.sizeCredenzialiList() > 1) {
                        for (i = 1; i < soggetto.sizeCredenzialiList(); ++i) {
                            CredenzialiSoggetto credenzialiSoggetto = soggetto.getCredenziali(i);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                            sqlQueryObject.addInsertTable("soggetti_credenziali");
                            sqlQueryObject.addInsertField("id_soggetto", "?");
                            sqlQueryObject.addInsertField("subject", "?");
                            sqlQueryObject.addInsertField("cn_subject", "?");
                            sqlQueryObject.addInsertField("issuer", "?");
                            sqlQueryObject.addInsertField("cn_issuer", "?");
                            sqlQueryObject.addInsertField("certificate", "?");
                            sqlQueryObject.addInsertField("cert_strict_verification", "?");
                            updateQuery = sqlQueryObject.createSQLInsert();
                            updateStmt = con.prepareStatement(updateQuery);
                            index = 1;
                            updateStmt.setLong(index++, idSoggetto);
                            String subjectCredenziali = null;
                            if (credenzialiSoggetto != null && credenzialiSoggetto.getSubject() != null && !"".equals(credenzialiSoggetto.getSubject())) {
                                subjectCredenziali = credenzialiSoggetto.getSubject();
                            }
                            updateStmt.setString(index++, subjectCredenziali != null ? CertificateUtils.formatPrincipal(subjectCredenziali, (PrincipalType)PrincipalType.SUBJECT) : null);
                            String subjectCredenzialiCN = null;
                            if (credenzialiSoggetto != null && credenzialiSoggetto.getCnSubject() != null && !"".equals(credenzialiSoggetto.getCnSubject())) {
                                subjectCredenzialiCN = credenzialiSoggetto.getCnSubject();
                            }
                            updateStmt.setString(index++, subjectCredenzialiCN);
                            String issuerCredenziali = null;
                            if (credenzialiSoggetto != null && CredenzialeTipo.APIKEY.equals(credenzialiSoggetto.getTipo())) {
                                updateStmt.setString(index++, CostantiDB.getIssuerApiKey(credenzialiSoggetto.isAppId()));
                            } else {
                                if (credenzialiSoggetto != null && credenzialiSoggetto.getIssuer() != null && !"".equals(credenzialiSoggetto.getIssuer())) {
                                    issuerCredenziali = credenzialiSoggetto.getIssuer();
                                }
                                updateStmt.setString(index++, issuerCredenziali != null ? CertificateUtils.formatPrincipal(issuerCredenziali, (PrincipalType)PrincipalType.ISSUER) : null);
                            }
                            String issuerCredenzialiCN = null;
                            if (credenzialiSoggetto != null && credenzialiSoggetto.getCnIssuer() != null && !"".equals(credenzialiSoggetto.getCnIssuer())) {
                                issuerCredenzialiCN = credenzialiSoggetto.getCnIssuer();
                            }
                            updateStmt.setString(index++, issuerCredenzialiCN);
                            byte[] certificateCredenziali = null;
                            if (credenzialiSoggetto != null && credenzialiSoggetto.getCertificate() != null) {
                                certificateCredenziali = credenzialiSoggetto.getCertificate();
                            }
                            jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)DriverRegistroServiziDB_LIB.tipoDB);
                            jdbcAdapter.setBinaryData(updateStmt, index++, certificateCredenziali);
                            if (credenzialiSoggetto != null && credenzialiSoggetto.isCertificateStrictVerification()) {
                                updateStmt.setInt(index++, 1);
                            } else {
                                updateStmt.setInt(index++, 0);
                            }
                            int r = updateStmt.executeUpdate();
                            ++n;
                            updateStmt.close();
                            DriverRegistroServiziDB_LIB.logDebug("CRUDSoggetto type = " + type + " row affected =" + r + " create credenziale");
                        }
                    }
                    DriverRegistroServiziDB_LIB.logDebug("Aggiunte " + n + " credenziali al soggetto " + idSoggetto);
                    n = 0;
                    if (soggetto.sizeProprietaList() > 0) {
                        for (i = 0; i < soggetto.sizeProprietaList(); ++i) {
                            BYOKWrappedValue byokValue;
                            Proprieta proprieta = soggetto.getProprieta(i);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                            sqlQueryObject.addInsertTable("soggetti_properties");
                            sqlQueryObject.addInsertField("id_soggetto", "?");
                            sqlQueryObject.addInsertField("nome", "?");
                            sqlQueryObject.addInsertField("valore", "?");
                            sqlQueryObject.addInsertField("enc_value", "?");
                            updateQuery = sqlQueryObject.createSQLInsert();
                            updateStmt = con.prepareStatement(updateQuery);
                            int indexP = 1;
                            updateStmt.setLong(indexP++, idSoggetto);
                            updateStmt.setString(indexP++, proprieta.getNome());
                            String plainValue = proprieta.getValore();
                            String encValue = null;
                            if (driverBYOK != null && BYOKUtilities.isWrappedValue(plainValue) && (byokValue = driverBYOK.wrap(plainValue)) != null) {
                                encValue = byokValue.getWrappedValue();
                                plainValue = byokValue.getWrappedPlainValue();
                            }
                            updateStmt.setString(indexP++, plainValue);
                            updateStmt.setString(indexP++, encValue);
                            int r = updateStmt.executeUpdate();
                            ++n;
                            updateStmt.close();
                            DriverRegistroServiziDB_LIB.logDebug("CRUDSoggetto type = " + type + " row affected =" + r + " create property [" + proprieta.getNome() + "]");
                        }
                    }
                    DriverRegistroServiziDB_LIB.logDebug("Aggiunti " + n + " propriet\u00e0 al soggetto " + idSoggetto);
                    break;
                }
                case 2: {
                    int i;
                    String oldNomeSoggetto = null;
                    String oldTipoSoggetto = null;
                    if (soggetto.getOldIDSoggettoForUpdate() != null) {
                        oldNomeSoggetto = soggetto.getOldIDSoggettoForUpdate().getNome();
                        oldTipoSoggetto = soggetto.getOldIDSoggettoForUpdate().getTipo();
                    }
                    if (oldNomeSoggetto == null || oldNomeSoggetto.equals("")) {
                        oldNomeSoggetto = nome;
                    }
                    if (oldTipoSoggetto == null || oldTipoSoggetto.equals("")) {
                        oldTipoSoggetto = tipo;
                    }
                    String utenteUltimaModifica = null;
                    utenteUltimaModifica = soggetto.getProprietaOggetto() != null && soggetto.getProprietaOggetto().getUtenteUltimaModifica() != null ? soggetto.getProprietaOggetto().getUtenteUltimaModifica() : superUser;
                    Timestamp dataUltimaModifica = null;
                    dataUltimaModifica = soggetto.getProprietaOggetto() != null && soggetto.getProprietaOggetto().getDataUltimaModifica() != null ? new Timestamp(soggetto.getProprietaOggetto().getDataUltimaModifica().getTime()) : DateManager.getTimestamp();
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addUpdateTable("soggetti");
                    sqlQueryObject.addUpdateField("nome_soggetto", "?");
                    sqlQueryObject.addUpdateField("descrizione", "?");
                    sqlQueryObject.addUpdateField("identificativo_porta", "?");
                    sqlQueryObject.addUpdateField("tipo_soggetto", "?");
                    sqlQueryObject.addUpdateField("server", "?");
                    sqlQueryObject.addUpdateField("superuser", "?");
                    sqlQueryObject.addUpdateField("privato", "?");
                    sqlQueryObject.addUpdateField("profilo", "?");
                    sqlQueryObject.addUpdateField("codice_ipa", "?");
                    sqlQueryObject.addUpdateField("tipoauth", "?");
                    sqlQueryObject.addUpdateField("utente", "?");
                    sqlQueryObject.addUpdateField("password", "?");
                    sqlQueryObject.addUpdateField("subject", "?");
                    sqlQueryObject.addUpdateField("cn_subject", "?");
                    sqlQueryObject.addUpdateField("issuer", "?");
                    sqlQueryObject.addUpdateField("cn_issuer", "?");
                    sqlQueryObject.addUpdateField("certificate", "?");
                    sqlQueryObject.addUpdateField("cert_strict_verification", "?");
                    if (soggetto.getOraRegistrazione() != null) {
                        sqlQueryObject.addUpdateField("ora_registrazione", "?");
                    }
                    if (utenteUltimaModifica != null) {
                        sqlQueryObject.addUpdateField("utente_ultima_modifica", "?");
                    }
                    if (dataUltimaModifica != null) {
                        sqlQueryObject.addUpdateField("data_ultima_modifica", "?");
                    }
                    sqlQueryObject.addWhereCondition("id=?");
                    updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    long idConnettore = DriverRegistroServiziDB_LIB.getIdConnettoreSoggetto(oldNomeSoggetto, oldTipoSoggetto, con);
                    connettore.setId(idConnettore);
                    idSoggetto = DBUtils.getIdSoggetto(oldNomeSoggetto, oldTipoSoggetto, con, DriverRegistroServiziDB_LIB.tipoDB);
                    if (idSoggetto <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDSoggetto(UPDATE)] Id Soggetto non valido.");
                    }
                    int index = 1;
                    updateStmt.setString(index++, nome);
                    updateStmt.setString(index++, descizione);
                    updateStmt.setString(index++, identificativoPorta);
                    updateStmt.setString(index++, tipo);
                    updateStmt.setString(index++, server);
                    updateStmt.setString(index++, superUser);
                    if (soggetto.getPrivato() != null && soggetto.getPrivato().booleanValue()) {
                        updateStmt.setInt(index++, 1);
                    } else {
                        updateStmt.setInt(index++, 0);
                    }
                    updateStmt.setString(index++, soggetto.getVersioneProtocollo());
                    updateStmt.setString(index++, codiceIPA);
                    CredenzialiSoggetto credenziali = soggetto.sizeCredenzialiList() > 0 ? soggetto.getCredenziali(0) : null;
                    updateStmt.setString(index++, credenziali != null ? DriverRegistroServiziDB_LIB.getValue(credenziali.getTipo()) : null);
                    updateStmt.setString(index++, credenziali != null ? credenziali.getUser() : null);
                    updateStmt.setString(index++, credenziali != null ? credenziali.getPassword() : null);
                    String subject = null;
                    if (credenziali != null && credenziali.getSubject() != null && !"".equals(credenziali.getSubject())) {
                        subject = credenziali.getSubject();
                    }
                    updateStmt.setString(index++, subject != null ? CertificateUtils.formatPrincipal(subject, (PrincipalType)PrincipalType.SUBJECT) : null);
                    String subjectCN = null;
                    if (credenziali != null && credenziali.getCnSubject() != null && !"".equals(credenziali.getCnSubject())) {
                        subjectCN = credenziali.getCnSubject();
                    }
                    updateStmt.setString(index++, subjectCN);
                    String issuer = null;
                    if (credenziali != null && CredenzialeTipo.APIKEY.equals(credenziali.getTipo())) {
                        updateStmt.setString(index++, CostantiDB.getIssuerApiKey(credenziali.isAppId()));
                    } else {
                        if (credenziali != null && credenziali.getIssuer() != null && !"".equals(credenziali.getIssuer())) {
                            issuer = credenziali.getIssuer();
                        }
                        updateStmt.setString(index++, issuer != null ? CertificateUtils.formatPrincipal(issuer, (PrincipalType)PrincipalType.ISSUER) : null);
                    }
                    String issuerCN = null;
                    if (credenziali != null && credenziali.getCnIssuer() != null && !"".equals(credenziali.getCnIssuer())) {
                        issuerCN = credenziali.getCnIssuer();
                    }
                    updateStmt.setString(index++, issuerCN);
                    byte[] certificate = null;
                    if (credenziali != null && credenziali.getCertificate() != null) {
                        certificate = credenziali.getCertificate();
                    }
                    IJDBCAdapter jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)DriverRegistroServiziDB_LIB.tipoDB);
                    jdbcAdapter.setBinaryData(updateStmt, index++, certificate);
                    if (credenziali != null && credenziali.isCertificateStrictVerification()) {
                        updateStmt.setInt(index++, 1);
                    } else {
                        updateStmt.setInt(index++, 0);
                    }
                    if (soggetto.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(index++, new Timestamp(soggetto.getOraRegistrazione().getTime()));
                    }
                    if (utenteUltimaModifica != null) {
                        updateStmt.setString(index++, utenteUltimaModifica);
                    }
                    if (dataUltimaModifica != null) {
                        updateStmt.setTimestamp(index++, dataUltimaModifica);
                    }
                    updateStmt.setLong(index++, idSoggetto);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDSoggetto type = " + type + " row affected =" + n);
                    String newNomeConnettore = "CNT_" + tipo + "_" + nome;
                    connettore.setNome(newNomeConnettore);
                    DriverRegistroServiziDB_connettoriLIB.CRUDConnettore(2, connettore, con, driverBYOK);
                    DriverRegistroServiziDB_LIB.logDebug("CRUDSoggetto UPDATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, nome, descizione, identificativoPorta, tipo, idSoggetto));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("soggetti_ruoli");
                    sqlQueryObject.addWhereCondition("id_soggetto=?");
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idSoggetto);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDSoggetto type = " + type + " row affected =" + n + " delete roles");
                    n = 0;
                    if (soggetto.getRuoli() != null && soggetto.getRuoli().sizeRuoloList() > 0) {
                        for (i = 0; i < soggetto.getRuoli().sizeRuoloList(); ++i) {
                            RuoloSoggetto ruoloSoggetto = soggetto.getRuoli().getRuolo(i);
                            IDRuolo idRuoloObject = new IDRuolo(ruoloSoggetto.getNome());
                            long idRuolo = DBUtils.getIdRuolo(idRuoloObject, con, DriverRegistroServiziDB_LIB.tipoDB);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                            sqlQueryObject.addInsertTable("soggetti_ruoli");
                            sqlQueryObject.addInsertField("id_soggetto", "?");
                            sqlQueryObject.addInsertField("id_ruolo", "?");
                            updateQuery = sqlQueryObject.createSQLInsert();
                            updateStmt = con.prepareStatement(updateQuery);
                            updateStmt.setLong(1, idSoggetto);
                            updateStmt.setLong(2, idRuolo);
                            int r = updateStmt.executeUpdate();
                            ++n;
                            updateStmt.close();
                            DriverRegistroServiziDB_LIB.logDebug("CRUDSoggetto type = " + type + " row affected =" + r + " create role [" + ruoloSoggetto.getNome() + "]");
                        }
                    }
                    DriverRegistroServiziDB_LIB.logDebug("Aggiunti " + n + " ruoli al soggetto " + idSoggetto);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("soggetti_credenziali");
                    sqlQueryObject.addWhereCondition("id_soggetto=?");
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idSoggetto);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDSoggetto type = " + type + " row affected =" + n + " delete roles");
                    n = 0;
                    if (soggetto.sizeCredenzialiList() > 1) {
                        for (i = 1; i < soggetto.sizeCredenzialiList(); ++i) {
                            CredenzialiSoggetto credenzialiSoggetto = soggetto.getCredenziali(i);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                            sqlQueryObject.addInsertTable("soggetti_credenziali");
                            sqlQueryObject.addInsertField("id_soggetto", "?");
                            sqlQueryObject.addInsertField("subject", "?");
                            sqlQueryObject.addInsertField("cn_subject", "?");
                            sqlQueryObject.addInsertField("issuer", "?");
                            sqlQueryObject.addInsertField("cn_issuer", "?");
                            sqlQueryObject.addInsertField("certificate", "?");
                            sqlQueryObject.addInsertField("cert_strict_verification", "?");
                            updateQuery = sqlQueryObject.createSQLInsert();
                            updateStmt = con.prepareStatement(updateQuery);
                            index = 1;
                            updateStmt.setLong(index++, idSoggetto);
                            String subjectCredenziali = null;
                            if (credenzialiSoggetto != null && credenzialiSoggetto.getSubject() != null && !"".equals(credenzialiSoggetto.getSubject())) {
                                subjectCredenziali = credenzialiSoggetto.getSubject();
                            }
                            updateStmt.setString(index++, subjectCredenziali != null ? CertificateUtils.formatPrincipal(subjectCredenziali, (PrincipalType)PrincipalType.SUBJECT) : null);
                            String subjectCredenzialiCN = null;
                            if (credenzialiSoggetto != null && credenzialiSoggetto.getCnSubject() != null && !"".equals(credenzialiSoggetto.getCnSubject())) {
                                subjectCredenzialiCN = credenzialiSoggetto.getCnSubject();
                            }
                            updateStmt.setString(index++, subjectCredenzialiCN);
                            String issuerCredenziali = null;
                            if (credenzialiSoggetto != null && CredenzialeTipo.APIKEY.equals(credenzialiSoggetto.getTipo())) {
                                updateStmt.setString(index++, CostantiDB.getIssuerApiKey(credenzialiSoggetto.isAppId()));
                            } else {
                                if (credenzialiSoggetto != null && credenzialiSoggetto.getIssuer() != null && !"".equals(credenzialiSoggetto.getIssuer())) {
                                    issuerCredenziali = credenzialiSoggetto.getIssuer();
                                }
                                updateStmt.setString(index++, issuerCredenziali != null ? CertificateUtils.formatPrincipal(issuerCredenziali, (PrincipalType)PrincipalType.ISSUER) : null);
                            }
                            String issuerCredenzialiCN = null;
                            if (credenzialiSoggetto != null && credenzialiSoggetto.getCnIssuer() != null && !"".equals(credenzialiSoggetto.getCnIssuer())) {
                                issuerCredenzialiCN = credenzialiSoggetto.getCnIssuer();
                            }
                            updateStmt.setString(index++, issuerCredenzialiCN);
                            byte[] certificateCredenziali = null;
                            if (credenzialiSoggetto != null && credenzialiSoggetto.getCertificate() != null) {
                                certificateCredenziali = credenzialiSoggetto.getCertificate();
                            }
                            jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)DriverRegistroServiziDB_LIB.tipoDB);
                            jdbcAdapter.setBinaryData(updateStmt, index++, certificateCredenziali);
                            if (credenzialiSoggetto != null && credenzialiSoggetto.isCertificateStrictVerification()) {
                                updateStmt.setInt(index++, 1);
                            } else {
                                updateStmt.setInt(index++, 0);
                            }
                            int r = updateStmt.executeUpdate();
                            ++n;
                            updateStmt.close();
                            DriverRegistroServiziDB_LIB.logDebug("CRUDSoggetto type = " + type + " row affected =" + r + " create credenziale");
                        }
                    }
                    DriverRegistroServiziDB_LIB.logDebug("Aggiunte " + n + " credenziali al soggetto " + idSoggetto);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("soggetti_properties");
                    sqlQueryObject.addWhereCondition("id_soggetto=?");
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idSoggetto);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDSoggetto type = " + type + " row affected =" + n + " delete properties");
                    n = 0;
                    if (soggetto.sizeProprietaList() > 0) {
                        for (i = 0; i < soggetto.sizeProprietaList(); ++i) {
                            BYOKWrappedValue byokValue;
                            Proprieta proprieta = soggetto.getProprieta(i);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                            sqlQueryObject.addInsertTable("soggetti_properties");
                            sqlQueryObject.addInsertField("id_soggetto", "?");
                            sqlQueryObject.addInsertField("nome", "?");
                            sqlQueryObject.addInsertField("valore", "?");
                            sqlQueryObject.addInsertField("enc_value", "?");
                            updateQuery = sqlQueryObject.createSQLInsert();
                            updateStmt = con.prepareStatement(updateQuery);
                            int indexP = 1;
                            updateStmt.setLong(indexP++, idSoggetto);
                            updateStmt.setString(indexP++, proprieta.getNome());
                            String plainValue = proprieta.getValore();
                            String encValue = null;
                            if (driverBYOK != null && BYOKUtilities.isWrappedValue(plainValue) && (byokValue = driverBYOK.wrap(plainValue)) != null) {
                                encValue = byokValue.getWrappedValue();
                                plainValue = byokValue.getWrappedPlainValue();
                            }
                            updateStmt.setString(indexP++, plainValue);
                            updateStmt.setString(indexP++, encValue);
                            int r = updateStmt.executeUpdate();
                            ++n;
                            updateStmt.close();
                            DriverRegistroServiziDB_LIB.logDebug("CRUDSoggetto type = " + type + " row affected =" + r + " create property [" + proprieta.getNome() + "]");
                        }
                    }
                    DriverRegistroServiziDB_LIB.logDebug("Aggiunti " + n + " propriet\u00e0 al soggetto " + idSoggetto);
                    DriverRegistroServiziDB_LIB.CRUDProtocolProperty(2, soggetto.getProtocolPropertyList(), idSoggetto, ProprietariProtocolProperty.SOGGETTO, con, tipoDatabase, driverBYOK);
                    break;
                }
                case 3: {
                    idSoggetto = DBUtils.getIdSoggetto(nome, tipo, con, DriverRegistroServiziDB_LIB.tipoDB);
                    long idConnettore = DriverRegistroServiziDB_LIB.getIdConnettoreSoggetto(nome, tipo, con);
                    if (idSoggetto <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDSoggetto(DELETE)] Id Soggetto non valido.");
                    }
                    DriverRegistroServiziDB_LIB.CRUDProtocolProperty(3, null, idSoggetto, ProprietariProtocolProperty.SOGGETTO, con, tipoDatabase, driverBYOK);
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("soggetti_properties");
                    sqlQueryObject.addWhereCondition("id_soggetto=?");
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idSoggetto);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDSoggetto type = " + type + " row affected =" + n + " delete properties");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("soggetti_credenziali");
                    sqlQueryObject.addWhereCondition("id_soggetto=?");
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idSoggetto);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDSoggetto type = " + type + " row affected =" + n + " delete credentials");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("soggetti_ruoli");
                    sqlQueryObject.addWhereCondition("id_soggetto=?");
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idSoggetto);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDSoggetto type = " + type + " row affected =" + n + " delete roles");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("soggetti");
                    sqlQueryObject.addWhereCondition("id=?");
                    String sqlQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(sqlQuery);
                    updateStmt.setLong(1, idSoggetto);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.logDebug("CRUDSoggetto type = " + type + " row affected =" + n);
                    connettore = new Connettore();
                    connettore.setId(idConnettore);
                    DriverRegistroServiziDB_connettoriLIB.CRUDConnettore(3, connettore, con, driverBYOK);
                    DriverRegistroServiziDB_LIB.logDebug("CRUDSoggetto DELETE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, idSoggetto));
                }
            }
            if (type == 1) {
                long l = idSoggetto;
                return l;
            }
            long l = n;
            return l;
        }
        catch (CoreException e) {
            throw new DriverRegistroServiziException(e);
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDSoggetto] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDSoggetto] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            JDBCUtilities.closeResources(updateStmt);
            JDBCUtilities.closeResources(selectRS, selectStmt);
        }
    }
}

