/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.constants.ProprietariDocumento;
import org.openspcoop2.core.registry.driver.BeanUtilities;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_LIB;
import org.openspcoop2.utils.jdbc.IJDBCAdapter;
import org.openspcoop2.utils.jdbc.JDBCAdapterFactory;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverRegistroServiziDB_documentiLIB {
    /*
     * Unable to fully structure code
     */
    public static void CRUDDocumento(int type, List<Documento> documenti, long idProprietario, ProprietariDocumento tipologiaProprietarioDocumento, Connection connection, String tipoDatabase) throws DriverRegistroServiziException {
        stm = null;
        rs = null;
        if (idProprietario <= 0L) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] id proprietario non definito");
        }
        jdbcAdapter = null;
        try {
            jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)tipoDatabase);
            switch (type) {
                case 1: {
                    if (documenti == null) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] L'oggetto documenti non puo essere null");
                    }
                    for (i = 0; i < documenti.size(); ++i) {
                        doc = documenti.get(i);
                        if (doc.getFile() == null || "".equals(doc.getFile())) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] Nome non definito per documento [" + i + "]");
                        }
                        if (doc.getRuolo() == null || "".equals(doc.getRuolo())) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] Ruolo non definito per documento [" + doc.getFile() + "]");
                        }
                        if (doc.getTipo() == null || "".equals(doc.getTipo())) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] Tipo non definito per documento [" + doc.getFile() + "]");
                        }
                        if (doc.getByteContenuto() == null || doc.getByteContenuto().length <= 0) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] Contenuto non definito per documento [" + doc.getFile() + "]");
                        }
                        BeanUtilities.validateTipoRuolo(doc.getTipo(), doc.getRuolo());
                        contenuto = doc.getByteContenuto();
                        if (contenuto.length < 3 && "".equals((test = new String(contenuto)).trim().replaceAll("\n", ""))) {
                            contenuto = null;
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                        sqlQueryObject.addInsertTable("documenti");
                        sqlQueryObject.addInsertField("ruolo", "?");
                        sqlQueryObject.addInsertField("tipo", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("id_proprietario", "?");
                        sqlQueryObject.addInsertField("tipo_proprietario", "?");
                        if (contenuto != null) {
                            sqlQueryObject.addInsertField("contenuto", "?");
                        }
                        if (doc.getOraRegistrazione() != null) {
                            sqlQueryObject.addInsertField("ora_registrazione", "?");
                        }
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = connection.prepareStatement(sqlQuery);
                        stm.setString(1, doc.getRuolo());
                        stm.setString(2, doc.getTipo());
                        stm.setString(3, doc.getFile());
                        stm.setLong(4, idProprietario);
                        stm.setString(5, tipologiaProprietarioDocumento.toString());
                        index = 6;
                        if (contenuto != null) {
                            jdbcAdapter.setBinaryData(stm, index, contenuto);
                            ++index;
                        }
                        if (doc.getOraRegistrazione() != null) {
                            stm.setTimestamp(index, new Timestamp(doc.getOraRegistrazione().getTime()));
                            ++index;
                        }
                        DriverRegistroServiziDB_LIB.log.debug("CRUDConnettore CREATE : \n" + DBUtils.formatSQLString(sqlQuery, new Object[]{doc.getRuolo(), doc.getTipo(), doc.getFile(), idProprietario, tipologiaProprietarioDocumento.toString()}));
                        n = stm.executeUpdate();
                        stm.close();
                        DriverRegistroServiziDB_LIB.log.debug("Inserted " + n + " row(s)");
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                        sqlQueryObject.addFromTable("documenti");
                        sqlQueryObject.addSelectField("id");
                        sqlQueryObject.addSelectField("ora_registrazione");
                        sqlQueryObject.addWhereCondition("ruolo = ?");
                        sqlQueryObject.addWhereCondition("tipo = ?");
                        sqlQueryObject.addWhereCondition("nome = ?");
                        sqlQueryObject.addWhereCondition("id_proprietario = ?");
                        sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                        sqlQueryObject.setANDLogicOperator(true);
                        sqlQuery = sqlQueryObject.createSQLQuery();
                        stm = connection.prepareStatement(sqlQuery);
                        stm.setString(1, doc.getRuolo());
                        stm.setString(2, doc.getTipo());
                        stm.setString(3, doc.getFile());
                        stm.setLong(4, idProprietario);
                        stm.setString(5, tipologiaProprietarioDocumento.toString());
                        DriverRegistroServiziDB_LIB.log.debug("Recupero idConnettore e oraRegistrazione inserito : \n" + DBUtils.formatSQLString(sqlQuery, new Object[]{doc.getRuolo(), doc.getTipo(), doc.getFile(), idProprietario, tipologiaProprietarioDocumento.toString()}));
                        rs = stm.executeQuery();
                        if (!rs.next()) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDConnettore] Errore tentanto di effettuare la select dopo una create, non riesco a recuperare l'id!");
                        }
                        documenti.get(i).setId(rs.getLong("id"));
                        documenti.get(i).setOraRegistrazione(rs.getTimestamp("ora_registrazione"));
                        rs.close();
                        stm.close();
                    }
                    break;
                }
                case 2: {
                    if (documenti == null) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] L'oggetto documenti non puo essere null");
                    }
                    oldLista = null;
                    try {
                        oldLista = DriverRegistroServiziDB_documentiLIB.getListaDocumenti(idProprietario, tipologiaProprietarioDocumento, false, connection, tipoDatabase);
                    }
                    catch (DriverRegistroServiziNotFound dNotFound) {
                        oldLista = new ArrayList<E>();
                    }
                    for (i = 0; i < documenti.size(); ++i) {
                        doc = documenti.get(i);
                        if (doc.getFile() == null || "".equals(doc.getFile())) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] Nome non definito per documento [" + i + "]");
                        }
                        if (doc.getRuolo() == null || "".equals(doc.getRuolo())) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] Ruolo non definito per documento [" + doc.getFile() + "]");
                        }
                        if (doc.getTipo() == null || "".equals(doc.getTipo())) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] Tipo non definito per documento [" + doc.getFile() + "]");
                        }
                        BeanUtilities.validateTipoRuolo(doc.getTipo(), doc.getRuolo());
                        tipologiaProprietarioDocumentoString = null;
                        if (tipologiaProprietarioDocumento != null) {
                            tipologiaProprietarioDocumentoString = tipologiaProprietarioDocumento.toString();
                        }
                        doc.setId(DBUtils.getIdDocumento(doc.getFile(), doc.getTipo(), doc.getRuolo(), idProprietario, connection, DriverRegistroServiziDB_LIB.tipoDB, tipologiaProprietarioDocumentoString));
                        if (doc.getOraRegistrazione() == null) {
                            doc.setOraRegistrazione(new Date());
                        }
                        doc.setIdProprietarioDocumento(idProprietario);
                        documentoGiaPresente = false;
                        documentoDaAggiornare = false;
                        if (doc.getId() > 0L) {
                            for (j = 0; j < oldLista.size(); ++j) {
                                old = (Documento)oldLista.get(j);
                                if (doc.getId().longValue() != old.getId().longValue()) continue;
                                documentoGiaPresente = true;
                                if (doc.getOraRegistrazione() == null) {
                                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] OraRegistrazione non definita per documento, precedentemente gia inserito, [" + doc.getFile() + "] [" + doc.getTipo() + "] [" + tipologiaProprietarioDocumento + "] [" + idProprietario + "]");
                                }
                                oldLista.remove(j);
                                if (!doc.getOraRegistrazione().after(old.getOraRegistrazione())) continue;
                                documentoDaAggiornare = true;
                            }
                        }
                        contenuto = null;
                        if (!documentoGiaPresente || documentoDaAggiornare) {
                            if (doc.getByteContenuto() == null || doc.getByteContenuto().length <= 0) {
                                throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] Contenuto non definito per documento [" + doc.getFile() + "] [" + doc.getTipo() + "] [" + tipologiaProprietarioDocumento + "] [" + idProprietario + "]");
                            }
                            contenuto = doc.getByteContenuto();
                            if (contenuto.length < 3 && "".equals((test = new String(contenuto)).trim().replaceAll("\n", ""))) {
                                contenuto = null;
                            }
                        }
                        if (documentoGiaPresente) {
                            if (!documentoDaAggiornare) continue;
                            idDocumento = doc.getId();
                            if (idDocumento <= 0L) {
                                throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] ID non definito per documento da aggiorare [" + doc.getFile() + "] [" + doc.getTipo() + "] [" + tipologiaProprietarioDocumento + "] [" + idProprietario + "]");
                            }
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                            sqlQueryObject.addUpdateTable("documenti");
                            sqlQueryObject.addUpdateField("tipo", "?");
                            sqlQueryObject.addUpdateField("nome", "?");
                            sqlQueryObject.addUpdateField("contenuto", "?");
                            sqlQueryObject.addUpdateField("ora_registrazione", "?");
                            sqlQueryObject.addWhereCondition("id=?");
                            sqlQuery = sqlQueryObject.createSQLUpdate();
                            stm = connection.prepareStatement(sqlQuery);
                            stm.setString(1, doc.getTipo());
                            stm.setString(2, doc.getFile());
                            jdbcAdapter.setBinaryData(stm, 3, contenuto);
                            stm.setTimestamp(4, new Timestamp(doc.getOraRegistrazione().getTime()));
                            stm.setLong(5, idDocumento);
                            stm.executeUpdate();
                            stm.close();
                            continue;
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                        sqlQueryObject.addInsertTable("documenti");
                        sqlQueryObject.addInsertField("ruolo", "?");
                        sqlQueryObject.addInsertField("tipo", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("id_proprietario", "?");
                        sqlQueryObject.addInsertField("tipo_proprietario", "?");
                        if (contenuto != null) {
                            sqlQueryObject.addInsertField("contenuto", "?");
                        }
                        if (doc.getOraRegistrazione() != null) {
                            sqlQueryObject.addInsertField("ora_registrazione", "?");
                        }
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = connection.prepareStatement(sqlQuery);
                        stm.setString(1, doc.getRuolo());
                        stm.setString(2, doc.getTipo());
                        stm.setString(3, doc.getFile());
                        stm.setLong(4, idProprietario);
                        stm.setString(5, tipologiaProprietarioDocumento.toString());
                        index = 6;
                        if (contenuto != null) {
                            jdbcAdapter.setBinaryData(stm, index, contenuto);
                            ++index;
                        }
                        if (doc.getOraRegistrazione() != null) {
                            stm.setTimestamp(index, new Timestamp(doc.getOraRegistrazione().getTime()));
                            ++index;
                        }
                        DriverRegistroServiziDB_LIB.log.debug("CRUDDocumento UPDATE : \n" + DBUtils.formatSQLString(sqlQuery, new Object[]{doc.getRuolo(), doc.getTipo(), doc.getFile(), idProprietario, tipologiaProprietarioDocumento.toString()}));
                        n = stm.executeUpdate();
                        stm.close();
                        DriverRegistroServiziDB_LIB.log.debug("Inserted " + n + " row(s)");
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                        sqlQueryObject.addFromTable("documenti");
                        sqlQueryObject.addSelectField("id");
                        sqlQueryObject.addWhereCondition("ruolo = ?");
                        sqlQueryObject.addWhereCondition("tipo = ?");
                        sqlQueryObject.addWhereCondition("nome = ?");
                        sqlQueryObject.addWhereCondition("id_proprietario = ?");
                        sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                        sqlQueryObject.setANDLogicOperator(true);
                        sqlQuery = sqlQueryObject.createSQLQuery();
                        stm = connection.prepareStatement(sqlQuery);
                        stm.setString(1, doc.getRuolo());
                        stm.setString(2, doc.getTipo());
                        stm.setString(3, doc.getFile());
                        stm.setLong(4, idProprietario);
                        stm.setString(5, tipologiaProprietarioDocumento.toString());
                        DriverRegistroServiziDB_LIB.log.debug("Recupero idConnettore inserito : \n" + DBUtils.formatSQLString(sqlQuery, new Object[]{doc.getRuolo(), doc.getTipo(), doc.getFile(), idProprietario, tipologiaProprietarioDocumento.toString()}));
                        rs = stm.executeQuery();
                        if (!rs.next()) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDConnettore] Errore tentanto di effettuare la select dopo una create, non riesco a recuperare l'id!");
                        }
                        documenti.get(i).setId(rs.getLong("id"));
                        rs.close();
                        stm.close();
                    }
                    if (oldLista.size() <= 0) ** break;
                    for (j = 0; j < oldLista.size(); ++j) {
                        old = (Documento)oldLista.get(j);
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                        sqlQueryObject.addDeleteTable("documenti");
                        sqlQueryObject.addWhereCondition("id=?");
                        sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = connection.prepareStatement(sqlQuery);
                        stm.setLong(1, old.getId());
                        stm.executeUpdate();
                        stm.close();
                    }
                    break;
                }
                case 3: {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
                    sqlQueryObject.addDeleteTable("documenti");
                    sqlQueryObject.addWhereCondition("id_proprietario=?");
                    sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setLong(1, idProprietario);
                    stm.setString(2, tipologiaProprietarioDocumento.toString());
                    stm.executeUpdate();
                    stm.close();
                    DriverRegistroServiziDB_LIB.log.debug("CRUDDocumento DELETE : \n" + DBUtils.formatSQLString(sqlQuery, new Object[]{idProprietario}));
                    break;
                }
                ** default:
lbl276:
                // 1 sources

                break;
            }
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] SQLException : " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] Exception : " + se.getMessage(), se);
        }
        finally {
            JDBCUtilities.closeResources(rs, stm);
        }
    }

    public static List<Documento> getListaDocumenti(long idProprietario, ProprietariDocumento tipologiaProprietarioDocumento, boolean readBytes, Connection connection, String tipoDatabase) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return DriverRegistroServiziDB_documentiLIB.getListaDocumenti(null, idProprietario, tipologiaProprietarioDocumento, readBytes, connection, tipoDatabase);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Documento> getListaDocumenti(String ruoloDocumenti, long idProprietario, ProprietariDocumento tipologiaProprietarioDocumento, boolean readBytes, Connection connection, String tipoDatabase) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<Documento> arrayList;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (idProprietario <= 0L) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::getListaDocumenti] id proprietario non definito");
        }
        try {
            ArrayList<Documento> documenti = new ArrayList<Documento>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
            sqlQueryObject.addFromTable("documenti");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_proprietario = ?");
            sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
            sqlQueryObject.setANDLogicOperator(true);
            if (ruoloDocumenti != null) {
                sqlQueryObject.addWhereCondition("ruolo = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idProprietario);
            stm.setString(2, tipologiaProprietarioDocumento.toString());
            if (ruoloDocumenti != null) {
                stm.setString(3, ruoloDocumenti);
            }
            rs = stm.executeQuery();
            while (rs.next()) {
                Documento doc = DriverRegistroServiziDB_documentiLIB.getDocumento(rs.getLong("id"), readBytes, connection, tipoDatabase);
                documenti.add(doc);
            }
            if (documenti.size() <= 0) {
                throw new DriverRegistroServiziNotFound("Documenti con ruolo[" + ruoloDocumenti + "] e idProprietario[" + idProprietario + "] non trovati");
            }
            arrayList = documenti;
        }
        catch (SQLException se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::getListaDocumenti] SQLException : " + se.getMessage(), se);
                catch (DriverRegistroServiziNotFound dnf) {
                    throw dnf;
                }
                catch (Exception se2) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::getListaDocumenti] Exception : " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return arrayList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Documento getDocumento(long id, boolean readBytes, Connection connection, String tipoDatabase) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Documento documento;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (id <= 0L) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::getDocumento] id non definito");
        }
        try {
            IJDBCAdapter jdbcAdapter = null;
            if (readBytes) {
                jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)tipoDatabase);
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverRegistroServiziDB_LIB.tipoDB);
            sqlQueryObject.addFromTable("documenti");
            sqlQueryObject.addSelectField("ruolo");
            sqlQueryObject.addSelectField("tipo");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("id_proprietario");
            sqlQueryObject.addSelectField("tipo_proprietario");
            sqlQueryObject.addSelectField("ora_registrazione");
            sqlQueryObject.addSelectField("id");
            if (readBytes) {
                sqlQueryObject.addSelectField("contenuto");
            }
            sqlQueryObject.addWhereCondition("id = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, id);
            rs = stm.executeQuery();
            Documento doc = null;
            if (rs.next()) {
                doc = new Documento();
                doc.setRuolo(rs.getString("ruolo"));
                doc.setTipo(rs.getString("tipo"));
                doc.setFile(rs.getString("nome"));
                doc.setIdProprietarioDocumento(rs.getLong("id_proprietario"));
                doc.setTipoProprietarioDocumento(rs.getString("tipo_proprietario"));
                doc.setOraRegistrazione(rs.getTimestamp("ora_registrazione"));
                doc.setId(rs.getLong("id"));
                if (readBytes) {
                    doc.setByteContenuto(jdbcAdapter.getBinaryData(rs, 8));
                }
            }
            if (doc == null) {
                throw new DriverRegistroServiziNotFound("Documento con id[" + id + "] non trovato");
            }
            documento = doc;
        }
        catch (SQLException se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::getDocumento] SQLException : " + se.getMessage(), se);
                catch (DriverRegistroServiziNotFound dnf) {
                    throw dnf;
                }
                catch (Exception se2) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::getDocumento] Exception : " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return documento;
    }
}

