/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.constants.ProprietariDocumento;
import org.openspcoop2.core.registry.constants.RuoliDocumento;
import org.openspcoop2.core.registry.constants.TipiDocumentoLivelloServizio;
import org.openspcoop2.core.registry.constants.TipiDocumentoSemiformale;
import org.openspcoop2.core.registry.constants.TipiDocumentoSicurezza;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_documentiLIB;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverRegistroServiziDB_documentiDriver {
    private DriverRegistroServiziDB driver = null;

    protected DriverRegistroServiziDB_documentiDriver(DriverRegistroServiziDB driver) {
        this.driver = driver;
    }

    protected boolean existsDocumento(String nome, String tipo, String ruolo, long idProprietario, ProprietariDocumento proprietarioDocumento) throws DriverRegistroServiziException {
        Connection connection;
        boolean exist = false;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (this.driver.atomica) {
            try {
                connection = this.driver.getConnectionFromDatasource("existsDocumento");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsDocumento] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("documenti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_proprietario = ?");
            sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
            sqlQueryObject.addWhereCondition("nome = ?");
            if (tipo != null) {
                sqlQueryObject.addWhereCondition("tipo = ?");
            }
            if (ruolo != null) {
                sqlQueryObject.addWhereCondition("ruolo = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            int index = 1;
            stm.setLong(index++, idProprietario);
            stm.setString(index++, proprietarioDocumento.toString());
            stm.setString(index++, nome);
            if (tipo != null) {
                stm.setString(index++, tipo);
            }
            if (ruolo != null) {
                stm.setString(index++, ruolo);
            }
            if ((rs = stm.executeQuery()).next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            try {
                exist = false;
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(connection);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(connection);
        return exist;
    }

    protected Documento getDocumento(String nome, String tipo, String ruolo, long idProprietario, boolean readBytes, ProprietariDocumento tipoProprietario) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String nomeMetodo = "getDocumento";
        Connection con = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getDocumento");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        try {
            long idDoc;
            String tipoProprietarioAsString = null;
            if (tipoProprietario != null) {
                tipoProprietarioAsString = tipoProprietario.toString();
            }
            if ((idDoc = DBUtils.getIdDocumento(nome, tipo, ruolo, idProprietario, con, this.driver.tipoDB, tipoProprietarioAsString)) <= 0L) {
                throw new DriverRegistroServiziNotFound("Documento richiesto non esistente (nome:" + nome + ", tipo:" + tipo + ", ruolo:" + ruolo + ", idProprietario:" + idProprietario + ", tipoProprietario:" + tipoProprietarioAsString + ")");
            }
            Documento documento = DriverRegistroServiziDB_documentiLIB.getDocumento(idDoc, readBytes, con, this.driver.tipoDB);
            return documento;
        }
        catch (DriverRegistroServiziNotFound se) {
            throw se;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.driver.closeConnection(con);
        }
    }

    protected Documento getDocumento(long idDocumento, boolean readBytes) throws DriverRegistroServiziException {
        String nomeMetodo = "getDocumento";
        Connection con = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getDocumento");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        try {
            Documento e = DriverRegistroServiziDB_documentiLIB.getDocumento(idDocumento, readBytes, con, this.driver.tipoDB);
            return e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.driver.closeConnection(con);
        }
    }

    protected List<Documento> serviziAllegatiList(long idServizio, ISearch ricerca) throws DriverRegistroServiziException {
        ArrayList<Documento> arrayList;
        String nomeMetodo = "serviziAllegatiList";
        int idLista = Liste.SERVIZI_ALLEGATI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Documento> lista = new ArrayList<Documento>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("serviziAllegatiList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("documenti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_proprietario = ?");
                sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("nome", search, true, true)});
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("documenti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_proprietario = ?");
                sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idServizio);
            stmt.setString(2, ProprietariDocumento.servizio.toString());
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("documenti");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("ruolo");
            sqlQueryObject.addSelectField("id_proprietario");
            sqlQueryObject.addSelectField("tipo_proprietario");
            sqlQueryObject.addWhereCondition("id_proprietario = ?");
            sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("nome", search, true, true)});
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idServizio);
            stmt.setString(2, ProprietariDocumento.servizio.toString());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Documento doc = DriverRegistroServiziDB_documentiLIB.getDocumento(risultato.getLong("id"), false, con, this.driver.tipoDB);
                lista.add(doc);
            }
            arrayList = lista;
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected Documento getAllegato(IDServizio idASPS, String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getEngineDocumento(idASPS, RuoliDocumento.allegato.toString(), null, nome);
    }

    protected Documento getSpecificaSemiformale(IDServizio idASPS, TipiDocumentoSemiformale tipo, String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getEngineDocumento(idASPS, RuoliDocumento.specificaSemiformale.toString(), tipo.toString(), nome);
    }

    protected Documento getSpecificaSicurezza(IDServizio idASPS, TipiDocumentoSicurezza tipo, String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getEngineDocumento(idASPS, RuoliDocumento.specificaSicurezza.toString(), tipo.toString(), nome);
    }

    protected Documento getSpecificaLivelloServizio(IDServizio idASPS, TipiDocumentoLivelloServizio tipo, String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getEngineDocumento(idASPS, RuoliDocumento.specificaLivelloServizio.toString(), tipo.toString(), nome);
    }

    private Documento getEngineDocumento(IDServizio idASPS, String ruolo, String tipo, String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ResultSet risultato;
        PreparedStatement stmt;
        Connection con;
        String nomeMetodo;
        block13: {
            Documento doc;
            nomeMetodo = "getDocumento";
            con = null;
            stmt = null;
            risultato = null;
            if (this.driver.atomica) {
                try {
                    con = this.driver.getConnectionFromDatasource("serviziAllegatiList");
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.driver.globalConnection;
            }
            long idServizio = DBUtils.getIdAccordoServizioParteSpecifica(idASPS, con, this.driver.tipoDB);
            if (idServizio <= 0L) {
                throw new DriverRegistroServiziNotFound("ApiImpl '" + idASPS + "' undefined");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("documenti");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_proprietario = ?");
            sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
            sqlQueryObject.addWhereCondition("ruolo = ?");
            if (tipo != null) {
                sqlQueryObject.addWhereCondition("tipo = ?");
            }
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int index = 1;
            stmt.setLong(index++, idServizio);
            stmt.setString(index++, ProprietariDocumento.servizio.toString());
            stmt.setString(index++, ruolo);
            if (tipo != null) {
                stmt.setString(index++, tipo);
            }
            stmt.setString(index++, nome);
            risultato = stmt.executeQuery();
            if (!risultato.next()) break block13;
            Documento documento = doc = DriverRegistroServiziDB_documentiLIB.getDocumento(risultato.getLong("id"), true, con, this.driver.tipoDB);
            JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
            this.driver.closeConnection(con);
            return documento;
        }
        try {
            try {
                Object tipoS = tipo != null ? "tipo:" + tipo + " " : "";
                throw new DriverRegistroServiziNotFound("Documento (ruolo:" + ruolo + " " + (String)tipoS + "nome:" + nome + ") non trovato");
            }
            catch (DriverRegistroServiziNotFound notFound) {
                throw notFound;
            }
            catch (Exception se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
        }
        catch (Throwable throwable) {
            JDBCUtilities.closeResources(risultato, stmt);
            this.driver.closeConnection(con);
            throw throwable;
        }
    }

    protected Documento getAllegato(IDAccordo idAccordo, String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getEngineDocumento(idAccordo, RuoliDocumento.allegato.toString(), null, nome);
    }

    protected Documento getSpecificaSemiformale(IDAccordo idAccordo, TipiDocumentoSemiformale tipo, String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getEngineDocumento(idAccordo, RuoliDocumento.specificaSemiformale.toString(), tipo.toString(), nome);
    }

    private Documento getEngineDocumento(IDAccordo idAccordo, String ruolo, String tipo, String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ResultSet risultato;
        PreparedStatement stmt;
        Connection con;
        String nomeMetodo;
        block13: {
            Documento doc;
            nomeMetodo = "getDocumento";
            con = null;
            stmt = null;
            risultato = null;
            if (this.driver.atomica) {
                try {
                    con = this.driver.getConnectionFromDatasource("serviziAllegatiList");
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.driver.globalConnection;
            }
            long idAccordoLong = DBUtils.getIdAccordoServizioParteComune(idAccordo, con, this.driver.tipoDB);
            if (idAccordoLong <= 0L) {
                throw new DriverRegistroServiziNotFound("Api '" + idAccordo + "' undefined");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("documenti");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_proprietario = ?");
            sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
            sqlQueryObject.addWhereCondition("ruolo = ?");
            if (tipo != null) {
                sqlQueryObject.addWhereCondition("tipo = ?");
            }
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int index = 1;
            stmt.setLong(index++, idAccordoLong);
            stmt.setString(index++, ProprietariDocumento.accordoServizio.toString());
            stmt.setString(index++, ruolo);
            if (tipo != null) {
                stmt.setString(index++, tipo);
            }
            stmt.setString(index++, nome);
            risultato = stmt.executeQuery();
            if (!risultato.next()) break block13;
            Documento documento = doc = DriverRegistroServiziDB_documentiLIB.getDocumento(risultato.getLong("id"), true, con, this.driver.tipoDB);
            JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
            this.driver.closeConnection(con);
            return documento;
        }
        try {
            try {
                Object tipoS = tipo != null ? "tipo:" + tipo + " " : "";
                throw new DriverRegistroServiziNotFound("Documento (ruolo:" + ruolo + " " + (String)tipoS + "nome:" + nome + ") non trovato");
            }
            catch (DriverRegistroServiziNotFound notFound) {
                throw notFound;
            }
            catch (Exception se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
        }
        catch (Throwable throwable) {
            JDBCUtilities.closeResources(risultato, stmt);
            this.driver.closeConnection(con);
            throw throwable;
        }
    }
}

