/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.Filtri;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.CostantiRegistroServizi;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.core.registry.constants.TipologiaServizio;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverRegistroServiziDB_accordiParteSpecificaSearchDriver {
    private DriverRegistroServiziDB driver = null;

    protected DriverRegistroServiziDB_accordiParteSpecificaSearchDriver(DriverRegistroServiziDB driver) {
        this.driver = driver;
    }

    protected List<AccordoServizioParteSpecifica> serviziList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        ArrayList<AccordoServizioParteSpecifica> arrayList;
        String nomeMetodo = "serviziList";
        int idLista = Liste.SERVIZI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        this.driver.logDebug("search : " + search);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizioParteSpecifica> lista = new ArrayList<AccordoServizioParteSpecifica>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("serviziList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addWhereLikeCondition("nome_servizio", search, true, true);
                if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.setANDLogicOperator(true);
                if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                stmt.setString(1, superuser);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_servizio");
                sqlQueryObject.addSelectField("tipo_servizio");
                sqlQueryObject.addSelectField("versione_servizio");
                sqlQueryObject.addSelectField("id_soggetto");
                sqlQueryObject.addSelectField("id_accordo");
                sqlQueryObject.addSelectField("servizio_correlato");
                sqlQueryObject.addSelectField("stato");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addWhereLikeCondition("nome_servizio", search, true, true);
                if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addOrderBy("tipo_servizio");
                sqlQueryObject.addOrderBy("nome_servizio");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_servizio");
                sqlQueryObject.addSelectField("tipo_servizio");
                sqlQueryObject.addSelectField("versione_servizio");
                sqlQueryObject.addSelectField("id_soggetto");
                sqlQueryObject.addSelectField("id_accordo");
                sqlQueryObject.addSelectField("servizio_correlato");
                sqlQueryObject.addSelectField("stato");
                sqlQueryObject.setANDLogicOperator(true);
                if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addOrderBy("tipo_servizio");
                sqlQueryObject.addOrderBy("nome_servizio");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            this.driver.logDebug("query : " + queryString);
            stmt = con.prepareStatement(queryString);
            if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                stmt.setString(1, superuser);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                AccordoServizioParteSpecifica asps = new AccordoServizioParteSpecifica();
                asps.setId(risultato.getLong("id"));
                asps.setNome(risultato.getString("nome_servizio"));
                asps.setTipo(risultato.getString("tipo_servizio"));
                asps.setVersione(risultato.getInt("versione_servizio"));
                asps.setIdSoggetto(risultato.getLong("id_soggetto"));
                asps.setIdAccordo(risultato.getLong("id_accordo"));
                String servizio_correlato = risultato.getString("servizio_correlato");
                if (servizio_correlato != null && (servizio_correlato.equalsIgnoreCase(CostantiRegistroServizi.ABILITATO.toString()) || TipologiaServizio.CORRELATO.toString().equals(servizio_correlato))) {
                    asps.setTipologiaServizio(TipologiaServizio.CORRELATO);
                } else {
                    asps.setTipologiaServizio(TipologiaServizio.NORMALE);
                }
                Soggetto sog = this.driver.getSoggetto(asps.getIdSoggetto(), con);
                String nomeErogatore = sog.getNome();
                String tipoErogatore = sog.getTipo();
                asps.setNomeSoggettoErogatore(nomeErogatore);
                asps.setTipoSoggettoErogatore(tipoErogatore);
                AccordoServizioParteComune as = this.driver.getAccordoServizioParteComune(asps.getIdAccordo(), con);
                asps.setAccordoServizioParteComune(this.driver.idAccordoFactory.getUriFromAccordo(as));
                asps.setStatoPackage(risultato.getString("stato"));
                lista.add(asps);
            }
            this.driver.logDebug("size lista :" + (lista == null ? null : Integer.valueOf(lista.size())));
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<Soggetto> accordiErogatoriList(long idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        ArrayList<Soggetto> arrayList;
        String nomeMetodo = "accordiErogatoriList";
        int idLista = Liste.ACCORDI_EROGATORI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        PreparedStatement stmt2 = null;
        ResultSet risultato2 = null;
        ArrayList<Soggetto> lista = new ArrayList<Soggetto>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("accordiErogatoriList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("servizi.id_accordo = ?");
                sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("soggetti.tipo_soggetto", search, true, true)});
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("servizi.id_accordo = ?");
                sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti.id");
                sqlQueryObject.addSelectField("soggetti.descrizione");
                sqlQueryObject.addSelectField("soggetti.identificativo_porta");
                sqlQueryObject.addSelectField("soggetti.codice_ipa");
                sqlQueryObject.addSelectAliasField("servizi.id", "servid");
                sqlQueryObject.addSelectField("servizi.nome_servizio");
                sqlQueryObject.addSelectField("servizi.tipo_servizio");
                sqlQueryObject.addSelectField("servizi.versione_servizio");
                sqlQueryObject.addSelectField("servizi.servizio_correlato");
                sqlQueryObject.addSelectField("servizi.id_accordo");
                sqlQueryObject.addSelectField("servizi.id_soggetto");
                sqlQueryObject.addWhereCondition("servizi.id_accordo = ?");
                sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("soggetti.tipo_soggetto", search, true, true)});
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
                sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti.id");
                sqlQueryObject.addSelectField("soggetti.descrizione");
                sqlQueryObject.addSelectField("soggetti.identificativo_porta");
                sqlQueryObject.addSelectField("soggetti.codice_ipa");
                sqlQueryObject.addSelectAliasField("servizi.id", "servid");
                sqlQueryObject.addSelectField("servizi.nome_servizio");
                sqlQueryObject.addSelectField("servizi.tipo_servizio");
                sqlQueryObject.addSelectField("servizi.versione_servizio");
                sqlQueryObject.addSelectField("servizi.servizio_correlato");
                sqlQueryObject.addSelectField("servizi.id_accordo");
                sqlQueryObject.addSelectField("servizi.id_soggetto");
                sqlQueryObject.addWhereCondition("servizi.id_accordo = ?");
                sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("tipo_soggetto");
                sqlQueryObject.addOrderBy("nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            risultato = stmt.executeQuery();
            Soggetto sog = null;
            String oldNome = "";
            String oldTipo = "";
            while (risultato.next()) {
                String newNome = risultato.getString("nome_soggetto");
                String newTipo = risultato.getString("tipo_soggetto");
                if (sog == null || !oldTipo.equals(newTipo) || !oldNome.equals(newNome)) {
                    oldTipo = newTipo;
                    oldNome = newNome;
                    if (sog != null) {
                        lista.add(sog);
                    }
                    sog = new Soggetto();
                    sog.setId(risultato.getLong("id"));
                    sog.setNome(risultato.getString("nome_soggetto"));
                    sog.setTipo(risultato.getString("tipo_soggetto"));
                    sog.setDescrizione(risultato.getString("descrizione"));
                    sog.setIdentificativoPorta(risultato.getString("identificativo_porta"));
                    sog.setCodiceIpa(risultato.getString("codice_ipa"));
                }
                AccordoServizioParteSpecifica serv = new AccordoServizioParteSpecifica();
                serv.setId(risultato.getLong("servid"));
                serv.setNome(risultato.getString("nome_servizio"));
                serv.setTipo(risultato.getString("tipo_servizio"));
                serv.setVersione(risultato.getInt("versione_servizio"));
                if (risultato.getString("servizio_correlato").equals(CostantiRegistroServizi.ABILITATO.toString()) || TipologiaServizio.CORRELATO.toString().equals(risultato.getString("servizio_correlato"))) {
                    serv.setTipologiaServizio(TipologiaServizio.CORRELATO);
                } else {
                    serv.setTipologiaServizio(TipologiaServizio.NORMALE);
                }
                ISQLQueryObject sqlQueryObjectFruitori = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectFruitori.addFromTable("servizi");
                sqlQueryObjectFruitori.addFromTable("servizi_fruitori");
                sqlQueryObjectFruitori.addFromTable("soggetti");
                sqlQueryObjectFruitori.addSelectField("soggetti", "tipo_soggetto");
                sqlQueryObjectFruitori.addSelectField("soggetti", "nome_soggetto");
                sqlQueryObjectFruitori.addWhereCondition("servizi.id = ?");
                sqlQueryObjectFruitori.addWhereCondition("servizi.id = servizi_fruitori.id_servizio");
                sqlQueryObjectFruitori.addWhereCondition("soggetti.id = servizi_fruitori.id_soggetto");
                sqlQueryObjectFruitori.setANDLogicOperator(true);
                sqlQueryObjectFruitori.setSelectDistinct(true);
                String queryStringFruitori = sqlQueryObjectFruitori.createSQLQuery();
                stmt2 = con.prepareStatement(queryStringFruitori);
                stmt2.setLong(1, serv.getId());
                risultato2 = stmt2.executeQuery();
                while (risultato2.next()) {
                    String nome = risultato2.getString("nome_soggetto");
                    String tipo = risultato2.getString("tipo_soggetto");
                    Fruitore fruitore = new Fruitore();
                    fruitore.setTipo(tipo);
                    fruitore.setNome(nome);
                    serv.addFruitore(fruitore);
                }
                risultato2.close();
                stmt2.close();
                serv.setTipoSoggettoErogatore(sog.getTipo());
                serv.setNomeSoggettoErogatore(sog.getNome());
                sog.addAccordoServizioParteSpecifica(serv);
            }
            if (sog != null) {
                lista.add(sog);
            }
            arrayList = lista;
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                JDBCUtilities.closeResources(risultato2, stmt2);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        JDBCUtilities.closeResources(risultato2, stmt2);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<AccordoServizioParteSpecifica> getServiziByIdErogatore(long idErogatore, ISearch filters) throws DriverRegistroServiziException {
        return this.getServiziByIdErogatoreAndFilters(idErogatore, filters);
    }

    private List<AccordoServizioParteSpecifica> getServiziByIdErogatoreAndFilters(long idErogatore, ISearch filters) throws DriverRegistroServiziException {
        ArrayList<AccordoServizioParteSpecifica> arrayList;
        String nomeMetodo = "getServiziByIdErogatoreAndFilters";
        int idLista = Liste.SERVIZI;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        int limit = filters.getPageSize(idLista);
        int offset = filters.getIndexIniziale(idLista);
        String search = "undefined".equals(filters.getSearchString(idLista)) ? "" : filters.getSearchString(idLista);
        ArrayList<AccordoServizioParteSpecifica> lista = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getServiziByIdErogatoreAndFilters");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome_servizio", search, true, true);
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idErogatore);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                filters.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome_servizio");
            sqlQueryObject.addSelectField("tipo_servizio");
            sqlQueryObject.addSelectField("versione_servizio");
            sqlQueryObject.addSelectField("id_soggetto");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome_servizio", search, true, true);
            }
            sqlQueryObject.addOrderBy("nome_servizio");
            sqlQueryObject.addOrderBy("versione_servizio");
            sqlQueryObject.addOrderBy("tipo_servizio");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idErogatore);
            risultato = stmt.executeQuery();
            lista = new ArrayList<AccordoServizioParteSpecifica>();
            while (risultato.next()) {
                long id = risultato.getLong("id");
                AccordoServizioParteSpecifica se = this.driver.getAccordoServizioParteSpecifica(id, con);
                lista.add(se);
            }
            arrayList = lista;
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<AccordoServizioParteSpecifica> soggettiServizioList(String superuser, ISearch ricerca, boolean[] permessiUtente, boolean gestioneFruitori, boolean gestioneErogatori) throws DriverRegistroServiziException {
        ArrayList<AccordoServizioParteSpecifica> arrayList;
        String filtroCORSorigin;
        String filtroCORS;
        String filtroConfigurazioneDumpTipo;
        String filtroCorrelazioneApplicativa;
        String filtroConfigurazioneTransazioni;
        String filtroTrasformazione;
        String filtroMTOMStato;
        String filtroMessageSecurityStato;
        String filtroCacheRispostaStato;
        String filtroValidazioneStato;
        String filtroAutenticazioneTrasportoTipoPlugin;
        String filtroAutenticazioneTrasportoTipo;
        String filtroAutenticazioneTokenPolicy;
        String filterGruppo;
        String nomeMetodo = "soggettiServizioList";
        int idLista = Liste.SERVIZI;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizioParteSpecifica> serviziList = new ArrayList<AccordoServizioParteSpecifica>();
        String aliasSoggettiFruitori = "soggettoFruitore";
        String aliasSoggettiReferenti = "soggettoReferente";
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String searchAPIErogazioneFruizione = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        String filterProtocollo = SearchUtils.getFilter(ricerca, idLista, "filtroProtocollo");
        String filterProtocolli = SearchUtils.getFilter(ricerca, idLista, "filtroProtocolli");
        List<String> tipoServiziProtocollo = null;
        try {
            tipoServiziProtocollo = Filtri.convertToTipiServizi(filterProtocollo, filterProtocolli);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        String filterTipoAPI = SearchUtils.getFilter(ricerca, idLista, "filtroServiceBinding");
        if (filterTipoAPI != null && filterTipoAPI.equals("")) {
            filterTipoAPI = null;
        }
        if ((filterGruppo = SearchUtils.getFilter(ricerca, idLista, "filtroGruppo")) != null && filterGruppo.equals("")) {
            filterGruppo = null;
        }
        String filterApi = SearchUtils.getFilter(ricerca, idLista, "filtroApi");
        IDAccordo idAccordoApi = null;
        if (filterApi != null && filterApi.equals("")) {
            filterApi = null;
        }
        if (filterApi != null) {
            try {
                idAccordoApi = IDAccordoFactory.getInstance().getIDAccordoFromUri(filterApi);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
        }
        String filterCanale = SearchUtils.getFilter(ricerca, idLista, "filtroCanale");
        boolean searchCanale = false;
        boolean canaleDefault = false;
        if ((gestioneFruitori || gestioneErogatori) && filterCanale != null && !filterCanale.equals("")) {
            searchCanale = true;
            if (filterCanale.startsWith("__DEFAULT__ ")) {
                filterCanale = filterCanale.substring("__DEFAULT__ ".length());
                canaleDefault = true;
            }
        }
        String filterDominio = SearchUtils.getFilter(ricerca, idLista, "filtroDominio");
        PddTipologia pddTipologia = null;
        if (filterDominio != null && !"".equals(filterDominio)) {
            pddTipologia = PddTipologia.toPddTipologia(filterDominio);
        }
        String filterStatoAccordo = SearchUtils.getFilter(ricerca, idLista, "filtroStatoAccordo");
        String filterSoggettoTipoNome = SearchUtils.getFilter(ricerca, idLista, "filtroSoggetto");
        String filterSoggettoTipo = null;
        String filterSoggettoNome = null;
        if (filterSoggettoTipoNome != null && !"".equals(filterSoggettoTipoNome)) {
            filterSoggettoTipo = filterSoggettoTipoNome.split("/")[0];
            filterSoggettoNome = filterSoggettoTipoNome.split("/")[1];
        }
        String filterSoggettoErogatoreContains = SearchUtils.getFilter(ricerca, idLista, "filtroSoggettoErogatoreContains");
        String filtroStatoAPIImpl = SearchUtils.getFilter(ricerca, idLista, "filtroConfigurazioneStato");
        if (filtroStatoAPIImpl != null && "".equals(filtroStatoAPIImpl)) {
            filtroStatoAPIImpl = null;
        }
        if ((filtroAutenticazioneTokenPolicy = SearchUtils.getFilter(ricerca, idLista, "filtroAutenticazioneTokenTipo")) != null && "".equals(filtroAutenticazioneTokenPolicy)) {
            filtroAutenticazioneTokenPolicy = null;
        }
        if ((filtroAutenticazioneTrasportoTipo = SearchUtils.getFilter(ricerca, idLista, "filtroAutenticazioneTrasportoTipo")) != null && "".equals(filtroAutenticazioneTrasportoTipo)) {
            filtroAutenticazioneTrasportoTipo = null;
        }
        if ((filtroAutenticazioneTrasportoTipoPlugin = SearchUtils.getFilter(ricerca, idLista, "filtroAutenticazioneTrasportoTipoPlugin")) != null && "".equals(filtroAutenticazioneTrasportoTipoPlugin)) {
            filtroAutenticazioneTrasportoTipoPlugin = null;
        }
        if (filtroAutenticazioneTrasportoTipoPlugin != null && !"custom".equals(filtroAutenticazioneTrasportoTipo)) {
            filtroAutenticazioneTrasportoTipoPlugin = null;
        }
        String filtroAutenticazioneTrasporto = filtroAutenticazioneTrasportoTipoPlugin != null ? filtroAutenticazioneTrasportoTipoPlugin : filtroAutenticazioneTrasportoTipo;
        String filtroRateLimitingStato = SearchUtils.getFilter(ricerca, idLista, "filtroConfigurazioneRateLimitingStato");
        if (filtroRateLimitingStato != null && "".equals(filtroRateLimitingStato)) {
            filtroRateLimitingStato = null;
        }
        if ((filtroValidazioneStato = SearchUtils.getFilter(ricerca, idLista, "filtroConfigurazioneValidazioneStato")) != null && "".equals(filtroValidazioneStato)) {
            filtroValidazioneStato = null;
        }
        if ((filtroCacheRispostaStato = SearchUtils.getFilter(ricerca, idLista, "filtroConfigurazioneCacheRispostaStato")) != null && "".equals(filtroCacheRispostaStato)) {
            filtroCacheRispostaStato = null;
        }
        if ((filtroMessageSecurityStato = SearchUtils.getFilter(ricerca, idLista, "filtroConfigurazioneMessageSecurityStato")) != null && "".equals(filtroMessageSecurityStato)) {
            filtroMessageSecurityStato = null;
        }
        if ((filtroMTOMStato = SearchUtils.getFilter(ricerca, idLista, "filtroConfigurazioneMTOMStato")) != null && "".equals(filtroMTOMStato)) {
            filtroMTOMStato = null;
        }
        if (filtroMTOMStato != null && "rest".equalsIgnoreCase(filterTipoAPI)) {
            filtroMTOMStato = null;
        }
        if ((filtroTrasformazione = SearchUtils.getFilter(ricerca, idLista, "filtroConfigurazioneTrasformazione")) != null && "".equals(filtroTrasformazione)) {
            filtroTrasformazione = null;
        }
        if ((filtroConfigurazioneTransazioni = SearchUtils.getFilter(ricerca, idLista, "filtroConfigurazioneTransazioni")) != null && "".equals(filtroConfigurazioneTransazioni)) {
            filtroConfigurazioneTransazioni = null;
        }
        if ((filtroCorrelazioneApplicativa = SearchUtils.getFilter(ricerca, idLista, "filtroConfigurazioneCorrelazioneApplicativaStato")) != null && "".equals(filtroCorrelazioneApplicativa)) {
            filtroCorrelazioneApplicativa = null;
        }
        if ((filtroConfigurazioneDumpTipo = SearchUtils.getFilter(ricerca, idLista, "filtroConfigurazioneDumpTipo")) != null && "".equals(filtroConfigurazioneDumpTipo)) {
            filtroConfigurazioneDumpTipo = null;
        }
        if ((filtroCORS = SearchUtils.getFilter(ricerca, idLista, "filtroConfigurazioneCorsTipo")) != null && "".equals(filtroCORS)) {
            filtroCORS = null;
        }
        if ((filtroCORSorigin = SearchUtils.getFilter(ricerca, idLista, "filtroConfigurazioneCorsOrigin")) != null && "".equals(filtroCORSorigin)) {
            filtroCORSorigin = null;
        }
        if (filtroCORSorigin != null && !"Ridefinito (abilitato)".equals(filtroCORS)) {
            filtroCORSorigin = null;
        }
        String filtroConnettoreTipo = SearchUtils.getFilter(ricerca, idLista, "filtroConnettoreTipo");
        String filtroConnettoreTipoPlugin = SearchUtils.getFilter(ricerca, idLista, "filtroConnettoreTipoPlugin");
        String filtroConnettoreTokenPolicy = SearchUtils.getFilter(ricerca, idLista, "filtroConnettoreTokenPolicy");
        String filtroConnettoreEndpoint = SearchUtils.getFilter(ricerca, idLista, "filtroConnettoreEndpoint");
        String filtroConnettoreKeystore = SearchUtils.getFilter(ricerca, idLista, "filtroConnettoreKeystore");
        String filtroConnettoreDebug = SearchUtils.getFilter(ricerca, idLista, "filtroConnettoreDebug");
        if (filtroConnettoreTipo != null && "".equals(filtroConnettoreTipo)) {
            filtroConnettoreTipo = null;
        }
        if (filtroConnettoreTipoPlugin != null && "".equals(filtroConnettoreTipoPlugin)) {
            filtroConnettoreTipoPlugin = null;
        }
        if (filtroConnettoreTokenPolicy != null && "".equals(filtroConnettoreTokenPolicy)) {
            filtroConnettoreTokenPolicy = null;
        }
        if (filtroConnettoreEndpoint != null && "".equals(filtroConnettoreEndpoint)) {
            filtroConnettoreEndpoint = null;
        }
        if (filtroConnettoreKeystore != null && "".equals(filtroConnettoreKeystore)) {
            filtroConnettoreKeystore = null;
        }
        if (filtroConnettoreDebug != null && "".equals(filtroConnettoreDebug)) {
            filtroConnettoreDebug = null;
        }
        boolean joinConnettore = filtroConnettoreTipo != null || filtroConnettoreTokenPolicy != null || filtroConnettoreEndpoint != null || filtroConnettoreKeystore != null || filtroConnettoreDebug != null;
        TipiConnettore tipoConnettore = null;
        String endpointType = null;
        boolean tipoConnettoreIntegrationManager = false;
        if (filtroConnettoreTipo != null && !"".equals(filtroConnettoreTipo)) {
            if ("IM".equals(filtroConnettoreTipo)) {
                tipoConnettoreIntegrationManager = true;
            } else {
                tipoConnettore = TipiConnettore.toEnumFromName(filtroConnettoreTipo);
                if (tipoConnettore != null) {
                    endpointType = TipiConnettore.CUSTOM.equals((Object)tipoConnettore) ? filtroConnettoreTipoPlugin : tipoConnettore.getNome();
                }
            }
        }
        String filtroModISicurezzaCanale = SearchUtils.getFilter(ricerca, idLista, "filtroModiSicCanale");
        String filtroModISicurezzaMessaggio = SearchUtils.getFilter(ricerca, idLista, "filtroModiSicMessaggio");
        String filtroModISorgenteToken = SearchUtils.getFilter(ricerca, idLista, "filtroModiGenToken");
        String filtroModIKeystorePath = SearchUtils.getFilter(ricerca, idLista, "filtroModiKeystorePath");
        String filtroModIAudience = SearchUtils.getFilter(ricerca, idLista, "filtroModiAudience");
        String filtroModIInfoUtente = SearchUtils.getFilter(ricerca, idLista, "filtroModiInfoUtente");
        String filtroModIDigestRichiesta = SearchUtils.getFilter(ricerca, idLista, "filtroModiDigestRich");
        if (filtroModISicurezzaCanale != null && "".equals(filtroModISicurezzaCanale)) {
            filtroModISicurezzaCanale = null;
        }
        if (filtroModISicurezzaMessaggio != null && "".equals(filtroModISicurezzaMessaggio)) {
            filtroModISicurezzaMessaggio = null;
        }
        if (filtroModISorgenteToken != null && "".equals(filtroModISorgenteToken)) {
            filtroModISorgenteToken = null;
        }
        Boolean filtroModIDigestRichiestaEnabled = null;
        if ("abilitato".equals(filtroModIDigestRichiesta)) {
            filtroModIDigestRichiestaEnabled = true;
        } else if ("disabilitato".equals(filtroModIDigestRichiesta)) {
            filtroModIDigestRichiestaEnabled = false;
        }
        if (filtroModIInfoUtente != null && "".equals(filtroModIInfoUtente)) {
            filtroModIInfoUtente = null;
        }
        if (filtroModIKeystorePath != null && "".equals(filtroModIKeystorePath)) {
            filtroModIKeystorePath = null;
        }
        if (filtroModIAudience != null && "".equals(filtroModIAudience)) {
            filtroModIAudience = null;
        }
        boolean filtroModI = filtroModISicurezzaCanale != null || filtroModISicurezzaMessaggio != null || filtroModISorgenteToken != null || filtroModIDigestRichiestaEnabled != null || filtroModIInfoUtente != null || filtroModIKeystorePath != null || filtroModIAudience != null;
        String filtroProprietaNome = SearchUtils.getFilter(ricerca, idLista, "filtroPropNome");
        String filtroProprietaValore = SearchUtils.getFilter(ricerca, idLista, "filtroPropValore");
        if (filtroProprietaNome != null && "".equals(filtroProprietaNome)) {
            filtroProprietaNome = null;
        }
        if (filtroProprietaValore != null && "".equals(filtroProprietaValore)) {
            filtroProprietaValore = null;
        }
        boolean filtroProprieta = filtroProprietaNome != null || filtroProprietaValore != null;
        this.driver.logDebug("search : " + searchAPIErogazioneFruizione);
        this.driver.logDebug("filterSoggettoErogatoreContains : " + filterSoggettoErogatoreContains);
        this.driver.logDebug("filterProtocollo : " + filterProtocollo);
        this.driver.logDebug("filterProtocolli : " + filterProtocolli);
        this.driver.logDebug("filterTipoAPI : " + filterTipoAPI);
        this.driver.logDebug("filterGruppo : " + filterGruppo);
        this.driver.logDebug("filterApi : " + filterApi);
        this.driver.logDebug("filterCanale : " + filterCanale);
        this.driver.logDebug("filterDominio : " + filterDominio);
        this.driver.logDebug("filterStatoAccordo : " + filterStatoAccordo);
        this.driver.logDebug("filterSoggettoNome : " + filterSoggettoNome);
        this.driver.logDebug("filterSoggettoTipo : " + filterSoggettoTipo);
        this.driver.logDebug("filtroStatoAPIImpl : " + filtroStatoAPIImpl);
        this.driver.logDebug("filtroAutenticazioneTokenPolicy : " + filtroAutenticazioneTokenPolicy);
        this.driver.logDebug("filtroAutenticazioneTrasporto : " + filtroAutenticazioneTrasporto);
        this.driver.logDebug("filtroRateLimitingStato : " + filtroRateLimitingStato);
        this.driver.logDebug("filtroValidazioneStato : " + filtroValidazioneStato);
        this.driver.logDebug("filtroCacheRispostaStato : " + filtroCacheRispostaStato);
        this.driver.logDebug("filtroMessageSecurityStato : " + filtroMessageSecurityStato);
        this.driver.logDebug("filtroMTOMStato : " + filtroMTOMStato);
        this.driver.logDebug("filtroTrasformazione : " + filtroTrasformazione);
        this.driver.logDebug("filtroConfigurazioneTransazioni : " + filtroConfigurazioneTransazioni);
        this.driver.logDebug("filtroCorrelazioneApplicativa : " + filtroCorrelazioneApplicativa);
        this.driver.logDebug("filtroConfigurazioneDumpTipo : " + filtroConfigurazioneDumpTipo);
        this.driver.logDebug("filtroCORS : " + filtroCORS);
        this.driver.logDebug("filtroCORS_origin : " + filtroCORSorigin);
        this.driver.logDebug("filtroConnettoreTipo : " + filtroConnettoreTipo);
        this.driver.logDebug("filtroConnettoreTipoPlugin : " + filtroConnettoreTipoPlugin);
        this.driver.logDebug("filtroConnettoreTokenPolicy : " + filtroConnettoreTokenPolicy);
        this.driver.logDebug("filtroConnettoreEndpoint : " + filtroConnettoreEndpoint);
        this.driver.logDebug("filtroConnettoreKeystore : " + filtroConnettoreKeystore);
        this.driver.logDebug("filtroConnettoreDebug : " + filtroConnettoreDebug);
        this.driver.logDebug("filtroConnettoreTipoPlugin : " + filtroConnettoreTipoPlugin);
        this.driver.logDebug("filtroModISicurezzaCanale : " + filtroModISicurezzaCanale);
        this.driver.logDebug("filtroModISicurezzaMessaggio : " + filtroModISicurezzaMessaggio);
        this.driver.logDebug("filtroModISorgenteToken : " + filtroModISorgenteToken);
        this.driver.logDebug("filtroModIKeystorePath : " + filtroModIKeystorePath);
        this.driver.logDebug("filtroModIAudience : " + filtroModIAudience);
        this.driver.logDebug("filtroModIInfoUtente : " + filtroModIInfoUtente);
        this.driver.logDebug("filtroModIDigestRichiesta : " + filtroModIDigestRichiesta);
        this.driver.logDebug("filtroProprietaNome : " + filtroProprietaNome);
        this.driver.logDebug("filtroProprietaValore : " + filtroProprietaValore);
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("soggettiServizioList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String tabellaPorta;
            ISQLQueryObject sqlQueryObject;
            String queryString;
            String tabellaPorta2;
            ISQLQueryObject sqlQueryObject2;
            ISQLQueryObject sqlQueryObjectAccordiComposti = null;
            if (permessiUtente != null) {
                sqlQueryObjectAccordiComposti = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectAccordiComposti.addFromTable("acc_serv_composti");
                sqlQueryObjectAccordiComposti.addSelectField("acc_serv_composti", "id");
                sqlQueryObjectAccordiComposti.setANDLogicOperator(true);
                sqlQueryObjectAccordiComposti.addWhereCondition("acc_serv_composti.id_accordo=accordi.id");
            }
            ISQLQueryObject sqlQueryObjectSoggettiErogatoreContains = null;
            if (!filterSoggettoErogatoreContains.equals("")) {
                sqlQueryObjectSoggettiErogatoreContains = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectSoggettiErogatoreContains.addFromTable("soggetti");
                sqlQueryObjectSoggettiErogatoreContains.addSelectField("soggetti", "tipo_soggetto");
                sqlQueryObjectSoggettiErogatoreContains.addSelectField("soggetti", "nome_soggetto");
                sqlQueryObjectSoggettiErogatoreContains.setANDLogicOperator(true);
                sqlQueryObjectSoggettiErogatoreContains.addWhereCondition("servizi.id_soggetto=soggetti.id");
                sqlQueryObjectSoggettiErogatoreContains.addWhereCondition(false, new String[]{sqlQueryObjectSoggettiErogatoreContains.getWhereLikeCondition("nome_soggetto", filterSoggettoErogatoreContains, true, true)});
            }
            ISQLQueryObject sqlQueryObjectPdd = null;
            if (pddTipologia != null && PddTipologia.ESTERNO.equals((Object)pddTipologia)) {
                ISQLQueryObject sqlQueryObjectExistsPdd = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectExistsPdd.addSelectField("pdd.nome");
                sqlQueryObjectExistsPdd.addFromTable("pdd");
                sqlQueryObjectExistsPdd.setANDLogicOperator(true);
                sqlQueryObjectExistsPdd.addWhereCondition("pdd.nome=soggetti.server");
                sqlQueryObjectExistsPdd.addWhereCondition("pdd.tipo=?");
                sqlQueryObjectPdd = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectPdd.setANDLogicOperator(false);
                sqlQueryObjectPdd.addWhereIsNullCondition("soggetti.server");
                sqlQueryObjectPdd.addWhereExistsCondition(false, sqlQueryObjectExistsPdd);
            }
            if (!searchAPIErogazioneFruizione.equals("")) {
                sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject2.addFromTable("servizi");
                sqlQueryObject2.addFromTable("soggetti");
                if (permessiUtente != null || filterTipoAPI != null || filterGruppo != null || idAccordoApi != null || searchCanale || filtroModI || !searchAPIErogazioneFruizione.equals("")) {
                    sqlQueryObject2.addFromTable("accordi");
                    sqlQueryObject2.addWhereCondition("servizi.id_accordo=accordi.id");
                    if (filterGruppo != null) {
                        sqlQueryObject2.addFromTable("accordi_gruppi");
                        sqlQueryObject2.addFromTable("gruppi");
                        sqlQueryObject2.addWhereCondition("accordi_gruppi.id_accordo=accordi.id");
                        sqlQueryObject2.addWhereCondition("accordi_gruppi.id_gruppo=gruppi.id");
                    }
                    if (idAccordoApi != null) {
                        sqlQueryObject2.addFromTable("soggetti", aliasSoggettiReferenti);
                        sqlQueryObject2.addWhereCondition("accordi.id_referente=" + aliasSoggettiReferenti + ".id");
                    }
                }
                if (gestioneFruitori) {
                    sqlQueryObject2.addFromTable("mapping_fruizione_pd");
                    sqlQueryObject2.addFromTable("servizi_fruitori");
                    sqlQueryObject2.addFromTable("soggetti", aliasSoggettiFruitori);
                    if (searchCanale) {
                        sqlQueryObject2.addFromTable("porte_delegate");
                    }
                    sqlQueryObject2.addWhereCondition("mapping_fruizione_pd.id_fruizione=servizi_fruitori.id");
                    sqlQueryObject2.addWhereCondition("mapping_fruizione_pd.is_default=1");
                    if (searchCanale) {
                        sqlQueryObject2.addWhereCondition("mapping_fruizione_pd.id_porta=porte_delegate.id");
                    }
                    sqlQueryObject2.addWhereCondition("servizi_fruitori.id_servizio=servizi.id");
                    sqlQueryObject2.addWhereCondition("servizi_fruitori.id_soggetto=" + aliasSoggettiFruitori + ".id");
                    if (joinConnettore) {
                        DBUtils.setFiltriConnettoreFruizione(sqlQueryObject2, this.driver.tipoDB, tipoConnettore, endpointType, tipoConnettoreIntegrationManager, filtroConnettoreTokenPolicy, filtroConnettoreEndpoint, filtroConnettoreKeystore, filtroConnettoreDebug);
                    }
                    if (filtroModI) {
                        DBUtils.setFiltriModIFruizione(sqlQueryObject2, this.driver.tipoDB, filtroModISicurezzaCanale, filtroModISicurezzaMessaggio, filtroModISorgenteToken, filtroModIDigestRichiestaEnabled, filtroModIInfoUtente, filtroModIKeystorePath, filtroModIAudience);
                    }
                    if (filtroProprieta) {
                        DBUtils.setFiltriProprietaFruizione(sqlQueryObject2, this.driver.tipoDB, filtroProprietaNome, filtroProprietaValore);
                    }
                    if (filtroStatoAPIImpl != null || filtroAutenticazioneTokenPolicy != null || filtroAutenticazioneTrasporto != null || filtroRateLimitingStato != null || filtroValidazioneStato != null || filtroCacheRispostaStato != null || filtroMessageSecurityStato != null || filtroMTOMStato != null || filtroTrasformazione != null || filtroConfigurazioneTransazioni != null || filtroCorrelazioneApplicativa != null || filtroConfigurazioneDumpTipo != null || filtroCORS != null) {
                        DBUtils.setFiltriConfigurazioneFruizione(sqlQueryObject2, this.driver.tipoDB, filtroStatoAPIImpl, filtroAutenticazioneTokenPolicy, filtroAutenticazioneTrasporto, filtroRateLimitingStato, filtroValidazioneStato, filtroCacheRispostaStato, filtroMessageSecurityStato, filtroMTOMStato, filtroTrasformazione, filtroConfigurazioneTransazioni, filtroCorrelazioneApplicativa, filtroConfigurazioneDumpTipo, filtroCORS, filtroCORSorigin);
                    }
                }
                if (gestioneErogatori) {
                    sqlQueryObject2.addFromTable("mapping_erogazione_pa");
                    if (searchCanale) {
                        sqlQueryObject2.addFromTable("porte_applicative");
                    }
                    sqlQueryObject2.addWhereCondition("mapping_erogazione_pa.id_erogazione=servizi.id");
                    sqlQueryObject2.addWhereCondition("mapping_erogazione_pa.is_default=1");
                    if (searchCanale) {
                        sqlQueryObject2.addWhereCondition("mapping_erogazione_pa.id_porta=porte_applicative.id");
                    }
                    if (joinConnettore) {
                        DBUtils.setFiltriConnettoreErogazione(sqlQueryObject2, this.driver.tipoDB, tipoConnettore, endpointType, tipoConnettoreIntegrationManager, filtroConnettoreTokenPolicy, filtroConnettoreEndpoint, filtroConnettoreKeystore, filtroConnettoreDebug);
                    }
                    if (filtroModI) {
                        DBUtils.setFiltriModIErogazione(sqlQueryObject2, this.driver.tipoDB, filtroModISicurezzaCanale, filtroModISicurezzaMessaggio, filtroModISorgenteToken, filtroModIDigestRichiestaEnabled, filtroModIInfoUtente, filtroModIKeystorePath, filtroModIAudience);
                    }
                    if (filtroProprieta) {
                        DBUtils.setFiltriProprietaErogazione(sqlQueryObject2, this.driver.tipoDB, filtroProprietaNome, filtroProprietaValore);
                    }
                    if (filtroStatoAPIImpl != null || filtroAutenticazioneTokenPolicy != null || filtroAutenticazioneTrasporto != null || filtroRateLimitingStato != null || filtroValidazioneStato != null || filtroCacheRispostaStato != null || filtroMessageSecurityStato != null || filtroMTOMStato != null || filtroTrasformazione != null || filtroConfigurazioneTransazioni != null || filtroCorrelazioneApplicativa != null || filtroConfigurazioneDumpTipo != null || filtroCORS != null) {
                        DBUtils.setFiltriConfigurazioneErogazione(sqlQueryObject2, this.driver.tipoDB, filtroStatoAPIImpl, filtroAutenticazioneTokenPolicy, filtroAutenticazioneTrasporto, filtroRateLimitingStato, filtroValidazioneStato, filtroCacheRispostaStato, filtroMessageSecurityStato, filtroMTOMStato, filtroTrasformazione, filtroConfigurazioneTransazioni, filtroCorrelazioneApplicativa, filtroConfigurazioneDumpTipo, filtroCORS, filtroCORSorigin);
                    }
                }
                sqlQueryObject2.addSelectCountField("*", "cont");
                sqlQueryObject2.addWhereCondition("servizi.id_soggetto = soggetti.id");
                if (filterSoggettoNome != null && !"".equals(filterSoggettoNome)) {
                    if (gestioneFruitori) {
                        sqlQueryObject2.addWhereCondition(aliasSoggettiFruitori + ".tipo_soggetto=?");
                        sqlQueryObject2.addWhereCondition(aliasSoggettiFruitori + ".nome_soggetto=?");
                    } else {
                        sqlQueryObject2.addWhereCondition("soggetti.tipo_soggetto=?");
                        sqlQueryObject2.addWhereCondition("soggetti.nome_soggetto=?");
                    }
                }
                if (this.driver.useSuperUser && superuser != null && !"".equals(superuser)) {
                    sqlQueryObject2.addWhereCondition("soggetti.superuser = ?");
                }
                if (tipoServiziProtocollo != null && tipoServiziProtocollo.size() > 0) {
                    sqlQueryObject2.addWhereINCondition("servizi.tipo_servizio", true, tipoServiziProtocollo.toArray(new String[1]));
                }
                if (filterTipoAPI != null && !filterTipoAPI.equals("")) {
                    sqlQueryObject2.addWhereCondition("accordi.service_binding = ?");
                }
                if (filterGruppo != null && !filterGruppo.equals("")) {
                    sqlQueryObject2.addWhereCondition("gruppi.nome = ?");
                }
                if (idAccordoApi != null) {
                    sqlQueryObject2.addWhereCondition("accordi.nome = ?");
                    sqlQueryObject2.addWhereCondition("accordi.versione = ?");
                    sqlQueryObject2.addWhereCondition(aliasSoggettiReferenti + ".tipo_soggetto = ?");
                    sqlQueryObject2.addWhereCondition(aliasSoggettiReferenti + ".nome_soggetto = ?");
                }
                if (pddTipologia != null) {
                    if (PddTipologia.ESTERNO.equals((Object)pddTipologia)) {
                        sqlQueryObject2.addWhereCondition(sqlQueryObjectPdd.createSQLConditions());
                    } else {
                        sqlQueryObject2.addFromTable("pdd");
                        sqlQueryObject2.addWhereCondition(true, new String[]{"pdd.nome=soggetti.server", "pdd.tipo=?"});
                    }
                }
                if (filterStatoAccordo != null && !filterStatoAccordo.equals("")) {
                    sqlQueryObject2.addWhereCondition("servizi.stato = ?");
                }
                if (sqlQueryObjectSoggettiErogatoreContains != null) {
                    sqlQueryObject2.addWhereExistsCondition(false, sqlQueryObjectSoggettiErogatoreContains);
                }
                sqlQueryObject2.addWhereCondition(false, new String[]{sqlQueryObject2.getWhereLikeCondition("nome_servizio", searchAPIErogazioneFruizione, true, true), sqlQueryObject2.getWhereLikeCondition("accordi.nome", searchAPIErogazioneFruizione, true, true)});
                if (permessiUtente != null) {
                    if (permessiUtente[0] && !permessiUtente[1]) {
                        sqlQueryObject2.addWhereExistsCondition(true, sqlQueryObjectAccordiComposti);
                    }
                    if (!permessiUtente[0] && permessiUtente[1]) {
                        sqlQueryObject2.addWhereExistsCondition(false, sqlQueryObjectAccordiComposti);
                    }
                }
                if (searchCanale) {
                    String string = tabellaPorta2 = gestioneErogatori ? "porte_applicative" : "porte_delegate";
                    if (canaleDefault) {
                        sqlQueryObject2.addWhereCondition(false, new String[]{tabellaPorta2 + ".canale = ?", "( " + tabellaPorta2 + ".canale is null AND (accordi.canale = ?  OR accordi.canale is null) )"});
                    } else {
                        sqlQueryObject2.addWhereCondition(false, new String[]{tabellaPorta2 + ".canale = ?", "( " + tabellaPorta2 + ".canale is null AND accordi.canale = ? )"});
                    }
                }
                sqlQueryObject2.setANDLogicOperator(true);
                queryString = sqlQueryObject2.createSQLQuery();
            } else {
                sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject2.addFromTable("servizi");
                sqlQueryObject2.addFromTable("soggetti");
                if (permessiUtente != null || filterTipoAPI != null || filterGruppo != null || idAccordoApi != null || searchCanale || filtroModI) {
                    sqlQueryObject2.addFromTable("accordi");
                    sqlQueryObject2.addWhereCondition("servizi.id_accordo=accordi.id");
                    if (filterGruppo != null) {
                        sqlQueryObject2.addFromTable("accordi_gruppi");
                        sqlQueryObject2.addFromTable("gruppi");
                        sqlQueryObject2.addWhereCondition("accordi_gruppi.id_accordo=accordi.id");
                        sqlQueryObject2.addWhereCondition("accordi_gruppi.id_gruppo=gruppi.id");
                    }
                    if (idAccordoApi != null) {
                        sqlQueryObject2.addFromTable("soggetti", aliasSoggettiReferenti);
                        sqlQueryObject2.addWhereCondition("accordi.id_referente=" + aliasSoggettiReferenti + ".id");
                    }
                }
                if (gestioneFruitori) {
                    sqlQueryObject2.addFromTable("mapping_fruizione_pd");
                    sqlQueryObject2.addFromTable("servizi_fruitori");
                    sqlQueryObject2.addFromTable("soggetti", aliasSoggettiFruitori);
                    if (searchCanale) {
                        sqlQueryObject2.addFromTable("porte_delegate");
                    }
                    sqlQueryObject2.addWhereCondition("mapping_fruizione_pd.id_fruizione=servizi_fruitori.id");
                    sqlQueryObject2.addWhereCondition("mapping_fruizione_pd.is_default=1");
                    if (searchCanale) {
                        sqlQueryObject2.addWhereCondition("mapping_fruizione_pd.id_porta=porte_delegate.id");
                    }
                    sqlQueryObject2.addWhereCondition("servizi_fruitori.id_servizio=servizi.id");
                    sqlQueryObject2.addWhereCondition("servizi_fruitori.id_soggetto=" + aliasSoggettiFruitori + ".id");
                    if (joinConnettore) {
                        DBUtils.setFiltriConnettoreFruizione(sqlQueryObject2, this.driver.tipoDB, tipoConnettore, endpointType, tipoConnettoreIntegrationManager, filtroConnettoreTokenPolicy, filtroConnettoreEndpoint, filtroConnettoreKeystore, filtroConnettoreDebug);
                    }
                    if (filtroModI) {
                        DBUtils.setFiltriModIFruizione(sqlQueryObject2, this.driver.tipoDB, filtroModISicurezzaCanale, filtroModISicurezzaMessaggio, filtroModISorgenteToken, filtroModIDigestRichiestaEnabled, filtroModIInfoUtente, filtroModIKeystorePath, filtroModIAudience);
                    }
                    if (filtroProprieta) {
                        DBUtils.setFiltriProprietaFruizione(sqlQueryObject2, this.driver.tipoDB, filtroProprietaNome, filtroProprietaValore);
                    }
                    if (filtroStatoAPIImpl != null || filtroAutenticazioneTokenPolicy != null || filtroAutenticazioneTrasporto != null || filtroRateLimitingStato != null || filtroValidazioneStato != null || filtroCacheRispostaStato != null || filtroMessageSecurityStato != null || filtroMTOMStato != null || filtroTrasformazione != null || filtroConfigurazioneTransazioni != null || filtroCorrelazioneApplicativa != null || filtroConfigurazioneDumpTipo != null || filtroCORS != null) {
                        DBUtils.setFiltriConfigurazioneFruizione(sqlQueryObject2, this.driver.tipoDB, filtroStatoAPIImpl, filtroAutenticazioneTokenPolicy, filtroAutenticazioneTrasporto, filtroRateLimitingStato, filtroValidazioneStato, filtroCacheRispostaStato, filtroMessageSecurityStato, filtroMTOMStato, filtroTrasformazione, filtroConfigurazioneTransazioni, filtroCorrelazioneApplicativa, filtroConfigurazioneDumpTipo, filtroCORS, filtroCORSorigin);
                    }
                }
                if (gestioneErogatori) {
                    sqlQueryObject2.addFromTable("mapping_erogazione_pa");
                    if (searchCanale) {
                        sqlQueryObject2.addFromTable("porte_applicative");
                    }
                    sqlQueryObject2.addWhereCondition("mapping_erogazione_pa.id_erogazione=servizi.id");
                    sqlQueryObject2.addWhereCondition("mapping_erogazione_pa.is_default=1");
                    if (searchCanale) {
                        sqlQueryObject2.addWhereCondition("mapping_erogazione_pa.id_porta=porte_applicative.id");
                    }
                    if (joinConnettore) {
                        DBUtils.setFiltriConnettoreErogazione(sqlQueryObject2, this.driver.tipoDB, tipoConnettore, endpointType, tipoConnettoreIntegrationManager, filtroConnettoreTokenPolicy, filtroConnettoreEndpoint, filtroConnettoreKeystore, filtroConnettoreDebug);
                    }
                    if (filtroModI) {
                        DBUtils.setFiltriModIErogazione(sqlQueryObject2, this.driver.tipoDB, filtroModISicurezzaCanale, filtroModISicurezzaMessaggio, filtroModISorgenteToken, filtroModIDigestRichiestaEnabled, filtroModIInfoUtente, filtroModIKeystorePath, filtroModIAudience);
                    }
                    if (filtroProprieta) {
                        DBUtils.setFiltriProprietaErogazione(sqlQueryObject2, this.driver.tipoDB, filtroProprietaNome, filtroProprietaValore);
                    }
                    if (filtroStatoAPIImpl != null || filtroAutenticazioneTokenPolicy != null || filtroAutenticazioneTrasporto != null || filtroRateLimitingStato != null || filtroValidazioneStato != null || filtroCacheRispostaStato != null || filtroMessageSecurityStato != null || filtroMTOMStato != null || filtroTrasformazione != null || filtroConfigurazioneTransazioni != null || filtroCorrelazioneApplicativa != null || filtroConfigurazioneDumpTipo != null || filtroCORS != null) {
                        DBUtils.setFiltriConfigurazioneErogazione(sqlQueryObject2, this.driver.tipoDB, filtroStatoAPIImpl, filtroAutenticazioneTokenPolicy, filtroAutenticazioneTrasporto, filtroRateLimitingStato, filtroValidazioneStato, filtroCacheRispostaStato, filtroMessageSecurityStato, filtroMTOMStato, filtroTrasformazione, filtroConfigurazioneTransazioni, filtroCorrelazioneApplicativa, filtroConfigurazioneDumpTipo, filtroCORS, filtroCORSorigin);
                    }
                }
                sqlQueryObject2.addSelectCountField("*", "cont");
                sqlQueryObject2.addWhereCondition("servizi.id_soggetto = soggetti.id");
                if (filterSoggettoNome != null && !"".equals(filterSoggettoNome)) {
                    if (gestioneFruitori) {
                        sqlQueryObject2.addWhereCondition(aliasSoggettiFruitori + ".tipo_soggetto=?");
                        sqlQueryObject2.addWhereCondition(aliasSoggettiFruitori + ".nome_soggetto=?");
                    } else {
                        sqlQueryObject2.addWhereCondition("soggetti.tipo_soggetto=?");
                        sqlQueryObject2.addWhereCondition("soggetti.nome_soggetto=?");
                    }
                }
                if (this.driver.useSuperUser && superuser != null && !"".equals(superuser)) {
                    sqlQueryObject2.addWhereCondition("soggetti.superuser = ?");
                }
                if (tipoServiziProtocollo != null && tipoServiziProtocollo.size() > 0) {
                    sqlQueryObject2.addWhereINCondition("servizi.tipo_servizio", true, tipoServiziProtocollo.toArray(new String[1]));
                }
                if (filterTipoAPI != null && !filterTipoAPI.equals("")) {
                    sqlQueryObject2.addWhereCondition("accordi.service_binding = ?");
                }
                if (filterGruppo != null && !filterGruppo.equals("")) {
                    sqlQueryObject2.addWhereCondition("gruppi.nome = ?");
                }
                if (idAccordoApi != null) {
                    sqlQueryObject2.addWhereCondition("accordi.nome = ?");
                    sqlQueryObject2.addWhereCondition("accordi.versione = ?");
                    sqlQueryObject2.addWhereCondition(aliasSoggettiReferenti + ".tipo_soggetto = ?");
                    sqlQueryObject2.addWhereCondition(aliasSoggettiReferenti + ".nome_soggetto = ?");
                }
                if (pddTipologia != null) {
                    if (PddTipologia.ESTERNO.equals((Object)pddTipologia)) {
                        sqlQueryObject2.addWhereCondition(sqlQueryObjectPdd.createSQLConditions());
                    } else {
                        sqlQueryObject2.addFromTable("pdd");
                        sqlQueryObject2.addWhereCondition(true, new String[]{"pdd.nome=soggetti.server", "pdd.tipo=?"});
                    }
                }
                if (filterStatoAccordo != null && !filterStatoAccordo.equals("")) {
                    sqlQueryObject2.addWhereCondition("servizi.stato = ?");
                }
                if (sqlQueryObjectSoggettiErogatoreContains != null) {
                    sqlQueryObject2.addWhereExistsCondition(false, sqlQueryObjectSoggettiErogatoreContains);
                }
                if (permessiUtente != null) {
                    if (permessiUtente[0] && !permessiUtente[1]) {
                        sqlQueryObject2.addWhereExistsCondition(true, sqlQueryObjectAccordiComposti);
                    }
                    if (!permessiUtente[0] && permessiUtente[1]) {
                        sqlQueryObject2.addWhereExistsCondition(false, sqlQueryObjectAccordiComposti);
                    }
                }
                if (searchCanale) {
                    String string = tabellaPorta2 = gestioneErogatori ? "porte_applicative" : "porte_delegate";
                    if (canaleDefault) {
                        sqlQueryObject2.addWhereCondition(false, new String[]{tabellaPorta2 + ".canale = ?", "( " + tabellaPorta2 + ".canale is null AND (accordi.canale = ?  OR accordi.canale is null) )"});
                    } else {
                        sqlQueryObject2.addWhereCondition(false, new String[]{tabellaPorta2 + ".canale = ?", "( " + tabellaPorta2 + ".canale is null AND accordi.canale = ? )"});
                    }
                }
                sqlQueryObject2.setANDLogicOperator(true);
                queryString = sqlQueryObject2.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            int index = 1;
            if (filterSoggettoNome != null && !"".equals(filterSoggettoNome)) {
                stmt.setString(index++, filterSoggettoTipo);
                stmt.setString(index++, filterSoggettoNome);
            }
            if (this.driver.useSuperUser && superuser != null && !"".equals(superuser)) {
                stmt.setString(index++, superuser);
            }
            if (filterTipoAPI != null && !filterTipoAPI.equals("")) {
                stmt.setString(index++, filterTipoAPI);
            }
            if (filterGruppo != null && !filterGruppo.equals("")) {
                stmt.setString(index++, filterGruppo);
            }
            if (idAccordoApi != null) {
                stmt.setString(index++, idAccordoApi.getNome());
                stmt.setInt(index++, idAccordoApi.getVersione());
                stmt.setString(index++, idAccordoApi.getSoggettoReferente().getTipo());
                stmt.setString(index++, idAccordoApi.getSoggettoReferente().getNome());
            }
            if (pddTipologia != null) {
                stmt.setString(index++, pddTipologia.toString());
            }
            if (filterStatoAccordo != null && !filterStatoAccordo.equals("")) {
                stmt.setString(index++, filterStatoAccordo);
            }
            if (searchCanale) {
                stmt.setString(index++, filterCanale);
                stmt.setString(index++, filterCanale);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!searchAPIErogazioneFruizione.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addFromTable("soggetti");
                if (permessiUtente != null || filterTipoAPI != null || filterGruppo != null || idAccordoApi != null || searchCanale || filtroModI || !searchAPIErogazioneFruizione.equals("")) {
                    sqlQueryObject.addFromTable("accordi");
                    sqlQueryObject.addWhereCondition("servizi.id_accordo=accordi.id");
                    if (filterGruppo != null) {
                        sqlQueryObject.addFromTable("accordi_gruppi");
                        sqlQueryObject.addFromTable("gruppi");
                        sqlQueryObject.addWhereCondition("accordi_gruppi.id_accordo=accordi.id");
                        sqlQueryObject.addWhereCondition("accordi_gruppi.id_gruppo=gruppi.id");
                    }
                    if (idAccordoApi != null) {
                        sqlQueryObject.addFromTable("soggetti", aliasSoggettiReferenti);
                        sqlQueryObject.addWhereCondition("accordi.id_referente=" + aliasSoggettiReferenti + ".id");
                    }
                }
                if (gestioneFruitori) {
                    sqlQueryObject.addFromTable("mapping_fruizione_pd");
                    sqlQueryObject.addFromTable("servizi_fruitori");
                    sqlQueryObject.addFromTable("soggetti", aliasSoggettiFruitori);
                    if (searchCanale) {
                        sqlQueryObject.addFromTable("porte_delegate");
                    }
                    sqlQueryObject.addWhereCondition("mapping_fruizione_pd.id_fruizione=servizi_fruitori.id");
                    sqlQueryObject.addWhereCondition("mapping_fruizione_pd.is_default=1");
                    if (searchCanale) {
                        sqlQueryObject.addWhereCondition("mapping_fruizione_pd.id_porta=porte_delegate.id");
                    }
                    sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio=servizi.id");
                    sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto=" + aliasSoggettiFruitori + ".id");
                    if (joinConnettore) {
                        DBUtils.setFiltriConnettoreFruizione(sqlQueryObject, this.driver.tipoDB, tipoConnettore, endpointType, tipoConnettoreIntegrationManager, filtroConnettoreTokenPolicy, filtroConnettoreEndpoint, filtroConnettoreKeystore, filtroConnettoreDebug);
                    }
                    if (filtroModI) {
                        DBUtils.setFiltriModIFruizione(sqlQueryObject, this.driver.tipoDB, filtroModISicurezzaCanale, filtroModISicurezzaMessaggio, filtroModISorgenteToken, filtroModIDigestRichiestaEnabled, filtroModIInfoUtente, filtroModIKeystorePath, filtroModIAudience);
                    }
                    if (filtroProprieta) {
                        DBUtils.setFiltriProprietaFruizione(sqlQueryObject, this.driver.tipoDB, filtroProprietaNome, filtroProprietaValore);
                    }
                    if (filtroStatoAPIImpl != null || filtroAutenticazioneTokenPolicy != null || filtroAutenticazioneTrasporto != null || filtroRateLimitingStato != null || filtroValidazioneStato != null || filtroCacheRispostaStato != null || filtroMessageSecurityStato != null || filtroMTOMStato != null || filtroTrasformazione != null || filtroConfigurazioneTransazioni != null || filtroCorrelazioneApplicativa != null || filtroConfigurazioneDumpTipo != null || filtroCORS != null) {
                        DBUtils.setFiltriConfigurazioneFruizione(sqlQueryObject, this.driver.tipoDB, filtroStatoAPIImpl, filtroAutenticazioneTokenPolicy, filtroAutenticazioneTrasporto, filtroRateLimitingStato, filtroValidazioneStato, filtroCacheRispostaStato, filtroMessageSecurityStato, filtroMTOMStato, filtroTrasformazione, filtroConfigurazioneTransazioni, filtroCorrelazioneApplicativa, filtroConfigurazioneDumpTipo, filtroCORS, filtroCORSorigin);
                    }
                }
                if (gestioneErogatori) {
                    sqlQueryObject.addFromTable("mapping_erogazione_pa");
                    if (searchCanale) {
                        sqlQueryObject.addFromTable("porte_applicative");
                    }
                    sqlQueryObject.addWhereCondition("mapping_erogazione_pa.id_erogazione=servizi.id");
                    sqlQueryObject.addWhereCondition("mapping_erogazione_pa.is_default=1");
                    if (searchCanale) {
                        sqlQueryObject.addWhereCondition("mapping_erogazione_pa.id_porta=porte_applicative.id");
                    }
                    if (joinConnettore) {
                        DBUtils.setFiltriConnettoreErogazione(sqlQueryObject, this.driver.tipoDB, tipoConnettore, endpointType, tipoConnettoreIntegrationManager, filtroConnettoreTokenPolicy, filtroConnettoreEndpoint, filtroConnettoreKeystore, filtroConnettoreDebug);
                    }
                    if (filtroModI) {
                        DBUtils.setFiltriModIErogazione(sqlQueryObject, this.driver.tipoDB, filtroModISicurezzaCanale, filtroModISicurezzaMessaggio, filtroModISorgenteToken, filtroModIDigestRichiestaEnabled, filtroModIInfoUtente, filtroModIKeystorePath, filtroModIAudience);
                    }
                    if (filtroProprieta) {
                        DBUtils.setFiltriProprietaErogazione(sqlQueryObject, this.driver.tipoDB, filtroProprietaNome, filtroProprietaValore);
                    }
                    if (filtroStatoAPIImpl != null || filtroAutenticazioneTokenPolicy != null || filtroAutenticazioneTrasporto != null || filtroRateLimitingStato != null || filtroValidazioneStato != null || filtroCacheRispostaStato != null || filtroMessageSecurityStato != null || filtroMTOMStato != null || filtroTrasformazione != null || filtroConfigurazioneTransazioni != null || filtroCorrelazioneApplicativa != null || filtroConfigurazioneDumpTipo != null || filtroCORS != null) {
                        DBUtils.setFiltriConfigurazioneErogazione(sqlQueryObject, this.driver.tipoDB, filtroStatoAPIImpl, filtroAutenticazioneTokenPolicy, filtroAutenticazioneTrasporto, filtroRateLimitingStato, filtroValidazioneStato, filtroCacheRispostaStato, filtroMessageSecurityStato, filtroMTOMStato, filtroTrasformazione, filtroConfigurazioneTransazioni, filtroCorrelazioneApplicativa, filtroConfigurazioneDumpTipo, filtroCORS, filtroCORSorigin);
                    }
                }
                sqlQueryObject.addSelectField("servizi.id");
                sqlQueryObject.addSelectAliasField("servizi.nome_servizio", "nomeServizio");
                sqlQueryObject.addSelectAliasField("servizi.tipo_servizio", "tipoServizio");
                sqlQueryObject.addSelectAliasField("servizi.versione_servizio", "versioneServizio");
                sqlQueryObject.addSelectAliasField("servizi.id_soggetto", "idSoggettoErogatore");
                sqlQueryObject.addSelectField("servizi.id_accordo");
                sqlQueryObject.addSelectField("servizio_correlato");
                sqlQueryObject.addSelectAliasField("servizi.stato", "statoServizio");
                sqlQueryObject.addSelectAliasField("servizi", "descrizione", "descrizioneServizio");
                sqlQueryObject.addSelectAliasField("soggetti.nome_soggetto", "nomeSoggettoErogatore");
                sqlQueryObject.addSelectAliasField("soggetti.tipo_soggetto", "tipoSoggettoErogatore");
                sqlQueryObject.addSelectField("port_type");
                if (gestioneFruitori) {
                    sqlQueryObject.addSelectAliasField("servizi_fruitori.id", "idFruizione");
                    sqlQueryObject.addSelectAliasField(aliasSoggettiFruitori + ".id", "idSoggettoFruitore");
                    sqlQueryObject.addSelectAliasField(aliasSoggettiFruitori + ".nome_soggetto", "nomeSoggettoFruitore");
                    sqlQueryObject.addSelectAliasField(aliasSoggettiFruitori + ".tipo_soggetto", "tipoSoggettoFruitore");
                }
                sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
                if (filterSoggettoNome != null && !"".equals(filterSoggettoNome)) {
                    if (gestioneFruitori) {
                        sqlQueryObject.addWhereCondition(aliasSoggettiFruitori + ".tipo_soggetto=?");
                        sqlQueryObject.addWhereCondition(aliasSoggettiFruitori + ".nome_soggetto=?");
                    } else {
                        sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto=?");
                        sqlQueryObject.addWhereCondition("soggetti.nome_soggetto=?");
                    }
                }
                if (this.driver.useSuperUser && superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                if (tipoServiziProtocollo != null && tipoServiziProtocollo.size() > 0) {
                    sqlQueryObject.addWhereINCondition("servizi.tipo_servizio", true, tipoServiziProtocollo.toArray(new String[1]));
                }
                if (filterTipoAPI != null && !filterTipoAPI.equals("")) {
                    sqlQueryObject.addWhereCondition("accordi.service_binding = ?");
                }
                if (filterGruppo != null && !filterGruppo.equals("")) {
                    sqlQueryObject.addWhereCondition("gruppi.nome = ?");
                }
                if (idAccordoApi != null) {
                    sqlQueryObject.addWhereCondition("accordi.nome = ?");
                    sqlQueryObject.addWhereCondition("accordi.versione = ?");
                    sqlQueryObject.addWhereCondition(aliasSoggettiReferenti + ".tipo_soggetto = ?");
                    sqlQueryObject.addWhereCondition(aliasSoggettiReferenti + ".nome_soggetto = ?");
                }
                if (pddTipologia != null) {
                    if (PddTipologia.ESTERNO.equals((Object)pddTipologia)) {
                        sqlQueryObject.addWhereCondition(sqlQueryObjectPdd.createSQLConditions());
                    } else {
                        sqlQueryObject.addFromTable("pdd");
                        sqlQueryObject.addWhereCondition(true, new String[]{"pdd.nome=soggetti.server", "pdd.tipo=?"});
                    }
                }
                if (filterStatoAccordo != null && !filterStatoAccordo.equals("")) {
                    sqlQueryObject.addWhereCondition("servizi.stato = ?");
                }
                if (sqlQueryObjectSoggettiErogatoreContains != null) {
                    sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectSoggettiErogatoreContains);
                }
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("nome_servizio", searchAPIErogazioneFruizione, true, true), sqlQueryObject.getWhereLikeCondition("accordi.nome", searchAPIErogazioneFruizione, true, true)});
                if (permessiUtente != null) {
                    if (permessiUtente[0] && !permessiUtente[1]) {
                        sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectAccordiComposti);
                    }
                    if (!permessiUtente[0] && permessiUtente[1]) {
                        sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectAccordiComposti);
                    }
                }
                if (searchCanale) {
                    String string = tabellaPorta = gestioneErogatori ? "porte_applicative" : "porte_delegate";
                    if (canaleDefault) {
                        sqlQueryObject.addWhereCondition(false, new String[]{tabellaPorta + ".canale = ?", "( " + tabellaPorta + ".canale is null AND (accordi.canale = ?  OR accordi.canale is null) )"});
                    } else {
                        sqlQueryObject.addWhereCondition(false, new String[]{tabellaPorta + ".canale = ?", "( " + tabellaPorta + ".canale is null AND accordi.canale = ? )"});
                    }
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nomeServizio");
                sqlQueryObject.addOrderBy("versioneServizio");
                sqlQueryObject.addOrderBy("nomeSoggettoErogatore");
                sqlQueryObject.addOrderBy("tipoServizio");
                sqlQueryObject.addOrderBy("tipoSoggettoErogatore");
                if (gestioneFruitori) {
                    sqlQueryObject.addOrderBy("nomeSoggettoFruitore");
                    sqlQueryObject.addOrderBy("tipoSoggettoFruitore");
                }
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addFromTable("soggetti");
                if (permessiUtente != null || filterTipoAPI != null || filterGruppo != null || idAccordoApi != null || searchCanale || filtroModI) {
                    sqlQueryObject.addFromTable("accordi");
                    sqlQueryObject.addWhereCondition("servizi.id_accordo=accordi.id");
                    if (filterGruppo != null) {
                        sqlQueryObject.addFromTable("accordi_gruppi");
                        sqlQueryObject.addFromTable("gruppi");
                        sqlQueryObject.addWhereCondition("accordi_gruppi.id_accordo=accordi.id");
                        sqlQueryObject.addWhereCondition("accordi_gruppi.id_gruppo=gruppi.id");
                    }
                    if (idAccordoApi != null) {
                        sqlQueryObject.addFromTable("soggetti", aliasSoggettiReferenti);
                        sqlQueryObject.addWhereCondition("accordi.id_referente=" + aliasSoggettiReferenti + ".id");
                    }
                }
                if (gestioneFruitori) {
                    sqlQueryObject.addFromTable("mapping_fruizione_pd");
                    sqlQueryObject.addFromTable("servizi_fruitori");
                    sqlQueryObject.addFromTable("soggetti", aliasSoggettiFruitori);
                    if (searchCanale) {
                        sqlQueryObject.addFromTable("porte_delegate");
                    }
                    sqlQueryObject.addWhereCondition("mapping_fruizione_pd.id_fruizione=servizi_fruitori.id");
                    sqlQueryObject.addWhereCondition("mapping_fruizione_pd.is_default=1");
                    if (searchCanale) {
                        sqlQueryObject.addWhereCondition("mapping_fruizione_pd.id_porta=porte_delegate.id");
                    }
                    sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio=servizi.id");
                    sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto=" + aliasSoggettiFruitori + ".id");
                    if (joinConnettore) {
                        DBUtils.setFiltriConnettoreFruizione(sqlQueryObject, this.driver.tipoDB, tipoConnettore, endpointType, tipoConnettoreIntegrationManager, filtroConnettoreTokenPolicy, filtroConnettoreEndpoint, filtroConnettoreKeystore, filtroConnettoreDebug);
                    }
                    if (filtroModI) {
                        DBUtils.setFiltriModIFruizione(sqlQueryObject, this.driver.tipoDB, filtroModISicurezzaCanale, filtroModISicurezzaMessaggio, filtroModISorgenteToken, filtroModIDigestRichiestaEnabled, filtroModIInfoUtente, filtroModIKeystorePath, filtroModIAudience);
                    }
                    if (filtroProprieta) {
                        DBUtils.setFiltriProprietaFruizione(sqlQueryObject, this.driver.tipoDB, filtroProprietaNome, filtroProprietaValore);
                    }
                    if (filtroStatoAPIImpl != null || filtroAutenticazioneTokenPolicy != null || filtroAutenticazioneTrasporto != null || filtroRateLimitingStato != null || filtroValidazioneStato != null || filtroCacheRispostaStato != null || filtroMessageSecurityStato != null || filtroMTOMStato != null || filtroTrasformazione != null || filtroConfigurazioneTransazioni != null || filtroCorrelazioneApplicativa != null || filtroConfigurazioneDumpTipo != null || filtroCORS != null) {
                        DBUtils.setFiltriConfigurazioneFruizione(sqlQueryObject, this.driver.tipoDB, filtroStatoAPIImpl, filtroAutenticazioneTokenPolicy, filtroAutenticazioneTrasporto, filtroRateLimitingStato, filtroValidazioneStato, filtroCacheRispostaStato, filtroMessageSecurityStato, filtroMTOMStato, filtroTrasformazione, filtroConfigurazioneTransazioni, filtroCorrelazioneApplicativa, filtroConfigurazioneDumpTipo, filtroCORS, filtroCORSorigin);
                    }
                }
                if (gestioneErogatori) {
                    sqlQueryObject.addFromTable("mapping_erogazione_pa");
                    if (searchCanale) {
                        sqlQueryObject.addFromTable("porte_applicative");
                    }
                    sqlQueryObject.addWhereCondition("mapping_erogazione_pa.id_erogazione=servizi.id");
                    sqlQueryObject.addWhereCondition("mapping_erogazione_pa.is_default=1");
                    if (searchCanale) {
                        sqlQueryObject.addWhereCondition("mapping_erogazione_pa.id_porta=porte_applicative.id");
                    }
                    if (joinConnettore) {
                        DBUtils.setFiltriConnettoreErogazione(sqlQueryObject, this.driver.tipoDB, tipoConnettore, endpointType, tipoConnettoreIntegrationManager, filtroConnettoreTokenPolicy, filtroConnettoreEndpoint, filtroConnettoreKeystore, filtroConnettoreDebug);
                    }
                    if (filtroModI) {
                        DBUtils.setFiltriModIErogazione(sqlQueryObject, this.driver.tipoDB, filtroModISicurezzaCanale, filtroModISicurezzaMessaggio, filtroModISorgenteToken, filtroModIDigestRichiestaEnabled, filtroModIInfoUtente, filtroModIKeystorePath, filtroModIAudience);
                    }
                    if (filtroProprieta) {
                        DBUtils.setFiltriProprietaErogazione(sqlQueryObject, this.driver.tipoDB, filtroProprietaNome, filtroProprietaValore);
                    }
                    if (filtroStatoAPIImpl != null || filtroAutenticazioneTokenPolicy != null || filtroAutenticazioneTrasporto != null || filtroRateLimitingStato != null || filtroValidazioneStato != null || filtroCacheRispostaStato != null || filtroMessageSecurityStato != null || filtroMTOMStato != null || filtroTrasformazione != null || filtroConfigurazioneTransazioni != null || filtroCorrelazioneApplicativa != null || filtroConfigurazioneDumpTipo != null || filtroCORS != null) {
                        DBUtils.setFiltriConfigurazioneErogazione(sqlQueryObject, this.driver.tipoDB, filtroStatoAPIImpl, filtroAutenticazioneTokenPolicy, filtroAutenticazioneTrasporto, filtroRateLimitingStato, filtroValidazioneStato, filtroCacheRispostaStato, filtroMessageSecurityStato, filtroMTOMStato, filtroTrasformazione, filtroConfigurazioneTransazioni, filtroCorrelazioneApplicativa, filtroConfigurazioneDumpTipo, filtroCORS, filtroCORSorigin);
                    }
                }
                sqlQueryObject.addSelectField("servizi.id");
                sqlQueryObject.addSelectAliasField("servizi.nome_servizio", "nomeServizio");
                sqlQueryObject.addSelectAliasField("servizi.tipo_servizio", "tipoServizio");
                sqlQueryObject.addSelectAliasField("servizi.versione_servizio", "versioneServizio");
                sqlQueryObject.addSelectAliasField("servizi.id_soggetto", "idSoggettoErogatore");
                sqlQueryObject.addSelectField("servizi.id_accordo");
                sqlQueryObject.addSelectField("servizio_correlato");
                sqlQueryObject.addSelectAliasField("servizi.stato", "statoServizio");
                sqlQueryObject.addSelectAliasField("servizi", "descrizione", "descrizioneServizio");
                sqlQueryObject.addSelectAliasField("soggetti.nome_soggetto", "nomeSoggettoErogatore");
                sqlQueryObject.addSelectAliasField("soggetti.tipo_soggetto", "tipoSoggettoErogatore");
                sqlQueryObject.addSelectField("port_type");
                if (gestioneFruitori) {
                    sqlQueryObject.addSelectAliasField("servizi_fruitori.id", "idFruizione");
                    sqlQueryObject.addSelectAliasField(aliasSoggettiFruitori + ".id", "idSoggettoFruitore");
                    sqlQueryObject.addSelectAliasField(aliasSoggettiFruitori + ".nome_soggetto", "nomeSoggettoFruitore");
                    sqlQueryObject.addSelectAliasField(aliasSoggettiFruitori + ".tipo_soggetto", "tipoSoggettoFruitore");
                }
                sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
                if (filterSoggettoNome != null && !"".equals(filterSoggettoNome)) {
                    if (gestioneFruitori) {
                        sqlQueryObject.addWhereCondition(aliasSoggettiFruitori + ".tipo_soggetto=?");
                        sqlQueryObject.addWhereCondition(aliasSoggettiFruitori + ".nome_soggetto=?");
                    } else {
                        sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto=?");
                        sqlQueryObject.addWhereCondition("soggetti.nome_soggetto=?");
                    }
                }
                if (this.driver.useSuperUser && superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                if (tipoServiziProtocollo != null && tipoServiziProtocollo.size() > 0) {
                    sqlQueryObject.addWhereINCondition("servizi.tipo_servizio", true, tipoServiziProtocollo.toArray(new String[1]));
                }
                if (filterTipoAPI != null && !filterTipoAPI.equals("")) {
                    sqlQueryObject.addWhereCondition("accordi.service_binding = ?");
                }
                if (filterGruppo != null && !filterGruppo.equals("")) {
                    sqlQueryObject.addWhereCondition("gruppi.nome = ?");
                }
                if (idAccordoApi != null) {
                    sqlQueryObject.addWhereCondition("accordi.nome = ?");
                    sqlQueryObject.addWhereCondition("accordi.versione = ?");
                    sqlQueryObject.addWhereCondition(aliasSoggettiReferenti + ".tipo_soggetto = ?");
                    sqlQueryObject.addWhereCondition(aliasSoggettiReferenti + ".nome_soggetto = ?");
                }
                if (pddTipologia != null) {
                    if (PddTipologia.ESTERNO.equals((Object)pddTipologia)) {
                        sqlQueryObject.addWhereCondition(sqlQueryObjectPdd.createSQLConditions());
                    } else {
                        sqlQueryObject.addFromTable("pdd");
                        sqlQueryObject.addWhereCondition(true, new String[]{"pdd.nome=soggetti.server", "pdd.tipo=?"});
                    }
                }
                if (filterStatoAccordo != null && !filterStatoAccordo.equals("")) {
                    sqlQueryObject.addWhereCondition("servizi.stato = ?");
                }
                if (sqlQueryObjectSoggettiErogatoreContains != null) {
                    sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectSoggettiErogatoreContains);
                }
                if (permessiUtente != null) {
                    if (permessiUtente[0] && !permessiUtente[1]) {
                        sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectAccordiComposti);
                    }
                    if (!permessiUtente[0] && permessiUtente[1]) {
                        sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectAccordiComposti);
                    }
                }
                if (searchCanale) {
                    String string = tabellaPorta = gestioneErogatori ? "porte_applicative" : "porte_delegate";
                    if (canaleDefault) {
                        sqlQueryObject.addWhereCondition(false, new String[]{tabellaPorta + ".canale = ?", "( " + tabellaPorta + ".canale is null AND (accordi.canale = ?  OR accordi.canale is null) )"});
                    } else {
                        sqlQueryObject.addWhereCondition(false, new String[]{tabellaPorta + ".canale = ?", "( " + tabellaPorta + ".canale is null AND accordi.canale = ? )"});
                    }
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nomeServizio");
                sqlQueryObject.addOrderBy("versioneServizio");
                sqlQueryObject.addOrderBy("nomeSoggettoErogatore");
                sqlQueryObject.addOrderBy("tipoServizio");
                sqlQueryObject.addOrderBy("tipoSoggettoErogatore");
                if (gestioneFruitori) {
                    sqlQueryObject.addOrderBy("nomeSoggettoFruitore");
                    sqlQueryObject.addOrderBy("tipoSoggettoFruitore");
                }
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            this.driver.logDebug("query : " + queryString);
            stmt = con.prepareStatement(queryString);
            index = 1;
            if (filterSoggettoNome != null && !"".equals(filterSoggettoNome)) {
                stmt.setString(index++, filterSoggettoTipo);
                stmt.setString(index++, filterSoggettoNome);
            }
            if (this.driver.useSuperUser && superuser != null && !"".equals(superuser)) {
                stmt.setString(index++, superuser);
            }
            if (filterTipoAPI != null && !filterTipoAPI.equals("")) {
                stmt.setString(index++, filterTipoAPI);
            }
            if (filterGruppo != null && !filterGruppo.equals("")) {
                stmt.setString(index++, filterGruppo);
            }
            if (idAccordoApi != null) {
                stmt.setString(index++, idAccordoApi.getNome());
                stmt.setInt(index++, idAccordoApi.getVersione());
                stmt.setString(index++, idAccordoApi.getSoggettoReferente().getTipo());
                stmt.setString(index++, idAccordoApi.getSoggettoReferente().getNome());
            }
            if (pddTipologia != null) {
                stmt.setString(index++, pddTipologia.toString());
            }
            if (filterStatoAccordo != null && !filterStatoAccordo.equals("")) {
                stmt.setString(index++, filterStatoAccordo);
            }
            if (searchCanale) {
                stmt.setString(index++, filterCanale);
                stmt.setString(index++, filterCanale);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                AccordoServizioParteSpecifica serv = new AccordoServizioParteSpecifica();
                serv.setId(risultato.getLong("id"));
                serv.setNome(risultato.getString("nomeServizio"));
                serv.setTipo(risultato.getString("tipoServizio"));
                serv.setVersione(risultato.getInt("versioneServizio"));
                serv.setPortType(risultato.getString("port_type"));
                serv.setIdSoggetto(risultato.getLong("idSoggettoErogatore"));
                serv.setIdAccordo(risultato.getLong("id_accordo"));
                String servizioCorrelato = risultato.getString("servizio_correlato");
                if (servizioCorrelato != null && (servizioCorrelato.equalsIgnoreCase(CostantiRegistroServizi.ABILITATO.toString()) || TipologiaServizio.CORRELATO.toString().equals(servizioCorrelato))) {
                    serv.setTipologiaServizio(TipologiaServizio.CORRELATO);
                } else {
                    serv.setTipologiaServizio(TipologiaServizio.NORMALE);
                }
                serv.setDescrizione(risultato.getString("descrizioneServizio"));
                Soggetto sog = this.driver.getSoggetto(serv.getIdSoggetto(), con);
                String nomeErogatore = sog.getNome();
                String tipoErogatore = sog.getTipo();
                serv.setNomeSoggettoErogatore(nomeErogatore);
                serv.setTipoSoggettoErogatore(tipoErogatore);
                IDAccordo idAccordo = this.driver.getIdAccordoServizioParteComune(serv.getIdAccordo(), con);
                serv.setAccordoServizioParteComune(this.driver.idAccordoFactory.getUriFromIDAccordo(idAccordo));
                serv.setStatoPackage(risultato.getString("statoServizio"));
                if (gestioneFruitori) {
                    Fruitore fruitore = new Fruitore();
                    fruitore.setId(risultato.getLong("idFruizione"));
                    fruitore.setTipo(risultato.getString("tipoSoggettoFruitore"));
                    fruitore.setNome(risultato.getString("nomeSoggettoFruitore"));
                    fruitore.setIdServizio(serv.getId());
                    fruitore.setIdSoggetto(risultato.getLong("idSoggettoFruitore"));
                    serv.addFruitore(fruitore);
                }
                serviziList.add(serv);
            }
            arrayList = serviziList;
        }
        catch (Exception qe) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }
}

