/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.IdSoggetto;
import org.openspcoop2.utils.beans.BaseBeanWithId;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="id-accordo-servizio-parte-specifica", propOrder={"soggettoErogatore"})
@XmlRootElement(name="id-accordo-servizio-parte-specifica")
public class IdAccordoServizioParteSpecifica
extends BaseBeanWithId
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="soggetto-erogatore", required=true, nillable=false)
    protected IdSoggetto soggettoErogatore;
    @XmlSchemaType(name="string")
    @XmlAttribute(name="tipo", required=true)
    protected String tipo;
    @XmlSchemaType(name="string")
    @XmlAttribute(name="nome", required=true)
    protected String nome;
    @XmlSchemaType(name="unsignedInt")
    @XmlAttribute(name="versione", required=false)
    protected Integer versione = Integer.valueOf("1");

    public IdAccordoServizioParteSpecifica() {
    }

    public IdSoggetto getSoggettoErogatore() {
        return this.soggettoErogatore;
    }

    public void setSoggettoErogatore(IdSoggetto soggettoErogatore) {
        this.soggettoErogatore = soggettoErogatore;
    }

    public String getTipo() {
        return this.tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Integer getVersione() {
        return this.versione;
    }

    public void setVersione(Integer versione) {
        this.versione = versione;
    }

    public IdAccordoServizioParteSpecifica(IDServizio idServizio) {
        if (idServizio != null) {
            this.tipo = idServizio.getTipo();
            this.nome = idServizio.getNome();
            this.versione = idServizio.getVersione();
            if (idServizio.getSoggettoErogatore() != null) {
                this.soggettoErogatore = new IdSoggetto();
                this.soggettoErogatore.setNome(idServizio.getSoggettoErogatore().getNome());
                this.soggettoErogatore.setTipo(idServizio.getSoggettoErogatore().getTipo());
            }
        }
    }

    public IDServizio toIDServizio() throws CoreException {
        if (this.tipo == null) {
            throw new CoreException("Tipo undefined");
        }
        if (this.nome == null) {
            throw new CoreException("Nome undefined");
        }
        if (this.versione == null) {
            throw new CoreException("Versione undefined");
        }
        if (this.soggettoErogatore == null) {
            throw new CoreException("SoggettoErogatore undefined");
        }
        if (this.soggettoErogatore.getTipo() == null) {
            throw new CoreException("TipoSoggettoErogatore undefined");
        }
        if (this.soggettoErogatore.getNome() == null) {
            throw new CoreException("NomeSoggettoErogatore undefined");
        }
        try {
            IDServizio id = new IDServizio();
            id.setTipo(this.tipo);
            id.setNome(this.nome);
            id.setVersione(this.versione);
            if (this.soggettoErogatore != null) {
                id.setSoggettoErogatore(new IDSoggetto(this.soggettoErogatore.getTipo(), this.soggettoErogatore.getNome()));
            }
            return id;
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), e);
        }
    }
}

