/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.id;

import java.io.Serializable;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.utils.Utilities;

public class IDFruizione
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected IDServizio idServizio;
    protected IDSoggetto idFruitore;

    public IDServizio getIdServizio() {
        return this.idServizio;
    }

    public void setIdServizio(IDServizio idServizio) {
        this.idServizio = idServizio;
    }

    public IDSoggetto getIdFruitore() {
        return this.idFruitore;
    }

    public void setIdFruitore(IDSoggetto idFruitore) {
        this.idFruitore = idFruitore;
    }

    public String toString() {
        StringBuilder bf = new StringBuilder();
        if (this.idServizio != null) {
            bf.append(" idServizio[" + this.idServizio + "]");
        }
        if (this.idFruitore != null) {
            bf.append(" idFruitore[" + this.idFruitore + "]");
        }
        return bf.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!Utilities.equalsClass((Object)object, (Object)this)) {
            return false;
        }
        IDFruizione id = (IDFruizione)object;
        if (this.idServizio == null ? id.idServizio != null : !this.idServizio.equals(id.idServizio)) {
            return false;
        }
        return !(this.idFruitore == null ? id.idFruitore != null : !this.idFruitore.equals(id.idFruitore));
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public IDFruizione clone() {
        IDFruizione idFruizione = new IDFruizione();
        if (this.idServizio != null) {
            idFruizione.idServizio = this.idServizio.clone();
        }
        if (this.idFruitore != null) {
            idFruizione.idFruitore = this.idFruitore.clone();
        }
        return idFruizione;
    }

    public String toFormatString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.idFruitore.toFormatString());
        sb.append(" ");
        sb.append(this.idServizio.toFormatString());
        return sb.toString();
    }

    public static IDFruizione toIDFruizione(String formatString) throws Exception {
        String[] tmp = formatString.split(" ");
        if (tmp.length != 2) {
            throw new Exception("Formato non supportato, attesi 2 valori, trovati " + tmp.length);
        }
        String fruitore = tmp[0];
        String servizio = tmp[1];
        IDFruizione idFruizione = new IDFruizione();
        idFruizione.setIdFruitore(IDSoggetto.toIDSoggetto(fruitore));
        idFruizione.setIdServizio(IDServizio.toIDServizio(servizio));
        return idFruizione;
    }
}

