/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.eccezione.details.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFault;
import org.openspcoop2.core.eccezione.details.Dettaglio;
import org.openspcoop2.core.eccezione.details.DettaglioEccezione;
import org.openspcoop2.core.eccezione.details.Dominio;
import org.openspcoop2.core.eccezione.details.Eccezione;
import org.openspcoop2.core.eccezione.details.utils.XMLUtilsException;
import org.openspcoop2.core.eccezione.details.utils.serializer.JsonJacksonDeserializer;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2RestJsonMessage;
import org.openspcoop2.message.OpenSPCoop2RestXmlMessage;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.message.xml.ValidatoreXSD;
import org.openspcoop2.utils.beans.WriteToSerializerType;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.xml.JaxbUtils;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLUtils {
    static ValidatoreXSD validatoreXSD = null;

    private static synchronized void initValidatoreXSD(Logger log) throws Exception {
        if (validatoreXSD == null) {
            validatoreXSD = new ValidatoreXSD(OpenSPCoop2MessageFactory.getDefaultMessageFactory(), log, XMLUtils.class.getResourceAsStream("/openspcoopDetail.xsd"));
        }
    }

    public static ValidatoreXSD getValidatoreXSD(Logger log) throws Exception {
        if (validatoreXSD == null) {
            XMLUtils.initValidatoreXSD(log);
        }
        return validatoreXSD;
    }

    public static boolean validate(DettaglioEccezione eccezione, StringBuilder motivoErroreValidazione) {
        int i;
        int size = motivoErroreValidazione.length();
        if (eccezione.getDomain() == null) {
            motivoErroreValidazione.append("Dominio non definito\n");
        } else {
            XMLUtils.validate(eccezione.getDomain(), motivoErroreValidazione);
        }
        if (eccezione.getTimestamp() == null) {
            motivoErroreValidazione.append("OraRegistrazione non definita\n");
        }
        if (eccezione.getExceptions() == null) {
            motivoErroreValidazione.append("Nessuna eccezione definita\n");
        } else if (eccezione.getExceptions().sizeExceptionList() <= 0) {
            motivoErroreValidazione.append("Nessuna eccezione definita\n");
        } else {
            for (i = 0; i < eccezione.getExceptions().sizeExceptionList(); ++i) {
                Eccezione ecc = eccezione.getExceptions().getException(i);
                if (ecc.getCode() == null) {
                    motivoErroreValidazione.append("Eccezione.codice non definito\n");
                }
                if (ecc.getDescription() == null) {
                    motivoErroreValidazione.append("Eccezione.codice non definito\n");
                }
                if (ecc.getType() != null) continue;
                motivoErroreValidazione.append("Eccezione.tipo non definito\n");
            }
        }
        if (eccezione.getDetails() != null && eccezione.getDetails().sizeDetailList() > 0) {
            for (i = 0; i < eccezione.getDetails().sizeDetailList(); ++i) {
                Dettaglio detail = eccezione.getDetails().getDetail(i);
                if (detail == null) {
                    motivoErroreValidazione.append("Detail presente e non definito??\n");
                    continue;
                }
                if (detail.getType() == null) {
                    motivoErroreValidazione.append("Detail[" + i + "].tipo non definito\n");
                }
                if (detail.getBase() != null) continue;
                motivoErroreValidazione.append("Detail[" + i + "].tipo non definito\n");
            }
        }
        return motivoErroreValidazione.length() == size;
    }

    private static void validate(Dominio dominio, StringBuilder motivoErroreValidazione) {
        if (dominio.getId() == null) {
            motivoErroreValidazione.append("Dominio.identificativoPorta non definito\n");
        }
        if (dominio.getRole() == null) {
            motivoErroreValidazione.append("Dominio.funzione non definito\n");
        }
        if (dominio.getModule() == null) {
            motivoErroreValidazione.append("Dominio.modulo non definito\n");
        }
        if (dominio.getOrganization() == null) {
            motivoErroreValidazione.append("Dominio.soggetto non definita\n");
        } else {
            if (dominio.getOrganization().getType() == null) {
                motivoErroreValidazione.append("Dominio.soggetto.tipo non definita\n");
            }
            if (dominio.getOrganization().getBase() == null) {
                motivoErroreValidazione.append("Dominio.soggetto.nome non definita\n");
            }
        }
    }

    public static DettaglioEccezione getDettaglioEccezione(Logger log, byte[] m) throws XMLUtilsException {
        ByteArrayInputStream bin = null;
        try {
            bin = new ByteArrayInputStream(m);
            DettaglioEccezione dettaglioEccezione = XMLUtils.getDettaglioEccezione(log, bin);
            return dettaglioEccezione;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static DettaglioEccezione getDettaglioEccezione(Logger log, File m) throws XMLUtilsException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(m);
            DettaglioEccezione dettaglioEccezione = XMLUtils.getDettaglioEccezione(log, fin);
            return dettaglioEccezione;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static DettaglioEccezione getDettaglioEccezione(Logger log, String m) throws XMLUtilsException {
        return XMLUtils.getDettaglioEccezione(log, m.getBytes());
    }

    public static DettaglioEccezione getDettaglioEccezione(Logger log, InputStream m) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] reads = new byte[1024];
            int letti = 0;
            while ((letti = m.read(reads)) != -1) {
                bout.write(reads, 0, letti);
            }
            bout.flush();
            bout.close();
            byte[] xml = bout.toByteArray();
            ByteArrayInputStream binValidazione = new ByteArrayInputStream(xml);
            ValidatoreXSD validatoreXSD = XMLUtils.getValidatoreXSD(log);
            validatoreXSD.valida((InputStream)binValidazione);
            ByteArrayInputStream binTrasformazione = new ByteArrayInputStream(xml);
            return (DettaglioEccezione)JaxbUtils.xmlToObj((InputStream)binTrasformazione, DettaglioEccezione.class);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static DettaglioEccezione getDettaglioEccezioneFromJson(Logger log, InputStream is) throws XMLUtilsException {
        try {
            JsonJacksonDeserializer deserializer = new JsonJacksonDeserializer();
            return deserializer.readDettaglioEccezione(is);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateDettaglioEccezione(DettaglioEccezione eccezione, File out) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            JaxbUtils.objToXml((String)out.getName(), (byte[])XMLUtils.generateDettaglioEccezione_engine(eccezione));
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateDettaglioEccezione(DettaglioEccezione eccezione, String fileName) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            JaxbUtils.objToXml((String)fileName, (byte[])XMLUtils.generateDettaglioEccezione_engine(eccezione));
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static byte[] generateDettaglioEccezione(DettaglioEccezione eccezione) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            return XMLUtils.generateDettaglioEccezione_engine(eccezione);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateDettaglioEccezione(DettaglioEccezione eccezione, OutputStream out) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            out.write(XMLUtils.generateDettaglioEccezione_engine(eccezione));
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static String generateDettaglioEccezioneAsJson(DettaglioEccezione eccezione) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            return XMLUtils.generateDettaglioEccezioneAsJson_engine(eccezione);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    private static byte[] generateDettaglioEccezione_engine(DettaglioEccezione eccezione) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            JaxbUtils.objToXml((OutputStream)bout, DettaglioEccezione.class, (Object)eccezione);
            byte[] dichiarazione = bout.toByteArray();
            return dichiarazione;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    private static String generateDettaglioEccezioneAsJson_engine(DettaglioEccezione eccezione) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            eccezione.writeTo(bout, WriteToSerializerType.JSON_JACKSON);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static DettaglioEccezione getDettaglioEccezione(Logger log, OpenSPCoop2Message msg) throws XMLUtilsException {
        switch (msg.getMessageType()) {
            case SOAP_11: 
            case SOAP_12: {
                try {
                    return XMLUtils.getDettaglioEccezione(log, msg.castAsSoap());
                }
                catch (XMLUtilsException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new XMLUtilsException(e.getMessage(), e);
                }
            }
            case XML: {
                try {
                    Element element;
                    OpenSPCoop2RestXmlMessage rest = msg.castAsRestXml();
                    if (rest.hasContent() && XMLUtils.isDettaglioEccezione(element = (Element)rest.getContent())) {
                        MessageXMLUtils xmlUtils = MessageXMLUtils.DEFAULT;
                        byte[] xml = xmlUtils.toByteArray(element);
                        DettaglioEccezione de = XMLUtils.getDettaglioEccezione(log, xml);
                        return de;
                    }
                    return null;
                }
                catch (XMLUtilsException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new XMLUtilsException(e.getMessage(), e);
                }
            }
            case JSON: {
                try {
                    OpenSPCoop2RestJsonMessage rest = msg.castAsRestJson();
                    if (rest.hasContent()) {
                        String json = (String)rest.getContent();
                        try {
                            DettaglioEccezione de = XMLUtils.getDettaglioEccezioneFromJson(log, new ByteArrayInputStream(json.getBytes()));
                            return de;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return null;
                }
                catch (Exception e) {
                    throw new XMLUtilsException(e.getMessage(), e);
                }
            }
        }
        return null;
    }

    public static DettaglioEccezione getDettaglioEccezione(Logger log, OpenSPCoop2SoapMessage msg) throws XMLUtilsException {
        try {
            if (msg == null) {
                throw new XMLUtilsException("Messaggio non presente");
            }
            SOAPBody soapBody = msg.getSOAPBody();
            if (soapBody == null) {
                throw new XMLUtilsException("SOAPBody non presente");
            }
            SOAPFault faultOriginale = null;
            if (!soapBody.hasFault()) {
                return null;
            }
            faultOriginale = soapBody.getFault();
            if (faultOriginale == null) {
                throw new XMLUtilsException("SOAPFault is null");
            }
            QName nameDetail = new QName("detail");
            Iterator itSF = faultOriginale.getChildElements(nameDetail);
            SOAPElement detailsFaultOriginale = null;
            if (itSF.hasNext()) {
                detailsFaultOriginale = (SOAPElement)itSF.next();
            }
            msg.saveChanges();
            if (detailsFaultOriginale != null) {
                Iterator it = detailsFaultOriginale.getChildElements();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (!(o instanceof SOAPElement)) continue;
                    SOAPElement elem = (SOAPElement)o;
                    try {
                        if (!XMLUtils.isDettaglioEccezione((Element)elem)) continue;
                        MessageXMLUtils xmlUtils = MessageXMLUtils.DEFAULT;
                        byte[] xml = xmlUtils.toByteArray((Element)elem);
                        DettaglioEccezione de = XMLUtils.getDettaglioEccezione(log, xml);
                        return de;
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                    }
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static boolean isDettaglioEccezione(byte[] doc) {
        try {
            MessageXMLUtils xmlUtils = MessageXMLUtils.DEFAULT;
            Document docXML = xmlUtils.newDocument(doc);
            Element elemXML = docXML.getDocumentElement();
            return XMLUtils.isDettaglioEccezione_engine(elemXML);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDettaglioEccezione(Document docXML) {
        try {
            Element elemXML = docXML.getDocumentElement();
            return XMLUtils.isDettaglioEccezione_engine(elemXML);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDettaglioEccezione(Element elemXML) {
        return XMLUtils.isDettaglioEccezione_engine(elemXML);
    }

    public static boolean isDettaglioEccezione(Node nodeXml) {
        return XMLUtils.isDettaglioEccezione_engine(nodeXml);
    }

    private static boolean isDettaglioEccezione_engine(Node nodeXml) {
        try {
            return "fault-details".equals(nodeXml.getLocalName()) && "http://govway.org/integration/fault/details".equals(nodeXml.getNamespaceURI());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String toString(DettaglioEccezione de) {
        StringBuilder bf = new StringBuilder();
        if (de != null) {
            int k;
            if (de.getTimestamp() != null) {
                SimpleDateFormat dateformat = DateUtils.getSimpleDateFormatMs();
                bf.append("(" + dateformat.format(de.getTimestamp()) + ")");
            }
            if (de.getDomain() != null) {
                bf.append(" ");
                boolean writeSoggetto = false;
                if (de.getDomain().getId() != null) {
                    bf.append(de.getDomain().getId());
                    writeSoggetto = true;
                    if (de.getDomain().getOrganization() != null) {
                        bf.append(".");
                    }
                }
                if (de.getDomain().getOrganization() != null) {
                    bf.append(de.getDomain().getOrganization().getType() + "/" + de.getDomain().getOrganization().getBase());
                    writeSoggetto = true;
                }
                if ((de.getDomain().getRole() != null || de.getDomain().getModule() != null) && writeSoggetto) {
                    bf.append(" ");
                }
                if (de.getDomain().getRole() != null) {
                    bf.append(de.getDomain().getRole());
                    if (de.getDomain().getModule() != null) {
                        bf.append(".");
                    }
                }
                if (de.getDomain().getModule() != null) {
                    bf.append(de.getDomain().getModule());
                }
            }
            if (bf.length() > 0) {
                bf.append(" ");
            }
            int sizeEccezioni = 0;
            if (de.getExceptions() != null) {
                sizeEccezioni = de.getExceptions().sizeExceptionList();
            }
            int sizeDettagli = 0;
            if (de.getDetails() != null) {
                sizeDettagli = de.getDetails().sizeDetailList();
            }
            bf.append("ha rilevato " + sizeEccezioni + " eccezione/i (dettagli:" + sizeDettagli + ")");
            for (k = 0; k < sizeEccezioni; ++k) {
                bf.append("\n- Eccezione (" + de.getExceptions().getException(k).getType() + ") [" + de.getExceptions().getException(k).getCode() + "] " + de.getExceptions().getException(k).getDescription());
            }
            if (sizeDettagli > 0) {
                for (k = 0; k < sizeDettagli; ++k) {
                    bf.append("\n- Dettaglio [" + de.getDetails().getDetail(k).getType() + "] " + de.getDetails().getDetail(k).getBase());
                }
            }
        }
        return bf.toString();
    }
}

