/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.controllo_traffico.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.controllo_traffico.constants.Costanti;
import org.openspcoop2.core.controllo_traffico.driver.PolicyGroupByActiveThreadsType;

public abstract class AbstractPolicyConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected boolean gestionePolicyRidefinita = false;
    protected PolicyGroupByActiveThreadsType type;
    private Boolean LOCAL_DIVIDED_BY_NODES_remaining_zeroValue = null;
    private Boolean LOCAL_DIVIDED_BY_NODES_limit_roundingDown = null;
    private Boolean LOCAL_DIVIDED_BY_NODES_limit_normalizedQuota = null;
    protected boolean gestioneHttpHeadersRidefinita = false;
    protected boolean disabledHttpHeaders = false;
    protected boolean disabledHttpHeaders_limit = false;
    protected boolean forceHttpHeaders_limit_no_windows = false;
    protected boolean forceHttpHeaders_limit_windows = false;
    protected boolean disabledHttpHeaders_remaining = false;
    protected boolean disabledHttpHeaders_reset = false;
    protected boolean disabledHttpHeaders_retryAfter = false;
    protected boolean forceDisabledHttpHeaders_retryAfter_backoff = false;
    protected int forceHttpHeaders_retryAfter_backoff = -1;
    protected String syncMode = "default";
    protected String impl = null;
    protected String count = null;
    protected String engineType = null;
    protected Long gestorePolicyConfigDate = null;
    protected String httpMode = "default";
    protected String httpMode_limit = null;
    protected String httpMode_remaining = null;
    protected String httpMode_reset = null;
    protected String httpMode_retry_after = null;
    protected String httpMode_retry_after_backoff = null;
    private static Map<String, PolicyGroupByActiveThreadsType> mappingCostantiToHazelcastExact = Map.of("atomic-long-counters", PolicyGroupByActiveThreadsType.HAZELCAST_ATOMIC_LONG, "full-sync", PolicyGroupByActiveThreadsType.HAZELCAST_MAP);
    private static Map<String, PolicyGroupByActiveThreadsType> mappingCostantiToHazelcastApprox = Map.of("pn-counters", PolicyGroupByActiveThreadsType.HAZELCAST_PNCOUNTER, "atomic-long-async-counters", PolicyGroupByActiveThreadsType.HAZELCAST_ATOMIC_LONG_ASYNC, "near-cache", PolicyGroupByActiveThreadsType.HAZELCAST_NEAR_CACHE, "local-cache", PolicyGroupByActiveThreadsType.HAZELCAST_LOCAL_CACHE);
    private static Map<String, PolicyGroupByActiveThreadsType> mappingCostantiToHazelcastInconsistent = Map.of("remote-sync", PolicyGroupByActiveThreadsType.HAZELCAST_NEAR_CACHE_UNSAFE_SYNC_MAP, "remote-async", PolicyGroupByActiveThreadsType.HAZELCAST_NEAR_CACHE_UNSAFE_ASYNC_MAP, "replicated-map", PolicyGroupByActiveThreadsType.HAZELCAST_REPLICATED_MAP);
    private static Map<String, PolicyGroupByActiveThreadsType> mappingCostantiToRedisExact = Map.of("atomic-long-counters", PolicyGroupByActiveThreadsType.REDISSON_ATOMIC_LONG, "redisson-map", PolicyGroupByActiveThreadsType.REDISSON_MAP);
    private static Map<String, PolicyGroupByActiveThreadsType> mappingCostantiToRedisInconsistent = Map.of("longadder-counters", PolicyGroupByActiveThreadsType.REDISSON_LONGADDER);

    protected Boolean getEngineLOCAL_DIVIDED_BY_NODES_remaining_zeroValue() {
        return this.LOCAL_DIVIDED_BY_NODES_remaining_zeroValue;
    }

    public void setLOCAL_DIVIDED_BY_NODES_remaining_zeroValue(Boolean lOCAL_DIVIDED_BY_NODES_remaining_zeroValue) {
        this.LOCAL_DIVIDED_BY_NODES_remaining_zeroValue = lOCAL_DIVIDED_BY_NODES_remaining_zeroValue;
    }

    protected Boolean getEngineLOCAL_DIVIDED_BY_NODES_limit_roundingDown() {
        return this.LOCAL_DIVIDED_BY_NODES_limit_roundingDown;
    }

    public void setLOCAL_DIVIDED_BY_NODES_limit_roundingDown(Boolean lOCAL_DIVIDED_BY_NODES_limit_roundingDown) {
        this.LOCAL_DIVIDED_BY_NODES_limit_roundingDown = lOCAL_DIVIDED_BY_NODES_limit_roundingDown;
    }

    protected Boolean getEngineLOCAL_DIVIDED_BY_NODES_limit_normalizedQuota() {
        return this.LOCAL_DIVIDED_BY_NODES_limit_normalizedQuota;
    }

    public void setLOCAL_DIVIDED_BY_NODES_limit_normalizedQuota(Boolean lOCAL_DIVIDED_BY_NODES_limit_normalizedQuota) {
        this.LOCAL_DIVIDED_BY_NODES_limit_normalizedQuota = lOCAL_DIVIDED_BY_NODES_limit_normalizedQuota;
    }

    public AbstractPolicyConfiguration() {
    }

    public AbstractPolicyConfiguration(boolean runtime) throws Exception {
        this.initRuntimeInfo(runtime);
    }

    public AbstractPolicyConfiguration(List<Proprieta> p) throws Exception {
        this(p, null, true);
    }

    public AbstractPolicyConfiguration(List<Proprieta> p, List<PolicyGroupByActiveThreadsType> tipiSupportati, boolean runtime) throws Exception {
        if (p != null && !p.isEmpty()) {
            String gestorePolicyConfigDate;
            if (tipiSupportati == null) {
                if (runtime) {
                    tipiSupportati = new ArrayList<PolicyGroupByActiveThreadsType>();
                    for (PolicyGroupByActiveThreadsType type : PolicyGroupByActiveThreadsType.values()) {
                        tipiSupportati.add(type);
                    }
                } else {
                    throw new Exception("Tipi supportati non indicati");
                }
            }
            if ((gestorePolicyConfigDate = AbstractPolicyConfiguration.getValue(p, "ctGestoreConfigDate", null)) != null) {
                this.gestorePolicyConfigDate = Long.valueOf(gestorePolicyConfigDate);
            }
            this.syncMode = AbstractPolicyConfiguration.getValue(p, "ctSyncMode", "default");
            if (!Costanti.getVALUES_MODALITA_SINCRONIZZAZIONE(tipiSupportati).contains(this.syncMode)) {
                throw new Exception("Value '" + this.syncMode + "' unsupported for property 'ctSyncMode'");
            }
            if ("distribuita".equals(this.syncMode)) {
                this.impl = AbstractPolicyConfiguration.getValue(p, "ctImpl", null);
                if (this.impl == null) {
                    if (runtime) {
                        throw new Exception("Value undefined for property 'ctImpl'");
                    }
                    this.impl = Costanti.getVALUES_MODALITA_IMPLEMENTAZIONE(tipiSupportati).get(0);
                }
                if (!Costanti.getVALUES_MODALITA_IMPLEMENTAZIONE(tipiSupportati).contains(this.impl)) {
                    throw new Exception("Value '" + this.impl + "' unsupported for property 'ctImpl'");
                }
                if ("hazelcast".equals(this.impl) || "redis".equals(this.impl)) {
                    this.count = AbstractPolicyConfiguration.getValue(p, "ctCount", null);
                    if (this.count == null) {
                        if (runtime) {
                            throw new Exception("Value undefined for property 'ctCount'");
                        }
                        this.count = Costanti.getVALUES_MODALITA_CONTATORI(tipiSupportati, this.impl).get(0);
                    }
                    if (!Costanti.getVALUES_MODALITA_CONTATORI(tipiSupportati, this.impl).contains(this.count)) {
                        if (runtime) {
                            throw new Exception("Value '" + this.count + "' unsupported for property 'ctCount'");
                        }
                        this.count = Costanti.getVALUES_MODALITA_CONTATORI(tipiSupportati, this.impl).get(0);
                    }
                    this.engineType = AbstractPolicyConfiguration.getValue(p, "ctEngineType", null);
                    if (this.engineType == null) {
                        if (runtime) {
                            throw new Exception("Value undefined for property 'ctEngineType'");
                        }
                        this.engineType = Costanti.getVALUES_MODALITA_TIPOLOGIA(tipiSupportati, this.impl, this.count).get(0);
                    }
                    if (!Costanti.getVALUES_MODALITA_TIPOLOGIA(tipiSupportati, this.impl, this.count).contains(this.engineType)) {
                        if (runtime) {
                            throw new Exception("Value '" + this.engineType + "' unsupported for property 'ctEngineType'");
                        }
                        this.engineType = Costanti.getVALUES_MODALITA_TIPOLOGIA(tipiSupportati, this.impl, this.count).get(0);
                    }
                }
            }
            this.httpMode = AbstractPolicyConfiguration.getValue(p, "ctHttpMode", "default");
            if (!Costanti.VALUES_MODALITA_GENERAZIONE_HEADER_HTTP.contains(this.httpMode)) {
                throw new Exception("Value '" + this.httpMode + "' unsupported for property 'ctHttpMode'");
            }
            if ("ridefinito".equals(this.httpMode)) {
                this.httpMode_limit = AbstractPolicyConfiguration.getValue(p, "ctHttpQuota", "default");
                if (!Costanti.VALUES_MODALITA_GENERAZIONE_HEADER_HTTP_LIMIT.contains(this.httpMode_limit)) {
                    throw new Exception("Value '" + this.httpMode_limit + "' unsupported for property 'ctHttpQuota'");
                }
                this.httpMode_remaining = AbstractPolicyConfiguration.getValue(p, "ctHttpRemaining", "default");
                if (!Costanti.VALUES_MODALITA_GENERAZIONE_HEADER_HTTP_REMAINING.contains(this.httpMode_remaining)) {
                    throw new Exception("Value '" + this.httpMode_remaining + "' unsupported for property 'ctHttpRemaining'");
                }
                this.httpMode_reset = AbstractPolicyConfiguration.getValue(p, "ctHttpReset", "default");
                if (!Costanti.VALUES_MODALITA_GENERAZIONE_HEADER_HTTP_RESET.contains(this.httpMode_reset)) {
                    throw new Exception("Value '" + this.httpMode_reset + "' unsupported for property 'ctHttpReset'");
                }
                this.httpMode_retry_after = AbstractPolicyConfiguration.getValue(p, "ctHttpRetryAfter", "default");
                if (!Costanti.VALUES_MODALITA_GENERAZIONE_HEADER_HTTP_RETRY_AFTER.contains(this.httpMode_retry_after)) {
                    throw new Exception("Value '" + this.httpMode_retry_after + "' unsupported for property 'ctHttpRetryAfter'");
                }
                if ("backoff".equals(this.httpMode_retry_after)) {
                    this.httpMode_retry_after_backoff = AbstractPolicyConfiguration.getValue(p, "ctHttpRetryAfterBackoff", null);
                }
            }
        }
        this.initRuntimeInfo(runtime);
    }

    private static String getValue(List<Proprieta> p, String name, String defaultV) {
        String tmp = null;
        if (p != null && !p.isEmpty()) {
            for (Proprieta proprieta : p) {
                if (!proprieta.getNome().equals(name)) continue;
                tmp = proprieta.getValore();
                break;
            }
        }
        if (tmp != null) {
            tmp = tmp.trim();
        }
        if (tmp != null && StringUtils.isNotEmpty((String)tmp)) {
            return tmp;
        }
        return defaultV;
    }

    private void initRuntimeInfo(boolean all) throws Exception {
        if (!"default".equals(this.syncMode)) {
            if ("locale".equals(this.syncMode)) {
                this.type = PolicyGroupByActiveThreadsType.LOCAL;
            } else if ("localePiuNodi".equals(this.syncMode)) {
                this.type = PolicyGroupByActiveThreadsType.LOCAL_DIVIDED_BY_NODES;
            } else if ("distribuita".equals(this.syncMode)) {
                if ("database".equals(this.impl)) {
                    this.type = PolicyGroupByActiveThreadsType.DATABASE;
                } else if ("hazelcast".equals(this.impl)) {
                    if ("exact".equals(this.count)) {
                        this.type = mappingCostantiToHazelcastExact.get(this.engineType);
                    } else if ("approximated".equals(this.count)) {
                        this.type = mappingCostantiToHazelcastApprox.get(this.engineType);
                    } else if ("inconsistent".equals(this.count)) {
                        this.type = mappingCostantiToHazelcastInconsistent.get(this.engineType);
                    }
                } else if ("redis".equals(this.impl)) {
                    if ("exact".equals(this.count)) {
                        this.type = mappingCostantiToRedisExact.get(this.engineType);
                    } else if ("inconsistent".equals(this.count)) {
                        this.type = mappingCostantiToRedisInconsistent.get(this.engineType);
                    }
                }
            }
        }
        if (all) {
            this.initRuntimeInfoAll();
        }
    }

    protected abstract void initRuntimeInfoAll() throws Exception;

    public void saveIn(List<Proprieta> list) throws Exception {
        this.initRuntimeInfo(false);
        if (this.type != null) {
            list.add(this.newProprieta("ctGestore", this.type.name()));
        }
        if (this.gestorePolicyConfigDate != null) {
            list.add(this.newProprieta("ctGestoreConfigDate", "" + this.gestorePolicyConfigDate));
        }
        list.add(this.newProprieta("ctSyncMode", this.syncMode));
        if (this.impl != null && StringUtils.isNotEmpty((String)this.impl)) {
            list.add(this.newProprieta("ctImpl", this.impl));
        }
        if (this.count != null && StringUtils.isNotEmpty((String)this.count)) {
            list.add(this.newProprieta("ctCount", this.count));
        }
        if (this.engineType != null && StringUtils.isNotEmpty((String)this.engineType)) {
            list.add(this.newProprieta("ctEngineType", this.engineType));
        }
        list.add(this.newProprieta("ctHttpMode", this.httpMode));
        if (this.httpMode_limit != null && StringUtils.isNotEmpty((String)this.httpMode_limit)) {
            list.add(this.newProprieta("ctHttpQuota", this.httpMode_limit));
        }
        if (this.httpMode_remaining != null && StringUtils.isNotEmpty((String)this.httpMode_remaining)) {
            list.add(this.newProprieta("ctHttpRemaining", this.httpMode_remaining));
        }
        if (this.httpMode_reset != null && StringUtils.isNotEmpty((String)this.httpMode_reset)) {
            list.add(this.newProprieta("ctHttpReset", this.httpMode_reset));
        }
        if (this.httpMode_retry_after != null && StringUtils.isNotEmpty((String)this.httpMode_retry_after)) {
            list.add(this.newProprieta("ctHttpRetryAfter", this.httpMode_retry_after));
        }
        if (this.httpMode_retry_after_backoff != null && StringUtils.isNotEmpty((String)this.httpMode_retry_after_backoff)) {
            list.add(this.newProprieta("ctHttpRetryAfterBackoff", this.httpMode_retry_after_backoff));
        }
    }

    private Proprieta newProprieta(String nome, String valore) {
        Proprieta p = new Proprieta();
        p.setNome(nome);
        p.setValore(valore);
        return p;
    }

    public Long getGestorePolicyConfigDate() {
        return this.gestorePolicyConfigDate;
    }

    public void setGestorePolicyConfigDate(Long gestorePolicyConfigDate) {
        this.gestorePolicyConfigDate = gestorePolicyConfigDate;
    }

    public String getSyncMode() {
        return this.syncMode;
    }

    public void setSyncMode(String syncMode) {
        this.syncMode = syncMode != null && StringUtils.isNotEmpty((String)syncMode) ? syncMode : "default";
    }

    public String getImpl() {
        return this.impl;
    }

    public void setImpl(String impl) {
        this.impl = impl != null && StringUtils.isNotEmpty((String)impl) ? impl : null;
    }

    public String getCount() {
        return this.count;
    }

    public void setCount(String count) {
        this.count = count != null && StringUtils.isNotEmpty((String)count) ? count : null;
    }

    public String getEngineType() {
        return this.engineType;
    }

    public void setEngineType(String engineType) {
        this.engineType = engineType != null && StringUtils.isNotEmpty((String)engineType) ? engineType : null;
    }

    public String getHttpMode() {
        return this.httpMode;
    }

    public void setHttpMode(String httpMode) {
        this.httpMode = httpMode != null && StringUtils.isNotEmpty((String)httpMode) ? httpMode : "default";
    }

    public String getHttpMode_limit() {
        return this.httpMode_limit;
    }

    public void setHttpMode_limit(String httpMode_limit) {
        this.httpMode_limit = httpMode_limit != null && StringUtils.isNotEmpty((String)httpMode_limit) ? httpMode_limit : null;
    }

    public String getHttpMode_remaining() {
        return this.httpMode_remaining;
    }

    public void setHttpMode_remaining(String httpMode_remaining) {
        this.httpMode_remaining = httpMode_remaining != null && StringUtils.isNotEmpty((String)httpMode_remaining) ? httpMode_remaining : null;
    }

    public String getHttpMode_reset() {
        return this.httpMode_reset;
    }

    public void setHttpMode_reset(String httpMode_reset) {
        this.httpMode_reset = httpMode_reset != null && StringUtils.isNotEmpty((String)httpMode_reset) ? httpMode_reset : null;
    }

    public String getHttpMode_retry_after() {
        return this.httpMode_retry_after;
    }

    public void setHttpMode_retry_after(String httpMode_retry_after) {
        this.httpMode_retry_after = httpMode_retry_after != null && StringUtils.isNotEmpty((String)httpMode_retry_after) ? httpMode_retry_after : null;
    }

    public String getHttpMode_retry_after_backoff() {
        return this.httpMode_retry_after_backoff;
    }

    public void setHttpMode_retry_after_backoff(String httpMode_retry_after_backoff) {
        this.httpMode_retry_after_backoff = httpMode_retry_after_backoff != null && StringUtils.isNotEmpty((String)httpMode_retry_after_backoff) ? httpMode_retry_after_backoff : null;
    }

    public boolean isGestionePolicyRidefinita() {
        return this.gestionePolicyRidefinita;
    }

    public PolicyGroupByActiveThreadsType getType() {
        return this.type;
    }

    public boolean isLOCAL_DIVIDED_BY_NODES_remaining_zeroValue() {
        return this.LOCAL_DIVIDED_BY_NODES_remaining_zeroValue;
    }

    public boolean isLOCAL_DIVIDED_BY_NODES_limit_roundingDown() {
        return this.LOCAL_DIVIDED_BY_NODES_limit_roundingDown;
    }

    public boolean isLOCAL_DIVIDED_BY_NODES_limit_normalizedQuota() {
        return this.LOCAL_DIVIDED_BY_NODES_limit_normalizedQuota;
    }

    public boolean isGestioneHttpHeadersRidefinita() {
        return this.gestioneHttpHeadersRidefinita;
    }

    public boolean isDisabledHttpHeaders() {
        return this.disabledHttpHeaders;
    }

    public boolean isDisabledHttpHeaders_limit() {
        return this.disabledHttpHeaders_limit;
    }

    public boolean isForceHttpHeaders_limit_no_windows() {
        return this.forceHttpHeaders_limit_no_windows;
    }

    public boolean isForceHttpHeaders_limit_windows() {
        return this.forceHttpHeaders_limit_windows;
    }

    public boolean isDisabledHttpHeaders_remaining() {
        return this.disabledHttpHeaders_remaining;
    }

    public boolean isDisabledHttpHeaders_reset() {
        return this.disabledHttpHeaders_reset;
    }

    public boolean isDisabledHttpHeaders_retryAfter() {
        return this.disabledHttpHeaders_retryAfter;
    }

    public boolean isForceDisabledHttpHeaders_retryAfter_backoff() {
        return this.forceDisabledHttpHeaders_retryAfter_backoff;
    }

    public int getForceHttpHeaders_retryAfter_backoff() {
        return this.forceHttpHeaders_retryAfter_backoff;
    }
}

