/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.List;
import org.openspcoop2.core.byok.BYOKUtilities;
import org.openspcoop2.core.byok.BYOKWrappedValue;
import org.openspcoop2.core.byok.IDriverBYOK;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.config.Connettore;
import org.openspcoop2.core.config.Credenziali;
import org.openspcoop2.core.config.InvocazioneCredenziali;
import org.openspcoop2.core.config.InvocazionePorta;
import org.openspcoop2.core.config.InvocazionePortaGestioneErrore;
import org.openspcoop2.core.config.InvocazioneServizio;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.RispostaAsincrona;
import org.openspcoop2.core.config.Ruolo;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.CredenzialeTipo;
import org.openspcoop2.core.config.constants.TipologiaErogazione;
import org.openspcoop2.core.config.constants.TipologiaFruizione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBLib;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_connettoriLIB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_gestioneErroreLIB;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.utils.certificate.CertificateUtils;
import org.openspcoop2.utils.certificate.PrincipalType;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.jdbc.IJDBCAdapter;
import org.openspcoop2.utils.jdbc.JDBCAdapterFactory;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverConfigurazioneDB_serviziApplicativiLIB {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long CRUDServizioApplicativo(int type, ServizioApplicativo aSA, Connection con, IDriverBYOK driverBYOK) throws DriverConfigurazioneException {
        if (aSA == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDServizioApplicativo] Servizio Applicativo non valido.");
        }
        String nomeSA = aSA.getNome();
        String tipoProprietario = aSA.getTipoSoggettoProprietario();
        String nomeProprietario = aSA.getNomeSoggettoProprietario();
        if (nomeSA == null || nomeSA.equals("")) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDServizioApplicativo] Nome Servizio Applicativo non valido.");
        }
        if (tipoProprietario == null || tipoProprietario.equals("")) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDServizioApplicativo] Tipo Proprietario Servizio Applicativo non valido.");
        }
        if (nomeProprietario == null || nomeProprietario.equals("")) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDServizioApplicativo] Nome Proprietario Servizio Applicativo non valido.");
        }
        PreparedStatement stm = null;
        Statement stmQuery = null;
        ResultSet rs = null;
        Statement stm2 = null;
        int n = 0;
        try {
            String tipoSA = aSA.getTipo();
            int useAsClient = aSA.getUseAsClient() ? 1 : 0;
            String descrizione = aSA.getDescrizione();
            DriverConfigurazioneDBLib.logDebug("get ID Soggetto con tipo[" + tipoProprietario + "] e nome[" + nomeProprietario + "]");
            long idProprietario = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, DriverConfigurazioneDBLib.tipoDB, DriverConfigurazioneDBLib.tabellaSoggetti);
            DriverConfigurazioneDBLib.logDebug("get ID Soggetto con tipo[" + tipoProprietario + "] e nome[" + nomeProprietario + "] : " + idProprietario);
            InvocazionePorta invPorta = aSA.getInvocazionePorta();
            InvocazioneServizio invServizio = aSA.getInvocazioneServizio();
            RispostaAsincrona ricezione = aSA.getRispostaAsincrona();
            List<Proprieta> proprieta = aSA.getProprietaList();
            Connettore connettoreRisp = null;
            Connettore connettoreInv = null;
            long idConnettoreRisp = 0L;
            long idConnettoreInv = 0L;
            long idServizioApplicativo = 0L;
            Credenziali credenzialiInvocazionePorta = null;
            InvocazioneCredenziali credenzialiInvocazione = null;
            InvocazionePortaGestioneErrore gestErr = null;
            String fault = null;
            switch (type) {
                case 1: {
                    ISQLQueryObject sqlQueryObjectUpdate;
                    BYOKWrappedValue byokValue;
                    Connettore connettore;
                    String utenteRichiedente = null;
                    utenteRichiedente = aSA.getProprietaOggetto() != null && aSA.getProprietaOggetto().getUtenteRichiedente() != null ? aSA.getProprietaOggetto().getUtenteRichiedente() : DBUtils.getSuperUserSoggettoSafe(DriverConfigurazioneDBLib.log, "CRUDPortaApplicativa", idProprietario, con, DriverConfigurazioneDBLib.tipoDB, DriverConfigurazioneDBLib.tabellaSoggetti);
                    Timestamp dataCreazione = null;
                    dataCreazione = aSA.getProprietaOggetto() != null && aSA.getProprietaOggetto().getDataCreazione() != null ? new Timestamp(aSA.getProprietaOggetto().getDataCreazione().getTime()) : (aSA.getOraRegistrazione() != null ? new Timestamp(aSA.getOraRegistrazione().getTime()) : DateManager.getTimestamp());
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addInsertTable("servizi_applicativi");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("tipo", "?");
                    sqlQueryObject.addInsertField("as_client", "?");
                    sqlQueryObject.addInsertField("descrizione", "?");
                    sqlQueryObject.addInsertField("sbustamentorisp", "?");
                    sqlQueryObject.addInsertField("sbustamento_protocol_info_risp", "?");
                    sqlQueryObject.addInsertField("getmsgrisp", "?");
                    sqlQueryObject.addInsertField("tipoauthrisp", "?");
                    sqlQueryObject.addInsertField("utenterisp", "?");
                    sqlQueryObject.addInsertField("passwordrisp", "?");
                    sqlQueryObject.addInsertField("enc_passwordrisp", "?");
                    sqlQueryObject.addInsertField("id_connettore_risp", "?");
                    sqlQueryObject.addInsertField("sbustamentoinv", "?");
                    sqlQueryObject.addInsertField("sbustamento_protocol_info_inv", "?");
                    sqlQueryObject.addInsertField("getmsginv", "?");
                    sqlQueryObject.addInsertField("tipoauthinv", "?");
                    sqlQueryObject.addInsertField("utenteinv", "?");
                    sqlQueryObject.addInsertField("passwordinv", "?");
                    sqlQueryObject.addInsertField("enc_passwordinv", "?");
                    sqlQueryObject.addInsertField("id_connettore_inv", "?");
                    sqlQueryObject.addInsertField("id_soggetto", "?");
                    sqlQueryObject.addInsertField("fault", "?");
                    sqlQueryObject.addInsertField("tipoauth", "?");
                    sqlQueryObject.addInsertField("utente", "?");
                    sqlQueryObject.addInsertField("password", "?");
                    sqlQueryObject.addInsertField("subject", "?");
                    sqlQueryObject.addInsertField("cn_subject", "?");
                    sqlQueryObject.addInsertField("issuer", "?");
                    sqlQueryObject.addInsertField("cn_issuer", "?");
                    sqlQueryObject.addInsertField("certificate", "?");
                    sqlQueryObject.addInsertField("cert_strict_verification", "?");
                    sqlQueryObject.addInsertField("token_policy", "?");
                    sqlQueryObject.addInsertField("invio_x_rif_inv", "?");
                    sqlQueryObject.addInsertField("risposta_x_rif_inv", "?");
                    sqlQueryObject.addInsertField("invio_x_rif", "?");
                    sqlQueryObject.addInsertField("invio_x_rif_risp", "?");
                    sqlQueryObject.addInsertField("risposta_x_rif_risp", "?");
                    sqlQueryObject.addInsertField("sbustamento_protocol_info", "?");
                    sqlQueryObject.addInsertField("fault_actor", "?");
                    sqlQueryObject.addInsertField("generic_fault_code", "?");
                    sqlQueryObject.addInsertField("prefix_fault_code", "?");
                    sqlQueryObject.addInsertField("tipologia_fruizione", "?");
                    sqlQueryObject.addInsertField("tipologia_erogazione", "?");
                    if (utenteRichiedente != null) {
                        sqlQueryObject.addInsertField("utente_richiedente", "?");
                    }
                    if (dataCreazione != null) {
                        sqlQueryObject.addInsertField("data_creazione", "?");
                    }
                    String sqlQuery = sqlQueryObject.createSQLInsert();
                    stm = con.prepareStatement(sqlQuery);
                    connettoreRisp = new Connettore();
                    connettoreRisp.setNome("ConnettoreRISP_" + aSA.getNome() + "_" + aSA.getTipoSoggettoProprietario() + aSA.getNomeSoggettoProprietario());
                    connettoreRisp.setTipo(TipiConnettore.DISABILITATO.getNome());
                    idConnettoreRisp = DriverConfigurazioneDB_connettoriLIB.CRUDConnettore(1, connettoreRisp, con, driverBYOK);
                    if (ricezione != null && ricezione.getConnettore() != null) {
                        connettore = ricezione.getConnettore();
                        connettore.setId(idConnettoreRisp);
                        connettore.setNome(connettoreRisp.getNome());
                        DriverConfigurazioneDB_connettoriLIB.CRUDConnettore(2, connettore, con, driverBYOK);
                    }
                    connettoreInv = new Connettore();
                    connettoreInv.setNome("ConnettoreINV_" + aSA.getNome() + "_" + aSA.getTipoSoggettoProprietario() + aSA.getNomeSoggettoProprietario());
                    connettoreInv.setTipo(TipiConnettore.DISABILITATO.getNome());
                    idConnettoreInv = DriverConfigurazioneDB_connettoriLIB.CRUDConnettore(1, connettoreInv, con, driverBYOK);
                    if (invServizio != null && invServizio.getConnettore() != null) {
                        connettore = invServizio.getConnettore();
                        connettore.setId(idConnettoreInv);
                        connettore.setNome(connettoreInv.getNome());
                        DriverConfigurazioneDB_connettoriLIB.CRUDConnettore(2, connettore, con, driverBYOK);
                    }
                    int index = 1;
                    stm.setString(index++, nomeSA);
                    stm.setString(index++, tipoSA);
                    stm.setInt(index++, useAsClient);
                    stm.setString(index++, descrizione);
                    stm.setInt(index++, ricezione != null && CostantiConfigurazione.ABILITATO.equals(ricezione.getSbustamentoSoap()) ? 1 : 0);
                    stm.setInt(index++, ricezione != null && !CostantiConfigurazione.DISABILITATO.equals(ricezione.getSbustamentoInformazioniProtocollo()) ? 1 : 0);
                    stm.setString(index++, ricezione != null ? DriverConfigurazioneDBLib.getValue(ricezione.getGetMessage()) : null);
                    credenzialiInvocazione = ricezione != null ? ricezione.getCredenziali() : null;
                    stm.setString(index++, ricezione != null ? DriverConfigurazioneDBLib.getValue(ricezione.getAutenticazione()) : null);
                    stm.setString(index++, credenzialiInvocazione != null ? credenzialiInvocazione.getUser() : null);
                    String plainValue = credenzialiInvocazione != null ? credenzialiInvocazione.getPassword() : null;
                    String encValue = null;
                    if (driverBYOK != null && plainValue != null && (byokValue = driverBYOK.wrap(plainValue)) != null) {
                        encValue = byokValue.getWrappedValue();
                        plainValue = byokValue.getWrappedPlainValue();
                    }
                    stm.setString(index++, plainValue);
                    stm.setString(index++, encValue);
                    stm.setLong(index++, idConnettoreRisp);
                    stm.setInt(index++, invServizio != null && CostantiConfigurazione.ABILITATO.equals(invServizio.getSbustamentoSoap()) ? 1 : 0);
                    stm.setInt(index++, invServizio != null && !CostantiConfigurazione.DISABILITATO.equals(invServizio.getSbustamentoInformazioniProtocollo()) ? 1 : 0);
                    stm.setString(index++, invServizio != null ? DriverConfigurazioneDBLib.getValue(invServizio.getGetMessage()) : null);
                    credenzialiInvocazione = invServizio != null ? invServizio.getCredenziali() : null;
                    stm.setString(index++, invServizio != null ? DriverConfigurazioneDBLib.getValue(invServizio.getAutenticazione()) : null);
                    stm.setString(index++, credenzialiInvocazione != null ? credenzialiInvocazione.getUser() : null);
                    plainValue = credenzialiInvocazione != null ? credenzialiInvocazione.getPassword() : null;
                    encValue = null;
                    if (driverBYOK != null && plainValue != null && (byokValue = driverBYOK.wrap(plainValue)) != null) {
                        encValue = byokValue.getWrappedValue();
                        plainValue = byokValue.getWrappedPlainValue();
                    }
                    stm.setString(index++, plainValue);
                    stm.setString(index++, encValue);
                    stm.setLong(index++, idConnettoreInv);
                    stm.setLong(index++, idProprietario);
                    gestErr = invPorta != null ? invPorta.getGestioneErrore() : null;
                    fault = gestErr != null ? DriverConfigurazioneDBLib.getValue(gestErr.getFault()) : null;
                    stm.setString(index++, fault);
                    credenzialiInvocazionePorta = invPorta != null && invPorta.sizeCredenzialiList() > 0 ? invPorta.getCredenziali(0) : null;
                    stm.setString(index++, credenzialiInvocazionePorta != null ? DriverConfigurazioneDBLib.getValue(credenzialiInvocazionePorta.getTipo()) : null);
                    stm.setString(index++, credenzialiInvocazionePorta != null ? credenzialiInvocazionePorta.getUser() : null);
                    stm.setString(index++, credenzialiInvocazionePorta != null ? credenzialiInvocazionePorta.getPassword() : null);
                    String subject = null;
                    if (credenzialiInvocazionePorta != null && credenzialiInvocazionePorta.getSubject() != null && !"".equals(credenzialiInvocazionePorta.getSubject())) {
                        subject = credenzialiInvocazionePorta.getSubject();
                    }
                    stm.setString(index++, subject != null ? CertificateUtils.formatPrincipal(subject, (PrincipalType)PrincipalType.SUBJECT) : null);
                    String subjectCN = null;
                    if (credenzialiInvocazionePorta != null && credenzialiInvocazionePorta.getCnSubject() != null && !"".equals(credenzialiInvocazionePorta.getCnSubject())) {
                        subjectCN = credenzialiInvocazionePorta.getCnSubject();
                    }
                    stm.setString(index++, subjectCN);
                    String issuer = null;
                    if (credenzialiInvocazionePorta != null && CredenzialeTipo.APIKEY.equals(credenzialiInvocazionePorta.getTipo())) {
                        stm.setString(index++, CostantiDB.getIssuerApiKey(credenzialiInvocazionePorta.isAppId()));
                    } else {
                        if (credenzialiInvocazionePorta != null && credenzialiInvocazionePorta.getIssuer() != null && !"".equals(credenzialiInvocazionePorta.getIssuer())) {
                            issuer = credenzialiInvocazionePorta.getIssuer();
                        }
                        stm.setString(index++, issuer != null ? CertificateUtils.formatPrincipal(issuer, (PrincipalType)PrincipalType.ISSUER) : null);
                    }
                    String issuerCN = null;
                    if (credenzialiInvocazionePorta != null && credenzialiInvocazionePorta.getCnIssuer() != null && !"".equals(credenzialiInvocazionePorta.getCnIssuer())) {
                        issuerCN = credenzialiInvocazionePorta.getCnIssuer();
                    }
                    stm.setString(index++, issuerCN);
                    byte[] certificate = null;
                    if (credenzialiInvocazionePorta != null && credenzialiInvocazionePorta.getCertificate() != null) {
                        certificate = credenzialiInvocazionePorta.getCertificate();
                    }
                    IJDBCAdapter jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)DriverConfigurazioneDBLib.tipoDB);
                    jdbcAdapter.setBinaryData(stm, index++, certificate);
                    if (credenzialiInvocazionePorta != null && credenzialiInvocazionePorta.isCertificateStrictVerification()) {
                        stm.setInt(index++, 1);
                    } else {
                        stm.setInt(index++, 0);
                    }
                    stm.setString(index++, credenzialiInvocazionePorta != null ? credenzialiInvocazionePorta.getTokenPolicy() : null);
                    stm.setString(index++, invServizio != null ? DriverConfigurazioneDBLib.getValue(invServizio.getInvioPerRiferimento()) : null);
                    stm.setString(index++, invServizio != null ? DriverConfigurazioneDBLib.getValue(invServizio.getRispostaPerRiferimento()) : null);
                    stm.setString(index++, invPorta != null ? DriverConfigurazioneDBLib.getValue(invPorta.getInvioPerRiferimento()) : null);
                    stm.setString(index++, ricezione != null ? DriverConfigurazioneDBLib.getValue(ricezione.getInvioPerRiferimento()) : null);
                    stm.setString(index++, ricezione != null ? DriverConfigurazioneDBLib.getValue(ricezione.getRispostaPerRiferimento()) : null);
                    stm.setInt(index++, invPorta != null && !CostantiConfigurazione.DISABILITATO.equals(invPorta.getSbustamentoInformazioniProtocollo()) ? 1 : 0);
                    stm.setString(index++, gestErr != null ? gestErr.getFaultActor() : null);
                    stm.setString(index++, gestErr != null ? DriverConfigurazioneDBLib.getValue(gestErr.getGenericFaultCode()) : null);
                    stm.setString(index++, gestErr != null ? gestErr.getPrefixFaultCode() : null);
                    stm.setString(index++, aSA.getTipologiaFruizione() != null ? TipologiaFruizione.valueOf(aSA.getTipologiaFruizione().toUpperCase()).toString() : TipologiaFruizione.DISABILITATO.toString());
                    stm.setString(index++, aSA.getTipologiaErogazione() != null ? TipologiaErogazione.valueOf(aSA.getTipologiaErogazione().toUpperCase()).toString() : TipologiaErogazione.DISABILITATO.toString());
                    if (utenteRichiedente != null) {
                        stm.setString(index++, utenteRichiedente);
                    }
                    if (dataCreazione != null) {
                        stm.setTimestamp(index++, dataCreazione);
                    }
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Inserted " + n + " row(s)");
                    try {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addFromTable("servizi_applicativi");
                        sqlQueryObject.addSelectField("id");
                        sqlQueryObject.addWhereCondition("id_soggetto = ?");
                        sqlQueryObject.addWhereCondition("nome = ?");
                        sqlQueryObject.setANDLogicOperator(true);
                        sqlQuery = sqlQueryObject.createSQLQuery();
                        stmQuery = con.prepareStatement(sqlQuery);
                        stmQuery.setLong(1, idProprietario);
                        stmQuery.setString(2, nomeSA);
                        rs = stmQuery.executeQuery();
                        if (!rs.next()) throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDServizioApplicativo(CREATE)] Impossibile trovare il servizio appena creato.");
                        idServizioApplicativo = rs.getLong("id");
                        aSA.setId(idServizioApplicativo);
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (stmQuery != null) {
                            stmQuery.close();
                            stmQuery = null;
                        }
                    }
                    if (aSA.getRispostaAsincrona() != null && aSA.getRispostaAsincrona().getGestioneErrore() != null) {
                        DriverConfigurazioneDB_gestioneErroreLIB.CRUDGestioneErroreServizioApplicativo(1, aSA.getRispostaAsincrona().getGestioneErrore(), idProprietario, idServizioApplicativo, false, con);
                        try {
                            sqlQueryObjectUpdate = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObjectUpdate.addUpdateTable("servizi_applicativi");
                            sqlQueryObjectUpdate.addUpdateField("id_gestione_errore_risp", "?");
                            sqlQueryObjectUpdate.addWhereCondition("id = ?");
                            stm2 = con.prepareStatement(sqlQueryObjectUpdate.createSQLUpdate());
                            stm2.setLong(1, aSA.getRispostaAsincrona().getGestioneErrore().getId());
                            stm2.setLong(2, idServizioApplicativo);
                            stm2.executeUpdate();
                        }
                        finally {
                            if (stm2 != null) {
                                stm2.close();
                                stm2 = null;
                            }
                        }
                    }
                    if (aSA.getInvocazioneServizio() != null && aSA.getInvocazioneServizio().getGestioneErrore() != null) {
                        DriverConfigurazioneDB_gestioneErroreLIB.CRUDGestioneErroreServizioApplicativo(1, aSA.getInvocazioneServizio().getGestioneErrore(), idProprietario, idServizioApplicativo, true, con);
                        try {
                            sqlQueryObjectUpdate = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObjectUpdate.addUpdateTable("servizi_applicativi");
                            sqlQueryObjectUpdate.addUpdateField("id_gestione_errore_inv", "?");
                            sqlQueryObjectUpdate.addWhereCondition("id = ?");
                            stm2 = con.prepareStatement(sqlQueryObjectUpdate.createSQLUpdate());
                            stm2.setLong(1, aSA.getInvocazioneServizio().getGestioneErrore().getId());
                            stm2.setLong(2, idServizioApplicativo);
                            stm2.executeUpdate();
                        }
                        finally {
                            if (stm2 != null) {
                                stm2.close();
                                stm2 = null;
                            }
                        }
                    }
                    n = 0;
                    if (invPorta != null && invPorta.getRuoli() != null && invPorta.getRuoli().sizeRuoloList() > 0) {
                        for (int i = 0; i < invPorta.getRuoli().sizeRuoloList(); ++i) {
                            Ruolo ruolo = invPorta.getRuoli().getRuolo(i);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("sa_ruoli");
                            sqlQueryObject.addInsertField("id_servizio_applicativo", "?");
                            sqlQueryObject.addInsertField("ruolo", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, aSA.getId());
                            stm.setString(2, ruolo.getNome());
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunto ruolo[" + ruolo.getNome() + "] al servizioApplicativo " + idServizioApplicativo);
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunti " + n + " ruoli al servizioApplicativo " + idServizioApplicativo);
                    n = 0;
                    if (invPorta != null && invPorta.sizeCredenzialiList() > 1) {
                        for (int i = 1; i < invPorta.sizeCredenzialiList(); ++i) {
                            Credenziali credenziale = invPorta.getCredenziali(i);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("sa_credenziali");
                            sqlQueryObject.addInsertField("id_servizio_applicativo", "?");
                            sqlQueryObject.addInsertField("subject", "?");
                            sqlQueryObject.addInsertField("cn_subject", "?");
                            sqlQueryObject.addInsertField("issuer", "?");
                            sqlQueryObject.addInsertField("cn_issuer", "?");
                            sqlQueryObject.addInsertField("certificate", "?");
                            sqlQueryObject.addInsertField("cert_strict_verification", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            index = 1;
                            stm.setLong(index++, aSA.getId());
                            String subjectCredenziale = null;
                            if (credenziale != null && credenziale.getSubject() != null && !"".equals(credenziale.getSubject())) {
                                subjectCredenziale = credenziale.getSubject();
                            }
                            stm.setString(index++, subjectCredenziale != null ? CertificateUtils.formatPrincipal(subjectCredenziale, (PrincipalType)PrincipalType.SUBJECT) : null);
                            String subjectCredenzialeCN = null;
                            if (credenziale != null && credenziale.getCnSubject() != null && !"".equals(credenziale.getCnSubject())) {
                                subjectCredenzialeCN = credenziale.getCnSubject();
                            }
                            stm.setString(index++, subjectCredenzialeCN);
                            String issuerCredenziale = null;
                            if (credenziale != null && CredenzialeTipo.APIKEY.equals(credenziale.getTipo())) {
                                stm.setString(index++, CostantiDB.getIssuerApiKey(credenziale.isAppId()));
                            } else {
                                if (credenziale != null && credenziale.getIssuer() != null && !"".equals(credenziale.getIssuer())) {
                                    issuerCredenziale = credenziale.getIssuer();
                                }
                                stm.setString(index++, issuerCredenziale != null ? CertificateUtils.formatPrincipal(issuerCredenziale, (PrincipalType)PrincipalType.ISSUER) : null);
                            }
                            String issuerCredenzialeCN = null;
                            if (credenziale != null && credenziale.getCnIssuer() != null && !"".equals(credenziale.getCnIssuer())) {
                                issuerCredenzialeCN = credenziale.getCnIssuer();
                            }
                            stm.setString(index++, issuerCredenzialeCN);
                            byte[] certificateCredenziale = null;
                            if (credenziale != null && credenziale.getCertificate() != null) {
                                certificateCredenziale = credenziale.getCertificate();
                            }
                            jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)DriverConfigurazioneDBLib.tipoDB);
                            jdbcAdapter.setBinaryData(stm, index++, certificateCredenziale);
                            if (credenziale != null && credenziale.isCertificateStrictVerification()) {
                                stm.setInt(index++, 1);
                            } else {
                                stm.setInt(index++, 0);
                            }
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunta credenziale al servizioApplicativo " + idServizioApplicativo);
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunte " + n + " credenziali al servizioApplicativo " + idServizioApplicativo);
                    n = 0;
                    if (proprieta != null && !proprieta.isEmpty()) {
                        for (int i = 0; i < proprieta.size(); ++i) {
                            BYOKWrappedValue byokValue2;
                            Proprieta prop = proprieta.get(i);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("sa_properties");
                            sqlQueryObject.addInsertField("id_servizio_applicativo", "?");
                            sqlQueryObject.addInsertField("nome", "?");
                            sqlQueryObject.addInsertField("valore", "?");
                            sqlQueryObject.addInsertField("enc_value", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            int indexP = 1;
                            stm.setLong(indexP++, aSA.getId());
                            stm.setString(indexP++, prop.getNome());
                            String plainValueP = prop.getValore();
                            String encValueP = null;
                            if (driverBYOK != null && BYOKUtilities.isWrappedValue(plainValueP) && (byokValue2 = driverBYOK.wrap(plainValueP)) != null) {
                                encValueP = byokValue2.getWrappedValue();
                                plainValueP = byokValue2.getWrappedPlainValue();
                            }
                            stm.setString(indexP++, plainValueP);
                            stm.setString(indexP++, encValueP);
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunta proprieta' [" + prop.getNome() + "] al servizioApplicativo " + idServizioApplicativo);
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunte " + n + " proprieta' al servizioApplicativo " + idServizioApplicativo);
                    DriverConfigurazioneDBLib.crudProtocolProperty(1, aSA.getProtocolPropertyList(), idServizioApplicativo, ProprietariProtocolProperty.SERVIZIO_APPLICATIVO, con, DriverConfigurazioneDBLib.tipoDB, driverBYOK);
                    break;
                }
                case 2: {
                    BYOKWrappedValue byokValue;
                    long oldIdProprietario;
                    String oldNomeSA = null;
                    String oldNomeProprietario = null;
                    String oldTipoProprietario = null;
                    if (aSA.getOldIDServizioApplicativoForUpdate() != null) {
                        oldNomeSA = aSA.getOldIDServizioApplicativoForUpdate().getNome();
                        if (aSA.getOldIDServizioApplicativoForUpdate().getIdSoggettoProprietario() != null) {
                            oldNomeProprietario = aSA.getOldIDServizioApplicativoForUpdate().getIdSoggettoProprietario().getNome();
                            oldTipoProprietario = aSA.getOldIDServizioApplicativoForUpdate().getIdSoggettoProprietario().getTipo();
                        }
                    }
                    if (oldNomeSA == null || oldNomeSA.equals("")) {
                        oldNomeSA = nomeSA;
                    }
                    if (oldNomeProprietario == null || oldNomeProprietario.equals("")) {
                        oldNomeProprietario = nomeProprietario;
                    }
                    if (oldTipoProprietario == null || oldTipoProprietario.equals("")) {
                        oldTipoProprietario = tipoProprietario;
                    }
                    if ((oldIdProprietario = DBUtils.getIdSoggetto(oldNomeProprietario, oldTipoProprietario, con, DriverConfigurazioneDBLib.tipoDB, DriverConfigurazioneDBLib.tabellaSoggetti)) <= 0L) {
                        oldIdProprietario = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, DriverConfigurazioneDBLib.tipoDB, DriverConfigurazioneDBLib.tabellaSoggetti);
                    }
                    if (oldIdProprietario <= 0L) {
                        throw new DriverConfigurazioneException("Impossibile recuperare l'id del Soggetto Proprietario del Servizio Applicativo");
                    }
                    String utenteUltimaModifica = null;
                    if (aSA.getProprietaOggetto() != null && aSA.getProprietaOggetto().getUtenteUltimaModifica() != null) {
                        utenteUltimaModifica = aSA.getProprietaOggetto().getUtenteUltimaModifica();
                    }
                    Timestamp dataUltimaModifica = null;
                    dataUltimaModifica = aSA.getProprietaOggetto() != null && aSA.getProprietaOggetto().getDataUltimaModifica() != null ? new Timestamp(aSA.getProprietaOggetto().getDataUltimaModifica().getTime()) : DateManager.getTimestamp();
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addUpdateTable("servizi_applicativi");
                    sqlQueryObject.addUpdateField("tipo", "?");
                    sqlQueryObject.addUpdateField("as_client", "?");
                    sqlQueryObject.addUpdateField("descrizione", "?");
                    sqlQueryObject.addUpdateField("sbustamentorisp", "?");
                    sqlQueryObject.addUpdateField("sbustamento_protocol_info_risp", "?");
                    sqlQueryObject.addUpdateField("getmsgrisp", "?");
                    sqlQueryObject.addUpdateField("tipoauthrisp", "?");
                    sqlQueryObject.addUpdateField("utenterisp", "?");
                    sqlQueryObject.addUpdateField("passwordrisp", "?");
                    sqlQueryObject.addUpdateField("enc_passwordrisp", "?");
                    sqlQueryObject.addUpdateField("id_connettore_risp", "?");
                    sqlQueryObject.addUpdateField("sbustamentoinv", "?");
                    sqlQueryObject.addUpdateField("sbustamento_protocol_info_inv", "?");
                    sqlQueryObject.addUpdateField("getmsginv", "?");
                    sqlQueryObject.addUpdateField("tipoauthinv", "?");
                    sqlQueryObject.addUpdateField("utenteinv", "?");
                    sqlQueryObject.addUpdateField("passwordinv", "?");
                    sqlQueryObject.addUpdateField("enc_passwordinv", "?");
                    sqlQueryObject.addUpdateField("id_connettore_inv", "?");
                    sqlQueryObject.addUpdateField("fault", "?");
                    sqlQueryObject.addUpdateField("tipoauth", "?");
                    sqlQueryObject.addUpdateField("utente", "?");
                    sqlQueryObject.addUpdateField("password", "?");
                    sqlQueryObject.addUpdateField("subject", "?");
                    sqlQueryObject.addUpdateField("cn_subject", "?");
                    sqlQueryObject.addUpdateField("issuer", "?");
                    sqlQueryObject.addUpdateField("cn_issuer", "?");
                    sqlQueryObject.addUpdateField("certificate", "?");
                    sqlQueryObject.addUpdateField("cert_strict_verification", "?");
                    sqlQueryObject.addUpdateField("token_policy", "?");
                    sqlQueryObject.addUpdateField("invio_x_rif_inv", "?");
                    sqlQueryObject.addUpdateField("risposta_x_rif_inv", "?");
                    sqlQueryObject.addUpdateField("invio_x_rif", "?");
                    sqlQueryObject.addUpdateField("invio_x_rif_risp", "?");
                    sqlQueryObject.addUpdateField("risposta_x_rif_risp", "?");
                    sqlQueryObject.addUpdateField("sbustamento_protocol_info", "?");
                    sqlQueryObject.addUpdateField("fault_actor", "?");
                    sqlQueryObject.addUpdateField("generic_fault_code", "?");
                    sqlQueryObject.addUpdateField("prefix_fault_code", "?");
                    sqlQueryObject.addUpdateField("nome", "?");
                    sqlQueryObject.addUpdateField("id_soggetto", "?");
                    if (aSA.getRispostaAsincrona() != null && aSA.getRispostaAsincrona().getGestioneErrore() != null) {
                        sqlQueryObject.addUpdateField("id_gestione_errore_risp", "?");
                    }
                    if (aSA.getInvocazioneServizio() != null && aSA.getInvocazioneServizio().getGestioneErrore() != null) {
                        sqlQueryObject.addUpdateField("id_gestione_errore_inv", "?");
                    }
                    sqlQueryObject.addUpdateField("tipologia_fruizione", "?");
                    sqlQueryObject.addUpdateField("tipologia_erogazione", "?");
                    if (utenteUltimaModifica != null) {
                        sqlQueryObject.addUpdateField("utente_ultima_modifica", "?");
                    }
                    if (dataUltimaModifica != null) {
                        sqlQueryObject.addUpdateField("data_ultima_modifica", "?");
                    }
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQueryObject.addWhereCondition("nome=?");
                    sqlQueryObject.addWhereCondition("id_soggetto=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String sqlQuery = sqlQueryObject.createSQLUpdate();
                    stm = con.prepareStatement(sqlQuery);
                    idServizioApplicativo = DriverConfigurazioneDB_serviziApplicativiLIB.getIdServizioApplicativo(oldNomeSA, oldTipoProprietario, oldNomeProprietario, con, DriverConfigurazioneDBLib.tipoDB, DriverConfigurazioneDBLib.tabellaSoggetti);
                    if (idServizioApplicativo <= 0L) {
                        idServizioApplicativo = DriverConfigurazioneDB_serviziApplicativiLIB.getIdServizioApplicativo(oldNomeSA, tipoProprietario, nomeProprietario, con, DriverConfigurazioneDBLib.tipoDB, DriverConfigurazioneDBLib.tabellaSoggetti);
                    }
                    if (idServizioApplicativo <= 0L) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDServizioApplicativo(UPDATE)] ID del ServizioApplicativo necessario per l'aggiornamento.");
                    }
                    RispostaAsincrona rispAsin = aSA.getRispostaAsincrona();
                    connettoreRisp = rispAsin != null ? rispAsin.getConnettore() : new Connettore();
                    String newNomeConnettoreRisp = "ConnettoreRISP_" + nomeSA + "_" + tipoProprietario + nomeProprietario;
                    idConnettoreRisp = DriverConfigurazioneDB_connettoriLIB.getIdConnettoreSARISP(idServizioApplicativo, con);
                    InvocazioneServizio invServ = aSA.getInvocazioneServizio();
                    connettoreInv = invServ != null ? invServizio.getConnettore() : new Connettore();
                    String newNomeConnettoreInv = "ConnettoreINV_" + nomeSA + "_" + tipoProprietario + nomeProprietario;
                    idConnettoreInv = DriverConfigurazioneDB_connettoriLIB.getIdConnettoreSAINV(idServizioApplicativo, con);
                    if (idConnettoreInv <= 0L || idConnettoreRisp <= 0L) {
                        throw new DriverConfigurazioneException("I connettori del servizio applicativo sono invalidi");
                    }
                    String nomeConnettoreRisp = DriverConfigurazioneDB_connettoriLIB.getConnettore(idConnettoreRisp, con, null).getNome();
                    String nomeConnettoreInv = DriverConfigurazioneDB_connettoriLIB.getConnettore(idConnettoreInv, con, null).getNome();
                    String pattern = "Aggiorno Connettore [{0}] : id [{1}] oldNome [{2}] newNome [{2}]";
                    DriverConfigurazioneDBLib.logDebug(MessageFormat.format(pattern, "Risposta Asincrona", idConnettoreRisp, nomeConnettoreRisp, newNomeConnettoreRisp));
                    connettoreRisp.setNome(newNomeConnettoreRisp);
                    connettoreRisp.setId(idConnettoreRisp);
                    DriverConfigurazioneDB_connettoriLIB.CRUDConnettore(2, connettoreRisp, con, driverBYOK);
                    DriverConfigurazioneDBLib.logDebug(MessageFormat.format(pattern, "Invocazione Servizio", idConnettoreInv, nomeConnettoreInv, newNomeConnettoreInv));
                    connettoreInv.setNome(newNomeConnettoreInv);
                    connettoreInv.setId(idConnettoreInv);
                    DriverConfigurazioneDB_connettoriLIB.CRUDConnettore(2, connettoreInv, con, driverBYOK);
                    int index = 1;
                    stm.setString(index++, tipoSA);
                    stm.setInt(index++, useAsClient);
                    stm.setString(index++, descrizione);
                    stm.setInt(index++, ricezione != null && CostantiConfigurazione.ABILITATO.equals(ricezione.getSbustamentoSoap()) ? 1 : 0);
                    stm.setInt(index++, ricezione != null && !CostantiConfigurazione.DISABILITATO.equals(ricezione.getSbustamentoInformazioniProtocollo()) ? 1 : 0);
                    stm.setString(index++, ricezione != null ? DriverConfigurazioneDBLib.getValue(ricezione.getGetMessage()) : null);
                    credenzialiInvocazione = ricezione != null ? ricezione.getCredenziali() : null;
                    stm.setString(index++, ricezione != null ? DriverConfigurazioneDBLib.getValue(ricezione.getAutenticazione()) : null);
                    stm.setString(index++, credenzialiInvocazione != null ? credenzialiInvocazione.getUser() : null);
                    String plainValue = credenzialiInvocazione != null ? credenzialiInvocazione.getPassword() : null;
                    String encValue = null;
                    if (driverBYOK != null && plainValue != null && (byokValue = driverBYOK.wrap(plainValue)) != null) {
                        encValue = byokValue.getWrappedValue();
                        plainValue = byokValue.getWrappedPlainValue();
                    }
                    stm.setString(index++, plainValue);
                    stm.setString(index++, encValue);
                    stm.setLong(index++, idConnettoreRisp);
                    stm.setInt(index++, invServizio != null && CostantiConfigurazione.ABILITATO.equals(invServizio.getSbustamentoSoap()) ? 1 : 0);
                    stm.setInt(index++, invServizio != null && !CostantiConfigurazione.DISABILITATO.equals(invServizio.getSbustamentoInformazioniProtocollo()) ? 1 : 0);
                    stm.setString(index++, invServizio != null ? DriverConfigurazioneDBLib.getValue(invServizio.getGetMessage()) : null);
                    credenzialiInvocazione = invServizio != null ? invServizio.getCredenziali() : null;
                    stm.setString(index++, invServizio != null ? DriverConfigurazioneDBLib.getValue(invServizio.getAutenticazione()) : null);
                    stm.setString(index++, credenzialiInvocazione != null ? credenzialiInvocazione.getUser() : null);
                    plainValue = credenzialiInvocazione != null ? credenzialiInvocazione.getPassword() : null;
                    encValue = null;
                    if (driverBYOK != null && plainValue != null && (byokValue = driverBYOK.wrap(plainValue)) != null) {
                        encValue = byokValue.getWrappedValue();
                        plainValue = byokValue.getWrappedPlainValue();
                    }
                    stm.setString(index++, plainValue);
                    stm.setString(index++, encValue);
                    stm.setLong(index++, idConnettoreInv);
                    gestErr = invPorta != null ? invPorta.getGestioneErrore() : null;
                    fault = gestErr != null ? DriverConfigurazioneDBLib.getValue(gestErr.getFault()) : null;
                    stm.setString(index++, fault);
                    credenzialiInvocazionePorta = invPorta != null && invPorta.sizeCredenzialiList() > 0 ? invPorta.getCredenziali(0) : null;
                    stm.setString(index++, credenzialiInvocazionePorta != null ? DriverConfigurazioneDBLib.getValue(credenzialiInvocazionePorta.getTipo()) : null);
                    stm.setString(index++, credenzialiInvocazionePorta != null ? credenzialiInvocazionePorta.getUser() : null);
                    stm.setString(index++, credenzialiInvocazionePorta != null ? credenzialiInvocazionePorta.getPassword() : null);
                    String subject = null;
                    if (credenzialiInvocazionePorta != null && credenzialiInvocazionePorta.getSubject() != null && !"".equals(credenzialiInvocazionePorta.getSubject())) {
                        subject = credenzialiInvocazionePorta.getSubject();
                    }
                    stm.setString(index++, subject != null ? CertificateUtils.formatPrincipal(subject, (PrincipalType)PrincipalType.SUBJECT) : null);
                    String subjectCN = null;
                    if (credenzialiInvocazionePorta != null && credenzialiInvocazionePorta.getCnSubject() != null && !"".equals(credenzialiInvocazionePorta.getCnSubject())) {
                        subjectCN = credenzialiInvocazionePorta.getCnSubject();
                    }
                    stm.setString(index++, subjectCN);
                    String issuer = null;
                    if (credenzialiInvocazionePorta != null && CredenzialeTipo.APIKEY.equals(credenzialiInvocazionePorta.getTipo())) {
                        stm.setString(index++, CostantiDB.getIssuerApiKey(credenzialiInvocazionePorta.isAppId()));
                    } else {
                        if (credenzialiInvocazionePorta != null && credenzialiInvocazionePorta.getIssuer() != null && !"".equals(credenzialiInvocazionePorta.getIssuer())) {
                            issuer = credenzialiInvocazionePorta.getIssuer();
                        }
                        stm.setString(index++, issuer != null ? CertificateUtils.formatPrincipal(issuer, (PrincipalType)PrincipalType.ISSUER) : null);
                    }
                    String issuerCN = null;
                    if (credenzialiInvocazionePorta != null && credenzialiInvocazionePorta.getCnIssuer() != null && !"".equals(credenzialiInvocazionePorta.getCnIssuer())) {
                        issuerCN = credenzialiInvocazionePorta.getCnIssuer();
                    }
                    stm.setString(index++, issuerCN);
                    byte[] certificate = null;
                    if (credenzialiInvocazionePorta != null && credenzialiInvocazionePorta.getCertificate() != null) {
                        certificate = credenzialiInvocazionePorta.getCertificate();
                    }
                    IJDBCAdapter jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)DriverConfigurazioneDBLib.tipoDB);
                    jdbcAdapter.setBinaryData(stm, index++, certificate);
                    if (credenzialiInvocazionePorta != null && credenzialiInvocazionePorta.isCertificateStrictVerification()) {
                        stm.setInt(index++, 1);
                    } else {
                        stm.setInt(index++, 0);
                    }
                    stm.setString(index++, credenzialiInvocazionePorta != null ? credenzialiInvocazionePorta.getTokenPolicy() : null);
                    stm.setString(index++, invServizio != null ? DriverConfigurazioneDBLib.getValue(invServizio.getInvioPerRiferimento()) : null);
                    stm.setString(index++, invServizio != null ? DriverConfigurazioneDBLib.getValue(invServizio.getRispostaPerRiferimento()) : null);
                    stm.setString(index++, invPorta != null ? DriverConfigurazioneDBLib.getValue(invPorta.getInvioPerRiferimento()) : null);
                    stm.setString(index++, ricezione != null ? DriverConfigurazioneDBLib.getValue(ricezione.getInvioPerRiferimento()) : null);
                    stm.setString(index++, ricezione != null ? DriverConfigurazioneDBLib.getValue(ricezione.getRispostaPerRiferimento()) : null);
                    stm.setInt(index++, invPorta != null && !CostantiConfigurazione.DISABILITATO.equals(invPorta.getSbustamentoInformazioniProtocollo()) ? 1 : 0);
                    stm.setString(index++, gestErr != null ? gestErr.getFaultActor() : null);
                    stm.setString(index++, gestErr != null ? DriverConfigurazioneDBLib.getValue(gestErr.getGenericFaultCode()) : null);
                    stm.setString(index++, gestErr != null ? gestErr.getPrefixFaultCode() : null);
                    stm.setString(index++, nomeSA);
                    stm.setLong(index++, idProprietario < 0L ? oldIdProprietario : idProprietario);
                    if (aSA.getRispostaAsincrona() != null && aSA.getRispostaAsincrona().getGestioneErrore() != null) {
                        DriverConfigurazioneDB_gestioneErroreLIB.CRUDGestioneErroreServizioApplicativo(2, aSA.getRispostaAsincrona().getGestioneErrore(), idProprietario, idServizioApplicativo, false, con);
                        stm.setLong(index++, aSA.getRispostaAsincrona().getGestioneErrore().getId());
                    }
                    if (aSA.getInvocazioneServizio() != null && aSA.getInvocazioneServizio().getGestioneErrore() != null) {
                        DriverConfigurazioneDB_gestioneErroreLIB.CRUDGestioneErroreServizioApplicativo(2, aSA.getInvocazioneServizio().getGestioneErrore(), idProprietario, idServizioApplicativo, true, con);
                        stm.setLong(index++, aSA.getInvocazioneServizio().getGestioneErrore().getId());
                    }
                    stm.setString(index++, aSA.getTipologiaFruizione() != null ? TipologiaFruizione.valueOf(aSA.getTipologiaFruizione().toUpperCase()).toString() : TipologiaFruizione.DISABILITATO.toString());
                    stm.setString(index++, aSA.getTipologiaErogazione() != null ? TipologiaErogazione.valueOf(aSA.getTipologiaErogazione().toUpperCase()).toString() : TipologiaErogazione.DISABILITATO.toString());
                    if (utenteUltimaModifica != null) {
                        stm.setString(index++, utenteUltimaModifica);
                    }
                    if (dataUltimaModifica != null) {
                        stm.setTimestamp(index++, dataUltimaModifica);
                    }
                    stm.setLong(index++, idServizioApplicativo);
                    stm.setString(index++, oldNomeSA);
                    stm.setLong(index++, oldIdProprietario);
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Updated " + n + " row(s)");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("sa_ruoli");
                    sqlQueryObject.addWhereCondition("id_servizio_applicativo=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, aSA.getId());
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellati " + n + " ruoli associati al servizioApplicativo " + idServizioApplicativo);
                    n = 0;
                    if (invPorta != null && invPorta.getRuoli() != null && invPorta.getRuoli().sizeRuoloList() > 0) {
                        for (int i = 0; i < invPorta.getRuoli().sizeRuoloList(); ++i) {
                            Ruolo ruolo = invPorta.getRuoli().getRuolo(i);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("sa_ruoli");
                            sqlQueryObject.addInsertField("id_servizio_applicativo", "?");
                            sqlQueryObject.addInsertField("ruolo", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, aSA.getId());
                            stm.setString(2, ruolo.getNome());
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunto ruolo[" + ruolo.getNome() + "] al servizioApplicativo " + idServizioApplicativo);
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunti " + n + " ruoli al servizioApplicativo " + idServizioApplicativo);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("sa_credenziali");
                    sqlQueryObject.addWhereCondition("id_servizio_applicativo=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, aSA.getId());
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellate " + n + " credenziali associate al servizioApplicativo " + idServizioApplicativo);
                    n = 0;
                    if (invPorta != null && invPorta.sizeCredenzialiList() > 1) {
                        for (int i = 1; i < invPorta.sizeCredenzialiList(); ++i) {
                            Credenziali credenziale = invPorta.getCredenziali(i);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("sa_credenziali");
                            sqlQueryObject.addInsertField("id_servizio_applicativo", "?");
                            sqlQueryObject.addInsertField("subject", "?");
                            sqlQueryObject.addInsertField("cn_subject", "?");
                            sqlQueryObject.addInsertField("issuer", "?");
                            sqlQueryObject.addInsertField("cn_issuer", "?");
                            sqlQueryObject.addInsertField("certificate", "?");
                            sqlQueryObject.addInsertField("cert_strict_verification", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            index = 1;
                            stm.setLong(index++, aSA.getId());
                            String subjectCredenziale = null;
                            if (credenziale != null && credenziale.getSubject() != null && !"".equals(credenziale.getSubject())) {
                                subjectCredenziale = credenziale.getSubject();
                            }
                            stm.setString(index++, subjectCredenziale != null ? CertificateUtils.formatPrincipal(subjectCredenziale, (PrincipalType)PrincipalType.SUBJECT) : null);
                            String subjectCredenzialeCN = null;
                            if (credenziale != null && credenziale.getCnSubject() != null && !"".equals(credenziale.getCnSubject())) {
                                subjectCredenzialeCN = credenziale.getCnSubject();
                            }
                            stm.setString(index++, subjectCredenzialeCN);
                            String issuerCredenziale = null;
                            if (credenziale != null && CredenzialeTipo.APIKEY.equals(credenziale.getTipo())) {
                                stm.setString(index++, CostantiDB.getIssuerApiKey(credenziale.isAppId()));
                            } else {
                                if (credenziale != null && credenziale.getIssuer() != null && !"".equals(credenziale.getIssuer())) {
                                    issuerCredenziale = credenziale.getIssuer();
                                }
                                stm.setString(index++, issuerCredenziale != null ? CertificateUtils.formatPrincipal(issuerCredenziale, (PrincipalType)PrincipalType.ISSUER) : null);
                            }
                            String issuerCredenzialeCN = null;
                            if (credenziale != null && credenziale.getCnIssuer() != null && !"".equals(credenziale.getCnIssuer())) {
                                issuerCredenzialeCN = credenziale.getCnIssuer();
                            }
                            stm.setString(index++, issuerCredenzialeCN);
                            byte[] certificateCredenziale = null;
                            if (credenziale != null && credenziale.getCertificate() != null) {
                                certificateCredenziale = credenziale.getCertificate();
                            }
                            jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)DriverConfigurazioneDBLib.tipoDB);
                            jdbcAdapter.setBinaryData(stm, index++, certificateCredenziale);
                            if (credenziale != null && credenziale.isCertificateStrictVerification()) {
                                stm.setInt(index++, 1);
                            } else {
                                stm.setInt(index++, 0);
                            }
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunta credenziale al servizioApplicativo " + idServizioApplicativo);
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunte " + n + " credenziali al servizioApplicativo " + idServizioApplicativo);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("sa_properties");
                    sqlQueryObject.addWhereCondition("id_servizio_applicativo=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, aSA.getId());
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Cancellate " + n + " proprieta' associate al servizioApplicativo " + idServizioApplicativo);
                    n = 0;
                    if (proprieta != null && !proprieta.isEmpty()) {
                        for (int i = 0; i < proprieta.size(); ++i) {
                            BYOKWrappedValue byokValue3;
                            Proprieta prop = proprieta.get(i);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addInsertTable("sa_properties");
                            sqlQueryObject.addInsertField("id_servizio_applicativo", "?");
                            sqlQueryObject.addInsertField("nome", "?");
                            sqlQueryObject.addInsertField("valore", "?");
                            sqlQueryObject.addInsertField("enc_value", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            int indexP = 1;
                            stm.setLong(indexP++, aSA.getId());
                            stm.setString(indexP++, prop.getNome());
                            String plainValueP = prop.getValore();
                            String encValueP = null;
                            if (driverBYOK != null && BYOKUtilities.isWrappedValue(plainValueP) && (byokValue3 = driverBYOK.wrap(plainValueP)) != null) {
                                encValueP = byokValue3.getWrappedValue();
                                plainValueP = byokValue3.getWrappedPlainValue();
                            }
                            stm.setString(indexP++, plainValueP);
                            stm.setString(indexP++, encValueP);
                            stm.executeUpdate();
                            stm.close();
                            ++n;
                            DriverConfigurazioneDBLib.logDebug("Aggiunta proprieta' [" + prop.getNome() + "] al servizioApplicativo " + idServizioApplicativo);
                        }
                    }
                    DriverConfigurazioneDBLib.logDebug("Aggiunte " + n + " proprieta' al servizioApplicativo " + idServizioApplicativo);
                    DriverConfigurazioneDBLib.crudProtocolProperty(2, aSA.getProtocolPropertyList(), idServizioApplicativo, ProprietariProtocolProperty.SERVIZIO_APPLICATIVO, con, DriverConfigurazioneDBLib.tipoDB, driverBYOK);
                    break;
                }
                case 3: {
                    DriverConfigurazioneDBLib.logDebug("get ID Servizio Applicativo con nome[" + nomeSA + "] tipoProprietario[" + tipoProprietario + "] nomeProprietario[" + nomeProprietario + "]");
                    idServizioApplicativo = DriverConfigurazioneDB_serviziApplicativiLIB.getIdServizioApplicativo(nomeSA, tipoProprietario, nomeProprietario, con, DriverConfigurazioneDBLib.tipoDB, DriverConfigurazioneDBLib.tabellaSoggetti);
                    DriverConfigurazioneDBLib.logDebug("get ID Servizio Applicativo: " + idServizioApplicativo);
                    DriverConfigurazioneDBLib.crudProtocolProperty(3, null, idServizioApplicativo, ProprietariProtocolProperty.SERVIZIO_APPLICATIVO, con, DriverConfigurazioneDBLib.tipoDB, driverBYOK);
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("sa_properties");
                    sqlQueryObject.addWhereCondition("id_servizio_applicativo=?");
                    String sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idServizioApplicativo);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        DriverConfigurazioneDBLib.logDebug("Deleted " + n + " proprieta' associate al ServizioApplicativo[" + idServizioApplicativo + "]");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("sa_credenziali");
                    sqlQueryObject.addWhereCondition("id_servizio_applicativo=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idServizioApplicativo);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        DriverConfigurazioneDBLib.logDebug("Deleted " + n + " credenziali associate al ServizioApplicativo[" + idServizioApplicativo + "]");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("sa_ruoli");
                    sqlQueryObject.addWhereCondition("id_servizio_applicativo=?");
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idServizioApplicativo);
                    n = stm.executeUpdate();
                    stm.close();
                    if (n > 0) {
                        DriverConfigurazioneDBLib.logDebug("Deleted " + n + " ruoli associati al ServizioApplicativo[" + idServizioApplicativo + "]");
                    }
                    DriverConfigurazioneDBLib.logDebug("Deleted ...");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("servizi_applicativi");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQueryObject.addWhereCondition("nome=?");
                    sqlQueryObject.addWhereCondition("id_soggetto=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idServizioApplicativo);
                    stm.setString(2, nomeSA);
                    stm.setLong(3, idProprietario);
                    DriverConfigurazioneDBLib.logDebug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idServizioApplicativo, nomeSA, idProprietario));
                    n = stm.executeUpdate();
                    stm.close();
                    DriverConfigurazioneDBLib.logDebug("Deleted " + n + " row(s)");
                    DriverConfigurazioneDBLib.logDebug("Recupero connettore asincrono ...");
                    if (aSA.getRispostaAsincrona() != null && aSA.getRispostaAsincrona().getConnettore() != null) {
                        connettoreRisp = aSA.getRispostaAsincrona().getConnettore();
                    } else {
                        connettoreRisp = new Connettore();
                        connettoreRisp.setTipo(TipiConnettore.DISABILITATO.getNome());
                    }
                    String nomeConnettoreRisp = "ConnettoreRISP_" + aSA.getNome() + "_" + aSA.getTipoSoggettoProprietario() + aSA.getNomeSoggettoProprietario();
                    connettoreRisp.setNome(nomeConnettoreRisp);
                    idConnettoreRisp = DBUtils.getIdConnettore(nomeConnettoreRisp, con, DriverConfigurazioneDBLib.tipoDB);
                    DriverConfigurazioneDBLib.logDebug("Recupero connettore asincrono id[" + idConnettoreRisp + "]");
                    connettoreRisp.setId(idConnettoreRisp);
                    DriverConfigurazioneDBLib.logDebug("Recupero connettore invocazione servizio ...");
                    if (aSA.getInvocazioneServizio() != null && aSA.getInvocazioneServizio().getConnettore() != null) {
                        connettoreInv = aSA.getInvocazioneServizio().getConnettore();
                    } else {
                        connettoreInv = new Connettore();
                        connettoreInv.setTipo(TipiConnettore.DISABILITATO.getNome());
                    }
                    String nomeConnettoreInv = "ConnettoreINV_" + aSA.getNome() + "_" + aSA.getTipoSoggettoProprietario() + aSA.getNomeSoggettoProprietario();
                    connettoreInv.setNome(nomeConnettoreInv);
                    idConnettoreInv = DBUtils.getIdConnettore(nomeConnettoreInv, con, DriverConfigurazioneDBLib.tipoDB);
                    DriverConfigurazioneDBLib.logDebug("Recupero connettore invocazione servizio id[" + idConnettoreInv + "]");
                    connettoreInv.setId(idConnettoreInv);
                    if (idConnettoreInv <= 0L || idConnettoreRisp <= 0L) {
                        throw new DriverConfigurazioneException("I connettori del servizio applicativo sono invalidi");
                    }
                    DriverConfigurazioneDBLib.logDebug("Delete connettore asincrono ...");
                    DriverConfigurazioneDB_connettoriLIB.CRUDConnettore(3, connettoreRisp, con, driverBYOK);
                    DriverConfigurazioneDBLib.logDebug("Delete connettore invocazione servizio ...");
                    DriverConfigurazioneDB_connettoriLIB.CRUDConnettore(3, connettoreInv, con, driverBYOK);
                    if (aSA.getRispostaAsincrona() != null && aSA.getRispostaAsincrona().getGestioneErrore() != null) {
                        DriverConfigurazioneDB_gestioneErroreLIB.CRUDGestioneErroreServizioApplicativo(3, aSA.getRispostaAsincrona().getGestioneErrore(), idProprietario, idServizioApplicativo, false, con);
                    }
                    if (aSA.getInvocazioneServizio() == null || aSA.getInvocazioneServizio().getGestioneErrore() == null) break;
                    DriverConfigurazioneDB_gestioneErroreLIB.CRUDGestioneErroreServizioApplicativo(3, aSA.getInvocazioneServizio().getGestioneErrore(), idProprietario, idServizioApplicativo, true, con);
                }
            }
            long l = idServizioApplicativo;
            return l;
        }
        catch (DriverConfigurazioneException e) {
            throw e;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("SQLException : " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("Exception : " + se.getMessage(), se);
        }
        finally {
            JDBCUtilities.closeResources(rs, stmQuery);
            JDBCUtilities.closeResources(stm);
            JDBCUtilities.closeResources(stm2);
        }
    }

    public static long getIdServizioApplicativo(String nomeServizioApplicativo, String tipoProprietario, String nomeProprietario, Connection con, String tipoDB) throws CoreException {
        return DriverConfigurazioneDB_serviziApplicativiLIB.getIdServizioApplicativo(nomeServizioApplicativo, tipoProprietario, nomeProprietario, con, tipoDB, "soggetti");
    }

    public static long getIdServizioApplicativo(String nomeServizioApplicativo, String tipoProprietario, String nomeProprietario, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idServizioApplicativo = -1L;
        try {
            long idSoggetto = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, tipoDB, tabellaSoggetti);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            stm.setString(2, nomeServizioApplicativo);
            rs = stm.executeQuery();
            if (rs.next()) {
                idServizioApplicativo = rs.getLong("id");
            }
            l = idServizioApplicativo;
        }
        catch (Exception e) {
            try {
                throw new CoreException(e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }
}

