/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.TrasformazioneRegola;
import org.openspcoop2.core.config.TrasformazioneRegolaApplicabilitaRichiesta;
import org.openspcoop2.core.config.TrasformazioneRegolaApplicabilitaRisposta;
import org.openspcoop2.core.config.TrasformazioneRegolaApplicabilitaServizioApplicativo;
import org.openspcoop2.core.config.TrasformazioneRegolaApplicabilitaSoggetto;
import org.openspcoop2.core.config.TrasformazioneRegolaParametro;
import org.openspcoop2.core.config.TrasformazioneRegolaRichiesta;
import org.openspcoop2.core.config.TrasformazioneRegolaRisposta;
import org.openspcoop2.core.config.TrasformazioneRest;
import org.openspcoop2.core.config.TrasformazioneSoap;
import org.openspcoop2.core.config.TrasformazioneSoapRisposta;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBLib;
import org.openspcoop2.utils.jdbc.IJDBCAdapter;
import org.openspcoop2.utils.jdbc.JDBCAdapterFactory;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverConfigurazioneDB_porteTrasformazioniDriver {
    private DriverConfigurazioneDB driver = null;

    protected DriverConfigurazioneDB_porteTrasformazioniDriver(DriverConfigurazioneDB driver) {
        this.driver = driver;
    }

    protected List<TrasformazioneRegola> porteDelegateTrasformazioniList(long idPA, ISearch ricerca) throws DriverConfigurazioneException {
        int idLista = Liste.PORTE_DELEGATE_TRASFORMAZIONI;
        String nomeMetodo = "porteDelegateTrasformazioniList";
        boolean delegata = true;
        return this.getEngineTrasformazioniList(idPA, ricerca, idLista, nomeMetodo, delegata);
    }

    protected List<TrasformazioneRegola> porteApplicativeTrasformazioniList(long idPA, ISearch ricerca) throws DriverConfigurazioneException {
        int idLista = Liste.PORTE_APPLICATIVE_TRASFORMAZIONI;
        String nomeMetodo = "porteApplicativeTrasformazioniList";
        boolean delegata = false;
        return this.getEngineTrasformazioniList(idPA, ricerca, idLista, nomeMetodo, delegata);
    }

    private List<TrasformazioneRegola> getEngineTrasformazioniList(long idPA, ISearch ricerca, int idLista, String nomeMetodo, boolean portaDelegata) throws DriverConfigurazioneException {
        String nomeTabella;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        PreparedStatement stm1 = null;
        ResultSet rs1 = null;
        PreparedStatement stm0 = null;
        ResultSet rs0 = null;
        String string = nomeTabella = portaDelegata ? "pd_transform" : "pa_transform";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        ArrayList<TrasformazioneRegola> lista = new ArrayList<TrasformazioneRegola>();
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addSelectCountField(nomeTabella + ".id", "cont");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=?");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPA);
            rs = stmt.executeQuery();
            if (rs.next()) {
                ricerca.setNumEntries(idLista, rs.getInt(1));
            }
            rs.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addSelectField("id_porta");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("posizione");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=?");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy(nomeTabella + ".posizione");
            sqlQueryObject.addOrderBy(nomeTabella + ".nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPA);
            rs = stmt.executeQuery();
            ArrayList<Long> idTrasformazione = new ArrayList<Long>();
            while (rs.next()) {
                idTrasformazione.add(rs.getLong("id"));
            }
            rs.close();
            stmt.close();
            if (idTrasformazione != null && !idTrasformazione.isEmpty()) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable(nomeTabella);
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addWhereCondition("id = ?");
                queryString = sqlQueryObject.createSQLQuery();
                for (Long idLongTrasformazione : idTrasformazione) {
                    stmt = con.prepareStatement(queryString);
                    stmt.setLong(1, idLongTrasformazione);
                    rs = stmt.executeQuery();
                    if (rs.next()) {
                        String sqlQuery;
                        int trasformazione_soap;
                        TrasformazioneRegola regola = new TrasformazioneRegola();
                        String nome = rs.getString("nome");
                        regola.setNome(nome);
                        int posizione = rs.getInt("posizione");
                        regola.setPosizione(posizione);
                        StatoFunzionalita stato = DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs.getString("stato"));
                        regola.setStato(stato);
                        String applicabilita_azioni = rs.getString("applicabilita_azioni");
                        String applicabilita_ct = rs.getString("applicabilita_ct");
                        String applicabilita_pattern = rs.getString("applicabilita_pattern");
                        String applicabilita_connettori = rs.getString("applicabilita_connettori");
                        if (applicabilita_azioni != null && !"".equals(applicabilita_azioni) || applicabilita_ct != null && !"".equals(applicabilita_ct) || applicabilita_pattern != null && !"".equals(applicabilita_pattern) || applicabilita_connettori != null && !"".equals(applicabilita_connettori)) {
                            int i;
                            String[] tmp;
                            TrasformazioneRegolaApplicabilitaRichiesta applicabilita = new TrasformazioneRegolaApplicabilitaRichiesta();
                            if (applicabilita_azioni != null && !"".equals(applicabilita_azioni)) {
                                if (applicabilita_azioni.contains(",")) {
                                    tmp = applicabilita_azioni.split(",");
                                    for (i = 0; i < tmp.length; ++i) {
                                        applicabilita.addAzione(tmp[i].trim());
                                    }
                                } else {
                                    applicabilita.addAzione(applicabilita_azioni);
                                }
                            }
                            if (applicabilita_ct != null && !"".equals(applicabilita_ct)) {
                                if (applicabilita_ct.contains(",")) {
                                    tmp = applicabilita_ct.split(",");
                                    for (i = 0; i < tmp.length; ++i) {
                                        applicabilita.addContentType(tmp[i].trim());
                                    }
                                } else {
                                    applicabilita.addContentType(applicabilita_ct);
                                }
                            }
                            if (applicabilita_pattern != null && !"".equals(applicabilita_pattern)) {
                                applicabilita.setPattern(applicabilita_pattern);
                            }
                            if (applicabilita_connettori != null && !"".equals(applicabilita_connettori)) {
                                if (applicabilita_connettori.contains(",")) {
                                    tmp = applicabilita_connettori.split(",");
                                    for (i = 0; i < tmp.length; ++i) {
                                        applicabilita.addConnettore(tmp[i].trim());
                                    }
                                } else {
                                    applicabilita.addConnettore(applicabilita_connettori);
                                }
                            }
                            regola.setApplicabilita(applicabilita);
                        }
                        TrasformazioneRegolaRichiesta richiesta = new TrasformazioneRegolaRichiesta();
                        int req_conversione_enabled = rs.getInt("req_conversione_enabled");
                        if (1 == req_conversione_enabled) {
                            richiesta.setConversione(true);
                        } else {
                            richiesta.setConversione(false);
                        }
                        richiesta.setConversioneTipo(rs.getString("req_conversione_tipo"));
                        IJDBCAdapter jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)this.driver.tipoDB);
                        richiesta.setConversioneTemplate(jdbcAdapter.getBinaryData(rs, "req_conversione_template"));
                        richiesta.setContentType(rs.getString("req_content_type"));
                        int trasformazione_rest = rs.getInt("rest_transformation");
                        if (1 == trasformazione_rest) {
                            TrasformazioneRest trasformazioneRest = new TrasformazioneRest();
                            trasformazioneRest.setMetodo(rs.getString("rest_method"));
                            trasformazioneRest.setPath(rs.getString("rest_path"));
                            richiesta.setTrasformazioneRest(trasformazioneRest);
                        }
                        if (1 == (trasformazione_soap = rs.getInt("soap_transformation"))) {
                            TrasformazioneSoap trasformazioneSoap = new TrasformazioneSoap();
                            trasformazioneSoap.setVersione(DriverConfigurazioneDBLib.getEnumVersioneSOAP(rs.getString("soap_version")));
                            trasformazioneSoap.setSoapAction(rs.getString("soap_action"));
                            int envelope = rs.getInt("soap_envelope");
                            if (1 == envelope) {
                                trasformazioneSoap.setEnvelope(true);
                            } else {
                                trasformazioneSoap.setEnvelope(false);
                            }
                            int envelope_as_attach = rs.getInt("soap_envelope_as_attach");
                            if (1 == envelope_as_attach) {
                                trasformazioneSoap.setEnvelopeAsAttachment(true);
                                trasformazioneSoap.setEnvelopeBodyConversioneTipo(rs.getString("soap_envelope_tipo"));
                                trasformazioneSoap.setEnvelopeBodyConversioneTemplate(jdbcAdapter.getBinaryData(rs, "soap_envelope_template"));
                            } else {
                                trasformazioneSoap.setEnvelopeAsAttachment(false);
                            }
                            richiesta.setTrasformazioneSoap(trasformazioneSoap);
                        }
                        regola.setId(rs.getLong("id"));
                        regola.setRichiesta(richiesta);
                        if (!portaDelegata) {
                            nomeTabella = "pa_transform_soggetti";
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                            sqlQueryObject.addFromTable(nomeTabella);
                            sqlQueryObject.addSelectField("*");
                            sqlQueryObject.addWhereCondition("id_trasformazione=?");
                            sqlQuery = sqlQueryObject.createSQLQuery();
                            stm0 = con.prepareStatement(sqlQuery);
                            stm0.setLong(1, regola.getId());
                            rs0 = stm0.executeQuery();
                            while (rs0.next()) {
                                if (regola.getApplicabilita() == null) {
                                    regola.setApplicabilita(new TrasformazioneRegolaApplicabilitaRichiesta());
                                }
                                TrasformazioneRegolaApplicabilitaSoggetto soggetto = new TrasformazioneRegolaApplicabilitaSoggetto();
                                soggetto.setTipo(rs0.getString("tipo_soggetto"));
                                soggetto.setNome(rs0.getString("nome_soggetto"));
                                regola.getApplicabilita().addSoggetto(soggetto);
                            }
                            rs0.close();
                            stm0.close();
                        }
                        nomeTabella = portaDelegata ? "pd_transform_sa" : "pa_transform_sa";
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                        sqlQueryObject.addFromTable(nomeTabella);
                        sqlQueryObject.addSelectField("*");
                        sqlQueryObject.addWhereCondition("id_trasformazione=?");
                        sqlQuery = sqlQueryObject.createSQLQuery();
                        stm0 = con.prepareStatement(sqlQuery);
                        stm0.setLong(1, regola.getId());
                        rs0 = stm0.executeQuery();
                        while (rs0.next()) {
                            long idSA = rs0.getLong("id_servizio_applicativo");
                            if (idSA == 0L) continue;
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                            sqlQueryObject.addFromTable("servizi_applicativi");
                            sqlQueryObject.addFromTable("soggetti");
                            sqlQueryObject.addSelectField("nome");
                            sqlQueryObject.addSelectField("tipo_soggetto");
                            sqlQueryObject.addSelectField("nome_soggetto");
                            sqlQueryObject.addWhereCondition("servizi_applicativi.id=?");
                            sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto=soggetti.id");
                            sqlQueryObject.setANDLogicOperator(true);
                            sqlQuery = sqlQueryObject.createSQLQuery();
                            stm1 = con.prepareStatement(sqlQuery);
                            stm1.setLong(1, idSA);
                            this.driver.logDebug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idSA));
                            rs1 = stm1.executeQuery();
                            TrasformazioneRegolaApplicabilitaServizioApplicativo servizioApplicativo = null;
                            if (rs1.next()) {
                                servizioApplicativo = new TrasformazioneRegolaApplicabilitaServizioApplicativo();
                                servizioApplicativo.setId(idSA);
                                servizioApplicativo.setNome(rs1.getString("nome"));
                                servizioApplicativo.setTipoSoggettoProprietario(rs1.getString("tipo_soggetto"));
                                servizioApplicativo.setNomeSoggettoProprietario(rs1.getString("nome_soggetto"));
                                if (regola.getApplicabilita() == null) {
                                    regola.setApplicabilita(new TrasformazioneRegolaApplicabilitaRichiesta());
                                }
                                regola.getApplicabilita().addServizioApplicativo(servizioApplicativo);
                            }
                            rs1.close();
                            stm1.close();
                        }
                        rs0.close();
                        stm0.close();
                        lista.add(regola);
                    }
                    rs.close();
                    stmt.close();
                }
            }
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs1, stm1);
                JDBCUtilities.closeResources(rs0, stm0);
                JDBCUtilities.closeResources(rs, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources(rs1, stm1);
        JDBCUtilities.closeResources(rs0, stm0);
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return lista;
    }

    protected boolean azioneUsataInTrasformazioniPortaDelegata(String azione) throws DriverConfigurazioneException {
        return this.azioneUsataInTrasformazioni(azione, true);
    }

    protected boolean azioneUsataInTrasformazioniPortaApplicativa(String azione) throws DriverConfigurazioneException {
        return this.azioneUsataInTrasformazioni(azione, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean azioneUsataInTrasformazioni(String azione, boolean portaDelegata) throws DriverConfigurazioneException {
        block14: {
            block13: {
                nomeMetodo = "azioneUsataInTrasformazioni";
                con = null;
                stmt = null;
                rs = null;
                v0 = nomeTabella = portaDelegata != false ? "pd_transform" : "pa_transform";
                if (this.driver.atomica) {
                    try {
                        con = this.driver.getConnectionFromDatasource(nomeMetodo);
                    }
                    catch (Exception e) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
                    }
                } else {
                    con = this.driver.globalConnection;
                }
                this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
                try {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObject.addFromTable(nomeTabella);
                    sqlQueryObject.addSelectField("applicabilita_azioni");
                    sqlQueryObject.addWhereLikeCondition("applicabilita_azioni", azione, false, true, false);
                    sqlQueryObject.setANDLogicOperator(true);
                    stmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
                    rs = stmt.executeQuery();
lbl25:
                    // 4 sources

                    while (rs.next()) {
                        checkAz = rs.getString("applicabilita_azioni");
                        if (checkAz == null) continue;
                        if (azione.equals(checkAz)) {
                            var10_13 = true;
                            break block13;
                        }
                        ** GOTO lbl-1000
                    }
                    break block14;
                }
                catch (Exception qe) {
                    try {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
                    }
                    catch (Throwable var13_16) {
                        JDBCUtilities.closeResources(rs, stmt);
                        this.driver.closeConnection(con);
                        throw var13_16;
                    }
                }
            }
            JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stmt);
            this.driver.closeConnection(con);
            return var10_13;
lbl-1000:
            // 1 sources

            {
                if (!checkAz.contains(",") || (tmp = checkAz.split(",")) == null || tmp.length <= 0) ** GOTO lbl25
                for (i = 0; i < tmp.length; ++i) {
                    if (!azione.equals(tmp[i])) continue;
                    var12_15 = true;
                }
                ** GOTO lbl25
            }
            {
                JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stmt);
                this.driver.closeConnection(con);
                return var12_15;
                {
                    break;
                }
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return false;
    }

    protected TrasformazioneRegola getPortaApplicativaTrasformazione(long idPorta, String azioni, String pattern, String contentType, String connettori, List<TrasformazioneRegolaApplicabilitaSoggetto> soggetti, List<TrasformazioneRegolaApplicabilitaServizioApplicativo> applicativi, boolean interpretaNullList) throws DriverConfigurazioneException {
        String nomeMetodo = "getPortaApplicativaTrasformazione";
        boolean delegata = false;
        return this.getEngineTrasformazione(idPorta, azioni, pattern, contentType, connettori, soggetti, applicativi, nomeMetodo, delegata, interpretaNullList);
    }

    protected TrasformazioneRegola getPortaDelegataTrasformazione(long idPorta, String azioni, String pattern, String contentType, String connettori, List<TrasformazioneRegolaApplicabilitaServizioApplicativo> applicativi) throws DriverConfigurazioneException {
        String nomeMetodo = "getPortaDelegataTrasformazione";
        boolean delegata = true;
        return this.getEngineTrasformazione(idPorta, azioni, pattern, contentType, connettori, null, applicativi, nomeMetodo, delegata, true);
    }

    private TrasformazioneRegola getEngineTrasformazione(long idPorta, String azioni, String pattern, String contentType, String connettori, List<TrasformazioneRegolaApplicabilitaSoggetto> soggetti, List<TrasformazioneRegolaApplicabilitaServizioApplicativo> applicativi, String nomeMetodo, boolean portaDelegata, boolean interpretaNullList) throws DriverConfigurazioneException {
        TrasformazioneRegola trasformazioneRegola;
        String nomeTabellaSA;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        String nomeTabella = portaDelegata ? "pd_transform" : "pa_transform";
        String nomeTabellaSoggetti = "pa_transform_soggetti";
        String string = nomeTabellaSA = portaDelegata ? "pd_transform_sa" : "pa_transform_sa";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        TrasformazioneRegola regola = null;
        try {
            StringBuilder bf;
            ArrayList<String> conditions;
            ISQLQueryObject sqlQueryObjectExists;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("id_porta = ?");
            if (azioni != null) {
                sqlQueryObject.addWhereLikeCondition("applicabilita_azioni", azioni, false, false);
            } else {
                sqlQueryObject.addWhereIsNullCondition("applicabilita_azioni");
            }
            if (pattern != null) {
                sqlQueryObject.addWhereLikeCondition("applicabilita_pattern", pattern, false, false);
            } else {
                sqlQueryObject.addWhereIsNullCondition("applicabilita_pattern");
            }
            if (contentType != null) {
                sqlQueryObject.addWhereLikeCondition("applicabilita_ct", contentType, false, false);
            } else {
                sqlQueryObject.addWhereIsNullCondition("applicabilita_ct");
            }
            if (connettori != null) {
                sqlQueryObject.addWhereLikeCondition("applicabilita_connettori", connettori, false, false);
            } else {
                sqlQueryObject.addWhereIsNullCondition("applicabilita_connettori");
            }
            if (!portaDelegata) {
                if (soggetti == null || soggetti.isEmpty()) {
                    if (interpretaNullList) {
                        sqlQueryObjectExists = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                        sqlQueryObjectExists.addFromTable(nomeTabellaSoggetti);
                        sqlQueryObjectExists.addSelectField("id_trasformazione");
                        sqlQueryObjectExists.setANDLogicOperator(true);
                        sqlQueryObjectExists.addWhereCondition("id_trasformazione=" + nomeTabella + ".id");
                        sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectExists);
                    }
                } else {
                    sqlQueryObject.addFromTable(nomeTabellaSoggetti);
                    sqlQueryObject.addWhereCondition(nomeTabellaSoggetti + ".id_trasformazione=" + nomeTabella + ".id");
                    conditions = new ArrayList<String>();
                    for (TrasformazioneRegolaApplicabilitaSoggetto trasformazioneRegolaApplicabilitaSoggetto : soggetti) {
                        bf = new StringBuilder();
                        bf.append("( ");
                        bf.append(nomeTabellaSoggetti).append(".tipo_soggetto=?");
                        bf.append(" AND ");
                        bf.append(nomeTabellaSoggetti).append(".nome_soggetto=?");
                        bf.append(") ");
                        conditions.add(bf.toString());
                    }
                    sqlQueryObject.addWhereCondition(false, conditions.toArray(new String[1]));
                }
            }
            if (applicativi == null || applicativi.isEmpty()) {
                if (interpretaNullList) {
                    sqlQueryObjectExists = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObjectExists.addFromTable(nomeTabellaSA);
                    sqlQueryObjectExists.addSelectField("id_trasformazione");
                    sqlQueryObjectExists.setANDLogicOperator(true);
                    sqlQueryObjectExists.addWhereCondition("id_trasformazione=" + nomeTabella + ".id");
                    sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectExists);
                }
            } else {
                sqlQueryObject.addFromTable(nomeTabellaSA);
                sqlQueryObject.addWhereCondition(nomeTabellaSA + ".id_trasformazione=" + nomeTabella + ".id");
                conditions = new ArrayList();
                for (TrasformazioneRegolaApplicabilitaServizioApplicativo trasformazioneRegolaApplicabilitaSA : applicativi) {
                    bf = new StringBuilder();
                    bf.append("( ");
                    bf.append(nomeTabellaSA).append(".id_servizio_applicativo=?");
                    bf.append(") ");
                    conditions.add(bf.toString());
                }
                sqlQueryObject.addWhereCondition(false, conditions.toArray(new String[1]));
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int parameterIndex = 1;
            stmt.setLong(parameterIndex++, idPorta);
            if (!portaDelegata && soggetti != null && !soggetti.isEmpty()) {
                for (TrasformazioneRegolaApplicabilitaSoggetto trasformazioneRegolaApplicabilitaSoggetto : soggetti) {
                    stmt.setString(parameterIndex++, trasformazioneRegolaApplicabilitaSoggetto.getTipo());
                    stmt.setString(parameterIndex++, trasformazioneRegolaApplicabilitaSoggetto.getNome());
                }
            }
            if (applicativi != null && !applicativi.isEmpty()) {
                for (TrasformazioneRegolaApplicabilitaServizioApplicativo trasformazioneRegolaApplicabilitaSA : applicativi) {
                    long idSA = DBUtils.getIdServizioApplicativo(trasformazioneRegolaApplicabilitaSA.getNome(), trasformazioneRegolaApplicabilitaSA.getTipoSoggettoProprietario(), trasformazioneRegolaApplicabilitaSA.getNomeSoggettoProprietario(), con, this.driver.tipoDB);
                    stmt.setLong(parameterIndex++, idSA);
                }
            }
            if ((risultato = stmt.executeQuery()).next()) {
                regola = this.getEngineTrasformazione(risultato);
            }
            risultato.close();
            stmt.close();
            trasformazioneRegola = regola;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return trasformazioneRegola;
    }

    protected TrasformazioneRegola getPortaApplicativaTrasformazione(long idPorta, String nome) throws DriverConfigurazioneException {
        String nomeMetodo = "getPortaApplicativaTrasformazione";
        boolean delegata = false;
        return this.getEngineTrasformazione(idPorta, nome, nomeMetodo, delegata);
    }

    protected TrasformazioneRegola getPortaDelegataTrasformazione(long idPorta, String nome) throws DriverConfigurazioneException {
        String nomeMetodo = "getPortaDelegataTrasformazione";
        boolean delegata = true;
        return this.getEngineTrasformazione(idPorta, nome, nomeMetodo, delegata);
    }

    private TrasformazioneRegola getEngineTrasformazione(long idPorta, String nome, String nomeMetodo, boolean portaDelegata) throws DriverConfigurazioneException {
        TrasformazioneRegola trasformazioneRegola;
        String nomeTabella;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        String string = nomeTabella = portaDelegata ? "pd_transform" : "pa_transform";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        TrasformazioneRegola regola = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("id_porta = ?");
            sqlQueryObject.addWhereCondition("nome = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int parameterIndex = 1;
            stmt.setLong(parameterIndex++, idPorta);
            stmt.setString(parameterIndex++, nome);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                regola = this.getEngineTrasformazione(risultato);
            }
            risultato.close();
            stmt.close();
            trasformazioneRegola = regola;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return trasformazioneRegola;
    }

    private TrasformazioneRegola getEngineTrasformazione(ResultSet risultato) throws Exception {
        int trasformazione_soap;
        TrasformazioneRegola regola = new TrasformazioneRegola();
        StatoFunzionalita stato = DriverConfigurazioneDBLib.getEnumStatoFunzionalita(risultato.getString("stato"));
        regola.setStato(stato);
        String applicabilita_azioni = risultato.getString("applicabilita_azioni");
        String applicabilita_ct = risultato.getString("applicabilita_ct");
        String applicabilita_pattern = risultato.getString("applicabilita_pattern");
        String applicabilita_connettori = risultato.getString("applicabilita_connettori");
        if (applicabilita_azioni != null && !"".equals(applicabilita_azioni) || applicabilita_ct != null && !"".equals(applicabilita_ct) || applicabilita_pattern != null && !"".equals(applicabilita_pattern) || applicabilita_connettori != null && !"".equals(applicabilita_connettori)) {
            int i;
            String[] tmp;
            TrasformazioneRegolaApplicabilitaRichiesta applicabilita = new TrasformazioneRegolaApplicabilitaRichiesta();
            if (applicabilita_azioni != null && !"".equals(applicabilita_azioni)) {
                if (applicabilita_azioni.contains(",")) {
                    tmp = applicabilita_azioni.split(",");
                    for (i = 0; i < tmp.length; ++i) {
                        applicabilita.addAzione(tmp[i].trim());
                    }
                } else {
                    applicabilita.addAzione(applicabilita_azioni);
                }
            }
            if (applicabilita_ct != null && !"".equals(applicabilita_ct)) {
                if (applicabilita_ct.contains(",")) {
                    tmp = applicabilita_ct.split(",");
                    for (i = 0; i < tmp.length; ++i) {
                        applicabilita.addContentType(tmp[i].trim());
                    }
                } else {
                    applicabilita.addContentType(applicabilita_ct);
                }
            }
            if (applicabilita_pattern != null && !"".equals(applicabilita_pattern)) {
                applicabilita.setPattern(applicabilita_pattern);
            }
            if (applicabilita_connettori != null && !"".equals(applicabilita_connettori)) {
                if (applicabilita_connettori.contains(",")) {
                    tmp = applicabilita_connettori.split(",");
                    for (i = 0; i < tmp.length; ++i) {
                        applicabilita.addConnettore(tmp[i].trim());
                    }
                } else {
                    applicabilita.addConnettore(applicabilita_connettori);
                }
            }
            regola.setApplicabilita(applicabilita);
        }
        TrasformazioneRegolaRichiesta richiesta = new TrasformazioneRegolaRichiesta();
        int req_conversione_enabled = risultato.getInt("req_conversione_enabled");
        if (1 == req_conversione_enabled) {
            richiesta.setConversione(true);
        } else {
            richiesta.setConversione(false);
        }
        richiesta.setConversioneTipo(risultato.getString("req_conversione_tipo"));
        IJDBCAdapter jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)this.driver.tipoDB);
        richiesta.setConversioneTemplate(jdbcAdapter.getBinaryData(risultato, "req_conversione_template"));
        richiesta.setContentType(risultato.getString("req_content_type"));
        int trasformazione_rest = risultato.getInt("rest_transformation");
        if (1 == trasformazione_rest) {
            TrasformazioneRest trasformazioneRest = new TrasformazioneRest();
            trasformazioneRest.setMetodo(risultato.getString("rest_method"));
            trasformazioneRest.setPath(risultato.getString("rest_path"));
            richiesta.setTrasformazioneRest(trasformazioneRest);
        }
        if (1 == (trasformazione_soap = risultato.getInt("soap_transformation"))) {
            TrasformazioneSoap trasformazioneSoap = new TrasformazioneSoap();
            trasformazioneSoap.setVersione(DriverConfigurazioneDBLib.getEnumVersioneSOAP(risultato.getString("soap_version")));
            trasformazioneSoap.setSoapAction(risultato.getString("soap_action"));
            int envelope = risultato.getInt("soap_envelope");
            if (1 == envelope) {
                trasformazioneSoap.setEnvelope(true);
            } else {
                trasformazioneSoap.setEnvelope(false);
            }
            int envelope_as_attach = risultato.getInt("soap_envelope_as_attach");
            if (1 == envelope_as_attach) {
                trasformazioneSoap.setEnvelopeAsAttachment(true);
                trasformazioneSoap.setEnvelopeBodyConversioneTipo(risultato.getString("soap_envelope_tipo"));
                trasformazioneSoap.setEnvelopeBodyConversioneTemplate(jdbcAdapter.getBinaryData(risultato, "soap_envelope_template"));
            } else {
                trasformazioneSoap.setEnvelopeAsAttachment(false);
            }
            richiesta.setTrasformazioneSoap(trasformazioneSoap);
        }
        regola.setId(risultato.getLong("id"));
        regola.setRichiesta(richiesta);
        return regola;
    }

    protected boolean existsPortaApplicativaTrasformazione(long idPorta, String azioni, String pattern, String contentType, String connettori) throws DriverConfigurazioneException {
        String nomeMetodo = "existsPortaApplicativaTrasformazione";
        boolean delegata = false;
        return this._existsTrasformazione(idPorta, azioni, pattern, contentType, connettori, nomeMetodo, delegata);
    }

    protected boolean existsPortaDelegataTrasformazione(long idPorta, String azioni, String pattern, String contentType, String connettori) throws DriverConfigurazioneException {
        String nomeMetodo = "existsPortaDelegataTrasformazione";
        boolean delegata = true;
        return this._existsTrasformazione(idPorta, azioni, pattern, contentType, connettori, nomeMetodo, delegata);
    }

    private boolean _existsTrasformazione(long idPorta, String azioni, String pattern, String contentType, String connettori, String nomeMetodo, boolean portaDelegata) throws DriverConfigurazioneException {
        boolean bl;
        String nomeTabella;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        String string = nomeTabella = portaDelegata ? "pd_transform" : "pa_transform";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            int count = 0;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addSelectCountField(nomeTabella + ".id", "cont");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("id_porta = ?");
            if (azioni != null) {
                sqlQueryObject.addWhereLikeCondition("applicabilita_azioni", azioni, false, false);
            } else {
                sqlQueryObject.addWhereIsNullCondition("applicabilita_azioni");
            }
            if (pattern != null) {
                sqlQueryObject.addWhereLikeCondition("applicabilita_pattern", pattern, false, false);
            } else {
                sqlQueryObject.addWhereIsNullCondition("applicabilita_pattern");
            }
            if (contentType != null) {
                sqlQueryObject.addWhereLikeCondition("applicabilita_ct", contentType, false, false);
            } else {
                sqlQueryObject.addWhereIsNullCondition("applicabilita_ct");
            }
            if (connettori != null) {
                sqlQueryObject.addWhereLikeCondition("applicabilita_connettori", connettori, false, false);
            } else {
                sqlQueryObject.addWhereIsNullCondition("applicabilita_connettori");
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int parameterIndex = 1;
            stmt.setLong(parameterIndex++, idPorta);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                count = risultato.getInt(1);
            }
            risultato.close();
            stmt.close();
            bl = count > 0;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return bl;
    }

    protected boolean existsPortaApplicativaTrasformazione(long idPorta, String nome) throws DriverConfigurazioneException {
        String nomeMetodo = "existsPortaApplicativaTrasformazione";
        boolean delegata = false;
        return this._existsTrasformazione(idPorta, nome, nomeMetodo, delegata);
    }

    protected boolean existsPortaDelegataTrasformazione(long idPorta, String nome) throws DriverConfigurazioneException {
        String nomeMetodo = "existsPortaDelegataTrasformazione";
        boolean delegata = true;
        return this._existsTrasformazione(idPorta, nome, nomeMetodo, delegata);
    }

    private boolean _existsTrasformazione(long idPorta, String nome, String nomeMetodo, boolean portaDelegata) throws DriverConfigurazioneException {
        boolean bl;
        String nomeTabella;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        String string = nomeTabella = portaDelegata ? "pd_transform" : "pa_transform";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            int count = 0;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addSelectCountField(nomeTabella + ".id", "cont");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("id_porta = ?");
            sqlQueryObject.addWhereCondition("nome = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int parameterIndex = 1;
            stmt.setLong(parameterIndex++, idPorta);
            stmt.setString(parameterIndex++, nome);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                count = risultato.getInt(1);
            }
            risultato.close();
            stmt.close();
            bl = count > 0;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return bl;
    }

    protected List<TrasformazioneRegolaRisposta> porteDelegateTrasformazioniRispostaList(long idPD, long idTrasformazione, ISearch ricerca) throws DriverConfigurazioneException {
        int idLista = Liste.PORTE_DELEGATE_TRASFORMAZIONI_RISPOSTE;
        String nomeMetodo = "porteDelegateTrasformazioniRispostaList";
        boolean delegata = true;
        return this.getEngineTrasformazioniRispostaList(idPD, idTrasformazione, ricerca, idLista, nomeMetodo, delegata);
    }

    protected List<TrasformazioneRegolaRisposta> porteApplicativeTrasformazioniRispostaList(long idPA, long idTrasformazione, ISearch ricerca) throws DriverConfigurazioneException {
        int idLista = Liste.PORTE_APPLICATIVE_TRASFORMAZIONI_RISPOSTE;
        String nomeMetodo = "porteApplicativeTrasformazioniRispostaList";
        boolean delegata = false;
        return this.getEngineTrasformazioniRispostaList(idPA, idTrasformazione, ricerca, idLista, nomeMetodo, delegata);
    }

    private List<TrasformazioneRegolaRisposta> getEngineTrasformazioniRispostaList(long idPA, long idTrasformazione, ISearch ricerca, int idLista, String nomeMetodo, boolean portaDelegata) throws DriverConfigurazioneException {
        String nomeTabellaRisposta;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String nomeTabella = portaDelegata ? "pd_transform" : "pa_transform";
        String string = nomeTabellaRisposta = portaDelegata ? "pd_transform_risp" : "pa_transform_risp";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        ArrayList<TrasformazioneRegolaRisposta> lista = new ArrayList<TrasformazioneRegolaRisposta>();
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addFromTable(nomeTabellaRisposta);
            sqlQueryObject.addSelectCountField(nomeTabellaRisposta + ".id", "cont");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=?");
            sqlQueryObject.addWhereCondition(nomeTabellaRisposta + ".id_trasformazione=?");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id=" + nomeTabellaRisposta + ".id_trasformazione");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPA);
            stmt.setLong(2, idTrasformazione);
            rs = stmt.executeQuery();
            if (rs.next()) {
                ricerca.setNumEntries(idLista, rs.getInt(1));
            }
            rs.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addFromTable(nomeTabellaRisposta);
            sqlQueryObject.addSelectAliasField(nomeTabellaRisposta, "id", "idTrasRisposta");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".posizione");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".nome");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=?");
            sqlQueryObject.addWhereCondition(nomeTabellaRisposta + ".id_trasformazione=?");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id=" + nomeTabellaRisposta + ".id_trasformazione");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy(nomeTabellaRisposta + ".posizione");
            sqlQueryObject.addOrderBy(nomeTabellaRisposta + ".nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPA);
            stmt.setLong(2, idTrasformazione);
            rs = stmt.executeQuery();
            ArrayList<Long> idTrasformazioneRisposta = new ArrayList<Long>();
            while (rs.next()) {
                idTrasformazioneRisposta.add(rs.getLong("idTrasRisposta"));
            }
            rs.close();
            stmt.close();
            if (idTrasformazioneRisposta != null && !idTrasformazioneRisposta.isEmpty()) {
                for (Long idLongTrasformazioneRisposta : idTrasformazioneRisposta) {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObject.addFromTable(nomeTabella);
                    sqlQueryObject.addFromTable(nomeTabellaRisposta);
                    sqlQueryObject.addSelectField(nomeTabellaRisposta + ".nome");
                    sqlQueryObject.addSelectField(nomeTabellaRisposta + ".posizione");
                    sqlQueryObject.addSelectField(nomeTabellaRisposta + ".applicabilita_status_min");
                    sqlQueryObject.addSelectField(nomeTabellaRisposta + ".applicabilita_status_max");
                    sqlQueryObject.addSelectField(nomeTabellaRisposta + ".applicabilita_ct");
                    sqlQueryObject.addSelectField(nomeTabellaRisposta + ".applicabilita_pattern");
                    sqlQueryObject.addSelectField(nomeTabellaRisposta + ".conversione_enabled");
                    sqlQueryObject.addSelectField(nomeTabellaRisposta + ".conversione_tipo");
                    sqlQueryObject.addSelectField(nomeTabellaRisposta + ".conversione_template");
                    sqlQueryObject.addSelectField(nomeTabellaRisposta + ".content_type");
                    sqlQueryObject.addSelectField(nomeTabellaRisposta + ".return_code");
                    sqlQueryObject.addSelectField(nomeTabellaRisposta + ".soap_envelope");
                    sqlQueryObject.addSelectField(nomeTabellaRisposta + ".soap_envelope_as_attach");
                    sqlQueryObject.addSelectField(nomeTabellaRisposta + ".soap_envelope_tipo");
                    sqlQueryObject.addSelectField(nomeTabellaRisposta + ".soap_envelope_template");
                    sqlQueryObject.addSelectField(nomeTabellaRisposta + ".id");
                    sqlQueryObject.addSelectField(nomeTabellaRisposta + ".id_trasformazione");
                    sqlQueryObject.addSelectField(nomeTabella + ".rest_transformation");
                    sqlQueryObject.addWhereCondition(nomeTabellaRisposta + ".id=?");
                    sqlQueryObject.addWhereCondition(nomeTabella + ".id=" + nomeTabellaRisposta + ".id_trasformazione");
                    sqlQueryObject.setANDLogicOperator(true);
                    queryString = sqlQueryObject.createSQLQuery();
                    stmt = con.prepareStatement(queryString);
                    stmt.setLong(1, idLongTrasformazioneRisposta);
                    rs = stmt.executeQuery();
                    if (rs.next()) {
                        TrasformazioneRegolaRisposta risposta = this._readTrasformazioneRegolaRisposta(rs);
                        lista.add(risposta);
                    }
                    rs.close();
                    stmt.close();
                }
            }
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return lista;
    }

    protected TrasformazioneRegolaRisposta getPortaApplicativaTrasformazioneRisposta(long idPorta, long idTrasformazione, Integer statusMin, Integer statusMax, String pattern, String contentType) throws DriverConfigurazioneException {
        String nomeMetodo = "getPortaApplicativaTrasformazioneRisposta";
        boolean delegata = false;
        return this.getEngineTrasformazioneRisposta(idPorta, idTrasformazione, statusMin, statusMax, pattern, contentType, nomeMetodo, delegata);
    }

    protected TrasformazioneRegolaRisposta getPortaDelegataTrasformazioneRisposta(long idPorta, long idTrasformazione, Integer statusMin, Integer statusMax, String pattern, String contentType) throws DriverConfigurazioneException {
        String nomeMetodo = "getPortaDelegataTrasformazioneRisposta";
        boolean delegata = true;
        return this.getEngineTrasformazioneRisposta(idPorta, idTrasformazione, statusMin, statusMax, pattern, contentType, nomeMetodo, delegata);
    }

    private TrasformazioneRegolaRisposta getEngineTrasformazioneRisposta(long idPorta, long idTrasformazione, Integer statusMin, Integer statusMax, String pattern, String contentType, String nomeMetodo, boolean portaDelegata) throws DriverConfigurazioneException {
        TrasformazioneRegolaRisposta trasformazioneRegolaRisposta;
        String nomeTabellaRisposta;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String nomeTabella = portaDelegata ? "pd_transform" : "pa_transform";
        String string = nomeTabellaRisposta = portaDelegata ? "pd_transform_risp" : "pa_transform_risp";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        TrasformazioneRegolaRisposta risposta = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addFromTable(nomeTabellaRisposta);
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".nome");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".posizione");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".applicabilita_status_min");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".applicabilita_status_max");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".applicabilita_ct");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".applicabilita_pattern");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".conversione_enabled");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".conversione_tipo");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".conversione_template");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".content_type");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".return_code");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".soap_envelope");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".soap_envelope_as_attach");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".soap_envelope_tipo");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".soap_envelope_template");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".id");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".id_trasformazione");
            sqlQueryObject.addSelectField(nomeTabella + ".rest_transformation");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=?");
            sqlQueryObject.addWhereCondition(nomeTabellaRisposta + ".id_trasformazione=?");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id=" + nomeTabellaRisposta + ".id_trasformazione");
            sqlQueryObject.setANDLogicOperator(true);
            if (statusMin != null) {
                sqlQueryObject.addWhereCondition(nomeTabellaRisposta + ".applicabilita_status_min = ?");
            } else {
                sqlQueryObject.addWhereIsNullCondition(nomeTabellaRisposta + ".applicabilita_status_min");
            }
            if (statusMax != null) {
                sqlQueryObject.addWhereCondition(nomeTabellaRisposta + ".applicabilita_status_max = ?");
            } else {
                sqlQueryObject.addWhereIsNullCondition(nomeTabellaRisposta + ".applicabilita_status_max");
            }
            if (pattern != null) {
                sqlQueryObject.addWhereLikeCondition(nomeTabellaRisposta + ".applicabilita_pattern", pattern, false, false);
            } else {
                sqlQueryObject.addWhereIsNullCondition(nomeTabellaRisposta + ".applicabilita_pattern");
            }
            if (contentType != null) {
                sqlQueryObject.addWhereLikeCondition(nomeTabellaRisposta + ".applicabilita_ct", contentType, false, false);
            } else {
                sqlQueryObject.addWhereIsNullCondition(nomeTabellaRisposta + ".applicabilita_ct");
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int parameterIndex = 1;
            stmt.setLong(parameterIndex++, idPorta);
            stmt.setLong(parameterIndex++, idTrasformazione);
            if (statusMin != null) {
                stmt.setInt(parameterIndex++, statusMin);
            }
            if (statusMax != null) {
                stmt.setInt(parameterIndex++, statusMax);
            }
            if ((rs = stmt.executeQuery()).next()) {
                risposta = this._readTrasformazioneRegolaRisposta(rs);
            }
            rs.close();
            stmt.close();
            trasformazioneRegolaRisposta = risposta;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return trasformazioneRegolaRisposta;
    }

    protected TrasformazioneRegolaRisposta getPortaApplicativaTrasformazioneRisposta(long idPorta, long idTrasformazione, String nome) throws DriverConfigurazioneException {
        String nomeMetodo = "getPortaApplicativaTrasformazioneRisposta";
        boolean delegata = false;
        return this.getEngineTrasformazioneRisposta(idPorta, idTrasformazione, nome, nomeMetodo, delegata);
    }

    protected TrasformazioneRegolaRisposta getPortaDelegataTrasformazioneRisposta(long idPorta, long idTrasformazione, String nome) throws DriverConfigurazioneException {
        String nomeMetodo = "getPortaDelegataTrasformazioneRisposta";
        boolean delegata = true;
        return this.getEngineTrasformazioneRisposta(idPorta, idTrasformazione, nome, nomeMetodo, delegata);
    }

    private TrasformazioneRegolaRisposta getEngineTrasformazioneRisposta(long idPorta, long idTrasformazione, String nome, String nomeMetodo, boolean portaDelegata) throws DriverConfigurazioneException {
        TrasformazioneRegolaRisposta trasformazioneRegolaRisposta;
        String nomeTabellaRisposta;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String nomeTabella = portaDelegata ? "pd_transform" : "pa_transform";
        String string = nomeTabellaRisposta = portaDelegata ? "pd_transform_risp" : "pa_transform_risp";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        TrasformazioneRegolaRisposta risposta = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addFromTable(nomeTabellaRisposta);
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".nome");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".posizione");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".applicabilita_status_min");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".applicabilita_status_max");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".applicabilita_ct");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".applicabilita_pattern");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".conversione_enabled");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".conversione_tipo");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".conversione_template");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".content_type");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".return_code");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".soap_envelope");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".soap_envelope_as_attach");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".soap_envelope_tipo");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".soap_envelope_template");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".id");
            sqlQueryObject.addSelectField(nomeTabellaRisposta + ".id_trasformazione");
            sqlQueryObject.addSelectField(nomeTabella + ".rest_transformation");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=?");
            sqlQueryObject.addWhereCondition(nomeTabellaRisposta + ".id_trasformazione=?");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id=" + nomeTabellaRisposta + ".id_trasformazione");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition(nomeTabellaRisposta + ".nome = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int parameterIndex = 1;
            stmt.setLong(parameterIndex++, idPorta);
            stmt.setLong(parameterIndex++, idTrasformazione);
            stmt.setString(parameterIndex++, nome);
            rs = stmt.executeQuery();
            if (rs.next()) {
                risposta = this._readTrasformazioneRegolaRisposta(rs);
            }
            rs.close();
            stmt.close();
            trasformazioneRegolaRisposta = risposta;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return trasformazioneRegolaRisposta;
    }

    private TrasformazioneRegolaRisposta _readTrasformazioneRegolaRisposta(ResultSet rs) throws Exception {
        int conversione_enabled;
        TrasformazioneRegolaRisposta risposta = new TrasformazioneRegolaRisposta();
        String nome = rs.getString("nome");
        risposta.setNome(nome);
        int posizione = rs.getInt("posizione");
        risposta.setPosizione(posizione);
        int applicabilita_status_min = rs.getInt("applicabilita_status_min");
        int applicabilita_status_max = rs.getInt("applicabilita_status_max");
        String applicabilita_ct = rs.getString("applicabilita_ct");
        String applicabilita_pattern = rs.getString("applicabilita_pattern");
        if (applicabilita_status_min > 0 || applicabilita_status_max > 0 || applicabilita_ct != null && !"".equals(applicabilita_ct) || applicabilita_pattern != null && !"".equals(applicabilita_pattern)) {
            TrasformazioneRegolaApplicabilitaRisposta applicabilita = new TrasformazioneRegolaApplicabilitaRisposta();
            if (applicabilita_status_min > 0) {
                applicabilita.setReturnCodeMin(applicabilita_status_min);
            }
            if (applicabilita_status_max > 0) {
                applicabilita.setReturnCodeMax(applicabilita_status_max);
            }
            if (applicabilita_ct != null && !"".equals(applicabilita_ct)) {
                if (applicabilita_ct.contains(",")) {
                    String[] tmp = applicabilita_ct.split(",");
                    for (int i = 0; i < tmp.length; ++i) {
                        applicabilita.addContentType(tmp[i].trim());
                    }
                } else {
                    applicabilita.addContentType(applicabilita_ct);
                }
            }
            if (applicabilita_pattern != null && !"".equals(applicabilita_pattern)) {
                applicabilita.setPattern(applicabilita_pattern);
            }
            risposta.setApplicabilita(applicabilita);
        }
        if (1 == (conversione_enabled = rs.getInt("conversione_enabled"))) {
            risposta.setConversione(true);
        } else {
            risposta.setConversione(false);
        }
        risposta.setConversioneTipo(rs.getString("conversione_tipo"));
        IJDBCAdapter jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)this.driver.tipoDB);
        risposta.setConversioneTemplate(jdbcAdapter.getBinaryData(rs, "conversione_template"));
        risposta.setContentType(rs.getString("content_type"));
        risposta.setReturnCode(rs.getString("return_code"));
        int trasformazione_rest = rs.getInt("rest_transformation");
        if (1 == trasformazione_rest) {
            TrasformazioneSoapRisposta trasformazioneSoap = new TrasformazioneSoapRisposta();
            int envelope = rs.getInt("soap_envelope");
            if (1 == envelope) {
                trasformazioneSoap.setEnvelope(true);
            } else {
                trasformazioneSoap.setEnvelope(false);
            }
            int envelope_as_attach = rs.getInt("soap_envelope_as_attach");
            if (1 == envelope_as_attach) {
                trasformazioneSoap.setEnvelopeAsAttachment(true);
                trasformazioneSoap.setEnvelopeBodyConversioneTipo(rs.getString("soap_envelope_tipo"));
                trasformazioneSoap.setEnvelopeBodyConversioneTemplate(jdbcAdapter.getBinaryData(rs, "soap_envelope_template"));
            } else {
                trasformazioneSoap.setEnvelopeAsAttachment(false);
            }
            risposta.setTrasformazioneSoap(trasformazioneSoap);
        }
        risposta.setId(rs.getLong("id"));
        return risposta;
    }

    protected boolean existsPortaApplicativaTrasformazioneRisposta(long idPorta, long idTrasformazione, Integer statusMin, Integer statusMax, String pattern, String contentType) throws DriverConfigurazioneException {
        String nomeMetodo = "existsPortaApplicativaTrasformazioneRisposta";
        boolean delegata = false;
        return this._existsTrasformazioneRisposta(idPorta, idTrasformazione, statusMin, statusMax, pattern, contentType, nomeMetodo, delegata);
    }

    protected boolean existsPortaDelegataTrasformazioneRisposta(long idPorta, long idTrasformazione, Integer statusMin, Integer statusMax, String pattern, String contentType) throws DriverConfigurazioneException {
        String nomeMetodo = "existsPortaDelegataTrasformazioneRisposta";
        boolean delegata = true;
        return this._existsTrasformazioneRisposta(idPorta, idTrasformazione, statusMin, statusMax, pattern, contentType, nomeMetodo, delegata);
    }

    private boolean _existsTrasformazioneRisposta(long idPorta, long idTrasformazione, Integer statusMin, Integer statusMax, String pattern, String contentType, String nomeMetodo, boolean portaDelegata) throws DriverConfigurazioneException {
        boolean bl;
        String nomeTabellaRisposta;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        String nomeTabella = portaDelegata ? "pd_transform" : "pa_transform";
        String string = nomeTabellaRisposta = portaDelegata ? "pd_transform_risp" : "pa_transform_risp";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            int count = 0;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addFromTable(nomeTabellaRisposta);
            sqlQueryObject.addSelectCountField(nomeTabellaRisposta + ".id", "cont");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=?");
            sqlQueryObject.addWhereCondition(nomeTabellaRisposta + ".id_trasformazione=?");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id=" + nomeTabellaRisposta + ".id_trasformazione");
            if (statusMin != null) {
                sqlQueryObject.addWhereCondition(nomeTabellaRisposta + ".applicabilita_status_min = ?");
            } else {
                sqlQueryObject.addWhereIsNullCondition(nomeTabellaRisposta + ".applicabilita_status_min");
            }
            if (statusMax != null) {
                sqlQueryObject.addWhereCondition(nomeTabellaRisposta + ".applicabilita_status_max = ?");
            } else {
                sqlQueryObject.addWhereIsNullCondition(nomeTabellaRisposta + ".applicabilita_status_max");
            }
            if (pattern != null) {
                sqlQueryObject.addWhereLikeCondition(nomeTabellaRisposta + ".applicabilita_pattern", pattern, false, false);
            } else {
                sqlQueryObject.addWhereIsNullCondition(nomeTabellaRisposta + ".applicabilita_pattern");
            }
            if (contentType != null) {
                sqlQueryObject.addWhereLikeCondition(nomeTabellaRisposta + ".applicabilita_ct", contentType, false, false);
            } else {
                sqlQueryObject.addWhereIsNullCondition(nomeTabellaRisposta + ".applicabilita_ct");
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int parameterIndex = 1;
            stmt.setLong(parameterIndex++, idPorta);
            stmt.setLong(parameterIndex++, idTrasformazione);
            if (statusMin != null) {
                stmt.setInt(parameterIndex++, statusMin);
            }
            if (statusMax != null) {
                stmt.setInt(parameterIndex++, statusMax);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                count = risultato.getInt(1);
            }
            risultato.close();
            stmt.close();
            bl = count > 0;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return bl;
    }

    protected boolean existsPortaApplicativaTrasformazioneRisposta(long idPorta, long idTrasformazione, String nome) throws DriverConfigurazioneException {
        String nomeMetodo = "existsPortaApplicativaTrasformazioneRisposta";
        boolean delegata = false;
        return this._existsTrasformazioneRisposta(idPorta, idTrasformazione, nome, nomeMetodo, delegata);
    }

    protected boolean existsPortaDelegataTrasformazioneRisposta(long idPorta, long idTrasformazione, String nome) throws DriverConfigurazioneException {
        String nomeMetodo = "existsPortaDelegataTrasformazioneRisposta";
        boolean delegata = true;
        return this._existsTrasformazioneRisposta(idPorta, idTrasformazione, nome, nomeMetodo, delegata);
    }

    private boolean _existsTrasformazioneRisposta(long idPorta, long idTrasformazione, String nome, String nomeMetodo, boolean portaDelegata) throws DriverConfigurazioneException {
        boolean bl;
        String nomeTabellaRisposta;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        String nomeTabella = portaDelegata ? "pd_transform" : "pa_transform";
        String string = nomeTabellaRisposta = portaDelegata ? "pd_transform_risp" : "pa_transform_risp";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            int count = 0;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addFromTable(nomeTabellaRisposta);
            sqlQueryObject.addSelectCountField(nomeTabellaRisposta + ".id", "cont");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=?");
            sqlQueryObject.addWhereCondition(nomeTabellaRisposta + ".id_trasformazione=?");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id=" + nomeTabellaRisposta + ".id_trasformazione");
            sqlQueryObject.addWhereCondition(nomeTabellaRisposta + ".nome = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int parameterIndex = 1;
            stmt.setLong(parameterIndex++, idPorta);
            stmt.setLong(parameterIndex++, idTrasformazione);
            stmt.setString(parameterIndex++, nome);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                count = risultato.getInt(1);
            }
            risultato.close();
            stmt.close();
            bl = count > 0;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return bl;
    }

    protected List<TrasformazioneRegolaApplicabilitaServizioApplicativo> porteDelegateTrasformazioniServiziApplicativiList(long idPD, long idTrasformazione, ISearch ricerca) throws DriverConfigurazioneException {
        int idLista = Liste.PORTE_DELEGATE_TRASFORMAZIONI_SERVIZIO_APPLICATIVO;
        String nomeMetodo = "porteDelegateTrasformazioniServiziApplicativiList";
        boolean delegata = true;
        return this.getEngineTrasformazioniServiziApplicativiList(idPD, idTrasformazione, ricerca, idLista, nomeMetodo, delegata);
    }

    protected List<TrasformazioneRegolaApplicabilitaServizioApplicativo> porteApplicativeTrasformazioniServiziApplicativiList(long idPA, long idTrasformazione, ISearch ricerca) throws DriverConfigurazioneException {
        int idLista = Liste.PORTE_APPLICATIVE_TRASFORMAZIONI_SERVIZIO_APPLICATIVO_AUTORIZZATO;
        String nomeMetodo = "porteApplicativeTrasformazioniServiziApplicativiList";
        boolean delegata = false;
        return this.getEngineTrasformazioniServiziApplicativiList(idPA, idTrasformazione, ricerca, idLista, nomeMetodo, delegata);
    }

    private List<TrasformazioneRegolaApplicabilitaServizioApplicativo> getEngineTrasformazioniServiziApplicativiList(long idPA, long idTrasformazione, ISearch ricerca, int idLista, String nomeMetodo, boolean portaDelegata) throws DriverConfigurazioneException {
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String nomeTabella = portaDelegata ? "pd_transform" : "pa_transform";
        String nomeTabellaTrasformazioneSA = portaDelegata ? "pd_transform_sa" : "pa_transform_sa";
        String nomeTabellaSA = "servizi_applicativi";
        String nomeTabellaSoggetti = "soggetti";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        ArrayList<TrasformazioneRegolaApplicabilitaServizioApplicativo> lista = new ArrayList<TrasformazioneRegolaApplicabilitaServizioApplicativo>();
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addFromTable(nomeTabellaTrasformazioneSA);
            sqlQueryObject.addSelectCountField(nomeTabellaTrasformazioneSA + ".id", "cont");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=?");
            sqlQueryObject.addWhereCondition(nomeTabellaTrasformazioneSA + ".id_trasformazione=?");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id=" + nomeTabellaTrasformazioneSA + ".id_trasformazione");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPA);
            stmt.setLong(2, idTrasformazione);
            rs = stmt.executeQuery();
            if (rs.next()) {
                ricerca.setNumEntries(idLista, rs.getInt(1));
            }
            rs.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addFromTable(nomeTabellaTrasformazioneSA);
            sqlQueryObject.addFromTable(nomeTabellaSA);
            sqlQueryObject.addFromTable(nomeTabellaSoggetti);
            sqlQueryObject.addSelectAliasField(nomeTabellaTrasformazioneSA, "id", "idTrasSA");
            sqlQueryObject.addSelectField(nomeTabellaSA + ".nome");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=?");
            sqlQueryObject.addWhereCondition(nomeTabellaTrasformazioneSA + ".id_trasformazione=?");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id=" + nomeTabellaTrasformazioneSA + ".id_trasformazione");
            sqlQueryObject.addWhereCondition(nomeTabellaSA + ".id=" + nomeTabellaTrasformazioneSA + ".id_servizio_applicativo");
            sqlQueryObject.addWhereCondition(nomeTabellaSA + ".id_soggetto=" + nomeTabellaSoggetti + ".id");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy(nomeTabellaSA + ".nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPA);
            stmt.setLong(2, idTrasformazione);
            rs = stmt.executeQuery();
            ArrayList<Long> idLong = new ArrayList<Long>();
            while (rs.next()) {
                idLong.add(rs.getLong("idTrasSA"));
            }
            rs.close();
            stmt.close();
            if (!idLong.isEmpty()) {
                for (Long idLongTrasf : idLong) {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObject.addFromTable(nomeTabella);
                    sqlQueryObject.addFromTable(nomeTabellaTrasformazioneSA);
                    sqlQueryObject.addFromTable(nomeTabellaSA);
                    sqlQueryObject.addFromTable(nomeTabellaSoggetti);
                    sqlQueryObject.addSelectField(nomeTabellaSA + ".nome");
                    sqlQueryObject.addSelectField(nomeTabellaSoggetti + ".tipo_soggetto");
                    sqlQueryObject.addSelectField(nomeTabellaSoggetti + ".nome_soggetto");
                    sqlQueryObject.addSelectField(nomeTabellaTrasformazioneSA + ".id");
                    sqlQueryObject.addSelectField(nomeTabellaTrasformazioneSA + ".id_trasformazione");
                    sqlQueryObject.addSelectField(nomeTabellaTrasformazioneSA + ".id_servizio_applicativo");
                    sqlQueryObject.addWhereCondition(nomeTabellaTrasformazioneSA + ".id=?");
                    sqlQueryObject.addWhereCondition(nomeTabella + ".id=" + nomeTabellaTrasformazioneSA + ".id_trasformazione");
                    sqlQueryObject.addWhereCondition(nomeTabellaSA + ".id=" + nomeTabellaTrasformazioneSA + ".id_servizio_applicativo");
                    sqlQueryObject.addWhereCondition(nomeTabellaSA + ".id_soggetto=" + nomeTabellaSoggetti + ".id");
                    sqlQueryObject.setANDLogicOperator(true);
                    queryString = sqlQueryObject.createSQLQuery();
                    stmt = con.prepareStatement(queryString);
                    stmt.setLong(1, idLongTrasf);
                    rs = stmt.executeQuery();
                    if (rs.next()) {
                        TrasformazioneRegolaApplicabilitaServizioApplicativo risposta = new TrasformazioneRegolaApplicabilitaServizioApplicativo();
                        risposta.setId(rs.getLong("id"));
                        risposta.setNome(rs.getString("nome"));
                        risposta.setTipoSoggettoProprietario(rs.getString("tipo_soggetto"));
                        risposta.setNomeSoggettoProprietario(rs.getString("nome_soggetto"));
                        lista.add(risposta);
                    }
                    rs.close();
                    stmt.close();
                }
            }
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return lista;
    }

    protected List<TrasformazioneRegolaApplicabilitaSoggetto> porteApplicativeTrasformazioniSoggettiList(long idPA, long idTrasformazione, ISearch ricerca) throws DriverConfigurazioneException {
        int idLista = Liste.PORTE_APPLICATIVE_TRASFORMAZIONI_SOGGETTO;
        String nomeMetodo = "porteApplicativeTrasformazioniSoggettiList";
        boolean delegata = false;
        return this.getEngineTrasformazioniSoggettiList(idPA, idTrasformazione, ricerca, idLista, nomeMetodo, delegata);
    }

    private List<TrasformazioneRegolaApplicabilitaSoggetto> getEngineTrasformazioniSoggettiList(long idPA, long idTrasformazione, ISearch ricerca, int idLista, String nomeMetodo, boolean portaDelegata) throws DriverConfigurazioneException {
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String nomeTabella = portaDelegata ? "pd_transform" : "pa_transform";
        String nomeTabellaSoggetti = "pa_transform_soggetti";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        ArrayList<TrasformazioneRegolaApplicabilitaSoggetto> lista = new ArrayList<TrasformazioneRegolaApplicabilitaSoggetto>();
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addFromTable(nomeTabellaSoggetti);
            sqlQueryObject.addSelectCountField(nomeTabellaSoggetti + ".id", "cont");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=?");
            sqlQueryObject.addWhereCondition(nomeTabellaSoggetti + ".id_trasformazione=?");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id=" + nomeTabellaSoggetti + ".id_trasformazione");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPA);
            stmt.setLong(2, idTrasformazione);
            rs = stmt.executeQuery();
            if (rs.next()) {
                ricerca.setNumEntries(idLista, rs.getInt(1));
            }
            rs.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addFromTable(nomeTabellaSoggetti);
            sqlQueryObject.addSelectAliasField(nomeTabellaSoggetti, "id", "idTrasSoggetto");
            sqlQueryObject.addSelectField(nomeTabellaSoggetti + ".tipo_soggetto");
            sqlQueryObject.addSelectField(nomeTabellaSoggetti + ".nome_soggetto");
            sqlQueryObject.addSelectField(nomeTabellaSoggetti + ".id");
            sqlQueryObject.addSelectField(nomeTabellaSoggetti + ".id_trasformazione");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=?");
            sqlQueryObject.addWhereCondition(nomeTabellaSoggetti + ".id_trasformazione=?");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id=" + nomeTabellaSoggetti + ".id_trasformazione");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy(nomeTabellaSoggetti + ".tipo_soggetto");
            sqlQueryObject.addOrderBy(nomeTabellaSoggetti + ".nome_soggetto");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPA);
            stmt.setLong(2, idTrasformazione);
            rs = stmt.executeQuery();
            ArrayList<Long> idLong = new ArrayList<Long>();
            while (rs.next()) {
                idLong.add(rs.getLong("idTrasSoggetto"));
            }
            rs.close();
            stmt.close();
            if (!idLong.isEmpty()) {
                for (Long idLongTrasf : idLong) {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObject.addFromTable(nomeTabella);
                    sqlQueryObject.addFromTable(nomeTabellaSoggetti);
                    sqlQueryObject.addSelectField(nomeTabellaSoggetti + ".tipo_soggetto");
                    sqlQueryObject.addSelectField(nomeTabellaSoggetti + ".nome_soggetto");
                    sqlQueryObject.addSelectField(nomeTabellaSoggetti + ".id");
                    sqlQueryObject.addSelectField(nomeTabellaSoggetti + ".id_trasformazione");
                    sqlQueryObject.addWhereCondition(nomeTabellaSoggetti + ".id=?");
                    sqlQueryObject.addWhereCondition(nomeTabella + ".id=" + nomeTabellaSoggetti + ".id_trasformazione");
                    sqlQueryObject.setANDLogicOperator(true);
                    queryString = sqlQueryObject.createSQLQuery();
                    stmt = con.prepareStatement(queryString);
                    stmt.setLong(1, idLongTrasf);
                    rs = stmt.executeQuery();
                    if (rs.next()) {
                        TrasformazioneRegolaApplicabilitaSoggetto risposta = new TrasformazioneRegolaApplicabilitaSoggetto();
                        risposta.setId(rs.getLong("id"));
                        risposta.setTipo(rs.getString("tipo_soggetto"));
                        risposta.setNome(rs.getString("nome_soggetto"));
                        lista.add(risposta);
                    }
                    rs.close();
                    stmt.close();
                }
            }
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return lista;
    }

    protected List<TrasformazioneRegolaParametro> porteDelegateTrasformazioniRispostaHeaderList(long idPD, long idTrasformazione, long idTrasformazioneRisposta, ISearch ricerca) throws DriverConfigurazioneException {
        int idLista = Liste.PORTE_DELEGATE_TRASFORMAZIONI_RISPOSTE_HEADER;
        String nomeMetodo = "porteDelegateTrasformazioniRispostaHeaderList";
        boolean delegata = true;
        return this.getEngineTrasformazioniRispostaHeaderList(idPD, idTrasformazione, idTrasformazioneRisposta, ricerca, idLista, nomeMetodo, delegata);
    }

    protected List<TrasformazioneRegolaParametro> porteApplicativeTrasformazioniRispostaHeaderList(long idPA, long idTrasformazione, long idTrasformazioneRisposta, ISearch ricerca) throws DriverConfigurazioneException {
        int idLista = Liste.PORTE_APPLICATIVE_TRASFORMAZIONI_RISPOSTE_HEADER;
        String nomeMetodo = "porteApplicativeTrasformazioniRispostaHeaderList";
        boolean delegata = false;
        return this.getEngineTrasformazioniRispostaHeaderList(idPA, idTrasformazione, idTrasformazioneRisposta, ricerca, idLista, nomeMetodo, delegata);
    }

    private List<TrasformazioneRegolaParametro> getEngineTrasformazioniRispostaHeaderList(long idPA, long idTrasformazione, long idTrasformazioneRisposta, ISearch ricerca, int idLista, String nomeMetodo, boolean portaDelegata) throws DriverConfigurazioneException {
        String nomeTabellaRispostaHeader;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String nomeTabella = portaDelegata ? "pd_transform" : "pa_transform";
        String nomeTabellaRisposta = portaDelegata ? "pd_transform_risp" : "pa_transform_risp";
        String string = nomeTabellaRispostaHeader = portaDelegata ? "pd_transform_risp_hdr" : "pa_transform_risp_hdr";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        ArrayList<TrasformazioneRegolaParametro> lista = new ArrayList<TrasformazioneRegolaParametro>();
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addFromTable(nomeTabellaRisposta);
            sqlQueryObject.addFromTable(nomeTabellaRispostaHeader);
            sqlQueryObject.addSelectCountField(nomeTabellaRispostaHeader + ".id", "cont");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=?");
            sqlQueryObject.addWhereCondition(nomeTabellaRisposta + ".id_trasformazione=?");
            sqlQueryObject.addWhereCondition(nomeTabellaRispostaHeader + ".id_transform_risp=?");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id=" + nomeTabellaRisposta + ".id_trasformazione");
            sqlQueryObject.addWhereCondition(nomeTabellaRisposta + ".id=" + nomeTabellaRispostaHeader + ".id_transform_risp");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPA);
            stmt.setLong(2, idTrasformazione);
            stmt.setLong(3, idTrasformazioneRisposta);
            rs = stmt.executeQuery();
            if (rs.next()) {
                ricerca.setNumEntries(idLista, rs.getInt(1));
            }
            rs.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addFromTable(nomeTabellaRisposta);
            sqlQueryObject.addFromTable(nomeTabellaRispostaHeader);
            sqlQueryObject.addSelectAliasField(nomeTabellaRispostaHeader, "id", "idTrasParametro");
            sqlQueryObject.addSelectField(nomeTabellaRispostaHeader + ".tipo");
            sqlQueryObject.addSelectField(nomeTabellaRispostaHeader + ".nome");
            sqlQueryObject.addSelectField(nomeTabellaRispostaHeader + ".id");
            sqlQueryObject.addSelectField(nomeTabellaRispostaHeader + ".id_transform_risp");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=?");
            sqlQueryObject.addWhereCondition(nomeTabellaRisposta + ".id_trasformazione=?");
            sqlQueryObject.addWhereCondition(nomeTabellaRispostaHeader + ".id_transform_risp=?");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id=" + nomeTabellaRisposta + ".id_trasformazione");
            sqlQueryObject.addWhereCondition(nomeTabellaRisposta + ".id=" + nomeTabellaRispostaHeader + ".id_transform_risp");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy(nomeTabellaRispostaHeader + ".nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPA);
            stmt.setLong(2, idTrasformazione);
            stmt.setLong(3, idTrasformazioneRisposta);
            rs = stmt.executeQuery();
            ArrayList<Long> idLong = new ArrayList<Long>();
            while (rs.next()) {
                idLong.add(rs.getLong("idTrasParametro"));
            }
            rs.close();
            stmt.close();
            if (!idLong.isEmpty()) {
                for (Long idLongTrasf : idLong) {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObject.addFromTable(nomeTabella);
                    sqlQueryObject.addFromTable(nomeTabellaRisposta);
                    sqlQueryObject.addFromTable(nomeTabellaRispostaHeader);
                    sqlQueryObject.addSelectField(nomeTabellaRispostaHeader + ".tipo");
                    sqlQueryObject.addSelectField(nomeTabellaRispostaHeader + ".nome");
                    sqlQueryObject.addSelectField(nomeTabellaRispostaHeader + ".valore");
                    sqlQueryObject.addSelectField(nomeTabellaRispostaHeader + ".identificazione_fallita");
                    sqlQueryObject.addSelectField(nomeTabellaRispostaHeader + ".id");
                    sqlQueryObject.addSelectField(nomeTabellaRispostaHeader + ".id_transform_risp");
                    sqlQueryObject.addWhereCondition(nomeTabellaRispostaHeader + ".id=?");
                    sqlQueryObject.addWhereCondition(nomeTabella + ".id=" + nomeTabellaRisposta + ".id_trasformazione");
                    sqlQueryObject.addWhereCondition(nomeTabellaRisposta + ".id=" + nomeTabellaRispostaHeader + ".id_transform_risp");
                    sqlQueryObject.setANDLogicOperator(true);
                    queryString = sqlQueryObject.createSQLQuery();
                    stmt = con.prepareStatement(queryString);
                    stmt.setLong(1, idLongTrasf);
                    rs = stmt.executeQuery();
                    if (rs.next()) {
                        TrasformazioneRegolaParametro parametro = new TrasformazioneRegolaParametro();
                        parametro.setConversioneTipo(DriverConfigurazioneDBLib.getEnumTrasformazioneRegolaParametroTipoAzione(rs.getString("tipo")));
                        parametro.setNome(rs.getString("nome"));
                        parametro.setValore(rs.getString("valore"));
                        parametro.setIdentificazioneFallita(DriverConfigurazioneDBLib.getEnumTrasformazioneIdentificazioneRisorsaFallita(rs.getString("identificazione_fallita")));
                        parametro.setId(rs.getLong("id"));
                        lista.add(parametro);
                    }
                    rs.close();
                    stmt.close();
                }
            }
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return lista;
    }

    protected boolean existsPortaApplicativaTrasformazioneRispostaHeader(long idPorta, long idTrasformazione, long idTrasformazioneRisposta, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        String nomeMetodo = "existsPortaApplicativaTrasformazioneRispostaHeader";
        boolean delegata = false;
        return this._existsTrasformazioneRispostaHeader(idPorta, idTrasformazione, idTrasformazioneRisposta, nome, tipo, checkTipo, nomeMetodo, delegata);
    }

    protected boolean existsPortaDelegataTrasformazioneRispostaHeader(long idPorta, long idTrasformazione, long idTrasformazioneRisposta, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        String nomeMetodo = "existsPortaDelegataTrasformazioneRispostaHeader";
        boolean delegata = true;
        return this._existsTrasformazioneRispostaHeader(idPorta, idTrasformazione, idTrasformazioneRisposta, nome, tipo, checkTipo, nomeMetodo, delegata);
    }

    private boolean _existsTrasformazioneRispostaHeader(long idPorta, long idTrasformazione, long idTrasformazioneRisposta, String nome, String tipo, boolean checkTipo, String nomeMetodo, boolean portaDelegata) throws DriverConfigurazioneException {
        boolean bl;
        String nomeTabellaRispostaHeader;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        String nomeTabella = portaDelegata ? "pd_transform" : "pa_transform";
        String nomeTabellaRisposta = portaDelegata ? "pd_transform_risp" : "pa_transform_risp";
        String string = nomeTabellaRispostaHeader = portaDelegata ? "pd_transform_risp_hdr" : "pa_transform_risp_hdr";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            int count = 0;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addFromTable(nomeTabellaRisposta);
            sqlQueryObject.addFromTable(nomeTabellaRispostaHeader);
            sqlQueryObject.addSelectCountField(nomeTabellaRispostaHeader + ".id", "cont");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=?");
            sqlQueryObject.addWhereCondition(nomeTabellaRisposta + ".id_trasformazione=?");
            sqlQueryObject.addWhereCondition(nomeTabellaRispostaHeader + ".id_transform_risp=?");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id=" + nomeTabellaRisposta + ".id_trasformazione");
            sqlQueryObject.addWhereCondition(nomeTabellaRisposta + ".id=" + nomeTabellaRispostaHeader + ".id_transform_risp");
            sqlQueryObject.addWhereCondition(nomeTabellaRispostaHeader + ".nome = ?");
            if (checkTipo) {
                sqlQueryObject.addWhereCondition(nomeTabellaRispostaHeader + ".tipo = ?");
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int parameterIndex = 1;
            stmt.setLong(parameterIndex++, idPorta);
            stmt.setLong(parameterIndex++, idTrasformazione);
            stmt.setLong(parameterIndex++, idTrasformazioneRisposta);
            stmt.setString(parameterIndex++, nome);
            if (checkTipo) {
                stmt.setString(parameterIndex++, tipo);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                count = risultato.getInt(1);
            }
            risultato.close();
            stmt.close();
            bl = count > 0;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return bl;
    }

    protected TrasformazioneRegolaParametro getPortaApplicativaTrasformazioneRispostaHeader(long idPorta, long idTrasformazione, long idTrasformazioneRisposta, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        String nomeMetodo = "getPortaApplicativaTrasformazioneRispostaHeader";
        boolean delegata = false;
        return this.getEngineTrasformazioneRispostaHeader(idPorta, idTrasformazione, idTrasformazioneRisposta, nome, tipo, checkTipo, nomeMetodo, delegata);
    }

    protected TrasformazioneRegolaParametro getPortaDelegataTrasformazioneRispostaHeader(long idPorta, long idTrasformazione, long idTrasformazioneRisposta, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        String nomeMetodo = "getPortaDelegataTrasformazioneRispostaHeader";
        boolean delegata = true;
        return this.getEngineTrasformazioneRispostaHeader(idPorta, idTrasformazione, idTrasformazioneRisposta, nome, tipo, checkTipo, nomeMetodo, delegata);
    }

    private TrasformazioneRegolaParametro getEngineTrasformazioneRispostaHeader(long idPorta, long idTrasformazione, long idTrasformazioneRisposta, String nome, String tipo, boolean checkTipo, String nomeMetodo, boolean portaDelegata) throws DriverConfigurazioneException {
        TrasformazioneRegolaParametro trasformazioneRegolaParametro;
        String nomeTabellaRispostaHeader;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String nomeTabella = portaDelegata ? "pd_transform" : "pa_transform";
        String nomeTabellaRisposta = portaDelegata ? "pd_transform_risp" : "pa_transform_risp";
        String string = nomeTabellaRispostaHeader = portaDelegata ? "pd_transform_risp_hdr" : "pa_transform_risp_hdr";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        TrasformazioneRegolaParametro parametro = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addFromTable(nomeTabellaRisposta);
            sqlQueryObject.addSelectField(nomeTabellaRispostaHeader + ".nome");
            sqlQueryObject.addSelectField(nomeTabellaRispostaHeader + ".valore");
            sqlQueryObject.addSelectField(nomeTabellaRispostaHeader + ".tipo");
            sqlQueryObject.addSelectField(nomeTabellaRispostaHeader + ".identificazione_fallita");
            sqlQueryObject.addSelectField(nomeTabellaRispostaHeader + ".id");
            sqlQueryObject.addSelectField(nomeTabellaRispostaHeader + ".id_transform_risp");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=?");
            sqlQueryObject.addWhereCondition(nomeTabellaRisposta + ".id_trasformazione=?");
            sqlQueryObject.addWhereCondition(nomeTabellaRispostaHeader + ".id_transform_risp=?");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id=" + nomeTabellaRisposta + ".id_trasformazione");
            sqlQueryObject.addWhereCondition(nomeTabellaRisposta + ".id=" + nomeTabellaRispostaHeader + ".id_transform_risp");
            sqlQueryObject.addWhereCondition(nomeTabellaRispostaHeader + ".nome = ?");
            if (checkTipo) {
                sqlQueryObject.addWhereCondition(nomeTabellaRispostaHeader + ".tipo = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int parameterIndex = 1;
            stmt.setLong(parameterIndex++, idPorta);
            stmt.setLong(parameterIndex++, idTrasformazione);
            stmt.setLong(parameterIndex++, idTrasformazioneRisposta);
            stmt.setString(parameterIndex++, nome);
            if (checkTipo) {
                stmt.setString(parameterIndex++, tipo);
            }
            if ((rs = stmt.executeQuery()).next()) {
                parametro = new TrasformazioneRegolaParametro();
                parametro.setConversioneTipo(DriverConfigurazioneDBLib.getEnumTrasformazioneRegolaParametroTipoAzione(rs.getString("tipo")));
                parametro.setNome(rs.getString("nome"));
                parametro.setValore(rs.getString("valore"));
                parametro.setIdentificazioneFallita(DriverConfigurazioneDBLib.getEnumTrasformazioneIdentificazioneRisorsaFallita(rs.getString("identificazione_fallita")));
                parametro.setId(rs.getLong("id"));
            }
            rs.close();
            stmt.close();
            trasformazioneRegolaParametro = parametro;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return trasformazioneRegolaParametro;
    }

    protected List<TrasformazioneRegolaParametro> porteDelegateTrasformazioniRichiestaHeaderList(long idPD, long idTrasformazione, ISearch ricerca) throws DriverConfigurazioneException {
        int idLista = Liste.PORTE_DELEGATE_TRASFORMAZIONI_RICHIESTA_HEADER;
        String nomeMetodo = "porteDelegateTrasformazioniRichiestaHeaderList";
        boolean delegata = true;
        return this.getEngineTrasformazioniRichiestaHeaderList(idPD, idTrasformazione, ricerca, idLista, nomeMetodo, delegata);
    }

    protected List<TrasformazioneRegolaParametro> porteApplicativeTrasformazioniRichiestaHeaderList(long idPA, long idTrasformazione, ISearch ricerca) throws DriverConfigurazioneException {
        int idLista = Liste.PORTE_APPLICATIVE_TRASFORMAZIONI_RICHIESTA_HEADER;
        String nomeMetodo = "porteApplicativeTrasformazioniRichiestaHeaderList";
        boolean delegata = false;
        return this.getEngineTrasformazioniRichiestaHeaderList(idPA, idTrasformazione, ricerca, idLista, nomeMetodo, delegata);
    }

    private List<TrasformazioneRegolaParametro> getEngineTrasformazioniRichiestaHeaderList(long idPA, long idTrasformazione, ISearch ricerca, int idLista, String nomeMetodo, boolean portaDelegata) throws DriverConfigurazioneException {
        String nomeTabellaRichiestaHeader;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String nomeTabella = portaDelegata ? "pd_transform" : "pa_transform";
        String string = nomeTabellaRichiestaHeader = portaDelegata ? "pd_transform_hdr" : "pa_transform_hdr";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        ArrayList<TrasformazioneRegolaParametro> lista = new ArrayList<TrasformazioneRegolaParametro>();
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addFromTable(nomeTabellaRichiestaHeader);
            sqlQueryObject.addSelectCountField(nomeTabellaRichiestaHeader + ".id", "cont");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=?");
            sqlQueryObject.addWhereCondition(nomeTabellaRichiestaHeader + ".id_trasformazione=?");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id=" + nomeTabellaRichiestaHeader + ".id_trasformazione");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPA);
            stmt.setLong(2, idTrasformazione);
            rs = stmt.executeQuery();
            if (rs.next()) {
                ricerca.setNumEntries(idLista, rs.getInt(1));
            }
            rs.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addFromTable(nomeTabellaRichiestaHeader);
            sqlQueryObject.addSelectAliasField(nomeTabellaRichiestaHeader, "id", "idTrasParametro");
            sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".tipo");
            sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".nome");
            sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".id");
            sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".id_trasformazione");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=?");
            sqlQueryObject.addWhereCondition(nomeTabellaRichiestaHeader + ".id_trasformazione=?");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id=" + nomeTabellaRichiestaHeader + ".id_trasformazione");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy(nomeTabellaRichiestaHeader + ".nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPA);
            stmt.setLong(2, idTrasformazione);
            rs = stmt.executeQuery();
            ArrayList<Long> idLong = new ArrayList<Long>();
            while (rs.next()) {
                idLong.add(rs.getLong("idTrasParametro"));
            }
            rs.close();
            stmt.close();
            if (!idLong.isEmpty()) {
                for (Long idLongTrasf : idLong) {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObject.addFromTable(nomeTabella);
                    sqlQueryObject.addFromTable(nomeTabellaRichiestaHeader);
                    sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".tipo");
                    sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".nome");
                    sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".valore");
                    sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".identificazione_fallita");
                    sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".id");
                    sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".id_trasformazione");
                    sqlQueryObject.addWhereCondition(nomeTabellaRichiestaHeader + ".id=?");
                    sqlQueryObject.addWhereCondition(nomeTabella + ".id=" + nomeTabellaRichiestaHeader + ".id_trasformazione");
                    sqlQueryObject.setANDLogicOperator(true);
                    queryString = sqlQueryObject.createSQLQuery();
                    stmt = con.prepareStatement(queryString);
                    stmt.setLong(1, idLongTrasf);
                    rs = stmt.executeQuery();
                    if (rs.next()) {
                        TrasformazioneRegolaParametro parametro = new TrasformazioneRegolaParametro();
                        parametro.setConversioneTipo(DriverConfigurazioneDBLib.getEnumTrasformazioneRegolaParametroTipoAzione(rs.getString("tipo")));
                        parametro.setNome(rs.getString("nome"));
                        parametro.setValore(rs.getString("valore"));
                        parametro.setIdentificazioneFallita(DriverConfigurazioneDBLib.getEnumTrasformazioneIdentificazioneRisorsaFallita(rs.getString("identificazione_fallita")));
                        parametro.setId(rs.getLong("id"));
                        lista.add(parametro);
                    }
                    rs.close();
                    stmt.close();
                }
            }
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return lista;
    }

    protected boolean existsPortaApplicativaTrasformazioneRichiestaHeader(long idPorta, long idTrasformazione, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        String nomeMetodo = "existsPortaApplicativaTrasformazioneRichiestaHeader";
        boolean delegata = false;
        return this._existsTrasformazioneRichiestaHeader(idPorta, idTrasformazione, nome, tipo, checkTipo, nomeMetodo, delegata);
    }

    protected boolean existsPortaDelegataTrasformazioneRichiestaHeader(long idPorta, long idTrasformazione, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        String nomeMetodo = "existsPortaDelegataTrasformazioneRichiestaHeader";
        boolean delegata = true;
        return this._existsTrasformazioneRichiestaHeader(idPorta, idTrasformazione, nome, tipo, checkTipo, nomeMetodo, delegata);
    }

    private boolean _existsTrasformazioneRichiestaHeader(long idPorta, long idTrasformazione, String nome, String tipo, boolean checkTipo, String nomeMetodo, boolean portaDelegata) throws DriverConfigurazioneException {
        boolean bl;
        String nomeTabellaRichiestaHeader;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        String nomeTabella = portaDelegata ? "pd_transform" : "pa_transform";
        String string = nomeTabellaRichiestaHeader = portaDelegata ? "pd_transform_hdr" : "pa_transform_hdr";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            int count = 0;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addFromTable(nomeTabellaRichiestaHeader);
            sqlQueryObject.addSelectCountField(nomeTabellaRichiestaHeader + ".id", "cont");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=?");
            sqlQueryObject.addWhereCondition(nomeTabellaRichiestaHeader + ".id_trasformazione=?");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id=" + nomeTabellaRichiestaHeader + ".id_trasformazione");
            sqlQueryObject.addWhereCondition(nomeTabellaRichiestaHeader + ".nome = ?");
            if (checkTipo) {
                sqlQueryObject.addWhereCondition(nomeTabellaRichiestaHeader + ".tipo = ?");
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int parameterIndex = 1;
            stmt.setLong(parameterIndex++, idPorta);
            stmt.setLong(parameterIndex++, idTrasformazione);
            stmt.setString(parameterIndex++, nome);
            if (checkTipo) {
                stmt.setString(parameterIndex++, tipo);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                count = risultato.getInt(1);
            }
            risultato.close();
            stmt.close();
            bl = count > 0;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return bl;
    }

    protected TrasformazioneRegolaParametro getPortaApplicativaTrasformazioneRichiestaHeader(long idPorta, long idTrasformazione, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        String nomeMetodo = "getPortaApplicativaTrasformazioneRichiestaHeader";
        boolean delegata = false;
        return this.getEngineTrasformazioneRichiestaHeader(idPorta, idTrasformazione, nome, tipo, checkTipo, nomeMetodo, delegata);
    }

    protected TrasformazioneRegolaParametro getPortaDelegataTrasformazioneRichiestaHeader(long idPorta, long idTrasformazione, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        String nomeMetodo = "getPortaDelegataTrasformazioneRichiestaHeader";
        boolean delegata = true;
        return this.getEngineTrasformazioneRichiestaHeader(idPorta, idTrasformazione, nome, tipo, checkTipo, nomeMetodo, delegata);
    }

    private TrasformazioneRegolaParametro getEngineTrasformazioneRichiestaHeader(long idPorta, long idTrasformazione, String nome, String tipo, boolean checkTipo, String nomeMetodo, boolean portaDelegata) throws DriverConfigurazioneException {
        TrasformazioneRegolaParametro trasformazioneRegolaParametro;
        String nomeTabellaRichiestaHeader;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String nomeTabella = portaDelegata ? "pd_transform" : "pa_transform";
        String string = nomeTabellaRichiestaHeader = portaDelegata ? "pd_transform_hdr" : "pa_transform_hdr";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        TrasformazioneRegolaParametro parametro = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".nome");
            sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".valore");
            sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".tipo");
            sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".identificazione_fallita");
            sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".id");
            sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".id_trasformazione");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=?");
            sqlQueryObject.addWhereCondition(nomeTabellaRichiestaHeader + ".id_trasformazione=?");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id=" + nomeTabellaRichiestaHeader + ".id_trasformazione");
            sqlQueryObject.addWhereCondition(nomeTabellaRichiestaHeader + ".nome = ?");
            if (checkTipo) {
                sqlQueryObject.addWhereCondition(nomeTabellaRichiestaHeader + ".tipo = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int parameterIndex = 1;
            stmt.setLong(parameterIndex++, idPorta);
            stmt.setLong(parameterIndex++, idTrasformazione);
            stmt.setString(parameterIndex++, nome);
            if (checkTipo) {
                stmt.setString(parameterIndex++, tipo);
            }
            if ((rs = stmt.executeQuery()).next()) {
                parametro = new TrasformazioneRegolaParametro();
                parametro.setConversioneTipo(DriverConfigurazioneDBLib.getEnumTrasformazioneRegolaParametroTipoAzione(rs.getString("tipo")));
                parametro.setNome(rs.getString("nome"));
                parametro.setValore(rs.getString("valore"));
                parametro.setIdentificazioneFallita(DriverConfigurazioneDBLib.getEnumTrasformazioneIdentificazioneRisorsaFallita(rs.getString("identificazione_fallita")));
                parametro.setId(rs.getLong("id"));
            }
            rs.close();
            stmt.close();
            trasformazioneRegolaParametro = parametro;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return trasformazioneRegolaParametro;
    }

    protected List<TrasformazioneRegolaParametro> porteDelegateTrasformazioniRichiestaUrlParameterList(long idPD, long idTrasformazione, ISearch ricerca) throws DriverConfigurazioneException {
        int idLista = Liste.PORTE_DELEGATE_TRASFORMAZIONI_RICHIESTA_PARAMETRI;
        String nomeMetodo = "porteDelegateTrasformazioniRichiestaUrlParameterList";
        boolean delegata = true;
        return this.getEngineTrasformazioniRichiestaUrlParameterList(idPD, idTrasformazione, ricerca, idLista, nomeMetodo, delegata);
    }

    protected List<TrasformazioneRegolaParametro> porteApplicativeTrasformazioniRichiestaUrlParameterList(long idPA, long idTrasformazione, ISearch ricerca) throws DriverConfigurazioneException {
        int idLista = Liste.PORTE_APPLICATIVE_TRASFORMAZIONI_RICHIESTA_PARAMETRI;
        String nomeMetodo = "porteApplicativeTrasformazioniRichiestaUrlParameterList";
        boolean delegata = false;
        return this.getEngineTrasformazioniRichiestaUrlParameterList(idPA, idTrasformazione, ricerca, idLista, nomeMetodo, delegata);
    }

    private List<TrasformazioneRegolaParametro> getEngineTrasformazioniRichiestaUrlParameterList(long idPA, long idTrasformazione, ISearch ricerca, int idLista, String nomeMetodo, boolean portaDelegata) throws DriverConfigurazioneException {
        String nomeTabellaRichiestaHeader;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String nomeTabella = portaDelegata ? "pd_transform" : "pa_transform";
        String string = nomeTabellaRichiestaHeader = portaDelegata ? "pd_transform_url" : "pa_transform_url";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        ArrayList<TrasformazioneRegolaParametro> lista = new ArrayList<TrasformazioneRegolaParametro>();
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addFromTable(nomeTabellaRichiestaHeader);
            sqlQueryObject.addSelectCountField(nomeTabellaRichiestaHeader + ".id", "cont");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=?");
            sqlQueryObject.addWhereCondition(nomeTabellaRichiestaHeader + ".id_trasformazione=?");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id=" + nomeTabellaRichiestaHeader + ".id_trasformazione");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPA);
            stmt.setLong(2, idTrasformazione);
            rs = stmt.executeQuery();
            if (rs.next()) {
                ricerca.setNumEntries(idLista, rs.getInt(1));
            }
            rs.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addFromTable(nomeTabellaRichiestaHeader);
            sqlQueryObject.addSelectAliasField(nomeTabellaRichiestaHeader, "id", "idTrasParametro");
            sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".nome");
            sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".id");
            sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".id_trasformazione");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=?");
            sqlQueryObject.addWhereCondition(nomeTabellaRichiestaHeader + ".id_trasformazione=?");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id=" + nomeTabellaRichiestaHeader + ".id_trasformazione");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy(nomeTabellaRichiestaHeader + ".nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPA);
            stmt.setLong(2, idTrasformazione);
            rs = stmt.executeQuery();
            ArrayList<Long> idLong = new ArrayList<Long>();
            while (rs.next()) {
                idLong.add(rs.getLong("idTrasParametro"));
            }
            rs.close();
            stmt.close();
            if (!idLong.isEmpty()) {
                for (Long idLongTrasf : idLong) {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObject.addFromTable(nomeTabella);
                    sqlQueryObject.addFromTable(nomeTabellaRichiestaHeader);
                    sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".tipo");
                    sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".nome");
                    sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".valore");
                    sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".identificazione_fallita");
                    sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".id");
                    sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".id_trasformazione");
                    sqlQueryObject.addWhereCondition(nomeTabellaRichiestaHeader + ".id=?");
                    sqlQueryObject.addWhereCondition(nomeTabella + ".id=" + nomeTabellaRichiestaHeader + ".id_trasformazione");
                    sqlQueryObject.setANDLogicOperator(true);
                    queryString = sqlQueryObject.createSQLQuery();
                    stmt = con.prepareStatement(queryString);
                    stmt.setLong(1, idLongTrasf);
                    rs = stmt.executeQuery();
                    if (rs.next()) {
                        TrasformazioneRegolaParametro parametro = new TrasformazioneRegolaParametro();
                        parametro.setConversioneTipo(DriverConfigurazioneDBLib.getEnumTrasformazioneRegolaParametroTipoAzione(rs.getString("tipo")));
                        parametro.setNome(rs.getString("nome"));
                        parametro.setValore(rs.getString("valore"));
                        parametro.setIdentificazioneFallita(DriverConfigurazioneDBLib.getEnumTrasformazioneIdentificazioneRisorsaFallita(rs.getString("identificazione_fallita")));
                        parametro.setId(rs.getLong("id"));
                        lista.add(parametro);
                    }
                    rs.close();
                    stmt.close();
                }
            }
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return lista;
    }

    protected boolean existsPortaApplicativaTrasformazioneRichiestaUrlParameter(long idPorta, long idTrasformazione, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        String nomeMetodo = "existsPortaApplicativaTrasformazioneRichiestaUrlParameter";
        boolean delegata = false;
        return this._existsTrasformazioneRichiestaUrlParameter(idPorta, idTrasformazione, nome, tipo, checkTipo, nomeMetodo, delegata);
    }

    protected boolean existsPortaDelegataTrasformazioneRichiestaUrlParameter(long idPorta, long idTrasformazione, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        String nomeMetodo = "existsPortaDelegataTrasformazioneRichiestaUrlParameter";
        boolean delegata = true;
        return this._existsTrasformazioneRichiestaUrlParameter(idPorta, idTrasformazione, nome, tipo, checkTipo, nomeMetodo, delegata);
    }

    private boolean _existsTrasformazioneRichiestaUrlParameter(long idPorta, long idTrasformazione, String nome, String tipo, boolean checkTipo, String nomeMetodo, boolean portaDelegata) throws DriverConfigurazioneException {
        boolean bl;
        String nomeTabellaRichiestaHeader;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        String nomeTabella = portaDelegata ? "pd_transform" : "pa_transform";
        String string = nomeTabellaRichiestaHeader = portaDelegata ? "pd_transform_url" : "pa_transform_url";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            int count = 0;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addFromTable(nomeTabellaRichiestaHeader);
            sqlQueryObject.addSelectCountField(nomeTabellaRichiestaHeader + ".id", "cont");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=?");
            sqlQueryObject.addWhereCondition(nomeTabellaRichiestaHeader + ".id_trasformazione=?");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id=" + nomeTabellaRichiestaHeader + ".id_trasformazione");
            sqlQueryObject.addWhereCondition(nomeTabellaRichiestaHeader + ".nome = ?");
            if (checkTipo) {
                sqlQueryObject.addWhereCondition(nomeTabellaRichiestaHeader + ".tipo = ?");
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int parameterIndex = 1;
            stmt.setLong(parameterIndex++, idPorta);
            stmt.setLong(parameterIndex++, idTrasformazione);
            stmt.setString(parameterIndex++, nome);
            if (checkTipo) {
                stmt.setString(parameterIndex++, tipo);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                count = risultato.getInt(1);
            }
            risultato.close();
            stmt.close();
            bl = count > 0;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return bl;
    }

    protected TrasformazioneRegolaParametro getPortaApplicativaTrasformazioneRichiestaUrlParameter(long idPorta, long idTrasformazione, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        String nomeMetodo = "getPortaApplicativaTrasformazioneRichiestaUrlParameter";
        boolean delegata = false;
        return this.getEngineTrasformazioneRichiestaUrlParameter(idPorta, idTrasformazione, nome, tipo, checkTipo, nomeMetodo, delegata);
    }

    protected TrasformazioneRegolaParametro getPortaDelegataTrasformazioneRichiestaUrlParameter(long idPorta, long idTrasformazione, String nome, String tipo, boolean checkTipo) throws DriverConfigurazioneException {
        String nomeMetodo = "getPortaDelegataTrasformazioneRichiestaUrlParameter";
        boolean delegata = true;
        return this.getEngineTrasformazioneRichiestaUrlParameter(idPorta, idTrasformazione, nome, tipo, checkTipo, nomeMetodo, delegata);
    }

    private TrasformazioneRegolaParametro getEngineTrasformazioneRichiestaUrlParameter(long idPorta, long idTrasformazione, String nome, String tipo, boolean checkTipo, String nomeMetodo, boolean portaDelegata) throws DriverConfigurazioneException {
        TrasformazioneRegolaParametro trasformazioneRegolaParametro;
        String nomeTabellaRichiestaHeader;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String nomeTabella = portaDelegata ? "pd_transform" : "pa_transform";
        String string = nomeTabellaRichiestaHeader = portaDelegata ? "pd_transform_url" : "pa_transform_url";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        TrasformazioneRegolaParametro parametro = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".nome");
            sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".valore");
            sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".tipo");
            sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".identificazione_fallita");
            sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".id");
            sqlQueryObject.addSelectField(nomeTabellaRichiestaHeader + ".id_trasformazione");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=?");
            sqlQueryObject.addWhereCondition(nomeTabellaRichiestaHeader + ".id_trasformazione=?");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id=" + nomeTabellaRichiestaHeader + ".id_trasformazione");
            sqlQueryObject.addWhereCondition(nomeTabellaRichiestaHeader + ".nome = ?");
            if (checkTipo) {
                sqlQueryObject.addWhereCondition(nomeTabellaRichiestaHeader + ".tipo = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int parameterIndex = 1;
            stmt.setLong(parameterIndex++, idPorta);
            stmt.setLong(parameterIndex++, idTrasformazione);
            stmt.setString(parameterIndex++, nome);
            if (checkTipo) {
                stmt.setString(parameterIndex++, tipo);
            }
            if ((rs = stmt.executeQuery()).next()) {
                parametro = new TrasformazioneRegolaParametro();
                parametro.setConversioneTipo(DriverConfigurazioneDBLib.getEnumTrasformazioneRegolaParametroTipoAzione(rs.getString("tipo")));
                parametro.setNome(rs.getString("nome"));
                parametro.setValore(rs.getString("valore"));
                parametro.setIdentificazioneFallita(DriverConfigurazioneDBLib.getEnumTrasformazioneIdentificazioneRisorsaFallita(rs.getString("identificazione_fallita")));
                parametro.setId(rs.getLong("id"));
            }
            rs.close();
            stmt.close();
            trasformazioneRegolaParametro = parametro;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return trasformazioneRegolaParametro;
    }
}

