/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.CorsConfigurazione;
import org.openspcoop2.core.config.CorsConfigurazioneHeaders;
import org.openspcoop2.core.config.CorsConfigurazioneMethods;
import org.openspcoop2.core.config.CorsConfigurazioneOrigin;
import org.openspcoop2.core.config.ResponseCachingConfigurazione;
import org.openspcoop2.core.config.ResponseCachingConfigurazioneControl;
import org.openspcoop2.core.config.ResponseCachingConfigurazioneHashGenerator;
import org.openspcoop2.core.config.ResponseCachingConfigurazioneRegola;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.StatoFunzionalitaCacheDigestQueryParameter;
import org.openspcoop2.core.config.constants.TipoGestioneCORS;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBLib;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverConfigurazioneDB_porteDriver {
    private DriverConfigurazioneDB driver = null;

    protected DriverConfigurazioneDB_porteDriver(DriverConfigurazioneDB driver) {
        this.driver = driver;
    }

    protected List<ResponseCachingConfigurazioneRegola> portaApplicativaResponseCachingConfigurazioneRegolaList(long idPA, ISearch ricerca) throws DriverConfigurazioneException {
        int idLista = Liste.PORTE_APPLICATIVE_RESPONSE_CACHING_CONFIGURAZIONE_REGOLA;
        String nomeMetodo = "portaApplicativaResponseCachingConfigurazioneRegolaList";
        boolean delegata = false;
        return this.getEngineResponseCachingConfigurazioneRegolaList(idPA, ricerca, idLista, nomeMetodo, delegata);
    }

    protected List<ResponseCachingConfigurazioneRegola> portaDelegataResponseCachingConfigurazioneRegolaList(long idPD, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "portaDelegataResponseCachingConfigurazioneRegolaList";
        int idLista = Liste.PORTE_DELEGATE_RESPONSE_CACHING_CONFIGURAZIONE_REGOLA;
        boolean delegata = true;
        return this.getEngineResponseCachingConfigurazioneRegolaList(idPD, ricerca, idLista, nomeMetodo, delegata);
    }

    private List<ResponseCachingConfigurazioneRegola> getEngineResponseCachingConfigurazioneRegolaList(long idPA, ISearch ricerca, int idLista, String nomeMetodo, boolean portaDelegata) throws DriverConfigurazioneException {
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String nomeTabella = portaDelegata ? "pd_cache_regole" : "pa_cache_regole";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        ArrayList<ResponseCachingConfigurazioneRegola> lista = new ArrayList<ResponseCachingConfigurazioneRegola>();
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addSelectCountField(nomeTabella + ".id", "cont");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=?");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPA);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=?");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy(nomeTabella + ".id");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPA);
            risultato = stmt.executeQuery();
            ArrayList<Long> idLong = new ArrayList<Long>();
            while (risultato.next()) {
                idLong.add(risultato.getLong("id"));
            }
            risultato.close();
            stmt.close();
            if (!idLong.isEmpty()) {
                for (Long idLongRegola : idLong) {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObject.addFromTable(nomeTabella);
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition(nomeTabella + ".id=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    queryString = sqlQueryObject.createSQLQuery();
                    stmt = con.prepareStatement(queryString);
                    stmt.setLong(1, idLongRegola);
                    risultato = stmt.executeQuery();
                    if (risultato.next()) {
                        int fault;
                        ResponseCachingConfigurazioneRegola regola = new ResponseCachingConfigurazioneRegola();
                        regola.setId(risultato.getLong("id"));
                        int statusMin = risultato.getInt("status_min");
                        int statusMax = risultato.getInt("status_max");
                        if (statusMin > 0) {
                            regola.setReturnCodeMin(statusMin);
                        }
                        if (statusMax > 0) {
                            regola.setReturnCodeMax(statusMax);
                        }
                        if (1 == (fault = risultato.getInt("fault"))) {
                            regola.setFault(true);
                        } else if (0 == fault) {
                            regola.setFault(false);
                        }
                        int cacheSeconds = risultato.getInt("cache_seconds");
                        if (cacheSeconds > 0) {
                            regola.setCacheTimeoutSeconds(cacheSeconds);
                        }
                        lista.add(regola);
                    }
                    risultato.close();
                    stmt.close();
                }
            }
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return lista;
    }

    protected boolean existsPortaApplicativaResponseCachingConfigurazioneRegola(long idPA, Integer statusMin, Integer statusMax, boolean fault) throws DriverConfigurazioneException {
        String nomeMetodo = "existsPortaApplicativaResponseCachingConfigurazioneRegola";
        boolean delegata = false;
        return this.existsResponseCachingConfigurazioneRegolaEngine(idPA, statusMin, statusMax, fault, nomeMetodo, delegata);
    }

    protected boolean existsPortaDelegataResponseCachingConfigurazioneRegola(long idPA, Integer statusMin, Integer statusMax, boolean fault) throws DriverConfigurazioneException {
        String nomeMetodo = "existsPortaDelegataResponseCachingConfigurazioneRegola";
        boolean delegata = true;
        return this.existsResponseCachingConfigurazioneRegolaEngine(idPA, statusMin, statusMax, fault, nomeMetodo, delegata);
    }

    private boolean existsResponseCachingConfigurazioneRegolaEngine(long idPA, Integer statusMin, Integer statusMax, boolean fault, String nomeMetodo, boolean portaDelegata) throws DriverConfigurazioneException {
        boolean bl;
        String nomeTabella;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        String string = nomeTabella = portaDelegata ? "pd_cache_regole" : "pa_cache_regole";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            int count = 0;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addSelectCountField(nomeTabella + ".id", "cont");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("id_porta = ?");
            if (statusMin != null) {
                sqlQueryObject.addWhereCondition("status_min = ?");
            } else {
                sqlQueryObject.addWhereIsNullCondition("status_min");
            }
            if (statusMax != null) {
                sqlQueryObject.addWhereCondition("status_max = ?");
            } else {
                sqlQueryObject.addWhereIsNullCondition("status_max");
            }
            sqlQueryObject.addWhereCondition("fault = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int parameterIndex = 1;
            stmt.setLong(parameterIndex++, idPA);
            if (statusMin != null) {
                stmt.setInt(parameterIndex++, statusMin);
            }
            if (statusMax != null) {
                stmt.setInt(parameterIndex++, statusMax);
            }
            if (fault) {
                stmt.setInt(parameterIndex++, 1);
            } else {
                stmt.setInt(parameterIndex++, 0);
            }
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                count = risultato.getInt(1);
            }
            risultato.close();
            stmt.close();
            bl = count > 0;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return bl;
    }

    protected void readConfigurazioneCors(CorsConfigurazione configurazione, ResultSet rs) throws SQLException {
        String corsStato = rs.getString("cors_stato");
        if (corsStato != null && !"".equals(corsStato)) {
            configurazione.setStato(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(corsStato));
        }
        if (StatoFunzionalita.ABILITATO.equals(configurazione.getStato())) {
            String corsTipo = rs.getString("cors_tipo");
            if (corsTipo != null && !"".equals(corsTipo)) {
                configurazione.setTipo(DriverConfigurazioneDBLib.getEnumTipoGestioneCORS(corsTipo));
            }
            if (TipoGestioneCORS.GATEWAY.equals(configurazione.getTipo())) {
                List<String> l;
                String corsAllAllowMethods;
                String corsAllAllowHeader;
                int corsAllowMaxAge;
                String corsAllowCredentials;
                String corsAllAllowOrigins = rs.getString("cors_all_allow_origins");
                if (corsAllAllowOrigins != null && !"".equals(corsAllAllowOrigins)) {
                    configurazione.setAccessControlAllAllowOrigins(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(corsAllAllowOrigins));
                }
                if (StatoFunzionalita.DISABILITATO.equals(configurazione.getAccessControlAllAllowOrigins())) {
                    List<String> l2 = DBUtils.convertToList(rs.getString("cors_allow_origins"));
                    if (!l2.isEmpty()) {
                        configurazione.setAccessControlAllowOrigins(new CorsConfigurazioneOrigin());
                    }
                    for (String v : l2) {
                        configurazione.getAccessControlAllowOrigins().addOrigin(v);
                    }
                }
                if ((corsAllowCredentials = rs.getString("cors_allow_credentials")) != null && !"".equals(corsAllowCredentials)) {
                    configurazione.setAccessControlAllowCredentials(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(corsAllowCredentials));
                }
                if (1 == (corsAllowMaxAge = rs.getInt("cors_allow_max_age"))) {
                    int corsAllowMaxAgeSeconds = rs.getInt("cors_allow_max_age_seconds");
                    configurazione.setAccessControlMaxAge(corsAllowMaxAgeSeconds);
                }
                if ((corsAllAllowHeader = rs.getString("cors_all_allow_headers")) != null && !"".equals(corsAllAllowHeader)) {
                    configurazione.setAccessControlAllAllowHeaders(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(corsAllAllowHeader));
                }
                if (StatoFunzionalita.DISABILITATO.equals(configurazione.getAccessControlAllAllowHeaders())) {
                    List<String> l3 = DBUtils.convertToList(rs.getString("cors_allow_headers"));
                    if (!l3.isEmpty()) {
                        configurazione.setAccessControlAllowHeaders(new CorsConfigurazioneHeaders());
                    }
                    for (String v : l3) {
                        configurazione.getAccessControlAllowHeaders().addHeader(v);
                    }
                }
                if ((corsAllAllowMethods = rs.getString("cors_all_allow_methods")) != null && !"".equals(corsAllAllowMethods)) {
                    configurazione.setAccessControlAllAllowMethods(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(corsAllAllowMethods));
                }
                if (StatoFunzionalita.DISABILITATO.equals(configurazione.getAccessControlAllAllowMethods())) {
                    l = DBUtils.convertToList(rs.getString("cors_allow_methods"));
                    if (!l.isEmpty()) {
                        configurazione.setAccessControlAllowMethods(new CorsConfigurazioneMethods());
                    }
                    for (String v : l) {
                        configurazione.getAccessControlAllowMethods().addMethod(v);
                    }
                }
                if (!(l = DBUtils.convertToList(rs.getString("cors_allow_expose_headers"))).isEmpty()) {
                    configurazione.setAccessControlExposeHeaders(new CorsConfigurazioneHeaders());
                }
                for (String v : l) {
                    configurazione.getAccessControlExposeHeaders().addHeader(v);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readResponseCaching(Long idPorta, boolean config, boolean portaDelegata, ResponseCachingConfigurazione configurazione, ResultSet rs, Connection con) throws Exception {
        String responseCacheStato = rs.getString("response_cache_stato");
        if (responseCacheStato != null && !"".equals(responseCacheStato)) {
            configurazione.setStato(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(responseCacheStato));
        }
        if (StatoFunzionalita.ABILITATO.equals(configurazione.getStato())) {
            String responseCacheHashPayload;
            String responseCacheHashHeaders;
            String responseCacheHashQuery;
            long responseCacheMaxMsgBytes;
            int responseCacheSeconds = rs.getInt("response_cache_seconds");
            if (responseCacheSeconds > 0) {
                configurazione.setCacheTimeoutSeconds(responseCacheSeconds);
            }
            if ((responseCacheMaxMsgBytes = rs.getLong("response_cache_max_msg_size")) > 0L) {
                configurazione.setMaxMessageSize(responseCacheMaxMsgBytes);
            }
            configurazione.setHashGenerator(new ResponseCachingConfigurazioneHashGenerator());
            String responseCacheHashUrl = rs.getString("response_cache_hash_url");
            if (responseCacheHashUrl != null && !"".equals(responseCacheHashUrl)) {
                configurazione.getHashGenerator().setRequestUri(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(responseCacheHashUrl));
            }
            if ((responseCacheHashQuery = rs.getString("response_cache_hash_query")) != null && !"".equals(responseCacheHashQuery)) {
                configurazione.getHashGenerator().setQueryParameters(DriverConfigurazioneDBLib.getEnumStatoFunzionalitaCacheDigestQueryParameter(responseCacheHashQuery));
            }
            if (StatoFunzionalitaCacheDigestQueryParameter.SELEZIONE_PUNTUALE.equals(configurazione.getHashGenerator().getQueryParameters())) {
                List<String> l = DBUtils.convertToList(rs.getString("response_cache_hash_query_list"));
                for (String string : l) {
                    configurazione.getHashGenerator().addQueryParameter(string);
                }
            }
            if ((responseCacheHashHeaders = rs.getString("response_cache_hash_headers")) != null && !"".equals(responseCacheHashHeaders)) {
                configurazione.getHashGenerator().setHeaders(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(responseCacheHashHeaders));
            }
            if (StatoFunzionalita.ABILITATO.equals(configurazione.getHashGenerator().getHeaders())) {
                List<String> l = DBUtils.convertToList(rs.getString("response_cache_hash_hdr_list"));
                for (String v : l) {
                    configurazione.getHashGenerator().addHeader(v);
                }
            }
            if ((responseCacheHashPayload = rs.getString("response_cache_hash_payload")) != null && !"".equals(responseCacheHashPayload)) {
                configurazione.getHashGenerator().setPayload(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(responseCacheHashPayload));
            }
            configurazione.setControl(new ResponseCachingConfigurazioneControl());
            int n = rs.getInt("response_cache_control_nocache");
            if (1 == n) {
                configurazione.getControl().setNoCache(true);
            } else if (0 == n) {
                configurazione.getControl().setNoCache(false);
            }
            int responseCacheControlMaxAge = rs.getInt("response_cache_control_maxage");
            if (1 == responseCacheControlMaxAge) {
                configurazione.getControl().setMaxAge(true);
            } else if (0 == responseCacheControlMaxAge) {
                configurazione.getControl().setMaxAge(false);
            }
            int responseCacheControlNoStore = rs.getInt("response_cache_control_nostore");
            if (1 == responseCacheControlNoStore) {
                configurazione.getControl().setNoStore(true);
            } else if (0 == responseCacheControlNoStore) {
                configurazione.getControl().setNoStore(false);
            }
            PreparedStatement stmRegole = null;
            ResultSet rsRegole = null;
            try {
                String nomeTabella = null;
                nomeTabella = config ? "config_cache_regole" : (portaDelegata ? "pd_cache_regole" : "pa_cache_regole");
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable(nomeTabella);
                sqlQueryObject.addSelectField("*");
                if (!config) {
                    sqlQueryObject.addWhereCondition("id_porta=?");
                }
                String sqlQuery = sqlQueryObject.createSQLQuery();
                stmRegole = con.prepareStatement(sqlQuery);
                if (!config) {
                    stmRegole.setLong(1, idPorta);
                }
                this.driver.logDebug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idPorta));
                rsRegole = stmRegole.executeQuery();
                while (rsRegole.next()) {
                    int fault;
                    ResponseCachingConfigurazioneRegola regola = new ResponseCachingConfigurazioneRegola();
                    regola.setId(rsRegole.getLong("id"));
                    int statusMin = rsRegole.getInt("status_min");
                    int statusMax = rsRegole.getInt("status_max");
                    if (statusMin > 0) {
                        regola.setReturnCodeMin(statusMin);
                    }
                    if (statusMax > 0) {
                        regola.setReturnCodeMax(statusMax);
                    }
                    if (1 == (fault = rsRegole.getInt("fault"))) {
                        regola.setFault(true);
                    } else if (0 == fault) {
                        regola.setFault(false);
                    }
                    int cacheSeconds = rsRegole.getInt("cache_seconds");
                    if (cacheSeconds > 0) {
                        regola.setCacheTimeoutSeconds(cacheSeconds);
                    }
                    configurazione.addRegola(regola);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rsRegole, stmRegole);
                throw throwable;
            }
            JDBCUtilities.closeResources((ResultSet)rsRegole, (PreparedStatement)stmRegole);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateProprietaOggetto(String nome, String user, String tabella) throws DriverConfigurazioneException {
        String nomeMetodo = "updateProprietaOggetto_" + tabella;
        Connection con = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        PreparedStatement stm = null;
        try {
            ISQLQueryObject sqlQueryObjectUpdate = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObjectUpdate.addUpdateTable(tabella);
            sqlQueryObjectUpdate.addUpdateField("utente_ultima_modifica", "?");
            sqlQueryObjectUpdate.addUpdateField("data_ultima_modifica", "?");
            sqlQueryObjectUpdate.addWhereCondition("nome_porta=?");
            String updateString = sqlQueryObjectUpdate.createSQLUpdate();
            stm = con.prepareStatement(updateString);
            int index = 1;
            stm.setString(index++, user);
            stm.setTimestamp(index++, DateManager.getTimestamp());
            stm.setString(index, nome);
            int n = stm.executeUpdate();
            stm.close();
            this.driver.logDebug("Aggiornata " + n + " entry per l'operazione di ultima modifica della tabella '" + tabella + "' con nome: " + nome);
        }
        catch (SQLException e) {
            try {
                this.driver.logError("Errore SQL", e);
                throw new DriverConfigurazioneException(e);
                catch (Exception e2) {
                    this.driver.logError("Errore", e2);
                    throw new DriverConfigurazioneException(e2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((PreparedStatement)stm);
        this.driver.closeConnection(con);
    }
}

